import pandas as pd
import numpy as np

# matrix AST in FKM guideline nonlinear on page 162, chapter 3.4.1
expected_matrix_AST_162 = pd.DataFrame(
    index=pd.Index(np.arange(1, 200+1), name="class_index"),
    columns=["delta_load", "delta_strain", "delta_stress"],
    data=[
        [3.592, 0.0017e-2, 3.592],
        [7.185, 0.0035e-2, 7.185],
        [10.777, 0.0052e-2, 10.777],
        [14.370, 0.0070e-2, 14.370],
        [17.962, 0.0087e-2, 17.962],
        [21.554, 0.0105e-2, 21.554],
        [25.147, 0.0122e-2, 25.147],
        [28.739, 0.0140e-2, 28.739],
        [32.332, 0.0157e-2, 32.332],
        [35.924, 0.0174e-2, 35.924],
        [39.516, 0.0192e-2, 39.516],
        [43.109, 0.0209e-2, 43.109],
        [46.701, 0.0227e-2, 46.701],
        [50.294, 0.0244e-2, 50.293],
        [53.886, 0.0262e-2, 53.886],
        [57.478, 0.0279e-2, 57.478],
        [61.071, 0.0296e-2, 61.070],
        [64.663, 0.0314e-2, 64.662],
        [68.256, 0.0331e-2, 68.254],
        [71.848, 0.0349e-2, 71.846],
        [75.440, 0.0366e-2, 75.438],
        [79.033, 0.0384e-2, 79.030],
        [82.625, 0.0401e-2, 82.622],
        [86.218, 0.0419e-2, 86.213],
        [89.810, 0.0436e-2, 89.805],
        [93.402, 0.0453e-2, 93.396],
        [96.995, 0.0471e-2, 96.987],
        [100.587, 0.0488e-2, 100.578],
        [104.180, 0.0506e-2, 104.168],
        [107.772, 0.0523e-2, 107.758],
        [111.364, 0.0541e-2, 111.348],
        [114.957, 0.0558e-2, 114.938],
        [118.549, 0.0576e-2, 118.526],
        [122.142, 0.0593e-2, 122.115],
        [125.734, 0.0611e-2, 125.703],
        [129.326, 0.0628e-2, 129.290],
        [132.919, 0.0645e-2, 132.877],
        [136.511, 0.0663e-2, 136.463],
        [140.104, 0.0680e-2, 140.048],
        [143.696, 0.0698e-2, 143.633],
        [147.288, 0.0715e-2, 147.216],
        [150.881, 0.0733e-2, 150.799],
        [154.473, 0.0750e-2, 154.380],
        [158.066, 0.0768e-2, 157.960],
        [161.658, 0.0785e-2, 161.539],
        [165.250, 0.0803e-2, 165.117],
        [168.843, 0.0820e-2, 168.693],
        [172.435, 0.0838e-2, 172.268],
        [176.028, 0.0855e-2, 175.841],
        [179.620, 0.0873e-2, 179.412],
        [183.212, 0.0891e-2, 182.981],
        [186.805, 0.0908e-2, 186.548],
        [190.397, 0.0926e-2, 190.113],
        [193.990, 0.0943e-2, 193.676],
        [197.582, 0.0961e-2, 197.236],
        [201.174, 0.0978e-2, 200.794],
        [204.767, 0.0996e-2, 204.349],
        [208.359, 0.1014e-2, 207.901],
        [211.952, 0.1031e-2, 211.450],
        [215.544, 0.1049e-2, 214.996],
        [219.136, 0.1067e-2, 218.539],
        [222.729, 0.1084e-2, 222.078],
        [226.321, 0.1102e-2, 225.613],
        [229.914, 0.1120e-2, 229.144],
        [233.506, 0.1138e-2, 232.671],
        [237.098, 0.1155e-2, 236.193],
        [240.691, 0.1173e-2, 239.711],
        [244.283, 0.1191e-2, 243.225],
        [247.876, 0.1209e-2, 246.733],
        [251.468, 0.1227e-2, 250.236],
        [255.060, 0.1245e-2, 253.734],
        [258.653, 0.1263e-2, 257.226],
        [262.245, 0.1281e-2, 260.712],
        [265.838, 0.1299e-2, 264.192],
        [269.430, 0.1317e-2, 267.666],
        [273.022, 0.1335e-2, 271.133],
        [276.615, 0.1353e-2, 274.593],
        [280.207, 0.1371e-2, 278.046],
        [283.800, 0.1389e-2, 281.492],
        [287.392, 0.1407e-2, 284.930],
        [290.984, 0.1426e-2, 288.361],
        [294.577, 0.1444e-2, 291.783],
        [298.169, 0.1462e-2, 295.197],
        [301.762, 0.1481e-2, 298.602],
        [305.354, 0.1499e-2, 301.998],
        [308.946, 0.1517e-2, 305.386],
        [312.539, 0.1536e-2, 308.763],
        [316.131, 0.1554e-2, 312.132],
        [319.724, 0.1573e-2, 315.490],
        [323.316, 0.1592e-2, 318.838],
        [326.908, 0.1610e-2, 322.175],
        [330.501, 0.1629e-2, 325.502],
        [334.093, 0.1648e-2, 328.818],
        [337.686, 0.1667e-2, 332.123],
        [341.278, 0.1686e-2, 335.416],
        [344.870, 0.1705e-2, 338.698],
        [348.463, 0.1724e-2, 341.967],
        [352.055, 0.1743e-2, 345.225],
        [355.648, 0.1762e-2, 348.470],
        [359.240, 0.1782e-2, 351.702],
        [362.832, 0.1801e-2, 354.922],
        [366.425, 0.1820e-2, 358.128],
        [370.017, 0.1840e-2, 361.321],
        [373.610, 0.1859e-2, 364.501],
        [377.202, 0.1879e-2, 367.667],
        [380.794, 0.1899e-2, 370.819],
        [384.387, 0.1919e-2, 373.957],
        [387.979, 0.1938e-2, 377.081],
        [391.572, 0.1958e-2, 380.190],
        [395.164, 0.1978e-2, 383.285],
        [398.756, 0.1998e-2, 386.365],
        [402.349, 0.2019e-2, 389.430],
        [405.941, 0.2039e-2, 392.480],
        [409.534, 0.2059e-2, 395.515],
        [413.126, 0.2080e-2, 398.534],
        [416.718, 0.2100e-2, 401.538],
        [420.311, 0.2121e-2, 404.526],
        [423.903, 0.2142e-2, 407.499],
        [427.496, 0.2162e-2, 410.456],
        [431.088, 0.2183e-2, 413.397],
        [434.680, 0.2204e-2, 416.322],
        [438.273, 0.2225e-2, 419.231],
        [441.865, 0.2246e-2, 422.124],
        [445.458, 0.2268e-2, 425.001],
        [449.050, 0.2289e-2, 427.862],
        [452.642, 0.2311e-2, 430.706],
        [456.235, 0.2332e-2, 433.534],
        [459.827, 0.2354e-2, 436.346],
        [463.420, 0.2375e-2, 439.142],
        [467.012, 0.2397e-2, 441.921],
        [470.604, 0.2419e-2, 444.683],
        [474.197, 0.2441e-2, 447.430],
        [477.789, 0.2463e-2, 450.159],
        [481.382, 0.2486e-2, 452.873],
        [484.974, 0.2508e-2, 455.570],
        [488.566, 0.2531e-2, 458.251],
        [492.159, 0.2553e-2, 460.915],
        [495.751, 0.2576e-2, 463.563],
        [499.344, 0.2599e-2, 466.195],
        [502.936, 0.2621e-2, 468.811],
        [506.528, 0.2644e-2, 471.411],
        [510.121, 0.2668e-2, 473.994],
        [513.713, 0.2691e-2, 476.561],
        [517.306, 0.2714e-2, 479.113],
        [520.898, 0.2738e-2, 481.648],
        [524.490, 0.2761e-2, 484.168],
        [528.083, 0.2785e-2, 486.672],
        [531.675, 0.2808e-2, 489.160],
        [535.268, 0.2832e-2, 491.632],
        [538.860, 0.2856e-2, 494.089],
        [542.452, 0.2880e-2, 496.531],
        [546.045, 0.2905e-2, 498.957],
        [549.637, 0.2929e-2, 501.368],
        [553.230, 0.2953e-2, 503.763],
        [556.822, 0.2978e-2, 506.144],
        [560.414, 0.3002e-2, 508.510],
        [564.007, 0.3027e-2, 510.860],
        [567.599, 0.3052e-2, 513.196],
        [571.192, 0.3077e-2, 515.518],
        [574.784, 0.3102e-2, 517.824],
        [578.376, 0.3127e-2, 520.117],
        [581.969, 0.3153e-2, 522.395],
        [585.561, 0.3178e-2, 524.658],
        [589.154, 0.3203e-2, 526.908],
        [592.746, 0.3229e-2, 529.144],
        [596.338, 0.3255e-2, 531.365],
        [599.931, 0.3281e-2, 533.573],
        [603.523, 0.3307e-2, 535.768],
        [607.116, 0.3333e-2, 537.948],
        [610.708, 0.3359e-2, 540.116],
        [614.300, 0.3385e-2, 542.270],
        [617.893, 0.3412e-2, 544.411],
        [621.485, 0.3438e-2, 546.539],
        [625.078, 0.3465e-2, 548.654],
        [628.670, 0.3492e-2, 550.756],
        [632.262, 0.3519e-2, 552.845],
        [635.855, 0.3546e-2, 554.922],
        [639.447, 0.3573e-2, 556.986],
        [643.040, 0.3600e-2, 559.038],
        [646.632, 0.3627e-2, 561.078],
        [650.224, 0.3655e-2, 563.106],
        [653.817, 0.3682e-2, 565.122],
        [657.409, 0.3710e-2, 567.126],
        [661.002, 0.3738e-2, 569.118],
        [664.594, 0.3766e-2, 571.098],
        [668.186, 0.3794e-2, 573.067],
        [671.779, 0.3822e-2, 575.025],
        [675.371, 0.3850e-2, 576.971],
        [678.964, 0.3878e-2, 578.906],
        [682.556, 0.3907e-2, 580.830],
        [686.148, 0.3935e-2, 582.744],
        [689.741, 0.3964e-2, 584.646],
        [693.333, 0.3993e-2, 586.537],
        [696.926, 0.4022e-2, 588.418],
        [700.518, 0.4051e-2, 590.289],
        [704.110, 0.4080e-2, 592.149],
        [707.703, 0.4109e-2, 593.999],
        [711.295, 0.4138e-2, 595.839],
        [714.888, 0.4168e-2, 597.668],
        [718.480, 0.4198e-2, 599.488]
    ]
)

# matrix AST on page 171, chapter 3.4.2
expected_matrix_AST_171 = pd.DataFrame(
    index=pd.Index(np.arange(1, 200+1), name="class_index"),
    columns=["delta_load", "delta_strain", "delta_stress"],
    data=[
        [10.13, 0.0049e-2, 10.130],
        [20.26, 0.0098e-2, 20.260],
        [30.39, 0.0148e-2, 30.390],
        [40.52, 0.0197e-2, 40.520],
        [50.65, 0.0246e-2, 50.650],
        [60.78, 0.0295e-2, 60.780],
        [70.91, 0.0344e-2, 70.910],
        [81.04, 0.0393e-2, 81.040],
        [91.17, 0.0443e-2, 91.170],
        [101.30, 0.0492e-2, 101.300],
        [111.43, 0.0541e-2, 111.430],
        [121.56, 0.0590e-2, 121.560],
        [131.69, 0.0639e-2, 131.689],
        [141.82, 0.0688e-2, 141.819],
        [151.95, 0.0738e-2, 151.949],
        [162.08, 0.0787e-2, 162.078],
        [172.21, 0.0836e-2, 172.208],
        [182.34, 0.0885e-2, 182.337],
        [192.47, 0.0934e-2, 192.466],
        [202.60, 0.0984e-2, 202.595],
        [212.73, 0.1033e-2, 212.723],
        [222.86, 0.1082e-2, 222.851],
        [232.99, 0.1131e-2, 232.979],
        [243.12, 0.1180e-2, 243.106],
        [253.25, 0.1229e-2, 253.232],
        [263.38, 0.1279e-2, 263.358],
        [273.51, 0.1328e-2, 273.483],
        [283.64, 0.1377e-2, 283.608],
        [293.77, 0.1426e-2, 293.731],
        [303.90, 0.1475e-2, 303.853],
        [314.03, 0.1525e-2, 313.974],
        [324.16, 0.1574e-2, 324.094],
        [334.29, 0.1623e-2, 334.212],
        [344.42, 0.1672e-2, 344.328],
        [354.55, 0.1722e-2, 354.443],
        [364.68, 0.1771e-2, 364.556],
        [374.81, 0.1820e-2, 374.666],
        [384.94, 0.1869e-2, 384.774],
        [395.07, 0.1919e-2, 394.879],
        [405.20, 0.1968e-2, 404.982],
        [415.33, 0.2017e-2, 415.081],
        [425.46, 0.2067e-2, 425.177],
        [435.59, 0.2116e-2, 435.269],
        [445.72, 0.2165e-2, 445.357],
        [455.85, 0.2215e-2, 455.441],
        [465.98, 0.2264e-2, 465.520],
        [476.11, 0.2314e-2, 475.595],
        [486.24, 0.2363e-2, 485.664],
        [496.37, 0.2413e-2, 495.727],
        [506.50, 0.2462e-2, 505.784],
        [516.63, 0.2512e-2, 515.834],
        [526.76, 0.2561e-2, 525.878],
        [536.89, 0.2611e-2, 535.914],
        [547.02, 0.2661e-2, 545.943],
        [557.15, 0.2710e-2, 555.963],
        [567.28, 0.2760e-2, 565.974],
        [577.41, 0.2810e-2, 575.976],
        [587.54, 0.2860e-2, 585.968],
        [597.67, 0.2910e-2, 595.949],
        [607.80, 0.2960e-2, 605.920],
        [617.93, 0.3010e-2, 615.879],
        [628.06, 0.3060e-2, 625.826],
        [638.19, 0.3110e-2, 635.760],
        [648.32, 0.3160e-2, 645.680],
        [658.45, 0.3210e-2, 655.587],
        [668.58, 0.3261e-2, 665.479],
        [678.71, 0.3311e-2, 675.355],
        [688.84, 0.3362e-2, 685.215],
        [698.97, 0.3412e-2, 695.059],
        [709.10, 0.3463e-2, 704.885],
        [719.23, 0.3514e-2, 714.692],
        [729.36, 0.3565e-2, 724.481],
        [739.49, 0.3616e-2, 734.250],
        [749.62, 0.3667e-2, 743.998],
        [759.75, 0.3718e-2, 753.725],
        [769.88, 0.3769e-2, 763.430],
        [780.01, 0.3821e-2, 773.112],
        [790.14, 0.3872e-2, 782.770],
        [800.27, 0.3924e-2, 792.404],
        [810.40, 0.3975e-2, 802.013],
        [820.53, 0.4027e-2, 811.595],
        [830.66, 0.4079e-2, 821.151],
        [840.79, 0.4132e-2, 830.679],
        [850.92, 0.4184e-2, 840.179],
        [861.05, 0.4236e-2, 849.649],
        [871.18, 0.4289e-2, 859.089],
        [881.31, 0.4342e-2, 868.499],
        [891.44, 0.4395e-2, 877.876],
        [901.57, 0.4448e-2, 887.221],
        [911.70, 0.4501e-2, 896.533],
        [921.83, 0.4555e-2, 905.811],
        [931.96, 0.4608e-2, 915.055],
        [942.09, 0.4662e-2, 924.263],
        [952.22, 0.4716e-2, 933.434],
        [962.35, 0.4771e-2, 942.569],
        [972.48, 0.4825e-2, 951.666],
        [982.61, 0.4880e-2, 960.725],
        [992.74, 0.4935e-2, 969.745],
        [1002.87, 0.4990e-2, 978.725],
        [1013.00, 0.5045e-2, 987.665],
        [1023.13, 0.5100e-2, 996.564],
        [1033.26, 0.5156e-2, 1005.422],
        [1043.39, 0.5212e-2, 1014.237],
        [1053.52, 0.5268e-2, 1023.011],
        [1063.65, 0.5325e-2, 1031.741],
        [1073.78, 0.5381e-2, 1040.427],
        [1083.91, 0.5438e-2, 1049.070],
        [1094.04, 0.5495e-2, 1057.668],
        [1104.17, 0.5553e-2, 1066.221],
        [1114.30, 0.5611e-2, 1074.729],
        [1124.43, 0.5668e-2, 1083.191],
        [1134.56, 0.5727e-2, 1091.607],
        [1144.69, 0.5785e-2, 1099.977],
        [1154.82, 0.5844e-2, 1108.300],
        [1164.95, 0.5903e-2, 1116.576],
        [1175.08, 0.5962e-2, 1124.805],
        [1185.21, 0.6022e-2, 1132.987],
        [1195.34, 0.6081e-2, 1141.121],
        [1205.47, 0.6142e-2, 1149.207],
        [1215.60, 0.6202e-2, 1157.245],
        [1225.73, 0.6263e-2, 1165.235],
        [1235.86, 0.6324e-2, 1173.177],
        [1245.99, 0.6385e-2, 1181.070],
        [1256.12, 0.6446e-2, 1188.916],
        [1266.25, 0.6508e-2, 1196.712],
        [1276.38, 0.6570e-2, 1204.461],
        [1286.51, 0.6633e-2, 1212.161],
        [1296.64, 0.6696e-2, 1219.813],
        [1306.77, 0.6759e-2, 1227.416],
        [1316.90, 0.6822e-2, 1234.971],
        [1327.03, 0.6886e-2, 1242.478],
        [1337.16, 0.6950e-2, 1249.937],
        [1347.29, 0.7014e-2, 1257.348],
        [1357.42, 0.7079e-2, 1264.711],
        [1367.55, 0.7144e-2, 1272.027],
        [1377.68, 0.7209e-2, 1279.295],
        [1387.81, 0.7275e-2, 1286.515],
        [1397.94, 0.7340e-2, 1293.689],
        [1408.07, 0.7407e-2, 1300.816],
        [1418.20, 0.7473e-2, 1307.895],
        [1428.33, 0.7540e-2, 1314.929],
        [1438.46, 0.7607e-2, 1321.916],
        [1448.59, 0.7675e-2, 1328.857],
        [1458.72, 0.7743e-2, 1335.753],
        [1468.85, 0.7811e-2, 1342.603],
        [1478.98, 0.7879e-2, 1349.408],
        [1489.11, 0.7948e-2, 1356.168],
        [1499.24, 0.8017e-2, 1362.884],
        [1509.37, 0.8087e-2, 1369.555],
        [1519.50, 0.8156e-2, 1376.182],
        [1529.63, 0.8226e-2, 1382.766],
        [1539.76, 0.8297e-2, 1389.307],
        [1549.89, 0.8368e-2, 1395.804],
        [1560.02, 0.8439e-2, 1402.259],
        [1570.15, 0.8510e-2, 1408.672],
        [1580.28, 0.8582e-2, 1415.043],
        [1590.41, 0.8654e-2, 1421.372],
        [1600.54, 0.8726e-2, 1427.660],
        [1610.67, 0.8799e-2, 1433.908],
        [1620.80, 0.8872e-2, 1440.114],
        [1630.93, 0.8946e-2, 1446.281],
        [1641.06, 0.9019e-2, 1452.408],
        [1651.19, 0.9094e-2, 1458.496],
        [1661.32, 0.9168e-2, 1464.544],
        [1671.45, 0.9243e-2, 1470.554],
        [1681.58, 0.9318e-2, 1476.526],
        [1691.71, 0.9393e-2, 1482.459],
        [1701.84, 0.9469e-2, 1488.356],
        [1711.97, 0.9545e-2, 1494.215],
        [1722.10, 0.9621e-2, 1500.037],
        [1732.23, 0.9698e-2, 1505.823],
        [1742.36, 0.9775e-2, 1511.572],
        [1752.49, 0.9853e-2, 1517.286],
        [1762.62, 0.9931e-2, 1522.965],
        [1772.75, 1.0009e-2, 1528.609],
        [1782.88, 1.0087e-2, 1534.218],
        [1793.01, 1.0166e-2, 1539.793],
        [1803.14, 1.0245e-2, 1545.334],
        [1813.27, 1.0324e-2, 1550.841],
        [1823.40, 1.0404e-2, 1556.316],
        [1833.53, 1.0484e-2, 1561.757],
        [1843.66, 1.0565e-2, 1567.166],
        [1853.79, 1.0645e-2, 1572.543],
        [1863.92, 1.0726e-2, 1577.888],
        [1874.05, 1.0808e-2, 1583.202],
        [1884.18, 1.0890e-2, 1588.485],
        [1894.31, 1.0972e-2, 1593.737],
        [1904.44, 1.1054e-2, 1598.958],
        [1914.57, 1.1137e-2, 1604.149],
        [1924.70, 1.1220e-2, 1609.311],
        [1934.83, 1.1303e-2, 1614.443],
        [1944.96, 1.1387e-2, 1619.547],
        [1955.09, 1.1471e-2, 1624.621],
        [1965.22, 1.1556e-2, 1629.667],
        [1975.35, 1.1641e-2, 1634.685],
        [1985.48, 1.1726e-2, 1639.675],
        [1995.61, 1.1811e-2, 1644.637],
        [2005.74, 1.1897e-2, 1649.573],
        [2015.87, 1.1983e-2, 1654.481],
        [2026.00, 1.2069e-2, 1659.363]
    ]
)

# matrix AST on page 180, chapter 3.5.1
expected_matrix_AST_180_seeger_beste = pd.DataFrame(
    index=pd.Index(np.arange(1, 200+1), name="class_index"),
    columns=["delta_load", "delta_strain", "delta_stress"],
    data=[
        [3.59, 1.7e-05, 3.592],
        [7.18, 3.5e-05, 7.185],
        [10.78, 5.2e-05, 10.777],
        [14.37, 7e-05, 14.37],
        [17.96, 8.7e-05, 17.961],
        [21.55, 0.000105, 21.554],
        [25.15, 0.000122, 25.147],
        [28.74, 0.00014, 28.739],
        [32.33, 0.000157, 32.331],
        [35.92, 0.000174, 35.924],
        [39.52, 0.000192, 39.517],
        [43.11, 0.000209, 43.108],
        [46.7, 0.000227, 46.701],
        [50.29, 0.000244, 50.294],
        [53.89, 0.000262, 53.885],
        [57.48, 0.000279, 57.477],
        [61.07, 0.000296, 61.07],
        [64.66, 0.000314, 64.661],
        [68.26, 0.000331, 68.253],
        [71.85, 0.000349, 71.845],
        [75.44, 0.000366, 75.436],
        [79.03, 0.000384, 79.028],
        [82.63, 0.000401, 82.619],
        [86.22, 0.000419, 86.209],
        [89.81, 0.000436, 89.8],
        [93.4, 0.000453, 93.39],
        [96.99, 0.000471, 96.979],
        [100.59, 0.000488, 100.568],
        [104.18, 0.000506, 104.157],
        [107.77, 0.000523, 107.745],
        [111.36, 0.000541, 111.332],
        [114.96, 0.000558, 114.918],
        [118.55, 0.000575, 118.504],
        [122.14, 0.000593, 122.088],
        [125.73, 0.00061, 125.672],
        [129.33, 0.000628, 129.254],
        [132.92, 0.000645, 132.835],
        [136.51, 0.000663, 136.415],
        [140.1, 0.00068, 139.993],
        [143.7, 0.000698, 143.57],
        [147.29, 0.000715, 147.144],
        [150.88, 0.000732, 150.717],
        [154.47, 0.00075, 154.287],
        [158.07, 0.000767, 157.856],
        [161.66, 0.000785, 161.421],
        [165.25, 0.000802, 164.985],
        [168.84, 0.00082, 168.545],
        [172.44, 0.000837, 172.102],
        [176.03, 0.000855, 175.656],
        [179.62, 0.000872, 179.207],
        [183.21, 0.000889, 182.754],
        [186.8, 0.000907, 186.297],
        [190.4, 0.000924, 189.835],
        [193.99, 0.000942, 193.37],
        [197.58, 0.000959, 196.899],
        [201.17, 0.000977, 200.424],
        [204.77, 0.000994, 203.943],
        [208.36, 0.001011, 207.457],
        [211.95, 0.001029, 210.965],
        [215.54, 0.001046, 214.467],
        [219.14, 0.001064, 217.963],
        [222.73, 0.001081, 221.452],
        [226.32, 0.001099, 224.934],
        [229.91, 0.001116, 228.408],
        [233.51, 0.001134, 231.875],
        [237.1, 0.001151, 235.334],
        [240.69, 0.001169, 238.785],
        [244.28, 0.001186, 242.227],
        [247.88, 0.001203, 245.66],
        [251.47, 0.001221, 249.083],
        [255.06, 0.001238, 252.497],
        [258.65, 0.001256, 255.901],
        [262.25, 0.001273, 259.295],
        [265.84, 0.001291, 262.678],
        [269.43, 0.001308, 266.049],
        [273.02, 0.001326, 269.41],
        [276.61, 0.001343, 272.758],
        [280.21, 0.001361, 276.095],
        [283.8, 0.001378, 279.419],
        [287.39, 0.001396, 282.731],
        [290.98, 0.001413, 286.03],
        [294.58, 0.001431, 289.315],
        [298.17, 0.001448, 292.587],
        [301.76, 0.001466, 295.844],
        [305.35, 0.001483, 299.088],
        [308.95, 0.001501, 302.317],
        [312.54, 0.001518, 305.531],
        [316.13, 0.001536, 308.73],
        [319.72, 0.001553, 311.914],
        [323.32, 0.001571, 315.082],
        [326.91, 0.001588, 318.235],
        [330.5, 0.001606, 321.372],
        [334.09, 0.001624, 324.492],
        [337.69, 0.001641, 327.596],
        [341.28, 0.001659, 330.683],
        [344.87, 0.001676, 333.754],
        [348.46, 0.001694, 336.808],
        [352.06, 0.001712, 339.844],
        [355.65, 0.001729, 342.864],
        [359.24, 0.001747, 345.866],
        [362.83, 0.001765, 348.85],
        [366.42, 0.001782, 351.817],
        [370.02, 0.0018, 354.766],
        [373.61, 0.001818, 357.698],
        [377.2, 0.001836, 360.612],
        [380.79, 0.001853, 363.507],
        [384.39, 0.001871, 366.385],
        [387.98, 0.001889, 369.245],
        [391.57, 0.001907, 372.087],
        [395.16, 0.001925, 374.91],
        [398.76, 0.001942, 377.716],
        [402.35, 0.00196, 380.504],
        [405.94, 0.001978, 383.274],
        [409.53, 0.001996, 386.025],
        [413.13, 0.002014, 388.759],
        [416.72, 0.002032, 391.475],
        [420.31, 0.00205, 394.173],
        [423.9, 0.002068, 396.853],
        [427.5, 0.002086, 399.515],
        [431.09, 0.002104, 402.16],
        [434.68, 0.002123, 404.787],
        [438.27, 0.002141, 407.397],
        [441.87, 0.002159, 409.989],
        [445.46, 0.002177, 412.564],
        [449.05, 0.002196, 415.121],
        [452.64, 0.002214, 417.662],
        [456.23, 0.002232, 420.185],
        [459.83, 0.002251, 422.691],
        [463.42, 0.002269, 425.181],
        [467.01, 0.002287, 427.654],
        [470.6, 0.002306, 430.111],
        [474.2, 0.002325, 432.551],
        [477.79, 0.002343, 434.974],
        [481.38, 0.002362, 437.382],
        [484.97, 0.00238, 439.774],
        [488.57, 0.002399, 442.149],
        [492.16, 0.002418, 444.509],
        [495.75, 0.002437, 446.854],
        [499.34, 0.002456, 449.183],
        [502.94, 0.002474, 451.496],
        [506.53, 0.002493, 453.795],
        [510.12, 0.002512, 456.078],
        [513.71, 0.002531, 458.347],
        [517.31, 0.00255, 460.601],
        [520.9, 0.00257, 462.84],
        [524.49, 0.002589, 465.065],
        [528.08, 0.002608, 467.276],
        [531.68, 0.002627, 469.473],
        [535.27, 0.002647, 471.655],
        [538.86, 0.002666, 473.824],
        [542.45, 0.002685, 475.98],
        [546.04, 0.002705, 478.121],
        [549.64, 0.002725, 480.25],
        [553.23, 0.002744, 482.365],
        [556.82, 0.002764, 484.467],
        [560.41, 0.002784, 486.556],
        [564.01, 0.002803, 488.633],
        [567.6, 0.002823, 490.697],
        [571.19, 0.002843, 492.748],
        [574.78, 0.002863, 494.787],
        [578.38, 0.002883, 496.814],
        [581.97, 0.002903, 498.829],
        [585.56, 0.002923, 500.832],
        [589.15, 0.002944, 502.823],
        [592.75, 0.002964, 504.802],
        [596.34, 0.002984, 506.77],
        [599.93, 0.003005, 508.727],
        [603.52, 0.003025, 510.672],
        [607.12, 0.003046, 512.607],
        [610.71, 0.003066, 514.53],
        [614.3, 0.003087, 516.443],
        [617.89, 0.003108, 518.344],
        [621.49, 0.003129, 520.236],
        [625.08, 0.003149, 522.117],
        [628.67, 0.00317, 523.987],
        [632.26, 0.003191, 525.847],
        [635.85, 0.003213, 527.698],
        [639.45, 0.003234, 529.538],
        [643.04, 0.003255, 531.368],
        [646.63, 0.003276, 533.189],
        [650.22, 0.003298, 535.0],
        [653.82, 0.003319, 536.801],
        [657.41, 0.003341, 538.594],
        [661.0, 0.003362, 540.377],
        [664.59, 0.003384, 542.15],
        [668.19, 0.003406, 543.915],
        [671.78, 0.003427, 545.671],
        [675.37, 0.003449, 547.418],
        [678.96, 0.003471, 549.156],
        [682.56, 0.003493, 550.885],
        [686.15, 0.003515, 552.606],
        [689.74, 0.003538, 554.319],
        [693.33, 0.00356, 556.023],
        [696.93, 0.003582, 557.719],
        [700.52, 0.003605, 559.407],
        [704.11, 0.003627, 561.086],
        [707.7, 0.00365, 562.758],
        [711.3, 0.003673, 564.422],
        [714.89, 0.003695, 566.078],
        [718.48, 0.003718, 567.727]
    ]
)

# matrix AST on page 189, chapter 3.5.2
expected_matrix_AST_189_seeger_beste = pd.DataFrame(
    index=pd.Index(np.arange(1, 200+1), name="class_index"),
    columns=["delta_load", "delta_strain", "delta_stress"],
    data=[
        [10.13, 4.9e-05, 10.13],
        [20.26, 9.8e-05, 20.26],
        [30.39, 0.000148, 30.39],
        [40.52, 0.000197, 40.52],
        [50.65, 0.000246, 50.65],
        [60.78, 0.000295, 60.78],
        [70.91, 0.000344, 70.91],
        [81.04, 0.000393, 81.04],
        [91.17, 0.000443, 91.169],
        [101.3, 0.000492, 101.3],
        [111.43, 0.000541, 111.429],
        [121.56, 0.00059, 121.56],
        [131.69, 0.000639, 131.69],
        [141.82, 0.000688, 141.814],
        [151.95, 0.000738, 151.948],
        [162.08, 0.000787, 162.077],
        [172.21, 0.000836, 172.206],
        [182.34, 0.000885, 182.334],
        [192.47, 0.000934, 192.462],
        [202.6, 0.000983, 202.589],
        [212.73, 0.001033, 212.716],
        [222.86, 0.001082, 222.842],
        [232.99, 0.001131, 232.967],
        [243.12, 0.00118, 243.092],
        [253.25, 0.001229, 253.215],
        [263.38, 0.001279, 263.336],
        [273.51, 0.001328, 273.457],
        [283.64, 0.001377, 283.575],
        [293.77, 0.001426, 293.692],
        [303.9, 0.001475, 303.806],
        [314.03, 0.001524, 313.918],
        [324.16, 0.001574, 324.028],
        [334.29, 0.001623, 334.134],
        [344.42, 0.001672, 344.237],
        [354.55, 0.001721, 354.336],
        [364.68, 0.00177, 364.432],
        [374.81, 0.001819, 374.523],
        [384.94, 0.001869, 384.609],
        [395.07, 0.001918, 394.69],
        [405.2, 0.001967, 404.765],
        [415.33, 0.002016, 414.834],
        [425.46, 0.002065, 424.896],
        [435.59, 0.002115, 434.951],
        [445.72, 0.002164, 444.998],
        [455.85, 0.002213, 455.037],
        [465.98, 0.002262, 465.067],
        [476.11, 0.002311, 475.087],
        [486.24, 0.00236, 485.096],
        [496.37, 0.00241, 495.095],
        [506.5, 0.002459, 505.082],
        [516.63, 0.002508, 515.056],
        [526.76, 0.002557, 525.016],
        [536.89, 0.002606, 534.963],
        [547.02, 0.002656, 544.894],
        [557.15, 0.002705, 554.81],
        [567.28, 0.002754, 564.709],
        [577.41, 0.002803, 574.59],
        [587.54, 0.002852, 584.452],
        [597.67, 0.002901, 594.295],
        [607.8, 0.002951, 604.118],
        [617.93, 0.003, 613.919],
        [628.06, 0.003049, 623.697],
        [638.19, 0.003098, 633.452],
        [648.32, 0.003148, 643.183],
        [658.45, 0.003197, 652.888],
        [668.58, 0.003246, 662.566],
        [678.71, 0.003295, 672.217],
        [688.84, 0.003344, 681.838],
        [698.97, 0.003394, 691.43],
        [709.1, 0.003443, 700.992],
        [719.23, 0.003492, 710.521],
        [729.36, 0.003541, 720.018],
        [739.49, 0.003591, 729.48],
        [749.62, 0.00364, 738.907],
        [759.75, 0.003689, 748.299],
        [769.88, 0.003739, 757.653],
        [780.01, 0.003788, 766.97],
        [790.14, 0.003837, 776.247],
        [800.27, 0.003887, 785.485],
        [810.4, 0.003936, 794.681],
        [820.53, 0.003985, 803.836],
        [830.66, 0.004035, 812.948],
        [840.79, 0.004084, 822.017],
        [850.92, 0.004134, 831.041],
        [861.05, 0.004183, 840.02],
        [871.18, 0.004233, 848.954],
        [881.31, 0.004282, 857.84],
        [891.44, 0.004332, 866.68],
        [901.57, 0.004381, 875.471],
        [911.7, 0.004431, 884.214],
        [921.83, 0.004481, 892.908],
        [931.96, 0.00453, 901.552],
        [942.09, 0.00458, 910.146],
        [952.22, 0.00463, 918.69],
        [962.35, 0.004679, 927.182],
        [972.48, 0.004729, 935.623],
        [982.61, 0.004779, 944.012],
        [992.74, 0.004829, 952.349],
        [1002.87, 0.004879, 960.634],
        [1013.0, 0.004929, 968.866],
        [1023.13, 0.004979, 977.046],
        [1033.26, 0.005029, 985.172],
        [1043.39, 0.00508, 993.245],
        [1053.52, 0.00513, 1001.266],
        [1063.65, 0.00518, 1009.232],
        [1073.78, 0.005231, 1017.146],
        [1083.91, 0.005281, 1025.007],
        [1094.04, 0.005332, 1032.814],
        [1104.17, 0.005382, 1040.568],
        [1114.3, 0.005433, 1048.269],
        [1124.43, 0.005484, 1055.918],
        [1134.56, 0.005535, 1063.513],
        [1144.69, 0.005586, 1071.056],
        [1154.82, 0.005637, 1078.547],
        [1164.95, 0.005688, 1085.985],
        [1175.08, 0.005739, 1093.372],
        [1185.21, 0.00579, 1100.707],
        [1195.34, 0.005842, 1107.99],
        [1205.47, 0.005893, 1115.223],
        [1215.6, 0.005945, 1122.405],
        [1225.73, 0.005996, 1129.536],
        [1235.86, 0.006048, 1136.618],
        [1245.99, 0.0061, 1143.649],
        [1256.12, 0.006152, 1150.632],
        [1266.25, 0.006204, 1157.565],
        [1276.38, 0.006257, 1164.45],
        [1286.51, 0.006309, 1171.287],
        [1296.64, 0.006362, 1178.076],
        [1306.77, 0.006414, 1184.818],
        [1316.9, 0.006467, 1191.513],
        [1327.03, 0.00652, 1198.162],
        [1337.16, 0.006573, 1204.765],
        [1347.29, 0.006626, 1211.322],
        [1357.42, 0.006679, 1217.834],
        [1367.55, 0.006733, 1224.302],
        [1377.68, 0.006786, 1230.725],
        [1387.81, 0.00684, 1237.105],
        [1397.94, 0.006894, 1243.442],
        [1408.07, 0.006948, 1249.735],
        [1418.2, 0.007002, 1255.987],
        [1428.33, 0.007057, 1262.197],
        [1438.46, 0.007111, 1268.365],
        [1448.59, 0.007166, 1274.493],
        [1458.72, 0.007221, 1280.58],
        [1468.85, 0.007276, 1286.627],
        [1478.98, 0.007331, 1292.634],
        [1489.11, 0.007386, 1298.603],
        [1499.24, 0.007441, 1304.533],
        [1509.37, 0.007497, 1310.425],
        [1519.5, 0.007553, 1316.279],
        [1529.63, 0.007609, 1322.096],
        [1539.76, 0.007665, 1327.876],
        [1549.89, 0.007721, 1333.62],
        [1560.02, 0.007778, 1339.328],
        [1570.15, 0.007835, 1345.0],
        [1580.28, 0.007892, 1350.638],
        [1590.41, 0.007949, 1356.241],
        [1600.54, 0.008006, 1361.809],
        [1610.67, 0.008063, 1367.344],
        [1620.8, 0.008121, 1372.846],
        [1630.93, 0.008179, 1378.314],
        [1641.06, 0.008237, 1383.751],
        [1651.19, 0.008295, 1389.154],
        [1661.32, 0.008354, 1394.527],
        [1671.45, 0.008412, 1399.868],
        [1681.58, 0.008471, 1405.178],
        [1691.71, 0.00853, 1410.457],
        [1701.84, 0.008589, 1415.706],
        [1711.97, 0.008649, 1420.926],
        [1722.1, 0.008709, 1426.116],
        [1732.23, 0.008768, 1431.276],
        [1742.36, 0.008829, 1436.409],
        [1752.49, 0.008889, 1441.512],
        [1762.62, 0.008949, 1446.588],
        [1772.75, 0.00901, 1451.636],
        [1782.88, 0.009071, 1456.657],
        [1793.01, 0.009132, 1461.651],
        [1803.14, 0.009194, 1466.619],
        [1813.27, 0.009255, 1471.559],
        [1823.4, 0.009317, 1476.474],
        [1833.53, 0.009379, 1481.364],
        [1843.66, 0.009442, 1486.228],
        [1853.79, 0.009504, 1491.067],
        [1863.92, 0.009567, 1495.881],
        [1874.05, 0.00963, 1500.671],
        [1884.18, 0.009693, 1505.436],
        [1894.31, 0.009757, 1510.178],
        [1904.44, 0.00982, 1514.897],
        [1914.57, 0.009884, 1519.592],
        [1924.7, 0.009948, 1524.264],
        [1934.83, 0.010013, 1528.913],
        [1944.96, 0.010078, 1533.54],
        [1955.09, 0.010142, 1538.145],
        [1965.22, 0.010208, 1542.728],
        [1975.35, 0.010273, 1547.289],
        [1985.48, 0.010339, 1551.83],
        [1995.61, 0.010405, 1556.349],
        [2005.74, 0.010471, 1560.847],
        [2015.87, 0.010537, 1565.324],
        [2026.0, 0.010604, 1569.781]
    ]
)
