# Database Settings
DATABASE_AUTO_CREATE_INDEX = True
DATABASES = {
    "default": {
        # 'db': '',
        # 'host': '',
        # 'port': 0,
        # 'username': '',
        # 'password': '',
        # 'ssl': False,
        # 'ssl_ca_certs': ''
    }
}

# Cache Settings
CACHES = {
    "default": {},
    "local": {
        "backend": "spaceone.core.cache.local_cache.LocalCache",
        "max_size": 128,
        "ttl": 300,
    },
}

# Handler Settings
HANDLERS = {
    # "authentication": [{
    #     "backend": "spaceone.core.handler.authentication_handler:SpaceONEAuthenticationHandler"
    # }],
    # "authorization": [{
    #     "backend": "spaceone.core.handler.authorization_handler:SpaceONEAuthorizationHandler"
    # }],
    # "mutation": [{
    #     "backend": "spaceone.core.handler.mutation_handler:SpaceONEMutationHandler"
    # }],
    # "event": []
}

# Connector Settings
CONNECTORS = {
    "SpaceConnector": {
        "backend": "spaceone.core.connector.space_connector:SpaceConnector",
        "endpoints": {
            "identity": "grpc://identity:50051/v1",
            "inventory": "grpc://inventory:50051/v1",
            "monitoring": "grpc://monitoring:50051/v1",
            "cost_analysis": "grpc://cost-analysis:50051/v1",
            "notification": "grpc://notification:50051/v1",
        },
    }
}

# Queue Settings
collect_queue = "statistics_q"
QUEUES = {
    "statistics_q": {
        "backend": "spaceone.core.queue.redis_queue.RedisQueue",
        "host": "redis",
        "port": 6379,
        "channel": "stat_scheduler",
    },
}
SCHEDULERS = {}
WORKERS = {}

# System Token Settings
TOKEN = ""
