from customtkinter import CTkScrollableFrame
from customtkinter import CTkFrame
from customtkinter import CTkLabel
from customtkinter import CTkButton
from customtkinter import CTkEntry
from customtkinter import CTkOptionMenu
import tkinter as tk

class FunctionsList(CTkFrame):
    def __init__(self, *args,
                 option_manager: None,
                 step_index: 0,
                 **kwargs):
        super().__init__(*args, **kwargs)
        

        self.option_manager = option_manager
        self.step_index = step_index

        self.edit_mode = False
        self.render()
    
    def clear(self):
        self.containerFrame.destroy()
        
    def toggle_edit_mode(self):
        self.clear()
        self.edit_mode = not self.edit_mode
        self.render()
        
    def render(self):
        
        self.containerFrame = CTkFrame(self, fg_color="transparent")
        self.containerFrame.grid(row=0, column=0, padx=(5, 5), pady=(5, 5), sticky="nsew")
        self.containerFrame.grid_columnconfigure((0, 1), weight=1)
        
        row = 1
        
        funcs = self.option_manager.get_steps()[self.step_index]["objfunc"]
        
        index = 0
        for func in funcs:
            
            CTkLabel(self.containerFrame, text="Name:").grid(row=row, column=0, padx=(5, 5), pady=(5, 5), sticky="nsew")
            CTkLabel(self.containerFrame, text="Objective:").grid(row=row, column=1, padx=(5, 5), pady=(5, 5), sticky="nsew")
            CTkLabel(self.containerFrame, text="Weight:").grid(row=row, column=2, padx=(5, 5), pady=(5, 5), sticky="nsew")
            
            row += 1
            
            CTkEntry(self.containerFrame, textvariable=func["name"]).grid(row=row, column=0, padx=(5, 5), pady=(5, 5), sticky="ew")
            CTkEntry(self.containerFrame, textvariable=func["of"]).grid(row=row, column=1, padx=(5, 5), pady=(5, 5), sticky="ew")
            CTkEntry(self.containerFrame, textvariable=func["weight"]).grid(row=row, column=2, padx=(5, 5), pady=(5, 5), sticky="ew")
            
            row += 1
            
            CTkLabel(self.containerFrame, text="Data:").grid(row=row, column=0, padx=(5, 5), pady=(5, 5), sticky="nsew")
            
            row += 1
            for obj in func["data"]:
                CTkEntry(self.containerFrame, textvariable=obj).grid(row=row, column=0, columnspan=3, padx=(5, 5), pady=(5, 5), sticky="nsew")
                row += 1
            
            if self.edit_mode:
                remove_func = lambda index=index: (self.clear(), self.option_manager.remove_function(self.step_index, index), self.render())
                dupe_func = lambda index=index: (self.clear(), self.option_manager.dupe_function(self.step_index, index), self.render())
                CTkButton(self.containerFrame, text="Duplicate", command=dupe_func).grid(row=row, column=0, columnspan=1, padx=(5, 5), pady=(5, 5), sticky="ew")
                CTkButton(self.containerFrame, text="Remove", command=remove_func).grid(row=row, column=1, columnspan=1, padx=(5, 5), pady=(5, 5), sticky="ew")
                row += 1
                pass
            else:
                pass
            index += 1
            row += 1
            
        add_function = lambda: (self.clear(), self.option_manager.add_function(self.step_index), self.render())
        if len(funcs) > 0:
            if self.edit_mode:
                CTkButton(self.containerFrame, text="Exit", command=self.toggle_edit_mode).grid(row=row, column=0, padx=(5, 5), pady=(5, 5), sticky="ew")
            else:
                CTkButton(self.containerFrame, text="Edit", command=self.toggle_edit_mode).grid(row=row, column=0, padx=(5, 5), pady=(5, 5), sticky="ew")
            CTkButton(self.containerFrame, text="Add Objective Function", command=add_function).grid(row=row, column=1, columnspan=2, padx=(5, 5), pady=(5, 5), sticky="ew")
        else:
            CTkButton(self.containerFrame, text="Add Objective Function", command=add_function).grid(row=row, column=0, columnspan=2, padx=(5, 5), pady=(5, 5), sticky="ew")