/**
 * Kafka cluster version
 */
export declare class KafkaVersion {
    readonly version: string;
    /**
     * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
     *
     * Kafka version 1.1.1
     *
     * @deprecated use the latest runtime instead
     */
    static readonly V1_1_1: KafkaVersion;
    /**
     * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
     *
     * Kafka version 2.1.0
     *
     * @deprecated use the latest runtime instead
     */
    static readonly V2_1_0: KafkaVersion;
    /**
     * Kafka version 2.2.1
     */
    static readonly V2_2_1: KafkaVersion;
    /**
     * Kafka version 2.3.1
     */
    static readonly V2_3_1: KafkaVersion;
    /**
     * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
     *
     * Kafka version 2.4.1
     *
     * @deprecated use the latest runtime instead
     */
    static readonly V2_4_1: KafkaVersion;
    /**
     * Kafka version 2.4.1
     */
    static readonly V2_4_1_1: KafkaVersion;
    /**
     * Kafka version 2.5.1
     */
    static readonly V2_5_1: KafkaVersion;
    /**
     * Kafka version 2.6.0
     */
    static readonly V2_6_0: KafkaVersion;
    /**
     * Kafka version 2.6.1
     */
    static readonly V2_6_1: KafkaVersion;
    /**
     * Kafka version 2.6.2
     */
    static readonly V2_6_2: KafkaVersion;
    /**
     * Kafka version 2.6.3
     */
    static readonly V2_6_3: KafkaVersion;
    /**
     * Kafka version 2.7.0
     */
    static readonly V2_7_0: KafkaVersion;
    /**
     * Kafka version 2.7.1
     */
    static readonly V2_7_1: KafkaVersion;
    /**
     * Kafka version 2.7.2
     */
    static readonly V2_7_2: KafkaVersion;
    /**
     * Kafka version 2.8.0
     */
    static readonly V2_8_0: KafkaVersion;
    /**
     * Kafka version 2.8.1
     */
    static readonly V2_8_1: KafkaVersion;
    /**
     * AWS MSK Kafka version 2.8.2.tiered
     */
    static readonly V2_8_2_TIERED: KafkaVersion;
    /**
     * Kafka version 3.1.1
     */
    static readonly V3_1_1: KafkaVersion;
    /**
     * Kafka version 3.2.0
     */
    static readonly V3_2_0: KafkaVersion;
    /**
     * Kafka version 3.3.1
     */
    static readonly V3_3_1: KafkaVersion;
    /**
     * Kafka version 3.3.2
     */
    static readonly V3_3_2: KafkaVersion;
    /**
     * Kafka version 3.4.0
     */
    static readonly V3_4_0: KafkaVersion;
    /**
     * Kafka version 3.5.1
     */
    static readonly V3_5_1: KafkaVersion;
    /**
     * Kafka version 3.6.0
     */
    static readonly V3_6_0: KafkaVersion;
    /**
     * Custom cluster version
     * @param version custom version number
     */
    static of(version: string): KafkaVersion;
    /**
     * List of Kafka versions that support tiered storage
     *
     * @see https://docs.aws.amazon.com/msk/latest/developerguide/msk-tiered-storage.html#msk-tiered-storage-requirements
     */
    private static readonly TIERED_STORAGE_COMPATIBLE_VERSIONS;
    /**
     *
     * @param version cluster version number
     */
    private constructor();
    /**
     * Checks if the cluster version supports tiered storage mode.
     */
    isTieredStorageCompatible(): boolean;
}
