"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KafkaVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Kafka cluster version
 */
class KafkaVersion {
    /**
     * Custom cluster version
     * @param version custom version number
     */
    static of(version) {
        return new KafkaVersion(version);
    }
    /**
     *
     * @param version cluster version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Checks if the cluster version supports tiered storage mode.
     */
    isTieredStorageCompatible() {
        return KafkaVersion.TIERED_STORAGE_COMPATIBLE_VERSIONS.includes(this.version);
    }
    ;
}
exports.KafkaVersion = KafkaVersion;
_a = JSII_RTTI_SYMBOL_1;
KafkaVersion[_a] = { fqn: "@aws-cdk/aws-msk-alpha.KafkaVersion", version: "2.145.0-alpha.0" };
/**
 * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
 *
 * Kafka version 1.1.1
 *
 * @deprecated use the latest runtime instead
 */
KafkaVersion.V1_1_1 = KafkaVersion.of('1.1.1');
/**
 * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
 *
 * Kafka version 2.1.0
 *
 * @deprecated use the latest runtime instead
 */
KafkaVersion.V2_1_0 = KafkaVersion.of('2.1.0');
/**
 * Kafka version 2.2.1
 */
KafkaVersion.V2_2_1 = KafkaVersion.of('2.2.1');
/**
 * Kafka version 2.3.1
 */
KafkaVersion.V2_3_1 = KafkaVersion.of('2.3.1');
/**
 * **Deprecated by Amazon MSK. You can't create a Kafka cluster with a deprecated version.**
 *
 * Kafka version 2.4.1
 *
 * @deprecated use the latest runtime instead
 */
KafkaVersion.V2_4_1 = KafkaVersion.of('2.4.1');
/**
 * Kafka version 2.4.1
 */
KafkaVersion.V2_4_1_1 = KafkaVersion.of('2.4.1.1');
/**
 * Kafka version 2.5.1
 */
KafkaVersion.V2_5_1 = KafkaVersion.of('2.5.1');
/**
 * Kafka version 2.6.0
 */
KafkaVersion.V2_6_0 = KafkaVersion.of('2.6.0');
/**
 * Kafka version 2.6.1
 */
KafkaVersion.V2_6_1 = KafkaVersion.of('2.6.1');
/**
 * Kafka version 2.6.2
 */
KafkaVersion.V2_6_2 = KafkaVersion.of('2.6.2');
/**
 * Kafka version 2.6.3
 */
KafkaVersion.V2_6_3 = KafkaVersion.of('2.6.3');
/**
 * Kafka version 2.7.0
 */
KafkaVersion.V2_7_0 = KafkaVersion.of('2.7.0');
/**
 * Kafka version 2.7.1
 */
KafkaVersion.V2_7_1 = KafkaVersion.of('2.7.1');
/**
 * Kafka version 2.7.2
 */
KafkaVersion.V2_7_2 = KafkaVersion.of('2.7.2');
/**
 * Kafka version 2.8.0
 */
KafkaVersion.V2_8_0 = KafkaVersion.of('2.8.0');
/**
 * Kafka version 2.8.1
 */
KafkaVersion.V2_8_1 = KafkaVersion.of('2.8.1');
/**
 * AWS MSK Kafka version 2.8.2.tiered
 */
KafkaVersion.V2_8_2_TIERED = KafkaVersion.of('2.8.2.tiered');
/**
 * Kafka version 3.1.1
 */
KafkaVersion.V3_1_1 = KafkaVersion.of('3.1.1');
/**
 * Kafka version 3.2.0
 */
KafkaVersion.V3_2_0 = KafkaVersion.of('3.2.0');
/**
 * Kafka version 3.3.1
 */
KafkaVersion.V3_3_1 = KafkaVersion.of('3.3.1');
/**
 * Kafka version 3.3.2
 */
KafkaVersion.V3_3_2 = KafkaVersion.of('3.3.2');
/**
 * Kafka version 3.4.0
 */
KafkaVersion.V3_4_0 = KafkaVersion.of('3.4.0');
/**
 * Kafka version 3.5.1
 */
KafkaVersion.V3_5_1 = KafkaVersion.of('3.5.1');
/**
 * Kafka version 3.6.0
 */
KafkaVersion.V3_6_0 = KafkaVersion.of('3.6.0');
/**
 * List of Kafka versions that support tiered storage
 *
 * @see https://docs.aws.amazon.com/msk/latest/developerguide/msk-tiered-storage.html#msk-tiered-storage-requirements
 */
KafkaVersion.TIERED_STORAGE_COMPATIBLE_VERSIONS = [
    KafkaVersion.V2_8_2_TIERED,
    KafkaVersion.V3_6_0,
].map(({ version }) => version);
//# sourceMappingURL=data:application/json;base64,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