// -*- c++ -*-
//
// michael a.g. aïvázis <michael.aivazis@para-sim.com>
// (c) 1998-2023 all rights reserved


// external support
#include "externals.h"
// get the forward declarations
#include "forward.h"
// the type aliases
#include "api.h"
// get the support we need
#include "ASCII.h"
#include "CSI.h"
#include "ANSI.h"


// the color table factory
auto
pyre::journal::ANSI::make_x11() -> table_type
{
    // make a table
    table_type table;

    // the reset sequence
    table["normal"] = csi_t::reset();

    // the X11 named colors
    table["snow"] = csi_t::csi24(255, 250, 250);
    table["ghost white"] = csi_t::csi24(248, 248, 255);
    table["GhostWhite"] = csi_t::csi24(248, 248, 255);
    table["white smoke"] = csi_t::csi24(245, 245, 245);
    table["WhiteSmoke"] = csi_t::csi24(245, 245, 245);
    table["gainsboro"] = csi_t::csi24(220, 220, 220);
    table["floral white"] = csi_t::csi24(255, 250, 240);
    table["FloralWhite"] = csi_t::csi24(255, 250, 240);
    table["old lace"] = csi_t::csi24(253, 245, 230);
    table["OldLace"] = csi_t::csi24(253, 245, 230);
    table["linen"] = csi_t::csi24(250, 240, 230);
    table["antique white"] = csi_t::csi24(250, 235, 215);
    table["AntiqueWhite"] = csi_t::csi24(250, 235, 215);
    table["papaya whip"] = csi_t::csi24(255, 239, 213);
    table["PapayaWhip"] = csi_t::csi24(255, 239, 213);
    table["blanched almond"] = csi_t::csi24(255, 235, 205);
    table["BlanchedAlmond"] = csi_t::csi24(255, 235, 205);
    table["bisque"] = csi_t::csi24(255, 228, 196);
    table["peach puff"] = csi_t::csi24(255, 218, 185);
    table["PeachPuff"] = csi_t::csi24(255, 218, 185);
    table["navajo white"] = csi_t::csi24(255, 222, 173);
    table["NavajoWhite"] = csi_t::csi24(255, 222, 173);
    table["moccasin"] = csi_t::csi24(255, 228, 181);
    table["cornsilk"] = csi_t::csi24(255, 248, 220);
    table["ivory"] = csi_t::csi24(255, 255, 240);
    table["lemon chiffon"] = csi_t::csi24(255, 250, 205);
    table["LemonChiffon"] = csi_t::csi24(255, 250, 205);
    table["seashell"] = csi_t::csi24(255, 245, 238);
    table["honeydew"] = csi_t::csi24(240, 255, 240);
    table["mint cream"] = csi_t::csi24(245, 255, 250);
    table["MintCream"] = csi_t::csi24(245, 255, 250);
    table["azure"] = csi_t::csi24(240, 255, 255);
    table["alice blue"] = csi_t::csi24(240, 248, 255);
    table["AliceBlue"] = csi_t::csi24(240, 248, 255);
    table["lavender"] = csi_t::csi24(230, 230, 250);
    table["lavender blush"] = csi_t::csi24(255, 240, 245);
    table["LavenderBlush"] = csi_t::csi24(255, 240, 245);
    table["misty rose"] = csi_t::csi24(255, 228, 225);
    table["MistyRose"] = csi_t::csi24(255, 228, 225);
    table["white"] = csi_t::csi24(255, 255, 255);
    table["black"] = csi_t::csi24(0, 0, 0);
    table["dark slate gray"] = csi_t::csi24(47, 79, 79);
    table["DarkSlateGray"] = csi_t::csi24(47, 79, 79);
    table["dark slate grey"] = csi_t::csi24(47, 79, 79);
    table["DarkSlateGrey"] = csi_t::csi24(47, 79, 79);
    table["dim gray"] = csi_t::csi24(105, 105, 105);
    table["DimGray"] = csi_t::csi24(105, 105, 105);
    table["dim grey"] = csi_t::csi24(105, 105, 105);
    table["DimGrey"] = csi_t::csi24(105, 105, 105);
    table["slate gray"] = csi_t::csi24(112, 128, 144);
    table["SlateGray"] = csi_t::csi24(112, 128, 144);
    table["slate grey"] = csi_t::csi24(112, 128, 144);
    table["SlateGrey"] = csi_t::csi24(112, 128, 144);
    table["light slate gray"] = csi_t::csi24(119, 136, 153);
    table["LightSlateGray"] = csi_t::csi24(119, 136, 153);
    table["light slate grey"] = csi_t::csi24(119, 136, 153);
    table["LightSlateGrey"] = csi_t::csi24(119, 136, 153);
    table["gray"] = csi_t::csi24(190, 190, 190);
    table["grey"] = csi_t::csi24(190, 190, 190);
    table["x11 gray"] = csi_t::csi24(190, 190, 190);
    table["X11Gray"] = csi_t::csi24(190, 190, 190);
    table["x11 grey"] = csi_t::csi24(190, 190, 190);
    table["X11Grey"] = csi_t::csi24(190, 190, 190);
    table["web gray"] = csi_t::csi24(128, 128, 128);
    table["WebGray"] = csi_t::csi24(128, 128, 128);
    table["web grey"] = csi_t::csi24(128, 128, 128);
    table["WebGrey"] = csi_t::csi24(128, 128, 128);
    table["light grey"] = csi_t::csi24(211, 211, 211);
    table["LightGrey"] = csi_t::csi24(211, 211, 211);
    table["light gray"] = csi_t::csi24(211, 211, 211);
    table["LightGray"] = csi_t::csi24(211, 211, 211);
    table["midnight blue"] = csi_t::csi24(25, 25, 112);
    table["MidnightBlue"] = csi_t::csi24(25, 25, 112);
    table["navy"] = csi_t::csi24(0, 0, 128);
    table["navy blue"] = csi_t::csi24(0, 0, 128);
    table["NavyBlue"] = csi_t::csi24(0, 0, 128);
    table["cornflower blue"] = csi_t::csi24(100, 149, 237);
    table["CornflowerBlue"] = csi_t::csi24(100, 149, 237);
    table["dark slate blue"] = csi_t::csi24(72, 61, 139);
    table["DarkSlateBlue"] = csi_t::csi24(72, 61, 139);
    table["slate blue"] = csi_t::csi24(106, 90, 205);
    table["SlateBlue"] = csi_t::csi24(106, 90, 205);
    table["medium slate blue"] = csi_t::csi24(123, 104, 238);
    table["MediumSlateBlue"] = csi_t::csi24(123, 104, 238);
    table["light slate blue"] = csi_t::csi24(132, 112, 255);
    table["LightSlateBlue"] = csi_t::csi24(132, 112, 255);
    table["medium blue"] = csi_t::csi24(0, 0, 205);
    table["MediumBlue"] = csi_t::csi24(0, 0, 205);
    table["royal blue"] = csi_t::csi24(65, 105, 225);
    table["RoyalBlue"] = csi_t::csi24(65, 105, 225);
    table["blue"] = csi_t::csi24(0, 0, 255);
    table["dodger blue"] = csi_t::csi24(30, 144, 255);
    table["DodgerBlue"] = csi_t::csi24(30, 144, 255);
    table["deep sky blue"] = csi_t::csi24(0, 191, 255);
    table["DeepSkyBlue"] = csi_t::csi24(0, 191, 255);
    table["sky blue"] = csi_t::csi24(135, 206, 235);
    table["SkyBlue"] = csi_t::csi24(135, 206, 235);
    table["light sky blue"] = csi_t::csi24(135, 206, 250);
    table["LightSkyBlue"] = csi_t::csi24(135, 206, 250);
    table["steel blue"] = csi_t::csi24(70, 130, 180);
    table["SteelBlue"] = csi_t::csi24(70, 130, 180);
    table["light steel blue"] = csi_t::csi24(176, 196, 222);
    table["LightSteelBlue"] = csi_t::csi24(176, 196, 222);
    table["light blue"] = csi_t::csi24(173, 216, 230);
    table["LightBlue"] = csi_t::csi24(173, 216, 230);
    table["powder blue"] = csi_t::csi24(176, 224, 230);
    table["PowderBlue"] = csi_t::csi24(176, 224, 230);
    table["pale turquoise"] = csi_t::csi24(175, 238, 238);
    table["PaleTurquoise"] = csi_t::csi24(175, 238, 238);
    table["dark turquoise"] = csi_t::csi24(0, 206, 209);
    table["DarkTurquoise"] = csi_t::csi24(0, 206, 209);
    table["medium turquoise"] = csi_t::csi24(72, 209, 204);
    table["MediumTurquoise"] = csi_t::csi24(72, 209, 204);
    table["turquoise"] = csi_t::csi24(64, 224, 208);
    table["cyan"] = csi_t::csi24(0, 255, 255);
    table["aqua"] = csi_t::csi24(0, 255, 255);
    table["light cyan"] = csi_t::csi24(224, 255, 255);
    table["LightCyan"] = csi_t::csi24(224, 255, 255);
    table["cadet blue"] = csi_t::csi24(95, 158, 160);
    table["CadetBlue"] = csi_t::csi24(95, 158, 160);
    table["medium aquamarine"] = csi_t::csi24(102, 205, 170);
    table["MediumAquamarine"] = csi_t::csi24(102, 205, 170);
    table["aquamarine"] = csi_t::csi24(127, 255, 212);
    table["dark green"] = csi_t::csi24(0, 100, 0);
    table["DarkGreen"] = csi_t::csi24(0, 100, 0);
    table["dark olive green"] = csi_t::csi24(85, 107, 47);
    table["DarkOliveGreen"] = csi_t::csi24(85, 107, 47);
    table["dark sea green"] = csi_t::csi24(143, 188, 143);
    table["DarkSeaGreen"] = csi_t::csi24(143, 188, 143);
    table["sea green"] = csi_t::csi24(46, 139, 87);
    table["SeaGreen"] = csi_t::csi24(46, 139, 87);
    table["medium sea green"] = csi_t::csi24(60, 179, 113);
    table["MediumSeaGreen"] = csi_t::csi24(60, 179, 113);
    table["light sea green"] = csi_t::csi24(32, 178, 170);
    table["LightSeaGreen"] = csi_t::csi24(32, 178, 170);
    table["pale green"] = csi_t::csi24(152, 251, 152);
    table["PaleGreen"] = csi_t::csi24(152, 251, 152);
    table["spring green"] = csi_t::csi24(0, 255, 127);
    table["SpringGreen"] = csi_t::csi24(0, 255, 127);
    table["lawn green"] = csi_t::csi24(124, 252, 0);
    table["LawnGreen"] = csi_t::csi24(124, 252, 0);
    table["green"] = csi_t::csi24(0, 255, 0);
    table["lime"] = csi_t::csi24(0, 255, 0);
    table["x11 green"] = csi_t::csi24(0, 255, 0);
    table["X11Green"] = csi_t::csi24(0, 255, 0);
    table["web green"] = csi_t::csi24(0, 128, 0);
    table["WebGreen"] = csi_t::csi24(0, 128, 0);
    table["chartreuse"] = csi_t::csi24(127, 255, 0);
    table["medium spring green"] = csi_t::csi24(0, 250, 154);
    table["MediumSpringGreen"] = csi_t::csi24(0, 250, 154);
    table["green yellow"] = csi_t::csi24(173, 255, 47);
    table["GreenYellow"] = csi_t::csi24(173, 255, 47);
    table["lime green"] = csi_t::csi24(50, 205, 50);
    table["LimeGreen"] = csi_t::csi24(50, 205, 50);
    table["yellow green"] = csi_t::csi24(154, 205, 50);
    table["YellowGreen"] = csi_t::csi24(154, 205, 50);
    table["forest green"] = csi_t::csi24(34, 139, 34);
    table["ForestGreen"] = csi_t::csi24(34, 139, 34);
    table["olive drab"] = csi_t::csi24(107, 142, 35);
    table["OliveDrab"] = csi_t::csi24(107, 142, 35);
    table["dark khaki"] = csi_t::csi24(189, 183, 107);
    table["DarkKhaki"] = csi_t::csi24(189, 183, 107);
    table["khaki"] = csi_t::csi24(240, 230, 140);
    table["pale goldenrod"] = csi_t::csi24(238, 232, 170);
    table["PaleGoldenrod"] = csi_t::csi24(238, 232, 170);
    table["light goldenrod yellow"] = csi_t::csi24(250, 250, 210);
    table["LightGoldenrodYellow"] = csi_t::csi24(250, 250, 210);
    table["light yellow"] = csi_t::csi24(255, 255, 224);
    table["LightYellow"] = csi_t::csi24(255, 255, 224);
    table["yellow"] = csi_t::csi24(255, 255, 0);
    table["gold"] = csi_t::csi24(255, 215, 0);
    table["light goldenrod"] = csi_t::csi24(238, 221, 130);
    table["LightGoldenrod"] = csi_t::csi24(238, 221, 130);
    table["goldenrod"] = csi_t::csi24(218, 165, 32);
    table["dark goldenrod"] = csi_t::csi24(184, 134, 11);
    table["DarkGoldenrod"] = csi_t::csi24(184, 134, 11);
    table["rosy brown"] = csi_t::csi24(188, 143, 143);
    table["RosyBrown"] = csi_t::csi24(188, 143, 143);
    table["indian red"] = csi_t::csi24(205, 92, 92);
    table["IndianRed"] = csi_t::csi24(205, 92, 92);
    table["saddle brown"] = csi_t::csi24(139, 69, 19);
    table["SaddleBrown"] = csi_t::csi24(139, 69, 19);
    table["sienna"] = csi_t::csi24(160, 82, 45);
    table["peru"] = csi_t::csi24(205, 133, 63);
    table["burlywood"] = csi_t::csi24(222, 184, 135);
    table["beige"] = csi_t::csi24(245, 245, 220);
    table["wheat"] = csi_t::csi24(245, 222, 179);
    table["sandy brown"] = csi_t::csi24(244, 164, 96);
    table["SandyBrown"] = csi_t::csi24(244, 164, 96);
    table["tan"] = csi_t::csi24(210, 180, 140);
    table["chocolate"] = csi_t::csi24(210, 105, 30);
    table["firebrick"] = csi_t::csi24(178, 34, 34);
    table["brown"] = csi_t::csi24(165, 42, 42);
    table["dark salmon"] = csi_t::csi24(233, 150, 122);
    table["DarkSalmon"] = csi_t::csi24(233, 150, 122);
    table["salmon"] = csi_t::csi24(250, 128, 114);
    table["light salmon"] = csi_t::csi24(255, 160, 122);
    table["LightSalmon"] = csi_t::csi24(255, 160, 122);
    table["orange"] = csi_t::csi24(255, 165, 0);
    table["dark orange"] = csi_t::csi24(255, 140, 0);
    table["DarkOrange"] = csi_t::csi24(255, 140, 0);
    table["coral"] = csi_t::csi24(255, 127, 80);
    table["light coral"] = csi_t::csi24(240, 128, 128);
    table["LightCoral"] = csi_t::csi24(240, 128, 128);
    table["tomato"] = csi_t::csi24(255, 99, 71);
    table["orange red"] = csi_t::csi24(255, 69, 0);
    table["OrangeRed"] = csi_t::csi24(255, 69, 0);
    table["red"] = csi_t::csi24(255, 0, 0);
    table["hot pink"] = csi_t::csi24(255, 105, 180);
    table["HotPink"] = csi_t::csi24(255, 105, 180);
    table["deep pink"] = csi_t::csi24(255, 20, 147);
    table["DeepPink"] = csi_t::csi24(255, 20, 147);
    table["pink"] = csi_t::csi24(255, 192, 203);
    table["light pink"] = csi_t::csi24(255, 182, 193);
    table["LightPink"] = csi_t::csi24(255, 182, 193);
    table["pale violet red"] = csi_t::csi24(219, 112, 147);
    table["PaleVioletRed"] = csi_t::csi24(219, 112, 147);
    table["maroon"] = csi_t::csi24(176, 48, 96);
    table["x11 maroon"] = csi_t::csi24(176, 48, 96);
    table["X11Maroon"] = csi_t::csi24(176, 48, 96);
    table["web maroon"] = csi_t::csi24(128, 0, 0);
    table["WebMaroon"] = csi_t::csi24(128, 0, 0);
    table["medium violet red"] = csi_t::csi24(199, 21, 133);
    table["MediumVioletRed"] = csi_t::csi24(199, 21, 133);
    table["violet red"] = csi_t::csi24(208, 32, 144);
    table["VioletRed"] = csi_t::csi24(208, 32, 144);
    table["magenta"] = csi_t::csi24(255, 0, 255);
    table["fuchsia"] = csi_t::csi24(255, 0, 255);
    table["violet"] = csi_t::csi24(238, 130, 238);
    table["plum"] = csi_t::csi24(221, 160, 221);
    table["orchid"] = csi_t::csi24(218, 112, 214);
    table["medium orchid"] = csi_t::csi24(186, 85, 211);
    table["MediumOrchid"] = csi_t::csi24(186, 85, 211);
    table["dark orchid"] = csi_t::csi24(153, 50, 204);
    table["DarkOrchid"] = csi_t::csi24(153, 50, 204);
    table["dark violet"] = csi_t::csi24(148, 0, 211);
    table["DarkViolet"] = csi_t::csi24(148, 0, 211);
    table["blue violet"] = csi_t::csi24(138, 43, 226);
    table["BlueViolet"] = csi_t::csi24(138, 43, 226);
    table["purple"] = csi_t::csi24(160, 32, 240);
    table["x11 purple"] = csi_t::csi24(160, 32, 240);
    table["X11Purple"] = csi_t::csi24(160, 32, 240);
    table["web purple"] = csi_t::csi24(128, 0, 128);
    table["WebPurple"] = csi_t::csi24(128, 0, 128);
    table["medium purple"] = csi_t::csi24(147, 112, 219);
    table["MediumPurple"] = csi_t::csi24(147, 112, 219);
    table["thistle"] = csi_t::csi24(216, 191, 216);
    table["snow1"] = csi_t::csi24(255, 250, 250);
    table["snow2"] = csi_t::csi24(238, 233, 233);
    table["snow3"] = csi_t::csi24(205, 201, 201);
    table["snow4"] = csi_t::csi24(139, 137, 137);
    table["seashell1"] = csi_t::csi24(255, 245, 238);
    table["seashell2"] = csi_t::csi24(238, 229, 222);
    table["seashell3"] = csi_t::csi24(205, 197, 191);
    table["seashell4"] = csi_t::csi24(139, 134, 130);
    table["AntiqueWhite1"] = csi_t::csi24(255, 239, 219);
    table["AntiqueWhite2"] = csi_t::csi24(238, 223, 204);
    table["AntiqueWhite3"] = csi_t::csi24(205, 192, 176);
    table["AntiqueWhite4"] = csi_t::csi24(139, 131, 120);
    table["bisque1"] = csi_t::csi24(255, 228, 196);
    table["bisque2"] = csi_t::csi24(238, 213, 183);
    table["bisque3"] = csi_t::csi24(205, 183, 158);
    table["bisque4"] = csi_t::csi24(139, 125, 107);
    table["PeachPuff1"] = csi_t::csi24(255, 218, 185);
    table["PeachPuff2"] = csi_t::csi24(238, 203, 173);
    table["PeachPuff3"] = csi_t::csi24(205, 175, 149);
    table["PeachPuff4"] = csi_t::csi24(139, 119, 101);
    table["NavajoWhite1"] = csi_t::csi24(255, 222, 173);
    table["NavajoWhite2"] = csi_t::csi24(238, 207, 161);
    table["NavajoWhite3"] = csi_t::csi24(205, 179, 139);
    table["NavajoWhite4"] = csi_t::csi24(139, 121, 94);
    table["LemonChiffon1"] = csi_t::csi24(255, 250, 205);
    table["LemonChiffon2"] = csi_t::csi24(238, 233, 191);
    table["LemonChiffon3"] = csi_t::csi24(205, 201, 165);
    table["LemonChiffon4"] = csi_t::csi24(139, 137, 112);
    table["cornsilk1"] = csi_t::csi24(255, 248, 220);
    table["cornsilk2"] = csi_t::csi24(238, 232, 205);
    table["cornsilk3"] = csi_t::csi24(205, 200, 177);
    table["cornsilk4"] = csi_t::csi24(139, 136, 120);
    table["ivory1"] = csi_t::csi24(255, 255, 240);
    table["ivory2"] = csi_t::csi24(238, 238, 224);
    table["ivory3"] = csi_t::csi24(205, 205, 193);
    table["ivory4"] = csi_t::csi24(139, 139, 131);
    table["honeydew1"] = csi_t::csi24(240, 255, 240);
    table["honeydew2"] = csi_t::csi24(224, 238, 224);
    table["honeydew3"] = csi_t::csi24(193, 205, 193);
    table["honeydew4"] = csi_t::csi24(131, 139, 131);
    table["LavenderBlush1"] = csi_t::csi24(255, 240, 245);
    table["LavenderBlush2"] = csi_t::csi24(238, 224, 229);
    table["LavenderBlush3"] = csi_t::csi24(205, 193, 197);
    table["LavenderBlush4"] = csi_t::csi24(139, 131, 134);
    table["MistyRose1"] = csi_t::csi24(255, 228, 225);
    table["MistyRose2"] = csi_t::csi24(238, 213, 210);
    table["MistyRose3"] = csi_t::csi24(205, 183, 181);
    table["MistyRose4"] = csi_t::csi24(139, 125, 123);
    table["azure1"] = csi_t::csi24(240, 255, 255);
    table["azure2"] = csi_t::csi24(224, 238, 238);
    table["azure3"] = csi_t::csi24(193, 205, 205);
    table["azure4"] = csi_t::csi24(131, 139, 139);
    table["SlateBlue1"] = csi_t::csi24(131, 111, 255);
    table["SlateBlue2"] = csi_t::csi24(122, 103, 238);
    table["SlateBlue3"] = csi_t::csi24(105, 89, 205);
    table["SlateBlue4"] = csi_t::csi24(71, 60, 139);
    table["RoyalBlue1"] = csi_t::csi24(72, 118, 255);
    table["RoyalBlue2"] = csi_t::csi24(67, 110, 238);
    table["RoyalBlue3"] = csi_t::csi24(58, 95, 205);
    table["RoyalBlue4"] = csi_t::csi24(39, 64, 139);
    table["blue1"] = csi_t::csi24(0, 0, 255);
    table["blue2"] = csi_t::csi24(0, 0, 238);
    table["blue3"] = csi_t::csi24(0, 0, 205);
    table["blue4"] = csi_t::csi24(0, 0, 139);
    table["DodgerBlue1"] = csi_t::csi24(30, 144, 255);
    table["DodgerBlue2"] = csi_t::csi24(28, 134, 238);
    table["DodgerBlue3"] = csi_t::csi24(24, 116, 205);
    table["DodgerBlue4"] = csi_t::csi24(16, 78, 139);
    table["SteelBlue1"] = csi_t::csi24(99, 184, 255);
    table["SteelBlue2"] = csi_t::csi24(92, 172, 238);
    table["SteelBlue3"] = csi_t::csi24(79, 148, 205);
    table["SteelBlue4"] = csi_t::csi24(54, 100, 139);
    table["DeepSkyBlue1"] = csi_t::csi24(0, 191, 255);
    table["DeepSkyBlue2"] = csi_t::csi24(0, 178, 238);
    table["DeepSkyBlue3"] = csi_t::csi24(0, 154, 205);
    table["DeepSkyBlue4"] = csi_t::csi24(0, 104, 139);
    table["SkyBlue1"] = csi_t::csi24(135, 206, 255);
    table["SkyBlue2"] = csi_t::csi24(126, 192, 238);
    table["SkyBlue3"] = csi_t::csi24(108, 166, 205);
    table["SkyBlue4"] = csi_t::csi24(74, 112, 139);
    table["LightSkyBlue1"] = csi_t::csi24(176, 226, 255);
    table["LightSkyBlue2"] = csi_t::csi24(164, 211, 238);
    table["LightSkyBlue3"] = csi_t::csi24(141, 182, 205);
    table["LightSkyBlue4"] = csi_t::csi24(96, 123, 139);
    table["SlateGray1"] = csi_t::csi24(198, 226, 255);
    table["SlateGray2"] = csi_t::csi24(185, 211, 238);
    table["SlateGray3"] = csi_t::csi24(159, 182, 205);
    table["SlateGray4"] = csi_t::csi24(108, 123, 139);
    table["LightSteelBlue1"] = csi_t::csi24(202, 225, 255);
    table["LightSteelBlue2"] = csi_t::csi24(188, 210, 238);
    table["LightSteelBlue3"] = csi_t::csi24(162, 181, 205);
    table["LightSteelBlue4"] = csi_t::csi24(110, 123, 139);
    table["LightBlue1"] = csi_t::csi24(191, 239, 255);
    table["LightBlue2"] = csi_t::csi24(178, 223, 238);
    table["LightBlue3"] = csi_t::csi24(154, 192, 205);
    table["LightBlue4"] = csi_t::csi24(104, 131, 139);
    table["LightCyan1"] = csi_t::csi24(224, 255, 255);
    table["LightCyan2"] = csi_t::csi24(209, 238, 238);
    table["LightCyan3"] = csi_t::csi24(180, 205, 205);
    table["LightCyan4"] = csi_t::csi24(122, 139, 139);
    table["PaleTurquoise1"] = csi_t::csi24(187, 255, 255);
    table["PaleTurquoise2"] = csi_t::csi24(174, 238, 238);
    table["PaleTurquoise3"] = csi_t::csi24(150, 205, 205);
    table["PaleTurquoise4"] = csi_t::csi24(102, 139, 139);
    table["CadetBlue1"] = csi_t::csi24(152, 245, 255);
    table["CadetBlue2"] = csi_t::csi24(142, 229, 238);
    table["CadetBlue3"] = csi_t::csi24(122, 197, 205);
    table["CadetBlue4"] = csi_t::csi24(83, 134, 139);
    table["turquoise1"] = csi_t::csi24(0, 245, 255);
    table["turquoise2"] = csi_t::csi24(0, 229, 238);
    table["turquoise3"] = csi_t::csi24(0, 197, 205);
    table["turquoise4"] = csi_t::csi24(0, 134, 139);
    table["cyan1"] = csi_t::csi24(0, 255, 255);
    table["cyan2"] = csi_t::csi24(0, 238, 238);
    table["cyan3"] = csi_t::csi24(0, 205, 205);
    table["cyan4"] = csi_t::csi24(0, 139, 139);
    table["DarkSlateGray1"] = csi_t::csi24(151, 255, 255);
    table["DarkSlateGray2"] = csi_t::csi24(141, 238, 238);
    table["DarkSlateGray3"] = csi_t::csi24(121, 205, 205);
    table["DarkSlateGray4"] = csi_t::csi24(82, 139, 139);
    table["aquamarine1"] = csi_t::csi24(127, 255, 212);
    table["aquamarine2"] = csi_t::csi24(118, 238, 198);
    table["aquamarine3"] = csi_t::csi24(102, 205, 170);
    table["aquamarine4"] = csi_t::csi24(69, 139, 116);
    table["DarkSeaGreen1"] = csi_t::csi24(193, 255, 193);
    table["DarkSeaGreen2"] = csi_t::csi24(180, 238, 180);
    table["DarkSeaGreen3"] = csi_t::csi24(155, 205, 155);
    table["DarkSeaGreen4"] = csi_t::csi24(105, 139, 105);
    table["SeaGreen1"] = csi_t::csi24(84, 255, 159);
    table["SeaGreen2"] = csi_t::csi24(78, 238, 148);
    table["SeaGreen3"] = csi_t::csi24(67, 205, 128);
    table["SeaGreen4"] = csi_t::csi24(46, 139, 87);
    table["PaleGreen1"] = csi_t::csi24(154, 255, 154);
    table["PaleGreen2"] = csi_t::csi24(144, 238, 144);
    table["PaleGreen3"] = csi_t::csi24(124, 205, 124);
    table["PaleGreen4"] = csi_t::csi24(84, 139, 84);
    table["SpringGreen1"] = csi_t::csi24(0, 255, 127);
    table["SpringGreen2"] = csi_t::csi24(0, 238, 118);
    table["SpringGreen3"] = csi_t::csi24(0, 205, 102);
    table["SpringGreen4"] = csi_t::csi24(0, 139, 69);
    table["green1"] = csi_t::csi24(0, 255, 0);
    table["green2"] = csi_t::csi24(0, 238, 0);
    table["green3"] = csi_t::csi24(0, 205, 0);
    table["green4"] = csi_t::csi24(0, 139, 0);
    table["chartreuse1"] = csi_t::csi24(127, 255, 0);
    table["chartreuse2"] = csi_t::csi24(118, 238, 0);
    table["chartreuse3"] = csi_t::csi24(102, 205, 0);
    table["chartreuse4"] = csi_t::csi24(69, 139, 0);
    table["OliveDrab1"] = csi_t::csi24(192, 255, 62);
    table["OliveDrab2"] = csi_t::csi24(179, 238, 58);
    table["OliveDrab3"] = csi_t::csi24(154, 205, 50);
    table["OliveDrab4"] = csi_t::csi24(105, 139, 34);
    table["DarkOliveGreen1"] = csi_t::csi24(202, 255, 112);
    table["DarkOliveGreen2"] = csi_t::csi24(188, 238, 104);
    table["DarkOliveGreen3"] = csi_t::csi24(162, 205, 90);
    table["DarkOliveGreen4"] = csi_t::csi24(110, 139, 61);
    table["khaki1"] = csi_t::csi24(255, 246, 143);
    table["khaki2"] = csi_t::csi24(238, 230, 133);
    table["khaki3"] = csi_t::csi24(205, 198, 115);
    table["khaki4"] = csi_t::csi24(139, 134, 78);
    table["LightGoldenrod1"] = csi_t::csi24(255, 236, 139);
    table["LightGoldenrod2"] = csi_t::csi24(238, 220, 130);
    table["LightGoldenrod3"] = csi_t::csi24(205, 190, 112);
    table["LightGoldenrod4"] = csi_t::csi24(139, 129, 76);
    table["LightYellow1"] = csi_t::csi24(255, 255, 224);
    table["LightYellow2"] = csi_t::csi24(238, 238, 209);
    table["LightYellow3"] = csi_t::csi24(205, 205, 180);
    table["LightYellow4"] = csi_t::csi24(139, 139, 122);
    table["yellow1"] = csi_t::csi24(255, 255, 0);
    table["yellow2"] = csi_t::csi24(238, 238, 0);
    table["yellow3"] = csi_t::csi24(205, 205, 0);
    table["yellow4"] = csi_t::csi24(139, 139, 0);
    table["gold1"] = csi_t::csi24(255, 215, 0);
    table["gold2"] = csi_t::csi24(238, 201, 0);
    table["gold3"] = csi_t::csi24(205, 173, 0);
    table["gold4"] = csi_t::csi24(139, 117, 0);
    table["goldenrod1"] = csi_t::csi24(255, 193, 37);
    table["goldenrod2"] = csi_t::csi24(238, 180, 34);
    table["goldenrod3"] = csi_t::csi24(205, 155, 29);
    table["goldenrod4"] = csi_t::csi24(139, 105, 20);
    table["DarkGoldenrod1"] = csi_t::csi24(255, 185, 15);
    table["DarkGoldenrod2"] = csi_t::csi24(238, 173, 14);
    table["DarkGoldenrod3"] = csi_t::csi24(205, 149, 12);
    table["DarkGoldenrod4"] = csi_t::csi24(139, 101, 8);
    table["RosyBrown1"] = csi_t::csi24(255, 193, 193);
    table["RosyBrown2"] = csi_t::csi24(238, 180, 180);
    table["RosyBrown3"] = csi_t::csi24(205, 155, 155);
    table["RosyBrown4"] = csi_t::csi24(139, 105, 105);
    table["IndianRed1"] = csi_t::csi24(255, 106, 106);
    table["IndianRed2"] = csi_t::csi24(238, 99, 99);
    table["IndianRed3"] = csi_t::csi24(205, 85, 85);
    table["IndianRed4"] = csi_t::csi24(139, 58, 58);
    table["sienna1"] = csi_t::csi24(255, 130, 71);
    table["sienna2"] = csi_t::csi24(238, 121, 66);
    table["sienna3"] = csi_t::csi24(205, 104, 57);
    table["sienna4"] = csi_t::csi24(139, 71, 38);
    table["burlywood1"] = csi_t::csi24(255, 211, 155);
    table["burlywood2"] = csi_t::csi24(238, 197, 145);
    table["burlywood3"] = csi_t::csi24(205, 170, 125);
    table["burlywood4"] = csi_t::csi24(139, 115, 85);
    table["wheat1"] = csi_t::csi24(255, 231, 186);
    table["wheat2"] = csi_t::csi24(238, 216, 174);
    table["wheat3"] = csi_t::csi24(205, 186, 150);
    table["wheat4"] = csi_t::csi24(139, 126, 102);
    table["tan1"] = csi_t::csi24(255, 165, 79);
    table["tan2"] = csi_t::csi24(238, 154, 73);
    table["tan3"] = csi_t::csi24(205, 133, 63);
    table["tan4"] = csi_t::csi24(139, 90, 43);
    table["chocolate1"] = csi_t::csi24(255, 127, 36);
    table["chocolate2"] = csi_t::csi24(238, 118, 33);
    table["chocolate3"] = csi_t::csi24(205, 102, 29);
    table["chocolate4"] = csi_t::csi24(139, 69, 19);
    table["firebrick1"] = csi_t::csi24(255, 48, 48);
    table["firebrick2"] = csi_t::csi24(238, 44, 44);
    table["firebrick3"] = csi_t::csi24(205, 38, 38);
    table["firebrick4"] = csi_t::csi24(139, 26, 26);
    table["brown1"] = csi_t::csi24(255, 64, 64);
    table["brown2"] = csi_t::csi24(238, 59, 59);
    table["brown3"] = csi_t::csi24(205, 51, 51);
    table["brown4"] = csi_t::csi24(139, 35, 35);
    table["salmon1"] = csi_t::csi24(255, 140, 105);
    table["salmon2"] = csi_t::csi24(238, 130, 98);
    table["salmon3"] = csi_t::csi24(205, 112, 84);
    table["salmon4"] = csi_t::csi24(139, 76, 57);
    table["LightSalmon1"] = csi_t::csi24(255, 160, 122);
    table["LightSalmon2"] = csi_t::csi24(238, 149, 114);
    table["LightSalmon3"] = csi_t::csi24(205, 129, 98);
    table["LightSalmon4"] = csi_t::csi24(139, 87, 66);
    table["orange1"] = csi_t::csi24(255, 165, 0);
    table["orange2"] = csi_t::csi24(238, 154, 0);
    table["orange3"] = csi_t::csi24(205, 133, 0);
    table["orange4"] = csi_t::csi24(139, 90, 0);
    table["DarkOrange1"] = csi_t::csi24(255, 127, 0);
    table["DarkOrange2"] = csi_t::csi24(238, 118, 0);
    table["DarkOrange3"] = csi_t::csi24(205, 102, 0);
    table["DarkOrange4"] = csi_t::csi24(139, 69, 0);
    table["coral1"] = csi_t::csi24(255, 114, 86);
    table["coral2"] = csi_t::csi24(238, 106, 80);
    table["coral3"] = csi_t::csi24(205, 91, 69);
    table["coral4"] = csi_t::csi24(139, 62, 47);
    table["tomato1"] = csi_t::csi24(255, 99, 71);
    table["tomato2"] = csi_t::csi24(238, 92, 66);
    table["tomato3"] = csi_t::csi24(205, 79, 57);
    table["tomato4"] = csi_t::csi24(139, 54, 38);
    table["OrangeRed1"] = csi_t::csi24(255, 69, 0);
    table["OrangeRed2"] = csi_t::csi24(238, 64, 0);
    table["OrangeRed3"] = csi_t::csi24(205, 55, 0);
    table["OrangeRed4"] = csi_t::csi24(139, 37, 0);
    table["red1"] = csi_t::csi24(255, 0, 0);
    table["red2"] = csi_t::csi24(238, 0, 0);
    table["red3"] = csi_t::csi24(205, 0, 0);
    table["red4"] = csi_t::csi24(139, 0, 0);
    table["DeepPink1"] = csi_t::csi24(255, 20, 147);
    table["DeepPink2"] = csi_t::csi24(238, 18, 137);
    table["DeepPink3"] = csi_t::csi24(205, 16, 118);
    table["DeepPink4"] = csi_t::csi24(139, 10, 80);
    table["HotPink1"] = csi_t::csi24(255, 110, 180);
    table["HotPink2"] = csi_t::csi24(238, 106, 167);
    table["HotPink3"] = csi_t::csi24(205, 96, 144);
    table["HotPink4"] = csi_t::csi24(139, 58, 98);
    table["pink1"] = csi_t::csi24(255, 181, 197);
    table["pink2"] = csi_t::csi24(238, 169, 184);
    table["pink3"] = csi_t::csi24(205, 145, 158);
    table["pink4"] = csi_t::csi24(139, 99, 108);
    table["LightPink1"] = csi_t::csi24(255, 174, 185);
    table["LightPink2"] = csi_t::csi24(238, 162, 173);
    table["LightPink3"] = csi_t::csi24(205, 140, 149);
    table["LightPink4"] = csi_t::csi24(139, 95, 101);
    table["PaleVioletRed1"] = csi_t::csi24(255, 130, 171);
    table["PaleVioletRed2"] = csi_t::csi24(238, 121, 159);
    table["PaleVioletRed3"] = csi_t::csi24(205, 104, 137);
    table["PaleVioletRed4"] = csi_t::csi24(139, 71, 93);
    table["maroon1"] = csi_t::csi24(255, 52, 179);
    table["maroon2"] = csi_t::csi24(238, 48, 167);
    table["maroon3"] = csi_t::csi24(205, 41, 144);
    table["maroon4"] = csi_t::csi24(139, 28, 98);
    table["VioletRed1"] = csi_t::csi24(255, 62, 150);
    table["VioletRed2"] = csi_t::csi24(238, 58, 140);
    table["VioletRed3"] = csi_t::csi24(205, 50, 120);
    table["VioletRed4"] = csi_t::csi24(139, 34, 82);
    table["magenta1"] = csi_t::csi24(255, 0, 255);
    table["magenta2"] = csi_t::csi24(238, 0, 238);
    table["magenta3"] = csi_t::csi24(205, 0, 205);
    table["magenta4"] = csi_t::csi24(139, 0, 139);
    table["orchid1"] = csi_t::csi24(255, 131, 250);
    table["orchid2"] = csi_t::csi24(238, 122, 233);
    table["orchid3"] = csi_t::csi24(205, 105, 201);
    table["orchid4"] = csi_t::csi24(139, 71, 137);
    table["plum1"] = csi_t::csi24(255, 187, 255);
    table["plum2"] = csi_t::csi24(238, 174, 238);
    table["plum3"] = csi_t::csi24(205, 150, 205);
    table["plum4"] = csi_t::csi24(139, 102, 139);
    table["MediumOrchid1"] = csi_t::csi24(224, 102, 255);
    table["MediumOrchid2"] = csi_t::csi24(209, 95, 238);
    table["MediumOrchid3"] = csi_t::csi24(180, 82, 205);
    table["MediumOrchid4"] = csi_t::csi24(122, 55, 139);
    table["DarkOrchid1"] = csi_t::csi24(191, 62, 255);
    table["DarkOrchid2"] = csi_t::csi24(178, 58, 238);
    table["DarkOrchid3"] = csi_t::csi24(154, 50, 205);
    table["DarkOrchid4"] = csi_t::csi24(104, 34, 139);
    table["purple1"] = csi_t::csi24(155, 48, 255);
    table["purple2"] = csi_t::csi24(145, 44, 238);
    table["purple3"] = csi_t::csi24(125, 38, 205);
    table["purple4"] = csi_t::csi24(85, 26, 139);
    table["MediumPurple1"] = csi_t::csi24(171, 130, 255);
    table["MediumPurple2"] = csi_t::csi24(159, 121, 238);
    table["MediumPurple3"] = csi_t::csi24(137, 104, 205);
    table["MediumPurple4"] = csi_t::csi24(93, 71, 139);
    table["thistle1"] = csi_t::csi24(255, 225, 255);
    table["thistle2"] = csi_t::csi24(238, 210, 238);
    table["thistle3"] = csi_t::csi24(205, 181, 205);
    table["thistle4"] = csi_t::csi24(139, 123, 139);
    table["gray0"] = csi_t::csi24(0, 0, 0);
    table["grey0"] = csi_t::csi24(0, 0, 0);
    table["gray1"] = csi_t::csi24(3, 3, 3);
    table["grey1"] = csi_t::csi24(3, 3, 3);
    table["gray2"] = csi_t::csi24(5, 5, 5);
    table["grey2"] = csi_t::csi24(5, 5, 5);
    table["gray3"] = csi_t::csi24(8, 8, 8);
    table["grey3"] = csi_t::csi24(8, 8, 8);
    table["gray4"] = csi_t::csi24(10, 10, 10);
    table["grey4"] = csi_t::csi24(10, 10, 10);
    table["gray5"] = csi_t::csi24(13, 13, 13);
    table["grey5"] = csi_t::csi24(13, 13, 13);
    table["gray6"] = csi_t::csi24(15, 15, 15);
    table["grey6"] = csi_t::csi24(15, 15, 15);
    table["gray7"] = csi_t::csi24(18, 18, 18);
    table["grey7"] = csi_t::csi24(18, 18, 18);
    table["gray8"] = csi_t::csi24(20, 20, 20);
    table["grey8"] = csi_t::csi24(20, 20, 20);
    table["gray9"] = csi_t::csi24(23, 23, 23);
    table["grey9"] = csi_t::csi24(23, 23, 23);
    table["gray10"] = csi_t::csi24(26, 26, 26);
    table["grey10"] = csi_t::csi24(26, 26, 26);
    table["gray11"] = csi_t::csi24(28, 28, 28);
    table["grey11"] = csi_t::csi24(28, 28, 28);
    table["gray12"] = csi_t::csi24(31, 31, 31);
    table["grey12"] = csi_t::csi24(31, 31, 31);
    table["gray13"] = csi_t::csi24(33, 33, 33);
    table["grey13"] = csi_t::csi24(33, 33, 33);
    table["gray14"] = csi_t::csi24(36, 36, 36);
    table["grey14"] = csi_t::csi24(36, 36, 36);
    table["gray15"] = csi_t::csi24(38, 38, 38);
    table["grey15"] = csi_t::csi24(38, 38, 38);
    table["gray16"] = csi_t::csi24(41, 41, 41);
    table["grey16"] = csi_t::csi24(41, 41, 41);
    table["gray17"] = csi_t::csi24(43, 43, 43);
    table["grey17"] = csi_t::csi24(43, 43, 43);
    table["gray18"] = csi_t::csi24(46, 46, 46);
    table["grey18"] = csi_t::csi24(46, 46, 46);
    table["gray19"] = csi_t::csi24(48, 48, 48);
    table["grey19"] = csi_t::csi24(48, 48, 48);
    table["gray20"] = csi_t::csi24(51, 51, 51);
    table["grey20"] = csi_t::csi24(51, 51, 51);
    table["gray21"] = csi_t::csi24(54, 54, 54);
    table["grey21"] = csi_t::csi24(54, 54, 54);
    table["gray22"] = csi_t::csi24(56, 56, 56);
    table["grey22"] = csi_t::csi24(56, 56, 56);
    table["gray23"] = csi_t::csi24(59, 59, 59);
    table["grey23"] = csi_t::csi24(59, 59, 59);
    table["gray24"] = csi_t::csi24(61, 61, 61);
    table["grey24"] = csi_t::csi24(61, 61, 61);
    table["gray25"] = csi_t::csi24(64, 64, 64);
    table["grey25"] = csi_t::csi24(64, 64, 64);
    table["gray26"] = csi_t::csi24(66, 66, 66);
    table["grey26"] = csi_t::csi24(66, 66, 66);
    table["gray27"] = csi_t::csi24(69, 69, 69);
    table["grey27"] = csi_t::csi24(69, 69, 69);
    table["gray28"] = csi_t::csi24(71, 71, 71);
    table["grey28"] = csi_t::csi24(71, 71, 71);
    table["gray29"] = csi_t::csi24(74, 74, 74);
    table["grey29"] = csi_t::csi24(74, 74, 74);
    table["gray30"] = csi_t::csi24(77, 77, 77);
    table["grey30"] = csi_t::csi24(77, 77, 77);
    table["gray31"] = csi_t::csi24(79, 79, 79);
    table["grey31"] = csi_t::csi24(79, 79, 79);
    table["gray32"] = csi_t::csi24(82, 82, 82);
    table["grey32"] = csi_t::csi24(82, 82, 82);
    table["gray33"] = csi_t::csi24(84, 84, 84);
    table["grey33"] = csi_t::csi24(84, 84, 84);
    table["gray34"] = csi_t::csi24(87, 87, 87);
    table["grey34"] = csi_t::csi24(87, 87, 87);
    table["gray35"] = csi_t::csi24(89, 89, 89);
    table["grey35"] = csi_t::csi24(89, 89, 89);
    table["gray36"] = csi_t::csi24(92, 92, 92);
    table["grey36"] = csi_t::csi24(92, 92, 92);
    table["gray37"] = csi_t::csi24(94, 94, 94);
    table["grey37"] = csi_t::csi24(94, 94, 94);
    table["gray38"] = csi_t::csi24(97, 97, 97);
    table["grey38"] = csi_t::csi24(97, 97, 97);
    table["gray39"] = csi_t::csi24(99, 99, 99);
    table["grey39"] = csi_t::csi24(99, 99, 99);
    table["gray40"] = csi_t::csi24(102, 102, 102);
    table["grey40"] = csi_t::csi24(102, 102, 102);
    table["gray41"] = csi_t::csi24(105, 105, 105);
    table["grey41"] = csi_t::csi24(105, 105, 105);
    table["gray42"] = csi_t::csi24(107, 107, 107);
    table["grey42"] = csi_t::csi24(107, 107, 107);
    table["gray43"] = csi_t::csi24(110, 110, 110);
    table["grey43"] = csi_t::csi24(110, 110, 110);
    table["gray44"] = csi_t::csi24(112, 112, 112);
    table["grey44"] = csi_t::csi24(112, 112, 112);
    table["gray45"] = csi_t::csi24(115, 115, 115);
    table["grey45"] = csi_t::csi24(115, 115, 115);
    table["gray46"] = csi_t::csi24(117, 117, 117);
    table["grey46"] = csi_t::csi24(117, 117, 117);
    table["gray47"] = csi_t::csi24(120, 120, 120);
    table["grey47"] = csi_t::csi24(120, 120, 120);
    table["gray48"] = csi_t::csi24(122, 122, 122);
    table["grey48"] = csi_t::csi24(122, 122, 122);
    table["gray49"] = csi_t::csi24(125, 125, 125);
    table["grey49"] = csi_t::csi24(125, 125, 125);
    table["gray50"] = csi_t::csi24(127, 127, 127);
    table["grey50"] = csi_t::csi24(127, 127, 127);
    table["gray51"] = csi_t::csi24(130, 130, 130);
    table["grey51"] = csi_t::csi24(130, 130, 130);
    table["gray52"] = csi_t::csi24(133, 133, 133);
    table["grey52"] = csi_t::csi24(133, 133, 133);
    table["gray53"] = csi_t::csi24(135, 135, 135);
    table["grey53"] = csi_t::csi24(135, 135, 135);
    table["gray54"] = csi_t::csi24(138, 138, 138);
    table["grey54"] = csi_t::csi24(138, 138, 138);
    table["gray55"] = csi_t::csi24(140, 140, 140);
    table["grey55"] = csi_t::csi24(140, 140, 140);
    table["gray56"] = csi_t::csi24(143, 143, 143);
    table["grey56"] = csi_t::csi24(143, 143, 143);
    table["gray57"] = csi_t::csi24(145, 145, 145);
    table["grey57"] = csi_t::csi24(145, 145, 145);
    table["gray58"] = csi_t::csi24(148, 148, 148);
    table["grey58"] = csi_t::csi24(148, 148, 148);
    table["gray59"] = csi_t::csi24(150, 150, 150);
    table["grey59"] = csi_t::csi24(150, 150, 150);
    table["gray60"] = csi_t::csi24(153, 153, 153);
    table["grey60"] = csi_t::csi24(153, 153, 153);
    table["gray61"] = csi_t::csi24(156, 156, 156);
    table["grey61"] = csi_t::csi24(156, 156, 156);
    table["gray62"] = csi_t::csi24(158, 158, 158);
    table["grey62"] = csi_t::csi24(158, 158, 158);
    table["gray63"] = csi_t::csi24(161, 161, 161);
    table["grey63"] = csi_t::csi24(161, 161, 161);
    table["gray64"] = csi_t::csi24(163, 163, 163);
    table["grey64"] = csi_t::csi24(163, 163, 163);
    table["gray65"] = csi_t::csi24(166, 166, 166);
    table["grey65"] = csi_t::csi24(166, 166, 166);
    table["gray66"] = csi_t::csi24(168, 168, 168);
    table["grey66"] = csi_t::csi24(168, 168, 168);
    table["gray67"] = csi_t::csi24(171, 171, 171);
    table["grey67"] = csi_t::csi24(171, 171, 171);
    table["gray68"] = csi_t::csi24(173, 173, 173);
    table["grey68"] = csi_t::csi24(173, 173, 173);
    table["gray69"] = csi_t::csi24(176, 176, 176);
    table["grey69"] = csi_t::csi24(176, 176, 176);
    table["gray70"] = csi_t::csi24(179, 179, 179);
    table["grey70"] = csi_t::csi24(179, 179, 179);
    table["gray71"] = csi_t::csi24(181, 181, 181);
    table["grey71"] = csi_t::csi24(181, 181, 181);
    table["gray72"] = csi_t::csi24(184, 184, 184);
    table["grey72"] = csi_t::csi24(184, 184, 184);
    table["gray73"] = csi_t::csi24(186, 186, 186);
    table["grey73"] = csi_t::csi24(186, 186, 186);
    table["gray74"] = csi_t::csi24(189, 189, 189);
    table["grey74"] = csi_t::csi24(189, 189, 189);
    table["gray75"] = csi_t::csi24(191, 191, 191);
    table["grey75"] = csi_t::csi24(191, 191, 191);
    table["gray76"] = csi_t::csi24(194, 194, 194);
    table["grey76"] = csi_t::csi24(194, 194, 194);
    table["gray77"] = csi_t::csi24(196, 196, 196);
    table["grey77"] = csi_t::csi24(196, 196, 196);
    table["gray78"] = csi_t::csi24(199, 199, 199);
    table["grey78"] = csi_t::csi24(199, 199, 199);
    table["gray79"] = csi_t::csi24(201, 201, 201);
    table["grey79"] = csi_t::csi24(201, 201, 201);
    table["gray80"] = csi_t::csi24(204, 204, 204);
    table["grey80"] = csi_t::csi24(204, 204, 204);
    table["gray81"] = csi_t::csi24(207, 207, 207);
    table["grey81"] = csi_t::csi24(207, 207, 207);
    table["gray82"] = csi_t::csi24(209, 209, 209);
    table["grey82"] = csi_t::csi24(209, 209, 209);
    table["gray83"] = csi_t::csi24(212, 212, 212);
    table["grey83"] = csi_t::csi24(212, 212, 212);
    table["gray84"] = csi_t::csi24(214, 214, 214);
    table["grey84"] = csi_t::csi24(214, 214, 214);
    table["gray85"] = csi_t::csi24(217, 217, 217);
    table["grey85"] = csi_t::csi24(217, 217, 217);
    table["gray86"] = csi_t::csi24(219, 219, 219);
    table["grey86"] = csi_t::csi24(219, 219, 219);
    table["gray87"] = csi_t::csi24(222, 222, 222);
    table["grey87"] = csi_t::csi24(222, 222, 222);
    table["gray88"] = csi_t::csi24(224, 224, 224);
    table["grey88"] = csi_t::csi24(224, 224, 224);
    table["gray89"] = csi_t::csi24(227, 227, 227);
    table["grey89"] = csi_t::csi24(227, 227, 227);
    table["gray90"] = csi_t::csi24(229, 229, 229);
    table["grey90"] = csi_t::csi24(229, 229, 229);
    table["gray91"] = csi_t::csi24(232, 232, 232);
    table["grey91"] = csi_t::csi24(232, 232, 232);
    table["gray92"] = csi_t::csi24(235, 235, 235);
    table["grey92"] = csi_t::csi24(235, 235, 235);
    table["gray93"] = csi_t::csi24(237, 237, 237);
    table["grey93"] = csi_t::csi24(237, 237, 237);
    table["gray94"] = csi_t::csi24(240, 240, 240);
    table["grey94"] = csi_t::csi24(240, 240, 240);
    table["gray95"] = csi_t::csi24(242, 242, 242);
    table["grey95"] = csi_t::csi24(242, 242, 242);
    table["gray96"] = csi_t::csi24(245, 245, 245);
    table["grey96"] = csi_t::csi24(245, 245, 245);
    table["gray97"] = csi_t::csi24(247, 247, 247);
    table["grey97"] = csi_t::csi24(247, 247, 247);
    table["gray98"] = csi_t::csi24(250, 250, 250);
    table["grey98"] = csi_t::csi24(250, 250, 250);
    table["gray99"] = csi_t::csi24(252, 252, 252);
    table["grey99"] = csi_t::csi24(252, 252, 252);
    table["gray100"] = csi_t::csi24(255, 255, 255);
    table["grey100"] = csi_t::csi24(255, 255, 255);
    table["dark grey"] = csi_t::csi24(169, 169, 169);
    table["DarkGrey"] = csi_t::csi24(169, 169, 169);
    table["dark gray"] = csi_t::csi24(169, 169, 169);
    table["DarkGray"] = csi_t::csi24(169, 169, 169);
    table["dark blue"] = csi_t::csi24(0, 0, 139);
    table["DarkBlue"] = csi_t::csi24(0, 0, 139);
    table["dark cyan"] = csi_t::csi24(0, 139, 139);
    table["DarkCyan"] = csi_t::csi24(0, 139, 139);
    table["dark magenta"] = csi_t::csi24(139, 0, 139);
    table["DarkMagenta"] = csi_t::csi24(139, 0, 139);
    table["dark red"] = csi_t::csi24(139, 0, 0);
    table["DarkRed"] = csi_t::csi24(139, 0, 0);
    table["light green"] = csi_t::csi24(144, 238, 144);
    table["LightGreen"] = csi_t::csi24(144, 238, 144);
    table["crimson"] = csi_t::csi24(220, 20, 60);
    table["indigo"] = csi_t::csi24(75, 0, 130);
    table["olive"] = csi_t::csi24(128, 128, 0);
    table["rebecca purple"] = csi_t::csi24(102, 51, 153);
    table["RebeccaPurple"] = csi_t::csi24(102, 51, 153);
    table["silver"] = csi_t::csi24(192, 192, 192);
    table["teal"] = csi_t::csi24(0, 128, 128);

    // all done
    return table;
}


// end of file
