# -*- coding: utf-8 -*-
#
# michael a.g. aïvázis <michael.aivazis@para-sim.com>
# (c) 1998-2023 all rights reserved


# get the control sequence generator
from .CSI import CSI


# the table of color names to ANSI control sequences
table = {
    # the reset sequence
    "normal": CSI.reset(),

    # the X11 named colors
    "snow": CSI.csi24(red=255, green=250, blue=250),
    "ghost white": CSI.csi24(red=248, green=248, blue=255),
    "GhostWhite": CSI.csi24(red=248, green=248, blue=255),
    "white smoke": CSI.csi24(red=245, green=245, blue=245),
    "WhiteSmoke": CSI.csi24(red=245, green=245, blue=245),
    "gainsboro": CSI.csi24(red=220, green=220, blue=220),
    "floral white": CSI.csi24(red=255, green=250, blue=240),
    "FloralWhite": CSI.csi24(red=255, green=250, blue=240),
    "old lace": CSI.csi24(red=253, green=245, blue=230),
    "OldLace": CSI.csi24(red=253, green=245, blue=230),
    "linen": CSI.csi24(red=250, green=240, blue=230),
    "antique white": CSI.csi24(red=250, green=235, blue=215),
    "AntiqueWhite": CSI.csi24(red=250, green=235, blue=215),
    "papaya whip": CSI.csi24(red=255, green=239, blue=213),
    "PapayaWhip": CSI.csi24(red=255, green=239, blue=213),
    "blanched almond": CSI.csi24(red=255, green=235, blue=205),
    "BlanchedAlmond": CSI.csi24(red=255, green=235, blue=205),
    "bisque": CSI.csi24(red=255, green=228, blue=196),
    "peach puff": CSI.csi24(red=255, green=218, blue=185),
    "PeachPuff": CSI.csi24(red=255, green=218, blue=185),
    "navajo white": CSI.csi24(red=255, green=222, blue=173),
    "NavajoWhite": CSI.csi24(red=255, green=222, blue=173),
    "moccasin": CSI.csi24(red=255, green=228, blue=181),
    "cornsilk": CSI.csi24(red=255, green=248, blue=220),
    "ivory": CSI.csi24(red=255, green=255, blue=240),
    "lemon chiffon": CSI.csi24(red=255, green=250, blue=205),
    "LemonChiffon": CSI.csi24(red=255, green=250, blue=205),
    "seashell": CSI.csi24(red=255, green=245, blue=238),
    "honeydew": CSI.csi24(red=240, green=255, blue=240),
    "mint cream": CSI.csi24(red=245, green=255, blue=250),
    "MintCream": CSI.csi24(red=245, green=255, blue=250),
    "azure": CSI.csi24(red=240, green=255, blue=255),
    "alice blue": CSI.csi24(red=240, green=248, blue=255),
    "AliceBlue": CSI.csi24(red=240, green=248, blue=255),
    "lavender": CSI.csi24(red=230, green=230, blue=250),
    "lavender blush": CSI.csi24(red=255, green=240, blue=245),
    "LavenderBlush": CSI.csi24(red=255, green=240, blue=245),
    "misty rose": CSI.csi24(red=255, green=228, blue=225),
    "MistyRose": CSI.csi24(red=255, green=228, blue=225),
    "white": CSI.csi24(red=255, green=255, blue=255),
    "black": CSI.csi24(red=0, green=0, blue=0),
    "dark slate gray": CSI.csi24(red=47, green=79, blue=79),
    "DarkSlateGray": CSI.csi24(red=47, green=79, blue=79),
    "dark slate grey": CSI.csi24(red=47, green=79, blue=79),
    "DarkSlateGrey": CSI.csi24(red=47, green=79, blue=79),
    "dim gray": CSI.csi24(red=105, green=105, blue=105),
    "DimGray": CSI.csi24(red=105, green=105, blue=105),
    "dim grey": CSI.csi24(red=105, green=105, blue=105),
    "DimGrey": CSI.csi24(red=105, green=105, blue=105),
    "slate gray": CSI.csi24(red=112, green=128, blue=144),
    "SlateGray": CSI.csi24(red=112, green=128, blue=144),
    "slate grey": CSI.csi24(red=112, green=128, blue=144),
    "SlateGrey": CSI.csi24(red=112, green=128, blue=144),
    "light slate gray": CSI.csi24(red=119, green=136, blue=153),
    "LightSlateGray": CSI.csi24(red=119, green=136, blue=153),
    "light slate grey": CSI.csi24(red=119, green=136, blue=153),
    "LightSlateGrey": CSI.csi24(red=119, green=136, blue=153),
    "gray": CSI.csi24(red=190, green=190, blue=190),
    "grey": CSI.csi24(red=190, green=190, blue=190),
    "x11 gray": CSI.csi24(red=190, green=190, blue=190),
    "X11Gray": CSI.csi24(red=190, green=190, blue=190),
    "x11 grey": CSI.csi24(red=190, green=190, blue=190),
    "X11Grey": CSI.csi24(red=190, green=190, blue=190),
    "web gray": CSI.csi24(red=128, green=128, blue=128),
    "WebGray": CSI.csi24(red=128, green=128, blue=128),
    "web grey": CSI.csi24(red=128, green=128, blue=128),
    "WebGrey": CSI.csi24(red=128, green=128, blue=128),
    "light grey": CSI.csi24(red=211, green=211, blue=211),
    "LightGrey": CSI.csi24(red=211, green=211, blue=211),
    "light gray": CSI.csi24(red=211, green=211, blue=211),
    "LightGray": CSI.csi24(red=211, green=211, blue=211),
    "midnight blue": CSI.csi24(red=25, green=25, blue=112),
    "MidnightBlue": CSI.csi24(red=25, green=25, blue=112),
    "navy": CSI.csi24(red=0, green=0, blue=128),
    "navy blue": CSI.csi24(red=0, green=0, blue=128),
    "NavyBlue": CSI.csi24(red=0, green=0, blue=128),
    "cornflower blue": CSI.csi24(red=100, green=149, blue=237),
    "CornflowerBlue": CSI.csi24(red=100, green=149, blue=237),
    "dark slate blue": CSI.csi24(red=72, green=61, blue=139),
    "DarkSlateBlue": CSI.csi24(red=72, green=61, blue=139),
    "slate blue": CSI.csi24(red=106, green=90, blue=205),
    "SlateBlue": CSI.csi24(red=106, green=90, blue=205),
    "medium slate blue": CSI.csi24(red=123, green=104, blue=238),
    "MediumSlateBlue": CSI.csi24(red=123, green=104, blue=238),
    "light slate blue": CSI.csi24(red=132, green=112, blue=255),
    "LightSlateBlue": CSI.csi24(red=132, green=112, blue=255),
    "medium blue": CSI.csi24(red=0, green=0, blue=205),
    "MediumBlue": CSI.csi24(red=0, green=0, blue=205),
    "royal blue": CSI.csi24(red=65, green=105, blue=225),
    "RoyalBlue": CSI.csi24(red=65, green=105, blue=225),
    "blue": CSI.csi24(red=0, green=0, blue=255),
    "dodger blue": CSI.csi24(red=30, green=144, blue=255),
    "DodgerBlue": CSI.csi24(red=30, green=144, blue=255),
    "deep sky blue": CSI.csi24(red=0, green=191, blue=255),
    "DeepSkyBlue": CSI.csi24(red=0, green=191, blue=255),
    "sky blue": CSI.csi24(red=135, green=206, blue=235),
    "SkyBlue": CSI.csi24(red=135, green=206, blue=235),
    "light sky blue": CSI.csi24(red=135, green=206, blue=250),
    "LightSkyBlue": CSI.csi24(red=135, green=206, blue=250),
    "steel blue": CSI.csi24(red=70, green=130, blue=180),
    "SteelBlue": CSI.csi24(red=70, green=130, blue=180),
    "light steel blue": CSI.csi24(red=176, green=196, blue=222),
    "LightSteelBlue": CSI.csi24(red=176, green=196, blue=222),
    "light blue": CSI.csi24(red=173, green=216, blue=230),
    "LightBlue": CSI.csi24(red=173, green=216, blue=230),
    "powder blue": CSI.csi24(red=176, green=224, blue=230),
    "PowderBlue": CSI.csi24(red=176, green=224, blue=230),
    "pale turquoise": CSI.csi24(red=175, green=238, blue=238),
    "PaleTurquoise": CSI.csi24(red=175, green=238, blue=238),
    "dark turquoise": CSI.csi24(red=0, green=206, blue=209),
    "DarkTurquoise": CSI.csi24(red=0, green=206, blue=209),
    "medium turquoise": CSI.csi24(red=72, green=209, blue=204),
    "MediumTurquoise": CSI.csi24(red=72, green=209, blue=204),
    "turquoise": CSI.csi24(red=64, green=224, blue=208),
    "cyan": CSI.csi24(red=0, green=255, blue=255),
    "aqua": CSI.csi24(red=0, green=255, blue=255),
    "light cyan": CSI.csi24(red=224, green=255, blue=255),
    "LightCyan": CSI.csi24(red=224, green=255, blue=255),
    "cadet blue": CSI.csi24(red=95, green=158, blue=160),
    "CadetBlue": CSI.csi24(red=95, green=158, blue=160),
    "medium aquamarine": CSI.csi24(red=102, green=205, blue=170),
    "MediumAquamarine": CSI.csi24(red=102, green=205, blue=170),
    "aquamarine": CSI.csi24(red=127, green=255, blue=212),
    "dark green": CSI.csi24(red=0, green=100, blue=0),
    "DarkGreen": CSI.csi24(red=0, green=100, blue=0),
    "dark olive green": CSI.csi24(red=85, green=107, blue=47),
    "DarkOliveGreen": CSI.csi24(red=85, green=107, blue=47),
    "dark sea green": CSI.csi24(red=143, green=188, blue=143),
    "DarkSeaGreen": CSI.csi24(red=143, green=188, blue=143),
    "sea green": CSI.csi24(red=46, green=139, blue=87),
    "SeaGreen": CSI.csi24(red=46, green=139, blue=87),
    "medium sea green": CSI.csi24(red=60, green=179, blue=113),
    "MediumSeaGreen": CSI.csi24(red=60, green=179, blue=113),
    "light sea green": CSI.csi24(red=32, green=178, blue=170),
    "LightSeaGreen": CSI.csi24(red=32, green=178, blue=170),
    "pale green": CSI.csi24(red=152, green=251, blue=152),
    "PaleGreen": CSI.csi24(red=152, green=251, blue=152),
    "spring green": CSI.csi24(red=0, green=255, blue=127),
    "SpringGreen": CSI.csi24(red=0, green=255, blue=127),
    "lawn green": CSI.csi24(red=124, green=252, blue=0),
    "LawnGreen": CSI.csi24(red=124, green=252, blue=0),
    "green": CSI.csi24(red=0, green=255, blue=0),
    "lime": CSI.csi24(red=0, green=255, blue=0),
    "x11 green": CSI.csi24(red=0, green=255, blue=0),
    "X11Green": CSI.csi24(red=0, green=255, blue=0),
    "web green": CSI.csi24(red=0, green=128, blue=0),
    "WebGreen": CSI.csi24(red=0, green=128, blue=0),
    "chartreuse": CSI.csi24(red=127, green=255, blue=0),
    "medium spring green": CSI.csi24(red=0, green=250, blue=154),
    "MediumSpringGreen": CSI.csi24(red=0, green=250, blue=154),
    "green yellow": CSI.csi24(red=173, green=255, blue=47),
    "GreenYellow": CSI.csi24(red=173, green=255, blue=47),
    "lime green": CSI.csi24(red=50, green=205, blue=50),
    "LimeGreen": CSI.csi24(red=50, green=205, blue=50),
    "yellow green": CSI.csi24(red=154, green=205, blue=50),
    "YellowGreen": CSI.csi24(red=154, green=205, blue=50),
    "forest green": CSI.csi24(red=34, green=139, blue=34),
    "ForestGreen": CSI.csi24(red=34, green=139, blue=34),
    "olive drab": CSI.csi24(red=107, green=142, blue=35),
    "OliveDrab": CSI.csi24(red=107, green=142, blue=35),
    "dark khaki": CSI.csi24(red=189, green=183, blue=107),
    "DarkKhaki": CSI.csi24(red=189, green=183, blue=107),
    "khaki": CSI.csi24(red=240, green=230, blue=140),
    "pale goldenrod": CSI.csi24(red=238, green=232, blue=170),
    "PaleGoldenrod": CSI.csi24(red=238, green=232, blue=170),
    "light goldenrod yellow": CSI.csi24(red=250, green=250, blue=210),
    "LightGoldenrodYellow": CSI.csi24(red=250, green=250, blue=210),
    "light yellow": CSI.csi24(red=255, green=255, blue=224),
    "LightYellow": CSI.csi24(red=255, green=255, blue=224),
    "yellow": CSI.csi24(red=255, green=255, blue=0),
    "gold": CSI.csi24(red=255, green=215, blue=0),
    "light goldenrod": CSI.csi24(red=238, green=221, blue=130),
    "LightGoldenrod": CSI.csi24(red=238, green=221, blue=130),
    "goldenrod": CSI.csi24(red=218, green=165, blue=32),
    "dark goldenrod": CSI.csi24(red=184, green=134, blue=11),
    "DarkGoldenrod": CSI.csi24(red=184, green=134, blue=11),
    "rosy brown": CSI.csi24(red=188, green=143, blue=143),
    "RosyBrown": CSI.csi24(red=188, green=143, blue=143),
    "indian red": CSI.csi24(red=205, green=92, blue=92),
    "IndianRed": CSI.csi24(red=205, green=92, blue=92),
    "saddle brown": CSI.csi24(red=139, green=69, blue=19),
    "SaddleBrown": CSI.csi24(red=139, green=69, blue=19),
    "sienna": CSI.csi24(red=160, green=82, blue=45),
    "peru": CSI.csi24(red=205, green=133, blue=63),
    "burlywood": CSI.csi24(red=222, green=184, blue=135),
    "beige": CSI.csi24(red=245, green=245, blue=220),
    "wheat": CSI.csi24(red=245, green=222, blue=179),
    "sandy brown": CSI.csi24(red=244, green=164, blue=96),
    "SandyBrown": CSI.csi24(red=244, green=164, blue=96),
    "tan": CSI.csi24(red=210, green=180, blue=140),
    "chocolate": CSI.csi24(red=210, green=105, blue=30),
    "firebrick": CSI.csi24(red=178, green=34, blue=34),
    "brown": CSI.csi24(red=165, green=42, blue=42),
    "dark salmon": CSI.csi24(red=233, green=150, blue=122),
    "DarkSalmon": CSI.csi24(red=233, green=150, blue=122),
    "salmon": CSI.csi24(red=250, green=128, blue=114),
    "light salmon": CSI.csi24(red=255, green=160, blue=122),
    "LightSalmon": CSI.csi24(red=255, green=160, blue=122),
    "orange": CSI.csi24(red=255, green=165, blue=0),
    "dark orange": CSI.csi24(red=255, green=140, blue=0),
    "DarkOrange": CSI.csi24(red=255, green=140, blue=0),
    "coral": CSI.csi24(red=255, green=127, blue=80),
    "light coral": CSI.csi24(red=240, green=128, blue=128),
    "LightCoral": CSI.csi24(red=240, green=128, blue=128),
    "tomato": CSI.csi24(red=255, green=99, blue=71),
    "orange red": CSI.csi24(red=255, green=69, blue=0),
    "OrangeRed": CSI.csi24(red=255, green=69, blue=0),
    "red": CSI.csi24(red=255, green=0, blue=0),
    "hot pink": CSI.csi24(red=255, green=105, blue=180),
    "HotPink": CSI.csi24(red=255, green=105, blue=180),
    "deep pink": CSI.csi24(red=255, green=20, blue=147),
    "DeepPink": CSI.csi24(red=255, green=20, blue=147),
    "pink": CSI.csi24(red=255, green=192, blue=203),
    "light pink": CSI.csi24(red=255, green=182, blue=193),
    "LightPink": CSI.csi24(red=255, green=182, blue=193),
    "pale violet red": CSI.csi24(red=219, green=112, blue=147),
    "PaleVioletRed": CSI.csi24(red=219, green=112, blue=147),
    "maroon": CSI.csi24(red=176, green=48, blue=96),
    "x11 maroon": CSI.csi24(red=176, green=48, blue=96),
    "X11Maroon": CSI.csi24(red=176, green=48, blue=96),
    "web maroon": CSI.csi24(red=128, green=0, blue=0),
    "WebMaroon": CSI.csi24(red=128, green=0, blue=0),
    "medium violet red": CSI.csi24(red=199, green=21, blue=133),
    "MediumVioletRed": CSI.csi24(red=199, green=21, blue=133),
    "violet red": CSI.csi24(red=208, green=32, blue=144),
    "VioletRed": CSI.csi24(red=208, green=32, blue=144),
    "magenta": CSI.csi24(red=255, green=0, blue=255),
    "fuchsia": CSI.csi24(red=255, green=0, blue=255),
    "violet": CSI.csi24(red=238, green=130, blue=238),
    "plum": CSI.csi24(red=221, green=160, blue=221),
    "orchid": CSI.csi24(red=218, green=112, blue=214),
    "medium orchid": CSI.csi24(red=186, green=85, blue=211),
    "MediumOrchid": CSI.csi24(red=186, green=85, blue=211),
    "dark orchid": CSI.csi24(red=153, green=50, blue=204),
    "DarkOrchid": CSI.csi24(red=153, green=50, blue=204),
    "dark violet": CSI.csi24(red=148, green=0, blue=211),
    "DarkViolet": CSI.csi24(red=148, green=0, blue=211),
    "blue violet": CSI.csi24(red=138, green=43, blue=226),
    "BlueViolet": CSI.csi24(red=138, green=43, blue=226),
    "purple": CSI.csi24(red=160, green=32, blue=240),
    "x11 purple": CSI.csi24(red=160, green=32, blue=240),
    "X11Purple": CSI.csi24(red=160, green=32, blue=240),
    "web purple": CSI.csi24(red=128, green=0, blue=128),
    "WebPurple": CSI.csi24(red=128, green=0, blue=128),
    "medium purple": CSI.csi24(red=147, green=112, blue=219),
    "MediumPurple": CSI.csi24(red=147, green=112, blue=219),
    "thistle": CSI.csi24(red=216, green=191, blue=216),
    "snow1": CSI.csi24(red=255, green=250, blue=250),
    "snow2": CSI.csi24(red=238, green=233, blue=233),
    "snow3": CSI.csi24(red=205, green=201, blue=201),
    "snow4": CSI.csi24(red=139, green=137, blue=137),
    "seashell1": CSI.csi24(red=255, green=245, blue=238),
    "seashell2": CSI.csi24(red=238, green=229, blue=222),
    "seashell3": CSI.csi24(red=205, green=197, blue=191),
    "seashell4": CSI.csi24(red=139, green=134, blue=130),
    "AntiqueWhite1": CSI.csi24(red=255, green=239, blue=219),
    "AntiqueWhite2": CSI.csi24(red=238, green=223, blue=204),
    "AntiqueWhite3": CSI.csi24(red=205, green=192, blue=176),
    "AntiqueWhite4": CSI.csi24(red=139, green=131, blue=120),
    "bisque1": CSI.csi24(red=255, green=228, blue=196),
    "bisque2": CSI.csi24(red=238, green=213, blue=183),
    "bisque3": CSI.csi24(red=205, green=183, blue=158),
    "bisque4": CSI.csi24(red=139, green=125, blue=107),
    "PeachPuff1": CSI.csi24(red=255, green=218, blue=185),
    "PeachPuff2": CSI.csi24(red=238, green=203, blue=173),
    "PeachPuff3": CSI.csi24(red=205, green=175, blue=149),
    "PeachPuff4": CSI.csi24(red=139, green=119, blue=101),
    "NavajoWhite1": CSI.csi24(red=255, green=222, blue=173),
    "NavajoWhite2": CSI.csi24(red=238, green=207, blue=161),
    "NavajoWhite3": CSI.csi24(red=205, green=179, blue=139),
    "NavajoWhite4": CSI.csi24(red=139, green=121, blue=94),
    "LemonChiffon1": CSI.csi24(red=255, green=250, blue=205),
    "LemonChiffon2": CSI.csi24(red=238, green=233, blue=191),
    "LemonChiffon3": CSI.csi24(red=205, green=201, blue=165),
    "LemonChiffon4": CSI.csi24(red=139, green=137, blue=112),
    "cornsilk1": CSI.csi24(red=255, green=248, blue=220),
    "cornsilk2": CSI.csi24(red=238, green=232, blue=205),
    "cornsilk3": CSI.csi24(red=205, green=200, blue=177),
    "cornsilk4": CSI.csi24(red=139, green=136, blue=120),
    "ivory1": CSI.csi24(red=255, green=255, blue=240),
    "ivory2": CSI.csi24(red=238, green=238, blue=224),
    "ivory3": CSI.csi24(red=205, green=205, blue=193),
    "ivory4": CSI.csi24(red=139, green=139, blue=131),
    "honeydew1": CSI.csi24(red=240, green=255, blue=240),
    "honeydew2": CSI.csi24(red=224, green=238, blue=224),
    "honeydew3": CSI.csi24(red=193, green=205, blue=193),
    "honeydew4": CSI.csi24(red=131, green=139, blue=131),
    "LavenderBlush1": CSI.csi24(red=255, green=240, blue=245),
    "LavenderBlush2": CSI.csi24(red=238, green=224, blue=229),
    "LavenderBlush3": CSI.csi24(red=205, green=193, blue=197),
    "LavenderBlush4": CSI.csi24(red=139, green=131, blue=134),
    "MistyRose1": CSI.csi24(red=255, green=228, blue=225),
    "MistyRose2": CSI.csi24(red=238, green=213, blue=210),
    "MistyRose3": CSI.csi24(red=205, green=183, blue=181),
    "MistyRose4": CSI.csi24(red=139, green=125, blue=123),
    "azure1": CSI.csi24(red=240, green=255, blue=255),
    "azure2": CSI.csi24(red=224, green=238, blue=238),
    "azure3": CSI.csi24(red=193, green=205, blue=205),
    "azure4": CSI.csi24(red=131, green=139, blue=139),
    "SlateBlue1": CSI.csi24(red=131, green=111, blue=255),
    "SlateBlue2": CSI.csi24(red=122, green=103, blue=238),
    "SlateBlue3": CSI.csi24(red=105, green=89, blue=205),
    "SlateBlue4": CSI.csi24(red=71, green=60, blue=139),
    "RoyalBlue1": CSI.csi24(red=72, green=118, blue=255),
    "RoyalBlue2": CSI.csi24(red=67, green=110, blue=238),
    "RoyalBlue3": CSI.csi24(red=58, green=95, blue=205),
    "RoyalBlue4": CSI.csi24(red=39, green=64, blue=139),
    "blue1": CSI.csi24(red=0, green=0, blue=255),
    "blue2": CSI.csi24(red=0, green=0, blue=238),
    "blue3": CSI.csi24(red=0, green=0, blue=205),
    "blue4": CSI.csi24(red=0, green=0, blue=139),
    "DodgerBlue1": CSI.csi24(red=30, green=144, blue=255),
    "DodgerBlue2": CSI.csi24(red=28, green=134, blue=238),
    "DodgerBlue3": CSI.csi24(red=24, green=116, blue=205),
    "DodgerBlue4": CSI.csi24(red=16, green=78, blue=139),
    "SteelBlue1": CSI.csi24(red=99, green=184, blue=255),
    "SteelBlue2": CSI.csi24(red=92, green=172, blue=238),
    "SteelBlue3": CSI.csi24(red=79, green=148, blue=205),
    "SteelBlue4": CSI.csi24(red=54, green=100, blue=139),
    "DeepSkyBlue1": CSI.csi24(red=0, green=191, blue=255),
    "DeepSkyBlue2": CSI.csi24(red=0, green=178, blue=238),
    "DeepSkyBlue3": CSI.csi24(red=0, green=154, blue=205),
    "DeepSkyBlue4": CSI.csi24(red=0, green=104, blue=139),
    "SkyBlue1": CSI.csi24(red=135, green=206, blue=255),
    "SkyBlue2": CSI.csi24(red=126, green=192, blue=238),
    "SkyBlue3": CSI.csi24(red=108, green=166, blue=205),
    "SkyBlue4": CSI.csi24(red=74, green=112, blue=139),
    "LightSkyBlue1": CSI.csi24(red=176, green=226, blue=255),
    "LightSkyBlue2": CSI.csi24(red=164, green=211, blue=238),
    "LightSkyBlue3": CSI.csi24(red=141, green=182, blue=205),
    "LightSkyBlue4": CSI.csi24(red=96, green=123, blue=139),
    "SlateGray1": CSI.csi24(red=198, green=226, blue=255),
    "SlateGray2": CSI.csi24(red=185, green=211, blue=238),
    "SlateGray3": CSI.csi24(red=159, green=182, blue=205),
    "SlateGray4": CSI.csi24(red=108, green=123, blue=139),
    "LightSteelBlue1": CSI.csi24(red=202, green=225, blue=255),
    "LightSteelBlue2": CSI.csi24(red=188, green=210, blue=238),
    "LightSteelBlue3": CSI.csi24(red=162, green=181, blue=205),
    "LightSteelBlue4": CSI.csi24(red=110, green=123, blue=139),
    "LightBlue1": CSI.csi24(red=191, green=239, blue=255),
    "LightBlue2": CSI.csi24(red=178, green=223, blue=238),
    "LightBlue3": CSI.csi24(red=154, green=192, blue=205),
    "LightBlue4": CSI.csi24(red=104, green=131, blue=139),
    "LightCyan1": CSI.csi24(red=224, green=255, blue=255),
    "LightCyan2": CSI.csi24(red=209, green=238, blue=238),
    "LightCyan3": CSI.csi24(red=180, green=205, blue=205),
    "LightCyan4": CSI.csi24(red=122, green=139, blue=139),
    "PaleTurquoise1": CSI.csi24(red=187, green=255, blue=255),
    "PaleTurquoise2": CSI.csi24(red=174, green=238, blue=238),
    "PaleTurquoise3": CSI.csi24(red=150, green=205, blue=205),
    "PaleTurquoise4": CSI.csi24(red=102, green=139, blue=139),
    "CadetBlue1": CSI.csi24(red=152, green=245, blue=255),
    "CadetBlue2": CSI.csi24(red=142, green=229, blue=238),
    "CadetBlue3": CSI.csi24(red=122, green=197, blue=205),
    "CadetBlue4": CSI.csi24(red=83, green=134, blue=139),
    "turquoise1": CSI.csi24(red=0, green=245, blue=255),
    "turquoise2": CSI.csi24(red=0, green=229, blue=238),
    "turquoise3": CSI.csi24(red=0, green=197, blue=205),
    "turquoise4": CSI.csi24(red=0, green=134, blue=139),
    "cyan1": CSI.csi24(red=0, green=255, blue=255),
    "cyan2": CSI.csi24(red=0, green=238, blue=238),
    "cyan3": CSI.csi24(red=0, green=205, blue=205),
    "cyan4": CSI.csi24(red=0, green=139, blue=139),
    "DarkSlateGray1": CSI.csi24(red=151, green=255, blue=255),
    "DarkSlateGray2": CSI.csi24(red=141, green=238, blue=238),
    "DarkSlateGray3": CSI.csi24(red=121, green=205, blue=205),
    "DarkSlateGray4": CSI.csi24(red=82, green=139, blue=139),
    "aquamarine1": CSI.csi24(red=127, green=255, blue=212),
    "aquamarine2": CSI.csi24(red=118, green=238, blue=198),
    "aquamarine3": CSI.csi24(red=102, green=205, blue=170),
    "aquamarine4": CSI.csi24(red=69, green=139, blue=116),
    "DarkSeaGreen1": CSI.csi24(red=193, green=255, blue=193),
    "DarkSeaGreen2": CSI.csi24(red=180, green=238, blue=180),
    "DarkSeaGreen3": CSI.csi24(red=155, green=205, blue=155),
    "DarkSeaGreen4": CSI.csi24(red=105, green=139, blue=105),
    "SeaGreen1": CSI.csi24(red=84, green=255, blue=159),
    "SeaGreen2": CSI.csi24(red=78, green=238, blue=148),
    "SeaGreen3": CSI.csi24(red=67, green=205, blue=128),
    "SeaGreen4": CSI.csi24(red=46, green=139, blue=87),
    "PaleGreen1": CSI.csi24(red=154, green=255, blue=154),
    "PaleGreen2": CSI.csi24(red=144, green=238, blue=144),
    "PaleGreen3": CSI.csi24(red=124, green=205, blue=124),
    "PaleGreen4": CSI.csi24(red=84, green=139, blue=84),
    "SpringGreen1": CSI.csi24(red=0, green=255, blue=127),
    "SpringGreen2": CSI.csi24(red=0, green=238, blue=118),
    "SpringGreen3": CSI.csi24(red=0, green=205, blue=102),
    "SpringGreen4": CSI.csi24(red=0, green=139, blue=69),
    "green1": CSI.csi24(red=0, green=255, blue=0),
    "green2": CSI.csi24(red=0, green=238, blue=0),
    "green3": CSI.csi24(red=0, green=205, blue=0),
    "green4": CSI.csi24(red=0, green=139, blue=0),
    "chartreuse1": CSI.csi24(red=127, green=255, blue=0),
    "chartreuse2": CSI.csi24(red=118, green=238, blue=0),
    "chartreuse3": CSI.csi24(red=102, green=205, blue=0),
    "chartreuse4": CSI.csi24(red=69, green=139, blue=0),
    "OliveDrab1": CSI.csi24(red=192, green=255, blue=62),
    "OliveDrab2": CSI.csi24(red=179, green=238, blue=58),
    "OliveDrab3": CSI.csi24(red=154, green=205, blue=50),
    "OliveDrab4": CSI.csi24(red=105, green=139, blue=34),
    "DarkOliveGreen1": CSI.csi24(red=202, green=255, blue=112),
    "DarkOliveGreen2": CSI.csi24(red=188, green=238, blue=104),
    "DarkOliveGreen3": CSI.csi24(red=162, green=205, blue=90),
    "DarkOliveGreen4": CSI.csi24(red=110, green=139, blue=61),
    "khaki1": CSI.csi24(red=255, green=246, blue=143),
    "khaki2": CSI.csi24(red=238, green=230, blue=133),
    "khaki3": CSI.csi24(red=205, green=198, blue=115),
    "khaki4": CSI.csi24(red=139, green=134, blue=78),
    "LightGoldenrod1": CSI.csi24(red=255, green=236, blue=139),
    "LightGoldenrod2": CSI.csi24(red=238, green=220, blue=130),
    "LightGoldenrod3": CSI.csi24(red=205, green=190, blue=112),
    "LightGoldenrod4": CSI.csi24(red=139, green=129, blue=76),
    "LightYellow1": CSI.csi24(red=255, green=255, blue=224),
    "LightYellow2": CSI.csi24(red=238, green=238, blue=209),
    "LightYellow3": CSI.csi24(red=205, green=205, blue=180),
    "LightYellow4": CSI.csi24(red=139, green=139, blue=122),
    "yellow1": CSI.csi24(red=255, green=255, blue=0),
    "yellow2": CSI.csi24(red=238, green=238, blue=0),
    "yellow3": CSI.csi24(red=205, green=205, blue=0),
    "yellow4": CSI.csi24(red=139, green=139, blue=0),
    "gold1": CSI.csi24(red=255, green=215, blue=0),
    "gold2": CSI.csi24(red=238, green=201, blue=0),
    "gold3": CSI.csi24(red=205, green=173, blue=0),
    "gold4": CSI.csi24(red=139, green=117, blue=0),
    "goldenrod1": CSI.csi24(red=255, green=193, blue=37),
    "goldenrod2": CSI.csi24(red=238, green=180, blue=34),
    "goldenrod3": CSI.csi24(red=205, green=155, blue=29),
    "goldenrod4": CSI.csi24(red=139, green=105, blue=20),
    "DarkGoldenrod1": CSI.csi24(red=255, green=185, blue=15),
    "DarkGoldenrod2": CSI.csi24(red=238, green=173, blue=14),
    "DarkGoldenrod3": CSI.csi24(red=205, green=149, blue=12),
    "DarkGoldenrod4": CSI.csi24(red=139, green=101, blue=8),
    "RosyBrown1": CSI.csi24(red=255, green=193, blue=193),
    "RosyBrown2": CSI.csi24(red=238, green=180, blue=180),
    "RosyBrown3": CSI.csi24(red=205, green=155, blue=155),
    "RosyBrown4": CSI.csi24(red=139, green=105, blue=105),
    "IndianRed1": CSI.csi24(red=255, green=106, blue=106),
    "IndianRed2": CSI.csi24(red=238, green=99, blue=99),
    "IndianRed3": CSI.csi24(red=205, green=85, blue=85),
    "IndianRed4": CSI.csi24(red=139, green=58, blue=58),
    "sienna1": CSI.csi24(red=255, green=130, blue=71),
    "sienna2": CSI.csi24(red=238, green=121, blue=66),
    "sienna3": CSI.csi24(red=205, green=104, blue=57),
    "sienna4": CSI.csi24(red=139, green=71, blue=38),
    "burlywood1": CSI.csi24(red=255, green=211, blue=155),
    "burlywood2": CSI.csi24(red=238, green=197, blue=145),
    "burlywood3": CSI.csi24(red=205, green=170, blue=125),
    "burlywood4": CSI.csi24(red=139, green=115, blue=85),
    "wheat1": CSI.csi24(red=255, green=231, blue=186),
    "wheat2": CSI.csi24(red=238, green=216, blue=174),
    "wheat3": CSI.csi24(red=205, green=186, blue=150),
    "wheat4": CSI.csi24(red=139, green=126, blue=102),
    "tan1": CSI.csi24(red=255, green=165, blue=79),
    "tan2": CSI.csi24(red=238, green=154, blue=73),
    "tan3": CSI.csi24(red=205, green=133, blue=63),
    "tan4": CSI.csi24(red=139, green=90, blue=43),
    "chocolate1": CSI.csi24(red=255, green=127, blue=36),
    "chocolate2": CSI.csi24(red=238, green=118, blue=33),
    "chocolate3": CSI.csi24(red=205, green=102, blue=29),
    "chocolate4": CSI.csi24(red=139, green=69, blue=19),
    "firebrick1": CSI.csi24(red=255, green=48, blue=48),
    "firebrick2": CSI.csi24(red=238, green=44, blue=44),
    "firebrick3": CSI.csi24(red=205, green=38, blue=38),
    "firebrick4": CSI.csi24(red=139, green=26, blue=26),
    "brown1": CSI.csi24(red=255, green=64, blue=64),
    "brown2": CSI.csi24(red=238, green=59, blue=59),
    "brown3": CSI.csi24(red=205, green=51, blue=51),
    "brown4": CSI.csi24(red=139, green=35, blue=35),
    "salmon1": CSI.csi24(red=255, green=140, blue=105),
    "salmon2": CSI.csi24(red=238, green=130, blue=98),
    "salmon3": CSI.csi24(red=205, green=112, blue=84),
    "salmon4": CSI.csi24(red=139, green=76, blue=57),
    "LightSalmon1": CSI.csi24(red=255, green=160, blue=122),
    "LightSalmon2": CSI.csi24(red=238, green=149, blue=114),
    "LightSalmon3": CSI.csi24(red=205, green=129, blue=98),
    "LightSalmon4": CSI.csi24(red=139, green=87, blue=66),
    "orange1": CSI.csi24(red=255, green=165, blue=0),
    "orange2": CSI.csi24(red=238, green=154, blue=0),
    "orange3": CSI.csi24(red=205, green=133, blue=0),
    "orange4": CSI.csi24(red=139, green=90, blue=0),
    "DarkOrange1": CSI.csi24(red=255, green=127, blue=0),
    "DarkOrange2": CSI.csi24(red=238, green=118, blue=0),
    "DarkOrange3": CSI.csi24(red=205, green=102, blue=0),
    "DarkOrange4": CSI.csi24(red=139, green=69, blue=0),
    "coral1": CSI.csi24(red=255, green=114, blue=86),
    "coral2": CSI.csi24(red=238, green=106, blue=80),
    "coral3": CSI.csi24(red=205, green=91, blue=69),
    "coral4": CSI.csi24(red=139, green=62, blue=47),
    "tomato1": CSI.csi24(red=255, green=99, blue=71),
    "tomato2": CSI.csi24(red=238, green=92, blue=66),
    "tomato3": CSI.csi24(red=205, green=79, blue=57),
    "tomato4": CSI.csi24(red=139, green=54, blue=38),
    "OrangeRed1": CSI.csi24(red=255, green=69, blue=0),
    "OrangeRed2": CSI.csi24(red=238, green=64, blue=0),
    "OrangeRed3": CSI.csi24(red=205, green=55, blue=0),
    "OrangeRed4": CSI.csi24(red=139, green=37, blue=0),
    "red1": CSI.csi24(red=255, green=0, blue=0),
    "red2": CSI.csi24(red=238, green=0, blue=0),
    "red3": CSI.csi24(red=205, green=0, blue=0),
    "red4": CSI.csi24(red=139, green=0, blue=0),
    "DeepPink1": CSI.csi24(red=255, green=20, blue=147),
    "DeepPink2": CSI.csi24(red=238, green=18, blue=137),
    "DeepPink3": CSI.csi24(red=205, green=16, blue=118),
    "DeepPink4": CSI.csi24(red=139, green=10, blue=80),
    "HotPink1": CSI.csi24(red=255, green=110, blue=180),
    "HotPink2": CSI.csi24(red=238, green=106, blue=167),
    "HotPink3": CSI.csi24(red=205, green=96, blue=144),
    "HotPink4": CSI.csi24(red=139, green=58, blue=98),
    "pink1": CSI.csi24(red=255, green=181, blue=197),
    "pink2": CSI.csi24(red=238, green=169, blue=184),
    "pink3": CSI.csi24(red=205, green=145, blue=158),
    "pink4": CSI.csi24(red=139, green=99, blue=108),
    "LightPink1": CSI.csi24(red=255, green=174, blue=185),
    "LightPink2": CSI.csi24(red=238, green=162, blue=173),
    "LightPink3": CSI.csi24(red=205, green=140, blue=149),
    "LightPink4": CSI.csi24(red=139, green=95, blue=101),
    "PaleVioletRed1": CSI.csi24(red=255, green=130, blue=171),
    "PaleVioletRed2": CSI.csi24(red=238, green=121, blue=159),
    "PaleVioletRed3": CSI.csi24(red=205, green=104, blue=137),
    "PaleVioletRed4": CSI.csi24(red=139, green=71, blue=93),
    "maroon1": CSI.csi24(red=255, green=52, blue=179),
    "maroon2": CSI.csi24(red=238, green=48, blue=167),
    "maroon3": CSI.csi24(red=205, green=41, blue=144),
    "maroon4": CSI.csi24(red=139, green=28, blue=98),
    "VioletRed1": CSI.csi24(red=255, green=62, blue=150),
    "VioletRed2": CSI.csi24(red=238, green=58, blue=140),
    "VioletRed3": CSI.csi24(red=205, green=50, blue=120),
    "VioletRed4": CSI.csi24(red=139, green=34, blue=82),
    "magenta1": CSI.csi24(red=255, green=0, blue=255),
    "magenta2": CSI.csi24(red=238, green=0, blue=238),
    "magenta3": CSI.csi24(red=205, green=0, blue=205),
    "magenta4": CSI.csi24(red=139, green=0, blue=139),
    "orchid1": CSI.csi24(red=255, green=131, blue=250),
    "orchid2": CSI.csi24(red=238, green=122, blue=233),
    "orchid3": CSI.csi24(red=205, green=105, blue=201),
    "orchid4": CSI.csi24(red=139, green=71, blue=137),
    "plum1": CSI.csi24(red=255, green=187, blue=255),
    "plum2": CSI.csi24(red=238, green=174, blue=238),
    "plum3": CSI.csi24(red=205, green=150, blue=205),
    "plum4": CSI.csi24(red=139, green=102, blue=139),
    "MediumOrchid1": CSI.csi24(red=224, green=102, blue=255),
    "MediumOrchid2": CSI.csi24(red=209, green=95, blue=238),
    "MediumOrchid3": CSI.csi24(red=180, green=82, blue=205),
    "MediumOrchid4": CSI.csi24(red=122, green=55, blue=139),
    "DarkOrchid1": CSI.csi24(red=191, green=62, blue=255),
    "DarkOrchid2": CSI.csi24(red=178, green=58, blue=238),
    "DarkOrchid3": CSI.csi24(red=154, green=50, blue=205),
    "DarkOrchid4": CSI.csi24(red=104, green=34, blue=139),
    "purple1": CSI.csi24(red=155, green=48, blue=255),
    "purple2": CSI.csi24(red=145, green=44, blue=238),
    "purple3": CSI.csi24(red=125, green=38, blue=205),
    "purple4": CSI.csi24(red=85, green=26, blue=139),
    "MediumPurple1": CSI.csi24(red=171, green=130, blue=255),
    "MediumPurple2": CSI.csi24(red=159, green=121, blue=238),
    "MediumPurple3": CSI.csi24(red=137, green=104, blue=205),
    "MediumPurple4": CSI.csi24(red=93, green=71, blue=139),
    "thistle1": CSI.csi24(red=255, green=225, blue=255),
    "thistle2": CSI.csi24(red=238, green=210, blue=238),
    "thistle3": CSI.csi24(red=205, green=181, blue=205),
    "thistle4": CSI.csi24(red=139, green=123, blue=139),
    "gray0": CSI.csi24(red=0, green=0, blue=0),
    "grey0": CSI.csi24(red=0, green=0, blue=0),
    "gray1": CSI.csi24(red=3, green=3, blue=3),
    "grey1": CSI.csi24(red=3, green=3, blue=3),
    "gray2": CSI.csi24(red=5, green=5, blue=5),
    "grey2": CSI.csi24(red=5, green=5, blue=5),
    "gray3": CSI.csi24(red=8, green=8, blue=8),
    "grey3": CSI.csi24(red=8, green=8, blue=8),
    "gray4": CSI.csi24(red=10, green=10, blue=10),
    "grey4": CSI.csi24(red=10, green=10, blue=10),
    "gray5": CSI.csi24(red=13, green=13, blue=13),
    "grey5": CSI.csi24(red=13, green=13, blue=13),
    "gray6": CSI.csi24(red=15, green=15, blue=15),
    "grey6": CSI.csi24(red=15, green=15, blue=15),
    "gray7": CSI.csi24(red=18, green=18, blue=18),
    "grey7": CSI.csi24(red=18, green=18, blue=18),
    "gray8": CSI.csi24(red=20, green=20, blue=20),
    "grey8": CSI.csi24(red=20, green=20, blue=20),
    "gray9": CSI.csi24(red=23, green=23, blue=23),
    "grey9": CSI.csi24(red=23, green=23, blue=23),
    "gray10": CSI.csi24(red=26, green=26, blue=26),
    "grey10": CSI.csi24(red=26, green=26, blue=26),
    "gray11": CSI.csi24(red=28, green=28, blue=28),
    "grey11": CSI.csi24(red=28, green=28, blue=28),
    "gray12": CSI.csi24(red=31, green=31, blue=31),
    "grey12": CSI.csi24(red=31, green=31, blue=31),
    "gray13": CSI.csi24(red=33, green=33, blue=33),
    "grey13": CSI.csi24(red=33, green=33, blue=33),
    "gray14": CSI.csi24(red=36, green=36, blue=36),
    "grey14": CSI.csi24(red=36, green=36, blue=36),
    "gray15": CSI.csi24(red=38, green=38, blue=38),
    "grey15": CSI.csi24(red=38, green=38, blue=38),
    "gray16": CSI.csi24(red=41, green=41, blue=41),
    "grey16": CSI.csi24(red=41, green=41, blue=41),
    "gray17": CSI.csi24(red=43, green=43, blue=43),
    "grey17": CSI.csi24(red=43, green=43, blue=43),
    "gray18": CSI.csi24(red=46, green=46, blue=46),
    "grey18": CSI.csi24(red=46, green=46, blue=46),
    "gray19": CSI.csi24(red=48, green=48, blue=48),
    "grey19": CSI.csi24(red=48, green=48, blue=48),
    "gray20": CSI.csi24(red=51, green=51, blue=51),
    "grey20": CSI.csi24(red=51, green=51, blue=51),
    "gray21": CSI.csi24(red=54, green=54, blue=54),
    "grey21": CSI.csi24(red=54, green=54, blue=54),
    "gray22": CSI.csi24(red=56, green=56, blue=56),
    "grey22": CSI.csi24(red=56, green=56, blue=56),
    "gray23": CSI.csi24(red=59, green=59, blue=59),
    "grey23": CSI.csi24(red=59, green=59, blue=59),
    "gray24": CSI.csi24(red=61, green=61, blue=61),
    "grey24": CSI.csi24(red=61, green=61, blue=61),
    "gray25": CSI.csi24(red=64, green=64, blue=64),
    "grey25": CSI.csi24(red=64, green=64, blue=64),
    "gray26": CSI.csi24(red=66, green=66, blue=66),
    "grey26": CSI.csi24(red=66, green=66, blue=66),
    "gray27": CSI.csi24(red=69, green=69, blue=69),
    "grey27": CSI.csi24(red=69, green=69, blue=69),
    "gray28": CSI.csi24(red=71, green=71, blue=71),
    "grey28": CSI.csi24(red=71, green=71, blue=71),
    "gray29": CSI.csi24(red=74, green=74, blue=74),
    "grey29": CSI.csi24(red=74, green=74, blue=74),
    "gray30": CSI.csi24(red=77, green=77, blue=77),
    "grey30": CSI.csi24(red=77, green=77, blue=77),
    "gray31": CSI.csi24(red=79, green=79, blue=79),
    "grey31": CSI.csi24(red=79, green=79, blue=79),
    "gray32": CSI.csi24(red=82, green=82, blue=82),
    "grey32": CSI.csi24(red=82, green=82, blue=82),
    "gray33": CSI.csi24(red=84, green=84, blue=84),
    "grey33": CSI.csi24(red=84, green=84, blue=84),
    "gray34": CSI.csi24(red=87, green=87, blue=87),
    "grey34": CSI.csi24(red=87, green=87, blue=87),
    "gray35": CSI.csi24(red=89, green=89, blue=89),
    "grey35": CSI.csi24(red=89, green=89, blue=89),
    "gray36": CSI.csi24(red=92, green=92, blue=92),
    "grey36": CSI.csi24(red=92, green=92, blue=92),
    "gray37": CSI.csi24(red=94, green=94, blue=94),
    "grey37": CSI.csi24(red=94, green=94, blue=94),
    "gray38": CSI.csi24(red=97, green=97, blue=97),
    "grey38": CSI.csi24(red=97, green=97, blue=97),
    "gray39": CSI.csi24(red=99, green=99, blue=99),
    "grey39": CSI.csi24(red=99, green=99, blue=99),
    "gray40": CSI.csi24(red=102, green=102, blue=102),
    "grey40": CSI.csi24(red=102, green=102, blue=102),
    "gray41": CSI.csi24(red=105, green=105, blue=105),
    "grey41": CSI.csi24(red=105, green=105, blue=105),
    "gray42": CSI.csi24(red=107, green=107, blue=107),
    "grey42": CSI.csi24(red=107, green=107, blue=107),
    "gray43": CSI.csi24(red=110, green=110, blue=110),
    "grey43": CSI.csi24(red=110, green=110, blue=110),
    "gray44": CSI.csi24(red=112, green=112, blue=112),
    "grey44": CSI.csi24(red=112, green=112, blue=112),
    "gray45": CSI.csi24(red=115, green=115, blue=115),
    "grey45": CSI.csi24(red=115, green=115, blue=115),
    "gray46": CSI.csi24(red=117, green=117, blue=117),
    "grey46": CSI.csi24(red=117, green=117, blue=117),
    "gray47": CSI.csi24(red=120, green=120, blue=120),
    "grey47": CSI.csi24(red=120, green=120, blue=120),
    "gray48": CSI.csi24(red=122, green=122, blue=122),
    "grey48": CSI.csi24(red=122, green=122, blue=122),
    "gray49": CSI.csi24(red=125, green=125, blue=125),
    "grey49": CSI.csi24(red=125, green=125, blue=125),
    "gray50": CSI.csi24(red=127, green=127, blue=127),
    "grey50": CSI.csi24(red=127, green=127, blue=127),
    "gray51": CSI.csi24(red=130, green=130, blue=130),
    "grey51": CSI.csi24(red=130, green=130, blue=130),
    "gray52": CSI.csi24(red=133, green=133, blue=133),
    "grey52": CSI.csi24(red=133, green=133, blue=133),
    "gray53": CSI.csi24(red=135, green=135, blue=135),
    "grey53": CSI.csi24(red=135, green=135, blue=135),
    "gray54": CSI.csi24(red=138, green=138, blue=138),
    "grey54": CSI.csi24(red=138, green=138, blue=138),
    "gray55": CSI.csi24(red=140, green=140, blue=140),
    "grey55": CSI.csi24(red=140, green=140, blue=140),
    "gray56": CSI.csi24(red=143, green=143, blue=143),
    "grey56": CSI.csi24(red=143, green=143, blue=143),
    "gray57": CSI.csi24(red=145, green=145, blue=145),
    "grey57": CSI.csi24(red=145, green=145, blue=145),
    "gray58": CSI.csi24(red=148, green=148, blue=148),
    "grey58": CSI.csi24(red=148, green=148, blue=148),
    "gray59": CSI.csi24(red=150, green=150, blue=150),
    "grey59": CSI.csi24(red=150, green=150, blue=150),
    "gray60": CSI.csi24(red=153, green=153, blue=153),
    "grey60": CSI.csi24(red=153, green=153, blue=153),
    "gray61": CSI.csi24(red=156, green=156, blue=156),
    "grey61": CSI.csi24(red=156, green=156, blue=156),
    "gray62": CSI.csi24(red=158, green=158, blue=158),
    "grey62": CSI.csi24(red=158, green=158, blue=158),
    "gray63": CSI.csi24(red=161, green=161, blue=161),
    "grey63": CSI.csi24(red=161, green=161, blue=161),
    "gray64": CSI.csi24(red=163, green=163, blue=163),
    "grey64": CSI.csi24(red=163, green=163, blue=163),
    "gray65": CSI.csi24(red=166, green=166, blue=166),
    "grey65": CSI.csi24(red=166, green=166, blue=166),
    "gray66": CSI.csi24(red=168, green=168, blue=168),
    "grey66": CSI.csi24(red=168, green=168, blue=168),
    "gray67": CSI.csi24(red=171, green=171, blue=171),
    "grey67": CSI.csi24(red=171, green=171, blue=171),
    "gray68": CSI.csi24(red=173, green=173, blue=173),
    "grey68": CSI.csi24(red=173, green=173, blue=173),
    "gray69": CSI.csi24(red=176, green=176, blue=176),
    "grey69": CSI.csi24(red=176, green=176, blue=176),
    "gray70": CSI.csi24(red=179, green=179, blue=179),
    "grey70": CSI.csi24(red=179, green=179, blue=179),
    "gray71": CSI.csi24(red=181, green=181, blue=181),
    "grey71": CSI.csi24(red=181, green=181, blue=181),
    "gray72": CSI.csi24(red=184, green=184, blue=184),
    "grey72": CSI.csi24(red=184, green=184, blue=184),
    "gray73": CSI.csi24(red=186, green=186, blue=186),
    "grey73": CSI.csi24(red=186, green=186, blue=186),
    "gray74": CSI.csi24(red=189, green=189, blue=189),
    "grey74": CSI.csi24(red=189, green=189, blue=189),
    "gray75": CSI.csi24(red=191, green=191, blue=191),
    "grey75": CSI.csi24(red=191, green=191, blue=191),
    "gray76": CSI.csi24(red=194, green=194, blue=194),
    "grey76": CSI.csi24(red=194, green=194, blue=194),
    "gray77": CSI.csi24(red=196, green=196, blue=196),
    "grey77": CSI.csi24(red=196, green=196, blue=196),
    "gray78": CSI.csi24(red=199, green=199, blue=199),
    "grey78": CSI.csi24(red=199, green=199, blue=199),
    "gray79": CSI.csi24(red=201, green=201, blue=201),
    "grey79": CSI.csi24(red=201, green=201, blue=201),
    "gray80": CSI.csi24(red=204, green=204, blue=204),
    "grey80": CSI.csi24(red=204, green=204, blue=204),
    "gray81": CSI.csi24(red=207, green=207, blue=207),
    "grey81": CSI.csi24(red=207, green=207, blue=207),
    "gray82": CSI.csi24(red=209, green=209, blue=209),
    "grey82": CSI.csi24(red=209, green=209, blue=209),
    "gray83": CSI.csi24(red=212, green=212, blue=212),
    "grey83": CSI.csi24(red=212, green=212, blue=212),
    "gray84": CSI.csi24(red=214, green=214, blue=214),
    "grey84": CSI.csi24(red=214, green=214, blue=214),
    "gray85": CSI.csi24(red=217, green=217, blue=217),
    "grey85": CSI.csi24(red=217, green=217, blue=217),
    "gray86": CSI.csi24(red=219, green=219, blue=219),
    "grey86": CSI.csi24(red=219, green=219, blue=219),
    "gray87": CSI.csi24(red=222, green=222, blue=222),
    "grey87": CSI.csi24(red=222, green=222, blue=222),
    "gray88": CSI.csi24(red=224, green=224, blue=224),
    "grey88": CSI.csi24(red=224, green=224, blue=224),
    "gray89": CSI.csi24(red=227, green=227, blue=227),
    "grey89": CSI.csi24(red=227, green=227, blue=227),
    "gray90": CSI.csi24(red=229, green=229, blue=229),
    "grey90": CSI.csi24(red=229, green=229, blue=229),
    "gray91": CSI.csi24(red=232, green=232, blue=232),
    "grey91": CSI.csi24(red=232, green=232, blue=232),
    "gray92": CSI.csi24(red=235, green=235, blue=235),
    "grey92": CSI.csi24(red=235, green=235, blue=235),
    "gray93": CSI.csi24(red=237, green=237, blue=237),
    "grey93": CSI.csi24(red=237, green=237, blue=237),
    "gray94": CSI.csi24(red=240, green=240, blue=240),
    "grey94": CSI.csi24(red=240, green=240, blue=240),
    "gray95": CSI.csi24(red=242, green=242, blue=242),
    "grey95": CSI.csi24(red=242, green=242, blue=242),
    "gray96": CSI.csi24(red=245, green=245, blue=245),
    "grey96": CSI.csi24(red=245, green=245, blue=245),
    "gray97": CSI.csi24(red=247, green=247, blue=247),
    "grey97": CSI.csi24(red=247, green=247, blue=247),
    "gray98": CSI.csi24(red=250, green=250, blue=250),
    "grey98": CSI.csi24(red=250, green=250, blue=250),
    "gray99": CSI.csi24(red=252, green=252, blue=252),
    "grey99": CSI.csi24(red=252, green=252, blue=252),
    "gray100": CSI.csi24(red=255, green=255, blue=255),
    "grey100": CSI.csi24(red=255, green=255, blue=255),
    "dark grey": CSI.csi24(red=169, green=169, blue=169),
    "DarkGrey": CSI.csi24(red=169, green=169, blue=169),
    "dark gray": CSI.csi24(red=169, green=169, blue=169),
    "DarkGray": CSI.csi24(red=169, green=169, blue=169),
    "dark blue": CSI.csi24(red=0, green=0, blue=139),
    "DarkBlue": CSI.csi24(red=0, green=0, blue=139),
    "dark cyan": CSI.csi24(red=0, green=139, blue=139),
    "DarkCyan": CSI.csi24(red=0, green=139, blue=139),
    "dark magenta": CSI.csi24(red=139, green=0, blue=139),
    "DarkMagenta": CSI.csi24(red=139, green=0, blue=139),
    "dark red": CSI.csi24(red=139, green=0, blue=0),
    "DarkRed": CSI.csi24(red=139, green=0, blue=0),
    "light green": CSI.csi24(red=144, green=238, blue=144),
    "LightGreen": CSI.csi24(red=144, green=238, blue=144),
    "crimson": CSI.csi24(red=220, green=20, blue=60),
    "indigo": CSI.csi24(red=75, green=0, blue=130),
    "olive": CSI.csi24(red=128, green=128, blue=0),
    "rebecca purple": CSI.csi24(red=102, green=51, blue=153),
    "RebeccaPurple": CSI.csi24(red=102, green=51, blue=153),
    "silver": CSI.csi24(red=192, green=192, blue=192),
    "teal": CSI.csi24(red=0, green=128, blue=128),
    }

# end of file
