# -*- coding: utf-8 -*-
#
# michael a.g. aïvázis <michael.aivazis@para-sim.com>
# (c) 1998-2023 all rights reserved


# a table with symbolic names for ASCII control characters
class ASCII:
    """
    Symbolic names for the ASCII control characters
    """

    # constants
    NUL = "\x00"
    SOH = "\x01"
    STX = "\x02"
    ETX = "\x03"
    EOT = "\x04"
    ENQ = "\x05"
    ACK = "\x06"
    BEL = "\x07"
    BS = "\x08"
    TAB = "\x09"
    LF = "\x0a"
    VT = "\x0b"
    FF = "\x0c"
    CR = "\x0d"
    SO = "\x0e"
    SI = "\x0f"
    ESC = "\x1b"
    DEL = "\x7f"


# end of file
