# -*- coding: utf-8 -*-
#
# michael a.g. aïvázis <michael.aivazis@para-sim.com>
# (c) 1998-2023 all rights reserved


# framework
import pyre             # for my superclass


# the base class of journal devices
class Device(pyre.patterns.named):
    """
    Base class for journal devices
    """


    # interface
    def alert(self, entry):
        """
        Generate an alert.

        Alerts are user-facing; they are generated by {info}, {warning}, and {error}
        """
        # this device doesn't know how to do that
        raise NotImplementedError(f"class '{type(self).__name__}' must implement 'alert'")


    def help(self, entry):
        """
        Generate a help screen
        """
        # this device doesn't know how to do that
        raise NotImplementedError(f"class '{type(self).__name__}' must implement 'help'")


    def memo(self, entry):
        """
        Issue a memo

        Memos are developer-facing; they are generated by {debug} and {firewall}
        """
        # this device doesn't know how to do that
        raise NotImplementedError(f"class '{type(self).__name__}' must implement 'memo'")


# end of file
