# -*- coding: utf-8 -*-
#
# michael a.g. aïvázis <michael.aivazis@para-sim.com>
# (c) 1998-2023 all rights reserved


# externals
import datetime

# support
import merlin


# the base makefile generator
class Generator(merlin.component):
    """
    The base makefile content generator
    """

    # configurable state
    renderer = merlin.weaver.language()
    renderer.default = "make"
    renderer.doc = "the makefile mill"

    # interface
    def generate(self, makefile, **kwds):
        """
        Generate the makefile preamble
        """
        # get the renderer
        renderer = self.renderer
        # open the output
        with open(makefile, mode="w") as stream:
            # prime the content generation
            contents = self._generate(**kwds)
            # ask my renderer to build the makefile
            document = renderer.render(document=contents)
            # and write it out
            print("\n".join(document), file=stream)
        # all done
        return

    # implementation details
    def _generate(self, **kwds):
        """
        Build my contents
        """
        # make a time stamp
        stamp = (
            f"generated by '{self.pyre_name}' on {datetime.datetime.now().isoformat()}"
        )
        # mark
        yield self.renderer.commentLine(stamp)
        # make some room
        yield ""
        # all done
        return


# end of file
