# -*- coding: utf-8 -*-
#
# michael a.g. aïvázis <michael.aivazis@para-sim.com>
# (c) 1998-2023 all rights reserved


# exceptions
from ..framework.exceptions import FrameworkError


class SchemaError(FrameworkError):
    """
    Base class for all errors generated by this package
    """


class CastingError(SchemaError):
    """
    Exception raised on failed attempts to convert a value to one of the supported types
    """

    # meta-methods
    def __init__(self, value, **kwds):
        # chain up
        super().__init__(**kwds)
        # save the error info
        self.value = value
        # all done
        return


# end of file
