// -*- web -*-
//
// {project.authors}
// (c) {project.span} all rights reserved


// externals
import React from 'react'
import {{ Link }} from 'react-router-dom'
// locals
import base from './styles'


// the x
const mark = `
M 100 42.783564 C 100 37.00355 98.68787 31.40666 96.10338 26.13025 C 93.61166
21.03697 90.03313 16.458739 85.48708 12.532906 C 80.94102 8.607073 75.6395
5.516768 69.74155 3.3649994 C 63.631544 1.133112 57.15043 0 50.457256 0 L
49.542744 0 C 42.84957 0 36.368456 1.133112 30.25845 3.3649994 C 24.360504
5.516768 19.05898 8.607073 14.512922 12.532906 C 9.966865 16.458739 6.388337
21.03697 3.8966203 26.13025 C 1.3121272 31.40666 0 37.014994 0 42.783564 L 0
43.57331 C 0 52.67254 3.353214 61.485636 9.516236 68.77647 C 7.793241 70.60776
6.8124586 72.90832 6.8124586 75.380565 L 6.8124586 75.51791 C 6.8124586 81.28648
12.246521 85.97917 18.926441 85.97917 L 23.883366 85.97917 L 26.0835 96.97837 C
26.428098 98.7181 28.190855 100 30.23194 100 L 69.754805 100 C 71.809145 100
73.55865 98.72954 73.90325 96.97837 L 76.10338 85.97917 L 81.07356 85.97917 C
87.75348 85.97917 93.18754 81.28648 93.18754 75.51791 L 93.18754 75.380565 C
93.18754 72.91977 92.20676 70.60776 90.48376 68.77647 C 96.64679 61.485636 100
52.661096 100 43.57331 L 100 42.783564 Z M 30.563287 65.937965 C 22.876077
65.937965 16.633532 60.558544 16.633532 53.908664 C 16.633532 51.66533 17.349238
49.57079 18.581842 47.773835 C 26.414844 49.582236 35.016567 50.726794 44.09543
51.07016 C 44.34725 51.97436 44.47979 52.924345 44.47979 53.89722 C 44.49304
60.5471 38.250497 65.937965 30.563287 65.937965 Z M 48.641484 74.15589 L
46.838966 82.1449 C 46.53413 83.48403 45.18224 84.41113 43.671306 84.41113 C
43.4725 84.41113 43.260437 84.39968 43.048376 84.3539 C 41.298873 84.05631
40.14579 82.59128 40.49039 81.08046 L 42.29291 73.09145 C 42.63751 71.58063
44.333996 70.58487 46.0835 70.88245 C 47.833 71.16859 48.97283 72.63363
48.641484 74.15589 Z M 56.951624 84.3539 C 56.73956 84.38823 56.540755 84.41113
56.328694 84.41113 C 54.804506 84.41113 53.45262 83.48403 53.161034 82.1449 L
51.358516 74.15589 C 51.013917 72.64507 52.167 71.18004 53.9165 70.88245 C
55.666004 70.58487 57.36249 71.58063 57.70709 73.09145 L 59.50961 81.08046 C
59.85421 82.59128 58.70113 84.05631 56.951624 84.3539 Z M 69.43671 65.937965 C
61.7495 65.937965 55.50696 60.558544 55.50696 53.908664 C 55.50696 52.93579
55.639496 51.98581 55.89132 51.08161 C 64.97018 50.726794 73.58516 49.582236
81.4049 47.78528 C 82.63751 49.582236 83.35321 51.67678 83.35321 53.92011 C
83.36647 60.5471 77.12392 65.937965 69.43671 65.937965 Z`


// the bar at the bottom of every page
const widget = ({{style, onKill, ...xforms}}) => (
    // the action
    <Link to="/stop"
          onClick={{onKill}}
          style={{{{...base.action, ...style.action}}}}
          title="kill the server; you'll have to close this window yourself, though">
        {{/* the box */}}
        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" style={{{{...base.box, ...style.box}}}}>
            {{/* the shape */}}
            <g {{...base.shape}} {{...style.shape}} {{...xforms}}>
                <path d={{mark}}/>
            </g>
        </svg>
    </Link>
)


// publish
export default widget


// end of file
