#!/usr/bin/env cwl-runner
### Test harness for airnow.cwl

cwlVersion: v1.2
class: Workflow

requirements:
  InlineJavascriptRequirement: {}
  StepInputExpressionRequirement: {}
  SubworkflowFeatureRequirement: {}


# All inputs of original pipeline, remove what is not needed
inputs:
  api-key:
    doc: API key for AirNow
    type: string
  connection_name:
    doc: The name of the section in the database.ini file
    type: string
  database:
    doc: Path to database connection file, usually database.ini
    type: File
  from:
    doc: Start date for downolading, in YYYY-MM-DD format
    type: string
  parameter_code:
    doc: 'Parameter code. Either a numeric code (e.g. 88101, 44201)

      or symbolic name (e.g. PM25, NO2).

      See more: [AQS Code List](https://www.epa.gov/aqs/aqs-code-list)

      '
    type: string
  proxy:
    default: ''
    doc: HTTP/HTTPS Proxy if required
    type: string?
  table:
    doc: Name of the table to be created in the database
    type: string
  test_script:
    doc: File containing SQL test script
    type: File
  to:
    doc: End date for downolading, in YYYY-MM-DD format
    type: string
  year:
    type: int


steps:
  execute:
    run: airnow.cwl
    in:
      proxy: proxy
      api-key: api-key
      database: database
      connection_name: connection_name
      from: from
      to: to
      parameter_code: parameter_code
      table: table
      year: year
    out:
      - shapes_data
      - download_log
      - ingest_log
      - index_log
      - vacuum_log
      - download_data
      - model

  verify:
    run: run_test.cwl
    in:
      database: database
      connection_name: connection_name
      script: test_script
      depends_on: execute/model
    out:
      - log
      - errors

outputs:
## Generated by nsaph/util/cwl_collect_outputs.py from airnow.cwl:
  execute_shapes_data:
    type: File[]
    outputSource: execute/shapes_data
  execute_download_log:
    type: File
    outputSource: execute/download_log
  execute_ingest_log:
    type: File
    outputSource: execute/ingest_log
  execute_index_log:
    type: File
    outputSource: execute/index_log
  execute_vacuum_log:
    type: File
    outputSource: execute/vacuum_log
  execute_download_data:
    type: File
    outputSource: execute/download_data
  execute_model:
    type: File
    outputSource: execute/model
## Generated by nsaph/util/cwl_collect_outputs.py from run_test.cwl:
  verify_log:
    type: File
    outputSource: verify/log
  verify_errors:
    type: File
    outputSource: verify/errors
