#!/usr/bin/env cwl-runner
### Test harness for aqs.cwl

cwlVersion: v1.2
class: Workflow

requirements:
  InlineJavascriptRequirement: {}
  ScatterFeatureRequirement: {}
  StepInputExpressionRequirement: {}
  SubworkflowFeatureRequirement: {}


# All inputs of original pipeline, remove what is not needed
inputs:
  aggregation:
    type: string
  connection_name:
    doc: The name of the section in the database.ini file
    type: string
  database:
    doc: Path to database connection file, usually database.ini
    type: File
  parameter_code:
    doc: 'Parameter code. Either a numeric code (e.g. 88101, 44201)

      or symbolic name (e.g. PM25, NO2).

      See more: [AQS Code List](https://www.epa.gov/aqs/aqs-code-list)

      '
    type: string
  proxy:
    default: ''
    doc: HTTP/HTTPS Proxy if required
    type: string?
  table:
    doc: Name of the table to be created in the database
    type: string
  test_script:
    doc: File containing SQL test script
    type:
      - File[]
  years:
    doc: Years to download
    type: string[]


steps:
  execute:
    run: aqs.cwl
    in:
      proxy: proxy
      database: database
      connection_name: connection_name
      aggregation: aggregation
      parameter_code: parameter_code
      table: table
      years: years
    out:
      - initdb_log
      - expand_log
      - introspect_log
      - ingest_log
      - index_log
      - vacuum_log
      - data
      - model
      - introspect_err
      - ingest_err
      - index_err
      - vacuum_err

  verify:
    run: run_test.cwl
    in:
      database: database
      connection_name: connection_name
      script: test_script
      depends_on: execute/vacuum_err
    out:
      - log
      - errors

outputs:
## Generated by nsaph/util/cwl_collect_outputs.py from aqs.cwl:
  execute_initdb_log:
    type: File
    outputSource: execute/initdb_log
  execute_expand_log:
    type: File
    outputSource: execute/expand_log
  execute_introspect_log:
    type: File
    outputSource: execute/introspect_log
  execute_ingest_log:
    type: File
    outputSource: execute/ingest_log
  execute_index_log:
    type: File
    outputSource: execute/index_log
  execute_vacuum_log:
    type: File
    outputSource: execute/vacuum_log
  execute_data:
    type: File
    outputSource: execute/data
  execute_model:
    type: File
    outputSource: execute/model
  execute_introspect_err:
    type: File
    outputSource: execute/introspect_err
  execute_ingest_err:
    type: File
    outputSource: execute/ingest_err
  execute_index_err:
    type: File
    outputSource: execute/index_err
  execute_vacuum_err:
    type: File
    outputSource: execute/vacuum_err
## Generated by nsaph/util/cwl_collect_outputs.py from run_test.cwl:
  verify_log:
    type: File
    outputSource: verify/log
  verify_errors:
    type: File
    outputSource: verify/errors
