<a id="aea.helpers.acn.agent_record"></a>

# aea.helpers.acn.agent`_`record

This module contains types and helpers for ACN Proof-of-Representation.

<a id="aea.helpers.acn.agent_record.AgentRecord"></a>

## AgentRecord Objects

```python
class AgentRecord()
```

Agent Proof-of-Representation to representative.

<a id="aea.helpers.acn.agent_record.AgentRecord.__init__"></a>

#### `__`init`__`

```python
def __init__(address: str, representative_public_key: str,
             identifier: SimpleIdOrStr, ledger_id: SimpleIdOrStr,
             not_before: str, not_after: str, message_format: str,
             signature: str) -> None
```

Initialize the AgentRecord

**Arguments**:

- `address`: agent address
- `representative_public_key`: representative's public key
- `identifier`: certificate identifier.
- `ledger_id`: ledger identifier the request is referring to.
- `not_before`: specify the lower bound for certificate validity. If it is a string, it must follow the format: 'YYYY-MM-DD'. It will be interpreted as timezone UTC-0.
- `not_after`: specify the lower bound for certificate validity. If it is a string, it must follow the format: 'YYYY-MM-DD'. It will be interpreted as timezone UTC-0.
- `message_format`: message format used for signing
- `signature`: proof-of-representation of this AgentRecord

<a id="aea.helpers.acn.agent_record.AgentRecord.address"></a>

#### address

```python
@property
def address() -> str
```

Get agent address

<a id="aea.helpers.acn.agent_record.AgentRecord.public_key"></a>

#### public`_`key

```python
@property
def public_key() -> str
```

Get agent public key

<a id="aea.helpers.acn.agent_record.AgentRecord.representative_public_key"></a>

#### representative`_`public`_`key

```python
@property
def representative_public_key() -> str
```

Get agent representative's public key

<a id="aea.helpers.acn.agent_record.AgentRecord.signature"></a>

#### signature

```python
@property
def signature() -> str
```

Get record signature

<a id="aea.helpers.acn.agent_record.AgentRecord.message"></a>

#### message

```python
@property
def message() -> bytes
```

Get the message.

<a id="aea.helpers.acn.agent_record.AgentRecord.identifier"></a>

#### identifier

```python
@property
def identifier() -> SimpleIdOrStr
```

Get the identifier.

<a id="aea.helpers.acn.agent_record.AgentRecord.ledger_id"></a>

#### ledger`_`id

```python
@property
def ledger_id() -> SimpleIdOrStr
```

Get ledger id.

<a id="aea.helpers.acn.agent_record.AgentRecord.not_before"></a>

#### not`_`before

```python
@property
def not_before() -> str
```

Get the not_before field.

<a id="aea.helpers.acn.agent_record.AgentRecord.not_after"></a>

#### not`_`after

```python
@property
def not_after() -> str
```

Get the not_after field.

<a id="aea.helpers.acn.agent_record.AgentRecord.message_format"></a>

#### message`_`format

```python
@property
def message_format() -> str
```

Get the message format.

<a id="aea.helpers.acn.agent_record.AgentRecord.__str__"></a>

#### `__`str`__`

```python
def __str__() -> str
```

Get string representation.

<a id="aea.helpers.acn.agent_record.AgentRecord.from_cert_request"></a>

#### from`_`cert`_`request

```python
@classmethod
def from_cert_request(cls,
                      cert_request: CertRequest,
                      address: str,
                      representative_public_key: str,
                      data_dir: Optional[PathLike] = None) -> "AgentRecord"
```

Get agent record from cert request.

