!!! note

    The (open) AEA framework provides the necessary tools for creating 
    Autonomous Economic Agents (AEA). It is a fork of the 
    <a href="https://github.com/fetchai/agents-aea" target="_blank">legacy AEA 
    framework</a> that gives no priority to any package vendor.


## What are Autonomous Economic Agents (AEAs)?

We define an AEA as:

> An intelligent agent acting on an owner's behalf, with limited or no interference, and whose goal is to generate economic value for its owner.
    
-----

The AEA framework offers the owner, either an individual, an organisation, or 
another application, the ability to outsource the pursuit of their economic 
interests. Such interests may include maximizing the acquisition of items 
from a desired basket of goods, adaptive management of market exposure,
or minimization of transaction costs within an application to benefit its users.

In order to be able to act on an owner's behalf AEAs need to be endowed with a 
sense of agency, which requires the ability to enact behaviour and exercise 
control over its consequences in a way that is commensurate with its owners' 
goals. The ability to autonomously interact with their environment and 
proactively engage in peer-to-peer dialogue is a distinctive feature of AEAs. 
Where otherwise the execution of skills and decision-making logic are left as 
an exercise to the reader, AEAs allow developers to design systems that pursue 
economic interests without the requirement of an owner to actively partake or 
continuously intervene in the process.

Information on <a href="app-areas"> areas and applications </a> of AEAs and
<a href="demos">examples of their implementation </a> are provided to illustrate 
their use.


## What is the AEA Framework?

The AEA development suite, implemented in Python, equips the developer with an 
easily accessible set of tools for building AEAs. The framework is modular, 
composable and extensible. Its purpose is to make agent development as 
straightforward as web development became with the introduction of Django and 
Flask.

A modular design of components facilitates their reuse as parts 
of other applications that might serve an entirely different set of needs. The 
framework provided offers the user:

* A peer-to-peer <a href="acn">agent communication network (ACN)</a> allows your
  AEAs to interact with all other AEAs over the public internet.
* The framework's <a href="ledger-integration">crypto and ledger APIs</a> make 
  it possible for AEAs to interact with blockchains such as 
  <a href="https://ethereum.org/en/" target="_blank">Ethereum</a>,
  and use these as a financial settlement and commitment layer. 
* A <a href="registry">registry</a> that enables code sharing and re-use by 
  providing a space in which AEAs or their individual components may be shared. 
* The <a href="contract">contract</a> packages enable AEAs to interact with 
  smart contracts on various decentralised ledgers.


## Next steps

To get started developing your own AEA, check out the 
<a href="quickstart">getting started</a> section.

If you want to run a demo, check out the <a href="demos">demo guides</a>.

To learn more about the distinctive characteristics of agent-oriented 
development, check out the guide on 
<a href="agent-oriented-development">agent-oriented development</a>.


## Help us improve

<div class="admonition note">
  <p class="admonition-title">Note</p>
  <p>This developer documentation is a work in progress. If you spot any errors please open an issue on <a href="https://github.com/valory-xyz/open-aea" target="_blank">Github</a> or contact us in the <a href="https://discord.com/invite/eRa5e9c6zh" target="_blank">developer Discord channel</a>.</p>
</div>

<br />
