# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class DataExtraInfoSubCondsValue(TeaModel):
    def __init__(
        self,
        tenant_name: str = None,
        database: str = None,
        dest_database: str = None,
        table_name: str = None,
        dest_name: str = None,
        where_clause: str = None,
        filter_columns: List[str] = None,
        shard_columns: List[str] = None,
        logic_table_id: str = None,
        source_endpoint_id: str = None,
        source_client_id: str = None,
    ):
        self.tenant_name = tenant_name
        self.database = database
        self.dest_database = dest_database
        self.table_name = table_name
        self.dest_name = dest_name
        self.where_clause = where_clause
        self.filter_columns = filter_columns
        self.shard_columns = shard_columns
        self.logic_table_id = logic_table_id
        self.source_endpoint_id = source_endpoint_id
        self.source_client_id = source_client_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        if self.database is not None:
            result['Database'] = self.database
        if self.dest_database is not None:
            result['DestDatabase'] = self.dest_database
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.dest_name is not None:
            result['DestName'] = self.dest_name
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.logic_table_id is not None:
            result['LogicTableId'] = self.logic_table_id
        if self.source_endpoint_id is not None:
            result['SourceEndpointId'] = self.source_endpoint_id
        if self.source_client_id is not None:
            result['SourceClientId'] = self.source_client_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('DestDatabase') is not None:
            self.dest_database = m.get('DestDatabase')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DestName') is not None:
            self.dest_name = m.get('DestName')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('LogicTableId') is not None:
            self.logic_table_id = m.get('LogicTableId')
        if m.get('SourceEndpointId') is not None:
            self.source_endpoint_id = m.get('SourceEndpointId')
        if m.get('SourceClientId') is not None:
            self.source_client_id = m.get('SourceClientId')
        return self


class DataExtraInfoSubDbsValueTablesColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        position: int = None,
        column_type: str = None,
        record_field_type: str = None,
        raw_column_type: str = None,
        column_key: str = None,
        nullable: bool = None,
        default_value: str = None,
        data_length: int = None,
        data_precision: int = None,
        data_scale: int = None,
        encoding: str = None,
        column_comment: str = None,
        is_generate_field: bool = None,
    ):
        self.column_name = column_name
        self.position = position
        self.column_type = column_type
        self.record_field_type = record_field_type
        self.raw_column_type = raw_column_type
        self.column_key = column_key
        self.nullable = nullable
        self.default_value = default_value
        self.data_length = data_length
        self.data_precision = data_precision
        self.data_scale = data_scale
        self.encoding = encoding
        self.column_comment = column_comment
        self.is_generate_field = is_generate_field

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.position is not None:
            result['Position'] = self.position
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.record_field_type is not None:
            result['RecordFieldType'] = self.record_field_type
        if self.raw_column_type is not None:
            result['RawColumnType'] = self.raw_column_type
        if self.column_key is not None:
            result['ColumnKey'] = self.column_key
        if self.nullable is not None:
            result['Nullable'] = self.nullable
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.data_length is not None:
            result['DataLength'] = self.data_length
        if self.data_precision is not None:
            result['DataPrecision'] = self.data_precision
        if self.data_scale is not None:
            result['DataScale'] = self.data_scale
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.column_comment is not None:
            result['ColumnComment'] = self.column_comment
        if self.is_generate_field is not None:
            result['IsGenerateField'] = self.is_generate_field
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('RecordFieldType') is not None:
            self.record_field_type = m.get('RecordFieldType')
        if m.get('RawColumnType') is not None:
            self.raw_column_type = m.get('RawColumnType')
        if m.get('ColumnKey') is not None:
            self.column_key = m.get('ColumnKey')
        if m.get('Nullable') is not None:
            self.nullable = m.get('Nullable')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('DataLength') is not None:
            self.data_length = m.get('DataLength')
        if m.get('DataPrecision') is not None:
            self.data_precision = m.get('DataPrecision')
        if m.get('DataScale') is not None:
            self.data_scale = m.get('DataScale')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ColumnComment') is not None:
            self.column_comment = m.get('ColumnComment')
        if m.get('IsGenerateField') is not None:
            self.is_generate_field = m.get('IsGenerateField')
        return self


class DataExtraInfoSubDbsValueTables(TeaModel):
    def __init__(
        self,
        table_id: str = None,
        database: str = None,
        table_name: str = None,
        mapping_table_name: str = None,
        instance: str = None,
        columns: List[DataExtraInfoSubDbsValueTablesColumns] = None,
    ):
        self.table_id = table_id
        self.database = database
        self.table_name = table_name
        self.mapping_table_name = mapping_table_name
        self.instance = instance
        self.columns = columns

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_id is not None:
            result['TableId'] = self.table_id
        if self.database is not None:
            result['Database'] = self.database
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.mapping_table_name is not None:
            result['MappingTableName'] = self.mapping_table_name
        if self.instance is not None:
            result['Instance'] = self.instance
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableId') is not None:
            self.table_id = m.get('TableId')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('MappingTableName') is not None:
            self.mapping_table_name = m.get('MappingTableName')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = DataExtraInfoSubDbsValueTablesColumns()
                self.columns.append(temp_model.from_map(k))
        return self


class DataExtraInfoSubDbsValue(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        tenant_name: str = None,
        database_id: str = None,
        database_name: str = None,
        mapping_database_name: str = None,
        source_client_id: str = None,
        tables: List[DataExtraInfoSubDbsValueTables] = None,
    ):
        self.cluster_name = cluster_name
        self.tenant_name = tenant_name
        self.database_id = database_id
        self.database_name = database_name
        self.mapping_database_name = mapping_database_name
        self.source_client_id = source_client_id
        self.tables = tables

    def validate(self):
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        if self.database_id is not None:
            result['DatabaseId'] = self.database_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.mapping_database_name is not None:
            result['MappingDatabaseName'] = self.mapping_database_name
        if self.source_client_id is not None:
            result['SourceClientId'] = self.source_client_id
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        if m.get('DatabaseId') is not None:
            self.database_id = m.get('DatabaseId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('MappingDatabaseName') is not None:
            self.mapping_database_name = m.get('MappingDatabaseName')
        if m.get('SourceClientId') is not None:
            self.source_client_id = m.get('SourceClientId')
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = DataExtraInfoSubDbsValueTables()
                self.tables.append(temp_model.from_map(k))
        return self


class BatchKillProcessListRequest(TeaModel):
    def __init__(
        self,
        by_ob_session_id: bool = None,
        instance_id: str = None,
        session_list: str = None,
        tenant_id: str = None,
    ):
        self.by_ob_session_id = by_ob_session_id
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The list of sessions to close.
        # 
        # This parameter is required.
        self.session_list = session_list
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.by_ob_session_id is not None:
            result['ByObSessionId'] = self.by_ob_session_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.session_list is not None:
            result['SessionList'] = self.session_list
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ByObSessionId') is not None:
            self.by_ob_session_id = m.get('ByObSessionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SessionList') is not None:
            self.session_list = m.get('SessionList')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class BatchKillProcessListResponseBodyData(TeaModel):
    def __init__(
        self,
        success: bool = None,
    ):
        # Indicates whether the calling is successful.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchKillProcessListResponseBody(TeaModel):
    def __init__(
        self,
        data: List[BatchKillProcessListResponseBodyData] = None,
        request_id: str = None,
    ):
        # The array of the return result.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchKillProcessListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchKillProcessListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchKillProcessListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchKillProcessListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchKillSessionListRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        session_list: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The list of sessions, which is concatenated with commas.
        # >The session information is obtained from the result returned by the DescribeSessionList API.
        # 
        # This parameter is required.
        self.session_list = session_list
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.session_list is not None:
            result['SessionList'] = self.session_list
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SessionList') is not None:
            self.session_list = m.get('SessionList')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class BatchKillSessionListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchKillSessionListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchKillSessionListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchKillSessionListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelProjectModifyRecordRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CancelProjectModifyRecordResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CancelProjectModifyRecordResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: Any = None,
        error_detail: CancelProjectModifyRecordResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CancelProjectModifyRecordResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CancelProjectModifyRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelProjectModifyRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelProjectModifyRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupSetDownloadLinkRequest(TeaModel):
    def __init__(
        self,
        backup_set_id: str = None,
        instance_id: str = None,
    ):
        # This parameter is required.
        self.backup_set_id = backup_set_id
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateBackupSetDownloadLinkResponseBody(TeaModel):
    def __init__(
        self,
        download_task_id: int = None,
        request_id: str = None,
    ):
        self.download_task_id = download_task_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_task_id is not None:
            result['DownloadTaskId'] = self.download_task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadTaskId') is not None:
            self.download_task_id = m.get('DownloadTaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupSetDownloadLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBackupSetDownloadLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupSetDownloadLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDatabaseRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        collation: str = None,
        database_name: str = None,
        description: str = None,
        encoding: str = None,
        instance_id: str = None,
        tenant_id: str = None,
    ):
        # The name of the database.
        self.client_token = client_token
        # The encoding standard of the database.
        # For more information, see the Charset field returned by the DescribeCharset operation.
        self.collation = collation
        # Alibaba Cloud CLI
        # 
        # This parameter is required.
        self.database_name = database_name
        # The operation that you want to perform.   
        # Set the value to **CreateDatabase**.
        self.description = description
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.encoding = encoding
        # The collation.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The name of the database.   
        # You cannot use reserved keywords, such as test and mysql.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.collation is not None:
            result['Collation'] = self.collation
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.description is not None:
            result['Description'] = self.description
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Collation') is not None:
            self.collation = m.get('Collation')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateDatabaseResponseBody(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        request_id: str = None,
    ):
        # CreateDatabase
        self.database_name = database_name
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDatabaseResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDatabaseResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDatabaseResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(
        self,
        auto_renew: bool = None,
        auto_renew_period: int = None,
        charge_type: str = None,
        cpu_arch: str = None,
        disk_size: int = None,
        disk_type: str = None,
        dry_run: bool = None,
        instance_class: str = None,
        instance_name: str = None,
        isolation_optimization: str = None,
        ob_version: str = None,
        period: int = None,
        period_unit: str = None,
        primary_instance: str = None,
        primary_region: str = None,
        replica_mode: str = None,
        resource_group_id: str = None,
        series: str = None,
        zones: str = None,
    ):
        # Specifies whether to enable automatic renewal.   
        # This parameter is valid only when the ChargeType parameter is set to PrePaid. Valid values: 
        # - true: enables automatic renewal for the instance.   
        # - false: disables automatic renewal for the instance. This is the default value.
        self.auto_renew = auto_renew
        # The automatic renewal period of the instance. This parameter is required when the AutoRenew parameter is set to true. Valid values:  
        # - If the PeriodUnit parameter is set to Year: "1", "2", and "3".   
        # - If the PeriodUnit parameter is set to Month: "1", "2", "3", "6", and "12".
        self.auto_renew_period = auto_renew_period
        # The billing method of the instance. Valid values:  
        # - PrePay: the subscription billing method. You must ensure that the remaining balance or credit balance of your account can cover the cost of the subscription. Otherwise, you will receive an InvalidPayMethod error. 
        # - PostPay: the pay-as-you-go billing method. This is the default value. By default, fees are charged on an hourly basis.
        # 
        # This parameter is required.
        self.charge_type = charge_type
        self.cpu_arch = cpu_arch
        # The size of the storage space,in GB.    
        # The limits on the storage space vary with the cluster specifications:   
        # - 8C32GB: 100 GB to 10000 GB   
        # - 14C70GB: 200 GB to 10000 GB   
        # - 30C180GB: 400 GB to 10000 GB   
        # - 62C400GB: 800 GB to 10000 GB    
        # The preceding minimum storage space sizes are the default storage space sizes of the corresponding cluster specification plans.
        self.disk_size = disk_size
        # The type of the storage disk where the cluster is deployed. This parameter takes effect only for Standard Cluster Edition (Cloud Disk).
        # Valid values:
        # - cloud_essd_pl1: ESSD PL1.
        # - cloud_essd_pl0: ESSD PL0. Default value: cloud_essd_pl1.
        self.disk_type = disk_type
        # Specifies whether to perform only a dry run for the request. Default value: false. Valid values:
        # - true: Only a dry-run request is sent and the instance is not created. If the dry run succeeds, DryRunResult=true is returned. If the dry run fails, an error code is returned.
        # - false: The actual request is sent and no dry run is performed. The instance is created if the requirements are met. By default, the DryRunResult parameter returns false if you set DryRun to false.
        self.dry_run = dry_run
        # The specifications of the cluster.     
        # You can specify one of the following four plans:   
        #  - 8C32GB: indicates 8 CPU cores and 32 GB of memory.    
        #  - 14C70GB: indicates 14 CPU cores and 70 GB of memory. This is the default value.
        # - 30C180GB: indicates 30 CPU cores and 180 GB of memory.     
        # - 62C400GB: indicates 62 CPU cores and 400 GB of memory.
        # 
        # This parameter is required.
        self.instance_class = instance_class
        # The name of the OceanBase cluster.    
        # It must be 1 to 20 characters in length.   
        # If this parameter is not specified, the value is the instance ID of the cluster by default.
        self.instance_name = instance_name
        # Specifies whether to enable the control group feature.
        # Valid values:
        # - true
        # - false
        self.isolation_optimization = isolation_optimization
        # OceanBase Server version number.
        self.ob_version = ob_version
        # The valid duration of the purchased resources. The unit is specified by the PeriodUnit parameter.   
        # This parameter is valid and required only when the InstanceChargeType parameter is set to PrePaid.      
        # Valid values:     
        # - When the PeriodUnit parameter is set to Month: "1", "2", "3", "4", "5", "6", "7", "8", "9". 
        # - When the PeriodUnit parameter is set to Year: "1", "2", "3".
        self.period = period
        # The unit of the valid duration of the purchased resources.     
        # Valid value for subscription: Month or Year.
        # Default value: Month for subscription, and Hour for pay-as-you-go.
        self.period_unit = period_unit
        # Primary instance ID.
        self.primary_instance = primary_instance
        # Primary instance region.
        self.primary_region = primary_region
        # The number of full-featured replicas.
        # - 3F: three full-featured replicas.
        # - 2F1L: two full-featured replicas and one log replica.
        # - 2F1A: two full-featured replicas and one arbitration service.
        # - ApsaraDB for OceanBase earlier than V4.1 supports 3F and 2F1L.
        # - ApsaraDB for OceanBase V4.1 or later supports 3F and 2F1A.
        # - An ApsaraDB for OceanBase instance deployed across three zones supports only 3F.
        # - An ApsaraDB for OceanBase instance deployed across two zones supports 2F1A or 2F1L, depending on the version.
        # - An ApsaraDB for OceanBase instance deployed in a single zone supports 3F, 2F1A, or 2F1L, depending on the version.
        self.replica_mode = replica_mode
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The series of the OceanBase cluster. Valid values:    
        # - normal: Standard Cluster Edition (Cloud Disk). This is the default value.
        # - normal_ssd: Standard Cluster Edition (Local Disk).
        # - history: History Database Cluster Edition.
        # 
        # This parameter is required.
        self.series = series
        # The ID of the zone to which the instance belongs.   
        # For more information about how to obtain the list of zones, see [DescribeZones](https://help.aliyun.com/document_detail/25610.html).
        # 
        # This parameter is required.
        self.zones = zones

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.isolation_optimization is not None:
            result['IsolationOptimization'] = self.isolation_optimization
        if self.ob_version is not None:
            result['ObVersion'] = self.ob_version
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.primary_instance is not None:
            result['PrimaryInstance'] = self.primary_instance
        if self.primary_region is not None:
            result['PrimaryRegion'] = self.primary_region
        if self.replica_mode is not None:
            result['ReplicaMode'] = self.replica_mode
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.series is not None:
            result['Series'] = self.series
        if self.zones is not None:
            result['Zones'] = self.zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IsolationOptimization') is not None:
            self.isolation_optimization = m.get('IsolationOptimization')
        if m.get('ObVersion') is not None:
            self.ob_version = m.get('ObVersion')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PrimaryInstance') is not None:
            self.primary_instance = m.get('PrimaryInstance')
        if m.get('PrimaryRegion') is not None:
            self.primary_region = m.get('PrimaryRegion')
        if m.get('ReplicaMode') is not None:
            self.replica_mode = m.get('ReplicaMode')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Series') is not None:
            self.series = m.get('Series')
        if m.get('Zones') is not None:
            self.zones = m.get('Zones')
        return self


class CreateInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        dry_run_result: bool = None,
        instance_id: str = None,
        order_id: str = None,
        resource_group_id: str = None,
    ):
        # The result of the dry-run request.
        # 
        # If the DryRun parameter is set to true and the dry run succeeds, the DryRunResult parameter returns true. Otherwise, an error code is returned.
        # If the DryRun parameter is set to false, no dry run is performed and the DryRunResult parameter returns false.
        self.dry_run_result = dry_run_result
        # Instance ID.
        self.instance_id = instance_id
        # Order ID. The ID of the order that you have placed.
        # This parameter returns a value after you create a pre-paid or post-paid cluster.
        self.order_id = order_id
        # Resource group ID.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run_result is not None:
            result['DryRunResult'] = self.dry_run_result
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DryRunResult') is not None:
            self.dry_run_result = m.get('DryRunResult')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateInstanceResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLabelRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # This parameter is required.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateLabelResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateLabelResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: str = None,
        error_detail: CreateLabelResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateLabelResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateLabelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLabelResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLabelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMySqlDataSourceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dg_instance_id: str = None,
        instance_id: str = None,
        ip: str = None,
        name: str = None,
        password: str = None,
        port: int = None,
        schema: str = None,
        type: str = None,
        use_ssl: bool = None,
        user_name: str = None,
        vpc_id: str = None,
    ):
        self.description = description
        self.dg_instance_id = dg_instance_id
        self.instance_id = instance_id
        self.ip = ip
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.password = password
        self.port = port
        self.schema = schema
        # This parameter is required.
        self.type = type
        self.use_ssl = use_ssl
        # This parameter is required.
        self.user_name = user_name
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dg_instance_id is not None:
            result['DgInstanceId'] = self.dg_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.name is not None:
            result['Name'] = self.name
        if self.password is not None:
            result['Password'] = self.password
        if self.port is not None:
            result['Port'] = self.port
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.type is not None:
            result['Type'] = self.type
        if self.use_ssl is not None:
            result['UseSsl'] = self.use_ssl
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DgInstanceId') is not None:
            self.dg_instance_id = m.get('DgInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UseSsl') is not None:
            self.use_ssl = m.get('UseSsl')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateMySqlDataSourceResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateMySqlDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: str = None,
        error_detail: CreateMySqlDataSourceResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateMySqlDataSourceResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateMySqlDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateMySqlDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMySqlDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOasOutlineTaskRequest(TeaModel):
    def __init__(
        self,
        by_sql_id: bool = None,
        database_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        index_name: str = None,
        instance_id: str = None,
        is_concurrent_limit: bool = None,
        max_concurrent: int = None,
        plan_data: str = None,
        sql_id: str = None,
        sql_text: str = None,
        start_time: str = None,
        statement_id: str = None,
        table_name: str = None,
        tenant_id: str = None,
        uid: str = None,
    ):
        self.by_sql_id = by_sql_id
        # This parameter is required.
        self.database_name = database_name
        self.dynamic_sql = dynamic_sql
        self.end_time = end_time
        self.index_name = index_name
        # This parameter is required.
        self.instance_id = instance_id
        self.is_concurrent_limit = is_concurrent_limit
        self.max_concurrent = max_concurrent
        self.plan_data = plan_data
        # SQL ID
        self.sql_id = sql_id
        # This parameter is required.
        self.sql_text = sql_text
        self.start_time = start_time
        self.statement_id = statement_id
        self.table_name = table_name
        # This parameter is required.
        self.tenant_id = tenant_id
        self.uid = uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.by_sql_id is not None:
            result['BySqlId'] = self.by_sql_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.index_name is not None:
            result['IndexName'] = self.index_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_concurrent_limit is not None:
            result['IsConcurrentLimit'] = self.is_concurrent_limit
        if self.max_concurrent is not None:
            result['MaxConcurrent'] = self.max_concurrent
        if self.plan_data is not None:
            result['PlanData'] = self.plan_data
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.statement_id is not None:
            result['StatementId'] = self.statement_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.uid is not None:
            result['UId'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BySqlId') is not None:
            self.by_sql_id = m.get('BySqlId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IndexName') is not None:
            self.index_name = m.get('IndexName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsConcurrentLimit') is not None:
            self.is_concurrent_limit = m.get('IsConcurrentLimit')
        if m.get('MaxConcurrent') is not None:
            self.max_concurrent = m.get('MaxConcurrent')
        if m.get('PlanData') is not None:
            self.plan_data = m.get('PlanData')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StatementId') is not None:
            self.statement_id = m.get('StatementId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UId') is not None:
            self.uid = m.get('UId')
        return self


class CreateOasOutlineTaskResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOasOutlineTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOasOutlineTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOasOutlineTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOceanBaseDataSourceRequest(TeaModel):
    def __init__(
        self,
        cluster: str = None,
        config_url: str = None,
        description: str = None,
        drc_password: str = None,
        drc_user_name: str = None,
        inner_drc_password: str = None,
        ip: str = None,
        log_proxy_ip: str = None,
        log_proxy_port: str = None,
        name: str = None,
        password: str = None,
        port: int = None,
        tenant: str = None,
        type: str = None,
        user_name: str = None,
        vpc_id: str = None,
    ):
        self.cluster = cluster
        self.config_url = config_url
        self.description = description
        self.drc_password = drc_password
        self.drc_user_name = drc_user_name
        self.inner_drc_password = inner_drc_password
        self.ip = ip
        # LogProxy IP。
        self.log_proxy_ip = log_proxy_ip
        self.log_proxy_port = log_proxy_port
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.password = password
        self.port = port
        # This parameter is required.
        self.tenant = tenant
        # This parameter is required.
        self.type = type
        # This parameter is required.
        self.user_name = user_name
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster is not None:
            result['Cluster'] = self.cluster
        if self.config_url is not None:
            result['ConfigUrl'] = self.config_url
        if self.description is not None:
            result['Description'] = self.description
        if self.drc_password is not None:
            result['DrcPassword'] = self.drc_password
        if self.drc_user_name is not None:
            result['DrcUserName'] = self.drc_user_name
        if self.inner_drc_password is not None:
            result['InnerDrcPassword'] = self.inner_drc_password
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.log_proxy_ip is not None:
            result['LogProxyIp'] = self.log_proxy_ip
        if self.log_proxy_port is not None:
            result['LogProxyPort'] = self.log_proxy_port
        if self.name is not None:
            result['Name'] = self.name
        if self.password is not None:
            result['Password'] = self.password
        if self.port is not None:
            result['Port'] = self.port
        if self.tenant is not None:
            result['Tenant'] = self.tenant
        if self.type is not None:
            result['Type'] = self.type
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cluster') is not None:
            self.cluster = m.get('Cluster')
        if m.get('ConfigUrl') is not None:
            self.config_url = m.get('ConfigUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DrcPassword') is not None:
            self.drc_password = m.get('DrcPassword')
        if m.get('DrcUserName') is not None:
            self.drc_user_name = m.get('DrcUserName')
        if m.get('InnerDrcPassword') is not None:
            self.inner_drc_password = m.get('InnerDrcPassword')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LogProxyIp') is not None:
            self.log_proxy_ip = m.get('LogProxyIp')
        if m.get('LogProxyPort') is not None:
            self.log_proxy_port = m.get('LogProxyPort')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Tenant') is not None:
            self.tenant = m.get('Tenant')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateOceanBaseDataSourceResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateOceanBaseDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: str = None,
        error_detail: CreateOceanBaseDataSourceResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateOceanBaseDataSourceResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateOceanBaseDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOceanBaseDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOceanBaseDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOmsMysqlDataSourceRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dg_database_id: str = None,
        instance_id: str = None,
        ip: str = None,
        name: str = None,
        password: str = None,
        port: str = None,
        schema: str = None,
        type: str = None,
        username: str = None,
        vpc_id: str = None,
    ):
        # The description of the data source.   
        # 
        # It must be 2 to 256 characters in length. The default value is null.
        self.description = description
        # The ID of the database gateway instance.   
        # 
        # > <br>If Type is set to DG, this parameter is required.
        self.dg_database_id = dg_database_id
        # The ID of the ECS instance of the data source.   
        # 
        # > <br>If Type is set to RDS, PolarDB, or DG, this parameter is required.
        self.instance_id = instance_id
        # The IP address of the data source.   
        # 
        # > <br>If Type is set to INTERNET or VPC, this parameter is required.
        self.ip = ip
        # The name of the data source.   
        # It must be 2 to 128 characters in length and can contain letters, digits, underscores (_), periods (.), and hyphens (-).   
        # 
        # > <br>Invalid characters, such as slashes (/), are not allowed.
        # 
        # This parameter is required.
        self.name = name
        # The password of the username that is used to access the database. It must be Base64 encoded.   
        # For example, for the password abcd123@!, the Base64-encoded value is YWJjZDEyM0Ah.
        # 
        # This parameter is required.
        self.password = password
        # The port number of the data source.   
        # 
        # > <br>If Type is set to INTERNET or VPC, this parameter is required.
        self.port = port
        # The name of the database.   
        # 
        # > <br>If you specify this parameter, subsequent migration or synchronization operations will take effect on this database only.
        self.schema = schema
        # The type of the MySQL data source.   
        # Valid values: INTERNET, VPC, RDS, PolarDB, and DG.
        # 
        # This parameter is required.
        self.type = type
        # The username that is used to access the database.
        # 
        # This parameter is required.
        self.username = username
        # The ID of the VPC to which the data source belongs.   
        # 
        # > <br>If Type is set to VPC, this parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dg_database_id is not None:
            result['DgDatabaseId'] = self.dg_database_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.name is not None:
            result['Name'] = self.name
        if self.password is not None:
            result['Password'] = self.password
        if self.port is not None:
            result['Port'] = self.port
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.type is not None:
            result['Type'] = self.type
        if self.username is not None:
            result['Username'] = self.username
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DgDatabaseId') is not None:
            self.dg_database_id = m.get('DgDatabaseId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateOmsMysqlDataSourceResponseBodyData(TeaModel):
    def __init__(
        self,
        endpoint_id: str = None,
    ):
        # The ID of the data source record.
        self.endpoint_id = endpoint_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint_id is not None:
            result['EndpointId'] = self.endpoint_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndpointId') is not None:
            self.endpoint_id = m.get('EndpointId')
        return self


class CreateOmsMysqlDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateOmsMysqlDataSourceResponseBodyData = None,
        request_id: str = None,
    ):
        # The return result of the request.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateOmsMysqlDataSourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOmsMysqlDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOmsMysqlDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOmsMysqlDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectRequestCommonTransferConfigCustomColumns(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        expression: str = None,
    ):
        self.column_name = column_name
        self.expression = expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.expression is not None:
            result['Expression'] = self.expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        return self


class CreateProjectRequestCommonTransferConfig(TeaModel):
    def __init__(
        self,
        active_active: bool = None,
        custom_columns: List[CreateProjectRequestCommonTransferConfigCustomColumns] = None,
        data_works_business_name: str = None,
        datahub_topic_type: str = None,
        mq_partition: int = None,
        mq_partition_mode: str = None,
        mq_serializer_type: str = None,
        rocket_mq_enable_msg_trace: bool = None,
        rocket_mq_msg_tags: str = None,
        rocket_mq_producer_group: str = None,
        rocket_mq_send_msg_timeout: int = None,
        sink_store_format: str = None,
        source_store_format: str = None,
        sync_schema: bool = None,
        sync_schema_column_name: str = None,
        table_category: str = None,
    ):
        self.active_active = active_active
        self.custom_columns = custom_columns
        self.data_works_business_name = data_works_business_name
        self.datahub_topic_type = datahub_topic_type
        self.mq_partition = mq_partition
        self.mq_partition_mode = mq_partition_mode
        self.mq_serializer_type = mq_serializer_type
        self.rocket_mq_enable_msg_trace = rocket_mq_enable_msg_trace
        self.rocket_mq_msg_tags = rocket_mq_msg_tags
        self.rocket_mq_producer_group = rocket_mq_producer_group
        self.rocket_mq_send_msg_timeout = rocket_mq_send_msg_timeout
        self.sink_store_format = sink_store_format
        self.source_store_format = source_store_format
        self.sync_schema = sync_schema
        self.sync_schema_column_name = sync_schema_column_name
        self.table_category = table_category

    def validate(self):
        if self.custom_columns:
            for k in self.custom_columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_active is not None:
            result['ActiveActive'] = self.active_active
        result['CustomColumns'] = []
        if self.custom_columns is not None:
            for k in self.custom_columns:
                result['CustomColumns'].append(k.to_map() if k else None)
        if self.data_works_business_name is not None:
            result['DataWorksBusinessName'] = self.data_works_business_name
        if self.datahub_topic_type is not None:
            result['DatahubTopicType'] = self.datahub_topic_type
        if self.mq_partition is not None:
            result['MqPartition'] = self.mq_partition
        if self.mq_partition_mode is not None:
            result['MqPartitionMode'] = self.mq_partition_mode
        if self.mq_serializer_type is not None:
            result['MqSerializerType'] = self.mq_serializer_type
        if self.rocket_mq_enable_msg_trace is not None:
            result['RocketMqEnableMsgTrace'] = self.rocket_mq_enable_msg_trace
        if self.rocket_mq_msg_tags is not None:
            result['RocketMqMsgTags'] = self.rocket_mq_msg_tags
        if self.rocket_mq_producer_group is not None:
            result['RocketMqProducerGroup'] = self.rocket_mq_producer_group
        if self.rocket_mq_send_msg_timeout is not None:
            result['RocketMqSendMsgTimeout'] = self.rocket_mq_send_msg_timeout
        if self.sink_store_format is not None:
            result['SinkStoreFormat'] = self.sink_store_format
        if self.source_store_format is not None:
            result['SourceStoreFormat'] = self.source_store_format
        if self.sync_schema is not None:
            result['SyncSchema'] = self.sync_schema
        if self.sync_schema_column_name is not None:
            result['SyncSchemaColumnName'] = self.sync_schema_column_name
        if self.table_category is not None:
            result['TableCategory'] = self.table_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveActive') is not None:
            self.active_active = m.get('ActiveActive')
        self.custom_columns = []
        if m.get('CustomColumns') is not None:
            for k in m.get('CustomColumns'):
                temp_model = CreateProjectRequestCommonTransferConfigCustomColumns()
                self.custom_columns.append(temp_model.from_map(k))
        if m.get('DataWorksBusinessName') is not None:
            self.data_works_business_name = m.get('DataWorksBusinessName')
        if m.get('DatahubTopicType') is not None:
            self.datahub_topic_type = m.get('DatahubTopicType')
        if m.get('MqPartition') is not None:
            self.mq_partition = m.get('MqPartition')
        if m.get('MqPartitionMode') is not None:
            self.mq_partition_mode = m.get('MqPartitionMode')
        if m.get('MqSerializerType') is not None:
            self.mq_serializer_type = m.get('MqSerializerType')
        if m.get('RocketMqEnableMsgTrace') is not None:
            self.rocket_mq_enable_msg_trace = m.get('RocketMqEnableMsgTrace')
        if m.get('RocketMqMsgTags') is not None:
            self.rocket_mq_msg_tags = m.get('RocketMqMsgTags')
        if m.get('RocketMqProducerGroup') is not None:
            self.rocket_mq_producer_group = m.get('RocketMqProducerGroup')
        if m.get('RocketMqSendMsgTimeout') is not None:
            self.rocket_mq_send_msg_timeout = m.get('RocketMqSendMsgTimeout')
        if m.get('SinkStoreFormat') is not None:
            self.sink_store_format = m.get('SinkStoreFormat')
        if m.get('SourceStoreFormat') is not None:
            self.source_store_format = m.get('SourceStoreFormat')
        if m.get('SyncSchema') is not None:
            self.sync_schema = m.get('SyncSchema')
        if m.get('SyncSchemaColumnName') is not None:
            self.sync_schema_column_name = m.get('SyncSchemaColumnName')
        if m.get('TableCategory') is not None:
            self.table_category = m.get('TableCategory')
        return self


class CreateProjectRequestFullTransferConfig(TeaModel):
    def __init__(
        self,
        allow_dest_table_not_empty: bool = None,
        full_transfer_speed_mode: str = None,
        full_verify_speed_mode: str = None,
        hbase_obj_check_mode: str = None,
        hbase_obj_mig_mode: str = None,
        index_ddlconcurrency_limit: int = None,
        max_concurrent_index_ddls: int = None,
        none_pk_uk_truncate_dst_table: bool = None,
        read_worker_num: int = None,
        throttle_iops: int = None,
        throttle_rps: int = None,
        write_worker_num: int = None,
    ):
        self.allow_dest_table_not_empty = allow_dest_table_not_empty
        self.full_transfer_speed_mode = full_transfer_speed_mode
        self.full_verify_speed_mode = full_verify_speed_mode
        self.hbase_obj_check_mode = hbase_obj_check_mode
        self.hbase_obj_mig_mode = hbase_obj_mig_mode
        self.index_ddlconcurrency_limit = index_ddlconcurrency_limit
        self.max_concurrent_index_ddls = max_concurrent_index_ddls
        self.none_pk_uk_truncate_dst_table = none_pk_uk_truncate_dst_table
        self.read_worker_num = read_worker_num
        self.throttle_iops = throttle_iops
        self.throttle_rps = throttle_rps
        self.write_worker_num = write_worker_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_dest_table_not_empty is not None:
            result['AllowDestTableNotEmpty'] = self.allow_dest_table_not_empty
        if self.full_transfer_speed_mode is not None:
            result['FullTransferSpeedMode'] = self.full_transfer_speed_mode
        if self.full_verify_speed_mode is not None:
            result['FullVerifySpeedMode'] = self.full_verify_speed_mode
        if self.hbase_obj_check_mode is not None:
            result['HbaseObjCheckMode'] = self.hbase_obj_check_mode
        if self.hbase_obj_mig_mode is not None:
            result['HbaseObjMigMode'] = self.hbase_obj_mig_mode
        if self.index_ddlconcurrency_limit is not None:
            result['IndexDDLConcurrencyLimit'] = self.index_ddlconcurrency_limit
        if self.max_concurrent_index_ddls is not None:
            result['MaxConcurrentIndexDDLs'] = self.max_concurrent_index_ddls
        if self.none_pk_uk_truncate_dst_table is not None:
            result['NonePkUkTruncateDstTable'] = self.none_pk_uk_truncate_dst_table
        if self.read_worker_num is not None:
            result['ReadWorkerNum'] = self.read_worker_num
        if self.throttle_iops is not None:
            result['ThrottleIOPS'] = self.throttle_iops
        if self.throttle_rps is not None:
            result['ThrottleRps'] = self.throttle_rps
        if self.write_worker_num is not None:
            result['WriteWorkerNum'] = self.write_worker_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowDestTableNotEmpty') is not None:
            self.allow_dest_table_not_empty = m.get('AllowDestTableNotEmpty')
        if m.get('FullTransferSpeedMode') is not None:
            self.full_transfer_speed_mode = m.get('FullTransferSpeedMode')
        if m.get('FullVerifySpeedMode') is not None:
            self.full_verify_speed_mode = m.get('FullVerifySpeedMode')
        if m.get('HbaseObjCheckMode') is not None:
            self.hbase_obj_check_mode = m.get('HbaseObjCheckMode')
        if m.get('HbaseObjMigMode') is not None:
            self.hbase_obj_mig_mode = m.get('HbaseObjMigMode')
        if m.get('IndexDDLConcurrencyLimit') is not None:
            self.index_ddlconcurrency_limit = m.get('IndexDDLConcurrencyLimit')
        if m.get('MaxConcurrentIndexDDLs') is not None:
            self.max_concurrent_index_ddls = m.get('MaxConcurrentIndexDDLs')
        if m.get('NonePkUkTruncateDstTable') is not None:
            self.none_pk_uk_truncate_dst_table = m.get('NonePkUkTruncateDstTable')
        if m.get('ReadWorkerNum') is not None:
            self.read_worker_num = m.get('ReadWorkerNum')
        if m.get('ThrottleIOPS') is not None:
            self.throttle_iops = m.get('ThrottleIOPS')
        if m.get('ThrottleRps') is not None:
            self.throttle_rps = m.get('ThrottleRps')
        if m.get('WriteWorkerNum') is not None:
            self.write_worker_num = m.get('WriteWorkerNum')
        return self


class CreateProjectRequestIncrTransferConfig(TeaModel):
    def __init__(
        self,
        enable_incr_sync_statistics: bool = None,
        enable_sequencing_within_txn: bool = None,
        incr_sync_concurrency: int = None,
        record_type_white_list: List[str] = None,
        start_timestamp: str = None,
        store_log_kept_hour: int = None,
        support_ddltypes: List[str] = None,
        throttle_iops: int = None,
        throttle_rps: int = None,
    ):
        self.enable_incr_sync_statistics = enable_incr_sync_statistics
        self.enable_sequencing_within_txn = enable_sequencing_within_txn
        self.incr_sync_concurrency = incr_sync_concurrency
        self.record_type_white_list = record_type_white_list
        self.start_timestamp = start_timestamp
        self.store_log_kept_hour = store_log_kept_hour
        self.support_ddltypes = support_ddltypes
        self.throttle_iops = throttle_iops
        self.throttle_rps = throttle_rps

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_incr_sync_statistics is not None:
            result['EnableIncrSyncStatistics'] = self.enable_incr_sync_statistics
        if self.enable_sequencing_within_txn is not None:
            result['EnableSequencingWithinTxn'] = self.enable_sequencing_within_txn
        if self.incr_sync_concurrency is not None:
            result['IncrSyncConcurrency'] = self.incr_sync_concurrency
        if self.record_type_white_list is not None:
            result['RecordTypeWhiteList'] = self.record_type_white_list
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        if self.store_log_kept_hour is not None:
            result['StoreLogKeptHour'] = self.store_log_kept_hour
        if self.support_ddltypes is not None:
            result['SupportDDLTypes'] = self.support_ddltypes
        if self.throttle_iops is not None:
            result['ThrottleIOPS'] = self.throttle_iops
        if self.throttle_rps is not None:
            result['ThrottleRps'] = self.throttle_rps
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableIncrSyncStatistics') is not None:
            self.enable_incr_sync_statistics = m.get('EnableIncrSyncStatistics')
        if m.get('EnableSequencingWithinTxn') is not None:
            self.enable_sequencing_within_txn = m.get('EnableSequencingWithinTxn')
        if m.get('IncrSyncConcurrency') is not None:
            self.incr_sync_concurrency = m.get('IncrSyncConcurrency')
        if m.get('RecordTypeWhiteList') is not None:
            self.record_type_white_list = m.get('RecordTypeWhiteList')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        if m.get('StoreLogKeptHour') is not None:
            self.store_log_kept_hour = m.get('StoreLogKeptHour')
        if m.get('SupportDDLTypes') is not None:
            self.support_ddltypes = m.get('SupportDDLTypes')
        if m.get('ThrottleIOPS') is not None:
            self.throttle_iops = m.get('ThrottleIOPS')
        if m.get('ThrottleRps') is not None:
            self.throttle_rps = m.get('ThrottleRps')
        return self


class CreateProjectRequestReverseIncrTransferConfig(TeaModel):
    def __init__(
        self,
        enable_incr_sync_statistics: bool = None,
        enable_sequencing_within_txn: bool = None,
        incr_sync_concurrency: int = None,
        record_type_white_list: List[str] = None,
        start_timestamp: str = None,
        store_log_kept_hour: int = None,
        support_ddltypes: List[str] = None,
        throttle_iops: int = None,
        throttle_rps: int = None,
    ):
        self.enable_incr_sync_statistics = enable_incr_sync_statistics
        self.enable_sequencing_within_txn = enable_sequencing_within_txn
        self.incr_sync_concurrency = incr_sync_concurrency
        self.record_type_white_list = record_type_white_list
        self.start_timestamp = start_timestamp
        self.store_log_kept_hour = store_log_kept_hour
        self.support_ddltypes = support_ddltypes
        self.throttle_iops = throttle_iops
        self.throttle_rps = throttle_rps

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_incr_sync_statistics is not None:
            result['EnableIncrSyncStatistics'] = self.enable_incr_sync_statistics
        if self.enable_sequencing_within_txn is not None:
            result['EnableSequencingWithinTxn'] = self.enable_sequencing_within_txn
        if self.incr_sync_concurrency is not None:
            result['IncrSyncConcurrency'] = self.incr_sync_concurrency
        if self.record_type_white_list is not None:
            result['RecordTypeWhiteList'] = self.record_type_white_list
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        if self.store_log_kept_hour is not None:
            result['StoreLogKeptHour'] = self.store_log_kept_hour
        if self.support_ddltypes is not None:
            result['SupportDDLTypes'] = self.support_ddltypes
        if self.throttle_iops is not None:
            result['ThrottleIOPS'] = self.throttle_iops
        if self.throttle_rps is not None:
            result['ThrottleRps'] = self.throttle_rps
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableIncrSyncStatistics') is not None:
            self.enable_incr_sync_statistics = m.get('EnableIncrSyncStatistics')
        if m.get('EnableSequencingWithinTxn') is not None:
            self.enable_sequencing_within_txn = m.get('EnableSequencingWithinTxn')
        if m.get('IncrSyncConcurrency') is not None:
            self.incr_sync_concurrency = m.get('IncrSyncConcurrency')
        if m.get('RecordTypeWhiteList') is not None:
            self.record_type_white_list = m.get('RecordTypeWhiteList')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        if m.get('StoreLogKeptHour') is not None:
            self.store_log_kept_hour = m.get('StoreLogKeptHour')
        if m.get('SupportDDLTypes') is not None:
            self.support_ddltypes = m.get('SupportDDLTypes')
        if m.get('ThrottleIOPS') is not None:
            self.throttle_iops = m.get('ThrottleIOPS')
        if m.get('ThrottleRps') is not None:
            self.throttle_rps = m.get('ThrottleRps')
        return self


class CreateProjectRequestStructTransferConfig(TeaModel):
    def __init__(
        self,
        byte_char_convert_strategy: str = None,
        defer_index_creation: bool = None,
    ):
        self.byte_char_convert_strategy = byte_char_convert_strategy
        self.defer_index_creation = defer_index_creation

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.byte_char_convert_strategy is not None:
            result['ByteCharConvertStrategy'] = self.byte_char_convert_strategy
        if self.defer_index_creation is not None:
            result['DeferIndexCreation'] = self.defer_index_creation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ByteCharConvertStrategy') is not None:
            self.byte_char_convert_strategy = m.get('ByteCharConvertStrategy')
        if m.get('DeferIndexCreation') is not None:
            self.defer_index_creation = m.get('DeferIndexCreation')
        return self


class CreateProjectRequestTransferMappingDatabasesSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesTablesObkvPartitionConfig(TeaModel):
    def __init__(
        self,
        partition_size: int = None,
        partition_type: str = None,
        virtual_column: str = None,
    ):
        self.partition_size = partition_size
        self.partition_type = partition_type
        self.virtual_column = virtual_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_size is not None:
            result['PartitionSize'] = self.partition_size
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.virtual_column is not None:
            result['VirtualColumn'] = self.virtual_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionSize') is not None:
            self.partition_size = m.get('PartitionSize')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('VirtualColumn') is not None:
            self.virtual_column = m.get('VirtualColumn')
        return self


class CreateProjectRequestTransferMappingDatabasesTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        obkv_partition_config: CreateProjectRequestTransferMappingDatabasesTablesObkvPartitionConfig = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.obkv_partition_config = obkv_partition_config
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()
        if self.obkv_partition_config:
            self.obkv_partition_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.obkv_partition_config is not None:
            result['ObkvPartitionConfig'] = self.obkv_partition_config.to_map()
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObkvPartitionConfig') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesTablesObkvPartitionConfig()
            self.obkv_partition_config = temp_model.from_map(m['ObkvPartitionConfig'])
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabases(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectRequestTransferMappingDatabasesSpecificTables] = None,
        specific_views: List[CreateProjectRequestTransferMappingDatabasesSpecificViews] = None,
        tables: List[CreateProjectRequestTransferMappingDatabasesTables] = None,
        tenant_name: str = None,
        views: List[CreateProjectRequestTransferMappingDatabasesViews] = None,
    ):
        self.cluster_name = cluster_name
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.tenant_name = tenant_name
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectRequestTransferMappingDatabasesSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectRequestTransferMappingDatabasesSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectRequestTransferMappingDatabasesTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectRequestTransferMappingDatabasesViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesBlackTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesBlackTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectRequestTransferMappingDatabasesBlackViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectRequestTransferMappingDatabasesBlackViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectRequestTransferMappingDatabasesBlackViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectRequestTransferMappingDatabasesBlack(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectRequestTransferMappingDatabasesBlackSpecificTables] = None,
        specific_views: List[CreateProjectRequestTransferMappingDatabasesBlackSpecificViews] = None,
        tables: List[CreateProjectRequestTransferMappingDatabasesBlackTables] = None,
        tenant_name: str = None,
        views: List[CreateProjectRequestTransferMappingDatabasesBlackViews] = None,
    ):
        self.cluster_name = cluster_name
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.tenant_name = tenant_name
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectRequestTransferMappingDatabasesBlackSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectRequestTransferMappingDatabasesBlackSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectRequestTransferMappingDatabasesBlackTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectRequestTransferMappingDatabasesBlackViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectRequestTransferMapping(TeaModel):
    def __init__(
        self,
        databases: List[CreateProjectRequestTransferMappingDatabases] = None,
        databases_black: List[CreateProjectRequestTransferMappingDatabasesBlack] = None,
        mode: str = None,
        table_and_view_black_list: List[str] = None,
        table_and_view_white_list: List[str] = None,
    ):
        self.databases = databases
        self.databases_black = databases_black
        self.mode = mode
        self.table_and_view_black_list = table_and_view_black_list
        self.table_and_view_white_list = table_and_view_white_list

    def validate(self):
        if self.databases:
            for k in self.databases:
                if k:
                    k.validate()
        if self.databases_black:
            for k in self.databases_black:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Databases'] = []
        if self.databases is not None:
            for k in self.databases:
                result['Databases'].append(k.to_map() if k else None)
        result['DatabasesBlack'] = []
        if self.databases_black is not None:
            for k in self.databases_black:
                result['DatabasesBlack'].append(k.to_map() if k else None)
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.table_and_view_black_list is not None:
            result['TableAndViewBlackList'] = self.table_and_view_black_list
        if self.table_and_view_white_list is not None:
            result['TableAndViewWhiteList'] = self.table_and_view_white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.databases = []
        if m.get('Databases') is not None:
            for k in m.get('Databases'):
                temp_model = CreateProjectRequestTransferMappingDatabases()
                self.databases.append(temp_model.from_map(k))
        self.databases_black = []
        if m.get('DatabasesBlack') is not None:
            for k in m.get('DatabasesBlack'):
                temp_model = CreateProjectRequestTransferMappingDatabasesBlack()
                self.databases_black.append(temp_model.from_map(k))
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('TableAndViewBlackList') is not None:
            self.table_and_view_black_list = m.get('TableAndViewBlackList')
        if m.get('TableAndViewWhiteList') is not None:
            self.table_and_view_white_list = m.get('TableAndViewWhiteList')
        return self


class CreateProjectRequest(TeaModel):
    def __init__(
        self,
        common_transfer_config: CreateProjectRequestCommonTransferConfig = None,
        enable_full_transfer: bool = None,
        enable_full_verify: bool = None,
        enable_incr_transfer: bool = None,
        enable_reverse_incr_transfer: bool = None,
        enable_struct_transfer: bool = None,
        full_transfer_config: CreateProjectRequestFullTransferConfig = None,
        id: str = None,
        incr_transfer_config: CreateProjectRequestIncrTransferConfig = None,
        label_ids: List[str] = None,
        name: str = None,
        oss_key: str = None,
        reverse_incr_transfer_config: CreateProjectRequestReverseIncrTransferConfig = None,
        sink_endpoint_id: str = None,
        source_endpoint_id: str = None,
        struct_transfer_config: CreateProjectRequestStructTransferConfig = None,
        transfer_mapping: CreateProjectRequestTransferMapping = None,
        type: str = None,
        use_oss: bool = None,
        worker_grade_id: str = None,
    ):
        self.common_transfer_config = common_transfer_config
        self.enable_full_transfer = enable_full_transfer
        self.enable_full_verify = enable_full_verify
        self.enable_incr_transfer = enable_incr_transfer
        self.enable_reverse_incr_transfer = enable_reverse_incr_transfer
        self.enable_struct_transfer = enable_struct_transfer
        self.full_transfer_config = full_transfer_config
        # This parameter is required.
        self.id = id
        self.incr_transfer_config = incr_transfer_config
        self.label_ids = label_ids
        # This parameter is required.
        self.name = name
        self.oss_key = oss_key
        self.reverse_incr_transfer_config = reverse_incr_transfer_config
        # This parameter is required.
        self.sink_endpoint_id = sink_endpoint_id
        # This parameter is required.
        self.source_endpoint_id = source_endpoint_id
        self.struct_transfer_config = struct_transfer_config
        # This parameter is required.
        self.transfer_mapping = transfer_mapping
        # This parameter is required.
        self.type = type
        self.use_oss = use_oss
        # This parameter is required.
        self.worker_grade_id = worker_grade_id

    def validate(self):
        if self.common_transfer_config:
            self.common_transfer_config.validate()
        if self.full_transfer_config:
            self.full_transfer_config.validate()
        if self.incr_transfer_config:
            self.incr_transfer_config.validate()
        if self.reverse_incr_transfer_config:
            self.reverse_incr_transfer_config.validate()
        if self.struct_transfer_config:
            self.struct_transfer_config.validate()
        if self.transfer_mapping:
            self.transfer_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_transfer_config is not None:
            result['CommonTransferConfig'] = self.common_transfer_config.to_map()
        if self.enable_full_transfer is not None:
            result['EnableFullTransfer'] = self.enable_full_transfer
        if self.enable_full_verify is not None:
            result['EnableFullVerify'] = self.enable_full_verify
        if self.enable_incr_transfer is not None:
            result['EnableIncrTransfer'] = self.enable_incr_transfer
        if self.enable_reverse_incr_transfer is not None:
            result['EnableReverseIncrTransfer'] = self.enable_reverse_incr_transfer
        if self.enable_struct_transfer is not None:
            result['EnableStructTransfer'] = self.enable_struct_transfer
        if self.full_transfer_config is not None:
            result['FullTransferConfig'] = self.full_transfer_config.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.incr_transfer_config is not None:
            result['IncrTransferConfig'] = self.incr_transfer_config.to_map()
        if self.label_ids is not None:
            result['LabelIds'] = self.label_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.reverse_incr_transfer_config is not None:
            result['ReverseIncrTransferConfig'] = self.reverse_incr_transfer_config.to_map()
        if self.sink_endpoint_id is not None:
            result['SinkEndpointId'] = self.sink_endpoint_id
        if self.source_endpoint_id is not None:
            result['SourceEndpointId'] = self.source_endpoint_id
        if self.struct_transfer_config is not None:
            result['StructTransferConfig'] = self.struct_transfer_config.to_map()
        if self.transfer_mapping is not None:
            result['TransferMapping'] = self.transfer_mapping.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.use_oss is not None:
            result['UseOss'] = self.use_oss
        if self.worker_grade_id is not None:
            result['WorkerGradeId'] = self.worker_grade_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommonTransferConfig') is not None:
            temp_model = CreateProjectRequestCommonTransferConfig()
            self.common_transfer_config = temp_model.from_map(m['CommonTransferConfig'])
        if m.get('EnableFullTransfer') is not None:
            self.enable_full_transfer = m.get('EnableFullTransfer')
        if m.get('EnableFullVerify') is not None:
            self.enable_full_verify = m.get('EnableFullVerify')
        if m.get('EnableIncrTransfer') is not None:
            self.enable_incr_transfer = m.get('EnableIncrTransfer')
        if m.get('EnableReverseIncrTransfer') is not None:
            self.enable_reverse_incr_transfer = m.get('EnableReverseIncrTransfer')
        if m.get('EnableStructTransfer') is not None:
            self.enable_struct_transfer = m.get('EnableStructTransfer')
        if m.get('FullTransferConfig') is not None:
            temp_model = CreateProjectRequestFullTransferConfig()
            self.full_transfer_config = temp_model.from_map(m['FullTransferConfig'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IncrTransferConfig') is not None:
            temp_model = CreateProjectRequestIncrTransferConfig()
            self.incr_transfer_config = temp_model.from_map(m['IncrTransferConfig'])
        if m.get('LabelIds') is not None:
            self.label_ids = m.get('LabelIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('ReverseIncrTransferConfig') is not None:
            temp_model = CreateProjectRequestReverseIncrTransferConfig()
            self.reverse_incr_transfer_config = temp_model.from_map(m['ReverseIncrTransferConfig'])
        if m.get('SinkEndpointId') is not None:
            self.sink_endpoint_id = m.get('SinkEndpointId')
        if m.get('SourceEndpointId') is not None:
            self.source_endpoint_id = m.get('SourceEndpointId')
        if m.get('StructTransferConfig') is not None:
            temp_model = CreateProjectRequestStructTransferConfig()
            self.struct_transfer_config = temp_model.from_map(m['StructTransferConfig'])
        if m.get('TransferMapping') is not None:
            temp_model = CreateProjectRequestTransferMapping()
            self.transfer_mapping = temp_model.from_map(m['TransferMapping'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UseOss') is not None:
            self.use_oss = m.get('UseOss')
        if m.get('WorkerGradeId') is not None:
            self.worker_grade_id = m.get('WorkerGradeId')
        return self


class CreateProjectShrinkRequest(TeaModel):
    def __init__(
        self,
        common_transfer_config_shrink: str = None,
        enable_full_transfer: bool = None,
        enable_full_verify: bool = None,
        enable_incr_transfer: bool = None,
        enable_reverse_incr_transfer: bool = None,
        enable_struct_transfer: bool = None,
        full_transfer_config_shrink: str = None,
        id: str = None,
        incr_transfer_config_shrink: str = None,
        label_ids_shrink: str = None,
        name: str = None,
        oss_key: str = None,
        reverse_incr_transfer_config_shrink: str = None,
        sink_endpoint_id: str = None,
        source_endpoint_id: str = None,
        struct_transfer_config_shrink: str = None,
        transfer_mapping_shrink: str = None,
        type: str = None,
        use_oss: bool = None,
        worker_grade_id: str = None,
    ):
        self.common_transfer_config_shrink = common_transfer_config_shrink
        self.enable_full_transfer = enable_full_transfer
        self.enable_full_verify = enable_full_verify
        self.enable_incr_transfer = enable_incr_transfer
        self.enable_reverse_incr_transfer = enable_reverse_incr_transfer
        self.enable_struct_transfer = enable_struct_transfer
        self.full_transfer_config_shrink = full_transfer_config_shrink
        # This parameter is required.
        self.id = id
        self.incr_transfer_config_shrink = incr_transfer_config_shrink
        self.label_ids_shrink = label_ids_shrink
        # This parameter is required.
        self.name = name
        self.oss_key = oss_key
        self.reverse_incr_transfer_config_shrink = reverse_incr_transfer_config_shrink
        # This parameter is required.
        self.sink_endpoint_id = sink_endpoint_id
        # This parameter is required.
        self.source_endpoint_id = source_endpoint_id
        self.struct_transfer_config_shrink = struct_transfer_config_shrink
        # This parameter is required.
        self.transfer_mapping_shrink = transfer_mapping_shrink
        # This parameter is required.
        self.type = type
        self.use_oss = use_oss
        # This parameter is required.
        self.worker_grade_id = worker_grade_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_transfer_config_shrink is not None:
            result['CommonTransferConfig'] = self.common_transfer_config_shrink
        if self.enable_full_transfer is not None:
            result['EnableFullTransfer'] = self.enable_full_transfer
        if self.enable_full_verify is not None:
            result['EnableFullVerify'] = self.enable_full_verify
        if self.enable_incr_transfer is not None:
            result['EnableIncrTransfer'] = self.enable_incr_transfer
        if self.enable_reverse_incr_transfer is not None:
            result['EnableReverseIncrTransfer'] = self.enable_reverse_incr_transfer
        if self.enable_struct_transfer is not None:
            result['EnableStructTransfer'] = self.enable_struct_transfer
        if self.full_transfer_config_shrink is not None:
            result['FullTransferConfig'] = self.full_transfer_config_shrink
        if self.id is not None:
            result['Id'] = self.id
        if self.incr_transfer_config_shrink is not None:
            result['IncrTransferConfig'] = self.incr_transfer_config_shrink
        if self.label_ids_shrink is not None:
            result['LabelIds'] = self.label_ids_shrink
        if self.name is not None:
            result['Name'] = self.name
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.reverse_incr_transfer_config_shrink is not None:
            result['ReverseIncrTransferConfig'] = self.reverse_incr_transfer_config_shrink
        if self.sink_endpoint_id is not None:
            result['SinkEndpointId'] = self.sink_endpoint_id
        if self.source_endpoint_id is not None:
            result['SourceEndpointId'] = self.source_endpoint_id
        if self.struct_transfer_config_shrink is not None:
            result['StructTransferConfig'] = self.struct_transfer_config_shrink
        if self.transfer_mapping_shrink is not None:
            result['TransferMapping'] = self.transfer_mapping_shrink
        if self.type is not None:
            result['Type'] = self.type
        if self.use_oss is not None:
            result['UseOss'] = self.use_oss
        if self.worker_grade_id is not None:
            result['WorkerGradeId'] = self.worker_grade_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommonTransferConfig') is not None:
            self.common_transfer_config_shrink = m.get('CommonTransferConfig')
        if m.get('EnableFullTransfer') is not None:
            self.enable_full_transfer = m.get('EnableFullTransfer')
        if m.get('EnableFullVerify') is not None:
            self.enable_full_verify = m.get('EnableFullVerify')
        if m.get('EnableIncrTransfer') is not None:
            self.enable_incr_transfer = m.get('EnableIncrTransfer')
        if m.get('EnableReverseIncrTransfer') is not None:
            self.enable_reverse_incr_transfer = m.get('EnableReverseIncrTransfer')
        if m.get('EnableStructTransfer') is not None:
            self.enable_struct_transfer = m.get('EnableStructTransfer')
        if m.get('FullTransferConfig') is not None:
            self.full_transfer_config_shrink = m.get('FullTransferConfig')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IncrTransferConfig') is not None:
            self.incr_transfer_config_shrink = m.get('IncrTransferConfig')
        if m.get('LabelIds') is not None:
            self.label_ids_shrink = m.get('LabelIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('ReverseIncrTransferConfig') is not None:
            self.reverse_incr_transfer_config_shrink = m.get('ReverseIncrTransferConfig')
        if m.get('SinkEndpointId') is not None:
            self.sink_endpoint_id = m.get('SinkEndpointId')
        if m.get('SourceEndpointId') is not None:
            self.source_endpoint_id = m.get('SourceEndpointId')
        if m.get('StructTransferConfig') is not None:
            self.struct_transfer_config_shrink = m.get('StructTransferConfig')
        if m.get('TransferMapping') is not None:
            self.transfer_mapping_shrink = m.get('TransferMapping')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UseOss') is not None:
            self.use_oss = m.get('UseOss')
        if m.get('WorkerGradeId') is not None:
            self.worker_grade_id = m.get('WorkerGradeId')
        return self


class CreateProjectResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateProjectResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: str = None,
        error_detail: CreateProjectResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateProjectResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectModifyRecordsRequestDatabasesSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestDatabasesSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestDatabasesSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestDatabasesSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestDatabasesSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestDatabasesSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestDatabasesSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestDatabasesSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestDatabasesTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestDatabasesTablesObkvPartitionConfig(TeaModel):
    def __init__(
        self,
        partition_size: int = None,
        partition_type: str = None,
        virtual_column: str = None,
    ):
        self.partition_size = partition_size
        self.partition_type = partition_type
        self.virtual_column = virtual_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_size is not None:
            result['PartitionSize'] = self.partition_size
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.virtual_column is not None:
            result['VirtualColumn'] = self.virtual_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionSize') is not None:
            self.partition_size = m.get('PartitionSize')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('VirtualColumn') is not None:
            self.virtual_column = m.get('VirtualColumn')
        return self


class CreateProjectModifyRecordsRequestDatabasesTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestDatabasesTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        obkv_partition_config: CreateProjectModifyRecordsRequestDatabasesTablesObkvPartitionConfig = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.obkv_partition_config = obkv_partition_config
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()
        if self.obkv_partition_config:
            self.obkv_partition_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.obkv_partition_config is not None:
            result['ObkvPartitionConfig'] = self.obkv_partition_config.to_map()
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestDatabasesTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObkvPartitionConfig') is not None:
            temp_model = CreateProjectModifyRecordsRequestDatabasesTablesObkvPartitionConfig()
            self.obkv_partition_config = temp_model.from_map(m['ObkvPartitionConfig'])
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestDatabasesViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestDatabasesViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestDatabasesViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestDatabasesViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestDatabases(TeaModel):
    def __init__(
        self,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectModifyRecordsRequestDatabasesSpecificTables] = None,
        specific_views: List[CreateProjectModifyRecordsRequestDatabasesSpecificViews] = None,
        tables: List[CreateProjectModifyRecordsRequestDatabasesTables] = None,
        views: List[CreateProjectModifyRecordsRequestDatabasesViews] = None,
    ):
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectModifyRecordsRequestDatabasesSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectModifyRecordsRequestDatabasesSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectModifyRecordsRequestDatabasesTables()
                self.tables.append(temp_model.from_map(k))
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectModifyRecordsRequestDatabasesViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesObjectMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesSchemaMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackTableRules(TeaModel):
    def __init__(
        self,
        object_mapping: CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesObjectMapping = None,
        schema_mapping: CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesSchemaMapping = None,
    ):
        self.object_mapping = object_mapping
        self.schema_mapping = schema_mapping

    def validate(self):
        if self.object_mapping:
            self.object_mapping.validate()
        if self.schema_mapping:
            self.schema_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_mapping is not None:
            result['ObjectMapping'] = self.object_mapping.to_map()
        if self.schema_mapping is not None:
            result['SchemaMapping'] = self.schema_mapping.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesObjectMapping()
            self.object_mapping = temp_model.from_map(m['ObjectMapping'])
        if m.get('SchemaMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackTableRulesSchemaMapping()
            self.schema_mapping = temp_model.from_map(m['SchemaMapping'])
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesObjectMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesSchemaMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingBlackViewRules(TeaModel):
    def __init__(
        self,
        object_mapping: CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesObjectMapping = None,
        schema_mapping: CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesSchemaMapping = None,
    ):
        self.object_mapping = object_mapping
        self.schema_mapping = schema_mapping

    def validate(self):
        if self.object_mapping:
            self.object_mapping.validate()
        if self.schema_mapping:
            self.schema_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_mapping is not None:
            result['ObjectMapping'] = self.object_mapping.to_map()
        if self.schema_mapping is not None:
            result['SchemaMapping'] = self.schema_mapping.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesObjectMapping()
            self.object_mapping = temp_model.from_map(m['ObjectMapping'])
        if m.get('SchemaMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackViewRulesSchemaMapping()
            self.schema_mapping = temp_model.from_map(m['SchemaMapping'])
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesObkvPartitionConfig(TeaModel):
    def __init__(
        self,
        partition_size: int = None,
        partition_type: str = None,
        virtual_column: str = None,
    ):
        self.partition_size = partition_size
        self.partition_type = partition_type
        self.virtual_column = virtual_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_size is not None:
            result['PartitionSize'] = self.partition_size
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.virtual_column is not None:
            result['VirtualColumn'] = self.virtual_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionSize') is not None:
            self.partition_size = m.get('PartitionSize')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('VirtualColumn') is not None:
            self.virtual_column = m.get('VirtualColumn')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        obkv_partition_config: CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesObkvPartitionConfig = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.obkv_partition_config = obkv_partition_config
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()
        if self.obkv_partition_config:
            self.obkv_partition_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.obkv_partition_config is not None:
            result['ObkvPartitionConfig'] = self.obkv_partition_config.to_map()
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObkvPartitionConfig') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesTablesObkvPartitionConfig()
            self.obkv_partition_config = temp_model.from_map(m['ObkvPartitionConfig'])
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabases(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTables] = None,
        specific_views: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViews] = None,
        tables: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesTables] = None,
        tenant_name: str = None,
        views: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesViews] = None,
    ):
        self.cluster_name = cluster_name
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.tenant_name = tenant_name
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingDatabasesBlack(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTables] = None,
        specific_views: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViews] = None,
        tables: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTables] = None,
        tenant_name: str = None,
        views: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViews] = None,
    ):
        self.cluster_name = cluster_name
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.tenant_name = tenant_name
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlackViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasTablesAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasTablesObkvPartitionConfig(TeaModel):
    def __init__(
        self,
        partition_size: int = None,
        partition_type: str = None,
        virtual_column: str = None,
    ):
        self.partition_size = partition_size
        self.partition_type = partition_type
        self.virtual_column = virtual_column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_size is not None:
            result['PartitionSize'] = self.partition_size
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.virtual_column is not None:
            result['VirtualColumn'] = self.virtual_column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionSize') is not None:
            self.partition_size = m.get('PartitionSize')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('VirtualColumn') is not None:
            self.virtual_column = m.get('VirtualColumn')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasTables(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingSchemasTablesAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        obkv_partition_config: CreateProjectModifyRecordsRequestTransferMappingSchemasTablesObkvPartitionConfig = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.obkv_partition_config = obkv_partition_config
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()
        if self.obkv_partition_config:
            self.obkv_partition_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.obkv_partition_config is not None:
            result['ObkvPartitionConfig'] = self.obkv_partition_config.to_map()
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasTablesAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ObkvPartitionConfig') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasTablesObkvPartitionConfig()
            self.obkv_partition_config = temp_model.from_map(m['ObkvPartitionConfig'])
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasViewsAdbTableSchema(TeaModel):
    def __init__(
        self,
        distributed_keys: List[str] = None,
        partition_life_cycle: str = None,
        partition_statement: str = None,
        primary_keys: List[str] = None,
    ):
        self.distributed_keys = distributed_keys
        self.partition_life_cycle = partition_life_cycle
        self.partition_statement = partition_statement
        self.primary_keys = primary_keys

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distributed_keys is not None:
            result['DistributedKeys'] = self.distributed_keys
        if self.partition_life_cycle is not None:
            result['PartitionLifeCycle'] = self.partition_life_cycle
        if self.partition_statement is not None:
            result['PartitionStatement'] = self.partition_statement
        if self.primary_keys is not None:
            result['PrimaryKeys'] = self.primary_keys
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributedKeys') is not None:
            self.distributed_keys = m.get('DistributedKeys')
        if m.get('PartitionLifeCycle') is not None:
            self.partition_life_cycle = m.get('PartitionLifeCycle')
        if m.get('PartitionStatement') is not None:
            self.partition_statement = m.get('PartitionStatement')
        if m.get('PrimaryKeys') is not None:
            self.primary_keys = m.get('PrimaryKeys')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemasViews(TeaModel):
    def __init__(
        self,
        adb_table_schema: CreateProjectModifyRecordsRequestTransferMappingSchemasViewsAdbTableSchema = None,
        filter_columns: List[str] = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        shard_columns: List[str] = None,
        where_clause: str = None,
    ):
        self.adb_table_schema = adb_table_schema
        self.filter_columns = filter_columns
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.shard_columns = shard_columns
        self.where_clause = where_clause

    def validate(self):
        if self.adb_table_schema:
            self.adb_table_schema.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adb_table_schema is not None:
            result['AdbTableSchema'] = self.adb_table_schema.to_map()
        if self.filter_columns is not None:
            result['FilterColumns'] = self.filter_columns
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        if self.shard_columns is not None:
            result['ShardColumns'] = self.shard_columns
        if self.where_clause is not None:
            result['WhereClause'] = self.where_clause
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdbTableSchema') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasViewsAdbTableSchema()
            self.adb_table_schema = temp_model.from_map(m['AdbTableSchema'])
        if m.get('FilterColumns') is not None:
            self.filter_columns = m.get('FilterColumns')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ShardColumns') is not None:
            self.shard_columns = m.get('ShardColumns')
        if m.get('WhereClause') is not None:
            self.where_clause = m.get('WhereClause')
        return self


class CreateProjectModifyRecordsRequestTransferMappingSchemas(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        id: str = None,
        mapped_name: str = None,
        name: str = None,
        specific_tables: List[CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTables] = None,
        specific_views: List[CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViews] = None,
        tables: List[CreateProjectModifyRecordsRequestTransferMappingSchemasTables] = None,
        tenant_name: str = None,
        views: List[CreateProjectModifyRecordsRequestTransferMappingSchemasViews] = None,
    ):
        self.cluster_name = cluster_name
        self.id = id
        self.mapped_name = mapped_name
        self.name = name
        self.specific_tables = specific_tables
        self.specific_views = specific_views
        self.tables = tables
        self.tenant_name = tenant_name
        self.views = views

    def validate(self):
        if self.specific_tables:
            for k in self.specific_tables:
                if k:
                    k.validate()
        if self.specific_views:
            for k in self.specific_views:
                if k:
                    k.validate()
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.views:
            for k in self.views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        result['SpecificTables'] = []
        if self.specific_tables is not None:
            for k in self.specific_tables:
                result['SpecificTables'].append(k.to_map() if k else None)
        result['SpecificViews'] = []
        if self.specific_views is not None:
            for k in self.specific_views:
                result['SpecificViews'].append(k.to_map() if k else None)
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Views'] = []
        if self.views is not None:
            for k in self.views:
                result['Views'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.specific_tables = []
        if m.get('SpecificTables') is not None:
            for k in m.get('SpecificTables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificTables()
                self.specific_tables.append(temp_model.from_map(k))
        self.specific_views = []
        if m.get('SpecificViews') is not None:
            for k in m.get('SpecificViews'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasSpecificViews()
                self.specific_views.append(temp_model.from_map(k))
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.views = []
        if m.get('Views') is not None:
            for k in m.get('Views'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemasViews()
                self.views.append(temp_model.from_map(k))
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesObjectMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesSchemaMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteTableRules(TeaModel):
    def __init__(
        self,
        object_mapping: CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesObjectMapping = None,
        schema_mapping: CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesSchemaMapping = None,
    ):
        self.object_mapping = object_mapping
        self.schema_mapping = schema_mapping

    def validate(self):
        if self.object_mapping:
            self.object_mapping.validate()
        if self.schema_mapping:
            self.schema_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_mapping is not None:
            result['ObjectMapping'] = self.object_mapping.to_map()
        if self.schema_mapping is not None:
            result['SchemaMapping'] = self.schema_mapping.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesObjectMapping()
            self.object_mapping = temp_model.from_map(m['ObjectMapping'])
        if m.get('SchemaMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteTableRulesSchemaMapping()
            self.schema_mapping = temp_model.from_map(m['SchemaMapping'])
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesObjectMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesSchemaMapping(TeaModel):
    def __init__(
        self,
        mapped_name: str = None,
        name: str = None,
    ):
        self.mapped_name = mapped_name
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mapped_name is not None:
            result['MappedName'] = self.mapped_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MappedName') is not None:
            self.mapped_name = m.get('MappedName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateProjectModifyRecordsRequestTransferMappingWhiteViewRules(TeaModel):
    def __init__(
        self,
        object_mapping: CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesObjectMapping = None,
        schema_mapping: CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesSchemaMapping = None,
    ):
        self.object_mapping = object_mapping
        self.schema_mapping = schema_mapping

    def validate(self):
        if self.object_mapping:
            self.object_mapping.validate()
        if self.schema_mapping:
            self.schema_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_mapping is not None:
            result['ObjectMapping'] = self.object_mapping.to_map()
        if self.schema_mapping is not None:
            result['SchemaMapping'] = self.schema_mapping.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesObjectMapping()
            self.object_mapping = temp_model.from_map(m['ObjectMapping'])
        if m.get('SchemaMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteViewRulesSchemaMapping()
            self.schema_mapping = temp_model.from_map(m['SchemaMapping'])
        return self


class CreateProjectModifyRecordsRequestTransferMapping(TeaModel):
    def __init__(
        self,
        black_table_rules: List[CreateProjectModifyRecordsRequestTransferMappingBlackTableRules] = None,
        black_view_rules: List[CreateProjectModifyRecordsRequestTransferMappingBlackViewRules] = None,
        databases: List[CreateProjectModifyRecordsRequestTransferMappingDatabases] = None,
        databases_black: List[CreateProjectModifyRecordsRequestTransferMappingDatabasesBlack] = None,
        mode: str = None,
        schemas: List[CreateProjectModifyRecordsRequestTransferMappingSchemas] = None,
        table_and_view_black_list: List[str] = None,
        table_and_view_white_list: List[str] = None,
        white_table_rules: List[CreateProjectModifyRecordsRequestTransferMappingWhiteTableRules] = None,
        white_view_rules: List[CreateProjectModifyRecordsRequestTransferMappingWhiteViewRules] = None,
    ):
        self.black_table_rules = black_table_rules
        self.black_view_rules = black_view_rules
        self.databases = databases
        self.databases_black = databases_black
        self.mode = mode
        self.schemas = schemas
        self.table_and_view_black_list = table_and_view_black_list
        self.table_and_view_white_list = table_and_view_white_list
        self.white_table_rules = white_table_rules
        self.white_view_rules = white_view_rules

    def validate(self):
        if self.black_table_rules:
            for k in self.black_table_rules:
                if k:
                    k.validate()
        if self.black_view_rules:
            for k in self.black_view_rules:
                if k:
                    k.validate()
        if self.databases:
            for k in self.databases:
                if k:
                    k.validate()
        if self.databases_black:
            for k in self.databases_black:
                if k:
                    k.validate()
        if self.schemas:
            for k in self.schemas:
                if k:
                    k.validate()
        if self.white_table_rules:
            for k in self.white_table_rules:
                if k:
                    k.validate()
        if self.white_view_rules:
            for k in self.white_view_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BlackTableRules'] = []
        if self.black_table_rules is not None:
            for k in self.black_table_rules:
                result['BlackTableRules'].append(k.to_map() if k else None)
        result['BlackViewRules'] = []
        if self.black_view_rules is not None:
            for k in self.black_view_rules:
                result['BlackViewRules'].append(k.to_map() if k else None)
        result['Databases'] = []
        if self.databases is not None:
            for k in self.databases:
                result['Databases'].append(k.to_map() if k else None)
        result['DatabasesBlack'] = []
        if self.databases_black is not None:
            for k in self.databases_black:
                result['DatabasesBlack'].append(k.to_map() if k else None)
        if self.mode is not None:
            result['Mode'] = self.mode
        result['Schemas'] = []
        if self.schemas is not None:
            for k in self.schemas:
                result['Schemas'].append(k.to_map() if k else None)
        if self.table_and_view_black_list is not None:
            result['TableAndViewBlackList'] = self.table_and_view_black_list
        if self.table_and_view_white_list is not None:
            result['TableAndViewWhiteList'] = self.table_and_view_white_list
        result['WhiteTableRules'] = []
        if self.white_table_rules is not None:
            for k in self.white_table_rules:
                result['WhiteTableRules'].append(k.to_map() if k else None)
        result['WhiteViewRules'] = []
        if self.white_view_rules is not None:
            for k in self.white_view_rules:
                result['WhiteViewRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.black_table_rules = []
        if m.get('BlackTableRules') is not None:
            for k in m.get('BlackTableRules'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackTableRules()
                self.black_table_rules.append(temp_model.from_map(k))
        self.black_view_rules = []
        if m.get('BlackViewRules') is not None:
            for k in m.get('BlackViewRules'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingBlackViewRules()
                self.black_view_rules.append(temp_model.from_map(k))
        self.databases = []
        if m.get('Databases') is not None:
            for k in m.get('Databases'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabases()
                self.databases.append(temp_model.from_map(k))
        self.databases_black = []
        if m.get('DatabasesBlack') is not None:
            for k in m.get('DatabasesBlack'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingDatabasesBlack()
                self.databases_black.append(temp_model.from_map(k))
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        self.schemas = []
        if m.get('Schemas') is not None:
            for k in m.get('Schemas'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingSchemas()
                self.schemas.append(temp_model.from_map(k))
        if m.get('TableAndViewBlackList') is not None:
            self.table_and_view_black_list = m.get('TableAndViewBlackList')
        if m.get('TableAndViewWhiteList') is not None:
            self.table_and_view_white_list = m.get('TableAndViewWhiteList')
        self.white_table_rules = []
        if m.get('WhiteTableRules') is not None:
            for k in m.get('WhiteTableRules'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteTableRules()
                self.white_table_rules.append(temp_model.from_map(k))
        self.white_view_rules = []
        if m.get('WhiteViewRules') is not None:
            for k in m.get('WhiteViewRules'):
                temp_model = CreateProjectModifyRecordsRequestTransferMappingWhiteViewRules()
                self.white_view_rules.append(temp_model.from_map(k))
        return self


class CreateProjectModifyRecordsRequest(TeaModel):
    def __init__(
        self,
        databases: List[CreateProjectModifyRecordsRequestDatabases] = None,
        id: str = None,
        transfer_mapping: CreateProjectModifyRecordsRequestTransferMapping = None,
    ):
        self.databases = databases
        # This parameter is required.
        self.id = id
        self.transfer_mapping = transfer_mapping

    def validate(self):
        if self.databases:
            for k in self.databases:
                if k:
                    k.validate()
        if self.transfer_mapping:
            self.transfer_mapping.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Databases'] = []
        if self.databases is not None:
            for k in self.databases:
                result['Databases'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        if self.transfer_mapping is not None:
            result['TransferMapping'] = self.transfer_mapping.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.databases = []
        if m.get('Databases') is not None:
            for k in m.get('Databases'):
                temp_model = CreateProjectModifyRecordsRequestDatabases()
                self.databases.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TransferMapping') is not None:
            temp_model = CreateProjectModifyRecordsRequestTransferMapping()
            self.transfer_mapping = temp_model.from_map(m['TransferMapping'])
        return self


class CreateProjectModifyRecordsShrinkRequest(TeaModel):
    def __init__(
        self,
        databases_shrink: str = None,
        id: str = None,
        transfer_mapping_shrink: str = None,
    ):
        self.databases_shrink = databases_shrink
        # This parameter is required.
        self.id = id
        self.transfer_mapping_shrink = transfer_mapping_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.databases_shrink is not None:
            result['Databases'] = self.databases_shrink
        if self.id is not None:
            result['Id'] = self.id
        if self.transfer_mapping_shrink is not None:
            result['TransferMapping'] = self.transfer_mapping_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Databases') is not None:
            self.databases_shrink = m.get('Databases')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TransferMapping') is not None:
            self.transfer_mapping_shrink = m.get('TransferMapping')
        return self


class CreateProjectModifyRecordsResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateProjectModifyRecordsResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: int = None,
        error_detail: CreateProjectModifyRecordsResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateProjectModifyRecordsResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateProjectModifyRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateProjectModifyRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateProjectModifyRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRdsPostgreSQLDataSourceRequest(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        description: str = None,
        instance_id: str = None,
        name: str = None,
        password: str = None,
        user_name: str = None,
    ):
        # This parameter is required.
        self.database_name = database_name
        self.description = description
        # This parameter is required.
        self.instance_id = instance_id
        # This parameter is required.
        self.name = name
        # This parameter is required.
        self.password = password
        # This parameter is required.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateRdsPostgreSQLDataSourceResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class CreateRdsPostgreSQLDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: str = None,
        error_detail: CreateRdsPostgreSQLDataSourceResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = CreateRdsPostgreSQLDataSourceResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateRdsPostgreSQLDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRdsPostgreSQLDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRdsPostgreSQLDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecurityIpGroupRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        security_ips: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The name of the whitelist group.
        # 
        # This parameter is required.
        self.security_ip_group_name = security_ip_group_name
        # The return result of the request.
        # 
        # This parameter is required.
        self.security_ips = security_ips

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.security_ips is not None:
            result['SecurityIps'] = self.security_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('SecurityIps') is not None:
            self.security_ips = m.get('SecurityIps')
        return self


class CreateSecurityIpGroupResponseBodySecurityIpGroup(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        security_ips: str = None,
    ):
        # ```
        # http(s)://[Endpoint]/?Action=CreateSecurityIpGroup
        # &InstanceId=ob317v4uif****\
        # &SecurityIps=192.168.1.1,192.168.0.0.1/8
        # &SecurityIpGroupName=pay_online
        # &Common request parameters
        # ```
        self.instance_id = instance_id
        # You can call this operation to create an IP address whitelist group.
        self.security_ip_group_name = security_ip_group_name
        self.security_ips = security_ips

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.security_ips is not None:
            result['SecurityIps'] = self.security_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('SecurityIps') is not None:
            self.security_ips = m.get('SecurityIps')
        return self


class CreateSecurityIpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_ip_group: CreateSecurityIpGroupResponseBodySecurityIpGroup = None,
    ):
        # The IP addresses or CIDR blocks in the IP address whitelist group.   
        # The return values of SecurityIps are strings that are separated with commas (,).
        self.request_id = request_id
        # The operation that you want to perform.   
        # Set the value to **CreateSecurityIpGroup**.
        self.security_ip_group = security_ip_group

    def validate(self):
        if self.security_ip_group:
            self.security_ip_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_ip_group is not None:
            result['SecurityIpGroup'] = self.security_ip_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityIpGroup') is not None:
            temp_model = CreateSecurityIpGroupResponseBodySecurityIpGroup()
            self.security_ip_group = temp_model.from_map(m['SecurityIpGroup'])
        return self


class CreateSecurityIpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSecurityIpGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecurityIpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTagRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        key: str = None,
    ):
        # The identifier of the client.
        self.client_token = client_token
        # The name of the tag group.
        # 
        # This parameter is required.
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateTagResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
    ):
        # The tag group creation result.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTagValueRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        key: str = None,
        value: str = None,
    ):
        # The identifier of the client.
        self.client_token = client_token
        # The name of the tag group.
        # 
        # This parameter is required.
        self.key = key
        # The name of the tag.
        # 
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTagValueResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
    ):
        # The tag creation result.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTagValueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTagValueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTagValueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTenantRequest(TeaModel):
    def __init__(
        self,
        charset: str = None,
        cpu: int = None,
        create_params: Dict[str, str] = None,
        description: str = None,
        instance_id: str = None,
        log_disk: int = None,
        memory: int = None,
        primary_zone: str = None,
        read_only_zone_list: str = None,
        tenant_mode: str = None,
        tenant_name: str = None,
        time_zone: str = None,
        unit_num: int = None,
        user_vswitch_id: str = None,
        user_vpc_id: str = None,
        user_vpc_owner_id: str = None,
    ):
        # The character set.    
        # For more information, see [DescribeCharset](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describecharset).
        # 
        # This parameter is required.
        self.charset = charset
        # The number of CPU cores of the tenant.   
        # 
        # > <br>The CPU specification of a single tenant cannot exceed that of the corresponding cluster. <br>For example, if the specification of the cluster is 14 CPU cores and 70 GB of memory, the CPU specification of the tenant cannot exceed 14 cores.
        # 
        # This parameter is required.
        self.cpu = cpu
        # The initialization parameters.
        self.create_params = create_params
        # The description of the database.
        self.description = description
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The size of the log disk allocated to the tenant, in GB.
        self.log_disk = log_disk
        # The memory size of the tenant, in GB.   
        # 
        # > <br>The memory size of a single tenant cannot exceed that of the corresponding cluster. <br>For example, if the specification of the cluster is 14 CPU cores and 70 GB of memory, the memory size of the tenant cannot exceed 70 GB.
        # 
        # This parameter is required.
        self.memory = memory
        # The primary zone of the tenant.    
        # It is one of the zones in which the cluster is deployed.
        # 
        # This parameter is required.
        self.primary_zone = primary_zone
        # Specifies to create a read-only zone. Separate the names of multiple zones with commas (,).
        # >Notice: <br>At present, this parameter is unavailable.
        self.read_only_zone_list = read_only_zone_list
        # The tenant mode.    
        # Valid values: Oracle and MySQL.   
        # For more information, see [DescribeInstanceTenantModes](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describeinstancetenantmodes).
        # 
        # This parameter is required.
        self.tenant_mode = tenant_mode
        # The name of the tenant.    
        # It must start with a letter or an underscore (_), and contain 2 to 20 characters, which can be uppercase letters, lowercase letters, digits, and underscores (_).  It cannot be set to sys.
        # 
        # This parameter is required.
        self.tenant_name = tenant_name
        # The time zone of the tenant. For more information, see [DescribeTimeZones](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describetimezones).
        # 
        # This parameter is required.
        self.time_zone = time_zone
        # The number of resource distribution nodes in the tenant.    
        # The number is determined by the deployment mode of the cluster. If the cluster is deployed in 2-2-2 mode, the maximum number of resource distribution nodes is 2.
        self.unit_num = unit_num
        # The ID of the vSwitch.    
        # If no suitable vSwitch is available, create a vSwitch as prompted.   
        # For more information, see Use a vSwitch.
        # 
        # This parameter is required.
        self.user_vswitch_id = user_vswitch_id
        # The ID of the VPC.   
        #  If no suitable VPC is available, create a VPC as prompted.   
        # For more information, see "What is a VPC".
        # 
        # This parameter is required.
        self.user_vpc_id = user_vpc_id
        # The ID of the VPC owner.
        self.user_vpc_owner_id = user_vpc_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charset is not None:
            result['Charset'] = self.charset
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.create_params is not None:
            result['CreateParams'] = self.create_params
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_disk is not None:
            result['LogDisk'] = self.log_disk
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.primary_zone is not None:
            result['PrimaryZone'] = self.primary_zone
        if self.read_only_zone_list is not None:
            result['ReadOnlyZoneList'] = self.read_only_zone_list
        if self.tenant_mode is not None:
            result['TenantMode'] = self.tenant_mode
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        if self.user_vswitch_id is not None:
            result['UserVSwitchId'] = self.user_vswitch_id
        if self.user_vpc_id is not None:
            result['UserVpcId'] = self.user_vpc_id
        if self.user_vpc_owner_id is not None:
            result['UserVpcOwnerId'] = self.user_vpc_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Charset') is not None:
            self.charset = m.get('Charset')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreateParams') is not None:
            self.create_params = m.get('CreateParams')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogDisk') is not None:
            self.log_disk = m.get('LogDisk')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('PrimaryZone') is not None:
            self.primary_zone = m.get('PrimaryZone')
        if m.get('ReadOnlyZoneList') is not None:
            self.read_only_zone_list = m.get('ReadOnlyZoneList')
        if m.get('TenantMode') is not None:
            self.tenant_mode = m.get('TenantMode')
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        if m.get('UserVSwitchId') is not None:
            self.user_vswitch_id = m.get('UserVSwitchId')
        if m.get('UserVpcId') is not None:
            self.user_vpc_id = m.get('UserVpcId')
        if m.get('UserVpcOwnerId') is not None:
            self.user_vpc_owner_id = m.get('UserVpcOwnerId')
        return self


class CreateTenantShrinkRequest(TeaModel):
    def __init__(
        self,
        charset: str = None,
        cpu: int = None,
        create_params_shrink: str = None,
        description: str = None,
        instance_id: str = None,
        log_disk: int = None,
        memory: int = None,
        primary_zone: str = None,
        read_only_zone_list: str = None,
        tenant_mode: str = None,
        tenant_name: str = None,
        time_zone: str = None,
        unit_num: int = None,
        user_vswitch_id: str = None,
        user_vpc_id: str = None,
        user_vpc_owner_id: str = None,
    ):
        # The character set.    
        # For more information, see [DescribeCharset](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describecharset).
        # 
        # This parameter is required.
        self.charset = charset
        # The number of CPU cores of the tenant.   
        # 
        # > <br>The CPU specification of a single tenant cannot exceed that of the corresponding cluster. <br>For example, if the specification of the cluster is 14 CPU cores and 70 GB of memory, the CPU specification of the tenant cannot exceed 14 cores.
        # 
        # This parameter is required.
        self.cpu = cpu
        # The initialization parameters.
        self.create_params_shrink = create_params_shrink
        # The description of the database.
        self.description = description
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The size of the log disk allocated to the tenant, in GB.
        self.log_disk = log_disk
        # The memory size of the tenant, in GB.   
        # 
        # > <br>The memory size of a single tenant cannot exceed that of the corresponding cluster. <br>For example, if the specification of the cluster is 14 CPU cores and 70 GB of memory, the memory size of the tenant cannot exceed 70 GB.
        # 
        # This parameter is required.
        self.memory = memory
        # The primary zone of the tenant.    
        # It is one of the zones in which the cluster is deployed.
        # 
        # This parameter is required.
        self.primary_zone = primary_zone
        # Specifies to create a read-only zone. Separate the names of multiple zones with commas (,).
        # >Notice: <br>At present, this parameter is unavailable.
        self.read_only_zone_list = read_only_zone_list
        # The tenant mode.    
        # Valid values: Oracle and MySQL.   
        # For more information, see [DescribeInstanceTenantModes](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describeinstancetenantmodes).
        # 
        # This parameter is required.
        self.tenant_mode = tenant_mode
        # The name of the tenant.    
        # It must start with a letter or an underscore (_), and contain 2 to 20 characters, which can be uppercase letters, lowercase letters, digits, and underscores (_).  It cannot be set to sys.
        # 
        # This parameter is required.
        self.tenant_name = tenant_name
        # The time zone of the tenant. For more information, see [DescribeTimeZones](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describetimezones).
        # 
        # This parameter is required.
        self.time_zone = time_zone
        # The number of resource distribution nodes in the tenant.    
        # The number is determined by the deployment mode of the cluster. If the cluster is deployed in 2-2-2 mode, the maximum number of resource distribution nodes is 2.
        self.unit_num = unit_num
        # The ID of the vSwitch.    
        # If no suitable vSwitch is available, create a vSwitch as prompted.   
        # For more information, see Use a vSwitch.
        # 
        # This parameter is required.
        self.user_vswitch_id = user_vswitch_id
        # The ID of the VPC.   
        #  If no suitable VPC is available, create a VPC as prompted.   
        # For more information, see "What is a VPC".
        # 
        # This parameter is required.
        self.user_vpc_id = user_vpc_id
        # The ID of the VPC owner.
        self.user_vpc_owner_id = user_vpc_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charset is not None:
            result['Charset'] = self.charset
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.create_params_shrink is not None:
            result['CreateParams'] = self.create_params_shrink
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.log_disk is not None:
            result['LogDisk'] = self.log_disk
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.primary_zone is not None:
            result['PrimaryZone'] = self.primary_zone
        if self.read_only_zone_list is not None:
            result['ReadOnlyZoneList'] = self.read_only_zone_list
        if self.tenant_mode is not None:
            result['TenantMode'] = self.tenant_mode
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        if self.user_vswitch_id is not None:
            result['UserVSwitchId'] = self.user_vswitch_id
        if self.user_vpc_id is not None:
            result['UserVpcId'] = self.user_vpc_id
        if self.user_vpc_owner_id is not None:
            result['UserVpcOwnerId'] = self.user_vpc_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Charset') is not None:
            self.charset = m.get('Charset')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreateParams') is not None:
            self.create_params_shrink = m.get('CreateParams')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogDisk') is not None:
            self.log_disk = m.get('LogDisk')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('PrimaryZone') is not None:
            self.primary_zone = m.get('PrimaryZone')
        if m.get('ReadOnlyZoneList') is not None:
            self.read_only_zone_list = m.get('ReadOnlyZoneList')
        if m.get('TenantMode') is not None:
            self.tenant_mode = m.get('TenantMode')
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        if m.get('UserVSwitchId') is not None:
            self.user_vswitch_id = m.get('UserVSwitchId')
        if m.get('UserVpcId') is not None:
            self.user_vpc_id = m.get('UserVpcId')
        if m.get('UserVpcOwnerId') is not None:
            self.user_vpc_owner_id = m.get('UserVpcOwnerId')
        return self


class CreateTenantResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tenant_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateTenantResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTenantResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTenantResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTenantReadOnlyConnectionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        tenant_id: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        # This parameter is required.
        self.instance_id = instance_id
        # This parameter is required.
        self.tenant_id = tenant_id
        # This parameter is required.
        self.v_switch_id = v_switch_id
        self.vpc_id = vpc_id
        # This parameter is required.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateTenantReadOnlyConnectionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTenantReadOnlyConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTenantReadOnlyConnectionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTenantReadOnlyConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTenantSecurityIpGroupRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        security_ips: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The group name of the whitelist group of IP addresses.
        # 
        # It starts with lowercase letters and ends with lowercase letters or numbers. It can only contain lowercase letters, numbers, and underscores, and should be 2~32 characters in length.
        # 
        # This parameter is required.
        self.security_ip_group_name = security_ip_group_name
        # The list of IP addresses in the whitelist group.
        # 
        # It is a JSON array. Each object in the array is an IP address or a CIDR block. You can have up to 40 whitelists.
        # 
        # This parameter is required.
        self.security_ips = security_ips
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.security_ips is not None:
            result['SecurityIps'] = self.security_ips
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('SecurityIps') is not None:
            self.security_ips = m.get('SecurityIps')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateTenantSecurityIpGroupResponseBodySecurityIpGroup(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        security_ips: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The name of the whitelist group.
        self.security_ip_group_name = security_ip_group_name
        # The list of IP addresses in the IP address whitelist group.   
        # 
        # It is a string separated by commas, and each object is an IP address or CIDR block.
        self.security_ips = security_ips
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.security_ips is not None:
            result['SecurityIps'] = self.security_ips
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('SecurityIps') is not None:
            self.security_ips = m.get('SecurityIps')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class CreateTenantSecurityIpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_ip_group: CreateTenantSecurityIpGroupResponseBodySecurityIpGroup = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information of the whitelist group.
        self.security_ip_group = security_ip_group

    def validate(self):
        if self.security_ip_group:
            self.security_ip_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_ip_group is not None:
            result['SecurityIpGroup'] = self.security_ip_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityIpGroup') is not None:
            temp_model = CreateTenantSecurityIpGroupResponseBodySecurityIpGroup()
            self.security_ip_group = temp_model.from_map(m['SecurityIpGroup'])
        return self


class CreateTenantSecurityIpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTenantSecurityIpGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTenantSecurityIpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTenantUserRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        encryption_type: str = None,
        global_permissions: str = None,
        instance_id: str = None,
        roles: str = None,
        tenant_id: str = None,
        user_name: str = None,
        user_password: str = None,
        user_type: str = None,
    ):
        # The description of the database.
        self.description = description
        # 加密方式。
        self.encryption_type = encryption_type
        self.global_permissions = global_permissions
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The role of the user account.  In Oracle mode, this parameter unspecified is left unspecified.  In MySQL mode, the super administrator account has ALL PRIVILEGES, and you can leave this parameter unspecified.  You need to specify the account information for a general user account. By default, the account information is a JSON array that contains the information of the role and the schema (Oracle mode) or database (MySQL mode).  Valid values: ReadWrite: a role that has the read and write privileges, namely ALL PRIVILEGES. ReadOnly: a role that has only the read-only privilege SELECT. DDL: a role that has DDL privileges such as CREATE, DROP, ALTER, SHOW VIEW, and CREATE VIEW. DML: a role that has DML privileges such as SELECT, INSERT, UPDATE, DELETE, and SHOW VIEW.
        self.roles = roles
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id
        # The name of the database account.  You cannot use reserved keywords, such as SYS and root.
        # 
        # This parameter is required.
        self.user_name = user_name
        # The password of the database account.  It must be 10 to 32 characters in length and contain three types of the following characters: uppercase letters, lowercase letters, digits, and special characters. The special characters are ! @ # $ % \\ ^ \\ & \\ * ( ) _ + - =\
        # 
        # This parameter is required.
        self.user_password = user_password
        # The type of the database account. Valid values: Admin: the super administrator account. Normal: a general account.
        # 
        # This parameter is required.
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.encryption_type is not None:
            result['EncryptionType'] = self.encryption_type
        if self.global_permissions is not None:
            result['GlobalPermissions'] = self.global_permissions
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.roles is not None:
            result['Roles'] = self.roles
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_password is not None:
            result['UserPassword'] = self.user_password
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EncryptionType') is not None:
            self.encryption_type = m.get('EncryptionType')
        if m.get('GlobalPermissions') is not None:
            self.global_permissions = m.get('GlobalPermissions')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Roles') is not None:
            self.roles = m.get('Roles')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserPassword') is not None:
            self.user_password = m.get('UserPassword')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class CreateTenantUserResponseBodyTenantUserRoles(TeaModel):
    def __init__(
        self,
        database: str = None,
        role: str = None,
    ):
        self.database = database
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class CreateTenantUserResponseBodyTenantUser(TeaModel):
    def __init__(
        self,
        global_permissions: str = None,
        roles: List[CreateTenantUserResponseBodyTenantUserRoles] = None,
        user_name: str = None,
        user_status: str = None,
        user_type: str = None,
    ):
        self.global_permissions = global_permissions
        self.roles = roles
        self.user_name = user_name
        self.user_status = user_status
        self.user_type = user_type

    def validate(self):
        if self.roles:
            for k in self.roles:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.global_permissions is not None:
            result['GlobalPermissions'] = self.global_permissions
        result['Roles'] = []
        if self.roles is not None:
            for k in self.roles:
                result['Roles'].append(k.to_map() if k else None)
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_status is not None:
            result['UserStatus'] = self.user_status
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GlobalPermissions') is not None:
            self.global_permissions = m.get('GlobalPermissions')
        self.roles = []
        if m.get('Roles') is not None:
            for k in m.get('Roles'):
                temp_model = CreateTenantUserResponseBodyTenantUserRoles()
                self.roles.append(temp_model.from_map(k))
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserStatus') is not None:
            self.user_status = m.get('UserStatus')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class CreateTenantUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tenant_user: CreateTenantUserResponseBodyTenantUser = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The list of database accounts in the tenant.
        self.tenant_user = tenant_user

    def validate(self):
        if self.tenant_user:
            self.tenant_user.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tenant_user is not None:
            result['TenantUser'] = self.tenant_user.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TenantUser') is not None:
            temp_model = CreateTenantUserResponseBodyTenantUser()
            self.tenant_user = temp_model.from_map(m['TenantUser'])
        return self


class CreateTenantUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTenantUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTenantUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteDataSourceResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: Any = None,
        error_detail: DeleteDataSourceResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = DeleteDataSourceResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDatabasesRequest(TeaModel):
    def __init__(
        self,
        database_names: str = None,
        instance_id: str = None,
        tenant_id: str = None,
    ):
        # This parameter is required.
        self.database_names = database_names
        self.instance_id = instance_id
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_names is not None:
            result['DatabaseNames'] = self.database_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseNames') is not None:
            self.database_names = m.get('DatabaseNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteDatabasesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDatabasesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDatabasesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDatabasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(
        self,
        backup_retain_mode: str = None,
        dry_run: bool = None,
        instance_ids: str = None,
    ):
        # The backup retention strategy for cluster deletion. Valid values:  
        # - receive_all: retains all backup sets.   
        # - delete_all: deletes all backup sets.   
        # - receive_last: retains the last backup set.    
        # 
        # > <br>Default value: delete_all.
        self.backup_retain_mode = backup_retain_mode
        # Specifies whether to perform only a dry run for the request. Default value: false. Valid values:
        # - true: Only a dry-run request is sent and the instance is not deleted. If the dry run succeeds, DryRunResult=true is returned. If the dry run fails, an error code is returned.
        # - false: The actual request is sent and no dry run is performed. The instance is deleted if the requirements are met. By default, false is returned for the parameter DryRunResult if you set DryRun to false.
        self.dry_run = dry_run
        # The ID of the cluster to be deleted.   
        # The value is a string in the JSON format.
        # 
        # This parameter is required.
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_retain_mode is not None:
            result['BackupRetainMode'] = self.backup_retain_mode
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRetainMode') is not None:
            self.backup_retain_mode = m.get('BackupRetainMode')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class DeleteInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        dry_run_result: bool = None,
    ):
        # The result of the dry-run request.
        # - If the DryRun parameter is set to true and the dry run succeeds, the DryRunResult parameter returns true. Otherwise, an error code is returned.
        # - If the DryRun parameter is set to false, no dry run is performed and the DryRunResult parameter returns false.
        self.dry_run_result = dry_run_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dry_run_result is not None:
            result['DryRunResult'] = self.dry_run_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DryRunResult') is not None:
            self.dry_run_result = m.get('DryRunResult')
        return self


class DeleteInstancesResponseBody(TeaModel):
    def __init__(
        self,
        data: DeleteInstancesResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DeleteInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteProjectResponseBodyErrorDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        extra_context: Dict[str, Any] = None,
        level: str = None,
        message: str = None,
        message_mcms_context: Dict[str, str] = None,
        message_mcms_key: str = None,
        proposal: str = None,
        proposal_mcms_context: Dict[str, str] = None,
        proposal_mcms_key: str = None,
        reason: str = None,
        reason_mcms_context: Dict[str, str] = None,
        reason_mcms_key: str = None,
        upstream_error_detail: Any = None,
    ):
        self.code = code
        self.extra_context = extra_context
        self.level = level
        self.message = message
        self.message_mcms_context = message_mcms_context
        self.message_mcms_key = message_mcms_key
        self.proposal = proposal
        self.proposal_mcms_context = proposal_mcms_context
        self.proposal_mcms_key = proposal_mcms_key
        self.reason = reason
        self.reason_mcms_context = reason_mcms_context
        self.reason_mcms_key = reason_mcms_key
        self.upstream_error_detail = upstream_error_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.extra_context is not None:
            result['ExtraContext'] = self.extra_context
        if self.level is not None:
            result['Level'] = self.level
        if self.message is not None:
            result['Message'] = self.message
        if self.message_mcms_context is not None:
            result['MessageMcmsContext'] = self.message_mcms_context
        if self.message_mcms_key is not None:
            result['MessageMcmsKey'] = self.message_mcms_key
        if self.proposal is not None:
            result['Proposal'] = self.proposal
        if self.proposal_mcms_context is not None:
            result['ProposalMcmsContext'] = self.proposal_mcms_context
        if self.proposal_mcms_key is not None:
            result['ProposalMcmsKey'] = self.proposal_mcms_key
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.reason_mcms_context is not None:
            result['ReasonMcmsContext'] = self.reason_mcms_context
        if self.reason_mcms_key is not None:
            result['ReasonMcmsKey'] = self.reason_mcms_key
        if self.upstream_error_detail is not None:
            result['UpstreamErrorDetail'] = self.upstream_error_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ExtraContext') is not None:
            self.extra_context = m.get('ExtraContext')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('MessageMcmsContext') is not None:
            self.message_mcms_context = m.get('MessageMcmsContext')
        if m.get('MessageMcmsKey') is not None:
            self.message_mcms_key = m.get('MessageMcmsKey')
        if m.get('Proposal') is not None:
            self.proposal = m.get('Proposal')
        if m.get('ProposalMcmsContext') is not None:
            self.proposal_mcms_context = m.get('ProposalMcmsContext')
        if m.get('ProposalMcmsKey') is not None:
            self.proposal_mcms_key = m.get('ProposalMcmsKey')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('ReasonMcmsContext') is not None:
            self.reason_mcms_context = m.get('ReasonMcmsContext')
        if m.get('ReasonMcmsKey') is not None:
            self.reason_mcms_key = m.get('ReasonMcmsKey')
        if m.get('UpstreamErrorDetail') is not None:
            self.upstream_error_detail = m.get('UpstreamErrorDetail')
        return self


class DeleteProjectResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        code: str = None,
        cost: str = None,
        data: Any = None,
        error_detail: DeleteProjectResponseBodyErrorDetail = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.advice = advice
        self.code = code
        self.cost = cost
        self.data = data
        self.error_detail = error_detail
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.error_detail:
            self.error_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.code is not None:
            result['Code'] = self.code
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.data is not None:
            result['Data'] = self.data
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorDetail') is not None:
            temp_model = DeleteProjectResponseBodyErrorDetail()
            self.error_detail = temp_model.from_map(m['ErrorDetail'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DeleteProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityIpGroupRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
    ):
        # The name of the IP address whitelist group.    
        # It must be 2 to 32 characters in length, start with a lowercase letter, end with a lowercase letter or digit, and contain only lowercase letters, digits, and underscores (_).
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The information of the deleted IP whitelist group.
        # 
        # This parameter is required.
        self.security_ip_group_name = security_ip_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        return self


class DeleteSecurityIpGroupResponseBodySecurityIpGroup(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
    ):
        self.instance_id = instance_id
        self.security_ip_group_name = security_ip_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        return self


class DeleteSecurityIpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_ip_group: DeleteSecurityIpGroupResponseBodySecurityIpGroup = None,
    ):
        # Example 1
        self.request_id = request_id
        self.security_ip_group = security_ip_group

    def validate(self):
        if self.security_ip_group:
            self.security_ip_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_ip_group is not None:
            result['SecurityIpGroup'] = self.security_ip_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityIpGroup') is not None:
            temp_model = DeleteSecurityIpGroupResponseBodySecurityIpGroup()
            self.security_ip_group = temp_model.from_map(m['SecurityIpGroup'])
        return self


class DeleteSecurityIpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityIpGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityIpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagRequest(TeaModel):
    def __init__(
        self,
        key: str = None,
    ):
        # The name of the tag group.
        # 
        # This parameter is required.
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class DeleteTagResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
    ):
        # The tag group deletion result.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagValueRequest(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The name of the tag group.
        # 
        # This parameter is required.
        self.key = key
        # The name of the tag.
        # 
        # This parameter is required.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteTagValueResponseBody(TeaModel):
    def __init__(
        self,
        message: str = None,
        request_id: str = None,
    ):
        # The tag deletion result.
        self.message = message
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagValueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTagValueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagValueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTenantSecurityIpGroupRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The group name of the whitelist group of IP addresses.
        # 
        # It starts with lowercase letters and ends with lowercase letters or numbers. It can only contain lowercase letters, numbers, and underscores, and should be 2~32 characters in length.
        # 
        # This parameter is required.
        self.security_ip_group_name = security_ip_group_name
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteTenantSecurityIpGroupResponseBodySecurityIpGroup(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        security_ip_group_name: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The name of the whitelist group.
        self.security_ip_group_name = security_ip_group_name
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.security_ip_group_name is not None:
            result['SecurityIpGroupName'] = self.security_ip_group_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SecurityIpGroupName') is not None:
            self.security_ip_group_name = m.get('SecurityIpGroupName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DeleteTenantSecurityIpGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_ip_group: DeleteTenantSecurityIpGroupResponseBodySecurityIpGroup = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The information of the whitelist group.
        self.security_ip_group = security_ip_group

    def validate(self):
        if self.security_ip_group:
            self.security_ip_group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_ip_group is not None:
            result['SecurityIpGroup'] = self.security_ip_group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityIpGroup') is not None:
            temp_model = DeleteTenantSecurityIpGroupResponseBodySecurityIpGroup()
            self.security_ip_group = temp_model.from_map(m['SecurityIpGroup'])
        return self


class DeleteTenantSecurityIpGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTenantSecurityIpGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTenantSecurityIpGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTenantUsersRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        tenant_id: str = None,
        users: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id
        # A list of usernames.
        # 
        # This parameter is required.
        self.users = users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.users is not None:
            result['Users'] = self.users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Users') is not None:
            self.users = m.get('Users')
        return self


class DeleteTenantUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTenantUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTenantUsersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTenantUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTenantsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        tenant_ids: str = None,
    ):
        # You can call this operation to delete one or more tenants from an OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # ```
        # http(s)://[Endpoint]/?Action=DeleteTenants
        # &TenantIds=["ob2mr3oae0****", "ob2mr3oae1****"]
        # &InstanceId=ob317v4uif****\
        # &Common request parameters
        # ```
        # 
        # This parameter is required.
        self.tenant_ids = tenant_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_ids is not None:
            result['TenantIds'] = self.tenant_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantIds') is not None:
            self.tenant_ids = m.get('TenantIds')
        return self


class DeleteTenantsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tenant_ids: List[str] = None,
    ):
        self.request_id = request_id
        self.tenant_ids = tenant_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tenant_ids is not None:
            result['TenantIds'] = self.tenant_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TenantIds') is not None:
            self.tenant_ids = m.get('TenantIds')
        return self


class DeleteTenantsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTenantsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTenantsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAnomalySQLListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        db_name: str = None,
        end_time: str = None,
        filter_condition: Dict[str, Any] = None,
        instance_id: str = None,
        node_ip: str = None,
        page_number: int = None,
        page_size: int = None,
        sqlid: str = None,
        search_key_word: str = None,
        search_parameter: str = None,
        search_rule: str = None,
        search_value: str = None,
        sort_column: str = None,
        sort_order: str = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the returned data.   
        # Default value: CN for a China site and EN for an International site.
        self.accept_language = accept_language
        # The name of the database.
        self.db_name = db_name
        # The end time of the time range for querying suspicious SQL statements.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The filter condition.   
        # > <br> - All fields in OceanBase Database support filtering. <br> - You can write the key-value pair of a parameter in a JSON string in the JSON format to filter the parameter.
        self.filter_condition = filter_condition
        # This parameter is required.
        self.instance_id = instance_id
        # The IP address of the node.
        self.node_ip = node_ip
        # The number of the page to return.    
        # - Start value: 1   
        # - Default value: 1
        self.page_number = page_number
        # The number of rows to return on each page.    
        # - Maximum value: 100   
        # - Default value: 10
        self.page_size = page_size
        # SQLID.
        self.sqlid = sqlid
        # The search keyword.
        self.search_key_word = search_key_word
        # The search parameter.
        self.search_parameter = search_parameter
        # The search rule.   
        # Valid values: "=", ">", ">=", "<", and "<="
        self.search_rule = search_rule
        # The search value.
        self.search_value = search_value
        # The sorted column.
        self.sort_column = sort_column
        # The sorting rule.
        self.sort_order = sort_order
        # The start time of the time range for querying suspicious SQL statements.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_condition is not None:
            result['FilterCondition'] = self.filter_condition
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sqlid is not None:
            result['SQLId'] = self.sqlid
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.search_parameter is not None:
            result['SearchParameter'] = self.search_parameter
        if self.search_rule is not None:
            result['SearchRule'] = self.search_rule
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        if self.sort_column is not None:
            result['SortColumn'] = self.sort_column
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterCondition') is not None:
            self.filter_condition = m.get('FilterCondition')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SQLId') is not None:
            self.sqlid = m.get('SQLId')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SearchParameter') is not None:
            self.search_parameter = m.get('SearchParameter')
        if m.get('SearchRule') is not None:
            self.search_rule = m.get('SearchRule')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        if m.get('SortColumn') is not None:
            self.sort_column = m.get('SortColumn')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeAnomalySQLListShrinkRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        db_name: str = None,
        end_time: str = None,
        filter_condition_shrink: str = None,
        instance_id: str = None,
        node_ip: str = None,
        page_number: int = None,
        page_size: int = None,
        sqlid: str = None,
        search_key_word: str = None,
        search_parameter: str = None,
        search_rule: str = None,
        search_value: str = None,
        sort_column: str = None,
        sort_order: str = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the returned data.   
        # Default value: CN for a China site and EN for an International site.
        self.accept_language = accept_language
        # The name of the database.
        self.db_name = db_name
        # The end time of the time range for querying suspicious SQL statements.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The filter condition.   
        # > <br> - All fields in OceanBase Database support filtering. <br> - You can write the key-value pair of a parameter in a JSON string in the JSON format to filter the parameter.
        self.filter_condition_shrink = filter_condition_shrink
        # This parameter is required.
        self.instance_id = instance_id
        # The IP address of the node.
        self.node_ip = node_ip
        # The number of the page to return.    
        # - Start value: 1   
        # - Default value: 1
        self.page_number = page_number
        # The number of rows to return on each page.    
        # - Maximum value: 100   
        # - Default value: 10
        self.page_size = page_size
        # SQLID.
        self.sqlid = sqlid
        # The search keyword.
        self.search_key_word = search_key_word
        # The search parameter.
        self.search_parameter = search_parameter
        # The search rule.   
        # Valid values: "=", ">", ">=", "<", and "<="
        self.search_rule = search_rule
        # The search value.
        self.search_value = search_value
        # The sorted column.
        self.sort_column = sort_column
        # The sorting rule.
        self.sort_order = sort_order
        # The start time of the time range for querying suspicious SQL statements.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_condition_shrink is not None:
            result['FilterCondition'] = self.filter_condition_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sqlid is not None:
            result['SQLId'] = self.sqlid
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.search_parameter is not None:
            result['SearchParameter'] = self.search_parameter
        if self.search_rule is not None:
            result['SearchRule'] = self.search_rule
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        if self.sort_column is not None:
            result['SortColumn'] = self.sort_column
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterCondition') is not None:
            self.filter_condition_shrink = m.get('FilterCondition')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SQLId') is not None:
            self.sqlid = m.get('SQLId')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SearchParameter') is not None:
            self.search_parameter = m.get('SearchParameter')
        if m.get('SearchRule') is not None:
            self.search_rule = m.get('SearchRule')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        if m.get('SortColumn') is not None:
            self.sort_column = m.get('SortColumn')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeAnomalySQLListResponseBodyAnomalySQLList(TeaModel):
    def __init__(
        self,
        cpu_time: float = None,
        db_name: str = None,
        diagnosis: str = None,
        diagnosis_rule: str = None,
        executions: int = None,
        key: int = None,
        request_time: float = None,
        request_time_utcstring: str = None,
        sqlid: str = None,
        sqltext: str = None,
        suggestion: str = None,
        user_name: str = None,
    ):
        # The average CPU time, in ms.
        self.cpu_time = cpu_time
        # The name of the database.
        self.db_name = db_name
        # The diagnosis information.
        self.diagnosis = diagnosis
        # The diagnostic rule.
        self.diagnosis_rule = diagnosis_rule
        # The number of executions.
        self.executions = executions
        # The sequence number of the returned SQL statement.
        self.key = key
        # The request time, in ms.
        self.request_time = request_time
        # The request time in UTC +0.
        self.request_time_utcstring = request_time_utcstring
        # SQLID.
        self.sqlid = sqlid
        # The SQL text.
        self.sqltext = sqltext
        # The suggestions.
        self.suggestion = suggestion
        # The username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.diagnosis is not None:
            result['Diagnosis'] = self.diagnosis
        if self.diagnosis_rule is not None:
            result['DiagnosisRule'] = self.diagnosis_rule
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.key is not None:
            result['Key'] = self.key
        if self.request_time is not None:
            result['RequestTime'] = self.request_time
        if self.request_time_utcstring is not None:
            result['RequestTimeUTCString'] = self.request_time_utcstring
        if self.sqlid is not None:
            result['SQLId'] = self.sqlid
        if self.sqltext is not None:
            result['SQLText'] = self.sqltext
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Diagnosis') is not None:
            self.diagnosis = m.get('Diagnosis')
        if m.get('DiagnosisRule') is not None:
            self.diagnosis_rule = m.get('DiagnosisRule')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RequestTime') is not None:
            self.request_time = m.get('RequestTime')
        if m.get('RequestTimeUTCString') is not None:
            self.request_time_utcstring = m.get('RequestTimeUTCString')
        if m.get('SQLId') is not None:
            self.sqlid = m.get('SQLId')
        if m.get('SQLText') is not None:
            self.sqltext = m.get('SQLText')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeAnomalySQLListResponseBody(TeaModel):
    def __init__(
        self,
        anomaly_sqllist: List[DescribeAnomalySQLListResponseBodyAnomalySQLList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of suspicious SQL statements.
        self.anomaly_sqllist = anomaly_sqllist
        # The request ID.
        self.request_id = request_id
        # The total count.
        self.total_count = total_count

    def validate(self):
        if self.anomaly_sqllist:
            for k in self.anomaly_sqllist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnomalySQLList'] = []
        if self.anomaly_sqllist is not None:
            for k in self.anomaly_sqllist:
                result['AnomalySQLList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.anomaly_sqllist = []
        if m.get('AnomalySQLList') is not None:
            for k in m.get('AnomalySQLList'):
                temp_model = DescribeAnomalySQLListResponseBodyAnomalySQLList()
                self.anomaly_sqllist.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAnomalySQLListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAnomalySQLListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAnomalySQLListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableCpuResourceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        modify_type: str = None,
        tenant_id: str = None,
    ):
        # The CPU resources available.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # ```
        # http(s)://[Endpoint]/?Action=DescribeAvailableCpuResource
        # &InstanceId=ob317v4uif****\
        # &TenantId=ob2mr3oae0****\
        # &ModifyType=update
        # &Common request parameters
        # ```
        self.modify_type = modify_type
        # The operation that you want to perform.   
        # Set the value to **DescribeAvailableCpuResource**.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_type is not None:
            result['ModifyType'] = self.modify_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyType') is not None:
            self.modify_type = m.get('ModifyType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeAvailableCpuResourceResponseBodyData(TeaModel):
    def __init__(
        self,
        comment: str = None,
        max_cpu: int = None,
        min_cpu: int = None,
        review_code: str = None,
        unit_num: int = None,
    ):
        self.comment = comment
        self.max_cpu = max_cpu
        self.min_cpu = min_cpu
        self.review_code = review_code
        self.unit_num = unit_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.max_cpu is not None:
            result['MaxCpu'] = self.max_cpu
        if self.min_cpu is not None:
            result['MinCpu'] = self.min_cpu
        if self.review_code is not None:
            result['ReviewCode'] = self.review_code
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MaxCpu') is not None:
            self.max_cpu = m.get('MaxCpu')
        if m.get('MinCpu') is not None:
            self.min_cpu = m.get('MinCpu')
        if m.get('ReviewCode') is not None:
            self.review_code = m.get('ReviewCode')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        return self


class DescribeAvailableCpuResourceResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeAvailableCpuResourceResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeAvailableCpuResourceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableCpuResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableCpuResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableCpuResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableMemResourceRequest(TeaModel):
    def __init__(
        self,
        cpu_num: int = None,
        instance_id: str = None,
        tenant_id: str = None,
        unit_num: int = None,
    ):
        # The number of CPU cores.
        # 
        # This parameter is required.
        self.cpu_num = cpu_num
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The number of resource distribution nodes in the tenant.   
        # The number is determined by the deployment mode of the cluster. If the cluster is deployed in 2-2-2 mode, the maximum number of resource distribution nodes is 2.
        # 
        # This parameter is required.
        self.unit_num = unit_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_num is not None:
            result['CpuNum'] = self.cpu_num
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.unit_num is not None:
            result['UnitNum'] = self.unit_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuNum') is not None:
            self.cpu_num = m.get('CpuNum')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UnitNum') is not None:
            self.unit_num = m.get('UnitNum')
        return self


class DescribeAvailableMemResourceResponseBodyData(TeaModel):
    def __init__(
        self,
        max_mem: int = None,
        min_mem: int = None,
        safe_mem: str = None,
        used_mem: int = None,
    ):
        # The maximum memory size for each resource unit, in GB.
        self.max_mem = max_mem
        # The minimum memory size required for each resource unit, in GB.
        self.min_mem = min_mem
        # The maximum allowed memory usage, in GB.
        self.safe_mem = safe_mem
        # The number of resource units in the tenant.
        self.used_mem = used_mem

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_mem is not None:
            result['MaxMem'] = self.max_mem
        if self.min_mem is not None:
            result['MinMem'] = self.min_mem
        if self.safe_mem is not None:
            result['SafeMem'] = self.safe_mem
        if self.used_mem is not None:
            result['UsedMem'] = self.used_mem
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxMem') is not None:
            self.max_mem = m.get('MaxMem')
        if m.get('MinMem') is not None:
            self.min_mem = m.get('MinMem')
        if m.get('SafeMem') is not None:
            self.safe_mem = m.get('SafeMem')
        if m.get('UsedMem') is not None:
            self.used_mem = m.get('UsedMem')
        return self


class DescribeAvailableMemResourceResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAvailableMemResourceResponseBodyData = None,
        request_id: str = None,
    ):
        # The available memory size.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAvailableMemResourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableMemResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableMemResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableMemResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableSpecRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        spec: str = None,
        upgrade_type: str = None,
    ):
        # This parameter is required.
        self.instance_id = instance_id
        self.spec = spec
        # This parameter is required.
        self.upgrade_type = upgrade_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.upgrade_type is not None:
            result['UpgradeType'] = self.upgrade_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('UpgradeType') is not None:
            self.upgrade_type = m.get('UpgradeType')
        return self


class DescribeAvailableSpecResponseBodyDataAvailableSpecificationsDiskSizeRange(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        step: int = None,
    ):
        self.max = max
        self.min = min
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableSpecResponseBodyDataAvailableSpecificationsLogDiskSizeRange(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        step: int = None,
    ):
        self.max = max
        self.min = min
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableSpecResponseBodyDataAvailableSpecifications(TeaModel):
    def __init__(
        self,
        disk_size_range: DescribeAvailableSpecResponseBodyDataAvailableSpecificationsDiskSizeRange = None,
        disk_types: List[str] = None,
        instance_class: str = None,
        log_disk_size_range: DescribeAvailableSpecResponseBodyDataAvailableSpecificationsLogDiskSizeRange = None,
        node_num: List[int] = None,
        spec: str = None,
    ):
        self.disk_size_range = disk_size_range
        self.disk_types = disk_types
        self.instance_class = instance_class
        self.log_disk_size_range = log_disk_size_range
        self.node_num = node_num
        self.spec = spec

    def validate(self):
        if self.disk_size_range:
            self.disk_size_range.validate()
        if self.log_disk_size_range:
            self.log_disk_size_range.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_size_range is not None:
            result['DiskSizeRange'] = self.disk_size_range.to_map()
        if self.disk_types is not None:
            result['DiskTypes'] = self.disk_types
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.log_disk_size_range is not None:
            result['LogDiskSizeRange'] = self.log_disk_size_range.to_map()
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskSizeRange') is not None:
            temp_model = DescribeAvailableSpecResponseBodyDataAvailableSpecificationsDiskSizeRange()
            self.disk_size_range = temp_model.from_map(m['DiskSizeRange'])
        if m.get('DiskTypes') is not None:
            self.disk_types = m.get('DiskTypes')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('LogDiskSizeRange') is not None:
            temp_model = DescribeAvailableSpecResponseBodyDataAvailableSpecificationsLogDiskSizeRange()
            self.log_disk_size_range = temp_model.from_map(m['LogDiskSizeRange'])
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class DescribeAvailableSpecResponseBodyData(TeaModel):
    def __init__(
        self,
        available_specifications: List[DescribeAvailableSpecResponseBodyDataAvailableSpecifications] = None,
    ):
        self.available_specifications = available_specifications

    def validate(self):
        if self.available_specifications:
            for k in self.available_specifications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableSpecifications'] = []
        if self.available_specifications is not None:
            for k in self.available_specifications:
                result['AvailableSpecifications'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_specifications = []
        if m.get('AvailableSpecifications') is not None:
            for k in m.get('AvailableSpecifications'):
                temp_model = DescribeAvailableSpecResponseBodyDataAvailableSpecifications()
                self.available_specifications.append(temp_model.from_map(k))
        return self


class DescribeAvailableSpecResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAvailableSpecResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAvailableSpecResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableSpecResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableSpecResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableSpecResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableZoneRequest(TeaModel):
    def __init__(
        self,
        cpu_arch: str = None,
        deploy_type: str = None,
        instance_type: str = None,
        ob_version: str = None,
        series: str = None,
        spec: str = None,
    ):
        self.cpu_arch = cpu_arch
        self.deploy_type = deploy_type
        # This parameter is required.
        self.instance_type = instance_type
        self.ob_version = ob_version
        self.series = series
        self.spec = spec

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.deploy_type is not None:
            result['DeployType'] = self.deploy_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ob_version is not None:
            result['ObVersion'] = self.ob_version
        if self.series is not None:
            result['Series'] = self.series
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DeployType') is not None:
            self.deploy_type = m.get('DeployType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('ObVersion') is not None:
            self.ob_version = m.get('ObVersion')
        if m.get('Series') is not None:
            self.series = m.get('Series')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsDiskSizeRange(TeaModel):
    def __init__(
        self,
        max: int = None,
        min: int = None,
        step: int = None,
    ):
        self.max = max
        self.min = min
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsSupportEngineVersions(TeaModel):
    def __init__(
        self,
        ob_version: str = None,
        support_isolation_optimization: bool = None,
        support_replica_modes: List[str] = None,
    ):
        self.ob_version = ob_version
        self.support_isolation_optimization = support_isolation_optimization
        self.support_replica_modes = support_replica_modes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ob_version is not None:
            result['ObVersion'] = self.ob_version
        if self.support_isolation_optimization is not None:
            result['SupportIsolationOptimization'] = self.support_isolation_optimization
        if self.support_replica_modes is not None:
            result['SupportReplicaModes'] = self.support_replica_modes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObVersion') is not None:
            self.ob_version = m.get('ObVersion')
        if m.get('SupportIsolationOptimization') is not None:
            self.support_isolation_optimization = m.get('SupportIsolationOptimization')
        if m.get('SupportReplicaModes') is not None:
            self.support_replica_modes = m.get('SupportReplicaModes')
        return self


class DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecifications(TeaModel):
    def __init__(
        self,
        disk_size_range: DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsDiskSizeRange = None,
        disk_types: List[str] = None,
        instance_class: str = None,
        spec: str = None,
        support_engine_versions: List[DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsSupportEngineVersions] = None,
    ):
        self.disk_size_range = disk_size_range
        self.disk_types = disk_types
        self.instance_class = instance_class
        self.spec = spec
        self.support_engine_versions = support_engine_versions

    def validate(self):
        if self.disk_size_range:
            self.disk_size_range.validate()
        if self.support_engine_versions:
            for k in self.support_engine_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_size_range is not None:
            result['DiskSizeRange'] = self.disk_size_range.to_map()
        if self.disk_types is not None:
            result['DiskTypes'] = self.disk_types
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.spec is not None:
            result['Spec'] = self.spec
        result['SupportEngineVersions'] = []
        if self.support_engine_versions is not None:
            for k in self.support_engine_versions:
                result['SupportEngineVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskSizeRange') is not None:
            temp_model = DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsDiskSizeRange()
            self.disk_size_range = temp_model.from_map(m['DiskSizeRange'])
        if m.get('DiskTypes') is not None:
            self.disk_types = m.get('DiskTypes')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        self.support_engine_versions = []
        if m.get('SupportEngineVersions') is not None:
            for k in m.get('SupportEngineVersions'):
                temp_model = DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecificationsSupportEngineVersions()
                self.support_engine_versions.append(temp_model.from_map(k))
        return self


class DescribeAvailableZoneResponseBodyDataAvailableZones(TeaModel):
    def __init__(
        self,
        channel: str = None,
        cpu_arch: str = None,
        deploy_type: str = None,
        instance_type: str = None,
        region: str = None,
        series: str = None,
        support_specifications: List[DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecifications] = None,
        zones: str = None,
    ):
        self.channel = channel
        self.cpu_arch = cpu_arch
        self.deploy_type = deploy_type
        self.instance_type = instance_type
        self.region = region
        self.series = series
        self.support_specifications = support_specifications
        self.zones = zones

    def validate(self):
        if self.support_specifications:
            for k in self.support_specifications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.deploy_type is not None:
            result['DeployType'] = self.deploy_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region is not None:
            result['Region'] = self.region
        if self.series is not None:
            result['Series'] = self.series
        result['SupportSpecifications'] = []
        if self.support_specifications is not None:
            for k in self.support_specifications:
                result['SupportSpecifications'].append(k.to_map() if k else None)
        if self.zones is not None:
            result['Zones'] = self.zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DeployType') is not None:
            self.deploy_type = m.get('DeployType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Series') is not None:
            self.series = m.get('Series')
        self.support_specifications = []
        if m.get('SupportSpecifications') is not None:
            for k in m.get('SupportSpecifications'):
                temp_model = DescribeAvailableZoneResponseBodyDataAvailableZonesSupportSpecifications()
                self.support_specifications.append(temp_model.from_map(k))
        if m.get('Zones') is not None:
            self.zones = m.get('Zones')
        return self


class DescribeAvailableZoneResponseBodyData(TeaModel):
    def __init__(
        self,
        available_zones: List[DescribeAvailableZoneResponseBodyDataAvailableZones] = None,
    ):
        self.available_zones = available_zones

    def validate(self):
        if self.available_zones:
            for k in self.available_zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableZones'] = []
        if self.available_zones is not None:
            for k in self.available_zones:
                result['AvailableZones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_zones = []
        if m.get('AvailableZones') is not None:
            for k in m.get('AvailableZones'):
                temp_model = DescribeAvailableZoneResponseBodyDataAvailableZones()
                self.available_zones.append(temp_model.from_map(k))
        return self


class DescribeAvailableZoneResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAvailableZoneResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAvailableZoneResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableZoneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAvailableZoneResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableZoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupEncryptedStringRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        tenant_id: str = None,
    ):
        # This parameter is required.
        self.instance_id = instance_id
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeBackupEncryptedStringResponseBodyData(TeaModel):
    def __init__(
        self,
        backup_info_json: str = None,
    ):
        self.backup_info_json = backup_info_json

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_info_json is not None:
            result['BackupInfoJson'] = self.backup_info_json
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupInfoJson') is not None:
            self.backup_info_json = m.get('BackupInfoJson')
        return self


class DescribeBackupEncryptedStringResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeBackupEncryptedStringResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeBackupEncryptedStringResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupEncryptedStringResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupEncryptedStringResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupEncryptedStringResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupSetDownloadLinkRequest(TeaModel):
    def __init__(
        self,
        download_task_id: str = None,
        instance_id: str = None,
    ):
        # The ID of the download task corresponding to the target backup set.
        # 
        # This parameter is required.
        self.download_task_id = download_task_id
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.download_task_id is not None:
            result['DownloadTaskId'] = self.download_task_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DownloadTaskId') is not None:
            self.download_task_id = m.get('DownloadTaskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeBackupSetDownloadLinkResponseBodyData(TeaModel):
    def __init__(
        self,
        backup_restorable_time: str = None,
        backup_set_id: str = None,
        download_task_create_time: str = None,
        download_task_id: int = None,
        download_task_status: str = None,
        internal_url: str = None,
        url_alive_time: int = None,
        url_expired_time: str = None,
    ):
        # The restorable time of the backup set.
        self.backup_restorable_time = backup_restorable_time
        # The ID of the target backup set.
        self.backup_set_id = backup_set_id
        # The time when the download task corresponding to the target backup set was created.
        self.download_task_create_time = download_task_create_time
        # The ID of the download task corresponding to the target backup set.
        self.download_task_id = download_task_id
        # The status of the download task corresponding to the target backup set.
        self.download_task_status = download_task_status
        # The internal URL.
        self.internal_url = internal_url
        # The validity period of the URL, in seconds.
        self.url_alive_time = url_alive_time
        # The expiration time of the URL.
        self.url_expired_time = url_expired_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_restorable_time is not None:
            result['BackupRestorableTime'] = self.backup_restorable_time
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.download_task_create_time is not None:
            result['DownloadTaskCreateTime'] = self.download_task_create_time
        if self.download_task_id is not None:
            result['DownloadTaskId'] = self.download_task_id
        if self.download_task_status is not None:
            result['DownloadTaskStatus'] = self.download_task_status
        if self.internal_url is not None:
            result['InternalUrl'] = self.internal_url
        if self.url_alive_time is not None:
            result['UrlAliveTime'] = self.url_alive_time
        if self.url_expired_time is not None:
            result['UrlExpiredTime'] = self.url_expired_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRestorableTime') is not None:
            self.backup_restorable_time = m.get('BackupRestorableTime')
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('DownloadTaskCreateTime') is not None:
            self.download_task_create_time = m.get('DownloadTaskCreateTime')
        if m.get('DownloadTaskId') is not None:
            self.download_task_id = m.get('DownloadTaskId')
        if m.get('DownloadTaskStatus') is not None:
            self.download_task_status = m.get('DownloadTaskStatus')
        if m.get('InternalUrl') is not None:
            self.internal_url = m.get('InternalUrl')
        if m.get('UrlAliveTime') is not None:
            self.url_alive_time = m.get('UrlAliveTime')
        if m.get('UrlExpiredTime') is not None:
            self.url_expired_time = m.get('UrlExpiredTime')
        return self


class DescribeBackupSetDownloadLinkResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeBackupSetDownloadLinkResponseBodyData = None,
        request_id: str = None,
    ):
        # The returned data.
        self.data = data
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeBackupSetDownloadLinkResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupSetDownloadLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupSetDownloadLinkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupSetDownloadLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCharsetRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        series: str = None,
        tenant_mode: str = None,
    ):
        self.instance_id = instance_id
        # 实例的系列  - normal（默认）：标准集群版（云盘）  - normal_ssd：标准集群版（本地盘） - history：历史库集群版。
        self.series = series
        # The return result of the request.
        # 
        # This parameter is required.
        self.tenant_mode = tenant_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.series is not None:
            result['Series'] = self.series
        if self.tenant_mode is not None:
            result['TenantMode'] = self.tenant_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Series') is not None:
            self.series = m.get('Series')
        if m.get('TenantMode') is not None:
            self.tenant_mode = m.get('TenantMode')
        return self


class DescribeCharsetResponseBodyCharset(TeaModel):
    def __init__(
        self,
        charset: str = None,
        collations: List[str] = None,
    ):
        # DescribeCharset
        self.charset = charset
        self.collations = collations

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charset is not None:
            result['Charset'] = self.charset
        if self.collations is not None:
            result['Collations'] = self.collations
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Charset') is not None:
            self.charset = m.get('Charset')
        if m.get('Collations') is not None:
            self.collations = m.get('Collations')
        return self


class DescribeCharsetResponseBody(TeaModel):
    def __init__(
        self,
        charset: List[DescribeCharsetResponseBodyCharset] = None,
        request_id: str = None,
    ):
        # ```
        # http(s)://[Endpoint]/?Action=DescribeCharset
        # &TenantMode=Oracle
        # &Common request parameters
        # ```
        self.charset = charset
        # The operation that you want to perform.   
        # Set the value to **DescribeCharset**.
        self.request_id = request_id

    def validate(self):
        if self.charset:
            for k in self.charset:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Charset'] = []
        if self.charset is not None:
            for k in self.charset:
                result['Charset'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.charset = []
        if m.get('Charset') is not None:
            for k in m.get('Charset'):
                temp_model = DescribeCharsetResponseBodyCharset()
                self.charset.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCharsetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCharsetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCharsetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataBackupSetRequest(TeaModel):
    def __init__(
        self,
        backup_object_type: str = None,
        end_time: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
        status: str = None,
    ):
        self.backup_object_type = backup_object_type
        self.end_time = end_time
        # This parameter is required.
        self.instance_id = instance_id
        self.page_number = page_number
        self.page_size = page_size
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_object_type is not None:
            result['BackupObjectType'] = self.backup_object_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupObjectType') is not None:
            self.backup_object_type = m.get('BackupObjectType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDataBackupSetResponseBodyDataBackupObjectsDatabaseTablesList(TeaModel):
    def __init__(
        self,
        database: str = None,
        tables: List[str] = None,
    ):
        self.database = database
        self.tables = tables

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.tables is not None:
            result['Tables'] = self.tables
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        return self


class DescribeDataBackupSetResponseBodyDataBackupObjects(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        database_tables_list: List[DescribeDataBackupSetResponseBodyDataBackupObjectsDatabaseTablesList] = None,
        tenant_name: str = None,
    ):
        self.cluster_name = cluster_name
        self.database_tables_list = database_tables_list
        self.tenant_name = tenant_name

    def validate(self):
        if self.database_tables_list:
            for k in self.database_tables_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        result['DatabaseTablesList'] = []
        if self.database_tables_list is not None:
            for k in self.database_tables_list:
                result['DatabaseTablesList'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        self.database_tables_list = []
        if m.get('DatabaseTablesList') is not None:
            for k in m.get('DatabaseTablesList'):
                temp_model = DescribeDataBackupSetResponseBodyDataBackupObjectsDatabaseTablesList()
                self.database_tables_list.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        return self


class DescribeDataBackupSetResponseBodyDataBackupResultsTableBackupResults(TeaModel):
    def __init__(
        self,
        database: str = None,
        message: str = None,
        status: str = None,
        table: str = None,
    ):
        self.database = database
        self.message = message
        self.status = status
        self.table = table

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.message is not None:
            result['Message'] = self.message
        if self.status is not None:
            result['Status'] = self.status
        if self.table is not None:
            result['Table'] = self.table
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        return self


class DescribeDataBackupSetResponseBodyDataBackupResults(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        table_backup_results: List[DescribeDataBackupSetResponseBodyDataBackupResultsTableBackupResults] = None,
        tenant_name: str = None,
    ):
        self.cluster_name = cluster_name
        self.table_backup_results = table_backup_results
        self.tenant_name = tenant_name

    def validate(self):
        if self.table_backup_results:
            for k in self.table_backup_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        result['TableBackupResults'] = []
        if self.table_backup_results is not None:
            for k in self.table_backup_results:
                result['TableBackupResults'].append(k.to_map() if k else None)
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        self.table_backup_results = []
        if m.get('TableBackupResults') is not None:
            for k in m.get('TableBackupResults'):
                temp_model = DescribeDataBackupSetResponseBodyDataBackupResultsTableBackupResults()
                self.table_backup_results.append(temp_model.from_map(k))
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        return self


class DescribeDataBackupSetResponseBodyData(TeaModel):
    def __init__(
        self,
        backup_object_type: str = None,
        backup_objects: List[DescribeDataBackupSetResponseBodyDataBackupObjects] = None,
        backup_results: List[DescribeDataBackupSetResponseBodyDataBackupResults] = None,
        checkpoint: str = None,
        data_size: int = None,
        data_version: int = None,
        download_task_id: int = None,
        download_task_status: str = None,
        end_time: str = None,
        method: str = None,
        policy: str = None,
        progress: str = None,
        set_id: str = None,
        start_time: str = None,
        status: str = None,
        storage_class: str = None,
        type: str = None,
        validity: str = None,
    ):
        self.backup_object_type = backup_object_type
        self.backup_objects = backup_objects
        self.backup_results = backup_results
        self.checkpoint = checkpoint
        self.data_size = data_size
        self.data_version = data_version
        self.download_task_id = download_task_id
        self.download_task_status = download_task_status
        self.end_time = end_time
        self.method = method
        self.policy = policy
        self.progress = progress
        self.set_id = set_id
        self.start_time = start_time
        self.status = status
        self.storage_class = storage_class
        self.type = type
        self.validity = validity

    def validate(self):
        if self.backup_objects:
            for k in self.backup_objects:
                if k:
                    k.validate()
        if self.backup_results:
            for k in self.backup_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_object_type is not None:
            result['BackupObjectType'] = self.backup_object_type
        result['BackupObjects'] = []
        if self.backup_objects is not None:
            for k in self.backup_objects:
                result['BackupObjects'].append(k.to_map() if k else None)
        result['BackupResults'] = []
        if self.backup_results is not None:
            for k in self.backup_results:
                result['BackupResults'].append(k.to_map() if k else None)
        if self.checkpoint is not None:
            result['Checkpoint'] = self.checkpoint
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.data_version is not None:
            result['DataVersion'] = self.data_version
        if self.download_task_id is not None:
            result['DownloadTaskId'] = self.download_task_id
        if self.download_task_status is not None:
            result['DownloadTaskStatus'] = self.download_task_status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.method is not None:
            result['Method'] = self.method
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.set_id is not None:
            result['SetId'] = self.set_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_class is not None:
            result['StorageClass'] = self.storage_class
        if self.type is not None:
            result['Type'] = self.type
        if self.validity is not None:
            result['Validity'] = self.validity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupObjectType') is not None:
            self.backup_object_type = m.get('BackupObjectType')
        self.backup_objects = []
        if m.get('BackupObjects') is not None:
            for k in m.get('BackupObjects'):
                temp_model = DescribeDataBackupSetResponseBodyDataBackupObjects()
                self.backup_objects.append(temp_model.from_map(k))
        self.backup_results = []
        if m.get('BackupResults') is not None:
            for k in m.get('BackupResults'):
                temp_model = DescribeDataBackupSetResponseBodyDataBackupResults()
                self.backup_results.append(temp_model.from_map(k))
        if m.get('Checkpoint') is not None:
            self.checkpoint = m.get('Checkpoint')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DataVersion') is not None:
            self.data_version = m.get('DataVersion')
        if m.get('DownloadTaskId') is not None:
            self.download_task_id = m.get('DownloadTaskId')
        if m.get('DownloadTaskStatus') is not None:
            self.download_task_status = m.get('DownloadTaskStatus')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SetId') is not None:
            self.set_id = m.get('SetId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageClass') is not None:
            self.storage_class = m.get('StorageClass')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Validity') is not None:
            self.validity = m.get('Validity')
        return self


class DescribeDataBackupSetResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeDataBackupSetResponseBodyData] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.data = data
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDataBackupSetResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDataBackupSetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDataBackupSetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDataBackupSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDatabasesRequest(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        search_key: str = None,
        tenant_id: str = None,
        with_tables: bool = None,
    ):
        # The name of the database.    
        # You cannot use reserved keywords, such as test and mysql.
        self.database_name = database_name
        # The ID of the cluster.
        self.instance_id = instance_id
        # The number of the page returned.  
        # - Start value: 1   
        # - Default value: 1
        self.page_number = page_number
        # The number of rows returned on each page.  
        # - Maximum value: 100.  
        # - Default value: 10
        self.page_size = page_size
        # The search keyword.
        self.search_key = search_key
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # Specifies whether to return the information about tables in the database.
        # Default value: false. 
        # > The operation may time out if the database contains a large number of tables.
        self.with_tables = with_tables

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.with_tables is not None:
            result['WithTables'] = self.with_tables
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('WithTables') is not None:
            self.with_tables = m.get('WithTables')
        return self


class DescribeDatabasesResponseBodyDatabasesTables(TeaModel):
    def __init__(
        self,
        table_name: str = None,
    ):
        # The name of the database table.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeDatabasesResponseBodyDatabasesUsers(TeaModel):
    def __init__(
        self,
        privileges: str = None,
        role: str = None,
        user_name: str = None,
        user_type: str = None,
    ):
        # If you have granted custom privileges on the database, this parameter indicates the custom privileges, separated by commas (,). Otherwise, no data is returned for this parameter.
        self.privileges = privileges
        # The role of the account.    
        # In MySQL mode, a role is a database-level role. Valid values:  
        # - ReadWrite: a role that has the read and write privileges, namely ALL PRIVILEGES.  
        # - ReadOnly: a role that has only the read-only privilege SELECT.   
        # - DDL: a role that has the DDL privileges such as CREATE, DROP, ALTER, SHOW VIEW, and CREATE VIEW.   
        # - DML: a role that has the DML privileges such as SELECT, INSERT, UPDATE, DELETE, and SHOW VIEW.
        self.role = role
        # The name of the account.
        self.user_name = user_name
        # The type of the account. Valid values:  
        # - Admin: the super administrator account. 
        # - Normal: a general account.
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.privileges is not None:
            result['Privileges'] = self.privileges
        if self.role is not None:
            result['Role'] = self.role
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Privileges') is not None:
            self.privileges = m.get('Privileges')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeDatabasesResponseBodyDatabases(TeaModel):
    def __init__(
        self,
        collation: str = None,
        create_time: str = None,
        data_size: float = None,
        database_name: str = None,
        db_type: str = None,
        description: str = None,
        encoding: str = None,
        instance_id: str = None,
        required_size: float = None,
        status: str = None,
        tables: List[DescribeDatabasesResponseBodyDatabasesTables] = None,
        tenant_id: str = None,
        tenant_name: str = None,
        users: List[DescribeDatabasesResponseBodyDatabasesUsers] = None,
    ):
        # The collation.
        self.collation = collation
        # The time when the database was created.
        self.create_time = create_time
        # The actual data size, in GB. 
        # >Notice: This parameter is no longer used in later versions. RequiredSize is used instead.
        self.data_size = data_size
        # The name of the database.
        self.database_name = database_name
        # The database type.
        self.db_type = db_type
        # The description of the database.
        self.description = description
        # The encoding standard of the database. Encoding standards such as utf8mb4 and GBK are supported.
        self.encoding = encoding
        # The ID of the cluster to which the tenant belongs.
        self.instance_id = instance_id
        # The storage space required, in GB.
        self.required_size = required_size
        # The status of the database. Valid values:    
        # - ONLINE: The database is running.  
        # - DELETING: The database is being deleted.
        self.status = status
        # The list of database tables.
        self.tables = tables
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The name of the tenant.
        self.tenant_name = tenant_name
        # The list of accounts that are granted privileges on this database.
        self.users = users

    def validate(self):
        if self.tables:
            for k in self.tables:
                if k:
                    k.validate()
        if self.users:
            for k in self.users:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.collation is not None:
            result['Collation'] = self.collation
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.db_type is not None:
            result['DbType'] = self.db_type
        if self.description is not None:
            result['Description'] = self.description
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.required_size is not None:
            result['RequiredSize'] = self.required_size
        if self.status is not None:
            result['Status'] = self.status
        result['Tables'] = []
        if self.tables is not None:
            for k in self.tables:
                result['Tables'].append(k.to_map() if k else None)
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        result['Users'] = []
        if self.users is not None:
            for k in self.users:
                result['Users'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Collation') is not None:
            self.collation = m.get('Collation')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequiredSize') is not None:
            self.required_size = m.get('RequiredSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tables = []
        if m.get('Tables') is not None:
            for k in m.get('Tables'):
                temp_model = DescribeDatabasesResponseBodyDatabasesTables()
                self.tables.append(temp_model.from_map(k))
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        self.users = []
        if m.get('Users') is not None:
            for k in m.get('Users'):
                temp_model = DescribeDatabasesResponseBodyDatabasesUsers()
                self.users.append(temp_model.from_map(k))
        return self


class DescribeDatabasesResponseBody(TeaModel):
    def __init__(
        self,
        databases: List[DescribeDatabasesResponseBodyDatabases] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of databases in the tenant.
        self.databases = databases
        # The ID of the request.
        self.request_id = request_id
        # The total number of databases in the tenant.
        self.total_count = total_count

    def validate(self):
        if self.databases:
            for k in self.databases:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Databases'] = []
        if self.databases is not None:
            for k in self.databases:
                result['Databases'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.databases = []
        if m.get('Databases') is not None:
            for k in m.get('Databases'):
                temp_model = DescribeDatabasesResponseBodyDatabases()
                self.databases.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDatabasesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDatabasesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDatabasesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_number: int = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return.
        # - Pages start from page 1.
        # - Default value: 1.
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class DescribeInstanceResponseBodyInstanceDataDiskAutoScaleConfig(TeaModel):
    def __init__(
        self,
        auto_scale: bool = None,
        max_disk_size: int = None,
        scale_step_in_merge: int = None,
        scale_step_in_normal: int = None,
        upper_merge_threshold: int = None,
        upper_scale_step: str = None,
        upper_scale_strategy: str = None,
        upper_threshold: int = None,
        upperbound: int = None,
    ):
        # Specifies whether to enable the automatic scaling of the data disk.
        self.auto_scale = auto_scale
        # The maximum size of the disk, in GB.
        self.max_disk_size = max_disk_size
        # The size of scaling step during a major compaction.
        self.scale_step_in_merge = scale_step_in_merge
        # The size of scaling step during daily use.
        self.scale_step_in_normal = scale_step_in_normal
        # The maximum usage of the data disk, in percentage, that triggers the scaling of the data disk for major compactions.
        self.upper_merge_threshold = upper_merge_threshold
        # The step size of the scale-out.
        self.upper_scale_step = upper_scale_step
        # The scale-out strategy. Valid values: RAW and PERCENTAGE.
        self.upper_scale_strategy = upper_scale_strategy
        # The maximum usage of the data disk, in percentage, that triggers the scaling of the data disk for daily use.
        self.upper_threshold = upper_threshold
        # The maximum space, in GB, to which the data disk can be scaled.
        self.upperbound = upperbound

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_scale is not None:
            result['AutoScale'] = self.auto_scale
        if self.max_disk_size is not None:
            result['MaxDiskSize'] = self.max_disk_size
        if self.scale_step_in_merge is not None:
            result['ScaleStepInMerge'] = self.scale_step_in_merge
        if self.scale_step_in_normal is not None:
            result['ScaleStepInNormal'] = self.scale_step_in_normal
        if self.upper_merge_threshold is not None:
            result['UpperMergeThreshold'] = self.upper_merge_threshold
        if self.upper_scale_step is not None:
            result['UpperScaleStep'] = self.upper_scale_step
        if self.upper_scale_strategy is not None:
            result['UpperScaleStrategy'] = self.upper_scale_strategy
        if self.upper_threshold is not None:
            result['UpperThreshold'] = self.upper_threshold
        if self.upperbound is not None:
            result['Upperbound'] = self.upperbound
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoScale') is not None:
            self.auto_scale = m.get('AutoScale')
        if m.get('MaxDiskSize') is not None:
            self.max_disk_size = m.get('MaxDiskSize')
        if m.get('ScaleStepInMerge') is not None:
            self.scale_step_in_merge = m.get('ScaleStepInMerge')
        if m.get('ScaleStepInNormal') is not None:
            self.scale_step_in_normal = m.get('ScaleStepInNormal')
        if m.get('UpperMergeThreshold') is not None:
            self.upper_merge_threshold = m.get('UpperMergeThreshold')
        if m.get('UpperScaleStep') is not None:
            self.upper_scale_step = m.get('UpperScaleStep')
        if m.get('UpperScaleStrategy') is not None:
            self.upper_scale_strategy = m.get('UpperScaleStrategy')
        if m.get('UpperThreshold') is not None:
            self.upper_threshold = m.get('UpperThreshold')
        if m.get('Upperbound') is not None:
            self.upperbound = m.get('Upperbound')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResourceCapacityUnit(TeaModel):
    def __init__(
        self,
        max_capacity_unit: int = None,
        min_capacity_unit: int = None,
        used_capacity_unit: str = None,
    ):
        # The maximum number of capacity units.
        self.max_capacity_unit = max_capacity_unit
        # The minimum number of capacity units.
        self.min_capacity_unit = min_capacity_unit
        # The number of used capacity units.
        self.used_capacity_unit = used_capacity_unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_capacity_unit is not None:
            result['MaxCapacityUnit'] = self.max_capacity_unit
        if self.min_capacity_unit is not None:
            result['MinCapacityUnit'] = self.min_capacity_unit
        if self.used_capacity_unit is not None:
            result['UsedCapacityUnit'] = self.used_capacity_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxCapacityUnit') is not None:
            self.max_capacity_unit = m.get('MaxCapacityUnit')
        if m.get('MinCapacityUnit') is not None:
            self.min_capacity_unit = m.get('MinCapacityUnit')
        if m.get('UsedCapacityUnit') is not None:
            self.used_capacity_unit = m.get('UsedCapacityUnit')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResourceCpu(TeaModel):
    def __init__(
        self,
        original_total_cpu: int = None,
        total_cpu: int = None,
        unit_cpu: int = None,
        used_cpu: int = None,
    ):
        # The number of original CPU cores in the cluster.
        self.original_total_cpu = original_total_cpu
        # The total number of CPU cores of the cluster.
        self.total_cpu = total_cpu
        # The number of CPU cores of each replica node in the cluster.
        self.unit_cpu = unit_cpu
        # The number of CPU cores used by the cluster.
        self.used_cpu = used_cpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_cpu is not None:
            result['OriginalTotalCpu'] = self.original_total_cpu
        if self.total_cpu is not None:
            result['TotalCpu'] = self.total_cpu
        if self.unit_cpu is not None:
            result['UnitCpu'] = self.unit_cpu
        if self.used_cpu is not None:
            result['UsedCpu'] = self.used_cpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalCpu') is not None:
            self.original_total_cpu = m.get('OriginalTotalCpu')
        if m.get('TotalCpu') is not None:
            self.total_cpu = m.get('TotalCpu')
        if m.get('UnitCpu') is not None:
            self.unit_cpu = m.get('UnitCpu')
        if m.get('UsedCpu') is not None:
            self.used_cpu = m.get('UsedCpu')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResourceDiskSize(TeaModel):
    def __init__(
        self,
        data_used_size: float = None,
        max_disk_size: float = None,
        max_disk_used_ob_server: List[str] = None,
        max_disk_used_percent: float = None,
        original_total_disk_size: int = None,
        total_disk_size: int = None,
        unit_disk_size: int = None,
        used_disk_size: int = None,
    ):
        # The size of the data disk, in GB.
        self.data_used_size = data_used_size
        # The maximum disk size that can be created.
        self.max_disk_size = max_disk_size
        # The maximum disk usage of the OBServer node.
        self.max_disk_used_ob_server = max_disk_used_ob_server
        # The maximum disk usage, in percentage.
        self.max_disk_used_percent = max_disk_used_percent
        # The original size of the disk.
        self.original_total_disk_size = original_total_disk_size
        # The total storage space of the cluster, in GB.
        self.total_disk_size = total_disk_size
        # The storage space of each replica node in the cluster, in GB.
        self.unit_disk_size = unit_disk_size
        # The size of used storage space of the cluster, in GB.
        self.used_disk_size = used_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_used_size is not None:
            result['DataUsedSize'] = self.data_used_size
        if self.max_disk_size is not None:
            result['MaxDiskSize'] = self.max_disk_size
        if self.max_disk_used_ob_server is not None:
            result['MaxDiskUsedObServer'] = self.max_disk_used_ob_server
        if self.max_disk_used_percent is not None:
            result['MaxDiskUsedPercent'] = self.max_disk_used_percent
        if self.original_total_disk_size is not None:
            result['OriginalTotalDiskSize'] = self.original_total_disk_size
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.unit_disk_size is not None:
            result['UnitDiskSize'] = self.unit_disk_size
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataUsedSize') is not None:
            self.data_used_size = m.get('DataUsedSize')
        if m.get('MaxDiskSize') is not None:
            self.max_disk_size = m.get('MaxDiskSize')
        if m.get('MaxDiskUsedObServer') is not None:
            self.max_disk_used_ob_server = m.get('MaxDiskUsedObServer')
        if m.get('MaxDiskUsedPercent') is not None:
            self.max_disk_used_percent = m.get('MaxDiskUsedPercent')
        if m.get('OriginalTotalDiskSize') is not None:
            self.original_total_disk_size = m.get('OriginalTotalDiskSize')
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UnitDiskSize') is not None:
            self.unit_disk_size = m.get('UnitDiskSize')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResourceLogDiskSize(TeaModel):
    def __init__(
        self,
        log_assigned_size: str = None,
        max_log_assigned_ob_server: List[str] = None,
        max_log_assigned_percent: str = None,
        total_disk_size: int = None,
        unit_disk_size: int = None,
    ):
        # The allocated disk space for log storage, in GB.
        self.log_assigned_size = log_assigned_size
        # The maximum storage space allocated for.
        self.max_log_assigned_ob_server = max_log_assigned_ob_server
        # The maximum percentage of space allocated for log storage.
        self.max_log_assigned_percent = max_log_assigned_percent
        # The information about the log disk space of the cluster.
        self.total_disk_size = total_disk_size
        # The log disk space of each replica node in the cluster, in GB.
        self.unit_disk_size = unit_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_assigned_size is not None:
            result['LogAssignedSize'] = self.log_assigned_size
        if self.max_log_assigned_ob_server is not None:
            result['MaxLogAssignedObServer'] = self.max_log_assigned_ob_server
        if self.max_log_assigned_percent is not None:
            result['MaxLogAssignedPercent'] = self.max_log_assigned_percent
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.unit_disk_size is not None:
            result['UnitDiskSize'] = self.unit_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogAssignedSize') is not None:
            self.log_assigned_size = m.get('LogAssignedSize')
        if m.get('MaxLogAssignedObServer') is not None:
            self.max_log_assigned_ob_server = m.get('MaxLogAssignedObServer')
        if m.get('MaxLogAssignedPercent') is not None:
            self.max_log_assigned_percent = m.get('MaxLogAssignedPercent')
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UnitDiskSize') is not None:
            self.unit_disk_size = m.get('UnitDiskSize')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResourceMemory(TeaModel):
    def __init__(
        self,
        original_total_memory: int = None,
        total_memory: int = None,
        unit_memory: int = None,
        used_memory: int = None,
    ):
        # The original memory size of the cluster.
        self.original_total_memory = original_total_memory
        # The total memory size of the cluster, in GB.
        self.total_memory = total_memory
        # The memory size of each replica node in the cluster, in GB.
        self.unit_memory = unit_memory
        # The size of memory used by the cluster, in GB.
        self.used_memory = used_memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_memory is not None:
            result['OriginalTotalMemory'] = self.original_total_memory
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.unit_memory is not None:
            result['UnitMemory'] = self.unit_memory
        if self.used_memory is not None:
            result['UsedMemory'] = self.used_memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalMemory') is not None:
            self.original_total_memory = m.get('OriginalTotalMemory')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('UnitMemory') is not None:
            self.unit_memory = m.get('UnitMemory')
        if m.get('UsedMemory') is not None:
            self.used_memory = m.get('UsedMemory')
        return self


class DescribeInstanceResponseBodyInstanceReadOnlyResource(TeaModel):
    def __init__(
        self,
        capacity_unit: DescribeInstanceResponseBodyInstanceReadOnlyResourceCapacityUnit = None,
        cpu: DescribeInstanceResponseBodyInstanceReadOnlyResourceCpu = None,
        disk_size: DescribeInstanceResponseBodyInstanceReadOnlyResourceDiskSize = None,
        log_disk_size: DescribeInstanceResponseBodyInstanceReadOnlyResourceLogDiskSize = None,
        memory: DescribeInstanceResponseBodyInstanceReadOnlyResourceMemory = None,
        unit_count: int = None,
    ):
        # The information about capacity units.
        self.capacity_unit = capacity_unit
        # The information about the CPU resources of the cluster.
        self.cpu = cpu
        # The information about the storage resources of the cluster.
        self.disk_size = disk_size
        # The information about the log disk space of the cluster.
        self.log_disk_size = log_disk_size
        # The information about the memory resources of the cluster.
        self.memory = memory
        # The number of resource units in the cluster.
        self.unit_count = unit_count

    def validate(self):
        if self.capacity_unit:
            self.capacity_unit.validate()
        if self.cpu:
            self.cpu.validate()
        if self.disk_size:
            self.disk_size.validate()
        if self.log_disk_size:
            self.log_disk_size.validate()
        if self.memory:
            self.memory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit.to_map()
        if self.cpu is not None:
            result['Cpu'] = self.cpu.to_map()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        if self.log_disk_size is not None:
            result['LogDiskSize'] = self.log_disk_size.to_map()
        if self.memory is not None:
            result['Memory'] = self.memory.to_map()
        if self.unit_count is not None:
            result['UnitCount'] = self.unit_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResourceCapacityUnit()
            self.capacity_unit = temp_model.from_map(m['CapacityUnit'])
        if m.get('Cpu') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResourceCpu()
            self.cpu = temp_model.from_map(m['Cpu'])
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        if m.get('LogDiskSize') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResourceLogDiskSize()
            self.log_disk_size = temp_model.from_map(m['LogDiskSize'])
        if m.get('Memory') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResourceMemory()
            self.memory = temp_model.from_map(m['Memory'])
        if m.get('UnitCount') is not None:
            self.unit_count = m.get('UnitCount')
        return self


class DescribeInstanceResponseBodyInstanceResourceCapacityUnit(TeaModel):
    def __init__(
        self,
        max_capacity_unit: int = None,
        min_capacity_unit: int = None,
        used_capacity_unit: str = None,
    ):
        # The maximum number of capacity units.
        self.max_capacity_unit = max_capacity_unit
        # The minimum number of capacity units.
        self.min_capacity_unit = min_capacity_unit
        # The number of used capacity units.
        self.used_capacity_unit = used_capacity_unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_capacity_unit is not None:
            result['MaxCapacityUnit'] = self.max_capacity_unit
        if self.min_capacity_unit is not None:
            result['MinCapacityUnit'] = self.min_capacity_unit
        if self.used_capacity_unit is not None:
            result['UsedCapacityUnit'] = self.used_capacity_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxCapacityUnit') is not None:
            self.max_capacity_unit = m.get('MaxCapacityUnit')
        if m.get('MinCapacityUnit') is not None:
            self.min_capacity_unit = m.get('MinCapacityUnit')
        if m.get('UsedCapacityUnit') is not None:
            self.used_capacity_unit = m.get('UsedCapacityUnit')
        return self


class DescribeInstanceResponseBodyInstanceResourceCpu(TeaModel):
    def __init__(
        self,
        original_total_cpu: int = None,
        total_cpu: int = None,
        unit_cpu: int = None,
        used_cpu: int = None,
    ):
        # The number of original CPU cores in the cluster.
        self.original_total_cpu = original_total_cpu
        # The total number of CPU cores of the cluster.
        self.total_cpu = total_cpu
        # The number of CPU cores of each replica node in the cluster.
        self.unit_cpu = unit_cpu
        # The number of CPU cores used in the cluster.
        self.used_cpu = used_cpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_cpu is not None:
            result['OriginalTotalCpu'] = self.original_total_cpu
        if self.total_cpu is not None:
            result['TotalCpu'] = self.total_cpu
        if self.unit_cpu is not None:
            result['UnitCpu'] = self.unit_cpu
        if self.used_cpu is not None:
            result['UsedCpu'] = self.used_cpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalCpu') is not None:
            self.original_total_cpu = m.get('OriginalTotalCpu')
        if m.get('TotalCpu') is not None:
            self.total_cpu = m.get('TotalCpu')
        if m.get('UnitCpu') is not None:
            self.unit_cpu = m.get('UnitCpu')
        if m.get('UsedCpu') is not None:
            self.used_cpu = m.get('UsedCpu')
        return self


class DescribeInstanceResponseBodyInstanceResourceDiskSize(TeaModel):
    def __init__(
        self,
        data_used_size: float = None,
        max_disk_size: float = None,
        max_disk_used_ob_server: List[str] = None,
        max_disk_used_percent: float = None,
        original_total_disk_size: int = None,
        total_disk_size: int = None,
        unit_disk_size: int = None,
        used_disk_size: int = None,
    ):
        # The size of the data disk, in GB.
        self.data_used_size = data_used_size
        # The maximum disk size that can be created.
        self.max_disk_size = max_disk_size
        # The maximum disk usage of the OBServer node.
        self.max_disk_used_ob_server = max_disk_used_ob_server
        # The maximum disk usage, in percentage.
        self.max_disk_used_percent = max_disk_used_percent
        # The original size of the disk.
        self.original_total_disk_size = original_total_disk_size
        # The total storage space of the cluster, in GB.
        self.total_disk_size = total_disk_size
        # The storage space of each replica node in the cluster, in GB.
        self.unit_disk_size = unit_disk_size
        # The size of used storage space of the cluster, in GB.
        self.used_disk_size = used_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_used_size is not None:
            result['DataUsedSize'] = self.data_used_size
        if self.max_disk_size is not None:
            result['MaxDiskSize'] = self.max_disk_size
        if self.max_disk_used_ob_server is not None:
            result['MaxDiskUsedObServer'] = self.max_disk_used_ob_server
        if self.max_disk_used_percent is not None:
            result['MaxDiskUsedPercent'] = self.max_disk_used_percent
        if self.original_total_disk_size is not None:
            result['OriginalTotalDiskSize'] = self.original_total_disk_size
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.unit_disk_size is not None:
            result['UnitDiskSize'] = self.unit_disk_size
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataUsedSize') is not None:
            self.data_used_size = m.get('DataUsedSize')
        if m.get('MaxDiskSize') is not None:
            self.max_disk_size = m.get('MaxDiskSize')
        if m.get('MaxDiskUsedObServer') is not None:
            self.max_disk_used_ob_server = m.get('MaxDiskUsedObServer')
        if m.get('MaxDiskUsedPercent') is not None:
            self.max_disk_used_percent = m.get('MaxDiskUsedPercent')
        if m.get('OriginalTotalDiskSize') is not None:
            self.original_total_disk_size = m.get('OriginalTotalDiskSize')
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UnitDiskSize') is not None:
            self.unit_disk_size = m.get('UnitDiskSize')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        return self


class DescribeInstanceResponseBodyInstanceResourceLogDiskSize(TeaModel):
    def __init__(
        self,
        log_assigned_size: str = None,
        max_log_assigned_ob_server: List[str] = None,
        max_log_assigned_percent: str = None,
        original_total_disk_size: int = None,
        total_disk_size: int = None,
        unit_disk_size: int = None,
    ):
        # The allocated disk space for log storage, in GB.
        self.log_assigned_size = log_assigned_size
        # The maximum storage space allocated for.
        self.max_log_assigned_ob_server = max_log_assigned_ob_server
        # The maximum percentage of space allocated for log storage.
        self.max_log_assigned_percent = max_log_assigned_percent
        # The original size of the disk.
        self.original_total_disk_size = original_total_disk_size
        # The total log disk space of the cluster, in GB.
        self.total_disk_size = total_disk_size
        # The log disk space of each replica node in the cluster. Unit: GB.
        self.unit_disk_size = unit_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_assigned_size is not None:
            result['LogAssignedSize'] = self.log_assigned_size
        if self.max_log_assigned_ob_server is not None:
            result['MaxLogAssignedObServer'] = self.max_log_assigned_ob_server
        if self.max_log_assigned_percent is not None:
            result['MaxLogAssignedPercent'] = self.max_log_assigned_percent
        if self.original_total_disk_size is not None:
            result['OriginalTotalDiskSize'] = self.original_total_disk_size
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.unit_disk_size is not None:
            result['UnitDiskSize'] = self.unit_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogAssignedSize') is not None:
            self.log_assigned_size = m.get('LogAssignedSize')
        if m.get('MaxLogAssignedObServer') is not None:
            self.max_log_assigned_ob_server = m.get('MaxLogAssignedObServer')
        if m.get('MaxLogAssignedPercent') is not None:
            self.max_log_assigned_percent = m.get('MaxLogAssignedPercent')
        if m.get('OriginalTotalDiskSize') is not None:
            self.original_total_disk_size = m.get('OriginalTotalDiskSize')
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UnitDiskSize') is not None:
            self.unit_disk_size = m.get('UnitDiskSize')
        return self


class DescribeInstanceResponseBodyInstanceResourceMemory(TeaModel):
    def __init__(
        self,
        original_total_memory: int = None,
        total_memory: int = None,
        unit_memory: int = None,
        used_memory: int = None,
    ):
        # The original memory size of the cluster, in GB.
        self.original_total_memory = original_total_memory
        # The total memory size of the cluster, in GB.
        self.total_memory = total_memory
        # The memory size of each replica node in the cluster, in GB.
        self.unit_memory = unit_memory
        # The size of used memory in the cluster, in GB.
        self.used_memory = used_memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_memory is not None:
            result['OriginalTotalMemory'] = self.original_total_memory
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.unit_memory is not None:
            result['UnitMemory'] = self.unit_memory
        if self.used_memory is not None:
            result['UsedMemory'] = self.used_memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalMemory') is not None:
            self.original_total_memory = m.get('OriginalTotalMemory')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('UnitMemory') is not None:
            self.unit_memory = m.get('UnitMemory')
        if m.get('UsedMemory') is not None:
            self.used_memory = m.get('UsedMemory')
        return self


class DescribeInstanceResponseBodyInstanceResource(TeaModel):
    def __init__(
        self,
        capacity_unit: DescribeInstanceResponseBodyInstanceResourceCapacityUnit = None,
        cpu: DescribeInstanceResponseBodyInstanceResourceCpu = None,
        disk_size: DescribeInstanceResponseBodyInstanceResourceDiskSize = None,
        log_disk_size: DescribeInstanceResponseBodyInstanceResourceLogDiskSize = None,
        memory: DescribeInstanceResponseBodyInstanceResourceMemory = None,
        unit_count: int = None,
    ):
        # The information about capacity units.
        self.capacity_unit = capacity_unit
        # The information about the CPU resources of the cluster.
        self.cpu = cpu
        # The information about the storage resources of the cluster.
        self.disk_size = disk_size
        # The information about the log disk space of the cluster.
        self.log_disk_size = log_disk_size
        # The information about the memory resources of the cluster.
        self.memory = memory
        # The number of resource units in the cluster.
        self.unit_count = unit_count

    def validate(self):
        if self.capacity_unit:
            self.capacity_unit.validate()
        if self.cpu:
            self.cpu.validate()
        if self.disk_size:
            self.disk_size.validate()
        if self.log_disk_size:
            self.log_disk_size.validate()
        if self.memory:
            self.memory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit.to_map()
        if self.cpu is not None:
            result['Cpu'] = self.cpu.to_map()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        if self.log_disk_size is not None:
            result['LogDiskSize'] = self.log_disk_size.to_map()
        if self.memory is not None:
            result['Memory'] = self.memory.to_map()
        if self.unit_count is not None:
            result['UnitCount'] = self.unit_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResourceCapacityUnit()
            self.capacity_unit = temp_model.from_map(m['CapacityUnit'])
        if m.get('Cpu') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResourceCpu()
            self.cpu = temp_model.from_map(m['Cpu'])
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        if m.get('LogDiskSize') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResourceLogDiskSize()
            self.log_disk_size = temp_model.from_map(m['LogDiskSize'])
        if m.get('Memory') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResourceMemory()
            self.memory = temp_model.from_map(m['Memory'])
        if m.get('UnitCount') is not None:
            self.unit_count = m.get('UnitCount')
        return self


class DescribeInstanceResponseBodyInstanceTenantCreatable(TeaModel):
    def __init__(
        self,
        disable_create_tenant_reason: str = None,
        enable_create_tenant: bool = None,
    ):
        # The reason why you cannot create a tenant in the cluster.
        self.disable_create_tenant_reason = disable_create_tenant_reason
        # Specifies whether a tenant can be created.
        self.enable_create_tenant = enable_create_tenant

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_create_tenant_reason is not None:
            result['DisableCreateTenantReason'] = self.disable_create_tenant_reason
        if self.enable_create_tenant is not None:
            result['EnableCreateTenant'] = self.enable_create_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisableCreateTenantReason') is not None:
            self.disable_create_tenant_reason = m.get('DisableCreateTenantReason')
        if m.get('EnableCreateTenant') is not None:
            self.enable_create_tenant = m.get('EnableCreateTenant')
        return self


class DescribeInstanceResponseBodyInstance(TeaModel):
    def __init__(
        self,
        allow_create_proxy_sql_firewall_rule: bool = None,
        allow_modify_internet_address_connection_limit: bool = None,
        auto_renewal: bool = None,
        auto_upgrade_ob_version: bool = None,
        available_zones: List[str] = None,
        cpu_architecture: str = None,
        create_time: str = None,
        data_disk_auto_scale: bool = None,
        data_disk_auto_scale_config: DescribeInstanceResponseBodyInstanceDataDiskAutoScaleConfig = None,
        data_merge_time: str = None,
        deploy_mode: str = None,
        deploy_type: str = None,
        disk_type: str = None,
        enable_isolation_optimization: bool = None,
        enable_proxy_service: bool = None,
        enable_read_only_replica: bool = None,
        enable_read_only_replica_management: bool = None,
        enable_upgrade_log_disk: bool = None,
        exclusive_unit_num_limit: int = None,
        expire_time: str = None,
        in_temp_capacity_status: bool = None,
        instance_class: str = None,
        instance_id: str = None,
        instance_name: str = None,
        instance_role: str = None,
        iops: int = None,
        is_latest_ob_version: bool = None,
        is_trust_ecs: bool = None,
        isolation_optimization: bool = None,
        maintain_time: str = None,
        node_num: str = None,
        ob_rpm_version: str = None,
        pay_type: str = None,
        primary_instance: str = None,
        primary_region: str = None,
        proxy_cluster_id: str = None,
        proxy_service_status: str = None,
        read_only_resource: DescribeInstanceResponseBodyInstanceReadOnlyResource = None,
        replica_mode: str = None,
        resource: DescribeInstanceResponseBodyInstanceResource = None,
        series: str = None,
        shared_unit_num_limit: int = None,
        spec_type: str = None,
        status: str = None,
        tenant_creatable: DescribeInstanceResponseBodyInstanceTenantCreatable = None,
        unit_spec: str = None,
        version: str = None,
        zones: List[str] = None,
    ):
        # Indicates whether the OceanBase Database Proxy (ODP) SQL firewall is supported.
        self.allow_create_proxy_sql_firewall_rule = allow_create_proxy_sql_firewall_rule
        # Indicates whether the maximum number of public connections can be modified.
        self.allow_modify_internet_address_connection_limit = allow_modify_internet_address_connection_limit
        # Indicates whether automatic renewal is enabled. 
        # 
        # This parameter is valid only for clusters whose billing methods are set to PREPAY.
        self.auto_renewal = auto_renewal
        # Indicates whether automatic upgrade of the OBServer version is enabled.
        self.auto_upgrade_ob_version = auto_upgrade_ob_version
        # The list of zones.
        self.available_zones = available_zones
        # The CPU architecture of the cluster.
        self.cpu_architecture = cpu_architecture
        # The time in UTC when the cluster was created.
        self.create_time = create_time
        # Specifies whether to enable automatic scaling of the data disk.
        # > <br>This parameter is deprecated.
        self.data_disk_auto_scale = data_disk_auto_scale
        # Specifies parameters for the automatic scaling of the data disk.
        self.data_disk_auto_scale_config = data_disk_auto_scale_config
        # The time when the major compaction of cluster data is performed.
        self.data_merge_time = data_merge_time
        # The data replica distribution mode of the cluster. Valid values: 
        # - n: indicates the single-IDC mode. 
        # - n-n: indicates the dual-IDC mode. 
        # - n-n-n: indicates the multi-IDC mode. 
        # 
        # > <br>The integer n represents the number of OBServer nodes in each IDC.
        self.deploy_mode = deploy_mode
        # The deployment type of the cluster. Valid values:  
        # - multiple: multi-IDC deployment   
        # - single: single-IDC deployment   
        # - dual: dual-IDC deployment
        self.deploy_type = deploy_type
        # The type of the storage disk where the cluster is deployed. 
        # 
        # The default value is cloud_essd_pl1, which indicates an ESSD cloud disk.
        self.disk_type = disk_type
        # Specifies whether to enable isolation optimization.
        self.enable_isolation_optimization = enable_isolation_optimization
        # Specifies whether to enable the proxy service.
        # - true
        # - false
        self.enable_proxy_service = enable_proxy_service
        # Indicates whether read-only replicas are supported.
        self.enable_read_only_replica = enable_read_only_replica
        # Indicates whether read-only replicas can be purchased for the cluster.
        self.enable_read_only_replica_management = enable_read_only_replica_management
        # Indicates whether the log disk specifications can be upgraded.
        self.enable_upgrade_log_disk = enable_upgrade_log_disk
        # The maximum number of units of the proxy service in exclusive mode.
        self.exclusive_unit_num_limit = exclusive_unit_num_limit
        # The time in UTC when the cluster expires.
        self.expire_time = expire_time
        # Specifies whether to indicate the temporary status of the capacity.
        self.in_temp_capacity_status = in_temp_capacity_status
        # The specifications of the cluster.  You can specify one of the following four plans:    
        # - 8C32G: indicates 8 CPU cores and 32 GB of memory. 
        # - 14C70G: indicates 14 CPU cores and 70 GB of memory. 
        # - 30C180G: indicates 30 CPU cores and 180 GB of memory. 
        # - 62C400G: indicates 62 CPU cores and 400 GB of memory.
        self.instance_class = instance_class
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The name of the OceanBase cluster.
        self.instance_name = instance_name
        # The role of the instance.
        self.instance_role = instance_role
        self.iops = iops
        # Indicates whether the OBServer version is the latest.
        self.is_latest_ob_version = is_latest_ob_version
        # Indicates whether trusted ECS instances are used.
        self.is_trust_ecs = is_trust_ecs
        # Specifies whether to enable the control group feature.
        self.isolation_optimization = isolation_optimization
        # The period in UTC for the daily routine maintenance of the cluster.
        self.maintain_time = maintain_time
        # The number of nodes in the cluster. If the cluster is deployed in n-n-n mode, the number of nodes in the cluster equals n × 3.
        self.node_num = node_num
        # The detailed information of the OBServer version.
        self.ob_rpm_version = ob_rpm_version
        # The billing method of the OceanBase cluster. Valid values: 
        # - PREPAY: the subscription billing method. 
        # - POSTPAY: the pay-as-you-go billing method.
        self.pay_type = pay_type
        # The ID of the primary cluster.
        self.primary_instance = primary_instance
        # The region of the primary cluster.
        self.primary_region = primary_region
        # The ID of the proxy cluster.
        # > This parameter returns a value only if you set the **EnableProxyService** parameter to true.
        self.proxy_cluster_id = proxy_cluster_id
        # The status of the proxy service.
        self.proxy_service_status = proxy_service_status
        # The information about cluster resources.
        self.read_only_resource = read_only_resource
        # The number of full-featured replicas. Return value: 3 or 2.
        # - 3: three full-featured replicas.
        # - 2: two full-featured replicas.
        # 
        # An OceanBase cluster deployed in three-zone mode supports only three full-featured replicas. An OceanBase cluster deployed in two-zone mode supports only two full-featured replicas. An OceanBase cluster deployed in one single zone supports two or three full-featured replicas.
        self.replica_mode = replica_mode
        # The information about cluster resources.
        self.resource = resource
        # The series of the instance. Valid values:
        # 
        # - normal: Standard Cluster Edition (Cloud Disk). This is the default value.
        # 
        # - normal_ssd: Standard Cluster Edition (Local Disk)
        # 
        # - history: History Database Cluster Edition
        self.series = series
        # The maximum number of units of the proxy service in shared mode.
        self.shared_unit_num_limit = shared_unit_num_limit
        # The specification type.
        self.spec_type = spec_type
        # The status of the cluster. Valid values: 
        #  - PENDING_CREATE: The cluster is being created. 
        #  - ONLINE: The cluster is running. 
        #  - TENANT_CREATING: The tenant is being created. 
        # - TENANT_SPEC_MODIFYING: The tenant specifications are being modified. 
        # - EXPANDING: Nodes are being added to the cluster to increase its capacity. 
        # - REDUCING: Nodes are being removed from the cluster to reduce its capacity. 
        # - SPEC_UPGRADING: The service plan is being upgraded. 
        # - DISK_UPGRADING: The storage space is being expanded. 
        # - WHITE_LIST_MODIFYING: The whitelist is being modified. 
        # - PARAMETER_MODIFYING: Parameters are being modified. 
        # - SSL_MODIFYING: The SSL certificate is being changed. 
        # - PREPAID_EXPIRE_CLOSED: The payment is overdue. This parameter is valid for a cluster whose billing method is set to PREPAY. 
        # - ARREARS_CLOSED: The payment is overdue. This parameter is valid for a cluster whose billing method is set to POSTPAY. 
        # - PENDING_DELETE: The cluster is being deleted.    
        # Generally, the cluster is in the ONLINE state.
        self.status = status
        # Specifies whether a tenant can be created.
        self.tenant_creatable = tenant_creatable
        # The unit specification of the proxy service.
        self.unit_spec = unit_spec
        # The version of OceanBase Database.
        self.version = version
        # The ID of the zone to which the instance belongs.
        # <props="intl">For more information about how to obtain the list of zones, see [DescribeZones](https://www.alibabacloud.com/help/en/apsaradb-for-oceanbase/latest/api-oceanbasepro-2019-09-01-describezones).
        self.zones = zones

    def validate(self):
        if self.data_disk_auto_scale_config:
            self.data_disk_auto_scale_config.validate()
        if self.read_only_resource:
            self.read_only_resource.validate()
        if self.resource:
            self.resource.validate()
        if self.tenant_creatable:
            self.tenant_creatable.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_create_proxy_sql_firewall_rule is not None:
            result['AllowCreateProxySqlFirewallRule'] = self.allow_create_proxy_sql_firewall_rule
        if self.allow_modify_internet_address_connection_limit is not None:
            result['AllowModifyInternetAddressConnectionLimit'] = self.allow_modify_internet_address_connection_limit
        if self.auto_renewal is not None:
            result['AutoRenewal'] = self.auto_renewal
        if self.auto_upgrade_ob_version is not None:
            result['AutoUpgradeObVersion'] = self.auto_upgrade_ob_version
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones
        if self.cpu_architecture is not None:
            result['CpuArchitecture'] = self.cpu_architecture
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_disk_auto_scale is not None:
            result['DataDiskAutoScale'] = self.data_disk_auto_scale
        if self.data_disk_auto_scale_config is not None:
            result['DataDiskAutoScaleConfig'] = self.data_disk_auto_scale_config.to_map()
        if self.data_merge_time is not None:
            result['DataMergeTime'] = self.data_merge_time
        if self.deploy_mode is not None:
            result['DeployMode'] = self.deploy_mode
        if self.deploy_type is not None:
            result['DeployType'] = self.deploy_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.enable_isolation_optimization is not None:
            result['EnableIsolationOptimization'] = self.enable_isolation_optimization
        if self.enable_proxy_service is not None:
            result['EnableProxyService'] = self.enable_proxy_service
        if self.enable_read_only_replica is not None:
            result['EnableReadOnlyReplica'] = self.enable_read_only_replica
        if self.enable_read_only_replica_management is not None:
            result['EnableReadOnlyReplicaManagement'] = self.enable_read_only_replica_management
        if self.enable_upgrade_log_disk is not None:
            result['EnableUpgradeLogDisk'] = self.enable_upgrade_log_disk
        if self.exclusive_unit_num_limit is not None:
            result['ExclusiveUnitNumLimit'] = self.exclusive_unit_num_limit
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.in_temp_capacity_status is not None:
            result['InTempCapacityStatus'] = self.in_temp_capacity_status
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_role is not None:
            result['InstanceRole'] = self.instance_role
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.is_latest_ob_version is not None:
            result['IsLatestObVersion'] = self.is_latest_ob_version
        if self.is_trust_ecs is not None:
            result['IsTrustEcs'] = self.is_trust_ecs
        if self.isolation_optimization is not None:
            result['IsolationOptimization'] = self.isolation_optimization
        if self.maintain_time is not None:
            result['MaintainTime'] = self.maintain_time
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.ob_rpm_version is not None:
            result['ObRpmVersion'] = self.ob_rpm_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.primary_instance is not None:
            result['PrimaryInstance'] = self.primary_instance
        if self.primary_region is not None:
            result['PrimaryRegion'] = self.primary_region
        if self.proxy_cluster_id is not None:
            result['ProxyClusterId'] = self.proxy_cluster_id
        if self.proxy_service_status is not None:
            result['ProxyServiceStatus'] = self.proxy_service_status
        if self.read_only_resource is not None:
            result['ReadOnlyResource'] = self.read_only_resource.to_map()
        if self.replica_mode is not None:
            result['ReplicaMode'] = self.replica_mode
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.series is not None:
            result['Series'] = self.series
        if self.shared_unit_num_limit is not None:
            result['SharedUnitNumLimit'] = self.shared_unit_num_limit
        if self.spec_type is not None:
            result['SpecType'] = self.spec_type
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_creatable is not None:
            result['TenantCreatable'] = self.tenant_creatable.to_map()
        if self.unit_spec is not None:
            result['UnitSpec'] = self.unit_spec
        if self.version is not None:
            result['Version'] = self.version
        if self.zones is not None:
            result['Zones'] = self.zones
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowCreateProxySqlFirewallRule') is not None:
            self.allow_create_proxy_sql_firewall_rule = m.get('AllowCreateProxySqlFirewallRule')
        if m.get('AllowModifyInternetAddressConnectionLimit') is not None:
            self.allow_modify_internet_address_connection_limit = m.get('AllowModifyInternetAddressConnectionLimit')
        if m.get('AutoRenewal') is not None:
            self.auto_renewal = m.get('AutoRenewal')
        if m.get('AutoUpgradeObVersion') is not None:
            self.auto_upgrade_ob_version = m.get('AutoUpgradeObVersion')
        if m.get('AvailableZones') is not None:
            self.available_zones = m.get('AvailableZones')
        if m.get('CpuArchitecture') is not None:
            self.cpu_architecture = m.get('CpuArchitecture')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataDiskAutoScale') is not None:
            self.data_disk_auto_scale = m.get('DataDiskAutoScale')
        if m.get('DataDiskAutoScaleConfig') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceDataDiskAutoScaleConfig()
            self.data_disk_auto_scale_config = temp_model.from_map(m['DataDiskAutoScaleConfig'])
        if m.get('DataMergeTime') is not None:
            self.data_merge_time = m.get('DataMergeTime')
        if m.get('DeployMode') is not None:
            self.deploy_mode = m.get('DeployMode')
        if m.get('DeployType') is not None:
            self.deploy_type = m.get('DeployType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EnableIsolationOptimization') is not None:
            self.enable_isolation_optimization = m.get('EnableIsolationOptimization')
        if m.get('EnableProxyService') is not None:
            self.enable_proxy_service = m.get('EnableProxyService')
        if m.get('EnableReadOnlyReplica') is not None:
            self.enable_read_only_replica = m.get('EnableReadOnlyReplica')
        if m.get('EnableReadOnlyReplicaManagement') is not None:
            self.enable_read_only_replica_management = m.get('EnableReadOnlyReplicaManagement')
        if m.get('EnableUpgradeLogDisk') is not None:
            self.enable_upgrade_log_disk = m.get('EnableUpgradeLogDisk')
        if m.get('ExclusiveUnitNumLimit') is not None:
            self.exclusive_unit_num_limit = m.get('ExclusiveUnitNumLimit')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InTempCapacityStatus') is not None:
            self.in_temp_capacity_status = m.get('InTempCapacityStatus')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceRole') is not None:
            self.instance_role = m.get('InstanceRole')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('IsLatestObVersion') is not None:
            self.is_latest_ob_version = m.get('IsLatestObVersion')
        if m.get('IsTrustEcs') is not None:
            self.is_trust_ecs = m.get('IsTrustEcs')
        if m.get('IsolationOptimization') is not None:
            self.isolation_optimization = m.get('IsolationOptimization')
        if m.get('MaintainTime') is not None:
            self.maintain_time = m.get('MaintainTime')
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('ObRpmVersion') is not None:
            self.ob_rpm_version = m.get('ObRpmVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PrimaryInstance') is not None:
            self.primary_instance = m.get('PrimaryInstance')
        if m.get('PrimaryRegion') is not None:
            self.primary_region = m.get('PrimaryRegion')
        if m.get('ProxyClusterId') is not None:
            self.proxy_cluster_id = m.get('ProxyClusterId')
        if m.get('ProxyServiceStatus') is not None:
            self.proxy_service_status = m.get('ProxyServiceStatus')
        if m.get('ReadOnlyResource') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceReadOnlyResource()
            self.read_only_resource = temp_model.from_map(m['ReadOnlyResource'])
        if m.get('ReplicaMode') is not None:
            self.replica_mode = m.get('ReplicaMode')
        if m.get('Resource') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Series') is not None:
            self.series = m.get('Series')
        if m.get('SharedUnitNumLimit') is not None:
            self.shared_unit_num_limit = m.get('SharedUnitNumLimit')
        if m.get('SpecType') is not None:
            self.spec_type = m.get('SpecType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantCreatable') is not None:
            temp_model = DescribeInstanceResponseBodyInstanceTenantCreatable()
            self.tenant_creatable = temp_model.from_map(m['TenantCreatable'])
        if m.get('UnitSpec') is not None:
            self.unit_spec = m.get('UnitSpec')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('Zones') is not None:
            self.zones = m.get('Zones')
        return self


class DescribeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        instance: DescribeInstanceResponseBodyInstance = None,
        request_id: str = None,
    ):
        # The information of the OceanBase cluster.
        self.instance = instance
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instance') is not None:
            temp_model = DescribeInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAvailableZonesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceAvailableZonesResponseBodyZoneList(TeaModel):
    def __init__(
        self,
        is_in_cluster: bool = None,
        logical_zone_name: str = None,
        replicate_zone_index: str = None,
        zone: str = None,
    ):
        self.is_in_cluster = is_in_cluster
        self.logical_zone_name = logical_zone_name
        self.replicate_zone_index = replicate_zone_index
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_in_cluster is not None:
            result['IsInCluster'] = self.is_in_cluster
        if self.logical_zone_name is not None:
            result['LogicalZoneName'] = self.logical_zone_name
        if self.replicate_zone_index is not None:
            result['ReplicateZoneIndex'] = self.replicate_zone_index
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsInCluster') is not None:
            self.is_in_cluster = m.get('IsInCluster')
        if m.get('LogicalZoneName') is not None:
            self.logical_zone_name = m.get('LogicalZoneName')
        if m.get('ReplicateZoneIndex') is not None:
            self.replicate_zone_index = m.get('ReplicateZoneIndex')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeInstanceAvailableZonesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zone_list: List[DescribeInstanceAvailableZonesResponseBodyZoneList] = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.zone_list = zone_list

    def validate(self):
        if self.zone_list:
            for k in self.zone_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ZoneList'] = []
        if self.zone_list is not None:
            for k in self.zone_list:
                result['ZoneList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.zone_list = []
        if m.get('ZoneList') is not None:
            for k in m.get('ZoneList'):
                temp_model = DescribeInstanceAvailableZonesResponseBodyZoneList()
                self.zone_list.append(temp_model.from_map(k))
        return self


class DescribeInstanceAvailableZonesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceAvailableZonesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAvailableZonesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceCreatableZoneRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the zone.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceCreatableZoneResponseBodyZoneList(TeaModel):
    def __init__(
        self,
        full_copy_id: str = None,
        is_in_cluster: bool = None,
        logical_zone_name: str = None,
        replicate_zone_index: int = None,
        zone: str = None,
    ):
        self.full_copy_id = full_copy_id
        self.is_in_cluster = is_in_cluster
        self.logical_zone_name = logical_zone_name
        self.replicate_zone_index = replicate_zone_index
        # DescribeInstanceCreatableZone
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_copy_id is not None:
            result['FullCopyId'] = self.full_copy_id
        if self.is_in_cluster is not None:
            result['IsInCluster'] = self.is_in_cluster
        if self.logical_zone_name is not None:
            result['LogicalZoneName'] = self.logical_zone_name
        if self.replicate_zone_index is not None:
            result['ReplicateZoneIndex'] = self.replicate_zone_index
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullCopyId') is not None:
            self.full_copy_id = m.get('FullCopyId')
        if m.get('IsInCluster') is not None:
            self.is_in_cluster = m.get('IsInCluster')
        if m.get('LogicalZoneName') is not None:
            self.logical_zone_name = m.get('LogicalZoneName')
        if m.get('ReplicateZoneIndex') is not None:
            self.replicate_zone_index = m.get('ReplicateZoneIndex')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeInstanceCreatableZoneResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zone_list: List[DescribeInstanceCreatableZoneResponseBodyZoneList] = None,
    ):
        # Indicates whether the cluster is deployed in the zone.
        self.request_id = request_id
        # The operation that you want to perform.   
        # Set the value to **DescribeInstanceCreatableZone**.
        self.zone_list = zone_list

    def validate(self):
        if self.zone_list:
            for k in self.zone_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ZoneList'] = []
        if self.zone_list is not None:
            for k in self.zone_list:
                result['ZoneList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.zone_list = []
        if m.get('ZoneList') is not None:
            for k in m.get('ZoneList'):
                temp_model = DescribeInstanceCreatableZoneResponseBodyZoneList()
                self.zone_list.append(temp_model.from_map(k))
        return self


class DescribeInstanceCreatableZoneResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceCreatableZoneResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceCreatableZoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSSLRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        tenant_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeInstanceSSLResponseBodyInstanceSSL(TeaModel):
    def __init__(
        self,
        auto_update: str = None,
        ca_url: str = None,
        enable_ssl: str = None,
        force_ssl: str = None,
        force_sslsupport: bool = None,
        instance_id: str = None,
        status: str = None,
        tenant_id: str = None,
        valid_period: str = None,
    ):
        # The status of automatic update of SSL certificates. Valid values: 
        # * CLOSE: The automatic update of SSL certificates is disabled. 
        # * OPEN: The automatic update of SSL certificates is enabled.
        self.auto_update = auto_update
        # The URL of the certificate authority (CA) node.
        self.ca_url = ca_url
        # The operation to modify the SSL status. Valid values:
        # 
        # - open: Enable SSL encryption.
        # 
        # - update: Update the CA certificate.
        # 
        # - close: Disable SSL encryption.
        self.enable_ssl = enable_ssl
        # The forced enabling status of SSL.
        self.force_ssl = force_ssl
        # Indicates whether SSL can be forcibly enabled.
        self.force_sslsupport = force_sslsupport
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The SSL status of the cluster.
        self.status = status
        self.tenant_id = tenant_id
        # The validity period of the SSL certificate.
        self.valid_period = valid_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_update is not None:
            result['AutoUpdate'] = self.auto_update
        if self.ca_url is not None:
            result['CaUrl'] = self.ca_url
        if self.enable_ssl is not None:
            result['EnableSSL'] = self.enable_ssl
        if self.force_ssl is not None:
            result['ForceSSL'] = self.force_ssl
        if self.force_sslsupport is not None:
            result['ForceSSLSupport'] = self.force_sslsupport
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.valid_period is not None:
            result['ValidPeriod'] = self.valid_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoUpdate') is not None:
            self.auto_update = m.get('AutoUpdate')
        if m.get('CaUrl') is not None:
            self.ca_url = m.get('CaUrl')
        if m.get('EnableSSL') is not None:
            self.enable_ssl = m.get('EnableSSL')
        if m.get('ForceSSL') is not None:
            self.force_ssl = m.get('ForceSSL')
        if m.get('ForceSSLSupport') is not None:
            self.force_sslsupport = m.get('ForceSSLSupport')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ValidPeriod') is not None:
            self.valid_period = m.get('ValidPeriod')
        return self


class DescribeInstanceSSLResponseBody(TeaModel):
    def __init__(
        self,
        instance_ssl: DescribeInstanceSSLResponseBodyInstanceSSL = None,
        request_id: str = None,
    ):
        # The SSL setting of the OceanBase cluster instance.
        self.instance_ssl = instance_ssl
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instance_ssl:
            self.instance_ssl.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ssl is not None:
            result['InstanceSSL'] = self.instance_ssl.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceSSL') is not None:
            temp_model = DescribeInstanceSSLResponseBodyInstanceSSL()
            self.instance_ssl = temp_model.from_map(m['InstanceSSL'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceSSLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceSSLResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSSLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSecurityConfigsRequest(TeaModel):
    def __init__(
        self,
        check_id: str = None,
        instance_id: str = None,
    ):
        # The unique identifier of the check.
        self.check_id = check_id
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigsSecurityConfigs(TeaModel):
    def __init__(
        self,
        config_description: str = None,
        config_group: str = None,
        config_name: str = None,
        risk: bool = None,
        risk_description: str = None,
    ):
        # The name of the check item.
        self.config_description = config_description
        # The group of the check.
        self.config_group = config_group
        # The name of the specific check item.
        self.config_name = config_name
        # Specifies whether a risk is detected.
        self.risk = risk
        # Security recommendations.
        self.risk_description = risk_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_description is not None:
            result['ConfigDescription'] = self.config_description
        if self.config_group is not None:
            result['ConfigGroup'] = self.config_group
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.risk is not None:
            result['Risk'] = self.risk
        if self.risk_description is not None:
            result['RiskDescription'] = self.risk_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigDescription') is not None:
            self.config_description = m.get('ConfigDescription')
        if m.get('ConfigGroup') is not None:
            self.config_group = m.get('ConfigGroup')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('Risk') is not None:
            self.risk = m.get('Risk')
        if m.get('RiskDescription') is not None:
            self.risk_description = m.get('RiskDescription')
        return self


class DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigs(TeaModel):
    def __init__(
        self,
        check_id: str = None,
        check_time: str = None,
        instance_id: str = None,
        security_configs: List[DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigsSecurityConfigs] = None,
        total_check_count: int = None,
        total_risk_count: int = None,
    ):
        # The unique identifier of the check.
        self.check_id = check_id
        # The time when the check was performed.
        self.check_time = check_time
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The list of check items.
        self.security_configs = security_configs
        # The total number of security check items for the cluster.
        self.total_check_count = total_check_count
        # The total number of detected cluster security risks.
        self.total_risk_count = total_risk_count

    def validate(self):
        if self.security_configs:
            for k in self.security_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_time is not None:
            result['CheckTime'] = self.check_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['SecurityConfigs'] = []
        if self.security_configs is not None:
            for k in self.security_configs:
                result['SecurityConfigs'].append(k.to_map() if k else None)
        if self.total_check_count is not None:
            result['TotalCheckCount'] = self.total_check_count
        if self.total_risk_count is not None:
            result['TotalRiskCount'] = self.total_risk_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckTime') is not None:
            self.check_time = m.get('CheckTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.security_configs = []
        if m.get('SecurityConfigs') is not None:
            for k in m.get('SecurityConfigs'):
                temp_model = DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigsSecurityConfigs()
                self.security_configs.append(temp_model.from_map(k))
        if m.get('TotalCheckCount') is not None:
            self.total_check_count = m.get('TotalCheckCount')
        if m.get('TotalRiskCount') is not None:
            self.total_risk_count = m.get('TotalRiskCount')
        return self


class DescribeInstanceSecurityConfigsResponseBody(TeaModel):
    def __init__(
        self,
        instance_security_configs: DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigs = None,
        request_id: str = None,
    ):
        # The return result of the request.
        self.instance_security_configs = instance_security_configs
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instance_security_configs:
            self.instance_security_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_security_configs is not None:
            result['InstanceSecurityConfigs'] = self.instance_security_configs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceSecurityConfigs') is not None:
            temp_model = DescribeInstanceSecurityConfigsResponseBodyInstanceSecurityConfigs()
            self.instance_security_configs = temp_model.from_map(m['InstanceSecurityConfigs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceSecurityConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceSecurityConfigsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSecurityConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSummaryRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
    ):
        # The number of the page to return.    
        # - Start value: 1   
        # - Default value: 1
        self.page_number = page_number
        # The number of rows to return on each page.
        # - Maximum value: 100.
        # - Default value: 10.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeInstanceSummaryResponseBodyInstanceSummaryRegionalInstanceSummaryList(TeaModel):
    def __init__(
        self,
        expired_instances_count: int = None,
        immediately_expired_instances_count: int = None,
        recent_created_instances_count: int = None,
        region: str = None,
        running_instances_count: int = None,
        total_instances_count: int = None,
    ):
        # The number of expired instances.
        self.expired_instances_count = expired_instances_count
        # The number of instances about to expire.
        self.immediately_expired_instances_count = immediately_expired_instances_count
        # The number of recently created instances.
        self.recent_created_instances_count = recent_created_instances_count
        # The ID of the region.
        self.region = region
        # The total number of running instances.
        self.running_instances_count = running_instances_count
        # The total number of instances.
        self.total_instances_count = total_instances_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_instances_count is not None:
            result['ExpiredInstancesCount'] = self.expired_instances_count
        if self.immediately_expired_instances_count is not None:
            result['ImmediatelyExpiredInstancesCount'] = self.immediately_expired_instances_count
        if self.recent_created_instances_count is not None:
            result['RecentCreatedInstancesCount'] = self.recent_created_instances_count
        if self.region is not None:
            result['Region'] = self.region
        if self.running_instances_count is not None:
            result['RunningInstancesCount'] = self.running_instances_count
        if self.total_instances_count is not None:
            result['TotalInstancesCount'] = self.total_instances_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredInstancesCount') is not None:
            self.expired_instances_count = m.get('ExpiredInstancesCount')
        if m.get('ImmediatelyExpiredInstancesCount') is not None:
            self.immediately_expired_instances_count = m.get('ImmediatelyExpiredInstancesCount')
        if m.get('RecentCreatedInstancesCount') is not None:
            self.recent_created_instances_count = m.get('RecentCreatedInstancesCount')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RunningInstancesCount') is not None:
            self.running_instances_count = m.get('RunningInstancesCount')
        if m.get('TotalInstancesCount') is not None:
            self.total_instances_count = m.get('TotalInstancesCount')
        return self


class DescribeInstanceSummaryResponseBodyInstanceSummary(TeaModel):
    def __init__(
        self,
        alarm_summary_count: int = None,
        anomaly_sqlcount: int = None,
        cluster_instances_count: int = None,
        expired_instances_count: int = None,
        immediately_expired_instances_count: int = None,
        insufficient_disk_instances_count: int = None,
        over_load_instances_count: int = None,
        regional_instance_summary_list: List[DescribeInstanceSummaryResponseBodyInstanceSummaryRegionalInstanceSummaryList] = None,
        running_instances_count: int = None,
        tenant_instances_count: int = None,
        total_instances_count: int = None,
        total_oms_instances_count: int = None,
    ):
        # The total number of alerts during the query period.
        self.alarm_summary_count = alarm_summary_count
        # The total number of abnormal SQL statements.
        self.anomaly_sqlcount = anomaly_sqlcount
        # The number of cluster instances.
        self.cluster_instances_count = cluster_instances_count
        # The number of expired instances.
        self.expired_instances_count = expired_instances_count
        # The total number of expired instances to be released.
        self.immediately_expired_instances_count = immediately_expired_instances_count
        # The total number of clusters with capacity risks.
        self.insufficient_disk_instances_count = insufficient_disk_instances_count
        # The number of overloaded instances.
        self.over_load_instances_count = over_load_instances_count
        # A list of regional instances.
        self.regional_instance_summary_list = regional_instance_summary_list
        # The number of running instances.
        self.running_instances_count = running_instances_count
        # The number of tenant instances.
        self.tenant_instances_count = tenant_instances_count
        # The total number of instances.
        self.total_instances_count = total_instances_count
        # The number of data transmission instances.
        self.total_oms_instances_count = total_oms_instances_count

    def validate(self):
        if self.regional_instance_summary_list:
            for k in self.regional_instance_summary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_summary_count is not None:
            result['AlarmSummaryCount'] = self.alarm_summary_count
        if self.anomaly_sqlcount is not None:
            result['AnomalySQLCount'] = self.anomaly_sqlcount
        if self.cluster_instances_count is not None:
            result['ClusterInstancesCount'] = self.cluster_instances_count
        if self.expired_instances_count is not None:
            result['ExpiredInstancesCount'] = self.expired_instances_count
        if self.immediately_expired_instances_count is not None:
            result['ImmediatelyExpiredInstancesCount'] = self.immediately_expired_instances_count
        if self.insufficient_disk_instances_count is not None:
            result['InsufficientDiskInstancesCount'] = self.insufficient_disk_instances_count
        if self.over_load_instances_count is not None:
            result['OverLoadInstancesCount'] = self.over_load_instances_count
        result['RegionalInstanceSummaryList'] = []
        if self.regional_instance_summary_list is not None:
            for k in self.regional_instance_summary_list:
                result['RegionalInstanceSummaryList'].append(k.to_map() if k else None)
        if self.running_instances_count is not None:
            result['RunningInstancesCount'] = self.running_instances_count
        if self.tenant_instances_count is not None:
            result['TenantInstancesCount'] = self.tenant_instances_count
        if self.total_instances_count is not None:
            result['TotalInstancesCount'] = self.total_instances_count
        if self.total_oms_instances_count is not None:
            result['TotalOmsInstancesCount'] = self.total_oms_instances_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmSummaryCount') is not None:
            self.alarm_summary_count = m.get('AlarmSummaryCount')
        if m.get('AnomalySQLCount') is not None:
            self.anomaly_sqlcount = m.get('AnomalySQLCount')
        if m.get('ClusterInstancesCount') is not None:
            self.cluster_instances_count = m.get('ClusterInstancesCount')
        if m.get('ExpiredInstancesCount') is not None:
            self.expired_instances_count = m.get('ExpiredInstancesCount')
        if m.get('ImmediatelyExpiredInstancesCount') is not None:
            self.immediately_expired_instances_count = m.get('ImmediatelyExpiredInstancesCount')
        if m.get('InsufficientDiskInstancesCount') is not None:
            self.insufficient_disk_instances_count = m.get('InsufficientDiskInstancesCount')
        if m.get('OverLoadInstancesCount') is not None:
            self.over_load_instances_count = m.get('OverLoadInstancesCount')
        self.regional_instance_summary_list = []
        if m.get('RegionalInstanceSummaryList') is not None:
            for k in m.get('RegionalInstanceSummaryList'):
                temp_model = DescribeInstanceSummaryResponseBodyInstanceSummaryRegionalInstanceSummaryList()
                self.regional_instance_summary_list.append(temp_model.from_map(k))
        if m.get('RunningInstancesCount') is not None:
            self.running_instances_count = m.get('RunningInstancesCount')
        if m.get('TenantInstancesCount') is not None:
            self.tenant_instances_count = m.get('TenantInstancesCount')
        if m.get('TotalInstancesCount') is not None:
            self.total_instances_count = m.get('TotalInstancesCount')
        if m.get('TotalOmsInstancesCount') is not None:
            self.total_oms_instances_count = m.get('TotalOmsInstancesCount')
        return self


class DescribeInstanceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        instance_summary: DescribeInstanceSummaryResponseBodyInstanceSummary = None,
        request_id: str = None,
    ):
        # The overview information about OceanBase instances.
        self.instance_summary = instance_summary
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.instance_summary:
            self.instance_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_summary is not None:
            result['InstanceSummary'] = self.instance_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceSummary') is not None:
            temp_model = DescribeInstanceSummaryResponseBodyInstanceSummary()
            self.instance_summary = temp_model.from_map(m['InstanceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceTagsRequest(TeaModel):
    def __init__(
        self,
        instance_ids: str = None,
        tags: str = None,
    ):
        # The list of cluster IDs.
        self.instance_ids = instance_ids
        # The tags.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class DescribeInstanceTagsResponseBodyTagResources(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        resource_type: str = None,
        tag: str = None,
    ):
        # The resource ID.
        self.resource_id = resource_id
        # The type of the resource.
        self.resource_type = resource_type
        # The tag of the resource.
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeInstanceTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tag_resources: List[DescribeInstanceTagsResponseBodyTagResources] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The list of tags.
        self.tag_resources = tag_resources

    def validate(self):
        if self.tag_resources:
            for k in self.tag_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TagResources'] = []
        if self.tag_resources is not None:
            for k in self.tag_resources:
                result['TagResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tag_resources = []
        if m.get('TagResources') is not None:
            for k in m.get('TagResources'):
                temp_model = DescribeInstanceTagsResponseBodyTagResources()
                self.tag_resources.append(temp_model.from_map(k))
        return self


class DescribeInstanceTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceTenantModesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The operation that you want to perform.   
        # Set the value to **DescribeInstanceTenantModes**.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceTenantModesResponseBody(TeaModel):
    def __init__(
        self,
        instance_modes: List[str] = None,
        request_id: str = None,
    ):
        self.instance_modes = instance_modes
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_modes is not None:
            result['InstanceModes'] = self.instance_modes
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceModes') is not None:
            self.instance_modes = m.get('InstanceModes')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceTenantModesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceTenantModesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceTenantModesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceTopologyRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceCpu(TeaModel):
    def __init__(
        self,
        total_cpu: int = None,
        used_cpu: int = None,
    ):
        # The total number of CPU cores of the replica.
        self.total_cpu = total_cpu
        # The number of CPU cores used by the replica.
        self.used_cpu = used_cpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_cpu is not None:
            result['TotalCpu'] = self.total_cpu
        if self.used_cpu is not None:
            result['UsedCpu'] = self.used_cpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCpu') is not None:
            self.total_cpu = m.get('TotalCpu')
        if m.get('UsedCpu') is not None:
            self.used_cpu = m.get('UsedCpu')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceDiskSize(TeaModel):
    def __init__(
        self,
        total_disk_size: int = None,
        used_disk_size: float = None,
    ):
        # The total disk space of the replica, in GB.
        self.total_disk_size = total_disk_size
        # The disk space used by the replica, in GB.
        self.used_disk_size = used_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceMemory(TeaModel):
    def __init__(
        self,
        total_memory: int = None,
        used_memory: int = None,
    ):
        # The total memory size of the replica, in GB.
        self.total_memory = total_memory
        # The size of memory used by the replica, in GB.
        self.used_memory = used_memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.used_memory is not None:
            result['UsedMemory'] = self.used_memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('UsedMemory') is not None:
            self.used_memory = m.get('UsedMemory')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResource(TeaModel):
    def __init__(
        self,
        cpu: DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceCpu = None,
        disk_size: DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceDiskSize = None,
        memory: DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceMemory = None,
    ):
        # The information about the CPU resources of the replica.
        self.cpu = cpu
        # The information about the data disk of the replica.
        self.disk_size = disk_size
        # The information about the memory resources of the replica.
        self.memory = memory

    def validate(self):
        if self.cpu:
            self.cpu.validate()
        if self.disk_size:
            self.disk_size.validate()
        if self.memory:
            self.memory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu.to_map()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        if self.memory is not None:
            result['Memory'] = self.memory.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceCpu()
            self.cpu = temp_model.from_map(m['Cpu'])
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        if m.get('Memory') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResourceMemory()
            self.memory = temp_model.from_map(m['Memory'])
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyReplicas(TeaModel):
    def __init__(
        self,
        logical_zone: str = None,
        node_num: int = None,
        online_node_num: int = None,
        read_only_replica_type: str = None,
        replica_resource: DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResource = None,
        replica_type: str = None,
        status: str = None,
        zone_logical_id: int = None,
        zone_logical_name: str = None,
        zone_region_name: str = None,
    ):
        # The ID of the replica.
        self.logical_zone = logical_zone
        # The number of nodes of the replica.
        self.node_num = node_num
        self.online_node_num = online_node_num
        # The type of the read-only replica.
        self.read_only_replica_type = read_only_replica_type
        # The information about the replica resources.
        self.replica_resource = replica_resource
        # The type of the replica.
        self.replica_type = replica_type
        # The status of the replica. Valid values: ACTIVE, INACTIVE, and UNKNOWN.
        self.status = status
        # The serial number of the replica.
        self.zone_logical_id = zone_logical_id
        # The region of the replica.
        self.zone_logical_name = zone_logical_name
        # The zone of the replica.
        self.zone_region_name = zone_region_name

    def validate(self):
        if self.replica_resource:
            self.replica_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logical_zone is not None:
            result['LogicalZone'] = self.logical_zone
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.online_node_num is not None:
            result['OnlineNodeNum'] = self.online_node_num
        if self.read_only_replica_type is not None:
            result['ReadOnlyReplicaType'] = self.read_only_replica_type
        if self.replica_resource is not None:
            result['ReplicaResource'] = self.replica_resource.to_map()
        if self.replica_type is not None:
            result['ReplicaType'] = self.replica_type
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_logical_id is not None:
            result['ZoneLogicalId'] = self.zone_logical_id
        if self.zone_logical_name is not None:
            result['ZoneLogicalName'] = self.zone_logical_name
        if self.zone_region_name is not None:
            result['ZoneRegionName'] = self.zone_region_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogicalZone') is not None:
            self.logical_zone = m.get('LogicalZone')
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('OnlineNodeNum') is not None:
            self.online_node_num = m.get('OnlineNodeNum')
        if m.get('ReadOnlyReplicaType') is not None:
            self.read_only_replica_type = m.get('ReadOnlyReplicaType')
        if m.get('ReplicaResource') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyReplicasReplicaResource()
            self.replica_resource = temp_model.from_map(m['ReplicaResource'])
        if m.get('ReplicaType') is not None:
            self.replica_type = m.get('ReplicaType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneLogicalId') is not None:
            self.zone_logical_id = m.get('ZoneLogicalId')
        if m.get('ZoneLogicalName') is not None:
            self.zone_logical_name = m.get('ZoneLogicalName')
        if m.get('ZoneRegionName') is not None:
            self.zone_region_name = m.get('ZoneRegionName')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZonesUnits(TeaModel):
    def __init__(
        self,
        enable_cancel_migrate_unit: bool = None,
        enable_migrate_unit: bool = None,
        manual_migrate: bool = None,
        node_id: str = None,
        replica_type: str = None,
        unit_cpu: float = None,
        unit_data_size: int = None,
        unit_id: str = None,
        unit_memory: float = None,
        unit_status: str = None,
    ):
        # Indicates whether the migration can be canceled. This parameter is valid only for resource units that are being manually immigrated or emigrated.
        self.enable_cancel_migrate_unit = enable_cancel_migrate_unit
        # Indicates whether the resource unit can be migrated.
        self.enable_migrate_unit = enable_migrate_unit
        # Indicates whether the resource unit is manually migrated.
        self.manual_migrate = manual_migrate
        # The ID of the OBServer node in which the resource unit resides.
        self.node_id = node_id
        # The type of the replica. Node filtering conditions are configured based on the replica type when you query the monitoring data of the OceanBase cluster. 
        # * By default, the replica type is not specified when you query the monitoring data of OceanBase clusters or the access proxy. If you do not specify the replica type when you query the monitoring data of an OceanBase cluster, the monitoring data of all nodes is queried. 
        # * If you set the replica type to FULL when you query the monitoring data of an OceanBase cluster, the monitoring data of only the full-featured replica nodes is queried. 
        # * If you set the replica type to READONLY when you query the monitoring data of an OceanBase cluster, the monitoring data of only the read-only replica nodes is queried.
        self.replica_type = replica_type
        # The number of CPU cores of the resource unit.
        self.unit_cpu = unit_cpu
        # The data size of the resource unit.
        self.unit_data_size = unit_data_size
        # The ID of the resource unit.
        self.unit_id = unit_id
        # The memory size of the resource unit, in GB.
        self.unit_memory = unit_memory
        # The status of the resource unit. Valid values: 
        # * ONLINE: The resource unit is running. 
        # * IMMIGRATING: The resource unit is being immigrated. 
        # * EMIGRATING: The resource unit is being emigrated. 
        # * CANCEL_EMIGRATING: The immigration of the resource unit is being canceled. 
        # * CANCEL_EMIGRATING: The emigration of the resource unit is being canceled. 
        # * DELETING: The resource unit is being deleted.
        self.unit_status = unit_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_cancel_migrate_unit is not None:
            result['EnableCancelMigrateUnit'] = self.enable_cancel_migrate_unit
        if self.enable_migrate_unit is not None:
            result['EnableMigrateUnit'] = self.enable_migrate_unit
        if self.manual_migrate is not None:
            result['ManualMigrate'] = self.manual_migrate
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.replica_type is not None:
            result['ReplicaType'] = self.replica_type
        if self.unit_cpu is not None:
            result['UnitCpu'] = self.unit_cpu
        if self.unit_data_size is not None:
            result['UnitDataSize'] = self.unit_data_size
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        if self.unit_memory is not None:
            result['UnitMemory'] = self.unit_memory
        if self.unit_status is not None:
            result['UnitStatus'] = self.unit_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableCancelMigrateUnit') is not None:
            self.enable_cancel_migrate_unit = m.get('EnableCancelMigrateUnit')
        if m.get('EnableMigrateUnit') is not None:
            self.enable_migrate_unit = m.get('EnableMigrateUnit')
        if m.get('ManualMigrate') is not None:
            self.manual_migrate = m.get('ManualMigrate')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ReplicaType') is not None:
            self.replica_type = m.get('ReplicaType')
        if m.get('UnitCpu') is not None:
            self.unit_cpu = m.get('UnitCpu')
        if m.get('UnitDataSize') is not None:
            self.unit_data_size = m.get('UnitDataSize')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        if m.get('UnitMemory') is not None:
            self.unit_memory = m.get('UnitMemory')
        if m.get('UnitStatus') is not None:
            self.unit_status = m.get('UnitStatus')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZones(TeaModel):
    def __init__(
        self,
        is_primary_tenant_zone: bool = None,
        logical_zone: str = None,
        read_only_replica_type: str = None,
        replica_type: str = None,
        tenant_zone_id: str = None,
        tenant_zone_role: str = None,
        units: List[DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZonesUnits] = None,
    ):
        # Indicates whether the zone is the primary zone.
        self.is_primary_tenant_zone = is_primary_tenant_zone
        # The ID of the replica.
        self.logical_zone = logical_zone
        # The type of the read-only replica.
        self.read_only_replica_type = read_only_replica_type
        # The replica type of the tenant.
        self.replica_type = replica_type
        # The ID of the zone.
        self.tenant_zone_id = tenant_zone_id
        # The role to access the zone. Valid values: 
        # * ReadWrite: a role that has the read and write privileges. 
        # * ReadOnly: a role that has only the read-only privilege.
        self.tenant_zone_role = tenant_zone_role
        # The information about the resource units.
        self.units = units

    def validate(self):
        if self.units:
            for k in self.units:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_primary_tenant_zone is not None:
            result['IsPrimaryTenantZone'] = self.is_primary_tenant_zone
        if self.logical_zone is not None:
            result['LogicalZone'] = self.logical_zone
        if self.read_only_replica_type is not None:
            result['ReadOnlyReplicaType'] = self.read_only_replica_type
        if self.replica_type is not None:
            result['ReplicaType'] = self.replica_type
        if self.tenant_zone_id is not None:
            result['TenantZoneId'] = self.tenant_zone_id
        if self.tenant_zone_role is not None:
            result['TenantZoneRole'] = self.tenant_zone_role
        result['Units'] = []
        if self.units is not None:
            for k in self.units:
                result['Units'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPrimaryTenantZone') is not None:
            self.is_primary_tenant_zone = m.get('IsPrimaryTenantZone')
        if m.get('LogicalZone') is not None:
            self.logical_zone = m.get('LogicalZone')
        if m.get('ReadOnlyReplicaType') is not None:
            self.read_only_replica_type = m.get('ReadOnlyReplicaType')
        if m.get('ReplicaType') is not None:
            self.replica_type = m.get('ReplicaType')
        if m.get('TenantZoneId') is not None:
            self.tenant_zone_id = m.get('TenantZoneId')
        if m.get('TenantZoneRole') is not None:
            self.tenant_zone_role = m.get('TenantZoneRole')
        self.units = []
        if m.get('Units') is not None:
            for k in m.get('Units'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZonesUnits()
                self.units.append(temp_model.from_map(k))
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyTenants(TeaModel):
    def __init__(
        self,
        primary_zone_deploy_type: str = None,
        tenant_cpu: float = None,
        tenant_deploy_type: str = None,
        tenant_disk_size: float = None,
        tenant_id: str = None,
        tenant_memory: float = None,
        tenant_mode: str = None,
        tenant_name: str = None,
        tenant_status: str = None,
        tenant_unit_cpu: float = None,
        tenant_unit_memory: float = None,
        tenant_unit_num: int = None,
        tenant_zones: List[DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZones] = None,
    ):
        # The deployment mode of the primary zone. Valid values: 
        # * RANDOM. 
        # * STATIC.
        self.primary_zone_deploy_type = primary_zone_deploy_type
        # The number of CPU cores of the tenant.
        self.tenant_cpu = tenant_cpu
        # The deployment type of the tenant. Valid values: 
        # * multiple: multi-IDC deployment. 
        # * single: single-IDC deployment. 
        # * dual: dual-IDC deployment.
        self.tenant_deploy_type = tenant_deploy_type
        # The disk space of the tenant, in GB.
        self.tenant_disk_size = tenant_disk_size
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The memory size of the tenant, in GB.
        self.tenant_memory = tenant_memory
        # The mode of the tenant. Valid values: 
        # * Oracle  
        # * MySQL
        self.tenant_mode = tenant_mode
        # The name of the tenant.
        self.tenant_name = tenant_name
        # The status of the tenant. Valid values: 
        # * PENDING_CREATE: The tenant is being created. 
        # * RESTORE: The tenant is being restored. 
        # * ONLINE: The tenant is running. 
        # * SPEC_MODIFYING: The specification of the tenant is being modified. 
        # * ALLOCATING_INTERNET_ADDRESS: A public IP address is being allocated to the tenant. 
        # * PENDING_OFFLINE_INTERNET_ADDRESS: The public IP address is being disabled. 
        # * PRIMARY_ZONE_MODIFYING: The tenant is being switched to a new primary zone. 
        # * PARAMETER_MODIFYING: Parameters are being modified. 
        # * WHITE_LIST_MODIFYING: The allowlist is being modified.
        self.tenant_status = tenant_status
        # The number of CPU cores of a single node in the tenant.
        self.tenant_unit_cpu = tenant_unit_cpu
        # The memory size of a single node in the tenant, in GB.
        self.tenant_unit_memory = tenant_unit_memory
        # The number of resource units in the tenant.
        self.tenant_unit_num = tenant_unit_num
        # The information about the zones.
        self.tenant_zones = tenant_zones

    def validate(self):
        if self.tenant_zones:
            for k in self.tenant_zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_zone_deploy_type is not None:
            result['PrimaryZoneDeployType'] = self.primary_zone_deploy_type
        if self.tenant_cpu is not None:
            result['TenantCpu'] = self.tenant_cpu
        if self.tenant_deploy_type is not None:
            result['TenantDeployType'] = self.tenant_deploy_type
        if self.tenant_disk_size is not None:
            result['TenantDiskSize'] = self.tenant_disk_size
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.tenant_memory is not None:
            result['TenantMemory'] = self.tenant_memory
        if self.tenant_mode is not None:
            result['TenantMode'] = self.tenant_mode
        if self.tenant_name is not None:
            result['TenantName'] = self.tenant_name
        if self.tenant_status is not None:
            result['TenantStatus'] = self.tenant_status
        if self.tenant_unit_cpu is not None:
            result['TenantUnitCpu'] = self.tenant_unit_cpu
        if self.tenant_unit_memory is not None:
            result['TenantUnitMemory'] = self.tenant_unit_memory
        if self.tenant_unit_num is not None:
            result['TenantUnitNum'] = self.tenant_unit_num
        result['TenantZones'] = []
        if self.tenant_zones is not None:
            for k in self.tenant_zones:
                result['TenantZones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrimaryZoneDeployType') is not None:
            self.primary_zone_deploy_type = m.get('PrimaryZoneDeployType')
        if m.get('TenantCpu') is not None:
            self.tenant_cpu = m.get('TenantCpu')
        if m.get('TenantDeployType') is not None:
            self.tenant_deploy_type = m.get('TenantDeployType')
        if m.get('TenantDiskSize') is not None:
            self.tenant_disk_size = m.get('TenantDiskSize')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TenantMemory') is not None:
            self.tenant_memory = m.get('TenantMemory')
        if m.get('TenantMode') is not None:
            self.tenant_mode = m.get('TenantMode')
        if m.get('TenantName') is not None:
            self.tenant_name = m.get('TenantName')
        if m.get('TenantStatus') is not None:
            self.tenant_status = m.get('TenantStatus')
        if m.get('TenantUnitCpu') is not None:
            self.tenant_unit_cpu = m.get('TenantUnitCpu')
        if m.get('TenantUnitMemory') is not None:
            self.tenant_unit_memory = m.get('TenantUnitMemory')
        if m.get('TenantUnitNum') is not None:
            self.tenant_unit_num = m.get('TenantUnitNum')
        self.tenant_zones = []
        if m.get('TenantZones') is not None:
            for k in m.get('TenantZones'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyTenantsTenantZones()
                self.tenant_zones.append(temp_model.from_map(k))
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceCpu(TeaModel):
    def __init__(
        self,
        total_cpu: int = None,
        used_cpu: float = None,
    ):
        # The total number of CPU cores of the node.
        self.total_cpu = total_cpu
        # The number of CPU cores used by the node.
        self.used_cpu = used_cpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_cpu is not None:
            result['TotalCpu'] = self.total_cpu
        if self.used_cpu is not None:
            result['UsedCpu'] = self.used_cpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCpu') is not None:
            self.total_cpu = m.get('TotalCpu')
        if m.get('UsedCpu') is not None:
            self.used_cpu = m.get('UsedCpu')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceDiskSize(TeaModel):
    def __init__(
        self,
        total_disk_size: float = None,
        used_disk_size: float = None,
    ):
        # The total storage space of the node, in GB.
        self.total_disk_size = total_disk_size
        # The size of storage space used by the node, in GB.
        self.used_disk_size = used_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceMemory(TeaModel):
    def __init__(
        self,
        total_memory: int = None,
        used_memory: float = None,
    ):
        # The total memory size of the node, in GB.
        self.total_memory = total_memory
        # The size of memory used by the node, in GB.
        self.used_memory = used_memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.used_memory is not None:
            result['UsedMemory'] = self.used_memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('UsedMemory') is not None:
            self.used_memory = m.get('UsedMemory')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResource(TeaModel):
    def __init__(
        self,
        cpu: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceCpu = None,
        disk_size: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceDiskSize = None,
        memory: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceMemory = None,
    ):
        # The information about the CPU resources of the node.
        self.cpu = cpu
        # The information about the storage resources of the node.
        self.disk_size = disk_size
        # The information about the memory resources of the node.
        self.memory = memory

    def validate(self):
        if self.cpu:
            self.cpu.validate()
        if self.disk_size:
            self.disk_size.validate()
        if self.memory:
            self.memory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu.to_map()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        if self.memory is not None:
            result['Memory'] = self.memory.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceCpu()
            self.cpu = temp_model.from_map(m['Cpu'])
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        if m.get('Memory') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResourceMemory()
            self.memory = temp_model.from_map(m['Memory'])
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodes(TeaModel):
    def __init__(
        self,
        full_copy_id: int = None,
        logical_zone: str = None,
        node_copy_id: int = None,
        node_id: str = None,
        node_resource: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResource = None,
        node_status: str = None,
        read_only_copy_id: int = None,
        read_only_replica_type: str = None,
        replica_type: str = None,
    ):
        # The ID of the full-featured replica.
        self.full_copy_id = full_copy_id
        # The ID of the replica.
        self.logical_zone = logical_zone
        # The ID of the replica node.
        self.node_copy_id = node_copy_id
        # The ID of the node.
        self.node_id = node_id
        # The information about node resources.
        self.node_resource = node_resource
        # The status of the node.
        self.node_status = node_status
        # The ID of the read-only replica.
        self.read_only_copy_id = read_only_copy_id
        # The type of the read-only replica.
        self.read_only_replica_type = read_only_replica_type
        # The type of the replica. Valid values: 
        # * FULL. 
        # * READONLY.
        self.replica_type = replica_type

    def validate(self):
        if self.node_resource:
            self.node_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_copy_id is not None:
            result['FullCopyId'] = self.full_copy_id
        if self.logical_zone is not None:
            result['LogicalZone'] = self.logical_zone
        if self.node_copy_id is not None:
            result['NodeCopyId'] = self.node_copy_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_resource is not None:
            result['NodeResource'] = self.node_resource.to_map()
        if self.node_status is not None:
            result['NodeStatus'] = self.node_status
        if self.read_only_copy_id is not None:
            result['ReadOnlyCopyId'] = self.read_only_copy_id
        if self.read_only_replica_type is not None:
            result['ReadOnlyReplicaType'] = self.read_only_replica_type
        if self.replica_type is not None:
            result['ReplicaType'] = self.replica_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullCopyId') is not None:
            self.full_copy_id = m.get('FullCopyId')
        if m.get('LogicalZone') is not None:
            self.logical_zone = m.get('LogicalZone')
        if m.get('NodeCopyId') is not None:
            self.node_copy_id = m.get('NodeCopyId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeResource') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodesNodeResource()
            self.node_resource = temp_model.from_map(m['NodeResource'])
        if m.get('NodeStatus') is not None:
            self.node_status = m.get('NodeStatus')
        if m.get('ReadOnlyCopyId') is not None:
            self.read_only_copy_id = m.get('ReadOnlyCopyId')
        if m.get('ReadOnlyReplicaType') is not None:
            self.read_only_replica_type = m.get('ReadOnlyReplicaType')
        if m.get('ReplicaType') is not None:
            self.replica_type = m.get('ReplicaType')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResourceDiskSize(TeaModel):
    def __init__(
        self,
        max_disk_used_ob_server: List[str] = None,
        max_disk_used_percent: float = None,
    ):
        # The IDs of OBServer nodes that use the maximum disk space.
        self.max_disk_used_ob_server = max_disk_used_ob_server
        # The maximum disk usage, in percentage.
        self.max_disk_used_percent = max_disk_used_percent

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_disk_used_ob_server is not None:
            result['MaxDiskUsedObServer'] = self.max_disk_used_ob_server
        if self.max_disk_used_percent is not None:
            result['MaxDiskUsedPercent'] = self.max_disk_used_percent
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxDiskUsedObServer') is not None:
            self.max_disk_used_ob_server = m.get('MaxDiskUsedObServer')
        if m.get('MaxDiskUsedPercent') is not None:
            self.max_disk_used_percent = m.get('MaxDiskUsedPercent')
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResource(TeaModel):
    def __init__(
        self,
        disk_size: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResourceDiskSize = None,
    ):
        # The information about the storage resources of the node.
        self.disk_size = disk_size

    def validate(self):
        if self.disk_size:
            self.disk_size.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopologyZones(TeaModel):
    def __init__(
        self,
        nodes: List[DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodes] = None,
        region: str = None,
        zone_disk: str = None,
        zone_id: str = None,
        zone_resource: DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResource = None,
    ):
        # The information about the nodes.
        self.nodes = nodes
        # The ID of the region.
        self.region = region
        # The storage capacity of the zone.
        self.zone_disk = zone_disk
        # The ID of the zone.
        self.zone_id = zone_id
        # The information about zones.
        self.zone_resource = zone_resource

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.zone_resource:
            self.zone_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.region is not None:
            result['Region'] = self.region
        if self.zone_disk is not None:
            result['ZoneDisk'] = self.zone_disk
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.zone_resource is not None:
            result['ZoneResource'] = self.zone_resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ZoneDisk') is not None:
            self.zone_disk = m.get('ZoneDisk')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ZoneResource') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZonesZoneResource()
            self.zone_resource = temp_model.from_map(m['ZoneResource'])
        return self


class DescribeInstanceTopologyResponseBodyInstanceTopology(TeaModel):
    def __init__(
        self,
        replicas: List[DescribeInstanceTopologyResponseBodyInstanceTopologyReplicas] = None,
        tenants: List[DescribeInstanceTopologyResponseBodyInstanceTopologyTenants] = None,
        zones: List[DescribeInstanceTopologyResponseBodyInstanceTopologyZones] = None,
    ):
        # The information about replicas.
        self.replicas = replicas
        # The information about the tenants.
        self.tenants = tenants
        # The information about the zones in which the cluster is deployed.
        self.zones = zones

    def validate(self):
        if self.replicas:
            for k in self.replicas:
                if k:
                    k.validate()
        if self.tenants:
            for k in self.tenants:
                if k:
                    k.validate()
        if self.zones:
            for k in self.zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Replicas'] = []
        if self.replicas is not None:
            for k in self.replicas:
                result['Replicas'].append(k.to_map() if k else None)
        result['Tenants'] = []
        if self.tenants is not None:
            for k in self.tenants:
                result['Tenants'].append(k.to_map() if k else None)
        result['Zones'] = []
        if self.zones is not None:
            for k in self.zones:
                result['Zones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.replicas = []
        if m.get('Replicas') is not None:
            for k in m.get('Replicas'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyReplicas()
                self.replicas.append(temp_model.from_map(k))
        self.tenants = []
        if m.get('Tenants') is not None:
            for k in m.get('Tenants'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyTenants()
                self.tenants.append(temp_model.from_map(k))
        self.zones = []
        if m.get('Zones') is not None:
            for k in m.get('Zones'):
                temp_model = DescribeInstanceTopologyResponseBodyInstanceTopologyZones()
                self.zones.append(temp_model.from_map(k))
        return self


class DescribeInstanceTopologyResponseBody(TeaModel):
    def __init__(
        self,
        instance_topology: DescribeInstanceTopologyResponseBodyInstanceTopology = None,
        request_id: str = None,
    ):
        # The topology of the cluster.
        self.instance_topology = instance_topology
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instance_topology:
            self.instance_topology.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_topology is not None:
            result['InstanceTopology'] = self.instance_topology.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceTopology') is not None:
            temp_model = DescribeInstanceTopologyResponseBodyInstanceTopology()
            self.instance_topology = temp_model.from_map(m['InstanceTopology'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceTopologyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceTopologyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceTopologyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstancesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_name: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
        search_key: str = None,
        with_obcloud_instances: bool = None,
    ):
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The name of the OceanBase cluster. It must be 1 to 20 characters in length. If this parameter is not specified, the value is the instance ID of the cluster by default.
        self.instance_name = instance_name
        # The number of the page to return.
        # - Pages start from page 1.
        # - Default value: 1.
        self.page_number = page_number
        # The number of rows to return on each page.
        # - Maximum value: 100.
        # - Default value: 10.
        self.page_size = page_size
        # The ID of the resource group. If you do not specify this parameter, all resources are returned.
        self.resource_group_id = resource_group_id
        # The keyword for fuzzy search, which can be an instance ID, instance name, tenant ID, or tenant name.
        self.search_key = search_key
        self.with_obcloud_instances = with_obcloud_instances

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.with_obcloud_instances is not None:
            result['WithOBCloudInstances'] = self.with_obcloud_instances
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('WithOBCloudInstances') is not None:
            self.with_obcloud_instances = m.get('WithOBCloudInstances')
        return self


class DescribeInstancesResponseBodyInstancesDataDiskAutoScaleConfig(TeaModel):
    def __init__(
        self,
        auto_scale: bool = None,
        max_disk_size: int = None,
        scale_step_in_merge: float = None,
        scale_step_in_normal: float = None,
        upper_merge_threshold: float = None,
        upper_scale_strategy: str = None,
        upper_threshold: float = None,
        upperbound: float = None,
    ):
        # Specifies whether to enable the automatic scaling of the data disk.
        self.auto_scale = auto_scale
        # The maximum size of the disk, in GB.
        self.max_disk_size = max_disk_size
        # The size of scaling step during a major compaction.
        self.scale_step_in_merge = scale_step_in_merge
        # The size of scaling step during daily use.
        self.scale_step_in_normal = scale_step_in_normal
        # The maximum usage of the data disk, in percentage, that triggers the scaling of the data disk for major compactions.
        self.upper_merge_threshold = upper_merge_threshold
        # The scale-out strategy. Valid values: RAW and PERCENTAGE.
        self.upper_scale_strategy = upper_scale_strategy
        # The maximum usage of the data disk, in percentage, that triggers the scaling of the data disk for daily use.
        self.upper_threshold = upper_threshold
        # The maximum space, in GB, to which the data disk can be scaled.
        self.upperbound = upperbound

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_scale is not None:
            result['AutoScale'] = self.auto_scale
        if self.max_disk_size is not None:
            result['MaxDiskSize'] = self.max_disk_size
        if self.scale_step_in_merge is not None:
            result['ScaleStepInMerge'] = self.scale_step_in_merge
        if self.scale_step_in_normal is not None:
            result['ScaleStepInNormal'] = self.scale_step_in_normal
        if self.upper_merge_threshold is not None:
            result['UpperMergeThreshold'] = self.upper_merge_threshold
        if self.upper_scale_strategy is not None:
            result['UpperScaleStrategy'] = self.upper_scale_strategy
        if self.upper_threshold is not None:
            result['UpperThreshold'] = self.upper_threshold
        if self.upperbound is not None:
            result['Upperbound'] = self.upperbound
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoScale') is not None:
            self.auto_scale = m.get('AutoScale')
        if m.get('MaxDiskSize') is not None:
            self.max_disk_size = m.get('MaxDiskSize')
        if m.get('ScaleStepInMerge') is not None:
            self.scale_step_in_merge = m.get('ScaleStepInMerge')
        if m.get('ScaleStepInNormal') is not None:
            self.scale_step_in_normal = m.get('ScaleStepInNormal')
        if m.get('UpperMergeThreshold') is not None:
            self.upper_merge_threshold = m.get('UpperMergeThreshold')
        if m.get('UpperScaleStrategy') is not None:
            self.upper_scale_strategy = m.get('UpperScaleStrategy')
        if m.get('UpperThreshold') is not None:
            self.upper_threshold = m.get('UpperThreshold')
        if m.get('Upperbound') is not None:
            self.upperbound = m.get('Upperbound')
        return self


class DescribeInstancesResponseBodyInstancesMigrationInfoCheckResult(TeaModel):
    def __init__(
        self,
        code: str = None,
        code_name: str = None,
        level: str = None,
        module: str = None,
        module_name: str = None,
        sub_module: str = None,
        sub_module_name: str = None,
    ):
        self.code = code
        self.code_name = code_name
        self.level = level
        self.module = module
        self.module_name = module_name
        self.sub_module = sub_module
        self.sub_module_name = sub_module_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.code_name is not None:
            result['CodeName'] = self.code_name
        if self.level is not None:
            result['Level'] = self.level
        if self.module is not None:
            result['Module'] = self.module
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.sub_module is not None:
            result['SubModule'] = self.sub_module
        if self.sub_module_name is not None:
            result['SubModuleName'] = self.sub_module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CodeName') is not None:
            self.code_name = m.get('CodeName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('SubModule') is not None:
            self.sub_module = m.get('SubModule')
        if m.get('SubModuleName') is not None:
            self.sub_module_name = m.get('SubModuleName')
        return self


class DescribeInstancesResponseBodyInstancesMigrationInfo(TeaModel):
    def __init__(
        self,
        check_result: DescribeInstancesResponseBodyInstancesMigrationInfoCheckResult = None,
        migratable: bool = None,
    ):
        self.check_result = check_result
        self.migratable = migratable

    def validate(self):
        if self.check_result:
            self.check_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_result is not None:
            result['CheckResult'] = self.check_result.to_map()
        if self.migratable is not None:
            result['Migratable'] = self.migratable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckResult') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesMigrationInfoCheckResult()
            self.check_result = temp_model.from_map(m['CheckResult'])
        if m.get('Migratable') is not None:
            self.migratable = m.get('Migratable')
        return self


class DescribeInstancesResponseBodyInstancesResourceCapacityUnit(TeaModel):
    def __init__(
        self,
        max_capacity_unit: int = None,
        min_capacity_unit: int = None,
        used_capacity_unit: int = None,
    ):
        # The maximum number of capacity units.
        self.max_capacity_unit = max_capacity_unit
        # The minimum number of capacity units.
        self.min_capacity_unit = min_capacity_unit
        # The number of used capacity units.
        self.used_capacity_unit = used_capacity_unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_capacity_unit is not None:
            result['MaxCapacityUnit'] = self.max_capacity_unit
        if self.min_capacity_unit is not None:
            result['MinCapacityUnit'] = self.min_capacity_unit
        if self.used_capacity_unit is not None:
            result['UsedCapacityUnit'] = self.used_capacity_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxCapacityUnit') is not None:
            self.max_capacity_unit = m.get('MaxCapacityUnit')
        if m.get('MinCapacityUnit') is not None:
            self.min_capacity_unit = m.get('MinCapacityUnit')
        if m.get('UsedCapacityUnit') is not None:
            self.used_capacity_unit = m.get('UsedCapacityUnit')
        return self


class DescribeInstancesResponseBodyInstancesResourceCpu(TeaModel):
    def __init__(
        self,
        original_total_cpu: float = None,
        total_cpu: float = None,
        unit_cpu: float = None,
        used_cpu: float = None,
    ):
        # The number of original CPU cores in the cluster.
        self.original_total_cpu = original_total_cpu
        # The total number of CPU cores of the cluster.
        self.total_cpu = total_cpu
        # The number of CPU cores of each replica node in the cluster.
        self.unit_cpu = unit_cpu
        # The number of CPU cores used in the cluster.
        self.used_cpu = used_cpu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_cpu is not None:
            result['OriginalTotalCpu'] = self.original_total_cpu
        if self.total_cpu is not None:
            result['TotalCpu'] = self.total_cpu
        if self.unit_cpu is not None:
            result['UnitCpu'] = self.unit_cpu
        if self.used_cpu is not None:
            result['UsedCpu'] = self.used_cpu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalCpu') is not None:
            self.original_total_cpu = m.get('OriginalTotalCpu')
        if m.get('TotalCpu') is not None:
            self.total_cpu = m.get('TotalCpu')
        if m.get('UnitCpu') is not None:
            self.unit_cpu = m.get('UnitCpu')
        if m.get('UsedCpu') is not None:
            self.used_cpu = m.get('UsedCpu')
        return self


class DescribeInstancesResponseBodyInstancesResourceDiskSize(TeaModel):
    def __init__(
        self,
        original_total_disk_size: float = None,
        total_disk_size: float = None,
        unit_disk_size: float = None,
        used_disk_size: int = None,
    ):
        # The original size of the disk.
        self.original_total_disk_size = original_total_disk_size
        # The total storage space of the cluster, in GB.
        self.total_disk_size = total_disk_size
        # The storage space of each replica node in the cluster, in GB.
        self.unit_disk_size = unit_disk_size
        # The size of used storage space of the cluster, in GB.
        self.used_disk_size = used_disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_disk_size is not None:
            result['OriginalTotalDiskSize'] = self.original_total_disk_size
        if self.total_disk_size is not None:
            result['TotalDiskSize'] = self.total_disk_size
        if self.unit_disk_size is not None:
            result['UnitDiskSize'] = self.unit_disk_size
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalDiskSize') is not None:
            self.original_total_disk_size = m.get('OriginalTotalDiskSize')
        if m.get('TotalDiskSize') is not None:
            self.total_disk_size = m.get('TotalDiskSize')
        if m.get('UnitDiskSize') is not None:
            self.unit_disk_size = m.get('UnitDiskSize')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        return self


class DescribeInstancesResponseBodyInstancesResourceMemory(TeaModel):
    def __init__(
        self,
        original_total_memory: float = None,
        total_memory: float = None,
        unit_memory: int = None,
        used_memory: int = None,
    ):
        # The original memory size of the cluster, in GB.
        self.original_total_memory = original_total_memory
        # The total memory size of the cluster, in GB.
        self.total_memory = total_memory
        # The memory size of each replica node in the cluster, in GB.
        self.unit_memory = unit_memory
        # The size of used memory in the cluster, in GB.
        self.used_memory = used_memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_total_memory is not None:
            result['OriginalTotalMemory'] = self.original_total_memory
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.unit_memory is not None:
            result['UnitMemory'] = self.unit_memory
        if self.used_memory is not None:
            result['UsedMemory'] = self.used_memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalTotalMemory') is not None:
            self.original_total_memory = m.get('OriginalTotalMemory')
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('UnitMemory') is not None:
            self.unit_memory = m.get('UnitMemory')
        if m.get('UsedMemory') is not None:
            self.used_memory = m.get('UsedMemory')
        return self


class DescribeInstancesResponseBodyInstancesResource(TeaModel):
    def __init__(
        self,
        capacity_unit: DescribeInstancesResponseBodyInstancesResourceCapacityUnit = None,
        cpu: DescribeInstancesResponseBodyInstancesResourceCpu = None,
        disk_size: DescribeInstancesResponseBodyInstancesResourceDiskSize = None,
        memory: DescribeInstancesResponseBodyInstancesResourceMemory = None,
        unit_count: int = None,
    ):
        # The information about capacity units.
        self.capacity_unit = capacity_unit
        # The information about the CPU resources of the cluster.
        self.cpu = cpu
        # The information about the storage resources of the cluster.
        self.disk_size = disk_size
        # The information about the memory resources of the cluster.
        self.memory = memory
        # The number of resource units in the cluster.
        self.unit_count = unit_count

    def validate(self):
        if self.capacity_unit:
            self.capacity_unit.validate()
        if self.cpu:
            self.cpu.validate()
        if self.disk_size:
            self.disk_size.validate()
        if self.memory:
            self.memory.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit.to_map()
        if self.cpu is not None:
            result['Cpu'] = self.cpu.to_map()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size.to_map()
        if self.memory is not None:
            result['Memory'] = self.memory.to_map()
        if self.unit_count is not None:
            result['UnitCount'] = self.unit_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesResourceCapacityUnit()
            self.capacity_unit = temp_model.from_map(m['CapacityUnit'])
        if m.get('Cpu') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesResourceCpu()
            self.cpu = temp_model.from_map(m['Cpu'])
        if m.get('DiskSize') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesResourceDiskSize()
            self.disk_size = temp_model.from_map(m['DiskSize'])
        if m.get('Memory') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesResourceMemory()
            self.memory = temp_model.from_map(m['Memory'])
        if m.get('UnitCount') is not None:
            self.unit_count = m.get('UnitCount')
        return self


class DescribeInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        available_zones: List[str] = None,
        commodity_code: str = None,
        cpu: int = None,
        cpu_architecture: str = None,
        create_time: str = None,
        data_disk_auto_scale_config: DescribeInstancesResponseBodyInstancesDataDiskAutoScaleConfig = None,
        deploy_mode: str = None,
        deploy_type: str = None,
        disk_size: int = None,
        disk_type: str = None,
        enable_read_only_replica_management: bool = None,
        enable_upgrade_nodes: bool = None,
        expire_seconds: int = None,
        expire_time: str = None,
        in_temp_capacity_status: bool = None,
        instance_class: str = None,
        instance_id: str = None,
        instance_name: str = None,
        instance_role: str = None,
        instance_type: str = None,
        iops: int = None,
        maintain_time: str = None,
        mem: int = None,
        migratable: bool = None,
        migration_info: DescribeInstancesResponseBodyInstancesMigrationInfo = None,
        ob_rpm_version: str = None,
        pay_type: str = None,
        replica_mode: str = None,
        resource: DescribeInstancesResponseBodyInstancesResource = None,
        resource_group_id: str = None,
        series: str = None,
        spec_type: str = None,
        state: str = None,
        used_disk_size: int = None,
        version: str = None,
        vpc_id: str = None,
    ):
        # The information about the zone in which the cluster is deployed.
        self.available_zones = available_zones
        # The product code of the OceanBase cluster.   
        # - oceanbase_oceanbasepre_public_cn: indicates an OceanBase cluster that is billed based on the subscription plan and that is deployed in a China site.  
        # - oceanbase_oceanbasepost_public_cn: indicates an OceanBase cluster that is billed based on the pay-as-you-go plan and that is deployed in a China site.  
        # - oceanbase_obpre_public_intl: indicates an OceanBase cluster that is billed based on the subscription plan and that is deployed in an international site.
        self.commodity_code = commodity_code
        # The number of CPU cores of the cluster.
        self.cpu = cpu
        # The CPU architecture of the cluster.
        self.cpu_architecture = cpu_architecture
        # The time in UTC when the cluster was created.
        self.create_time = create_time
        # Specifies parameters for the automatic scaling of the data disk.
        self.data_disk_auto_scale_config = data_disk_auto_scale_config
        # The data replica distribution mode of the cluster. The value is in the n-n-n format, where n is the number of OBServer nodes in each IDC.
        self.deploy_mode = deploy_mode
        # The deployment type of the cluster. Valid values:   
        # - multiple: multi-IDC deployment  
        # - single: single-IDC deployment  
        # - dual: dual-IDC deployment
        self.deploy_type = deploy_type
        # The size of the storage space, in GB.
        self.disk_size = disk_size
        # The type of the storage disk where the cluster is deployed.   
        # The default value is cloud_essd_pl1, which indicates an ESSD cloud disk.
        self.disk_type = disk_type
        # Indicates whether the cluster supports read-only replicas.
        self.enable_read_only_replica_management = enable_read_only_replica_management
        # Indicates whether new nodes can be added.
        self.enable_upgrade_nodes = enable_upgrade_nodes
        # The time elapsed since the expiration of the cluster, in seconds. 
        # > In subscription mode, if the cluster has not expired, this parameter indicates the remaining validity period of the cluster. If the cluster has expired, this parameter indicates the time elapsed since the expiration.
        self.expire_seconds = expire_seconds
        # The time in UTC when the cluster expires. 
        # > This parameter is valid only for subscription instances.
        self.expire_time = expire_time
        # Specifies whether to indicate the temporary status of the capacity.
        self.in_temp_capacity_status = in_temp_capacity_status
        # The specifications of the cluster.  You can specify one of the following four plans:  
        # - 8C32G: indicates 8 CPU cores and 32 GB of memory.  
        # - 14C70G: indicates 14 CPU cores and 70 GB of memory.  
        # - 30C180G: indicates 30 CPU cores and 180 GB of memory.  
        # - 62C400G: indicates 62 CPU cores and 400 GB of memory.
        self.instance_class = instance_class
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # The name of the OceanBase cluster.
        self.instance_name = instance_name
        # The role of the instance.
        self.instance_role = instance_role
        # The instance type.
        # - cluster: indicates a cluster instance.
        # - mtenant: indicates a tenant instance in MySQL mode.
        # - mtenant_serverless: indicates a serverless instance in MySQL mode.
        self.instance_type = instance_type
        self.iops = iops
        # The time period in UTC for the daily routine maintenance of the cluster.
        self.maintain_time = maintain_time
        # The memory size of the instance, in GB.
        self.mem = mem
        self.migratable = migratable
        self.migration_info = migration_info
        # The version of the OceanBase Database RedHat Package Managerment (RPM) package.
        self.ob_rpm_version = ob_rpm_version
        # The billing method for the OceanBase cluster. Valid values:  
        # - PREPAY: the subscription billing method.  
        # - POSTPAY: the pay-as-you-go billing method.
        self.pay_type = pay_type
        self.replica_mode = replica_mode
        # The information about cluster resources.
        self.resource = resource
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The series of the OceanBase cluster. Valid values:   
        # - NORMAL: the high availability edition.   
        # - BASIC: the basic edition.
        self.series = series
        # The specification type.
        self.spec_type = spec_type
        # The status of the cluster. Valid values:   
        # - ONLINE: The cluster is running.  
        # - PENDING_CREATE: The cluster is being created.  
        # - ARREARS_CLOSED("arrears_closed"): The cluster is suspended due to insufficient balance.
        # - PREPAID_EXPIRE_CLOSED("prepaid_expire_closed"): The cluster is suspended because the subscription has expired.
        # - WHITE_LIST_MODIFYING("white_list_modifying"): The allowlist of the cluster is being modified.
        # - SSL_MODIFYING("ssl_modifying"): The Secure Sockets Layer (SSL) settings of the cluster are being modified.
        # - PARAMETER_MODIFYING("parameter_modifying"): Parameters of the cluster are being modified.
        # - TENANT_CREATING("tenant_creating"): A tenant is being created in the cluster.
        # - TENANT_SPEC_MODIFYING("tenant_spec_modifying"): The specifications of a tenant in the cluster are being modified.
        # - EXPANDING("expanding"): Nodes are being added to the cluster.
        # - REDUCING("reducing"): Nodes are being removed from the cluster.
        # - ZONE_CHANGING("zone_changing"): Zones of the cluster are being modified.
        # - SPEC_UPGRADING: The service plan is being upgraded.
        # - SPEC_DOWNGRADING("spec_downgrading"): The plan specification is being downgraded.
        # - DISK_UPGRADING: The storage space is being expanded.
        # - UPGRADING("upgrading"): The version of the cluster is being upgraded.
        # - PENDING_DELETE("pending_delete"): The cluster is being deleted.
        # - DELETED("deleted"): The cluster has been deleted.
        # - ABNORMAL("abnormal"): The cluster is abnormal.
        # - OFFLINE("offline"): The cluster is offline.
        # - STANDBY_CREATING("standby_creating"): A standby cluster is being created for the cluster.
        # - STANDBY_DELETING("standby_deleting"): A standby cluster of the cluster is being deleted.
        # - SWITCHOVER_SWITCHING("switchover_switching"): The cluster is undergoing a primary/standby switchover.
        # - STANDBY_DISCONNECTING("standby_disconnecting"): The cluster is being decoupled from its standby cluster.
        # - LOG_DISK_UPGRADING("log_disk_upgrading"): The log disk of the cluster is being scaled out.
        # - ISOLATION_OPTIMIZATION_MODIFYING("isolation_optimization_modifying"): The isolation optimization settings of the cluster are being modified.
        # - DISKTYPE_MODIFYING("disktype_modifying"): The data disk type of the cluster is being modified.
        # - PROXY_SERVICE_CREATING("proxy_service_creating"): The proxy service is being enabled for the cluster.
        # - PROXY_SERVICE_DELETING("proxy_service_deleting"): The proxy service is being disabled for the cluster.
        # - PROXY_SERVICE_SPEC_MODIFYING("proxy_service_spec_modifying"): The proxy service specification is being modified for the cluster.
        # - READONLY_ADD_NODE("readonly_add_node"): A read-only node is being added to the cluster.
        # - READONLY_REDUCE_NODE("readonly_reduce_node"): A read-only node is being removed from the cluster.
        # - READONLY_REDUCE_ZONE("readonly_reduce_zone"): A read-only zone is being removed from the cluster.
        # - READONLY_ADD_ZONE("readonly_add_zone"): A read-only zone is being added to the cluster.
        # - READONLY_UPGRADE_SPEC("readonly_upgrade_spec"): The specification of read-only replicas is being upgraded.
        # - READONLY_UPGRADE_DISK("readonly_upgrade_disk"): The disk space of read-only replicas is being scaled out.
        # - READONLY_DOWNGRADE_SPEC("readonly_downgrade_spec"): The specification of read-only replicas is being downgraded.
        # - READONLY_DOWNGRADE_DISK("readonly_downgrade_disk"): The disk space of read-only replicas is being scaled in.
        # - CREATING_TENANT_READONLY_REPLICA("creating_tenant_readonly_replica"): A read-only replica is being created for a tenant in the cluster.
        # - DELETING_TENANT_READONLY_REPLICA("deleting_tenant_readonly_replica"): A read-only replica is being deleted for a tenant in the cluster.
        # - DISK_DOWNGRADING("disk_downgrading"): The disk space of the cluster is being scaled in.
        # - DEPLOY_MODE_MODIFYING("deploy_mode_modifying"): The deployment mode of the cluster is being modified.
        # > Generally, the cluster is in the ONLINE state.
        self.state = state
        # The size of used storage space of the cluster, in GB.
        self.used_disk_size = used_disk_size
        # The OBServer version.
        self.version = version
        # vpcId
        self.vpc_id = vpc_id

    def validate(self):
        if self.data_disk_auto_scale_config:
            self.data_disk_auto_scale_config.validate()
        if self.migration_info:
            self.migration_info.validate()
        if self.resource:
            self.resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_architecture is not None:
            result['CpuArchitecture'] = self.cpu_architecture
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_disk_auto_scale_config is not None:
            result['DataDiskAutoScaleConfig'] = self.data_disk_auto_scale_config.to_map()
        if self.deploy_mode is not None:
            result['DeployMode'] = self.deploy_mode
        if self.deploy_type is not None:
            result['DeployType'] = self.deploy_type
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.enable_read_only_replica_management is not None:
            result['EnableReadOnlyReplicaManagement'] = self.enable_read_only_replica_management
        if self.enable_upgrade_nodes is not None:
            result['EnableUpgradeNodes'] = self.enable_upgrade_nodes
        if self.expire_seconds is not None:
            result['ExpireSeconds'] = self.expire_seconds
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.in_temp_capacity_status is not None:
            result['InTempCapacityStatus'] = self.in_temp_capacity_status
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_role is not None:
            result['InstanceRole'] = self.instance_role
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.maintain_time is not None:
            result['MaintainTime'] = self.maintain_time
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.migratable is not None:
            result['Migratable'] = self.migratable
        if self.migration_info is not None:
            result['MigrationInfo'] = self.migration_info.to_map()
        if self.ob_rpm_version is not None:
            result['ObRpmVersion'] = self.ob_rpm_version
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.replica_mode is not None:
            result['ReplicaMode'] = self.replica_mode
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.series is not None:
            result['Series'] = self.series
        if self.spec_type is not None:
            result['SpecType'] = self.spec_type
        if self.state is not None:
            result['State'] = self.state
        if self.used_disk_size is not None:
            result['UsedDiskSize'] = self.used_disk_size
        if self.version is not None:
            result['Version'] = self.version
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableZones') is not None:
            self.available_zones = m.get('AvailableZones')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuArchitecture') is not None:
            self.cpu_architecture = m.get('CpuArchitecture')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataDiskAutoScaleConfig') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesDataDiskAutoScaleConfig()
            self.data_disk_auto_scale_config = temp_model.from_map(m['DataDiskAutoScaleConfig'])
        if m.get('DeployMode') is not None:
            self.deploy_mode = m.get('DeployMode')
        if m.get('DeployType') is not None:
            self.deploy_type = m.get('DeployType')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('EnableReadOnlyReplicaManagement') is not None:
            self.enable_read_only_replica_management = m.get('EnableReadOnlyReplicaManagement')
        if m.get('EnableUpgradeNodes') is not None:
            self.enable_upgrade_nodes = m.get('EnableUpgradeNodes')
        if m.get('ExpireSeconds') is not None:
            self.expire_seconds = m.get('ExpireSeconds')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InTempCapacityStatus') is not None:
            self.in_temp_capacity_status = m.get('InTempCapacityStatus')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceRole') is not None:
            self.instance_role = m.get('InstanceRole')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('MaintainTime') is not None:
            self.maintain_time = m.get('MaintainTime')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Migratable') is not None:
            self.migratable = m.get('Migratable')
        if m.get('MigrationInfo') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesMigrationInfo()
            self.migration_info = temp_model.from_map(m['MigrationInfo'])
        if m.get('ObRpmVersion') is not None:
            self.ob_rpm_version = m.get('ObRpmVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('ReplicaMode') is not None:
            self.replica_mode = m.get('ReplicaMode')
        if m.get('Resource') is not None:
            temp_model = DescribeInstancesResponseBodyInstancesResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Series') is not None:
            self.series = m.get('Series')
        if m.get('SpecType') is not None:
            self.spec_type = m.get('SpecType')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UsedDiskSize') is not None:
            self.used_disk_size = m.get('UsedDiskSize')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[DescribeInstancesResponseBodyInstances] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information of the OceanBase cluster.
        self.instances = instances
        # The request ID.
        self.request_id = request_id
        # The number of OceanBase clusters queried.
        self.total_count = total_count

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetricsDataRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        group_by_labels: str = None,
        instance_id: str = None,
        labels: str = None,
        limit: str = None,
        metric_scope: str = None,
        metrics: str = None,
        replica_type: str = None,
        sort_metric_key: str = None,
        sort_order: str = None,
        start_time: str = None,
    ):
        # This parameter is required.
        self.end_time = end_time
        # This parameter is required.
        self.group_by_labels = group_by_labels
        # This parameter is required.
        self.instance_id = instance_id
        # This parameter is required.
        self.labels = labels
        self.limit = limit
        self.metric_scope = metric_scope
        # This parameter is required.
        self.metrics = metrics
        self.replica_type = replica_type
        self.sort_metric_key = sort_metric_key
        self.sort_order = sort_order
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_by_labels is not None:
            result['GroupByLabels'] = self.group_by_labels
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.labels is not None:
            result['Labels'] = self.labels
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.metric_scope is not None:
            result['MetricScope'] = self.metric_scope
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.replica_type is not None:
            result['ReplicaType'] = self.replica_type
        if self.sort_metric_key is not None:
            result['SortMetricKey'] = self.sort_metric_key
        if self.sort_order is not None:
            result['SortOrder'] = self.sort_order
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupByLabels') is not None:
            self.group_by_labels = m.get('GroupByLabels')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Labels') is not None:
            self.labels = m.get('Labels')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('MetricScope') is not None:
            self.metric_scope = m.get('MetricScope')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('ReplicaType') is not None:
            self.replica_type = m.get('ReplicaType')
        if m.get('SortMetricKey') is not None:
            self.sort_metric_key = m.get('SortMetricKey')
        if m.get('SortOrder') is not None:
            self.sort_order = m.get('SortOrder')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeMetricsDataResponseBody(TeaModel):
    def __init__(
        self,
        data: List[str] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeMetricsDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeMetricsDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeMetricsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNodeMetricsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        metrics: str = None,
        node_id_list: str = None,
        node_name: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # $.parameters[7].schema.description
        # 
        # This parameter is required.
        self.end_time = end_time
        # The list of nodes.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # $.parameters[7].schema.enumValueTitles
        # 
        # This parameter is required.
        self.metrics = metrics
        # $.parameters[10].schema.description
        self.node_id_list = node_id_list
        # $.parameters[8].schema.example
        self.node_name = node_name
        # $.parameters[6].schema.description
        self.page_number = page_number
        # The ID of the tenant.
        self.page_size = page_size
        # $.parameters[9].schema.example
        # 
        # This parameter is required.
        self.start_time = start_time
        # $.parameters[6].schema.enumValueTitles
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.metrics is not None:
            result['Metrics'] = self.metrics
        if self.node_id_list is not None:
            result['NodeIdList'] = self.node_id_list
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Metrics') is not None:
            self.metrics = m.get('Metrics')
        if m.get('NodeIdList') is not None:
            self.node_id_list = m.get('NodeIdList')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeNodeMetricsResponseBody(TeaModel):
    def __init__(
        self,
        node_metrics: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.node_metrics = node_metrics
        # You can call this operation to query the detailed metrics information of an OceanBase Database node.
        self.request_id = request_id
        # ```
        # http(s)://[Endpoint]/?Action=DescribeNodeMetrics
        # &InstanceId=ob317v4uif****\
        # &PageSize=10
        # &PageNumber=1
        # &TenantId=ob2mr3oae0****\
        # &StartTime=2021-06-13 15:40:43
        # &EndTime=2021-09-13 15:40:43
        # &Metrics=tps
        # &NodeName=i-bp16niirq4zdmgvm****\
        # &NodeIdList=["i-bp19y05uq6xpacyqnlrc","i-bp1blcr3htr3g3u2vqvu","i-bp1392ikhayhr3hi4fli"]
        # &Common request parameters
        # ```
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_metrics is not None:
            result['NodeMetrics'] = self.node_metrics
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeMetrics') is not None:
            self.node_metrics = m.get('NodeMetrics')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeNodeMetricsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNodeMetricsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNodeMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasAnomalySQLListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        current: int = None,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        filter_condition: str = None,
        instance_id: str = None,
        merge_dynamic_sql: bool = None,
        node_ip: str = None,
        page_size: int = None,
        search_key_word: str = None,
        search_param: str = None,
        search_rule: str = None,
        search_value: str = None,
        sql_id: str = None,
        sql_text_length: int = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the response. Valid values:
        # - zh: Chinese
        # - en: English
        self.accept_language = accept_language
        # The current page.
        self.current = current
        # The name of the database.
        self.db_name = db_name
        # Specifies whether the specified SQL statements are dynamic SQL statements.
        # > This parameter specifies whether the values of the `SqlId` parameter are the IDs of dynamic SQL statements.
        self.dynamic_sql = dynamic_sql
        # The end time of the monitoring data.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # All parameters are referenced by the symbol @. For a list of available parameters, refer to the returned parameters in [Query performance indicators of an SQL statement](https://en.oceanbase.com/docs/community-ocp-en-10000000000840290).
        self.filter_condition = filter_condition
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # Specifies whether to merge dynamic SQL statements in the return result. 
        # 
        # > This parameter specifies whether to aggregate the results of IN queries.
        self.merge_dynamic_sql = merge_dynamic_sql
        # The node IP.
        self.node_ip = node_ip
        # Page size.
        # - Start value: 1
        # - Default value: 1
        self.page_size = page_size
        # The search keyword.
        self.search_key_word = search_key_word
        # The search parameter.
        self.search_param = search_param
        # The search rule.   
        # Valid values: "=", ">", ">=", "<", and "<="
        self.search_rule = search_rule
        # The search value.
        self.search_value = search_value
        # SQL ID.
        self.sql_id = sql_id
        # Max length of the returned SQL text.
        self.sql_text_length = sql_text_length
        # The start time of the monitoring data.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.current is not None:
            result['Current'] = self.current
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_condition is not None:
            result['FilterCondition'] = self.filter_condition
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.merge_dynamic_sql is not None:
            result['MergeDynamicSql'] = self.merge_dynamic_sql
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.search_param is not None:
            result['SearchParam'] = self.search_param
        if self.search_rule is not None:
            result['SearchRule'] = self.search_rule
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_length is not None:
            result['SqlTextLength'] = self.sql_text_length
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterCondition') is not None:
            self.filter_condition = m.get('FilterCondition')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MergeDynamicSql') is not None:
            self.merge_dynamic_sql = m.get('MergeDynamicSql')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SearchParam') is not None:
            self.search_param = m.get('SearchParam')
        if m.get('SearchRule') is not None:
            self.search_rule = m.get('SearchRule')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextLength') is not None:
            self.sql_text_length = m.get('SqlTextLength')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasAnomalySQLListResponseBodyDataSqlList(TeaModel):
    def __init__(
        self,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_elapsed_time: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_retry_count: float = None,
        cpu_time: float = None,
        db_name: str = None,
        diag_types: List[str] = None,
        diagnosis: str = None,
        executions: float = None,
        last_executed_time: str = None,
        risk_level: str = None,
        sql_id: str = None,
        sql_text_short: str = None,
        suggestion: str = None,
        sum_db_time: float = None,
        sum_elapsed_time: str = None,
        sum_retry_count: float = None,
        user_name: str = None,
    ):
        # The average CPU time.
        self.avg_cpu_time = avg_cpu_time
        # The average DB time.
        self.avg_db_time = avg_db_time
        # The average response time.
        self.avg_elapsed_time = avg_elapsed_time
        # The average plan generation time.
        self.avg_get_plan_time = avg_get_plan_time
        # The average number of logical reads.
        self.avg_logical_reads = avg_logical_reads
        # The average number of retries.
        self.avg_retry_count = avg_retry_count
        # The total CPU time.
        self.cpu_time = cpu_time
        # The name of the database.
        self.db_name = db_name
        # The diagnostic types.
        self.diag_types = diag_types
        # The diagnostic details. 
        # 
        # > This parameter is deprecated.
        self.diagnosis = diagnosis
        # The total number of executions.
        self.executions = executions
        # The last execution time.
        self.last_executed_time = last_executed_time
        # The risk level.
        self.risk_level = risk_level
        # The ID of the SQL statement.
        self.sql_id = sql_id
        # The prefix of the SQL text.
        self.sql_text_short = sql_text_short
        # The suggestion on the suspicious SQL statement.
        self.suggestion = suggestion
        # The total DB time.
        self.sum_db_time = sum_db_time
        # The total response time.
        self.sum_elapsed_time = sum_elapsed_time
        # The total number of retries.
        self.sum_retry_count = sum_retry_count
        # The username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_retry_count is not None:
            result['AvgRetryCount'] = self.avg_retry_count
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.diag_types is not None:
            result['DiagTypes'] = self.diag_types
        if self.diagnosis is not None:
            result['Diagnosis'] = self.diagnosis
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.last_executed_time is not None:
            result['LastExecutedTime'] = self.last_executed_time
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_retry_count is not None:
            result['SumRetryCount'] = self.sum_retry_count
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgRetryCount') is not None:
            self.avg_retry_count = m.get('AvgRetryCount')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DiagTypes') is not None:
            self.diag_types = m.get('DiagTypes')
        if m.get('Diagnosis') is not None:
            self.diagnosis = m.get('Diagnosis')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('LastExecutedTime') is not None:
            self.last_executed_time = m.get('LastExecutedTime')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumRetryCount') is not None:
            self.sum_retry_count = m.get('SumRetryCount')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeOasAnomalySQLListResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_elapsed_time: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_retry_count: float = None,
        cpu_time: float = None,
        db_name: str = None,
        diag_types: List[str] = None,
        diagnosis: str = None,
        dynamic_sql: bool = None,
        executions: float = None,
        last_executed_time: str = None,
        risk_level: str = None,
        sql_id: str = None,
        sql_list: List[DescribeOasAnomalySQLListResponseBodyDataSqlList] = None,
        sql_text_short: str = None,
        suggestion: str = None,
        sum_db_time: float = None,
        sum_elapsed_time: str = None,
        sum_retry_count: float = None,
        user_name: str = None,
    ):
        # Average CPU time of the suspicious SQL.
        self.avg_cpu_time = avg_cpu_time
        # The average DB time.
        self.avg_db_time = avg_db_time
        # Average response time of the suspicious SQL.
        self.avg_elapsed_time = avg_elapsed_time
        # Average time to obtain the execution plan of the suspicious SQL.
        self.avg_get_plan_time = avg_get_plan_time
        # The average number of logical reads.
        self.avg_logical_reads = avg_logical_reads
        # The average number of retries.
        self.avg_retry_count = avg_retry_count
        # CPU time of the suspicious SQL.
        self.cpu_time = cpu_time
        # The name of the database.
        self.db_name = db_name
        # The type of the diagnosis.
        self.diag_types = diag_types
        # The details of diagnosis.
        self.diagnosis = diagnosis
        # 是否动态SQL
        self.dynamic_sql = dynamic_sql
        # Total execution count of the suspicious SQL.
        self.executions = executions
        # Last execution time of the suspicious SQL.
        self.last_executed_time = last_executed_time
        # Risk level.
        self.risk_level = risk_level
        # SQL ID.
        self.sql_id = sql_id
        # The list of SQL statements.
        self.sql_list = sql_list
        # Prefix of the SQL text.
        self.sql_text_short = sql_text_short
        # Suggestion for the suspicious SQL.
        self.suggestion = suggestion
        # The total DB time.
        self.sum_db_time = sum_db_time
        # Total response time of the suspicious SQL.
        self.sum_elapsed_time = sum_elapsed_time
        # The total number of retries.
        self.sum_retry_count = sum_retry_count
        # Username.
        self.user_name = user_name

    def validate(self):
        if self.sql_list:
            for k in self.sql_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_retry_count is not None:
            result['AvgRetryCount'] = self.avg_retry_count
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.diag_types is not None:
            result['DiagTypes'] = self.diag_types
        if self.diagnosis is not None:
            result['Diagnosis'] = self.diagnosis
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.last_executed_time is not None:
            result['LastExecutedTime'] = self.last_executed_time
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        result['SqlList'] = []
        if self.sql_list is not None:
            for k in self.sql_list:
                result['SqlList'].append(k.to_map() if k else None)
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_retry_count is not None:
            result['SumRetryCount'] = self.sum_retry_count
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgRetryCount') is not None:
            self.avg_retry_count = m.get('AvgRetryCount')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DiagTypes') is not None:
            self.diag_types = m.get('DiagTypes')
        if m.get('Diagnosis') is not None:
            self.diagnosis = m.get('Diagnosis')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('LastExecutedTime') is not None:
            self.last_executed_time = m.get('LastExecutedTime')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        self.sql_list = []
        if m.get('SqlList') is not None:
            for k in m.get('SqlList'):
                temp_model = DescribeOasAnomalySQLListResponseBodyDataSqlList()
                self.sql_list.append(temp_model.from_map(k))
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumRetryCount') is not None:
            self.sum_retry_count = m.get('SumRetryCount')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeOasAnomalySQLListResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeOasAnomalySQLListResponseBodyData] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The information about suspicious SQL statements.
        self.data = data
        # The request ID.
        self.request_id = request_id
        # The total count.
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeOasAnomalySQLListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOasAnomalySQLListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasAnomalySQLListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasAnomalySQLListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasSQLDetailsRequest(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        instance_id: str = None,
        parse_table: bool = None,
        sql_id: str = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The name of the database.
        # 
        # This parameter is required.
        self.db_name = db_name
        self.dynamic_sql = dynamic_sql
        # The end time of querying the SQL execution plan.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.parse_table = parse_table
        # SQL ID.
        # 
        # This parameter is required.
        self.sql_id = sql_id
        # The start time of querying the SQL execution plan.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.parse_table is not None:
            result['ParseTable'] = self.parse_table
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ParseTable') is not None:
            self.parse_table = m.get('ParseTable')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasSQLDetailsResponseBodyData(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        fulltext: str = None,
        statement: str = None,
        tables: List[str] = None,
        user_name: str = None,
    ):
        # The name of the database.
        self.db_name = db_name
        # SQL text.
        self.fulltext = fulltext
        # Parameterized text.
        self.statement = statement
        # The table name related to the SQL.
        self.tables = tables
        # The username.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.fulltext is not None:
            result['Fulltext'] = self.fulltext
        if self.statement is not None:
            result['Statement'] = self.statement
        if self.tables is not None:
            result['Tables'] = self.tables
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Fulltext') is not None:
            self.fulltext = m.get('Fulltext')
        if m.get('Statement') is not None:
            self.statement = m.get('Statement')
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeOasSQLDetailsResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeOasSQLDetailsResponseBodyData = None,
        request_id: str = None,
    ):
        # The list of the SQL execution plan.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeOasSQLDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOasSQLDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasSQLDetailsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasSQLDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasSQLHistoryListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        instance_id: str = None,
        node_ip: str = None,
        sql_id: str = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the response. Valid values:
        # - zh: Chinese
        # - en: English
        self.accept_language = accept_language
        # The name of the database.
        self.db_name = db_name
        # Specifies whether the SQL statement is a dynamic SQL statement.
        self.dynamic_sql = dynamic_sql
        # The end time of querying the execution history of the SQL statement.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The IP address of the node.
        self.node_ip = node_ip
        # SQL ID.
        # 
        # This parameter is required.
        self.sql_id = sql_id
        # The start time of querying the execution history of the SQL statement.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasSQLHistoryListResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_affected_rows: float = None,
        avg_application_wait_time: float = None,
        avg_block_cache_hit: float = None,
        avg_block_index_cache_hit: float = None,
        avg_bloom_filter_cache_hit: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_decode_time: float = None,
        avg_disk_reads: float = None,
        avg_elapsed_time: float = None,
        avg_execute_time: float = None,
        avg_executor_rpc_count: float = None,
        avg_expected_worker_count: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_memstore_read_rows: float = None,
        avg_net_time: float = None,
        avg_net_wait_time: float = None,
        avg_partition_count: float = None,
        avg_queue_time: float = None,
        avg_return_rows: float = None,
        avg_row_cache_hit: float = None,
        avg_rpc_count: float = None,
        avg_schedule_time: float = None,
        avg_ssstore_read_rows: float = None,
        avg_used_worker_count: float = None,
        avg_user_io_wait_time: float = None,
        avg_wait_count: float = None,
        avg_wait_time: float = None,
        db_name: str = None,
        dist_plan_percentage: float = None,
        exec_ps: float = None,
        executions: int = None,
        fail_count: int = None,
        fail_percentage: float = None,
        local_plan_percentage: float = None,
        max_affected_rows: float = None,
        max_application_wait_time: float = None,
        max_concurrency_wait_time: float = None,
        max_cpu_time: float = None,
        max_disk_reads: float = None,
        max_elapsed_time: float = None,
        max_return_rows: float = None,
        max_user_io_wait_time: float = None,
        max_wait_time: float = None,
        miss_plan_percentage: float = None,
        miss_plans: int = None,
        remote_plan_percentage: float = None,
        remote_plans: int = None,
        ret_code_4012count: int = None,
        ret_code_4013count: int = None,
        ret_code_5001count: int = None,
        ret_code_5024count: int = None,
        ret_code_5167count: int = None,
        ret_code_5217count: int = None,
        ret_code_6002count: int = None,
        retry_count: int = None,
        sqlid: str = None,
        server: str = None,
        strong_consistency_percentage: float = None,
        sum_db_time: float = None,
        sum_elapsed_time: float = None,
        sum_logical_reads: float = None,
        sum_wait_time: float = None,
        table_scan_percentage: float = None,
        timestamp: str = None,
        user_name: str = None,
        wait_event: str = None,
        weak_consistency_percentage: float = None,
    ):
        # Average updated rows during the execution period.
        self.avg_affected_rows = avg_affected_rows
        # Average Application event wait time (in milliseconds) during the client waiting period.
        self.avg_application_wait_time = avg_application_wait_time
        # Average BlockCache hit count during the execution period.
        self.avg_block_cache_hit = avg_block_cache_hit
        # Average BlockIndexCache hit count during the execution period.
        self.avg_block_index_cache_hit = avg_block_index_cache_hit
        # Average BloomFilterCache hit count during the execution period.
        self.avg_bloom_filter_cache_hit = avg_bloom_filter_cache_hit
        # Average Concurrency event wait time (in milliseconds) during the execution period.
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        # Average CPU time (in milliseconds) during the execution period.
        self.avg_cpu_time = avg_cpu_time
        # The average DB time, in milliseconds.
        self.avg_db_time = avg_db_time
        # Average syntax parsing time (in milliseconds) during the execution period.
        self.avg_decode_time = avg_decode_time
        # Average physical read count during the execution period.
        self.avg_disk_reads = avg_disk_reads
        # Average response time (in milliseconds) during the execution period.
        self.avg_elapsed_time = avg_elapsed_time
        # Average plan execution time (in milliseconds) during the execution period.
        self.avg_execute_time = avg_execute_time
        # Average number of RPC requests executed during the execution period.
        self.avg_executor_rpc_count = avg_executor_rpc_count
        # Average degree of parallelism during the execution period.
        self.avg_expected_worker_count = avg_expected_worker_count
        # Average plan generation time (in milliseconds) during the execution period.
        self.avg_get_plan_time = avg_get_plan_time
        # Average logical reads during the execution period.
        self.avg_logical_reads = avg_logical_reads
        # Average Memstore read rows during the execution period.
        self.avg_memstore_read_rows = avg_memstore_read_rows
        # Average network transmission time (in milliseconds) during the execution period.
        self.avg_net_time = avg_net_time
        # Average network enqueue time (in milliseconds) during the network waiting period.
        self.avg_net_wait_time = avg_net_wait_time
        # Average number of partition accessed during the execution period.
        self.avg_partition_count = avg_partition_count
        # Average queueing time (in milliseconds) during the execution period.
        self.avg_queue_time = avg_queue_time
        # Average number of rows returned during the execution period.
        self.avg_return_rows = avg_return_rows
        # Average RowCache hit count during the execution period.
        self.avg_row_cache_hit = avg_row_cache_hit
        # Average number of RPC sent during the execution.
        self.avg_rpc_count = avg_rpc_count
        # Average Schedule event wait time (in milliseconds) during the scheduling period.
        self.avg_schedule_time = avg_schedule_time
        # Average Ssstore read rows during the execution period.
        self.avg_ssstore_read_rows = avg_ssstore_read_rows
        # Average number of threads used of the SQL during the execution period.
        self.avg_used_worker_count = avg_used_worker_count
        # Average UserIO event wait time (in milliseconds) during the execution period.
        self.avg_user_io_wait_time = avg_user_io_wait_time
        # Average number of waits during the execution period.
        self.avg_wait_count = avg_wait_count
        # Average wait time (in milliseconds) during the execution period.
        self.avg_wait_time = avg_wait_time
        # The name of the database.
        self.db_name = db_name
        # Distributed plan percentage during the execution period.
        self.dist_plan_percentage = dist_plan_percentage
        # Average execution count per second during the execution period.
        self.exec_ps = exec_ps
        # Total number of executions during the execution period.
        self.executions = executions
        # The total number of errors during the execution period.
        self.fail_count = fail_count
        # Error percentage during the execution period.
        self.fail_percentage = fail_percentage
        # Local plan percentage during the execution period.
        self.local_plan_percentage = local_plan_percentage
        # Max updated rows during the execution period.
        self.max_affected_rows = max_affected_rows
        # Max Application event wait time (in milliseconds) during the execution period
        self.max_application_wait_time = max_application_wait_time
        # Max Concurrency event wait time (in milliseconds) during the execution period
        self.max_concurrency_wait_time = max_concurrency_wait_time
        # Max CPU time.
        self.max_cpu_time = max_cpu_time
        # Max physical read count during the execution period.
        self.max_disk_reads = max_disk_reads
        # Max response time.
        self.max_elapsed_time = max_elapsed_time
        # Max returned rows during the execution period.
        self.max_return_rows = max_return_rows
        # Max UserIO event wait time (in milliseconds) during the execution period
        self.max_user_io_wait_time = max_user_io_wait_time
        # Max wait time (in milliseconds) during the execution period.
        self.max_wait_time = max_wait_time
        # Plan hit rage during the execution period.
        self.miss_plan_percentage = miss_plan_percentage
        # Missed plan count.
        self.miss_plans = miss_plans
        # Remote plan percentage during the execution period.
        self.remote_plan_percentage = remote_plan_percentage
        # Remote plan count.
        self.remote_plans = remote_plans
        # Number of occurrences of code 4012 during the execution period.
        self.ret_code_4012count = ret_code_4012count
        # Number of occurrences of code 4013 during the execution period.
        self.ret_code_4013count = ret_code_4013count
        # Number of occurrences of code 5001 during the execution period.
        self.ret_code_5001count = ret_code_5001count
        # Number of occurrences of code 5024 during the execution period.
        self.ret_code_5024count = ret_code_5024count
        # Number of occurrences of code 5167 during the execution period.
        self.ret_code_5167count = ret_code_5167count
        # Number of occurrences of code 5217 during the execution period.
        self.ret_code_5217count = ret_code_5217count
        # Number of occurrences of code 6002 during the execution period.
        self.ret_code_6002count = ret_code_6002count
        # Total number of retries during the execution period.
        self.retry_count = retry_count
        # SQL ID.
        self.sqlid = sqlid
        # The server where the SQL is executed.
        self.server = server
        # Strong consistent transaction percentage during the execution period.
        self.strong_consistency_percentage = strong_consistency_percentage
        # The total DB time, in milliseconds.
        self.sum_db_time = sum_db_time
        # Total response time (in milliseconds) during the execution period.
        self.sum_elapsed_time = sum_elapsed_time
        # Total logical reads.
        self.sum_logical_reads = sum_logical_reads
        # The total wait time (in milliseconds) during the internal waiting period.
        self.sum_wait_time = sum_wait_time
        # Table scan percentage during the execution period.
        self.table_scan_percentage = table_scan_percentage
        # Timestamp for the sample.
        self.timestamp = timestamp
        # Username.
        self.user_name = user_name
        # The wait event.
        self.wait_event = wait_event
        # Eventually consistent transaction percentage during the execution period.
        self.weak_consistency_percentage = weak_consistency_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_affected_rows is not None:
            result['AvgAffectedRows'] = self.avg_affected_rows
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_block_cache_hit is not None:
            result['AvgBlockCacheHit'] = self.avg_block_cache_hit
        if self.avg_block_index_cache_hit is not None:
            result['AvgBlockIndexCacheHit'] = self.avg_block_index_cache_hit
        if self.avg_bloom_filter_cache_hit is not None:
            result['AvgBloomFilterCacheHit'] = self.avg_bloom_filter_cache_hit
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_decode_time is not None:
            result['AvgDecodeTime'] = self.avg_decode_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_execute_time is not None:
            result['AvgExecuteTime'] = self.avg_execute_time
        if self.avg_executor_rpc_count is not None:
            result['AvgExecutorRpcCount'] = self.avg_executor_rpc_count
        if self.avg_expected_worker_count is not None:
            result['AvgExpectedWorkerCount'] = self.avg_expected_worker_count
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_memstore_read_rows is not None:
            result['AvgMemstoreReadRows'] = self.avg_memstore_read_rows
        if self.avg_net_time is not None:
            result['AvgNetTime'] = self.avg_net_time
        if self.avg_net_wait_time is not None:
            result['AvgNetWaitTime'] = self.avg_net_wait_time
        if self.avg_partition_count is not None:
            result['AvgPartitionCount'] = self.avg_partition_count
        if self.avg_queue_time is not None:
            result['AvgQueueTime'] = self.avg_queue_time
        if self.avg_return_rows is not None:
            result['AvgReturnRows'] = self.avg_return_rows
        if self.avg_row_cache_hit is not None:
            result['AvgRowCacheHit'] = self.avg_row_cache_hit
        if self.avg_rpc_count is not None:
            result['AvgRpcCount'] = self.avg_rpc_count
        if self.avg_schedule_time is not None:
            result['AvgScheduleTime'] = self.avg_schedule_time
        if self.avg_ssstore_read_rows is not None:
            result['AvgSsstoreReadRows'] = self.avg_ssstore_read_rows
        if self.avg_used_worker_count is not None:
            result['AvgUsedWorkerCount'] = self.avg_used_worker_count
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.avg_wait_count is not None:
            result['AvgWaitCount'] = self.avg_wait_count
        if self.avg_wait_time is not None:
            result['AvgWaitTime'] = self.avg_wait_time
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dist_plan_percentage is not None:
            result['DistPlanPercentage'] = self.dist_plan_percentage
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.fail_percentage is not None:
            result['FailPercentage'] = self.fail_percentage
        if self.local_plan_percentage is not None:
            result['LocalPlanPercentage'] = self.local_plan_percentage
        if self.max_affected_rows is not None:
            result['MaxAffectedRows'] = self.max_affected_rows
        if self.max_application_wait_time is not None:
            result['MaxApplicationWaitTime'] = self.max_application_wait_time
        if self.max_concurrency_wait_time is not None:
            result['MaxConcurrencyWaitTime'] = self.max_concurrency_wait_time
        if self.max_cpu_time is not None:
            result['MaxCpuTime'] = self.max_cpu_time
        if self.max_disk_reads is not None:
            result['MaxDiskReads'] = self.max_disk_reads
        if self.max_elapsed_time is not None:
            result['MaxElapsedTime'] = self.max_elapsed_time
        if self.max_return_rows is not None:
            result['MaxReturnRows'] = self.max_return_rows
        if self.max_user_io_wait_time is not None:
            result['MaxUserIoWaitTime'] = self.max_user_io_wait_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.miss_plan_percentage is not None:
            result['MissPlanPercentage'] = self.miss_plan_percentage
        if self.miss_plans is not None:
            result['MissPlans'] = self.miss_plans
        if self.remote_plan_percentage is not None:
            result['RemotePlanPercentage'] = self.remote_plan_percentage
        if self.remote_plans is not None:
            result['RemotePlans'] = self.remote_plans
        if self.ret_code_4012count is not None:
            result['RetCode4012Count'] = self.ret_code_4012count
        if self.ret_code_4013count is not None:
            result['RetCode4013Count'] = self.ret_code_4013count
        if self.ret_code_5001count is not None:
            result['RetCode5001Count'] = self.ret_code_5001count
        if self.ret_code_5024count is not None:
            result['RetCode5024Count'] = self.ret_code_5024count
        if self.ret_code_5167count is not None:
            result['RetCode5167Count'] = self.ret_code_5167count
        if self.ret_code_5217count is not None:
            result['RetCode5217Count'] = self.ret_code_5217count
        if self.ret_code_6002count is not None:
            result['RetCode6002Count'] = self.ret_code_6002count
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.sqlid is not None:
            result['SQLId'] = self.sqlid
        if self.server is not None:
            result['Server'] = self.server
        if self.strong_consistency_percentage is not None:
            result['StrongConsistencyPercentage'] = self.strong_consistency_percentage
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_logical_reads is not None:
            result['SumLogicalReads'] = self.sum_logical_reads
        if self.sum_wait_time is not None:
            result['SumWaitTime'] = self.sum_wait_time
        if self.table_scan_percentage is not None:
            result['TableScanPercentage'] = self.table_scan_percentage
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.wait_event is not None:
            result['WaitEvent'] = self.wait_event
        if self.weak_consistency_percentage is not None:
            result['WeakConsistencyPercentage'] = self.weak_consistency_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgAffectedRows') is not None:
            self.avg_affected_rows = m.get('AvgAffectedRows')
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBlockCacheHit') is not None:
            self.avg_block_cache_hit = m.get('AvgBlockCacheHit')
        if m.get('AvgBlockIndexCacheHit') is not None:
            self.avg_block_index_cache_hit = m.get('AvgBlockIndexCacheHit')
        if m.get('AvgBloomFilterCacheHit') is not None:
            self.avg_bloom_filter_cache_hit = m.get('AvgBloomFilterCacheHit')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgDecodeTime') is not None:
            self.avg_decode_time = m.get('AvgDecodeTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgExecuteTime') is not None:
            self.avg_execute_time = m.get('AvgExecuteTime')
        if m.get('AvgExecutorRpcCount') is not None:
            self.avg_executor_rpc_count = m.get('AvgExecutorRpcCount')
        if m.get('AvgExpectedWorkerCount') is not None:
            self.avg_expected_worker_count = m.get('AvgExpectedWorkerCount')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgMemstoreReadRows') is not None:
            self.avg_memstore_read_rows = m.get('AvgMemstoreReadRows')
        if m.get('AvgNetTime') is not None:
            self.avg_net_time = m.get('AvgNetTime')
        if m.get('AvgNetWaitTime') is not None:
            self.avg_net_wait_time = m.get('AvgNetWaitTime')
        if m.get('AvgPartitionCount') is not None:
            self.avg_partition_count = m.get('AvgPartitionCount')
        if m.get('AvgQueueTime') is not None:
            self.avg_queue_time = m.get('AvgQueueTime')
        if m.get('AvgReturnRows') is not None:
            self.avg_return_rows = m.get('AvgReturnRows')
        if m.get('AvgRowCacheHit') is not None:
            self.avg_row_cache_hit = m.get('AvgRowCacheHit')
        if m.get('AvgRpcCount') is not None:
            self.avg_rpc_count = m.get('AvgRpcCount')
        if m.get('AvgScheduleTime') is not None:
            self.avg_schedule_time = m.get('AvgScheduleTime')
        if m.get('AvgSsstoreReadRows') is not None:
            self.avg_ssstore_read_rows = m.get('AvgSsstoreReadRows')
        if m.get('AvgUsedWorkerCount') is not None:
            self.avg_used_worker_count = m.get('AvgUsedWorkerCount')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('AvgWaitCount') is not None:
            self.avg_wait_count = m.get('AvgWaitCount')
        if m.get('AvgWaitTime') is not None:
            self.avg_wait_time = m.get('AvgWaitTime')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DistPlanPercentage') is not None:
            self.dist_plan_percentage = m.get('DistPlanPercentage')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('FailPercentage') is not None:
            self.fail_percentage = m.get('FailPercentage')
        if m.get('LocalPlanPercentage') is not None:
            self.local_plan_percentage = m.get('LocalPlanPercentage')
        if m.get('MaxAffectedRows') is not None:
            self.max_affected_rows = m.get('MaxAffectedRows')
        if m.get('MaxApplicationWaitTime') is not None:
            self.max_application_wait_time = m.get('MaxApplicationWaitTime')
        if m.get('MaxConcurrencyWaitTime') is not None:
            self.max_concurrency_wait_time = m.get('MaxConcurrencyWaitTime')
        if m.get('MaxCpuTime') is not None:
            self.max_cpu_time = m.get('MaxCpuTime')
        if m.get('MaxDiskReads') is not None:
            self.max_disk_reads = m.get('MaxDiskReads')
        if m.get('MaxElapsedTime') is not None:
            self.max_elapsed_time = m.get('MaxElapsedTime')
        if m.get('MaxReturnRows') is not None:
            self.max_return_rows = m.get('MaxReturnRows')
        if m.get('MaxUserIoWaitTime') is not None:
            self.max_user_io_wait_time = m.get('MaxUserIoWaitTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MissPlanPercentage') is not None:
            self.miss_plan_percentage = m.get('MissPlanPercentage')
        if m.get('MissPlans') is not None:
            self.miss_plans = m.get('MissPlans')
        if m.get('RemotePlanPercentage') is not None:
            self.remote_plan_percentage = m.get('RemotePlanPercentage')
        if m.get('RemotePlans') is not None:
            self.remote_plans = m.get('RemotePlans')
        if m.get('RetCode4012Count') is not None:
            self.ret_code_4012count = m.get('RetCode4012Count')
        if m.get('RetCode4013Count') is not None:
            self.ret_code_4013count = m.get('RetCode4013Count')
        if m.get('RetCode5001Count') is not None:
            self.ret_code_5001count = m.get('RetCode5001Count')
        if m.get('RetCode5024Count') is not None:
            self.ret_code_5024count = m.get('RetCode5024Count')
        if m.get('RetCode5167Count') is not None:
            self.ret_code_5167count = m.get('RetCode5167Count')
        if m.get('RetCode5217Count') is not None:
            self.ret_code_5217count = m.get('RetCode5217Count')
        if m.get('RetCode6002Count') is not None:
            self.ret_code_6002count = m.get('RetCode6002Count')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('SQLId') is not None:
            self.sqlid = m.get('SQLId')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('StrongConsistencyPercentage') is not None:
            self.strong_consistency_percentage = m.get('StrongConsistencyPercentage')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumLogicalReads') is not None:
            self.sum_logical_reads = m.get('SumLogicalReads')
        if m.get('SumWaitTime') is not None:
            self.sum_wait_time = m.get('SumWaitTime')
        if m.get('TableScanPercentage') is not None:
            self.table_scan_percentage = m.get('TableScanPercentage')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('WaitEvent') is not None:
            self.wait_event = m.get('WaitEvent')
        if m.get('WeakConsistencyPercentage') is not None:
            self.weak_consistency_percentage = m.get('WeakConsistencyPercentage')
        return self


class DescribeOasSQLHistoryListResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeOasSQLHistoryListResponseBodyData] = None,
        request_id: str = None,
    ):
        # The list of SQL execution history.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeOasSQLHistoryListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOasSQLHistoryListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasSQLHistoryListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasSQLHistoryListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasSQLPlansRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        instance_id: str = None,
        plan_union_hash: str = None,
        return_brief_info: bool = None,
        sql_id: str = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # Supported language. Valid values:
        # - zh-CN: Chinese
        # - en-US: English
        self.accept_language = accept_language
        # The name of the database.
        # 
        # This parameter is required.
        self.db_name = db_name
        # Specifies whether the SQL statement is dynamic.
        self.dynamic_sql = dynamic_sql
        # The end time of querying the SQL execution plan.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The unique identifier of the execution plan.
        self.plan_union_hash = plan_union_hash
        # Specifies whether to return an overview of the execution plan.
        self.return_brief_info = return_brief_info
        # SQL ID.
        # 
        # This parameter is required.
        self.sql_id = sql_id
        # The start time of querying the SQL execution plan.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.plan_union_hash is not None:
            result['PlanUnionHash'] = self.plan_union_hash
        if self.return_brief_info is not None:
            result['ReturnBriefInfo'] = self.return_brief_info
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PlanUnionHash') is not None:
            self.plan_union_hash = m.get('PlanUnionHash')
        if m.get('ReturnBriefInfo') is not None:
            self.return_brief_info = m.get('ReturnBriefInfo')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasSQLPlansResponseBodyDataPlanExplain(TeaModel):
    def __init__(
        self,
        plan_json_string: str = None,
    ):
        # JSON string of the SQL execution plan.
        self.plan_json_string = plan_json_string

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.plan_json_string is not None:
            result['PlanJsonString'] = self.plan_json_string
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PlanJsonString') is not None:
            self.plan_json_string = m.get('PlanJsonString')
        return self


class DescribeOasSQLPlansResponseBodyDataPlans(TeaModel):
    def __init__(
        self,
        avg_application_wait_time: float = None,
        avg_buffer_gets: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_disk_reads: float = None,
        avg_disk_writes: float = None,
        avg_elapsed_time: float = None,
        avg_row_processed: float = None,
        avg_user_io_wait_time: float = None,
        collect_time_us: int = None,
        delayed_large_query_percentage: float = None,
        exec_ps: float = None,
        executions: int = None,
        first_load_time: str = None,
        first_load_time_us: int = None,
        hit_diagnosis: bool = None,
        hit_percentage: float = None,
        large_query_percentage: float = None,
        merged_version: int = None,
        ob_db_id: int = None,
        ob_server_id: int = None,
        outline_data: str = None,
        outline_id: int = None,
        plan_hash: str = None,
        plan_id: int = None,
        plan_size: int = None,
        plan_type: str = None,
        plan_union_hash: str = None,
        schema_version: int = None,
        server: str = None,
        server_id: int = None,
        sql_id: str = None,
        sql_text: str = None,
        table_scan: bool = None,
        timeout_percentage: float = None,
        uid: str = None,
    ):
        # Average Application event waiting time (in milliseconds) during the execution period.
        self.avg_application_wait_time = avg_application_wait_time
        # Average cache read count during the execution period.
        self.avg_buffer_gets = avg_buffer_gets
        # Average Concurrency event waiting time (in milliseconds) during the execution period.
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        # Average CPU time (in milliseconds) during the execution period.
        self.avg_cpu_time = avg_cpu_time
        # The average physical read count during the execution period.
        self.avg_disk_reads = avg_disk_reads
        # The average physical write count during the execution period.
        self.avg_disk_writes = avg_disk_writes
        # Average interval waiting time (in milliseconds) during the execution period.
        self.avg_elapsed_time = avg_elapsed_time
        # Average row processing waiting time (in milliseconds) during the execution period.
        self.avg_row_processed = avg_row_processed
        # Average UserIo event waiting time (in milliseconds) during the execution period.
        self.avg_user_io_wait_time = avg_user_io_wait_time
        # Collection time.
        self.collect_time_us = collect_time_us
        # Percentage of delayed long-running queries.
        self.delayed_large_query_percentage = delayed_large_query_percentage
        # The average execution count per second during the execution period.
        self.exec_ps = exec_ps
        # The total number of executions during the execution period.
        self.executions = executions
        # First time to load the plan.
        self.first_load_time = first_load_time
        # First loading time.
        self.first_load_time_us = first_load_time_us
        # Whether to hit the diagnosis.
        self.hit_diagnosis = hit_diagnosis
        # Hit rate.
        self.hit_percentage = hit_percentage
        # Percentage of completed long-running queries.
        self.large_query_percentage = large_query_percentage
        # Merge version.
        self.merged_version = merged_version
        # Database ID.
        self.ob_db_id = ob_db_id
        # Server ID.
        self.ob_server_id = ob_server_id
        # The outline_data parameter of the SQL execution plan.
        self.outline_data = outline_data
        # Outline ID.
        self.outline_id = outline_id
        # The internal identifier of the SQL execution plan in the diagnostic system.
        self.plan_hash = plan_hash
        # The ID of the plan.
        self.plan_id = plan_id
        # Plan size.
        self.plan_size = plan_size
        # Plan type, including LOCAL, REMOTE, DIST.
        self.plan_type = plan_type
        # The internal unique identifier of the SQL execution plan in the diagnostic system.
        self.plan_union_hash = plan_union_hash
        # Schema version.
        self.schema_version = schema_version
        # The server where the SQL is executed.
        self.server = server
        # The ID of the backend server instance.
        self.server_id = server_id
        # SQL ID.
        self.sql_id = sql_id
        self.sql_text = sql_text
        # Whether a full table scan is performed.
        self.table_scan = table_scan
        # Percentage of timeouts.
        self.timeout_percentage = timeout_percentage
        # The unique identifier of the plan.
        self.uid = uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_buffer_gets is not None:
            result['AvgBufferGets'] = self.avg_buffer_gets
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_disk_writes is not None:
            result['AvgDiskWrites'] = self.avg_disk_writes
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_row_processed is not None:
            result['AvgRowProcessed'] = self.avg_row_processed
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.collect_time_us is not None:
            result['CollectTimeUs'] = self.collect_time_us
        if self.delayed_large_query_percentage is not None:
            result['DelayedLargeQueryPercentage'] = self.delayed_large_query_percentage
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.first_load_time is not None:
            result['FirstLoadTime'] = self.first_load_time
        if self.first_load_time_us is not None:
            result['FirstLoadTimeUs'] = self.first_load_time_us
        if self.hit_diagnosis is not None:
            result['HitDiagnosis'] = self.hit_diagnosis
        if self.hit_percentage is not None:
            result['HitPercentage'] = self.hit_percentage
        if self.large_query_percentage is not None:
            result['LargeQueryPercentage'] = self.large_query_percentage
        if self.merged_version is not None:
            result['MergedVersion'] = self.merged_version
        if self.ob_db_id is not None:
            result['ObDbId'] = self.ob_db_id
        if self.ob_server_id is not None:
            result['ObServerId'] = self.ob_server_id
        if self.outline_data is not None:
            result['OutlineData'] = self.outline_data
        if self.outline_id is not None:
            result['OutlineId'] = self.outline_id
        if self.plan_hash is not None:
            result['PlanHash'] = self.plan_hash
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.plan_size is not None:
            result['PlanSize'] = self.plan_size
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        if self.plan_union_hash is not None:
            result['PlanUnionHash'] = self.plan_union_hash
        if self.schema_version is not None:
            result['SchemaVersion'] = self.schema_version
        if self.server is not None:
            result['Server'] = self.server
        if self.server_id is not None:
            result['ServerId'] = self.server_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.table_scan is not None:
            result['TableScan'] = self.table_scan
        if self.timeout_percentage is not None:
            result['TimeoutPercentage'] = self.timeout_percentage
        if self.uid is not None:
            result['Uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBufferGets') is not None:
            self.avg_buffer_gets = m.get('AvgBufferGets')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgDiskWrites') is not None:
            self.avg_disk_writes = m.get('AvgDiskWrites')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgRowProcessed') is not None:
            self.avg_row_processed = m.get('AvgRowProcessed')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('CollectTimeUs') is not None:
            self.collect_time_us = m.get('CollectTimeUs')
        if m.get('DelayedLargeQueryPercentage') is not None:
            self.delayed_large_query_percentage = m.get('DelayedLargeQueryPercentage')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FirstLoadTime') is not None:
            self.first_load_time = m.get('FirstLoadTime')
        if m.get('FirstLoadTimeUs') is not None:
            self.first_load_time_us = m.get('FirstLoadTimeUs')
        if m.get('HitDiagnosis') is not None:
            self.hit_diagnosis = m.get('HitDiagnosis')
        if m.get('HitPercentage') is not None:
            self.hit_percentage = m.get('HitPercentage')
        if m.get('LargeQueryPercentage') is not None:
            self.large_query_percentage = m.get('LargeQueryPercentage')
        if m.get('MergedVersion') is not None:
            self.merged_version = m.get('MergedVersion')
        if m.get('ObDbId') is not None:
            self.ob_db_id = m.get('ObDbId')
        if m.get('ObServerId') is not None:
            self.ob_server_id = m.get('ObServerId')
        if m.get('OutlineData') is not None:
            self.outline_data = m.get('OutlineData')
        if m.get('OutlineId') is not None:
            self.outline_id = m.get('OutlineId')
        if m.get('PlanHash') is not None:
            self.plan_hash = m.get('PlanHash')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('PlanSize') is not None:
            self.plan_size = m.get('PlanSize')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        if m.get('PlanUnionHash') is not None:
            self.plan_union_hash = m.get('PlanUnionHash')
        if m.get('SchemaVersion') is not None:
            self.schema_version = m.get('SchemaVersion')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('ServerId') is not None:
            self.server_id = m.get('ServerId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('TableScan') is not None:
            self.table_scan = m.get('TableScan')
        if m.get('TimeoutPercentage') is not None:
            self.timeout_percentage = m.get('TimeoutPercentage')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        return self


class DescribeOasSQLPlansResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_cpu_time: float = None,
        bounded: bool = None,
        executions: int = None,
        first_load_time: str = None,
        hit_diagnosis: bool = None,
        hit_percentage: float = None,
        merged_version: int = None,
        outline_id: str = None,
        outline_status: str = None,
        plan_explain: DescribeOasSQLPlansResponseBodyDataPlanExplain = None,
        plan_hash: str = None,
        plan_type: str = None,
        plan_union_hash: str = None,
        plans: List[DescribeOasSQLPlansResponseBodyDataPlans] = None,
        query_sql: str = None,
        table_scan: bool = None,
    ):
        # Average CPU time (in milliseconds) during the execution period.
        self.avg_cpu_time = avg_cpu_time
        # Whether to bind the execution plan.
        self.bounded = bounded
        # Execution count.
        self.executions = executions
        # First loading time.
        self.first_load_time = first_load_time
        # Whether to hit the diagnosis.
        self.hit_diagnosis = hit_diagnosis
        # Hit rate.
        self.hit_percentage = hit_percentage
        # Merge version.
        self.merged_version = merged_version
        # The ID of the outline used by the execution plan.
        self.outline_id = outline_id
        # The outline status of the execution plan. Valid values:
        # * **Effective**: indicates that the outline_data and outlIne_content fields exactly match with each other. 
        # * **Unknown**: indicates that the outline status is unknown.
        self.outline_status = outline_status
        # Execution plan.
        self.plan_explain = plan_explain
        # The internal identifier of the SQL execution plan in the diagnostic system.
        self.plan_hash = plan_hash
        # Execution plan type.
        self.plan_type = plan_type
        # The internal unique identifier of the SQL execution plan in the diagnostic system.
        self.plan_union_hash = plan_union_hash
        # The list of the execution plan.
        self.plans = plans
        # The SQL for the query.
        self.query_sql = query_sql
        # Indicates whether full table scan is performed.
        self.table_scan = table_scan

    def validate(self):
        if self.plan_explain:
            self.plan_explain.validate()
        if self.plans:
            for k in self.plans:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.bounded is not None:
            result['Bounded'] = self.bounded
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.first_load_time is not None:
            result['FirstLoadTime'] = self.first_load_time
        if self.hit_diagnosis is not None:
            result['HitDiagnosis'] = self.hit_diagnosis
        if self.hit_percentage is not None:
            result['HitPercentage'] = self.hit_percentage
        if self.merged_version is not None:
            result['MergedVersion'] = self.merged_version
        if self.outline_id is not None:
            result['OutlineId'] = self.outline_id
        if self.outline_status is not None:
            result['OutlineStatus'] = self.outline_status
        if self.plan_explain is not None:
            result['PlanExplain'] = self.plan_explain.to_map()
        if self.plan_hash is not None:
            result['PlanHash'] = self.plan_hash
        if self.plan_type is not None:
            result['PlanType'] = self.plan_type
        if self.plan_union_hash is not None:
            result['PlanUnionHash'] = self.plan_union_hash
        result['Plans'] = []
        if self.plans is not None:
            for k in self.plans:
                result['Plans'].append(k.to_map() if k else None)
        if self.query_sql is not None:
            result['QuerySql'] = self.query_sql
        if self.table_scan is not None:
            result['TableScan'] = self.table_scan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('Bounded') is not None:
            self.bounded = m.get('Bounded')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FirstLoadTime') is not None:
            self.first_load_time = m.get('FirstLoadTime')
        if m.get('HitDiagnosis') is not None:
            self.hit_diagnosis = m.get('HitDiagnosis')
        if m.get('HitPercentage') is not None:
            self.hit_percentage = m.get('HitPercentage')
        if m.get('MergedVersion') is not None:
            self.merged_version = m.get('MergedVersion')
        if m.get('OutlineId') is not None:
            self.outline_id = m.get('OutlineId')
        if m.get('OutlineStatus') is not None:
            self.outline_status = m.get('OutlineStatus')
        if m.get('PlanExplain') is not None:
            temp_model = DescribeOasSQLPlansResponseBodyDataPlanExplain()
            self.plan_explain = temp_model.from_map(m['PlanExplain'])
        if m.get('PlanHash') is not None:
            self.plan_hash = m.get('PlanHash')
        if m.get('PlanType') is not None:
            self.plan_type = m.get('PlanType')
        if m.get('PlanUnionHash') is not None:
            self.plan_union_hash = m.get('PlanUnionHash')
        self.plans = []
        if m.get('Plans') is not None:
            for k in m.get('Plans'):
                temp_model = DescribeOasSQLPlansResponseBodyDataPlans()
                self.plans.append(temp_model.from_map(k))
        if m.get('QuerySql') is not None:
            self.query_sql = m.get('QuerySql')
        if m.get('TableScan') is not None:
            self.table_scan = m.get('TableScan')
        return self


class DescribeOasSQLPlansResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeOasSQLPlansResponseBodyData] = None,
        request_id: str = None,
    ):
        # The list of SQL execution plan.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeOasSQLPlansResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOasSQLPlansResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasSQLPlansResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasSQLPlansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasSlowSQLListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        filter_condition: str = None,
        instance_id: str = None,
        merge_dynamic_sql: bool = None,
        node_ip: str = None,
        search_key_word: str = None,
        search_param: str = None,
        search_rule: str = None,
        search_value: str = None,
        sql_id: str = None,
        sql_text_length: int = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the response.
        self.accept_language = accept_language
        # The name of the database.
        self.db_name = db_name
        self.dynamic_sql = dynamic_sql
        # The end time of querying slow SQL historical parameters.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # All parameters are referenced by the symbol @. For a list of available parameters, refer to the returned parameters in [Query performance indicators of an SQL statement](https://en.oceanbase.com/docs/community-ocp-en-10000000000840290).
        self.filter_condition = filter_condition
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.merge_dynamic_sql = merge_dynamic_sql
        # The IP of the database node.
        self.node_ip = node_ip
        # The search keyword.
        self.search_key_word = search_key_word
        # The search parameter.
        self.search_param = search_param
        # The search rule.
        self.search_rule = search_rule
        # The search value.
        self.search_value = search_value
        # SQL ID, the unique identifier of the SQL.
        self.sql_id = sql_id
        # Max length of the returned SQL text.
        self.sql_text_length = sql_text_length
        # The start time of querying slow SQL historical parameters.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_condition is not None:
            result['FilterCondition'] = self.filter_condition
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.merge_dynamic_sql is not None:
            result['MergeDynamicSql'] = self.merge_dynamic_sql
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.search_param is not None:
            result['SearchParam'] = self.search_param
        if self.search_rule is not None:
            result['SearchRule'] = self.search_rule
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_length is not None:
            result['SqlTextLength'] = self.sql_text_length
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterCondition') is not None:
            self.filter_condition = m.get('FilterCondition')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MergeDynamicSql') is not None:
            self.merge_dynamic_sql = m.get('MergeDynamicSql')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SearchParam') is not None:
            self.search_param = m.get('SearchParam')
        if m.get('SearchRule') is not None:
            self.search_rule = m.get('SearchRule')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextLength') is not None:
            self.sql_text_length = m.get('SqlTextLength')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasSlowSQLListResponseBodyDataSqlList(TeaModel):
    def __init__(
        self,
        avg_affected_rows: float = None,
        avg_application_wait_time: float = None,
        avg_block_cache_hit: float = None,
        avg_block_index_cache_hit: float = None,
        avg_bloom_filter_cache_hit: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_decode_time: float = None,
        avg_disk_reads: float = None,
        avg_elapsed_time: float = None,
        avg_execute_time: float = None,
        avg_executor_rpc_count: float = None,
        avg_expected_worker_count: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_memstore_read_rows: float = None,
        avg_net_time: float = None,
        avg_net_wait_time: float = None,
        avg_partition_count: float = None,
        avg_queue_time: float = None,
        avg_return_rows: float = None,
        avg_row_cache_hit: float = None,
        avg_rpc_count: float = None,
        avg_schedule_time: float = None,
        avg_ssstore_read_rows: float = None,
        avg_used_worker_count: float = None,
        avg_user_io_wait_time: float = None,
        avg_wait_count: float = None,
        avg_wait_time: float = None,
        client_ip: str = None,
        db_name: str = None,
        dist_plan_percentage: float = None,
        exec_ps: float = None,
        executions: int = None,
        fail_count: int = None,
        fail_percentage: float = None,
        inner: bool = None,
        local_plan_percentage: float = None,
        max_affected_rows: float = None,
        max_application_wait_time: float = None,
        max_concurrency_wait_time: float = None,
        max_cpu_time: float = None,
        max_disk_reads: float = None,
        max_elapsed_time: float = None,
        max_return_rows: float = None,
        max_user_io_wait_time: float = None,
        max_wait_time: float = None,
        miss_plan_percentage: float = None,
        miss_plans: int = None,
        remote_plan_percentage: float = None,
        remote_plans: int = None,
        ret_code_4012count: int = None,
        ret_code_4013count: int = None,
        ret_code_5001count: int = None,
        ret_code_5024count: int = None,
        ret_code_5167count: int = None,
        ret_code_5217count: int = None,
        ret_code_6002count: int = None,
        retry_count: int = None,
        rpc_count: float = None,
        server: str = None,
        server_ip: str = None,
        server_port: int = None,
        sql_id: str = None,
        sql_text_short: str = None,
        sql_type: str = None,
        strong_consistency_percentage: float = None,
        sum_db_time: float = None,
        sum_elapsed_time: float = None,
        sum_logical_reads: float = None,
        sum_wait_time: float = None,
        table_scan_percentage: float = None,
        total_wait_time: float = None,
        user_name: str = None,
        wait_event: str = None,
        weak_consistency_percentage: float = None,
    ):
        self.avg_affected_rows = avg_affected_rows
        self.avg_application_wait_time = avg_application_wait_time
        self.avg_block_cache_hit = avg_block_cache_hit
        self.avg_block_index_cache_hit = avg_block_index_cache_hit
        self.avg_bloom_filter_cache_hit = avg_bloom_filter_cache_hit
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        self.avg_cpu_time = avg_cpu_time
        self.avg_db_time = avg_db_time
        self.avg_decode_time = avg_decode_time
        self.avg_disk_reads = avg_disk_reads
        self.avg_elapsed_time = avg_elapsed_time
        self.avg_execute_time = avg_execute_time
        self.avg_executor_rpc_count = avg_executor_rpc_count
        self.avg_expected_worker_count = avg_expected_worker_count
        self.avg_get_plan_time = avg_get_plan_time
        self.avg_logical_reads = avg_logical_reads
        self.avg_memstore_read_rows = avg_memstore_read_rows
        self.avg_net_time = avg_net_time
        self.avg_net_wait_time = avg_net_wait_time
        self.avg_partition_count = avg_partition_count
        self.avg_queue_time = avg_queue_time
        self.avg_return_rows = avg_return_rows
        self.avg_row_cache_hit = avg_row_cache_hit
        self.avg_rpc_count = avg_rpc_count
        self.avg_schedule_time = avg_schedule_time
        self.avg_ssstore_read_rows = avg_ssstore_read_rows
        self.avg_used_worker_count = avg_used_worker_count
        self.avg_user_io_wait_time = avg_user_io_wait_time
        self.avg_wait_count = avg_wait_count
        self.avg_wait_time = avg_wait_time
        self.client_ip = client_ip
        self.db_name = db_name
        self.dist_plan_percentage = dist_plan_percentage
        self.exec_ps = exec_ps
        self.executions = executions
        self.fail_count = fail_count
        self.fail_percentage = fail_percentage
        self.inner = inner
        self.local_plan_percentage = local_plan_percentage
        self.max_affected_rows = max_affected_rows
        self.max_application_wait_time = max_application_wait_time
        self.max_concurrency_wait_time = max_concurrency_wait_time
        self.max_cpu_time = max_cpu_time
        self.max_disk_reads = max_disk_reads
        self.max_elapsed_time = max_elapsed_time
        self.max_return_rows = max_return_rows
        self.max_user_io_wait_time = max_user_io_wait_time
        self.max_wait_time = max_wait_time
        self.miss_plan_percentage = miss_plan_percentage
        self.miss_plans = miss_plans
        self.remote_plan_percentage = remote_plan_percentage
        self.remote_plans = remote_plans
        self.ret_code_4012count = ret_code_4012count
        self.ret_code_4013count = ret_code_4013count
        self.ret_code_5001count = ret_code_5001count
        self.ret_code_5024count = ret_code_5024count
        self.ret_code_5167count = ret_code_5167count
        self.ret_code_5217count = ret_code_5217count
        self.ret_code_6002count = ret_code_6002count
        self.retry_count = retry_count
        self.rpc_count = rpc_count
        self.server = server
        self.server_ip = server_ip
        self.server_port = server_port
        self.sql_id = sql_id
        self.sql_text_short = sql_text_short
        self.sql_type = sql_type
        self.strong_consistency_percentage = strong_consistency_percentage
        self.sum_db_time = sum_db_time
        self.sum_elapsed_time = sum_elapsed_time
        self.sum_logical_reads = sum_logical_reads
        self.sum_wait_time = sum_wait_time
        self.table_scan_percentage = table_scan_percentage
        self.total_wait_time = total_wait_time
        self.user_name = user_name
        self.wait_event = wait_event
        self.weak_consistency_percentage = weak_consistency_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_affected_rows is not None:
            result['AvgAffectedRows'] = self.avg_affected_rows
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_block_cache_hit is not None:
            result['AvgBlockCacheHit'] = self.avg_block_cache_hit
        if self.avg_block_index_cache_hit is not None:
            result['AvgBlockIndexCacheHit'] = self.avg_block_index_cache_hit
        if self.avg_bloom_filter_cache_hit is not None:
            result['AvgBloomFilterCacheHit'] = self.avg_bloom_filter_cache_hit
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_decode_time is not None:
            result['AvgDecodeTime'] = self.avg_decode_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_execute_time is not None:
            result['AvgExecuteTime'] = self.avg_execute_time
        if self.avg_executor_rpc_count is not None:
            result['AvgExecutorRpcCount'] = self.avg_executor_rpc_count
        if self.avg_expected_worker_count is not None:
            result['AvgExpectedWorkerCount'] = self.avg_expected_worker_count
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_memstore_read_rows is not None:
            result['AvgMemstoreReadRows'] = self.avg_memstore_read_rows
        if self.avg_net_time is not None:
            result['AvgNetTime'] = self.avg_net_time
        if self.avg_net_wait_time is not None:
            result['AvgNetWaitTime'] = self.avg_net_wait_time
        if self.avg_partition_count is not None:
            result['AvgPartitionCount'] = self.avg_partition_count
        if self.avg_queue_time is not None:
            result['AvgQueueTime'] = self.avg_queue_time
        if self.avg_return_rows is not None:
            result['AvgReturnRows'] = self.avg_return_rows
        if self.avg_row_cache_hit is not None:
            result['AvgRowCacheHit'] = self.avg_row_cache_hit
        if self.avg_rpc_count is not None:
            result['AvgRpcCount'] = self.avg_rpc_count
        if self.avg_schedule_time is not None:
            result['AvgScheduleTime'] = self.avg_schedule_time
        if self.avg_ssstore_read_rows is not None:
            result['AvgSsstoreReadRows'] = self.avg_ssstore_read_rows
        if self.avg_used_worker_count is not None:
            result['AvgUsedWorkerCount'] = self.avg_used_worker_count
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.avg_wait_count is not None:
            result['AvgWaitCount'] = self.avg_wait_count
        if self.avg_wait_time is not None:
            result['AvgWaitTime'] = self.avg_wait_time
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dist_plan_percentage is not None:
            result['DistPlanPercentage'] = self.dist_plan_percentage
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.fail_percentage is not None:
            result['FailPercentage'] = self.fail_percentage
        if self.inner is not None:
            result['Inner'] = self.inner
        if self.local_plan_percentage is not None:
            result['LocalPlanPercentage'] = self.local_plan_percentage
        if self.max_affected_rows is not None:
            result['MaxAffectedRows'] = self.max_affected_rows
        if self.max_application_wait_time is not None:
            result['MaxApplicationWaitTime'] = self.max_application_wait_time
        if self.max_concurrency_wait_time is not None:
            result['MaxConcurrencyWaitTime'] = self.max_concurrency_wait_time
        if self.max_cpu_time is not None:
            result['MaxCpuTime'] = self.max_cpu_time
        if self.max_disk_reads is not None:
            result['MaxDiskReads'] = self.max_disk_reads
        if self.max_elapsed_time is not None:
            result['MaxElapsedTime'] = self.max_elapsed_time
        if self.max_return_rows is not None:
            result['MaxReturnRows'] = self.max_return_rows
        if self.max_user_io_wait_time is not None:
            result['MaxUserIoWaitTime'] = self.max_user_io_wait_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.miss_plan_percentage is not None:
            result['MissPlanPercentage'] = self.miss_plan_percentage
        if self.miss_plans is not None:
            result['MissPlans'] = self.miss_plans
        if self.remote_plan_percentage is not None:
            result['RemotePlanPercentage'] = self.remote_plan_percentage
        if self.remote_plans is not None:
            result['RemotePlans'] = self.remote_plans
        if self.ret_code_4012count is not None:
            result['RetCode4012Count'] = self.ret_code_4012count
        if self.ret_code_4013count is not None:
            result['RetCode4013Count'] = self.ret_code_4013count
        if self.ret_code_5001count is not None:
            result['RetCode5001Count'] = self.ret_code_5001count
        if self.ret_code_5024count is not None:
            result['RetCode5024Count'] = self.ret_code_5024count
        if self.ret_code_5167count is not None:
            result['RetCode5167Count'] = self.ret_code_5167count
        if self.ret_code_5217count is not None:
            result['RetCode5217Count'] = self.ret_code_5217count
        if self.ret_code_6002count is not None:
            result['RetCode6002Count'] = self.ret_code_6002count
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.rpc_count is not None:
            result['RpcCount'] = self.rpc_count
        if self.server is not None:
            result['Server'] = self.server
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.strong_consistency_percentage is not None:
            result['StrongConsistencyPercentage'] = self.strong_consistency_percentage
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_logical_reads is not None:
            result['SumLogicalReads'] = self.sum_logical_reads
        if self.sum_wait_time is not None:
            result['SumWaitTime'] = self.sum_wait_time
        if self.table_scan_percentage is not None:
            result['TableScanPercentage'] = self.table_scan_percentage
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.wait_event is not None:
            result['WaitEvent'] = self.wait_event
        if self.weak_consistency_percentage is not None:
            result['WeakConsistencyPercentage'] = self.weak_consistency_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgAffectedRows') is not None:
            self.avg_affected_rows = m.get('AvgAffectedRows')
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBlockCacheHit') is not None:
            self.avg_block_cache_hit = m.get('AvgBlockCacheHit')
        if m.get('AvgBlockIndexCacheHit') is not None:
            self.avg_block_index_cache_hit = m.get('AvgBlockIndexCacheHit')
        if m.get('AvgBloomFilterCacheHit') is not None:
            self.avg_bloom_filter_cache_hit = m.get('AvgBloomFilterCacheHit')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgDecodeTime') is not None:
            self.avg_decode_time = m.get('AvgDecodeTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgExecuteTime') is not None:
            self.avg_execute_time = m.get('AvgExecuteTime')
        if m.get('AvgExecutorRpcCount') is not None:
            self.avg_executor_rpc_count = m.get('AvgExecutorRpcCount')
        if m.get('AvgExpectedWorkerCount') is not None:
            self.avg_expected_worker_count = m.get('AvgExpectedWorkerCount')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgMemstoreReadRows') is not None:
            self.avg_memstore_read_rows = m.get('AvgMemstoreReadRows')
        if m.get('AvgNetTime') is not None:
            self.avg_net_time = m.get('AvgNetTime')
        if m.get('AvgNetWaitTime') is not None:
            self.avg_net_wait_time = m.get('AvgNetWaitTime')
        if m.get('AvgPartitionCount') is not None:
            self.avg_partition_count = m.get('AvgPartitionCount')
        if m.get('AvgQueueTime') is not None:
            self.avg_queue_time = m.get('AvgQueueTime')
        if m.get('AvgReturnRows') is not None:
            self.avg_return_rows = m.get('AvgReturnRows')
        if m.get('AvgRowCacheHit') is not None:
            self.avg_row_cache_hit = m.get('AvgRowCacheHit')
        if m.get('AvgRpcCount') is not None:
            self.avg_rpc_count = m.get('AvgRpcCount')
        if m.get('AvgScheduleTime') is not None:
            self.avg_schedule_time = m.get('AvgScheduleTime')
        if m.get('AvgSsstoreReadRows') is not None:
            self.avg_ssstore_read_rows = m.get('AvgSsstoreReadRows')
        if m.get('AvgUsedWorkerCount') is not None:
            self.avg_used_worker_count = m.get('AvgUsedWorkerCount')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('AvgWaitCount') is not None:
            self.avg_wait_count = m.get('AvgWaitCount')
        if m.get('AvgWaitTime') is not None:
            self.avg_wait_time = m.get('AvgWaitTime')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DistPlanPercentage') is not None:
            self.dist_plan_percentage = m.get('DistPlanPercentage')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('FailPercentage') is not None:
            self.fail_percentage = m.get('FailPercentage')
        if m.get('Inner') is not None:
            self.inner = m.get('Inner')
        if m.get('LocalPlanPercentage') is not None:
            self.local_plan_percentage = m.get('LocalPlanPercentage')
        if m.get('MaxAffectedRows') is not None:
            self.max_affected_rows = m.get('MaxAffectedRows')
        if m.get('MaxApplicationWaitTime') is not None:
            self.max_application_wait_time = m.get('MaxApplicationWaitTime')
        if m.get('MaxConcurrencyWaitTime') is not None:
            self.max_concurrency_wait_time = m.get('MaxConcurrencyWaitTime')
        if m.get('MaxCpuTime') is not None:
            self.max_cpu_time = m.get('MaxCpuTime')
        if m.get('MaxDiskReads') is not None:
            self.max_disk_reads = m.get('MaxDiskReads')
        if m.get('MaxElapsedTime') is not None:
            self.max_elapsed_time = m.get('MaxElapsedTime')
        if m.get('MaxReturnRows') is not None:
            self.max_return_rows = m.get('MaxReturnRows')
        if m.get('MaxUserIoWaitTime') is not None:
            self.max_user_io_wait_time = m.get('MaxUserIoWaitTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MissPlanPercentage') is not None:
            self.miss_plan_percentage = m.get('MissPlanPercentage')
        if m.get('MissPlans') is not None:
            self.miss_plans = m.get('MissPlans')
        if m.get('RemotePlanPercentage') is not None:
            self.remote_plan_percentage = m.get('RemotePlanPercentage')
        if m.get('RemotePlans') is not None:
            self.remote_plans = m.get('RemotePlans')
        if m.get('RetCode4012Count') is not None:
            self.ret_code_4012count = m.get('RetCode4012Count')
        if m.get('RetCode4013Count') is not None:
            self.ret_code_4013count = m.get('RetCode4013Count')
        if m.get('RetCode5001Count') is not None:
            self.ret_code_5001count = m.get('RetCode5001Count')
        if m.get('RetCode5024Count') is not None:
            self.ret_code_5024count = m.get('RetCode5024Count')
        if m.get('RetCode5167Count') is not None:
            self.ret_code_5167count = m.get('RetCode5167Count')
        if m.get('RetCode5217Count') is not None:
            self.ret_code_5217count = m.get('RetCode5217Count')
        if m.get('RetCode6002Count') is not None:
            self.ret_code_6002count = m.get('RetCode6002Count')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RpcCount') is not None:
            self.rpc_count = m.get('RpcCount')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StrongConsistencyPercentage') is not None:
            self.strong_consistency_percentage = m.get('StrongConsistencyPercentage')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumLogicalReads') is not None:
            self.sum_logical_reads = m.get('SumLogicalReads')
        if m.get('SumWaitTime') is not None:
            self.sum_wait_time = m.get('SumWaitTime')
        if m.get('TableScanPercentage') is not None:
            self.table_scan_percentage = m.get('TableScanPercentage')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('WaitEvent') is not None:
            self.wait_event = m.get('WaitEvent')
        if m.get('WeakConsistencyPercentage') is not None:
            self.weak_consistency_percentage = m.get('WeakConsistencyPercentage')
        return self


class DescribeOasSlowSQLListResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_affected_rows: float = None,
        avg_application_wait_time: float = None,
        avg_block_cache_hit: float = None,
        avg_block_index_cache_hit: float = None,
        avg_bloom_filter_cache_hit: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_decode_time: float = None,
        avg_disk_reads: float = None,
        avg_elapsed_time: float = None,
        avg_execute_time: float = None,
        avg_executor_rpc_count: float = None,
        avg_expected_worker_count: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_memstore_read_rows: float = None,
        avg_net_time: float = None,
        avg_net_wait_time: float = None,
        avg_partition_count: float = None,
        avg_queue_time: float = None,
        avg_return_rows: float = None,
        avg_row_cache_hit: float = None,
        avg_rpc_count: float = None,
        avg_schedule_time: float = None,
        avg_ssstore_read_rows: float = None,
        avg_used_worker_count: float = None,
        avg_user_io_wait_time: float = None,
        avg_wait_count: float = None,
        avg_wait_time: float = None,
        client_ip: str = None,
        db_name: str = None,
        dist_plan_percentage: float = None,
        dynamic_sql: bool = None,
        exec_ps: float = None,
        executions: int = None,
        fail_count: int = None,
        fail_percentage: float = None,
        inner: bool = None,
        local_plan_percentage: float = None,
        max_affected_rows: float = None,
        max_application_wait_time: float = None,
        max_concurrency_wait_time: float = None,
        max_cpu_time: float = None,
        max_disk_reads: float = None,
        max_elapsed_time: float = None,
        max_return_rows: float = None,
        max_user_io_wait_time: float = None,
        max_wait_time: float = None,
        miss_plan_percentage: float = None,
        miss_plans: int = None,
        remote_plan_percentage: float = None,
        remote_plans: int = None,
        ret_code_4012count: int = None,
        ret_code_4013count: int = None,
        ret_code_5001count: int = None,
        ret_code_5024count: int = None,
        ret_code_5167count: int = None,
        ret_code_5217count: int = None,
        ret_code_6002count: int = None,
        retry_count: int = None,
        rpc_count: float = None,
        server: str = None,
        server_ip: str = None,
        server_port: int = None,
        sql_id: str = None,
        sql_list: List[DescribeOasSlowSQLListResponseBodyDataSqlList] = None,
        sql_text_short: str = None,
        sql_type: str = None,
        strong_consistency_percentage: float = None,
        sum_db_time: float = None,
        sum_elapsed_time: float = None,
        sum_logical_reads: float = None,
        sum_wait_time: float = None,
        table_scan_percentage: float = None,
        total_wait_time: float = None,
        user_name: str = None,
        wait_event: str = None,
        weak_consistency_percentage: float = None,
    ):
        # Average updated rows during the execution period.
        self.avg_affected_rows = avg_affected_rows
        # Average Application event wait time (in milliseconds) during the client waiting period.
        self.avg_application_wait_time = avg_application_wait_time
        # Average BlockCache hit count during the execution period.
        self.avg_block_cache_hit = avg_block_cache_hit
        # Average BlockIndexCache hit count during the execution period.
        self.avg_block_index_cache_hit = avg_block_index_cache_hit
        # Average BloomFilterCache hit count during the execution period.
        self.avg_bloom_filter_cache_hit = avg_bloom_filter_cache_hit
        # Average Concurrency event wait time (in milliseconds) during the execution period.
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        # Average CPU time (in milliseconds) during the execution period.
        self.avg_cpu_time = avg_cpu_time
        self.avg_db_time = avg_db_time
        # Average syntax parsing time (in milliseconds) during the execution period.
        self.avg_decode_time = avg_decode_time
        # Average physical read count during the execution period.
        self.avg_disk_reads = avg_disk_reads
        # Average response time (in milliseconds) during the execution period.
        self.avg_elapsed_time = avg_elapsed_time
        # Average plan execution time (in milliseconds) during the execution period.
        self.avg_execute_time = avg_execute_time
        # Average number of RPC requests executed during the execution period.
        self.avg_executor_rpc_count = avg_executor_rpc_count
        # Average degree of parallelism during the execution period.
        self.avg_expected_worker_count = avg_expected_worker_count
        # Average plan generation time (in milliseconds) during the execution period.
        self.avg_get_plan_time = avg_get_plan_time
        # Average logical reads of the SQL during the execution period.
        self.avg_logical_reads = avg_logical_reads
        # Strong consistent transaction percentage during the execution period.
        self.avg_memstore_read_rows = avg_memstore_read_rows
        # Average network transmission time (in milliseconds) during the execution period.
        self.avg_net_time = avg_net_time
        # Average network enqueue time (in milliseconds) during the network waiting period.
        self.avg_net_wait_time = avg_net_wait_time
        # Average number of partition accessed during the execution period.
        self.avg_partition_count = avg_partition_count
        # Average queueing time (in milliseconds) during the execution period.
        self.avg_queue_time = avg_queue_time
        # Average number of rows returned during the execution period.
        self.avg_return_rows = avg_return_rows
        # Average RowCache hit count during the execution period.
        self.avg_row_cache_hit = avg_row_cache_hit
        # Average number of RPC sent during the execution.
        self.avg_rpc_count = avg_rpc_count
        # Average Schedule event wait time (in milliseconds) during the scheduling period.
        self.avg_schedule_time = avg_schedule_time
        # Eventually consistent transaction percentage during the execution period.
        self.avg_ssstore_read_rows = avg_ssstore_read_rows
        # Average number of threads used of the SQL during the execution period.
        self.avg_used_worker_count = avg_used_worker_count
        # Average UserIO event wait time (in milliseconds) during the execution period.
        self.avg_user_io_wait_time = avg_user_io_wait_time
        # Average number of waits during the execution period.
        self.avg_wait_count = avg_wait_count
        # Average wait time (in milliseconds) during the execution period.
        self.avg_wait_time = avg_wait_time
        # Client IP.
        self.client_ip = client_ip
        # The name of the database.
        self.db_name = db_name
        # Distributed plan percentage during the execution period.
        self.dist_plan_percentage = dist_plan_percentage
        self.dynamic_sql = dynamic_sql
        # Average execution count per second during the execution period.
        self.exec_ps = exec_ps
        # Total number of executions during the execution period.
        self.executions = executions
        # Average number of partition accessed during the execution period.
        self.fail_count = fail_count
        # Error percentage during the execution period.
        self.fail_percentage = fail_percentage
        # Whether an internal SQL.
        self.inner = inner
        # Local plan percentage during the execution period.
        self.local_plan_percentage = local_plan_percentage
        # Max affected rows during the execution period.
        self.max_affected_rows = max_affected_rows
        # Max Application event wait time (in milliseconds) during the execution period
        self.max_application_wait_time = max_application_wait_time
        # Max Concurrency event wait time (in milliseconds) during the execution period
        self.max_concurrency_wait_time = max_concurrency_wait_time
        # Max CPU time.
        self.max_cpu_time = max_cpu_time
        # Max physical read count during the execution period.
        self.max_disk_reads = max_disk_reads
        # Max response time during the execution period.
        self.max_elapsed_time = max_elapsed_time
        # Max returned rows during the execution period.
        self.max_return_rows = max_return_rows
        # Max UserIO event wait time (in milliseconds) during the execution period.
        self.max_user_io_wait_time = max_user_io_wait_time
        # Max wait time (in milliseconds) during the execution period.
        self.max_wait_time = max_wait_time
        # Plan hit rage during the execution period.
        self.miss_plan_percentage = miss_plan_percentage
        # Missed hit count of the execution plan during the execution period.
        self.miss_plans = miss_plans
        # Remote plan percentage during the execution period.
        self.remote_plan_percentage = remote_plan_percentage
        # Remote execution count during the execution period.
        self.remote_plans = remote_plans
        # Number of occurrences of code 4012 during the execution period.
        self.ret_code_4012count = ret_code_4012count
        # Number of occurrences of code 4013 during the execution period.
        self.ret_code_4013count = ret_code_4013count
        # Number of occurrences of code 5001 during the execution period.
        self.ret_code_5001count = ret_code_5001count
        # Number of occurrences of code 5024 during the execution period.
        self.ret_code_5024count = ret_code_5024count
        # Number of occurrences of code 5167 during the execution period.
        self.ret_code_5167count = ret_code_5167count
        # Number of occurrences of code 5217 during the execution period.
        self.ret_code_5217count = ret_code_5217count
        # Number of occurrences of code 6002 during the execution period.
        self.ret_code_6002count = ret_code_6002count
        # Total number of retries during the execution period.
        self.retry_count = retry_count
        # RPC count during the execution period.
        self.rpc_count = rpc_count
        # The server where the SQL is executed.
        self.server = server
        # The IP address of the server.
        self.server_ip = server_ip
        # The server port where the SQL is executed.
        self.server_port = server_port
        # SQL ID.
        self.sql_id = sql_id
        self.sql_list = sql_list
        # SQL text (the first 100 characters).
        self.sql_text_short = sql_text_short
        # SQL type.
        self.sql_type = sql_type
        # Strong consistent transaction percentage during the execution period.
        self.strong_consistency_percentage = strong_consistency_percentage
        self.sum_db_time = sum_db_time
        # Total response time (in milliseconds) during the execution period.
        self.sum_elapsed_time = sum_elapsed_time
        # Total logical reads of the SQL during the execution period.
        self.sum_logical_reads = sum_logical_reads
        # The total wait time (in milliseconds) during the internal waiting period.
        self.sum_wait_time = sum_wait_time
        # Table scan percentage during the execution period.
        self.table_scan_percentage = table_scan_percentage
        # Total wait time during the execution period.
        self.total_wait_time = total_wait_time
        # Username.
        self.user_name = user_name
        # Longest wait event during the execution period.
        self.wait_event = wait_event
        # Eventually consistent transaction percentage during the execution period.
        self.weak_consistency_percentage = weak_consistency_percentage

    def validate(self):
        if self.sql_list:
            for k in self.sql_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_affected_rows is not None:
            result['AvgAffectedRows'] = self.avg_affected_rows
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_block_cache_hit is not None:
            result['AvgBlockCacheHit'] = self.avg_block_cache_hit
        if self.avg_block_index_cache_hit is not None:
            result['AvgBlockIndexCacheHit'] = self.avg_block_index_cache_hit
        if self.avg_bloom_filter_cache_hit is not None:
            result['AvgBloomFilterCacheHit'] = self.avg_bloom_filter_cache_hit
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_decode_time is not None:
            result['AvgDecodeTime'] = self.avg_decode_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_execute_time is not None:
            result['AvgExecuteTime'] = self.avg_execute_time
        if self.avg_executor_rpc_count is not None:
            result['AvgExecutorRpcCount'] = self.avg_executor_rpc_count
        if self.avg_expected_worker_count is not None:
            result['AvgExpectedWorkerCount'] = self.avg_expected_worker_count
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_memstore_read_rows is not None:
            result['AvgMemstoreReadRows'] = self.avg_memstore_read_rows
        if self.avg_net_time is not None:
            result['AvgNetTime'] = self.avg_net_time
        if self.avg_net_wait_time is not None:
            result['AvgNetWaitTime'] = self.avg_net_wait_time
        if self.avg_partition_count is not None:
            result['AvgPartitionCount'] = self.avg_partition_count
        if self.avg_queue_time is not None:
            result['AvgQueueTime'] = self.avg_queue_time
        if self.avg_return_rows is not None:
            result['AvgReturnRows'] = self.avg_return_rows
        if self.avg_row_cache_hit is not None:
            result['AvgRowCacheHit'] = self.avg_row_cache_hit
        if self.avg_rpc_count is not None:
            result['AvgRpcCount'] = self.avg_rpc_count
        if self.avg_schedule_time is not None:
            result['AvgScheduleTime'] = self.avg_schedule_time
        if self.avg_ssstore_read_rows is not None:
            result['AvgSsstoreReadRows'] = self.avg_ssstore_read_rows
        if self.avg_used_worker_count is not None:
            result['AvgUsedWorkerCount'] = self.avg_used_worker_count
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.avg_wait_count is not None:
            result['AvgWaitCount'] = self.avg_wait_count
        if self.avg_wait_time is not None:
            result['AvgWaitTime'] = self.avg_wait_time
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dist_plan_percentage is not None:
            result['DistPlanPercentage'] = self.dist_plan_percentage
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.fail_percentage is not None:
            result['FailPercentage'] = self.fail_percentage
        if self.inner is not None:
            result['Inner'] = self.inner
        if self.local_plan_percentage is not None:
            result['LocalPlanPercentage'] = self.local_plan_percentage
        if self.max_affected_rows is not None:
            result['MaxAffectedRows'] = self.max_affected_rows
        if self.max_application_wait_time is not None:
            result['MaxApplicationWaitTime'] = self.max_application_wait_time
        if self.max_concurrency_wait_time is not None:
            result['MaxConcurrencyWaitTime'] = self.max_concurrency_wait_time
        if self.max_cpu_time is not None:
            result['MaxCpuTime'] = self.max_cpu_time
        if self.max_disk_reads is not None:
            result['MaxDiskReads'] = self.max_disk_reads
        if self.max_elapsed_time is not None:
            result['MaxElapsedTime'] = self.max_elapsed_time
        if self.max_return_rows is not None:
            result['MaxReturnRows'] = self.max_return_rows
        if self.max_user_io_wait_time is not None:
            result['MaxUserIoWaitTime'] = self.max_user_io_wait_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.miss_plan_percentage is not None:
            result['MissPlanPercentage'] = self.miss_plan_percentage
        if self.miss_plans is not None:
            result['MissPlans'] = self.miss_plans
        if self.remote_plan_percentage is not None:
            result['RemotePlanPercentage'] = self.remote_plan_percentage
        if self.remote_plans is not None:
            result['RemotePlans'] = self.remote_plans
        if self.ret_code_4012count is not None:
            result['RetCode4012Count'] = self.ret_code_4012count
        if self.ret_code_4013count is not None:
            result['RetCode4013Count'] = self.ret_code_4013count
        if self.ret_code_5001count is not None:
            result['RetCode5001Count'] = self.ret_code_5001count
        if self.ret_code_5024count is not None:
            result['RetCode5024Count'] = self.ret_code_5024count
        if self.ret_code_5167count is not None:
            result['RetCode5167Count'] = self.ret_code_5167count
        if self.ret_code_5217count is not None:
            result['RetCode5217Count'] = self.ret_code_5217count
        if self.ret_code_6002count is not None:
            result['RetCode6002Count'] = self.ret_code_6002count
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.rpc_count is not None:
            result['RpcCount'] = self.rpc_count
        if self.server is not None:
            result['Server'] = self.server
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        result['SqlList'] = []
        if self.sql_list is not None:
            for k in self.sql_list:
                result['SqlList'].append(k.to_map() if k else None)
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.strong_consistency_percentage is not None:
            result['StrongConsistencyPercentage'] = self.strong_consistency_percentage
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_logical_reads is not None:
            result['SumLogicalReads'] = self.sum_logical_reads
        if self.sum_wait_time is not None:
            result['SumWaitTime'] = self.sum_wait_time
        if self.table_scan_percentage is not None:
            result['TableScanPercentage'] = self.table_scan_percentage
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.wait_event is not None:
            result['WaitEvent'] = self.wait_event
        if self.weak_consistency_percentage is not None:
            result['WeakConsistencyPercentage'] = self.weak_consistency_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgAffectedRows') is not None:
            self.avg_affected_rows = m.get('AvgAffectedRows')
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBlockCacheHit') is not None:
            self.avg_block_cache_hit = m.get('AvgBlockCacheHit')
        if m.get('AvgBlockIndexCacheHit') is not None:
            self.avg_block_index_cache_hit = m.get('AvgBlockIndexCacheHit')
        if m.get('AvgBloomFilterCacheHit') is not None:
            self.avg_bloom_filter_cache_hit = m.get('AvgBloomFilterCacheHit')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgDecodeTime') is not None:
            self.avg_decode_time = m.get('AvgDecodeTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgExecuteTime') is not None:
            self.avg_execute_time = m.get('AvgExecuteTime')
        if m.get('AvgExecutorRpcCount') is not None:
            self.avg_executor_rpc_count = m.get('AvgExecutorRpcCount')
        if m.get('AvgExpectedWorkerCount') is not None:
            self.avg_expected_worker_count = m.get('AvgExpectedWorkerCount')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgMemstoreReadRows') is not None:
            self.avg_memstore_read_rows = m.get('AvgMemstoreReadRows')
        if m.get('AvgNetTime') is not None:
            self.avg_net_time = m.get('AvgNetTime')
        if m.get('AvgNetWaitTime') is not None:
            self.avg_net_wait_time = m.get('AvgNetWaitTime')
        if m.get('AvgPartitionCount') is not None:
            self.avg_partition_count = m.get('AvgPartitionCount')
        if m.get('AvgQueueTime') is not None:
            self.avg_queue_time = m.get('AvgQueueTime')
        if m.get('AvgReturnRows') is not None:
            self.avg_return_rows = m.get('AvgReturnRows')
        if m.get('AvgRowCacheHit') is not None:
            self.avg_row_cache_hit = m.get('AvgRowCacheHit')
        if m.get('AvgRpcCount') is not None:
            self.avg_rpc_count = m.get('AvgRpcCount')
        if m.get('AvgScheduleTime') is not None:
            self.avg_schedule_time = m.get('AvgScheduleTime')
        if m.get('AvgSsstoreReadRows') is not None:
            self.avg_ssstore_read_rows = m.get('AvgSsstoreReadRows')
        if m.get('AvgUsedWorkerCount') is not None:
            self.avg_used_worker_count = m.get('AvgUsedWorkerCount')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('AvgWaitCount') is not None:
            self.avg_wait_count = m.get('AvgWaitCount')
        if m.get('AvgWaitTime') is not None:
            self.avg_wait_time = m.get('AvgWaitTime')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DistPlanPercentage') is not None:
            self.dist_plan_percentage = m.get('DistPlanPercentage')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('FailPercentage') is not None:
            self.fail_percentage = m.get('FailPercentage')
        if m.get('Inner') is not None:
            self.inner = m.get('Inner')
        if m.get('LocalPlanPercentage') is not None:
            self.local_plan_percentage = m.get('LocalPlanPercentage')
        if m.get('MaxAffectedRows') is not None:
            self.max_affected_rows = m.get('MaxAffectedRows')
        if m.get('MaxApplicationWaitTime') is not None:
            self.max_application_wait_time = m.get('MaxApplicationWaitTime')
        if m.get('MaxConcurrencyWaitTime') is not None:
            self.max_concurrency_wait_time = m.get('MaxConcurrencyWaitTime')
        if m.get('MaxCpuTime') is not None:
            self.max_cpu_time = m.get('MaxCpuTime')
        if m.get('MaxDiskReads') is not None:
            self.max_disk_reads = m.get('MaxDiskReads')
        if m.get('MaxElapsedTime') is not None:
            self.max_elapsed_time = m.get('MaxElapsedTime')
        if m.get('MaxReturnRows') is not None:
            self.max_return_rows = m.get('MaxReturnRows')
        if m.get('MaxUserIoWaitTime') is not None:
            self.max_user_io_wait_time = m.get('MaxUserIoWaitTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MissPlanPercentage') is not None:
            self.miss_plan_percentage = m.get('MissPlanPercentage')
        if m.get('MissPlans') is not None:
            self.miss_plans = m.get('MissPlans')
        if m.get('RemotePlanPercentage') is not None:
            self.remote_plan_percentage = m.get('RemotePlanPercentage')
        if m.get('RemotePlans') is not None:
            self.remote_plans = m.get('RemotePlans')
        if m.get('RetCode4012Count') is not None:
            self.ret_code_4012count = m.get('RetCode4012Count')
        if m.get('RetCode4013Count') is not None:
            self.ret_code_4013count = m.get('RetCode4013Count')
        if m.get('RetCode5001Count') is not None:
            self.ret_code_5001count = m.get('RetCode5001Count')
        if m.get('RetCode5024Count') is not None:
            self.ret_code_5024count = m.get('RetCode5024Count')
        if m.get('RetCode5167Count') is not None:
            self.ret_code_5167count = m.get('RetCode5167Count')
        if m.get('RetCode5217Count') is not None:
            self.ret_code_5217count = m.get('RetCode5217Count')
        if m.get('RetCode6002Count') is not None:
            self.ret_code_6002count = m.get('RetCode6002Count')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RpcCount') is not None:
            self.rpc_count = m.get('RpcCount')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        self.sql_list = []
        if m.get('SqlList') is not None:
            for k in m.get('SqlList'):
                temp_model = DescribeOasSlowSQLListResponseBodyDataSqlList()
                self.sql_list.append(temp_model.from_map(k))
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StrongConsistencyPercentage') is not None:
            self.strong_consistency_percentage = m.get('StrongConsistencyPercentage')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumLogicalReads') is not None:
            self.sum_logical_reads = m.get('SumLogicalReads')
        if m.get('SumWaitTime') is not None:
            self.sum_wait_time = m.get('SumWaitTime')
        if m.get('TableScanPercentage') is not None:
            self.table_scan_percentage = m.get('TableScanPercentage')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('WaitEvent') is not None:
            self.wait_event = m.get('WaitEvent')
        if m.get('WeakConsistencyPercentage') is not None:
            self.weak_consistency_percentage = m.get('WeakConsistencyPercentage')
        return self


class DescribeOasSlowSQLListResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeOasSlowSQLListResponseBodyData] = None,
        request_id: str = None,
    ):
        # The list of slow queries.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeOasSlowSQLListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOasSlowSQLListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasSlowSQLListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasSlowSQLListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOasTopSQLListRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        custom_columns: str = None,
        db_name: str = None,
        dynamic_sql: bool = None,
        end_time: str = None,
        filter_condition: str = None,
        instance_id: str = None,
        merge_dynamic_sql: bool = None,
        node_ip: str = None,
        search_key_word: str = None,
        search_param: str = None,
        search_rule: str = None,
        search_value: str = None,
        sql_id: str = None,
        sql_text_length: int = None,
        start_time: str = None,
        tenant_id: str = None,
    ):
        # The language of the response. Valid values:
        # 
        # - zh: Chinese
        # - en: English
        self.accept_language = accept_language
        self.custom_columns = custom_columns
        # The name of the database.
        self.db_name = db_name
        self.dynamic_sql = dynamic_sql
        # The end time of querying the TOPSQL parameter.
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # All parameters are referenced by the symbol @. For a list of available parameters, refer to the returned parameters in [Query performance indicators of an SQL statement](https://en.oceanbase.com/docs/community-ocp-en-10000000000840290).
        self.filter_condition = filter_condition
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.merge_dynamic_sql = merge_dynamic_sql
        # The node IP.
        self.node_ip = node_ip
        # The search keyword.
        self.search_key_word = search_key_word
        # The search parameter.
        self.search_param = search_param
        # The search rule.
        self.search_rule = search_rule
        # The search value.
        self.search_value = search_value
        # SQL ID.
        # > When the SQL ID is provided, the system collects all the request data for the target SQL ID. When the SQL ID is empty, the system collects all the request data for the entire database instance.
        self.sql_id = sql_id
        # Max length of the returned SQL text.
        self.sql_text_length = sql_text_length
        # The start time of querying the TOPSQL parameter.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.custom_columns is not None:
            result['CustomColumns'] = self.custom_columns
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_condition is not None:
            result['FilterCondition'] = self.filter_condition
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.merge_dynamic_sql is not None:
            result['MergeDynamicSql'] = self.merge_dynamic_sql
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.search_key_word is not None:
            result['SearchKeyWord'] = self.search_key_word
        if self.search_param is not None:
            result['SearchParam'] = self.search_param
        if self.search_rule is not None:
            result['SearchRule'] = self.search_rule
        if self.search_value is not None:
            result['SearchValue'] = self.search_value
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_length is not None:
            result['SqlTextLength'] = self.sql_text_length
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('CustomColumns') is not None:
            self.custom_columns = m.get('CustomColumns')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterCondition') is not None:
            self.filter_condition = m.get('FilterCondition')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MergeDynamicSql') is not None:
            self.merge_dynamic_sql = m.get('MergeDynamicSql')
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('SearchKeyWord') is not None:
            self.search_key_word = m.get('SearchKeyWord')
        if m.get('SearchParam') is not None:
            self.search_param = m.get('SearchParam')
        if m.get('SearchRule') is not None:
            self.search_rule = m.get('SearchRule')
        if m.get('SearchValue') is not None:
            self.search_value = m.get('SearchValue')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextLength') is not None:
            self.sql_text_length = m.get('SqlTextLength')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOasTopSQLListResponseBodyDataCustomColumns(TeaModel):
    def __init__(
        self,
        expression: str = None,
        value: str = None,
    ):
        self.expression = expression
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeOasTopSQLListResponseBodyDataSqlList(TeaModel):
    def __init__(
        self,
        avg_affected_rows: float = None,
        avg_application_wait_time: float = None,
        avg_block_cache_hit: float = None,
        avg_block_index_cache_hit: float = None,
        avg_bloom_filter_cache_hit: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_decode_time: float = None,
        avg_disk_reads: float = None,
        avg_elapsed_time: float = None,
        avg_execute_time: float = None,
        avg_executor_rpc_count: float = None,
        avg_expected_worker_count: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_memstore_read_rows: float = None,
        avg_net_time: float = None,
        avg_net_wait_time: float = None,
        avg_partition_count: float = None,
        avg_queue_time: float = None,
        avg_return_rows: float = None,
        avg_row_cache_hit: float = None,
        avg_rpc_count: float = None,
        avg_schedule_time: float = None,
        avg_ssstore_read_rows: float = None,
        avg_used_worker_count: float = None,
        avg_user_io_wait_time: float = None,
        avg_wait_count: float = None,
        avg_wait_time: float = None,
        client_ip: str = None,
        cpu_percentage: float = None,
        db_name: str = None,
        dist_plan_percentage: float = None,
        exec_ps: float = None,
        executions: int = None,
        fail_count: int = None,
        fail_percentage: float = None,
        inner: bool = None,
        local_plan_percentage: float = None,
        max_affected_rows: float = None,
        max_application_wait_time: float = None,
        max_concurrency_wait_time: float = None,
        max_cpu_time: float = None,
        max_disk_reads: float = None,
        max_elapsed_time: float = None,
        max_return_rows: float = None,
        max_user_io_wait_time: float = None,
        max_wait_time: float = None,
        miss_plan_percentage: float = None,
        miss_plans: int = None,
        remote_plan_percentage: float = None,
        remote_plans: int = None,
        ret_code_4012count: int = None,
        ret_code_4013count: int = None,
        ret_code_5001count: int = None,
        ret_code_5024count: int = None,
        ret_code_5167count: int = None,
        ret_code_5217count: int = None,
        ret_code_6002count: int = None,
        retry_count: int = None,
        rpc_count: float = None,
        server: str = None,
        server_ip: str = None,
        server_port: int = None,
        sql_id: str = None,
        sql_text_short: str = None,
        sql_type: str = None,
        strong_consistency_percentage: float = None,
        sum_db_time: float = None,
        sum_elapsed_time: float = None,
        sum_logical_reads: float = None,
        sum_wait_time: float = None,
        table_scan_percentage: float = None,
        total_wait_time: float = None,
        user_name: str = None,
        wait_event: str = None,
        weak_consistency_percentage: float = None,
    ):
        self.avg_affected_rows = avg_affected_rows
        self.avg_application_wait_time = avg_application_wait_time
        self.avg_block_cache_hit = avg_block_cache_hit
        self.avg_block_index_cache_hit = avg_block_index_cache_hit
        self.avg_bloom_filter_cache_hit = avg_bloom_filter_cache_hit
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        self.avg_cpu_time = avg_cpu_time
        self.avg_db_time = avg_db_time
        self.avg_decode_time = avg_decode_time
        self.avg_disk_reads = avg_disk_reads
        self.avg_elapsed_time = avg_elapsed_time
        self.avg_execute_time = avg_execute_time
        self.avg_executor_rpc_count = avg_executor_rpc_count
        self.avg_expected_worker_count = avg_expected_worker_count
        self.avg_get_plan_time = avg_get_plan_time
        self.avg_logical_reads = avg_logical_reads
        self.avg_memstore_read_rows = avg_memstore_read_rows
        self.avg_net_time = avg_net_time
        self.avg_net_wait_time = avg_net_wait_time
        self.avg_partition_count = avg_partition_count
        self.avg_queue_time = avg_queue_time
        self.avg_return_rows = avg_return_rows
        self.avg_row_cache_hit = avg_row_cache_hit
        self.avg_rpc_count = avg_rpc_count
        self.avg_schedule_time = avg_schedule_time
        self.avg_ssstore_read_rows = avg_ssstore_read_rows
        self.avg_used_worker_count = avg_used_worker_count
        self.avg_user_io_wait_time = avg_user_io_wait_time
        self.avg_wait_count = avg_wait_count
        self.avg_wait_time = avg_wait_time
        self.client_ip = client_ip
        self.cpu_percentage = cpu_percentage
        self.db_name = db_name
        self.dist_plan_percentage = dist_plan_percentage
        self.exec_ps = exec_ps
        self.executions = executions
        self.fail_count = fail_count
        self.fail_percentage = fail_percentage
        self.inner = inner
        self.local_plan_percentage = local_plan_percentage
        self.max_affected_rows = max_affected_rows
        self.max_application_wait_time = max_application_wait_time
        self.max_concurrency_wait_time = max_concurrency_wait_time
        self.max_cpu_time = max_cpu_time
        self.max_disk_reads = max_disk_reads
        self.max_elapsed_time = max_elapsed_time
        self.max_return_rows = max_return_rows
        self.max_user_io_wait_time = max_user_io_wait_time
        self.max_wait_time = max_wait_time
        self.miss_plan_percentage = miss_plan_percentage
        self.miss_plans = miss_plans
        self.remote_plan_percentage = remote_plan_percentage
        self.remote_plans = remote_plans
        self.ret_code_4012count = ret_code_4012count
        self.ret_code_4013count = ret_code_4013count
        self.ret_code_5001count = ret_code_5001count
        self.ret_code_5024count = ret_code_5024count
        self.ret_code_5167count = ret_code_5167count
        self.ret_code_5217count = ret_code_5217count
        self.ret_code_6002count = ret_code_6002count
        self.retry_count = retry_count
        self.rpc_count = rpc_count
        self.server = server
        self.server_ip = server_ip
        self.server_port = server_port
        self.sql_id = sql_id
        self.sql_text_short = sql_text_short
        self.sql_type = sql_type
        self.strong_consistency_percentage = strong_consistency_percentage
        self.sum_db_time = sum_db_time
        self.sum_elapsed_time = sum_elapsed_time
        self.sum_logical_reads = sum_logical_reads
        self.sum_wait_time = sum_wait_time
        self.table_scan_percentage = table_scan_percentage
        self.total_wait_time = total_wait_time
        self.user_name = user_name
        self.wait_event = wait_event
        self.weak_consistency_percentage = weak_consistency_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_affected_rows is not None:
            result['AvgAffectedRows'] = self.avg_affected_rows
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_block_cache_hit is not None:
            result['AvgBlockCacheHit'] = self.avg_block_cache_hit
        if self.avg_block_index_cache_hit is not None:
            result['AvgBlockIndexCacheHit'] = self.avg_block_index_cache_hit
        if self.avg_bloom_filter_cache_hit is not None:
            result['AvgBloomFilterCacheHit'] = self.avg_bloom_filter_cache_hit
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_decode_time is not None:
            result['AvgDecodeTime'] = self.avg_decode_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_execute_time is not None:
            result['AvgExecuteTime'] = self.avg_execute_time
        if self.avg_executor_rpc_count is not None:
            result['AvgExecutorRpcCount'] = self.avg_executor_rpc_count
        if self.avg_expected_worker_count is not None:
            result['AvgExpectedWorkerCount'] = self.avg_expected_worker_count
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_memstore_read_rows is not None:
            result['AvgMemstoreReadRows'] = self.avg_memstore_read_rows
        if self.avg_net_time is not None:
            result['AvgNetTime'] = self.avg_net_time
        if self.avg_net_wait_time is not None:
            result['AvgNetWaitTime'] = self.avg_net_wait_time
        if self.avg_partition_count is not None:
            result['AvgPartitionCount'] = self.avg_partition_count
        if self.avg_queue_time is not None:
            result['AvgQueueTime'] = self.avg_queue_time
        if self.avg_return_rows is not None:
            result['AvgReturnRows'] = self.avg_return_rows
        if self.avg_row_cache_hit is not None:
            result['AvgRowCacheHit'] = self.avg_row_cache_hit
        if self.avg_rpc_count is not None:
            result['AvgRpcCount'] = self.avg_rpc_count
        if self.avg_schedule_time is not None:
            result['AvgScheduleTime'] = self.avg_schedule_time
        if self.avg_ssstore_read_rows is not None:
            result['AvgSsstoreReadRows'] = self.avg_ssstore_read_rows
        if self.avg_used_worker_count is not None:
            result['AvgUsedWorkerCount'] = self.avg_used_worker_count
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.avg_wait_count is not None:
            result['AvgWaitCount'] = self.avg_wait_count
        if self.avg_wait_time is not None:
            result['AvgWaitTime'] = self.avg_wait_time
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.cpu_percentage is not None:
            result['CpuPercentage'] = self.cpu_percentage
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dist_plan_percentage is not None:
            result['DistPlanPercentage'] = self.dist_plan_percentage
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.fail_percentage is not None:
            result['FailPercentage'] = self.fail_percentage
        if self.inner is not None:
            result['Inner'] = self.inner
        if self.local_plan_percentage is not None:
            result['LocalPlanPercentage'] = self.local_plan_percentage
        if self.max_affected_rows is not None:
            result['MaxAffectedRows'] = self.max_affected_rows
        if self.max_application_wait_time is not None:
            result['MaxApplicationWaitTime'] = self.max_application_wait_time
        if self.max_concurrency_wait_time is not None:
            result['MaxConcurrencyWaitTime'] = self.max_concurrency_wait_time
        if self.max_cpu_time is not None:
            result['MaxCpuTime'] = self.max_cpu_time
        if self.max_disk_reads is not None:
            result['MaxDiskReads'] = self.max_disk_reads
        if self.max_elapsed_time is not None:
            result['MaxElapsedTime'] = self.max_elapsed_time
        if self.max_return_rows is not None:
            result['MaxReturnRows'] = self.max_return_rows
        if self.max_user_io_wait_time is not None:
            result['MaxUserIoWaitTime'] = self.max_user_io_wait_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.miss_plan_percentage is not None:
            result['MissPlanPercentage'] = self.miss_plan_percentage
        if self.miss_plans is not None:
            result['MissPlans'] = self.miss_plans
        if self.remote_plan_percentage is not None:
            result['RemotePlanPercentage'] = self.remote_plan_percentage
        if self.remote_plans is not None:
            result['RemotePlans'] = self.remote_plans
        if self.ret_code_4012count is not None:
            result['RetCode4012Count'] = self.ret_code_4012count
        if self.ret_code_4013count is not None:
            result['RetCode4013Count'] = self.ret_code_4013count
        if self.ret_code_5001count is not None:
            result['RetCode5001Count'] = self.ret_code_5001count
        if self.ret_code_5024count is not None:
            result['RetCode5024Count'] = self.ret_code_5024count
        if self.ret_code_5167count is not None:
            result['RetCode5167Count'] = self.ret_code_5167count
        if self.ret_code_5217count is not None:
            result['RetCode5217Count'] = self.ret_code_5217count
        if self.ret_code_6002count is not None:
            result['RetCode6002Count'] = self.ret_code_6002count
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.rpc_count is not None:
            result['RpcCount'] = self.rpc_count
        if self.server is not None:
            result['Server'] = self.server
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.strong_consistency_percentage is not None:
            result['StrongConsistencyPercentage'] = self.strong_consistency_percentage
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_logical_reads is not None:
            result['SumLogicalReads'] = self.sum_logical_reads
        if self.sum_wait_time is not None:
            result['SumWaitTime'] = self.sum_wait_time
        if self.table_scan_percentage is not None:
            result['TableScanPercentage'] = self.table_scan_percentage
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.wait_event is not None:
            result['WaitEvent'] = self.wait_event
        if self.weak_consistency_percentage is not None:
            result['WeakConsistencyPercentage'] = self.weak_consistency_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgAffectedRows') is not None:
            self.avg_affected_rows = m.get('AvgAffectedRows')
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBlockCacheHit') is not None:
            self.avg_block_cache_hit = m.get('AvgBlockCacheHit')
        if m.get('AvgBlockIndexCacheHit') is not None:
            self.avg_block_index_cache_hit = m.get('AvgBlockIndexCacheHit')
        if m.get('AvgBloomFilterCacheHit') is not None:
            self.avg_bloom_filter_cache_hit = m.get('AvgBloomFilterCacheHit')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgDecodeTime') is not None:
            self.avg_decode_time = m.get('AvgDecodeTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgExecuteTime') is not None:
            self.avg_execute_time = m.get('AvgExecuteTime')
        if m.get('AvgExecutorRpcCount') is not None:
            self.avg_executor_rpc_count = m.get('AvgExecutorRpcCount')
        if m.get('AvgExpectedWorkerCount') is not None:
            self.avg_expected_worker_count = m.get('AvgExpectedWorkerCount')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgMemstoreReadRows') is not None:
            self.avg_memstore_read_rows = m.get('AvgMemstoreReadRows')
        if m.get('AvgNetTime') is not None:
            self.avg_net_time = m.get('AvgNetTime')
        if m.get('AvgNetWaitTime') is not None:
            self.avg_net_wait_time = m.get('AvgNetWaitTime')
        if m.get('AvgPartitionCount') is not None:
            self.avg_partition_count = m.get('AvgPartitionCount')
        if m.get('AvgQueueTime') is not None:
            self.avg_queue_time = m.get('AvgQueueTime')
        if m.get('AvgReturnRows') is not None:
            self.avg_return_rows = m.get('AvgReturnRows')
        if m.get('AvgRowCacheHit') is not None:
            self.avg_row_cache_hit = m.get('AvgRowCacheHit')
        if m.get('AvgRpcCount') is not None:
            self.avg_rpc_count = m.get('AvgRpcCount')
        if m.get('AvgScheduleTime') is not None:
            self.avg_schedule_time = m.get('AvgScheduleTime')
        if m.get('AvgSsstoreReadRows') is not None:
            self.avg_ssstore_read_rows = m.get('AvgSsstoreReadRows')
        if m.get('AvgUsedWorkerCount') is not None:
            self.avg_used_worker_count = m.get('AvgUsedWorkerCount')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('AvgWaitCount') is not None:
            self.avg_wait_count = m.get('AvgWaitCount')
        if m.get('AvgWaitTime') is not None:
            self.avg_wait_time = m.get('AvgWaitTime')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('CpuPercentage') is not None:
            self.cpu_percentage = m.get('CpuPercentage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DistPlanPercentage') is not None:
            self.dist_plan_percentage = m.get('DistPlanPercentage')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('FailPercentage') is not None:
            self.fail_percentage = m.get('FailPercentage')
        if m.get('Inner') is not None:
            self.inner = m.get('Inner')
        if m.get('LocalPlanPercentage') is not None:
            self.local_plan_percentage = m.get('LocalPlanPercentage')
        if m.get('MaxAffectedRows') is not None:
            self.max_affected_rows = m.get('MaxAffectedRows')
        if m.get('MaxApplicationWaitTime') is not None:
            self.max_application_wait_time = m.get('MaxApplicationWaitTime')
        if m.get('MaxConcurrencyWaitTime') is not None:
            self.max_concurrency_wait_time = m.get('MaxConcurrencyWaitTime')
        if m.get('MaxCpuTime') is not None:
            self.max_cpu_time = m.get('MaxCpuTime')
        if m.get('MaxDiskReads') is not None:
            self.max_disk_reads = m.get('MaxDiskReads')
        if m.get('MaxElapsedTime') is not None:
            self.max_elapsed_time = m.get('MaxElapsedTime')
        if m.get('MaxReturnRows') is not None:
            self.max_return_rows = m.get('MaxReturnRows')
        if m.get('MaxUserIoWaitTime') is not None:
            self.max_user_io_wait_time = m.get('MaxUserIoWaitTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MissPlanPercentage') is not None:
            self.miss_plan_percentage = m.get('MissPlanPercentage')
        if m.get('MissPlans') is not None:
            self.miss_plans = m.get('MissPlans')
        if m.get('RemotePlanPercentage') is not None:
            self.remote_plan_percentage = m.get('RemotePlanPercentage')
        if m.get('RemotePlans') is not None:
            self.remote_plans = m.get('RemotePlans')
        if m.get('RetCode4012Count') is not None:
            self.ret_code_4012count = m.get('RetCode4012Count')
        if m.get('RetCode4013Count') is not None:
            self.ret_code_4013count = m.get('RetCode4013Count')
        if m.get('RetCode5001Count') is not None:
            self.ret_code_5001count = m.get('RetCode5001Count')
        if m.get('RetCode5024Count') is not None:
            self.ret_code_5024count = m.get('RetCode5024Count')
        if m.get('RetCode5167Count') is not None:
            self.ret_code_5167count = m.get('RetCode5167Count')
        if m.get('RetCode5217Count') is not None:
            self.ret_code_5217count = m.get('RetCode5217Count')
        if m.get('RetCode6002Count') is not None:
            self.ret_code_6002count = m.get('RetCode6002Count')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RpcCount') is not None:
            self.rpc_count = m.get('RpcCount')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StrongConsistencyPercentage') is not None:
            self.strong_consistency_percentage = m.get('StrongConsistencyPercentage')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumLogicalReads') is not None:
            self.sum_logical_reads = m.get('SumLogicalReads')
        if m.get('SumWaitTime') is not None:
            self.sum_wait_time = m.get('SumWaitTime')
        if m.get('TableScanPercentage') is not None:
            self.table_scan_percentage = m.get('TableScanPercentage')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('WaitEvent') is not None:
            self.wait_event = m.get('WaitEvent')
        if m.get('WeakConsistencyPercentage') is not None:
            self.weak_consistency_percentage = m.get('WeakConsistencyPercentage')
        return self


class DescribeOasTopSQLListResponseBodyData(TeaModel):
    def __init__(
        self,
        avg_affected_rows: float = None,
        avg_application_wait_time: float = None,
        avg_block_cache_hit: float = None,
        avg_block_index_cache_hit: float = None,
        avg_bloom_filter_cache_hit: float = None,
        avg_concurrency_wait_time: float = None,
        avg_cpu_time: float = None,
        avg_db_time: float = None,
        avg_decode_time: float = None,
        avg_disk_reads: float = None,
        avg_elapsed_time: float = None,
        avg_execute_time: float = None,
        avg_executor_rpc_count: float = None,
        avg_expected_worker_count: float = None,
        avg_get_plan_time: float = None,
        avg_logical_reads: float = None,
        avg_memstore_read_rows: float = None,
        avg_net_time: float = None,
        avg_net_wait_time: float = None,
        avg_partition_count: float = None,
        avg_queue_time: float = None,
        avg_return_rows: float = None,
        avg_row_cache_hit: float = None,
        avg_rpc_count: float = None,
        avg_schedule_time: float = None,
        avg_ssstore_read_rows: float = None,
        avg_used_worker_count: float = None,
        avg_user_io_wait_time: float = None,
        avg_wait_count: float = None,
        avg_wait_time: float = None,
        client_ip: str = None,
        cpu_percentage: float = None,
        custom_columns: DescribeOasTopSQLListResponseBodyDataCustomColumns = None,
        db_name: str = None,
        dist_plan_percentage: float = None,
        dynamic_sql: bool = None,
        exec_ps: float = None,
        executions: int = None,
        fail_count: int = None,
        fail_percentage: float = None,
        inner: bool = None,
        last_fail_code: int = None,
        local_plan_percentage: float = None,
        max_affected_rows: float = None,
        max_application_wait_time: float = None,
        max_concurrency_wait_time: float = None,
        max_cpu_time: float = None,
        max_disk_reads: float = None,
        max_elapsed_time: float = None,
        max_return_rows: float = None,
        max_user_io_wait_time: float = None,
        max_wait_time: float = None,
        miss_plan_percentage: float = None,
        miss_plans: int = None,
        ob_db_id: int = None,
        remote_plan_percentage: float = None,
        remote_plans: int = None,
        ret_code_4012count: int = None,
        ret_code_4013count: int = None,
        ret_code_5001count: int = None,
        ret_code_5024count: int = None,
        ret_code_5167count: int = None,
        ret_code_5217count: int = None,
        ret_code_6002count: int = None,
        retry_count: int = None,
        rpc_count: float = None,
        server: str = None,
        server_ip: str = None,
        server_port: int = None,
        sql_id: str = None,
        sql_list: List[DescribeOasTopSQLListResponseBodyDataSqlList] = None,
        sql_text_short: str = None,
        sql_type: str = None,
        strong_consistency_percentage: float = None,
        sum_db_time: float = None,
        sum_elapsed_time: float = None,
        sum_logical_reads: float = None,
        sum_wait_time: float = None,
        table_scan_percentage: float = None,
        total_wait_time: float = None,
        user_name: str = None,
        wait_event: str = None,
        weak_consistency_percentage: float = None,
    ):
        # Average updated rows during the execution period.
        self.avg_affected_rows = avg_affected_rows
        # Average Application event wait time (in milliseconds) during the execution period.
        self.avg_application_wait_time = avg_application_wait_time
        # Average BlockCache hit count during the execution period.
        self.avg_block_cache_hit = avg_block_cache_hit
        # Average BlockIndexCache hit count during the execution period.
        self.avg_block_index_cache_hit = avg_block_index_cache_hit
        # Average BloomFilterCache hit count during the execution period.
        self.avg_bloom_filter_cache_hit = avg_bloom_filter_cache_hit
        # Average Concurrency event wait time (in milliseconds) during the execution period.
        self.avg_concurrency_wait_time = avg_concurrency_wait_time
        # Average CPU time (in milliseconds) during the execution period.
        self.avg_cpu_time = avg_cpu_time
        self.avg_db_time = avg_db_time
        # Average syntax parsing time (in milliseconds) during the execution period.
        self.avg_decode_time = avg_decode_time
        # Average physical read count during the execution period.
        self.avg_disk_reads = avg_disk_reads
        # Average response time (in milliseconds) during the execution period.
        self.avg_elapsed_time = avg_elapsed_time
        # Average plan execution time (in milliseconds) during the execution period.
        self.avg_execute_time = avg_execute_time
        # Average number of RPC requests executed during the execution period.
        self.avg_executor_rpc_count = avg_executor_rpc_count
        # Average degree of parallelism during the execution period.
        self.avg_expected_worker_count = avg_expected_worker_count
        # Average plan generation time (in milliseconds) during the execution period.
        self.avg_get_plan_time = avg_get_plan_time
        # Average logical reads of the SQL during the execution period.
        self.avg_logical_reads = avg_logical_reads
        # Strong consistent transaction percentage during the execution period.
        self.avg_memstore_read_rows = avg_memstore_read_rows
        # Average network transmission time (in milliseconds) during the execution period.
        self.avg_net_time = avg_net_time
        # Average network enqueue time (in milliseconds) during the execution period.
        self.avg_net_wait_time = avg_net_wait_time
        # Average number of partition accessed during the execution period.
        self.avg_partition_count = avg_partition_count
        # Average queueing time (in milliseconds) during the execution period.
        self.avg_queue_time = avg_queue_time
        # Average returned rows during the execution period.
        self.avg_return_rows = avg_return_rows
        # Average RowCache hit count during the execution period.
        self.avg_row_cache_hit = avg_row_cache_hit
        # Average count of RPC sent during the execution period.
        self.avg_rpc_count = avg_rpc_count
        # Average Schedule event wait time (in milliseconds) during the execution period.
        self.avg_schedule_time = avg_schedule_time
        # Eventually consistent transaction percentage during the execution period.
        self.avg_ssstore_read_rows = avg_ssstore_read_rows
        # Average number of threads used of the SQL during the execution period.
        self.avg_used_worker_count = avg_used_worker_count
        # Average UserIO event wait time (in milliseconds) during the execution period.
        self.avg_user_io_wait_time = avg_user_io_wait_time
        # Average wait count during the execution period.
        self.avg_wait_count = avg_wait_count
        # Average wait time (in milliseconds) during the execution period.
        self.avg_wait_time = avg_wait_time
        # Client IP.
        self.client_ip = client_ip
        # CPU percentage.
        self.cpu_percentage = cpu_percentage
        self.custom_columns = custom_columns
        # The name of the database.
        self.db_name = db_name
        # Distributed plan percentage during the execution period.
        self.dist_plan_percentage = dist_plan_percentage
        self.dynamic_sql = dynamic_sql
        # Average execution count per second during the execution period.
        self.exec_ps = exec_ps
        # Total number of executions during the execution period.
        self.executions = executions
        # Average number of partition accessed during the execution period.
        self.fail_count = fail_count
        # Error percentage during the execution period.
        self.fail_percentage = fail_percentage
        # Whether a internal SQL.
        self.inner = inner
        self.last_fail_code = last_fail_code
        # Local plan percentage during the execution period.
        self.local_plan_percentage = local_plan_percentage
        # Max affected rows during the execution period.
        self.max_affected_rows = max_affected_rows
        # Max Application event wait time (in milliseconds) during the execution period.
        self.max_application_wait_time = max_application_wait_time
        # Max Concurrency event wait time (in milliseconds) during the execution period.
        self.max_concurrency_wait_time = max_concurrency_wait_time
        # Max CPU time (in milliseconds).
        self.max_cpu_time = max_cpu_time
        # Max physical read count during the execution period.
        self.max_disk_reads = max_disk_reads
        # Max response time during the execution period.
        self.max_elapsed_time = max_elapsed_time
        # Max returned rows during the execution period.
        self.max_return_rows = max_return_rows
        # Max UserIO event wait time (in milliseconds) during the execution period.
        self.max_user_io_wait_time = max_user_io_wait_time
        # Max wait time (in milliseconds) during the execution period.
        self.max_wait_time = max_wait_time
        # Plan hit rage during the execution period.
        self.miss_plan_percentage = miss_plan_percentage
        # Missed hit count of the execution plan during the execution period.
        self.miss_plans = miss_plans
        self.ob_db_id = ob_db_id
        # Remote plan percentage during the execution period.
        self.remote_plan_percentage = remote_plan_percentage
        # Remote execution count during the execution period.
        self.remote_plans = remote_plans
        # Number of occurrences of the code 4012 during the execution period.
        self.ret_code_4012count = ret_code_4012count
        # Number of occurrences of the code 4013 during the execution period.
        self.ret_code_4013count = ret_code_4013count
        # Number of occurrences of the code 5001 during the execution period.
        self.ret_code_5001count = ret_code_5001count
        # Number of occurrences of the code 5024 during the execution period.
        self.ret_code_5024count = ret_code_5024count
        # Number of occurrences of the code 5167 during the execution period.
        self.ret_code_5167count = ret_code_5167count
        # Number of occurrences of the code 5217 during the execution period.
        self.ret_code_5217count = ret_code_5217count
        # Number of occurrences of the code 6002 during the execution period.
        self.ret_code_6002count = ret_code_6002count
        # Total retry count during the execution period.
        self.retry_count = retry_count
        # RPC count during the execution period.
        self.rpc_count = rpc_count
        # The server where the SQL is executed.
        self.server = server
        # The server IP where the SQL is executed.
        self.server_ip = server_ip
        # The server port where the SQL is executed.
        self.server_port = server_port
        # SQL ID.
        self.sql_id = sql_id
        self.sql_list = sql_list
        # SQL text (the first 100 characters).
        self.sql_text_short = sql_text_short
        # SQL type.
        self.sql_type = sql_type
        # Strong consistent transaction percentage during the execution period.
        self.strong_consistency_percentage = strong_consistency_percentage
        self.sum_db_time = sum_db_time
        # Total response time (in milliseconds) during the execution period.
        self.sum_elapsed_time = sum_elapsed_time
        # Total logical reads.
        self.sum_logical_reads = sum_logical_reads
        # Total wait time (in milliseconds) during the execution period.
        self.sum_wait_time = sum_wait_time
        # Table scan percentage during the execution period.
        self.table_scan_percentage = table_scan_percentage
        # Total wait time (in milliseconds) during the execution period.
        self.total_wait_time = total_wait_time
        # Username.
        self.user_name = user_name
        # Longest wait event during the execution period.
        self.wait_event = wait_event
        # Eventually consistent transaction percentage during the execution period.
        self.weak_consistency_percentage = weak_consistency_percentage

    def validate(self):
        if self.custom_columns:
            self.custom_columns.validate()
        if self.sql_list:
            for k in self.sql_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_affected_rows is not None:
            result['AvgAffectedRows'] = self.avg_affected_rows
        if self.avg_application_wait_time is not None:
            result['AvgApplicationWaitTime'] = self.avg_application_wait_time
        if self.avg_block_cache_hit is not None:
            result['AvgBlockCacheHit'] = self.avg_block_cache_hit
        if self.avg_block_index_cache_hit is not None:
            result['AvgBlockIndexCacheHit'] = self.avg_block_index_cache_hit
        if self.avg_bloom_filter_cache_hit is not None:
            result['AvgBloomFilterCacheHit'] = self.avg_bloom_filter_cache_hit
        if self.avg_concurrency_wait_time is not None:
            result['AvgConcurrencyWaitTime'] = self.avg_concurrency_wait_time
        if self.avg_cpu_time is not None:
            result['AvgCpuTime'] = self.avg_cpu_time
        if self.avg_db_time is not None:
            result['AvgDbTime'] = self.avg_db_time
        if self.avg_decode_time is not None:
            result['AvgDecodeTime'] = self.avg_decode_time
        if self.avg_disk_reads is not None:
            result['AvgDiskReads'] = self.avg_disk_reads
        if self.avg_elapsed_time is not None:
            result['AvgElapsedTime'] = self.avg_elapsed_time
        if self.avg_execute_time is not None:
            result['AvgExecuteTime'] = self.avg_execute_time
        if self.avg_executor_rpc_count is not None:
            result['AvgExecutorRpcCount'] = self.avg_executor_rpc_count
        if self.avg_expected_worker_count is not None:
            result['AvgExpectedWorkerCount'] = self.avg_expected_worker_count
        if self.avg_get_plan_time is not None:
            result['AvgGetPlanTime'] = self.avg_get_plan_time
        if self.avg_logical_reads is not None:
            result['AvgLogicalReads'] = self.avg_logical_reads
        if self.avg_memstore_read_rows is not None:
            result['AvgMemstoreReadRows'] = self.avg_memstore_read_rows
        if self.avg_net_time is not None:
            result['AvgNetTime'] = self.avg_net_time
        if self.avg_net_wait_time is not None:
            result['AvgNetWaitTime'] = self.avg_net_wait_time
        if self.avg_partition_count is not None:
            result['AvgPartitionCount'] = self.avg_partition_count
        if self.avg_queue_time is not None:
            result['AvgQueueTime'] = self.avg_queue_time
        if self.avg_return_rows is not None:
            result['AvgReturnRows'] = self.avg_return_rows
        if self.avg_row_cache_hit is not None:
            result['AvgRowCacheHit'] = self.avg_row_cache_hit
        if self.avg_rpc_count is not None:
            result['AvgRpcCount'] = self.avg_rpc_count
        if self.avg_schedule_time is not None:
            result['AvgScheduleTime'] = self.avg_schedule_time
        if self.avg_ssstore_read_rows is not None:
            result['AvgSsstoreReadRows'] = self.avg_ssstore_read_rows
        if self.avg_used_worker_count is not None:
            result['AvgUsedWorkerCount'] = self.avg_used_worker_count
        if self.avg_user_io_wait_time is not None:
            result['AvgUserIoWaitTime'] = self.avg_user_io_wait_time
        if self.avg_wait_count is not None:
            result['AvgWaitCount'] = self.avg_wait_count
        if self.avg_wait_time is not None:
            result['AvgWaitTime'] = self.avg_wait_time
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.cpu_percentage is not None:
            result['CpuPercentage'] = self.cpu_percentage
        if self.custom_columns is not None:
            result['CustomColumns'] = self.custom_columns.to_map()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dist_plan_percentage is not None:
            result['DistPlanPercentage'] = self.dist_plan_percentage
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.exec_ps is not None:
            result['ExecPs'] = self.exec_ps
        if self.executions is not None:
            result['Executions'] = self.executions
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.fail_percentage is not None:
            result['FailPercentage'] = self.fail_percentage
        if self.inner is not None:
            result['Inner'] = self.inner
        if self.last_fail_code is not None:
            result['LastFailCode'] = self.last_fail_code
        if self.local_plan_percentage is not None:
            result['LocalPlanPercentage'] = self.local_plan_percentage
        if self.max_affected_rows is not None:
            result['MaxAffectedRows'] = self.max_affected_rows
        if self.max_application_wait_time is not None:
            result['MaxApplicationWaitTime'] = self.max_application_wait_time
        if self.max_concurrency_wait_time is not None:
            result['MaxConcurrencyWaitTime'] = self.max_concurrency_wait_time
        if self.max_cpu_time is not None:
            result['MaxCpuTime'] = self.max_cpu_time
        if self.max_disk_reads is not None:
            result['MaxDiskReads'] = self.max_disk_reads
        if self.max_elapsed_time is not None:
            result['MaxElapsedTime'] = self.max_elapsed_time
        if self.max_return_rows is not None:
            result['MaxReturnRows'] = self.max_return_rows
        if self.max_user_io_wait_time is not None:
            result['MaxUserIoWaitTime'] = self.max_user_io_wait_time
        if self.max_wait_time is not None:
            result['MaxWaitTime'] = self.max_wait_time
        if self.miss_plan_percentage is not None:
            result['MissPlanPercentage'] = self.miss_plan_percentage
        if self.miss_plans is not None:
            result['MissPlans'] = self.miss_plans
        if self.ob_db_id is not None:
            result['ObDbId'] = self.ob_db_id
        if self.remote_plan_percentage is not None:
            result['RemotePlanPercentage'] = self.remote_plan_percentage
        if self.remote_plans is not None:
            result['RemotePlans'] = self.remote_plans
        if self.ret_code_4012count is not None:
            result['RetCode4012Count'] = self.ret_code_4012count
        if self.ret_code_4013count is not None:
            result['RetCode4013Count'] = self.ret_code_4013count
        if self.ret_code_5001count is not None:
            result['RetCode5001Count'] = self.ret_code_5001count
        if self.ret_code_5024count is not None:
            result['RetCode5024Count'] = self.ret_code_5024count
        if self.ret_code_5167count is not None:
            result['RetCode5167Count'] = self.ret_code_5167count
        if self.ret_code_5217count is not None:
            result['RetCode5217Count'] = self.ret_code_5217count
        if self.ret_code_6002count is not None:
            result['RetCode6002Count'] = self.ret_code_6002count
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.rpc_count is not None:
            result['RpcCount'] = self.rpc_count
        if self.server is not None:
            result['Server'] = self.server
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_port is not None:
            result['ServerPort'] = self.server_port
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        result['SqlList'] = []
        if self.sql_list is not None:
            for k in self.sql_list:
                result['SqlList'].append(k.to_map() if k else None)
        if self.sql_text_short is not None:
            result['SqlTextShort'] = self.sql_text_short
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.strong_consistency_percentage is not None:
            result['StrongConsistencyPercentage'] = self.strong_consistency_percentage
        if self.sum_db_time is not None:
            result['SumDbTime'] = self.sum_db_time
        if self.sum_elapsed_time is not None:
            result['SumElapsedTime'] = self.sum_elapsed_time
        if self.sum_logical_reads is not None:
            result['SumLogicalReads'] = self.sum_logical_reads
        if self.sum_wait_time is not None:
            result['SumWaitTime'] = self.sum_wait_time
        if self.table_scan_percentage is not None:
            result['TableScanPercentage'] = self.table_scan_percentage
        if self.total_wait_time is not None:
            result['TotalWaitTime'] = self.total_wait_time
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.wait_event is not None:
            result['WaitEvent'] = self.wait_event
        if self.weak_consistency_percentage is not None:
            result['WeakConsistencyPercentage'] = self.weak_consistency_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgAffectedRows') is not None:
            self.avg_affected_rows = m.get('AvgAffectedRows')
        if m.get('AvgApplicationWaitTime') is not None:
            self.avg_application_wait_time = m.get('AvgApplicationWaitTime')
        if m.get('AvgBlockCacheHit') is not None:
            self.avg_block_cache_hit = m.get('AvgBlockCacheHit')
        if m.get('AvgBlockIndexCacheHit') is not None:
            self.avg_block_index_cache_hit = m.get('AvgBlockIndexCacheHit')
        if m.get('AvgBloomFilterCacheHit') is not None:
            self.avg_bloom_filter_cache_hit = m.get('AvgBloomFilterCacheHit')
        if m.get('AvgConcurrencyWaitTime') is not None:
            self.avg_concurrency_wait_time = m.get('AvgConcurrencyWaitTime')
        if m.get('AvgCpuTime') is not None:
            self.avg_cpu_time = m.get('AvgCpuTime')
        if m.get('AvgDbTime') is not None:
            self.avg_db_time = m.get('AvgDbTime')
        if m.get('AvgDecodeTime') is not None:
            self.avg_decode_time = m.get('AvgDecodeTime')
        if m.get('AvgDiskReads') is not None:
            self.avg_disk_reads = m.get('AvgDiskReads')
        if m.get('AvgElapsedTime') is not None:
            self.avg_elapsed_time = m.get('AvgElapsedTime')
        if m.get('AvgExecuteTime') is not None:
            self.avg_execute_time = m.get('AvgExecuteTime')
        if m.get('AvgExecutorRpcCount') is not None:
            self.avg_executor_rpc_count = m.get('AvgExecutorRpcCount')
        if m.get('AvgExpectedWorkerCount') is not None:
            self.avg_expected_worker_count = m.get('AvgExpectedWorkerCount')
        if m.get('AvgGetPlanTime') is not None:
            self.avg_get_plan_time = m.get('AvgGetPlanTime')
        if m.get('AvgLogicalReads') is not None:
            self.avg_logical_reads = m.get('AvgLogicalReads')
        if m.get('AvgMemstoreReadRows') is not None:
            self.avg_memstore_read_rows = m.get('AvgMemstoreReadRows')
        if m.get('AvgNetTime') is not None:
            self.avg_net_time = m.get('AvgNetTime')
        if m.get('AvgNetWaitTime') is not None:
            self.avg_net_wait_time = m.get('AvgNetWaitTime')
        if m.get('AvgPartitionCount') is not None:
            self.avg_partition_count = m.get('AvgPartitionCount')
        if m.get('AvgQueueTime') is not None:
            self.avg_queue_time = m.get('AvgQueueTime')
        if m.get('AvgReturnRows') is not None:
            self.avg_return_rows = m.get('AvgReturnRows')
        if m.get('AvgRowCacheHit') is not None:
            self.avg_row_cache_hit = m.get('AvgRowCacheHit')
        if m.get('AvgRpcCount') is not None:
            self.avg_rpc_count = m.get('AvgRpcCount')
        if m.get('AvgScheduleTime') is not None:
            self.avg_schedule_time = m.get('AvgScheduleTime')
        if m.get('AvgSsstoreReadRows') is not None:
            self.avg_ssstore_read_rows = m.get('AvgSsstoreReadRows')
        if m.get('AvgUsedWorkerCount') is not None:
            self.avg_used_worker_count = m.get('AvgUsedWorkerCount')
        if m.get('AvgUserIoWaitTime') is not None:
            self.avg_user_io_wait_time = m.get('AvgUserIoWaitTime')
        if m.get('AvgWaitCount') is not None:
            self.avg_wait_count = m.get('AvgWaitCount')
        if m.get('AvgWaitTime') is not None:
            self.avg_wait_time = m.get('AvgWaitTime')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('CpuPercentage') is not None:
            self.cpu_percentage = m.get('CpuPercentage')
        if m.get('CustomColumns') is not None:
            temp_model = DescribeOasTopSQLListResponseBodyDataCustomColumns()
            self.custom_columns = temp_model.from_map(m['CustomColumns'])
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DistPlanPercentage') is not None:
            self.dist_plan_percentage = m.get('DistPlanPercentage')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('ExecPs') is not None:
            self.exec_ps = m.get('ExecPs')
        if m.get('Executions') is not None:
            self.executions = m.get('Executions')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('FailPercentage') is not None:
            self.fail_percentage = m.get('FailPercentage')
        if m.get('Inner') is not None:
            self.inner = m.get('Inner')
        if m.get('LastFailCode') is not None:
            self.last_fail_code = m.get('LastFailCode')
        if m.get('LocalPlanPercentage') is not None:
            self.local_plan_percentage = m.get('LocalPlanPercentage')
        if m.get('MaxAffectedRows') is not None:
            self.max_affected_rows = m.get('MaxAffectedRows')
        if m.get('MaxApplicationWaitTime') is not None:
            self.max_application_wait_time = m.get('MaxApplicationWaitTime')
        if m.get('MaxConcurrencyWaitTime') is not None:
            self.max_concurrency_wait_time = m.get('MaxConcurrencyWaitTime')
        if m.get('MaxCpuTime') is not None:
            self.max_cpu_time = m.get('MaxCpuTime')
        if m.get('MaxDiskReads') is not None:
            self.max_disk_reads = m.get('MaxDiskReads')
        if m.get('MaxElapsedTime') is not None:
            self.max_elapsed_time = m.get('MaxElapsedTime')
        if m.get('MaxReturnRows') is not None:
            self.max_return_rows = m.get('MaxReturnRows')
        if m.get('MaxUserIoWaitTime') is not None:
            self.max_user_io_wait_time = m.get('MaxUserIoWaitTime')
        if m.get('MaxWaitTime') is not None:
            self.max_wait_time = m.get('MaxWaitTime')
        if m.get('MissPlanPercentage') is not None:
            self.miss_plan_percentage = m.get('MissPlanPercentage')
        if m.get('MissPlans') is not None:
            self.miss_plans = m.get('MissPlans')
        if m.get('ObDbId') is not None:
            self.ob_db_id = m.get('ObDbId')
        if m.get('RemotePlanPercentage') is not None:
            self.remote_plan_percentage = m.get('RemotePlanPercentage')
        if m.get('RemotePlans') is not None:
            self.remote_plans = m.get('RemotePlans')
        if m.get('RetCode4012Count') is not None:
            self.ret_code_4012count = m.get('RetCode4012Count')
        if m.get('RetCode4013Count') is not None:
            self.ret_code_4013count = m.get('RetCode4013Count')
        if m.get('RetCode5001Count') is not None:
            self.ret_code_5001count = m.get('RetCode5001Count')
        if m.get('RetCode5024Count') is not None:
            self.ret_code_5024count = m.get('RetCode5024Count')
        if m.get('RetCode5167Count') is not None:
            self.ret_code_5167count = m.get('RetCode5167Count')
        if m.get('RetCode5217Count') is not None:
            self.ret_code_5217count = m.get('RetCode5217Count')
        if m.get('RetCode6002Count') is not None:
            self.ret_code_6002count = m.get('RetCode6002Count')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RpcCount') is not None:
            self.rpc_count = m.get('RpcCount')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerPort') is not None:
            self.server_port = m.get('ServerPort')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        self.sql_list = []
        if m.get('SqlList') is not None:
            for k in m.get('SqlList'):
                temp_model = DescribeOasTopSQLListResponseBodyDataSqlList()
                self.sql_list.append(temp_model.from_map(k))
        if m.get('SqlTextShort') is not None:
            self.sql_text_short = m.get('SqlTextShort')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StrongConsistencyPercentage') is not None:
            self.strong_consistency_percentage = m.get('StrongConsistencyPercentage')
        if m.get('SumDbTime') is not None:
            self.sum_db_time = m.get('SumDbTime')
        if m.get('SumElapsedTime') is not None:
            self.sum_elapsed_time = m.get('SumElapsedTime')
        if m.get('SumLogicalReads') is not None:
            self.sum_logical_reads = m.get('SumLogicalReads')
        if m.get('SumWaitTime') is not None:
            self.sum_wait_time = m.get('SumWaitTime')
        if m.get('TableScanPercentage') is not None:
            self.table_scan_percentage = m.get('TableScanPercentage')
        if m.get('TotalWaitTime') is not None:
            self.total_wait_time = m.get('TotalWaitTime')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('WaitEvent') is not None:
            self.wait_event = m.get('WaitEvent')
        if m.get('WeakConsistencyPercentage') is not None:
            self.weak_consistency_percentage = m.get('WeakConsistencyPercentage')
        return self


class DescribeOasTopSQLListResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeOasTopSQLListResponseBodyData] = None,
        request_id: str = None,
    ):
        # The list of Top SQL.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeOasTopSQLListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOasTopSQLListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOasTopSQLListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOasTopSQLListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutlineBindingRequest(TeaModel):
    def __init__(
        self,
        database_name: str = None,
        instance_id: str = None,
        is_concurrent_limit: bool = None,
        sqlid: str = None,
        table_name: str = None,
        tenant_id: str = None,
    ):
        # The name of the database.
        # 
        # This parameter is required.
        self.database_name = database_name
        # The ID of the OceanBase cluster.
        self.instance_id = instance_id
        # - When the value is set to True, the throttling information in the database is queried based on the SQL ID.   
        # - When the value is set to False, the bound index or execution plan in the database is queried based on the SQL ID.
        self.is_concurrent_limit = is_concurrent_limit
        # SQLID.
        # 
        # This parameter is required.
        self.sqlid = sqlid
        # The name of the tenant.    
        # It must start with a letter or an underscore (_), and contain 2 to 20 characters, which can be uppercase letters, lowercase letters, digits, and underscores (_). It cannot be set to SYS.
        # 
        # This parameter is required.
        self.table_name = table_name
        # The ID of the tenant.
        # 
        # This parameter is required.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_concurrent_limit is not None:
            result['IsConcurrentLimit'] = self.is_concurrent_limit
        if self.sqlid is not None:
            result['SQLId'] = self.sqlid
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsConcurrentLimit') is not None:
            self.is_concurrent_limit = m.get('IsConcurrentLimit')
        if m.get('SQLId') is not None:
            self.sqlid = m.get('SQLId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeOutlineBindingResponseBodyOutlineBinding(TeaModel):
    def __init__(
        self,
        bind_index: str = None,
        bind_plan: str = None,
        max_concurrent: int = None,
        outline_id: int = None,
        sql_text: str = None,
        sql_text_concurrent_num: int = None,
        table_name: str = None,
    ):
        # The bound index.
        self.bind_index = bind_index
        # The bound plan.
        self.bind_plan = bind_plan
        # The maximum number of concurrent tasks.
        self.max_concurrent = max_concurrent
        # OutlineID.
        self.outline_id = outline_id
        self.sql_text = sql_text
        self.sql_text_concurrent_num = sql_text_concurrent_num
        # The name of the tenant. The tenant name must start with a letter or an underscore (_), and contain 2 to 20 characters, which can be uppercase letters, lowercase letters, digits, and underscores (_). It cannot be set to sys.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_index is not None:
            result['BindIndex'] = self.bind_index
        if self.bind_plan is not None:
            result['BindPlan'] = self.bind_plan
        if self.max_concurrent is not None:
            result['MaxConcurrent'] = self.max_concurrent
        if self.outline_id is not None:
            result['OutlineId'] = self.outline_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.sql_text_concurrent_num is not None:
            result['SqlTextConcurrentNum'] = self.sql_text_concurrent_num
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindIndex') is not None:
            self.bind_index = m.get('BindIndex')
        if m.get('BindPlan') is not None:
            self.bind_plan = m.get('BindPlan')
        if m.get('MaxConcurrent') is not None:
            self.max_concurrent = m.get('MaxConcurrent')
        if m.get('OutlineId') is not None:
            self.outline_id = m.get('OutlineId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('SqlTextConcurrentNum') is not None:
            self.sql_text_concurrent_num = m.get('SqlTextConcurrentNum')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeOutlineBindingResponseBody(TeaModel):
    def __init__(
        self,
        outline_binding: DescribeOutlineBindingResponseBodyOutlineBinding = None,
        request_id: str = None,
    ):
        # The binding information.
        self.outline_binding = outline_binding
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.outline_binding:
            self.outline_binding.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outline_binding is not None:
            result['OutlineBinding'] = self.outline_binding.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutlineBinding') is not None:
            temp_model = DescribeOutlineBindingResponseBodyOutlineBinding()
            self.outline_binding = temp_model.from_map(m['OutlineBinding'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeOutlineBindingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutlineBindingResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutlineBindingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParametersRequest(TeaModel):
    def __init__(
        self,
        dimension: str = None,
        dimension_value: str = None,
        instance_id: str = None,
    ):
        # It is an online CLI tool that allows you to quickly retrieve and debug APIs. It can dynamically generate executable SDK code samples.
        # 
        # This parameter is required.
        self.dimension = dimension
        # Alibaba Cloud CLI
        self.dimension_value = dimension_value
        # 498529
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeParametersResponseBodyParameters(TeaModel):
    def __init__(
        self,
        acceptable_value: List[str] = None,
        current_value: str = None,
        default_value: str = None,
        description: str = None,
        name: str = None,
        need_reboot: bool = None,
        readonly: bool = None,
        rejected_value: List[str] = None,
        unit: str = None,
        value_type: str = None,
    ):
        # DescribeParameters
        self.acceptable_value = acceptable_value
        # The ID of the OceanBase cluster.
        self.current_value = current_value
        # ```
        # http(s)://[Endpoint]/?Action=DescribeParameters
        # &InstanceId=ob317v4uif****\
        # &Dimension=TENANT
        # &DimensionValue=ob2mr3oae0****\
        # &Common request parameters
        # ```
        self.default_value = default_value
        # The description of the parameter.
        self.description = description
        # The request ID.
        self.name = name
        # The name of the parameter.
        self.need_reboot = need_reboot
        # 参数是否只读
        self.readonly = readonly
        # {
        #     "RequestId": "EE205C00-30E4-XXXX-XXXX-87E3A8A2AA0C",
        #     "Parameters": [
        #         {
        #             "Description": "The maximum delay allowed in weak-consistency reads.",
        #             "ValueType": "CAPACITY",
        #             "CurrentValue": "600",
        #             "NeedReboot": false,
        #             "Name": "connect_timeout",
        #             "DefaultValue": "600s",
        #             "RejectedValue": [
        #                 "1s"
        #             ],
        #             "AcceptableValue": [
        #                 "1s"
        #             ]
        #         }
        #     ]
        # }
        self.rejected_value = rejected_value
        self.unit = unit
        # The invalid value range of the parameter.    
        # It is an array with two string elements, which represents a range. The first element represents the minimum value and the second element represents the maximum value.
        self.value_type = value_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceptable_value is not None:
            result['AcceptableValue'] = self.acceptable_value
        if self.current_value is not None:
            result['CurrentValue'] = self.current_value
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.need_reboot is not None:
            result['NeedReboot'] = self.need_reboot
        if self.readonly is not None:
            result['Readonly'] = self.readonly
        if self.rejected_value is not None:
            result['RejectedValue'] = self.rejected_value
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.value_type is not None:
            result['ValueType'] = self.value_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptableValue') is not None:
            self.acceptable_value = m.get('AcceptableValue')
        if m.get('CurrentValue') is not None:
            self.current_value = m.get('CurrentValue')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NeedReboot') is not None:
            self.need_reboot = m.get('NeedReboot')
        if m.get('Readonly') is not None:
            self.readonly = m.get('Readonly')
        if m.get('RejectedValue') is not None:
            self.rejected_value = m.get('RejectedValue')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('ValueType') is not None:
            self.value_type = m.get('ValueType')
        return self


class DescribeParametersResponseBody(TeaModel):
    def __init__(
        self,
        parameters: List[DescribeParametersResponseBodyParameters] = None,
        request_id: str = None,
    ):
        # Indicates whether a restart is required for changes to the parameter to take effect. Valid values:   
        # - true: A restart is required.   
        # - false: A restart is not required.
        self.parameters = parameters
        # The return result of the request.
        self.request_id = request_id

    def validate(self):
        if self.parameters:
            for k in self.parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Parameters'] = []
        if self.parameters is not None:
            for k in self.parameters:
                result['Parameters'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parameters = []
        if m.get('Parameters') is not None:
            for k in m.get('Parameters'):
                temp_model = DescribeParametersResponseBodyParameters()
                self.parameters.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeParametersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeParametersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeParametersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeParametersHistoryRequest(TeaModel):
    def __init__(
        self,
        dimension: str = None,
        dimension_value: str = None,
        end_time: str = None,
        instance_id: str = None,
        page_number: int = None,
        page_size: int = None,
        start_time: str = None,
    ):
        # The type of the parameter.    
        # Valid values: CLUSTER and TENANT.
        # 
        # This parameter is required.
        self.dimension = dimension
        # The resource ID of the parameter type.   
        # You can leave this parameter unspecified when you call this operation to query cluster parameters. In the case of tenant parameters, pass the tenant ID.
        self.dimension_value = dimension_value
        # The end time of the time range for querying the SQL execution history.   
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        # The number of the page to return.    
        # - Start value: 1   
        # - Default value: 1
        # 
        # This parameter is required.
        self.page_number = page_number
        # The number of rows to return on each page.   
        # - Maximum value: 100.
        # - Default value: 10
        # 
        # This parameter is required.
        self.page_size = page_size
        # The start time of querying the slow query execution.
        # The value must be UTC time in the format of YYYY-MM-DDThh:mm:ssZ.
        # 
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension is not None:
            result['Dimension'] = self.dimension
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dimension') is not None:
            self.dimension = m.get('Dimension')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeParametersHistoryResponseBodyRespondParameters(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        dimension_value: str = None,
        name: str = None,
        new_value: str = None,
        old_value: str = None,
        status: str = None,
        update_time: str = None,
    ):
        # The time when the parameter modification was initiated.
        self.create_time = create_time
        # The resource ID of the parameter type. When you called this operation to query the modification history of cluster parameters, the value is DEFAULT_DIMENSION_VALUE. When you called this operation to query the modification history of tenant parameters, the value is the tenant ID.
        self.dimension_value = dimension_value
        # The name of the parameter.
        self.name = name
        # The value of the parameter after the modification.
        self.new_value = new_value
        # The value of the parameter before the modification.
        self.old_value = old_value
        # The modification status of the parameter. Valid values: 
        # * APPLIED: The parameter was modified.
        # * SCHEDULING: The parameter was to be modified.
        self.status = status
        # The time when the parameter modification took effect.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        if self.name is not None:
            result['Name'] = self.name
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeParametersHistoryResponseBodyRespond(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        parameters: List[DescribeParametersHistoryResponseBodyRespondParameters] = None,
        total_count: int = None,
    ):
        # The number of the page to return.    
        # - Start value: 1   
        # - Default value: 1
        self.page_number = page_number
        # The information about parameters.
        self.parameters = parameters
        # The total count, which takes effect in a pagination query.
        self.total_count = total_count

    def validate(self):
        if self.parameters:
            for k in self.parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        result['Parameters'] = []
        if self.parameters is not None:
            for k in self.parameters:
                result['Parameters'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        self.parameters = []
        if m.get('Parameters') is not None:
            for k in m.get('Parameters'):
                temp_model = DescribeParametersHistoryResponseBodyRespondParameters()
                self.parameters.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeParametersHistoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        respond: DescribeParametersHistoryResponseBodyRespond = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The list of parameter modification records.
        self.respond = respond

    def validate(self):
        if self.respond:
            self.respond.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.respond is not None:
            result['Respond'] = self.respond.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Respond') is not None:
            temp_model = DescribeParametersHistoryResponseBodyRespond()
            self.respond = temp_model.from_map(m['Respond'])
        return self


class DescribeParametersHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeParametersHistoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeParametersHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProcessStatsCompositionRequest(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        instance_id: str = None,
        merge_dynamic_sql: bool = None,
        server_ip: str = None,
        sql_text: str = None,
        status: str = None,
        tenant_id: str = None,
        uid: str = None,
        users: str = None,
    ):
        # The IP address of the client.
        self.client_ip = client_ip
        # The ID of the OceanBase cluster.
        # 
        # This parameter is required.
        self.instance_id = instance_id
        self.merge_dynamic_sql = merge_dynamic_sql
        # The IP address of the server.
        self.server_ip = server_ip
        # The SQL statement, which can contain LIKE clauses. You can specify only part of the clauses in the SQL statement.
        self.sql_text = sql_text
        # The status of the session.
        self.status = status
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The user identifier (UID) of the OceanBase database.
        self.uid = uid
        # The username of the database.
        self.users = users

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.merge_dynamic_sql is not None:
            result['MergeDynamicSql'] = self.merge_dynamic_sql
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.uid is not None:
            result['UId'] = self.uid
        if self.users is not None:
            result['Users'] = self.users
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MergeDynamicSql') is not None:
            self.merge_dynamic_sql = m.get('MergeDynamicSql')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UId') is not None:
            self.uid = m.get('UId')
        if m.get('Users') is not None:
            self.users = m.get('Users')
        return self


class DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlListsProcessSqlList(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        command: str = None,
        cpu_time: int = None,
        database: str = None,
        dynamic_sql: bool = None,
        execute_time: int = None,
        plan_id: str = None,
        proxy_sess_id: str = None,
        server_ip: str = None,
        session_id: int = None,
        sql_id: str = None,
        sql_text: str = None,
        status: str = None,
        tenant_id: str = None,
        trace_id: str = None,
        user: str = None,
    ):
        self.client_ip = client_ip
        self.command = command
        self.cpu_time = cpu_time
        self.database = database
        self.dynamic_sql = dynamic_sql
        self.execute_time = execute_time
        self.plan_id = plan_id
        self.proxy_sess_id = proxy_sess_id
        self.server_ip = server_ip
        self.session_id = session_id
        self.sql_id = sql_id
        self.sql_text = sql_text
        self.status = status
        self.tenant_id = tenant_id
        self.trace_id = trace_id
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.command is not None:
            result['Command'] = self.command
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.database is not None:
            result['Database'] = self.database
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        if self.proxy_sess_id is not None:
            result['ProxySessId'] = self.proxy_sess_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        if m.get('ProxySessId') is not None:
            self.proxy_sess_id = m.get('ProxySessId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlLists(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        command: str = None,
        cpu_time: int = None,
        database: str = None,
        dynamic_sql: bool = None,
        execute_time: int = None,
        plan_id: str = None,
        process_sql_list: List[DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlListsProcessSqlList] = None,
        proxy_sess_id: str = None,
        server_ip: str = None,
        session_id: int = None,
        sql_id: str = None,
        sql_text: str = None,
        status: str = None,
        tenant_id: str = None,
        trace_id: str = None,
        user: str = None,
    ):
        self.client_ip = client_ip
        self.command = command
        self.cpu_time = cpu_time
        self.database = database
        self.dynamic_sql = dynamic_sql
        self.execute_time = execute_time
        self.plan_id = plan_id
        self.process_sql_list = process_sql_list
        self.proxy_sess_id = proxy_sess_id
        self.server_ip = server_ip
        self.session_id = session_id
        self.sql_id = sql_id
        self.sql_text = sql_text
        self.status = status
        self.tenant_id = tenant_id
        self.trace_id = trace_id
        self.user = user

    def validate(self):
        if self.process_sql_list:
            for k in self.process_sql_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.command is not None:
            result['Command'] = self.command
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.database is not None:
            result['Database'] = self.database
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        result['ProcessSqlList'] = []
        if self.process_sql_list is not None:
            for k in self.process_sql_list:
                result['ProcessSqlList'].append(k.to_map() if k else None)
        if self.proxy_sess_id is not None:
            result['ProxySessId'] = self.proxy_sess_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        self.process_sql_list = []
        if m.get('ProcessSqlList') is not None:
            for k in m.get('ProcessSqlList'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlListsProcessSqlList()
                self.process_sql_list.append(temp_model.from_map(k))
        if m.get('ProxySessId') is not None:
            self.proxy_sess_id = m.get('ProxySessId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeProcessStatsCompositionResponseBodyDataAllProcessList(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        command: str = None,
        cpu_time: int = None,
        database: str = None,
        dynamic_sql: bool = None,
        execute_time: int = None,
        plan_id: str = None,
        process_sql_lists: List[DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlLists] = None,
        proxy_sess_id: str = None,
        server_ip: str = None,
        server_sn: str = None,
        session_id: int = None,
        sql_id: str = None,
        sql_text: str = None,
        status: str = None,
        tenant_id: str = None,
        trace_id: str = None,
        user: str = None,
    ):
        # The IP address of the client.
        self.client_ip = client_ip
        # The type of the SQL statement being executed in the session.
        self.command = command
        # The CPU time spent on executing the current SQL statement, in seconds. 
        # 
        # > This parameter is introduced since OceanBase Database V3.2.4 BP5.
        self.cpu_time = cpu_time
        # The name of the database.
        self.database = database
        self.dynamic_sql = dynamic_sql
        # The definition of this parameter varies based on whether the SQL statement is executed.
        # * When the request is accepted and the result is not returned to the client, this parameter indicates the time interval between the time when the request is accepted and the current time, in seconds.
        # * When the request is not accepted, this parameter indicates the duration for which the current status lasts, in seconds.
        self.execute_time = execute_time
        # The ID of the execution plan.
        self.plan_id = plan_id
        self.process_sql_lists = process_sql_lists
        # The session ID of the client. If an OceanBase Database Proxy (ODP) is used for connection, the session ID of the ODP is returned.
        self.proxy_sess_id = proxy_sess_id
        # The IP address of the server.
        self.server_ip = server_ip
        self.server_sn = server_sn
        # The ID of the session.
        self.session_id = session_id
        # The ID of the SQL statement.
        self.sql_id = sql_id
        # The SQL text.
        self.sql_text = sql_text
        # The status of the session.
        self.status = status
        # The ID of the tenant.
        self.tenant_id = tenant_id
        # The ID of the trace.
        self.trace_id = trace_id
        # The user to which the session belongs.
        self.user = user

    def validate(self):
        if self.process_sql_lists:
            for k in self.process_sql_lists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.command is not None:
            result['Command'] = self.command
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.database is not None:
            result['Database'] = self.database
        if self.dynamic_sql is not None:
            result['DynamicSql'] = self.dynamic_sql
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.plan_id is not None:
            result['PlanId'] = self.plan_id
        result['ProcessSqlLists'] = []
        if self.process_sql_lists is not None:
            for k in self.process_sql_lists:
                result['ProcessSqlLists'].append(k.to_map() if k else None)
        if self.proxy_sess_id is not None:
            result['ProxySessId'] = self.proxy_sess_id
        if self.server_ip is not None:
            result['ServerIp'] = self.server_ip
        if self.server_sn is not None:
            result['ServerSn'] = self.server_sn
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('DynamicSql') is not None:
            self.dynamic_sql = m.get('DynamicSql')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('PlanId') is not None:
            self.plan_id = m.get('PlanId')
        self.process_sql_lists = []
        if m.get('ProcessSqlLists') is not None:
            for k in m.get('ProcessSqlLists'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataAllProcessListProcessSqlLists()
                self.process_sql_lists.append(temp_model.from_map(k))
        if m.get('ProxySessId') is not None:
            self.proxy_sess_id = m.get('ProxySessId')
        if m.get('ServerIp') is not None:
            self.server_ip = m.get('ServerIp')
        if m.get('ServerSn') is not None:
            self.server_sn = m.get('ServerSn')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsDataBaseStatistics(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        metric_value: str = None,
        total_count: int = None,
        type: str = None,
    ):
        # The number of active sessions.
        self.active_count = active_count
        # The name of the database.
        self.metric_value = metric_value
        # The total number of entries returned.
        self.total_count = total_count
        # The dimension. This value is fixed to database.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.metric_value is not None:
            result['MetricValue'] = self.metric_value
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('MetricValue') is not None:
            self.metric_value = m.get('MetricValue')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsSourceStatistics(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        metric_value: str = None,
        total_count: int = None,
        type: str = None,
    ):
        # The number of active sessions.
        self.active_count = active_count
        # The IP address of the client.
        self.metric_value = metric_value
        # The total number of entries returned.
        self.total_count = total_count
        # The dimension. This value is fixed to client.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.metric_value is not None:
            result['MetricValue'] = self.metric_value
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('MetricValue') is not None:
            self.metric_value = m.get('MetricValue')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsUserStatistics(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        metric_value: str = None,
        total_count: int = None,
        type: str = None,
    ):
        # The number of active sessions.
        self.active_count = active_count
        # The username.
        self.metric_value = metric_value
        # The total number of entries returned.
        self.total_count = total_count
        # The dimension. This value is fixed to user.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.metric_value is not None:
            result['MetricValue'] = self.metric_value
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('MetricValue') is not None:
            self.metric_value = m.get('MetricValue')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeProcessStatsCompositionResponseBodyDataSessionStatistics(TeaModel):
    def __init__(
        self,
        data_base_statistics: List[DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsDataBaseStatistics] = None,
        source_statistics: List[DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsSourceStatistics] = None,
        user_statistics: List[DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsUserStatistics] = None,
    ):
        # The session data in the database dimension.
        self.data_base_statistics = data_base_statistics
        # The session data in the client dimension.
        self.source_statistics = source_statistics
        # The session data in the user dimension.
        self.user_statistics = user_statistics

    def validate(self):
        if self.data_base_statistics:
            for k in self.data_base_statistics:
                if k:
                    k.validate()
        if self.source_statistics:
            for k in self.source_statistics:
                if k:
                    k.validate()
        if self.user_statistics:
            for k in self.user_statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataBaseStatistics'] = []
        if self.data_base_statistics is not None:
            for k in self.data_base_statistics:
                result['DataBaseStatistics'].append(k.to_map() if k else None)
        result['SourceStatistics'] = []
        if self.source_statistics is not None:
            for k in self.source_statistics:
                result['SourceStatistics'].append(k.to_map() if k else None)
        result['UserStatistics'] = []
        if self.user_statistics is not None:
            for k in self.user_statistics:
                result['UserStatistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_base_statistics = []
        if m.get('DataBaseStatistics') is not None:
            for k in m.get('DataBaseStatistics'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsDataBaseStatistics()
                self.data_base_statistics.append(temp_model.from_map(k))
        self.source_statistics = []
        if m.get('SourceStatistics') is not None:
            for k in m.get('SourceStatistics'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsSourceStatistics()
                self.source_statistics.append(temp_model.from_map(k))
        self.user_statistics = []
        if m.get('UserStatistics') is not None:
            for k in m.get('UserStatistics'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataSessionStatisticsUserStatistics()
                self.user_statistics.append(temp_model.from_map(k))
        return self


class DescribeProcessStatsCompositionResponseBodyData(TeaModel):
    def __init__(
        self,
        active_session_count: int = None,
        all_process_list: List[DescribeProcessStatsCompositionResponseBodyDataAllProcessList] = None,
        idle_session_count: int = None,
        ob_version: str = None,
        session_statistics: DescribeProcessStatsCompositionResponseBodyDataSessionStatistics = None,
        total_session_count: int = None,
    ):
        # The number of active sessions.
        self.active_session_count = active_session_count
        # The details of all sessions.
        self.all_process_list = all_process_list
        # The number of sessions in the SLEEP state.
        self.idle_session_count = idle_session_count
        # The version of OceanBase Database.
        self.ob_version = ob_version
        # The session data in different dimensions.
        self.session_statistics = session_statistics
        # The total number of sessions.
        self.total_session_count = total_session_count

    def validate(self):
        if self.all_process_list:
            for k in self.all_process_list:
                if k:
                    k.validate()
        if self.session_statistics:
            self.session_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_count is not None:
            result['ActiveSessionCount'] = self.active_session_count
        result['AllProcessList'] = []
        if self.all_process_list is not None:
            for k in self.all_process_list:
                result['AllProcessList'].append(k.to_map() if k else None)
        if self.idle_session_count is not None:
            result['IdleSessionCount'] = self.idle_session_count
        if self.ob_version is not None:
            result['ObVersion'] = self.ob_version
        if self.session_statistics is not None:
            result['SessionStatistics'] = self.session_statistics.to_map()
        if self.total_session_count is not None:
            result['TotalSessionCount'] = self.total_session_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionCount') is not None:
            self.active_session_count = m.get('ActiveSessionCount')
        self.all_process_list = []
        if m.get('AllProcessList') is not None:
            for k in m.get('AllProcessList'):
                temp_model = DescribeProcessStatsCompositionResponseBodyDataAllProcessList()
                self.all_process_list.append(temp_model.from_map(k))
        if m.get('IdleSessionCount') is not None:
            self.idle_session_count = m.get('IdleSessionCount')
        if m.get('ObVersion') is not None:
            self.ob_version = m.get('ObVersion')
        if m.get('SessionStatistics') is not None:
            temp_model = DescribeProcessStatsCompositionResponseBodyDataSessionStatistics()
            self.session_statistics = temp_model.from_map(m['SessionStatistics'])
        if m.get('TotalSessionCount') is not None:
            self.total_session_count = m.get('TotalSessionCount')
        return self


class DescribeProcessStatsCompositionResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeProcessStatsCompositionResponseBodyData = None,
        request_id: str = None,
    ):
        # The return result.
        self.data = data
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeProcessStatsCompositionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeProcessStatsCompositionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProcessStatsCompositionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProcessStatsCompositionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProjectRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
    ):
        # This parameter is required.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeProjectResponseBodyDataAlarmStats(TeaModel):
    def __init__(
        self,
        alarm_content: str = None,
        alarming: bool = None,
        open_monitor: bool = None,
        recently_trigger_count: int = None,
        rule_to_recently_trigger_count: Dict[str, int] = None,
        target: str = None,
    ):
        self.alarm_content = alarm_content
        self.alarming = alarming
        self.open_monitor = open_monitor
        self.recently_trigger_count = recently_trigger_count
        self.rule_to_recently_trigger_count = rule_to_recently_trigger_count
        self.target = target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_content is not None:
            result['AlarmContent'] = self.alarm_content
        if self.alarming is not None:
            result['Alarming'] = self.alarming
        if self.open_monitor is not None:
            result['OpenMonitor'] = self.open_monitor
        if self.recently_trigger_count is not None:
            result['RecentlyTriggerCount'] = self.recently_trigger_count
        if self.rule_to_recently_trigger_count is not None:
            result['RuleToRecentlyTriggerCount'] = self.rule_to_recently_trigger_count
        if self.target is not None:
            result['Target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmContent') is not None:
            self.alarm_content = m.get('AlarmContent')
        if m.get('Alarming') is not None:
            self.alarming = m.get('Alarming')
        if m.get('OpenMonitor') is not None:
            self.open_monitor = m.get('OpenMonitor')
        if m.get('RecentlyTriggerCount') is not None:
            self.recently_trigger_count = m.get('RecentlyTriggerCount')
        if m.get('RuleToRecentlyTriggerCount') is not None:
            self.rule_to_recently_trigger_count = m.get('RuleToRecentlyTriggerCount')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        return self


class DescribeProjectResponseBodyDataCommonTransferConfig(TeaModel):
    def __init__(
        self,
        active_active: bool = None,
        data_works_business_name: str = None,
        datahub_topic_type: str = None,
        mq_partition: int = None,
        mq_partition_mode: str = None,
        mq_serializer_type: str = None,
        rocket_mq_enable_msg_trace: bool = None,
        rocket_mq_msg_tags: str = None,
        rocket_mq_producer_group: str = None,
        rocket_mq_send_msg_timeout: int = None,
        sink_store_format: str = None,
        source_store_format: str = None,
        table_category: str = None,
    ):
        self.active_active = active_active
        self.data_works_business_name = data_works_business_name
        self.datahub_topic_type = datahub_topic_type
        self.mq_partition = mq_partition
        self.mq_partition_mode = mq_partition_mode
        self.mq_serializer_type = mq_serializer_type
        self.rocket_mq_enable_msg_trace = rocket_mq_enable_msg_trace
        self.rocket_mq_msg_tags = rocket_mq_msg_tags
        self.rocket_mq_producer_group = rocket_mq_producer_group
        self.rocket_mq_send_msg_timeout = rocket_mq_send_msg_timeout
        self.sink_store_format = sink_store_format
        self.source_store_format = source_store_format
        self.table_category = table_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_active is not None:
            result['ActiveActive'] = self.active_active
        if self.data_works_business_name is not None:
            result['DataWorksBusinessName'] = self.data_works_business_name
        if self.datahub_topic_type is not None:
            result['DatahubTopicType'] = self.datahub_topic_type
        if self.mq_partition is not None:
            result['MqPartition'] = self.mq_partition
        if self.mq_partition_mode is not None:
            result['MqPartitionMode'] = self.mq_partition_mode
        if self.mq_serializer_type is not None:
            result['MqSerializerType'] = self.mq_serializer_type
        if self.rocket_mq_enable_msg_trace is not None:
            result['RocketMqEnableMsgTrace'] = self.rocket_mq_enable_msg_trace
        if self.rocket_mq_msg_tags is not None:
            result['RocketMqMsgTags'] = self.rocket_mq_msg_tags
        if self.rocket_mq_producer_group is not None:
            result['RocketMqProducerGroup'] = self.rocket_mq_producer_group
        if self.rocket_mq_send_msg_timeout is not None:
            result['RocketMqSendMsgTimeout'] = self.rocket_mq_send_msg_timeout
        if self.sink_store_format is not None:
            result['SinkStoreFormat'] = self.sink_store_format
        if self.source_store_format is not None:
            result['SourceStoreFormat'] = self.source_store_format
        if self.table_category is not None:
            result['TableCategory'] = self.table_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveActive') is not None:
            self.active_active = m.get('ActiveActive')
        if m.get('DataWorksBusinessName') is not None:
            self.data_works_business_name = m.get('DataWorksBusinessName')
        if m.get('DatahubTopicType') is not None:
            self.datahub_topic_type = m.get('DatahubTopicType')
        if m.get('MqPartition') is not None:
            self.mq_partition = m.get('MqPartition')
        if m.get('MqPartitionMode') is not None:
            self.mq_partition_mode = m.get('MqPartitionMode')
        if m.get('MqSerializerType') is not None:
            self.mq_serializer_type = m.get('MqSerializerType')
        if m.get('RocketMqEnableMsgTrace') is not None:
            self.rocket_mq_enable_msg_trace = m.get('RocketMqEnableMsgTrace')
        if m.get('RocketMqMsgTags') is not None:
            self.rocket_mq_msg_tags = m.get('RocketMqMsgTags')
        if m.get('RocketMqProducerGroup') is not None:
            self.rocket_mq_producer_group = m.get('RocketMqProducerGroup')
        if m.get('RocketMqSendMsgTimeout') is not None:
            self.rocket_mq_send_msg_timeout = m.get('RocketMqSendMsgTimeout')
        if m.get('SinkStoreFormat') is not None:
            self.sink_store_format = m.get('SinkStoreFormat')
        if m.get('SourceStoreFormat') is not None:
            self.source_store_format = m.get('SourceStoreFormat')
        if m.get('TableCategory') is not None:
            self.table_category = m.get('TableCategory')
        return self


class DescribeProjectResponseBodyDataExtraInfo(TeaModel):
    def __init__(
        self,
        access_ob_source: bool = None,
        ignore_unsupport_ddl: bool = None,
        incr_sync_timestamp: int = None,
        log_service_start_checkpoint: int = None,
        max_connector_count: int = None,
        monitoring_incr: bool = None,
        overwrite_config: bool = None,
        reverse_subtopics: List[str] = None,
        running_progress: int = None,
        running_step: str = None,
        source_store_kept_hour: int = None,
        store_incr: bool = None,
        sub_conds: Dict[str, List[DataExtraInfoSubCondsValue]] = None,
        sub_dbs: Dict[str, List[DataExtraInfoSubDbsValue]] = None,
        sub_ids: Dict[str, str] = None,
        subtopics: List[str] = None,
        sync_delay: int = None,
        sync_delay_sample_timestamp: int = None,
    ):
        self.access_ob_source = access_ob_source
        self.ignore_unsupport_ddl = ignore_unsupport_ddl
        self.incr_sync_timestamp = incr_sync_timestamp
        self.log_service_start_checkpoint = log_service_start_checkpoint
        self.max_connector_count = max_connector_count
        self.monitoring_incr = monitoring_incr
        self.overwrite_config = overwrite_config
        self.reverse_subtopics = reverse_subtopics
        self.running_progress = running_progress
        self.running_step = running_step
        self.source_store_kept_hour = source_store_kept_hour
        self.store_incr = store_incr
        self.sub_conds = sub_conds
        self.sub_dbs = sub_dbs
        self.sub_ids = sub_ids
        self.subtopics = subtopics
        self.sync_delay = sync_delay
        self.sync_delay_sample_timestamp = sync_delay_sample_timestamp

    def validate(self):
        if self.sub_conds:
            for v in self.sub_conds.values():
                for k1 in v:
                    if k1:
                        k1.validate()
        if self.sub_dbs:
            for v in self.sub_dbs.values():
                for k1 in v:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_ob_source is not None:
            result['AccessObSource'] = self.access_ob_source
        if self.ignore_unsupport_ddl is not None:
            result['IgnoreUnsupportDdl'] = self.ignore_unsupport_ddl
        if self.incr_sync_timestamp is not None:
            result['IncrSyncTimestamp'] = self.incr_sync_timestamp
        if self.log_service_start_checkpoint is not None:
            result['LogServiceStartCheckpoint'] = self.log_service_start_checkpoint
        if self.max_connector_count is not None:
            result['MaxConnectorCount'] = self.max_connector_count
        if self.monitoring_incr is not None:
            result['MonitoringIncr'] = self.monitoring_incr
        if self.overwrite_config is not None:
            result['OverwriteConfig'] = self.overwrite_config
        if self.reverse_subtopics is not None:
            result['ReverseSubtopics'] = self.reverse_subtopics
        if self.running_progress is not None:
            result['RunningProgre