import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudinitProviderConfig {
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit#alias CloudinitProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/cloudinit cloudinit}
*/
export declare class CloudinitProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "cloudinit";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/cloudinit cloudinit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudinitProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: CloudinitProviderConfig);
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
