import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#base64_encode Config#base64_encode}
    */
    readonly base64Encode?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#boundary Config#boundary}
    */
    readonly boundary?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#gzip Config#gzip}
    */
    readonly gzip?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#id Config#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * part block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#part Config#part}
    */
    readonly part: ConfigPart[] | cdktf.IResolvable;
}
export interface ConfigPart {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#content Config#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#content_type Config#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#filename Config#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/cloudinit/r/config#merge_type Config#merge_type}
    */
    readonly mergeType?: string;
}
export declare function configPartToTerraform(struct?: ConfigPart | cdktf.IResolvable): any;
export declare class ConfigPartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConfigPart | cdktf.IResolvable | undefined;
    set internalValue(value: ConfigPart | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _mergeType?;
    get mergeType(): string;
    set mergeType(value: string);
    resetMergeType(): void;
    get mergeTypeInput(): string | undefined;
}
export declare class ConfigPartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConfigPart[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConfigPartOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/cloudinit/r/config cloudinit_config}
*/
export declare class Config extends cdktf.TerraformResource {
    static readonly tfResourceType = "cloudinit_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/cloudinit/r/config cloudinit_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConfigConfig
    */
    constructor(scope: Construct, id: string, config: ConfigConfig);
    private _base64Encode?;
    get base64Encode(): boolean | cdktf.IResolvable;
    set base64Encode(value: boolean | cdktf.IResolvable);
    resetBase64Encode(): void;
    get base64EncodeInput(): boolean | cdktf.IResolvable | undefined;
    private _boundary?;
    get boundary(): string;
    set boundary(value: string);
    resetBoundary(): void;
    get boundaryInput(): string | undefined;
    private _gzip?;
    get gzip(): boolean | cdktf.IResolvable;
    set gzip(value: boolean | cdktf.IResolvable);
    resetGzip(): void;
    get gzipInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get rendered(): string;
    private _part;
    get part(): ConfigPartList;
    putPart(value: ConfigPart[] | cdktf.IResolvable): void;
    get partInput(): cdktf.IResolvable | ConfigPart[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
