# coding: utf-8

"""
    College Football Data API

    This is an API for query various college football datasets and analytics. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.9.3
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr

from typing import List, Optional, Union

from cfbd.models.field_goal_ep import FieldGoalEP
from cfbd.models.play_win_probability import PlayWinProbability
from cfbd.models.player_game_predicted_points_added import PlayerGamePredictedPointsAdded
from cfbd.models.player_season_predicted_points_added import PlayerSeasonPredictedPointsAdded
from cfbd.models.predicted_points_value import PredictedPointsValue
from cfbd.models.pregame_win_probability import PregameWinProbability
from cfbd.models.season_type import SeasonType
from cfbd.models.team_game_predicted_points_added import TeamGamePredictedPointsAdded
from cfbd.models.team_season_predicted_points_added import TeamSeasonPredictedPointsAdded

from cfbd.api_client import ApiClient
from cfbd.api_response import ApiResponse
from cfbd.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MetricsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_field_goal_expected_points(self, **kwargs) -> List[FieldGoalEP]:  # noqa: E501
        """get_field_goal_expected_points  # noqa: E501

        Queries field goal expected points values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_field_goal_expected_points(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[FieldGoalEP]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_field_goal_expected_points_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_field_goal_expected_points_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_field_goal_expected_points_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_field_goal_expected_points  # noqa: E501

        Queries field goal expected points values  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_field_goal_expected_points_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[FieldGoalEP], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_field_goal_expected_points" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[FieldGoalEP]",
        }

        return self.api_client.call_api(
            '/metrics/fg/ep', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_predicted_points(self, down : Annotated[StrictInt, Field(..., description="Down value")], distance : Annotated[StrictInt, Field(..., description="Distance value")], **kwargs) -> List[PredictedPointsValue]:  # noqa: E501
        """get_predicted_points  # noqa: E501

        Query Predicted Points values by down and distance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points(down, distance, async_req=True)
        >>> result = thread.get()

        :param down: Down value (required)
        :type down: int
        :param distance: Distance value (required)
        :type distance: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PredictedPointsValue]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_predicted_points_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_predicted_points_with_http_info(down, distance, **kwargs)  # noqa: E501

    @validate_arguments
    def get_predicted_points_with_http_info(self, down : Annotated[StrictInt, Field(..., description="Down value")], distance : Annotated[StrictInt, Field(..., description="Distance value")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_predicted_points  # noqa: E501

        Query Predicted Points values by down and distance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_with_http_info(down, distance, async_req=True)
        >>> result = thread.get()

        :param down: Down value (required)
        :type down: int
        :param distance: Distance value (required)
        :type distance: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PredictedPointsValue], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'down',
            'distance'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_predicted_points" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('down') is not None:  # noqa: E501
            _query_params.append(('down', _params['down']))

        if _params.get('distance') is not None:  # noqa: E501
            _query_params.append(('distance', _params['distance']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PredictedPointsValue]",
        }

        return self.api_client.call_api(
            '/ppa/predicted', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_predicted_points_added_by_game(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference abbreviation filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> List[TeamGamePredictedPointsAdded]:  # noqa: E501
        """get_predicted_points_added_by_game  # noqa: E501

        Retrieves historical team PPA metrics by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_game(year, week, season_type, team, conference, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference abbreviation filter
        :type conference: str
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[TeamGamePredictedPointsAdded]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_predicted_points_added_by_game_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_predicted_points_added_by_game_with_http_info(year, week, season_type, team, conference, exclude_garbage_time, **kwargs)  # noqa: E501

    @validate_arguments
    def get_predicted_points_added_by_game_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference abbreviation filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_predicted_points_added_by_game  # noqa: E501

        Retrieves historical team PPA metrics by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_game_with_http_info(year, week, season_type, team, conference, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Optional team filter
        :type team: str
        :param conference: Optional conference abbreviation filter
        :type conference: str
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[TeamGamePredictedPointsAdded], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'season_type',
            'team',
            'conference',
            'exclude_garbage_time'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_predicted_points_added_by_game" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[TeamGamePredictedPointsAdded]",
        }

        return self.api_client.call_api(
            '/ppa/games', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_predicted_points_added_by_player_game(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[Optional[StrictInt], Field(description="Week filter, required if team not specified")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if week not specified")] = None, position : Annotated[Optional[StrictStr], Field(description="Optional player position abbreviation filter")] = None, player_id : Annotated[Optional[StrictStr], Field(description="Optional player ID filter")] = None, threshold : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Threshold value for minimum number of plays")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> List[PlayerGamePredictedPointsAdded]:  # noqa: E501
        """get_predicted_points_added_by_player_game  # noqa: E501

        Queries player PPA statistics by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_player_game(year, week, season_type, team, position, player_id, threshold, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Week filter, required if team not specified
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Team filter, required if week not specified
        :type team: str
        :param position: Optional player position abbreviation filter
        :type position: str
        :param player_id: Optional player ID filter
        :type player_id: str
        :param threshold: Threshold value for minimum number of plays
        :type threshold: float
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayerGamePredictedPointsAdded]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_predicted_points_added_by_player_game_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_predicted_points_added_by_player_game_with_http_info(year, week, season_type, team, position, player_id, threshold, exclude_garbage_time, **kwargs)  # noqa: E501

    @validate_arguments
    def get_predicted_points_added_by_player_game_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[Optional[StrictInt], Field(description="Week filter, required if team not specified")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if week not specified")] = None, position : Annotated[Optional[StrictStr], Field(description="Optional player position abbreviation filter")] = None, player_id : Annotated[Optional[StrictStr], Field(description="Optional player ID filter")] = None, threshold : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Threshold value for minimum number of plays")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_predicted_points_added_by_player_game  # noqa: E501

        Queries player PPA statistics by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_player_game_with_http_info(year, week, season_type, team, position, player_id, threshold, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Week filter, required if team not specified
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Team filter, required if week not specified
        :type team: str
        :param position: Optional player position abbreviation filter
        :type position: str
        :param player_id: Optional player ID filter
        :type player_id: str
        :param threshold: Threshold value for minimum number of plays
        :type threshold: float
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayerGamePredictedPointsAdded], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'season_type',
            'team',
            'position',
            'player_id',
            'threshold',
            'exclude_garbage_time'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_predicted_points_added_by_player_game" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('position') is not None:  # noqa: E501
            _query_params.append(('position', _params['position']))

        if _params.get('player_id') is not None:  # noqa: E501
            _query_params.append(('playerId', _params['player_id']))

        if _params.get('threshold') is not None:  # noqa: E501
            _query_params.append(('threshold', _params['threshold']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayerGamePredictedPointsAdded]",
        }

        return self.api_client.call_api(
            '/ppa/players/games', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_predicted_points_added_by_player_season(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if playerId not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference abbreviation filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, position : Annotated[Optional[StrictStr], Field(description="Optional position abbreviation filter")] = None, player_id : Annotated[Optional[StrictStr], Field(description="Player ID filter, required if year not specified")] = None, threshold : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Threshold value for minimum number of plays")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> List[PlayerSeasonPredictedPointsAdded]:  # noqa: E501
        """get_predicted_points_added_by_player_season  # noqa: E501

        Queries player PPA statistics by season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_player_season(year, conference, team, position, player_id, threshold, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if playerId not specified
        :type year: int
        :param conference: Optional conference abbreviation filter
        :type conference: str
        :param team: Optional team filter
        :type team: str
        :param position: Optional position abbreviation filter
        :type position: str
        :param player_id: Player ID filter, required if year not specified
        :type player_id: str
        :param threshold: Threshold value for minimum number of plays
        :type threshold: float
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayerSeasonPredictedPointsAdded]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_predicted_points_added_by_player_season_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_predicted_points_added_by_player_season_with_http_info(year, conference, team, position, player_id, threshold, exclude_garbage_time, **kwargs)  # noqa: E501

    @validate_arguments
    def get_predicted_points_added_by_player_season_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if playerId not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference abbreviation filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, position : Annotated[Optional[StrictStr], Field(description="Optional position abbreviation filter")] = None, player_id : Annotated[Optional[StrictStr], Field(description="Player ID filter, required if year not specified")] = None, threshold : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Threshold value for minimum number of plays")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Optional flag to exclude garbage time plays")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_predicted_points_added_by_player_season  # noqa: E501

        Queries player PPA statistics by season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_player_season_with_http_info(year, conference, team, position, player_id, threshold, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if playerId not specified
        :type year: int
        :param conference: Optional conference abbreviation filter
        :type conference: str
        :param team: Optional team filter
        :type team: str
        :param position: Optional position abbreviation filter
        :type position: str
        :param player_id: Player ID filter, required if year not specified
        :type player_id: str
        :param threshold: Threshold value for minimum number of plays
        :type threshold: float
        :param exclude_garbage_time: Optional flag to exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayerSeasonPredictedPointsAdded], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'conference',
            'team',
            'position',
            'player_id',
            'threshold',
            'exclude_garbage_time'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_predicted_points_added_by_player_season" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('position') is not None:  # noqa: E501
            _query_params.append(('position', _params['position']))

        if _params.get('player_id') is not None:  # noqa: E501
            _query_params.append(('playerId', _params['player_id']))

        if _params.get('threshold') is not None:  # noqa: E501
            _query_params.append(('threshold', _params['threshold']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayerSeasonPredictedPointsAdded]",
        }

        return self.api_client.call_api(
            '/ppa/players/season', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_predicted_points_added_by_team(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Conference abbreviation filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Exclude garbage time plays")] = None, **kwargs) -> List[TeamSeasonPredictedPointsAdded]:  # noqa: E501
        """get_predicted_points_added_by_team  # noqa: E501

        Retrieves historical team PPA metrics by season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_team(year, team, conference, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Conference abbreviation filter
        :type conference: str
        :param exclude_garbage_time: Exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[TeamSeasonPredictedPointsAdded]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_predicted_points_added_by_team_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_predicted_points_added_by_team_with_http_info(year, team, conference, exclude_garbage_time, **kwargs)  # noqa: E501

    @validate_arguments
    def get_predicted_points_added_by_team_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Year filter, required if team not specified")] = None, team : Annotated[Optional[StrictStr], Field(description="Team filter, required if year not specified")] = None, conference : Annotated[Optional[StrictStr], Field(description="Conference abbreviation filter")] = None, exclude_garbage_time : Annotated[Optional[StrictBool], Field(description="Exclude garbage time plays")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_predicted_points_added_by_team  # noqa: E501

        Retrieves historical team PPA metrics by season  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_predicted_points_added_by_team_with_http_info(year, team, conference, exclude_garbage_time, async_req=True)
        >>> result = thread.get()

        :param year: Year filter, required if team not specified
        :type year: int
        :param team: Team filter, required if year not specified
        :type team: str
        :param conference: Conference abbreviation filter
        :type conference: str
        :param exclude_garbage_time: Exclude garbage time plays
        :type exclude_garbage_time: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[TeamSeasonPredictedPointsAdded], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'team',
            'conference',
            'exclude_garbage_time'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_predicted_points_added_by_team" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('exclude_garbage_time') is not None:  # noqa: E501
            _query_params.append(('excludeGarbageTime', _params['exclude_garbage_time']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[TeamSeasonPredictedPointsAdded]",
        }

        return self.api_client.call_api(
            '/ppa/teams', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_pregame_win_probabilities(self, year : Annotated[Optional[StrictInt], Field(description="Optional year filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, **kwargs) -> List[PregameWinProbability]:  # noqa: E501
        """get_pregame_win_probabilities  # noqa: E501

        Queries pregame win probabilities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pregame_win_probabilities(year, week, season_type, team, async_req=True)
        >>> result = thread.get()

        :param year: Optional year filter
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Optional team filter
        :type team: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PregameWinProbability]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_pregame_win_probabilities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_pregame_win_probabilities_with_http_info(year, week, season_type, team, **kwargs)  # noqa: E501

    @validate_arguments
    def get_pregame_win_probabilities_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Optional year filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_pregame_win_probabilities  # noqa: E501

        Queries pregame win probabilities  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pregame_win_probabilities_with_http_info(year, week, season_type, team, async_req=True)
        >>> result = thread.get()

        :param year: Optional year filter
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param team: Optional team filter
        :type team: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PregameWinProbability], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'season_type',
            'team'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pregame_win_probabilities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PregameWinProbability]",
        }

        return self.api_client.call_api(
            '/metrics/wp/pregame', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_win_probability(self, game_id : Annotated[StrictInt, Field(..., description="Required game ID filter")], **kwargs) -> List[PlayWinProbability]:  # noqa: E501
        """get_win_probability  # noqa: E501

        Query play win probabilities by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_win_probability(game_id, async_req=True)
        >>> result = thread.get()

        :param game_id: Required game ID filter (required)
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayWinProbability]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_win_probability_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_win_probability_with_http_info(game_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_win_probability_with_http_info(self, game_id : Annotated[StrictInt, Field(..., description="Required game ID filter")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_win_probability  # noqa: E501

        Query play win probabilities by game  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_win_probability_with_http_info(game_id, async_req=True)
        >>> result = thread.get()

        :param game_id: Required game ID filter (required)
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayWinProbability], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'game_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_win_probability" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('game_id') is not None:  # noqa: E501
            _query_params.append(('gameId', _params['game_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayWinProbability]",
        }

        return self.api_client.call_api(
            '/metrics/wp', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
