# coding: utf-8

"""
    College Football Data API

    This is an API for query various college football datasets and analytics. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.9.3
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import List, Optional

from cfbd.models.division_classification import DivisionClassification
from cfbd.models.live_game import LiveGame
from cfbd.models.play import Play
from cfbd.models.play_stat import PlayStat
from cfbd.models.play_stat_type import PlayStatType
from cfbd.models.play_type import PlayType
from cfbd.models.season_type import SeasonType

from cfbd.api_client import ApiClient
from cfbd.api_response import ApiResponse
from cfbd.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PlaysApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_live_plays(self, game_id : Annotated[StrictInt, Field(..., description="Game Id filter")], **kwargs) -> LiveGame:  # noqa: E501
        """get_live_plays  # noqa: E501

        Queries live play-by-play data and advanced stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_plays(game_id, async_req=True)
        >>> result = thread.get()

        :param game_id: Game Id filter (required)
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveGame
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_live_plays_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_live_plays_with_http_info(game_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_live_plays_with_http_info(self, game_id : Annotated[StrictInt, Field(..., description="Game Id filter")], **kwargs) -> ApiResponse:  # noqa: E501
        """get_live_plays  # noqa: E501

        Queries live play-by-play data and advanced stats  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_plays_with_http_info(game_id, async_req=True)
        >>> result = thread.get()

        :param game_id: Game Id filter (required)
        :type game_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveGame, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'game_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_live_plays" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('game_id') is not None:  # noqa: E501
            _query_params.append(('gameId', _params['game_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "LiveGame",
        }

        return self.api_client.call_api(
            '/live/plays', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_play_stat_types(self, **kwargs) -> List[PlayStatType]:  # noqa: E501
        """get_play_stat_types  # noqa: E501

        Retrieves available play stat types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_stat_types(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayStatType]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_play_stat_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_play_stat_types_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_play_stat_types_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_play_stat_types  # noqa: E501

        Retrieves available play stat types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_stat_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayStatType], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_play_stat_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayStatType]",
        }

        return self.api_client.call_api(
            '/plays/stats/types', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_play_stats(self, year : Annotated[Optional[StrictInt], Field(description="Optional year filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, game_id : Annotated[Optional[StrictInt], Field(description="Optional gameId filter")] = None, athlete_id : Annotated[Optional[StrictInt], Field(description="Optional athleteId filter")] = None, stat_type_id : Annotated[Optional[StrictInt], Field(description="Optional statTypeId filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> List[PlayStat]:  # noqa: E501
        """get_play_stats  # noqa: E501

        Retrieve player-play associations (limit 2000)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_stats(year, week, team, game_id, athlete_id, stat_type_id, season_type, conference, async_req=True)
        >>> result = thread.get()

        :param year: Optional year filter
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param game_id: Optional gameId filter
        :type game_id: int
        :param athlete_id: Optional athleteId filter
        :type athlete_id: int
        :param stat_type_id: Optional statTypeId filter
        :type stat_type_id: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayStat]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_play_stats_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_play_stats_with_http_info(year, week, team, game_id, athlete_id, stat_type_id, season_type, conference, **kwargs)  # noqa: E501

    @validate_arguments
    def get_play_stats_with_http_info(self, year : Annotated[Optional[StrictInt], Field(description="Optional year filter")] = None, week : Annotated[Optional[StrictInt], Field(description="Optional week filter")] = None, team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, game_id : Annotated[Optional[StrictInt], Field(description="Optional gameId filter")] = None, athlete_id : Annotated[Optional[StrictInt], Field(description="Optional athleteId filter")] = None, stat_type_id : Annotated[Optional[StrictInt], Field(description="Optional statTypeId filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_play_stats  # noqa: E501

        Retrieve player-play associations (limit 2000)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_stats_with_http_info(year, week, team, game_id, athlete_id, stat_type_id, season_type, conference, async_req=True)
        >>> result = thread.get()

        :param year: Optional year filter
        :type year: int
        :param week: Optional week filter
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param game_id: Optional gameId filter
        :type game_id: int
        :param athlete_id: Optional athleteId filter
        :type athlete_id: int
        :param stat_type_id: Optional statTypeId filter
        :type stat_type_id: int
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param conference: Optional conference filter
        :type conference: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayStat], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'team',
            'game_id',
            'athlete_id',
            'stat_type_id',
            'season_type',
            'conference'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_play_stats" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('game_id') is not None:  # noqa: E501
            _query_params.append(('gameId', _params['game_id']))

        if _params.get('athlete_id') is not None:  # noqa: E501
            _query_params.append(('athleteId', _params['athlete_id']))

        if _params.get('stat_type_id') is not None:  # noqa: E501
            _query_params.append(('statTypeId', _params['stat_type_id']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayStat]",
        }

        return self.api_client.call_api(
            '/plays/stats', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_play_types(self, **kwargs) -> List[PlayType]:  # noqa: E501
        """get_play_types  # noqa: E501

        Retrieves available play types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_types(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[PlayType]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_play_types_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_play_types_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_play_types_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """get_play_types  # noqa: E501

        Retrieves available play types  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_play_types_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PlayType], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_play_types" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[PlayType]",
        }

        return self.api_client.call_api(
            '/plays/types', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_plays(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[StrictInt, Field(..., description="Required week filter")], team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, offense : Annotated[Optional[StrictStr], Field(description="Optional offensive team filter")] = None, defense : Annotated[Optional[StrictStr], Field(description="Optional defensive team filter")] = None, offense_conference : Annotated[Optional[StrictStr], Field(description="Optional offensive conference filter")] = None, defense_conference : Annotated[Optional[StrictStr], Field(description="Optional defensive conference filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, play_type : Annotated[Optional[StrictStr], Field(description="Optoinal play type abbreviation filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, **kwargs) -> List[Play]:  # noqa: E501
        """get_plays  # noqa: E501

        Retrieves historical play data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_plays(year, week, team, offense, defense, offense_conference, defense_conference, conference, play_type, season_type, classification, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Required week filter (required)
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param offense: Optional offensive team filter
        :type offense: str
        :param defense: Optional defensive team filter
        :type defense: str
        :param offense_conference: Optional offensive conference filter
        :type offense_conference: str
        :param defense_conference: Optional defensive conference filter
        :type defense_conference: str
        :param conference: Optional conference filter
        :type conference: str
        :param play_type: Optoinal play type abbreviation filter
        :type play_type: str
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[Play]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_plays_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_plays_with_http_info(year, week, team, offense, defense, offense_conference, defense_conference, conference, play_type, season_type, classification, **kwargs)  # noqa: E501

    @validate_arguments
    def get_plays_with_http_info(self, year : Annotated[StrictInt, Field(..., description="Required year filter")], week : Annotated[StrictInt, Field(..., description="Required week filter")], team : Annotated[Optional[StrictStr], Field(description="Optional team filter")] = None, offense : Annotated[Optional[StrictStr], Field(description="Optional offensive team filter")] = None, defense : Annotated[Optional[StrictStr], Field(description="Optional defensive team filter")] = None, offense_conference : Annotated[Optional[StrictStr], Field(description="Optional offensive conference filter")] = None, defense_conference : Annotated[Optional[StrictStr], Field(description="Optional defensive conference filter")] = None, conference : Annotated[Optional[StrictStr], Field(description="Optional conference filter")] = None, play_type : Annotated[Optional[StrictStr], Field(description="Optoinal play type abbreviation filter")] = None, season_type : Annotated[Optional[SeasonType], Field(description="Optional season type filter")] = None, classification : Annotated[Optional[DivisionClassification], Field(description="Optional division classification filter")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_plays  # noqa: E501

        Retrieves historical play data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_plays_with_http_info(year, week, team, offense, defense, offense_conference, defense_conference, conference, play_type, season_type, classification, async_req=True)
        >>> result = thread.get()

        :param year: Required year filter (required)
        :type year: int
        :param week: Required week filter (required)
        :type week: int
        :param team: Optional team filter
        :type team: str
        :param offense: Optional offensive team filter
        :type offense: str
        :param defense: Optional defensive team filter
        :type defense: str
        :param offense_conference: Optional offensive conference filter
        :type offense_conference: str
        :param defense_conference: Optional defensive conference filter
        :type defense_conference: str
        :param conference: Optional conference filter
        :type conference: str
        :param play_type: Optoinal play type abbreviation filter
        :type play_type: str
        :param season_type: Optional season type filter
        :type season_type: SeasonType
        :param classification: Optional division classification filter
        :type classification: DivisionClassification
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[Play], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'year',
            'week',
            'team',
            'offense',
            'defense',
            'offense_conference',
            'defense_conference',
            'conference',
            'play_type',
            'season_type',
            'classification'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_plays" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('year') is not None:  # noqa: E501
            _query_params.append(('year', _params['year']))

        if _params.get('week') is not None:  # noqa: E501
            _query_params.append(('week', _params['week']))

        if _params.get('team') is not None:  # noqa: E501
            _query_params.append(('team', _params['team']))

        if _params.get('offense') is not None:  # noqa: E501
            _query_params.append(('offense', _params['offense']))

        if _params.get('defense') is not None:  # noqa: E501
            _query_params.append(('defense', _params['defense']))

        if _params.get('offense_conference') is not None:  # noqa: E501
            _query_params.append(('offenseConference', _params['offense_conference']))

        if _params.get('defense_conference') is not None:  # noqa: E501
            _query_params.append(('defenseConference', _params['defense_conference']))

        if _params.get('conference') is not None:  # noqa: E501
            _query_params.append(('conference', _params['conference']))

        if _params.get('play_type') is not None:  # noqa: E501
            _query_params.append(('playType', _params['play_type']))

        if _params.get('season_type') is not None:  # noqa: E501
            _query_params.append(('seasonType', _params['season_type'].value))

        if _params.get('classification') is not None:  # noqa: E501
            _query_params.append(('classification', _params['classification'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['apiKey']  # noqa: E501

        _response_types_map = {
            '200': "List[Play]",
        }

        return self.api_client.call_api(
            '/plays', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
