# coding: utf-8

"""
    College Football Data API

    This is an API for query various college football datasets and analytics. API keys can be acquired from the CollegeFootballData.com website.

    The version of the OpenAPI document: 5.9.3
    Contact: admin@collegefootballdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt

class TeamFPIResumeRanks(BaseModel):
    """
    TeamFPIResumeRanks
    """
    game_control: Optional[StrictInt] = Field(default=..., alias="gameControl")
    remaining_strength_of_schedule: Optional[StrictInt] = Field(default=..., alias="remainingStrengthOfSchedule")
    strength_of_schedule: Optional[StrictInt] = Field(default=..., alias="strengthOfSchedule")
    average_win_probability: Optional[StrictInt] = Field(default=..., alias="averageWinProbability")
    fpi: Optional[StrictInt] = Field(...)
    strength_of_record: Optional[StrictInt] = Field(default=..., alias="strengthOfRecord")
    __properties = ["gameControl", "remainingStrengthOfSchedule", "strengthOfSchedule", "averageWinProbability", "fpi", "strengthOfRecord"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TeamFPIResumeRanks:
        """Create an instance of TeamFPIResumeRanks from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if game_control (nullable) is None
        # and __fields_set__ contains the field
        if self.game_control is None and "game_control" in self.__fields_set__:
            _dict['gameControl'] = None

        # set to None if remaining_strength_of_schedule (nullable) is None
        # and __fields_set__ contains the field
        if self.remaining_strength_of_schedule is None and "remaining_strength_of_schedule" in self.__fields_set__:
            _dict['remainingStrengthOfSchedule'] = None

        # set to None if strength_of_schedule (nullable) is None
        # and __fields_set__ contains the field
        if self.strength_of_schedule is None and "strength_of_schedule" in self.__fields_set__:
            _dict['strengthOfSchedule'] = None

        # set to None if average_win_probability (nullable) is None
        # and __fields_set__ contains the field
        if self.average_win_probability is None and "average_win_probability" in self.__fields_set__:
            _dict['averageWinProbability'] = None

        # set to None if fpi (nullable) is None
        # and __fields_set__ contains the field
        if self.fpi is None and "fpi" in self.__fields_set__:
            _dict['fpi'] = None

        # set to None if strength_of_record (nullable) is None
        # and __fields_set__ contains the field
        if self.strength_of_record is None and "strength_of_record" in self.__fields_set__:
            _dict['strengthOfRecord'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TeamFPIResumeRanks:
        """Create an instance of TeamFPIResumeRanks from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TeamFPIResumeRanks.parse_obj(obj)

        _obj = TeamFPIResumeRanks.parse_obj({
            "game_control": obj.get("gameControl"),
            "remaining_strength_of_schedule": obj.get("remainingStrengthOfSchedule"),
            "strength_of_schedule": obj.get("strengthOfSchedule"),
            "average_win_probability": obj.get("averageWinProbability"),
            "fpi": obj.get("fpi"),
            "strength_of_record": obj.get("strengthOfRecord")
        })
        return _obj


