# Python ToyCrypto

## What it does

ToyCrypto ([documentation](https://jpgoldberg.github.io/toy-crypto-math/index.html), [GitHub](https://github.com/jpgoldberg/toy-crypto-math))
had its origins as just a place I could collect some of
the bits and pieces of sample code I used to learn or illustrate certain
cryptography related concepts.
You can read more about
[the motivations](https://jpgoldberg.github.io/toy-crypto-math/why/index.html)
as you wish.
It is now something that I believe may be sufficiently useful to others
and is not too embarrassing in its code quality to be worth shamelessly plugging.

It emphatically (as stated on every documentation page and in the project's name)
is *not* intended to be used to secure anything.

## Some modules that have little new

There are many things I have that duplicate what is done better elsewhere.
There are [reasons](https://jpgoldberg.github.io/toy-crypto-math/why/index.html)
for this,
and I attempt to document that fact,
but nobody here needs to see yet another
[Miller-Rabin probably prime](https://jpgoldberg.github.io/toy-crypto-math/modules/nt.html#toy_crypto.nt.probably_prime) function.

The same goes for yet another toy RSA implementation,
though I do think there are some things in [mine](https://jpgoldberg.github.io/toy-crypto-math/modules/rsa/index.html)
may be fun such as the
[RSA129 example](https://jpgoldberg.github.io/toy-crypto-math/modules/rsa/primitive.html#the-original-example)
or the well-commented
[source](https://jpgoldberg.github.io/toy-crypto-math/_modules/toy_crypto/rsa.html#fips186_prime_gen) for
[fips186_prime_gen](https://jpgoldberg.github.io/toy-crypto-math/modules/rsa/keygen.html#toy_crypto.rsa.fips186_prime_gen).

But these and other [modules](https://jpgoldberg.github.io/toy-crypto-math/modules/index.html) may be useful for to you for my
intent of teaching and illustrating algorithms and concepts.
Additionally, they pass strict static type checking, have some test coverage, are documented, and the ones I worked on recently are legibly coded.
(There are exceptions to that last claim.)

## Modules of direct interest to the Cryptographic community

The [birthday parodox module](https://jpgoldberg.github.io/toy-crypto-math/modules/birthday.html)
is designed to yield reasonable approximations for the kinds of large numbers and
small probabilities that might be useful when exploring things like
UUID collisions or *k*-anonymity.
It is still limited by Python `float`,
but it may be useful where other offerings are not.

Have you ever wanted to illustrate something like an `IND-CPA` game?
The [security games module](https://jpgoldberg.github.io/toy-crypto-math/modules/games.html)
can help.
It is only set up for symmetric games at the moment, but I'm hoping to extend that.
Indeed, it was laying the ground work which led me to implement
[RSA OAEP](https://jpgoldberg.github.io/toy-crypto-math/modules/rsa/oaep.html),
which in turn led me wycheproof testing.

The newest (with version v0.5.0) module, [wycheproof](https://jpgoldberg.github.io/toy-crypto-math/modules/wycheproof/index.html),
is designed to save you some of the annoyance of dealing with the
wycheproof JSON data imported into Python as JSON
and replace that with the annoyance of my data classes.
Note that until someone helps me figure out how to make better use
of JSON schemata in Python, this is not nearly as robust as I had initially expected.
But I am hoping that even in its current state it will be useful.

### How does this compare

- This, as far as I know, is the only Python toy cryptography project that features
a [picture of my big-endian dog](https://jpgoldberg.github.io/toy-crypto-math/modules/rsa/oaep.html#id1).

- It is also probably the only one that features not one, not two,
but [*three* implementations](https://jpgoldberg.github.io/toy-crypto-math/modules/sieve.html#why-three-separate-implementations)
of the Sieve of Eratosthenes.

- The occasional dad joke in comments and error messages.

More seriously, some partially distinguishing features include:

- Pure Python (including dependencies), so it can be used in environments that require pure Python;

- It warns you on every page of the documentation that the cryptographic functions should not be used for security;

- Lots of documentation with passing doctests;

- Full type-annotations

- Linting and testing in CI.

### Where is it?

- PyPi: <https://pypi.org/project/toycrypto/>
- GitHub: <https://github.com/jpgoldberg/toy-crypto-math>
- Documentation: <https://jpgoldberg.github.io/toy-crypto-math/index.html>
