# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MaintenanceWindowArgs', 'MaintenanceWindow']

@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.int],
                 automatic_updates: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_day: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MaintenanceWindow resource.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] automatic_updates: Allow scheduling of a maintenance for version update
               once a new LavinMQ version been released.
        :param pulumi.Input[_builtins.str] preferred_day: Preferred day of the week when to schedule maintenance.
        :param pulumi.Input[_builtins.str] preferred_time: Preferred time (UTC) of the day when to schedule maintenance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if automatic_updates is not None:
            pulumi.set(__self__, "automatic_updates", automatic_updates)
        if preferred_day is not None:
            pulumi.set(__self__, "preferred_day", preferred_day)
        if preferred_time is not None:
            pulumi.set(__self__, "preferred_time", preferred_time)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpdates")
    def automatic_updates(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow scheduling of a maintenance for version update
        once a new LavinMQ version been released.
        """
        return pulumi.get(self, "automatic_updates")

    @automatic_updates.setter
    def automatic_updates(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_updates", value)

    @_builtins.property
    @pulumi.getter(name="preferredDay")
    def preferred_day(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred day of the week when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_day")

    @preferred_day.setter
    def preferred_day(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_day", value)

    @_builtins.property
    @pulumi.getter(name="preferredTime")
    def preferred_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred time (UTC) of the day when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_time")

    @preferred_time.setter
    def preferred_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_time", value)


@pulumi.input_type
class _MaintenanceWindowState:
    def __init__(__self__, *,
                 automatic_updates: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_day: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindow resources.
        :param pulumi.Input[_builtins.str] automatic_updates: Allow scheduling of a maintenance for version update
               once a new LavinMQ version been released.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] preferred_day: Preferred day of the week when to schedule maintenance.
        :param pulumi.Input[_builtins.str] preferred_time: Preferred time (UTC) of the day when to schedule maintenance.
        """
        if automatic_updates is not None:
            pulumi.set(__self__, "automatic_updates", automatic_updates)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if preferred_day is not None:
            pulumi.set(__self__, "preferred_day", preferred_day)
        if preferred_time is not None:
            pulumi.set(__self__, "preferred_time", preferred_time)

    @_builtins.property
    @pulumi.getter(name="automaticUpdates")
    def automatic_updates(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow scheduling of a maintenance for version update
        once a new LavinMQ version been released.
        """
        return pulumi.get(self, "automatic_updates")

    @automatic_updates.setter
    def automatic_updates(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automatic_updates", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="preferredDay")
    def preferred_day(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred day of the week when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_day")

    @preferred_day.setter
    def preferred_day(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_day", value)

    @_builtins.property
    @pulumi.getter(name="preferredTime")
    def preferred_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Preferred time (UTC) of the day when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_time")

    @preferred_time.setter
    def preferred_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_time", value)


@pulumi.type_token("cloudamqp:index/maintenanceWindow:MaintenanceWindow")
class MaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_updates: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_day: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource allows you to set the preferred start of new scheduled maintenances. The maintenance
        windows are 3 hours long and CloudAMQP attempts to begin the maintenance as close as possible to the
        preferred start. A maintenance will never start before the window.

        Available for dedicated subscription plans.

        From **August 5, 2025** LavinMQ instances will have `automatic_updates` set to `on` by default.

        ## Example Usage

        <details>
          <summary>
            <b>Set the preferred maintenance start</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday",
            preferred_time="23:00")
        ```

        </details>

        <details>
          <summary>
            <b>Set the preferred maintenance start with automatic updates</b>
          </summary>

        When setting the automatic updates to "on", a maintenance for version update will be scheduled once
        a new LavinMQ version been released.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday",
            preferred_time="23:00",
            automatic_updates="on")
        ```

        </details>

        <details>
          <summary>
            <b>Only set preferred time of day</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_time="23:00")
        ```

        </details>

        <details>
          <summary>
            <b>Only set preferred day of week</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday")
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_maintenance_window` can be imported using CloudAMQP instance identifier. To retrieve the

        identifier of an instance, use [CloudAMQP API list instances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_maintenance_window.this

          id = cloudamqp_instance.instance.id

        }

        Or with Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/maintenanceWindow:MaintenanceWindow this <id>`
        ```

        [CloudAMQP API list instances]: https://docs.cloudamqp.com/#list-instances

        [format]: https://developer.hashicorp.com/terraform/language/functions/formatdate#specification-syntax

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automatic_updates: Allow scheduling of a maintenance for version update
               once a new LavinMQ version been released.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] preferred_day: Preferred day of the week when to schedule maintenance.
        :param pulumi.Input[_builtins.str] preferred_time: Preferred time (UTC) of the day when to schedule maintenance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to set the preferred start of new scheduled maintenances. The maintenance
        windows are 3 hours long and CloudAMQP attempts to begin the maintenance as close as possible to the
        preferred start. A maintenance will never start before the window.

        Available for dedicated subscription plans.

        From **August 5, 2025** LavinMQ instances will have `automatic_updates` set to `on` by default.

        ## Example Usage

        <details>
          <summary>
            <b>Set the preferred maintenance start</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday",
            preferred_time="23:00")
        ```

        </details>

        <details>
          <summary>
            <b>Set the preferred maintenance start with automatic updates</b>
          </summary>

        When setting the automatic updates to "on", a maintenance for version update will be scheduled once
        a new LavinMQ version been released.

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday",
            preferred_time="23:00",
            automatic_updates="on")
        ```

        </details>

        <details>
          <summary>
            <b>Only set preferred time of day</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_time="23:00")
        ```

        </details>

        <details>
          <summary>
            <b>Only set preferred day of week</b>
          </summary>

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        this = cloudamqp.MaintenanceWindow("this",
            instance_id=instance["id"],
            preferred_day="Monday")
        ```

        </details>

        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_maintenance_window` can be imported using CloudAMQP instance identifier. To retrieve the

        identifier of an instance, use [CloudAMQP API list instances].

        From Terraform v1.5.0, the `import` block can be used to import this resource:

        hcl

        import {

          to = cloudamqp_maintenance_window.this

          id = cloudamqp_instance.instance.id

        }

        Or with Terraform CLI:

        ```sh
        $ pulumi import cloudamqp:index/maintenanceWindow:MaintenanceWindow this <id>`
        ```

        [CloudAMQP API list instances]: https://docs.cloudamqp.com/#list-instances

        [format]: https://developer.hashicorp.com/terraform/language/functions/formatdate#specification-syntax

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_updates: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_day: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_time: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowArgs.__new__(MaintenanceWindowArgs)

            __props__.__dict__["automatic_updates"] = automatic_updates
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["preferred_day"] = preferred_day
            __props__.__dict__["preferred_time"] = preferred_time
        super(MaintenanceWindow, __self__).__init__(
            'cloudamqp:index/maintenanceWindow:MaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_updates: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_day: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MaintenanceWindow':
        """
        Get an existing MaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automatic_updates: Allow scheduling of a maintenance for version update
               once a new LavinMQ version been released.
        :param pulumi.Input[_builtins.int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[_builtins.str] preferred_day: Preferred day of the week when to schedule maintenance.
        :param pulumi.Input[_builtins.str] preferred_time: Preferred time (UTC) of the day when to schedule maintenance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowState.__new__(_MaintenanceWindowState)

        __props__.__dict__["automatic_updates"] = automatic_updates
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["preferred_day"] = preferred_day
        __props__.__dict__["preferred_time"] = preferred_time
        return MaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticUpdates")
    def automatic_updates(self) -> pulumi.Output[_builtins.str]:
        """
        Allow scheduling of a maintenance for version update
        once a new LavinMQ version been released.
        """
        return pulumi.get(self, "automatic_updates")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="preferredDay")
    def preferred_day(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Preferred day of the week when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_day")

    @_builtins.property
    @pulumi.getter(name="preferredTime")
    def preferred_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Preferred time (UTC) of the day when to schedule maintenance.
        """
        return pulumi.get(self, "preferred_time")

