﻿---
sidebar_position: 1
---

# Getting Started

Your first steps with mem8.

## Initialize a Workspace

The easiest way to get started is with interactive initialization:

```bash
cd your-project
mem8 init
```

This will:
1. **Detect** your project type (Claude Code, Python, Node.js, etc.)
2. **Prompt** for configuration (workflow provider, template type)
3. **Generate** appropriate templates
4. **Set up** thought repository structure

### Non-Interactive Mode

For scripts or CI/CD:

```bash
mem8 init --template full --force --non-interactive
```

### Template Options

```bash
# Claude Code only
mem8 init --template claude-config

# Thoughts repository only
mem8 init --template thoughts-repo

# Both (recommended)
mem8 init --template full
```

## Your First Thought

### Research the Codebase

Start by understanding your project:

```bash
# In Claude Code, run:
/research_codebase "authentication system"
```

This creates a research document in `thoughts/shared/research/` with:
- Relevant code snippets
- Architecture notes
- Key findings

### Create a Plan

Design your implementation:

```bash
/create_plan "add OAuth2 support"
```

Generates a structured plan in `thoughts/shared/plans/` with:
- Requirements analysis
- Implementation steps
- Testing strategy

### Implement with Context

Execute your plan:

```bash
/implement_plan thoughts/shared/plans/add-oauth2-support.md
```

Claude Code will:
- Load your plan for context
- Implement step-by-step
- Check off completed steps

### Commit Your Work

Create a conventional commit:

```bash
/commit
```

Generates a commit message based on your changes.

## Search Your Thoughts

Find information quickly:

```bash
# Basic search
mem8 search "authentication"

# Limit results
mem8 search "OAuth" --limit 5

# Search specific locations
mem8 search "database" --path thoughts/shared/research
```

## Check Workspace Status

Monitor your workspace health:

```bash
# Quick status
mem8 status

# Detailed view
mem8 status --detailed
```

Shows:
- âœ… Components installed
- ðŸ“Š Thought statistics
- ðŸ”— Git status
- âš ï¸ Issues found

## Sync with Team

Share thoughts with your team:

```bash
# Two-way sync
mem8 sync

# Push your changes
mem8 sync --direction push

# Pull team changes
mem8 sync --direction pull

# Preview changes
mem8 sync --dry-run
```

## Daily Workflow

### Morning Routine

```bash
# Pull latest thoughts
mem8 sync --direction pull

# Check for issues
mem8 doctor

# Review recent research
mem8 search "research" --limit 5
```

mem8 doctor reads the `.mem8/toolbelt.json` manifest generated by your template, checking workspace folders and required CLI tooling for your platform before you start working.


### During Development

1. **Research** - Understand the code
2. **Plan** - Design your approach
3. **Implement** - Execute with context
4. **Commit** - Document your changes

### End of Day

```bash
# Share your thoughts
mem8 sync --direction push

# Check workspace
mem8 status
```

## Tips & Tricks

### Keyboard Shortcuts

In Claude Code:
- `/` - List available commands
- `Ctrl+K` - Quick command palette
- `Tab` - Autocomplete

### Search Operators

```bash
# Exact phrase
mem8 search '"exact phrase"'

# Multiple terms
mem8 search "term1 term2"

# In specific directory
mem8 search "query" --path thoughts/shared/plans
```

### Template Variables

Use environment variables in templates:

```bash
# Set your username
export MEM8_USERNAME=yourname

# Init will use it
mem8 init
```

### Backup Strategy

Thoughts are git repositories:

```bash
# Regular commits
cd thoughts
git add .
git commit -m "Update research"
git push
```

### Custom Templates

Use organization templates:

```bash
# Set as default
mem8 templates set-default your-org/templates

# All future inits use it
mem8 init
```

## Next Steps

- **[CLI Commands](./cli-commands)** - Full command reference
- **[Workflows](./workflows)** - Common development patterns
- **[External Templates](../external-templates)** - Use custom templates
- **[Troubleshooting](./troubleshooting)** - Solve common issues

## Common Tasks

### Add a New Agent

1. Create `agent-name.md` in `.claude/agents/`
2. Define the agent's purpose and tools
3. Test with Claude Code

### Add a Slash Command

1. Create `command-name.md` in `.claude/commands/`
2. Write the command prompt
3. Use in Claude Code with `/command-name`

### Share a Research Document

1. Create in `thoughts/shared/research/`
2. Commit to git
3. Team members pull with `mem8 sync`

### Find Old Decisions

```bash
mem8 search "decision" --path thoughts/shared/decisions
```

### Clean Up Old Thoughts

```bash
# Archive old thoughts
mkdir -p thoughts/archive/2024
mv thoughts/shared/research/old-* thoughts/archive/2024/
```

## Need Help?

- **Documentation** - You're reading it!
- **GitHub Issues** - https://github.com/killerapp/mem8/issues
- **Discussions** - https://github.com/killerapp/mem8/discussions
- **Diagnostics** - Run `mem8 doctor` for automated checks
