# Contributing to GraphFleet

First off, thank you for considering contributing to GraphFleet! It's people like you that make GraphFleet such a great tool.

## Code of Conduct

By participating in this project, you are expected to uphold our [Code of Conduct](CODE_OF_CONDUCT.md).

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for GraphFleet. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

- Use a clear and descriptive title for the issue to identify the problem.
- Describe the exact steps which reproduce the problem in as many details as possible.
- Provide specific examples to demonstrate the steps.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for GraphFleet, including completely new features and minor improvements to existing functionality.

- Use a clear and descriptive title for the issue to identify the suggestion.
- Provide a step-by-step description of the suggested enhancement in as many details as possible.
- Provide specific examples to demonstrate the steps.



### Pull Requests

The process described here has several goals:

- Maintain GraphFleet's quality
- Fix problems that are important to users
- Engage the community in working toward the best possible GraphFleet
- Enable a sustainable system for GraphFleet's maintainers to review contributions

Please follow these steps to have your contribution considered by the maintainers:

1. After you submit your pull request, verify that all [status checks](https://help.github.com/articles/about-status-checks/) are passing

## Styleguides

### Git Commit Messages

- Use the present tense ("Add feature" not "Added feature")
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
- Limit the first line to 72 characters or less
- Reference issues and pull requests liberally after the first line

### Python Styleguide

All Python code must adhere to the [PEP 8 style guide](https://www.python.org/dev/peps/pep-0008/).

### Documentation Styleguide

- Use [Markdown](https://daringfireball.net/projects/markdown/) for documentation.
- Reference functions and classes in backticks.

## Additional Notes

### Issue and Pull Request Labels

This section lists the labels we use to help us track and manage issues and pull requests.

* `bug` - Issues for bugs in the codebase.
* `enhancement` - Issues for new features or improvements.
* `documentation` - Issues related to documentation.
* `help-wanted` - Issues where we need help from the community.

## Thank You!

Your contributions to open source, large or small, make projects like this possible. Thank you for taking the time to contribute.

