
# Scaleway Resource Provider

The Scaleway resource provider for Pulumi lets you creating resources in [Scaleway](https://www.scaleway.com). To use
this package, please [install the Pulumi CLI first](https://pulumi.com/).

## Support

This is a community maintained provider. Please file issues and feature requests here:

[pulumiverse/pulumi-scaleway](https://github.com/pulumiverse/pulumi-scaleway/issues)

You can also reach out on one of these channels:

* `#pulumiverse` channel on the [Pulumi Community Slack](https://slack.pulumi.com)
* `#pulumi` channel on the [Scaleway Community Slack](https://slack.scaleway.com)

## Installing

This package is available in many languages in the standard packaging formats.

### Node.js (Java/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```sh
npm install @pulumiverse/scaleway
```

or `yarn`:

```sh
yarn add @pulumiverse/scaleway
```

### Python

To use from Python, install using `pip`:

```sh
pip install pulumiverse-scaleway
```

### Go

To use from Go, use `go get` to grab the latest version of the library

```sh
go get github.com/pulumiverse/pulumi-scaleway/sdk/go/...
```

### .NET

To use from Dotnet, use `dotnet add package` to install into your project. You must specify the version if it is a pre-release version.

```sh
dotnet add package Pulumiverse.Scaleway
```

## Reference

See the Pulumi registry for [API documention](https://www.pulumi.com/registry/packages/scaleway/api-docs/).
