# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServerPrivateIp',
    'ServerPrivateNetwork',
]

@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IP address.
        :param builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 created_at: Optional[builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[builtins.str]] = None,
                 status: Optional[builtins.str] = None,
                 updated_at: Optional[builtins.str] = None,
                 vlan: Optional[builtins.int] = None):
        """
        :param builtins.str id: The ID of the IP address resource.
        :param builtins.str created_at: The date and time of the creation of the Apple Silicon server.
        :param Sequence[builtins.str] ipam_ip_ids: List of IPAM IP IDs to attach to the server
        :param builtins.str status: The private network status
        :param builtins.str updated_at: The date and time of the last update of the Apple Silicon server.
        :param builtins.int vlan: The VLAN ID associated to the private network
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time of the creation of the Apple Silicon server.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of IPAM IP IDs to attach to the server
        """
        return pulumi.get(self, "ipam_ip_ids")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The private network status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        The date and time of the last update of the Apple Silicon server.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[builtins.int]:
        """
        The VLAN ID associated to the private network
        """
        return pulumi.get(self, "vlan")


