# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePolicyArgs', 'InstancePolicy']

@pulumi.input_type
class InstancePolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 instance_group_id: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 type: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.int],
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstancePolicy resource.
        :param pulumi.Input[builtins.str] action: The action to execute when the metric-based condition is met.
        :param pulumi.Input[builtins.str] instance_group_id: The ID of the Instance group related to this policy.
        :param pulumi.Input[builtins.int] priority: The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        :param pulumi.Input[builtins.str] type: How to use the number defined in `value` when determining by how many Instances to scale up/down.
        :param pulumi.Input[builtins.int] value: The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]] metrics: Cockpit metric to use when determining whether to trigger a scale up/down action.
        :param pulumi.Input[builtins.str] name: The Instance policy name.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance policy is associated with.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance policy exists.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "instance_group_id", instance_group_id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        The action to execute when the metric-based condition is met.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Instance group related to this policy.
        """
        return pulumi.get(self, "instance_group_id")

    @instance_group_id.setter
    def instance_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_group_id", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        How to use the number defined in `value` when determining by how many Instances to scale up/down.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.int]:
        """
        The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]]:
        """
        Cockpit metric to use when determining whether to trigger a scale up/down action.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Instance policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance policy is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the Instance policy exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstancePolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstancePolicy resources.
        :param pulumi.Input[builtins.str] action: The action to execute when the metric-based condition is met.
        :param pulumi.Input[builtins.str] instance_group_id: The ID of the Instance group related to this policy.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]] metrics: Cockpit metric to use when determining whether to trigger a scale up/down action.
        :param pulumi.Input[builtins.str] name: The Instance policy name.
        :param pulumi.Input[builtins.int] priority: The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance policy is associated with.
        :param pulumi.Input[builtins.str] type: How to use the number defined in `value` when determining by how many Instances to scale up/down.
        :param pulumi.Input[builtins.int] value: The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance policy exists.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if instance_group_id is not None:
            pulumi.set(__self__, "instance_group_id", instance_group_id)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to execute when the metric-based condition is met.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Instance group related to this policy.
        """
        return pulumi.get(self, "instance_group_id")

    @instance_group_id.setter
    def instance_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_group_id", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]]:
        """
        Cockpit metric to use when determining whether to trigger a scale up/down action.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Instance policy name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance policy is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to use the number defined in `value` when determining by how many Instances to scale up/down.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the Instance policy exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:autoscaling/instancePolicy:InstancePolicy")
class InstancePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePolicyMetricArgs', 'InstancePolicyMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Books and manages Autoscaling Instance policies.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        up = scaleway.autoscaling.InstancePolicy("up",
            instance_group_id=main["id"],
            name="scale-up-if-cpu-high",
            action="scale_up",
            type="flat_count",
            value=1,
            priority=1,
            metrics=[{
                "name": "cpu scale up",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_greater_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 70,
            }])
        down = scaleway.autoscaling.InstancePolicy("down",
            instance_group_id=main["id"],
            name="scale-down-if-cpu-low",
            action="scale_down",
            type="flat_count",
            value=1,
            priority=2,
            metrics=[{
                "name": "cpu scale down",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_less_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 40,
            }])
        ```

        ## Import

        Autoscaling instance policies can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instancePolicy:InstancePolicy main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The action to execute when the metric-based condition is met.
        :param pulumi.Input[builtins.str] instance_group_id: The ID of the Instance group related to this policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePolicyMetricArgs', 'InstancePolicyMetricArgsDict']]]] metrics: Cockpit metric to use when determining whether to trigger a scale up/down action.
        :param pulumi.Input[builtins.str] name: The Instance policy name.
        :param pulumi.Input[builtins.int] priority: The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance policy is associated with.
        :param pulumi.Input[builtins.str] type: How to use the number defined in `value` when determining by how many Instances to scale up/down.
        :param pulumi.Input[builtins.int] value: The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance policy exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Books and manages Autoscaling Instance policies.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        up = scaleway.autoscaling.InstancePolicy("up",
            instance_group_id=main["id"],
            name="scale-up-if-cpu-high",
            action="scale_up",
            type="flat_count",
            value=1,
            priority=1,
            metrics=[{
                "name": "cpu scale up",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_greater_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 70,
            }])
        down = scaleway.autoscaling.InstancePolicy("down",
            instance_group_id=main["id"],
            name="scale-down-if-cpu-low",
            action="scale_down",
            type="flat_count",
            value=1,
            priority=2,
            metrics=[{
                "name": "cpu scale down",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_less_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 40,
            }])
        ```

        ## Import

        Autoscaling instance policies can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instancePolicy:InstancePolicy main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstancePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePolicyMetricArgs', 'InstancePolicyMetricArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePolicyArgs.__new__(InstancePolicyArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_group_id'")
            __props__.__dict__["instance_group_id"] = instance_group_id
            __props__.__dict__["metrics"] = metrics
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project_id"] = project_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["zone"] = zone
        super(InstancePolicy, __self__).__init__(
            'scaleway:autoscaling/instancePolicy:InstancePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePolicyMetricArgs', 'InstancePolicyMetricArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.int]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'InstancePolicy':
        """
        Get an existing InstancePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The action to execute when the metric-based condition is met.
        :param pulumi.Input[builtins.str] instance_group_id: The ID of the Instance group related to this policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePolicyMetricArgs', 'InstancePolicyMetricArgsDict']]]] metrics: Cockpit metric to use when determining whether to trigger a scale up/down action.
        :param pulumi.Input[builtins.str] name: The Instance policy name.
        :param pulumi.Input[builtins.int] priority: The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance policy is associated with.
        :param pulumi.Input[builtins.str] type: How to use the number defined in `value` when determining by how many Instances to scale up/down.
        :param pulumi.Input[builtins.int] value: The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance policy exists.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePolicyState.__new__(_InstancePolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["instance_group_id"] = instance_group_id
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        __props__.__dict__["zone"] = zone
        return InstancePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        The action to execute when the metric-based condition is met.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="instanceGroupId")
    def instance_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Instance group related to this policy.
        """
        return pulumi.get(self, "instance_group_id")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.InstancePolicyMetric']]:
        """
        Cockpit metric to use when determining whether to trigger a scale up/down action.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Instance policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        The priority of this policy compared to all other scaling policies. This determines the processing order. The lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project the Instance policy is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        How to use the number defined in `value` when determining by how many Instances to scale up/down.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[builtins.int]:
        """
        The value representing the magnitude of the scaling action to take for the Instance group. Depending on the `type` parameter, this number could represent a total number of Instances in the group, a number of Instances to add, or a percentage to scale the group by.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which the Instance policy exists.
        """
        return pulumi.get(self, "zone")

