# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrivilegeResult',
    'AwaitableGetPrivilegeResult',
    'get_privilege',
    'get_privilege_output',
]

@pulumi.output_type
class GetPrivilegeResult:
    """
    A collection of values returned by getPrivilege.
    """
    def __init__(__self__, database_name=None, id=None, instance_id=None, permission=None, region=None, user_name=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> builtins.str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        The permission for this user on the database. Possible values are `readonly`, `readwrite`, `all`
        , `custom` and `none`.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> builtins.str:
        return pulumi.get(self, "user_name")


class AwaitableGetPrivilegeResult(GetPrivilegeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivilegeResult(
            database_name=self.database_name,
            id=self.id,
            instance_id=self.instance_id,
            permission=self.permission,
            region=self.region,
            user_name=self.user_name)


def get_privilege(database_name: Optional[builtins.str] = None,
                  instance_id: Optional[builtins.str] = None,
                  region: Optional[builtins.str] = None,
                  user_name: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivilegeResult:
    """
    Gets information about the privileges in a database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get the database privilege for the user "my-user" on the database "my-database" hosted on instance id 11111111-1111-1111-1111-111111111111 and on the default region. e.g: fr-par
    main = scaleway.databases.get_privilege(instance_id="11111111-1111-111111111111",
        user_name="my-user",
        database_name="my-database")
    ```


    :param builtins.str database_name: The database name.
    :param builtins.str instance_id: The Database Instance ID.
    :param builtins.str region: `region`) The region in which the resource exists.
    :param builtins.str user_name: The user name.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['userName'] = user_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:databases/getPrivilege:getPrivilege', __args__, opts=opts, typ=GetPrivilegeResult).value

    return AwaitableGetPrivilegeResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        permission=pulumi.get(__ret__, 'permission'),
        region=pulumi.get(__ret__, 'region'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_privilege_output(database_name: Optional[pulumi.Input[builtins.str]] = None,
                         instance_id: Optional[pulumi.Input[builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         user_name: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrivilegeResult]:
    """
    Gets information about the privileges in a database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get the database privilege for the user "my-user" on the database "my-database" hosted on instance id 11111111-1111-1111-1111-111111111111 and on the default region. e.g: fr-par
    main = scaleway.databases.get_privilege(instance_id="11111111-1111-111111111111",
        user_name="my-user",
        database_name="my-database")
    ```


    :param builtins.str database_name: The database name.
    :param builtins.str instance_id: The Database Instance ID.
    :param builtins.str region: `region`) The region in which the resource exists.
    :param builtins.str user_name: The user name.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    __args__['instanceId'] = instance_id
    __args__['region'] = region
    __args__['userName'] = user_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:databases/getPrivilege:getPrivilege', __args__, opts=opts, typ=GetPrivilegeResult)
    return __ret__.apply(lambda __response__: GetPrivilegeResult(
        database_name=pulumi.get(__response__, 'database_name'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        permission=pulumi.get(__response__, 'permission'),
        region=pulumi.get(__response__, 'region'),
        user_name=pulumi.get(__response__, 'user_name')))
