# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 node_type: pulumi.Input[builtins.str],
                 backup_same_region: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[builtins.int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[builtins.int]] = None,
                 disable_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 init_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_ha_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]] = None,
                 logs_policy: Optional[pulumi.Input['InstanceLogsPolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['InstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] node_type: The type of Database Instance you want to create (e.g. `db-dev-s`).
               
               > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
               interruption.
               
               > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        :param pulumi.Input[builtins.bool] backup_same_region: Boolean to store logical backups in the same region as the database instance
        :param pulumi.Input[builtins.int] backup_schedule_frequency: Backup schedule frequency in hours
        :param pulumi.Input[builtins.int] backup_schedule_retention: Backup schedule retention in days
        :param pulumi.Input[builtins.bool] disable_backup: Disable automated backup for the database instance
        :param pulumi.Input[builtins.bool] encryption_at_rest: Enable or disable encryption at rest for the Database Instance.
        :param pulumi.Input[builtins.str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
               
               > **Important** Updates to `engine` will recreate the Database Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] init_settings: Map of engine settings to be set at database initialisation.
        :param pulumi.Input[builtins.bool] is_ha_cluster: Enable or disable high availability for the Database Instance.
               
               > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]] load_balancers: List of Load Balancer endpoints of the Database Instance.
        :param pulumi.Input['InstanceLogsPolicyArgs'] logs_policy: Logs policy configuration
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input['InstancePrivateNetworkArgs'] private_network: List of Private Networks endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Database
               Instance is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region
               in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of engine settings to be set on a running instance.
        :param pulumi.Input[builtins.str] snapshot_id: The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Database Instance.
               
               > **Important** Updates to `user_name` will recreate the Database Instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.
               
               > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        :param pulumi.Input[builtins.str] volume_type: Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        pulumi.set(__self__, "node_type", node_type)
        if backup_same_region is not None:
            pulumi.set(__self__, "backup_same_region", backup_same_region)
        if backup_schedule_frequency is not None:
            pulumi.set(__self__, "backup_schedule_frequency", backup_schedule_frequency)
        if backup_schedule_retention is not None:
            pulumi.set(__self__, "backup_schedule_retention", backup_schedule_retention)
        if disable_backup is not None:
            pulumi.set(__self__, "disable_backup", disable_backup)
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if init_settings is not None:
            pulumi.set(__self__, "init_settings", init_settings)
        if is_ha_cluster is not None:
            pulumi.set(__self__, "is_ha_cluster", is_ha_cluster)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if logs_policy is not None:
            pulumi.set(__self__, "logs_policy", logs_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of Database Instance you want to create (e.g. `db-dev-s`).

        > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
        interruption.

        > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to store logical backups in the same region as the database instance
        """
        return pulumi.get(self, "backup_same_region")

    @backup_same_region.setter
    def backup_same_region(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "backup_same_region", value)

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup schedule frequency in hours
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @backup_schedule_frequency.setter
    def backup_schedule_frequency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_schedule_frequency", value)

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup schedule retention in days
        """
        return pulumi.get(self, "backup_schedule_retention")

    @backup_schedule_retention.setter
    def backup_schedule_retention(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_schedule_retention", value)

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable automated backup for the database instance
        """
        return pulumi.get(self, "disable_backup")

    @disable_backup.setter
    def disable_backup(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_backup", value)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable encryption at rest for the Database Instance.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_at_rest", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).

        > **Important** Updates to `engine` will recreate the Database Instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="initSettings")
    def init_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of engine settings to be set at database initialisation.
        """
        return pulumi.get(self, "init_settings")

    @init_settings.setter
    def init_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "init_settings", value)

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable high availability for the Database Instance.

        > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @is_ha_cluster.setter
    def is_ha_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ha_cluster", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]]:
        """
        List of Load Balancer endpoints of the Database Instance.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="logsPolicy")
    def logs_policy(self) -> Optional[pulumi.Input['InstanceLogsPolicyArgs']]:
        """
        Logs policy configuration
        """
        return pulumi.get(self, "logs_policy")

    @logs_policy.setter
    def logs_policy(self, value: Optional[pulumi.Input['InstanceLogsPolicyArgs']]):
        pulumi.set(self, "logs_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for the first user of the Database Instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['InstancePrivateNetworkArgs']]:
        """
        List of Private Networks endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['InstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the Database
        Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region
        in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of engine settings to be set on a running instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the first user of the Database Instance.

        > **Important** Updates to `user_name` will recreate the Database Instance.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.

        > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 backup_same_region: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[builtins.int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[builtins.int]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 disable_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_port: Optional[pulumi.Input[builtins.int]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 init_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_ha_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]] = None,
                 logs_policy: Optional[pulumi.Input['InstanceLogsPolicyArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]] = None,
                 private_network: Optional[pulumi.Input['InstancePrivateNetworkArgs']] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceReadReplicaArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[builtins.bool] backup_same_region: Boolean to store logical backups in the same region as the database instance
        :param pulumi.Input[builtins.int] backup_schedule_frequency: Backup schedule frequency in hours
        :param pulumi.Input[builtins.int] backup_schedule_retention: Backup schedule retention in days
        :param pulumi.Input[builtins.str] certificate: Certificate of the Database Instance.
        :param pulumi.Input[builtins.bool] disable_backup: Disable automated backup for the database instance
        :param pulumi.Input[builtins.bool] encryption_at_rest: Enable or disable encryption at rest for the Database Instance.
        :param pulumi.Input[builtins.str] endpoint_ip: (Deprecated) The IP of the Database Instance. Please use the private_network or the load_balancer attribute.
        :param pulumi.Input[builtins.int] endpoint_port: (Deprecated) The port of the Database Instance. Please use the private_network or the load_balancer attribute.
        :param pulumi.Input[builtins.str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
               
               > **Important** Updates to `engine` will recreate the Database Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] init_settings: Map of engine settings to be set at database initialisation.
        :param pulumi.Input[builtins.bool] is_ha_cluster: Enable or disable high availability for the Database Instance.
               
               > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]] load_balancers: List of Load Balancer endpoints of the Database Instance.
        :param pulumi.Input['InstanceLogsPolicyArgs'] logs_policy: Logs policy configuration
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.str] node_type: The type of Database Instance you want to create (e.g. `db-dev-s`).
               
               > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
               interruption.
               
               > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the Database Instance is associated with.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input['InstancePrivateNetworkArgs'] private_network: List of Private Networks endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Database
               Instance is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceReadReplicaArgs']]] read_replicas: List of read replicas of the Database Instance.
        :param pulumi.Input[builtins.str] region: `region`) The region
               in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of engine settings to be set on a running instance.
        :param pulumi.Input[builtins.str] snapshot_id: The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Database Instance.
               
               > **Important** Updates to `user_name` will recreate the Database Instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.
               
               > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        :param pulumi.Input[builtins.str] volume_type: Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        if backup_same_region is not None:
            pulumi.set(__self__, "backup_same_region", backup_same_region)
        if backup_schedule_frequency is not None:
            pulumi.set(__self__, "backup_schedule_frequency", backup_schedule_frequency)
        if backup_schedule_retention is not None:
            pulumi.set(__self__, "backup_schedule_retention", backup_schedule_retention)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if disable_backup is not None:
            pulumi.set(__self__, "disable_backup", disable_backup)
        if encryption_at_rest is not None:
            pulumi.set(__self__, "encryption_at_rest", encryption_at_rest)
        if endpoint_ip is not None:
            warnings.warn("""Please use the private_network or the load_balancer attribute""", DeprecationWarning)
            pulumi.log.warn("""endpoint_ip is deprecated: Please use the private_network or the load_balancer attribute""")
        if endpoint_ip is not None:
            pulumi.set(__self__, "endpoint_ip", endpoint_ip)
        if endpoint_port is not None:
            warnings.warn("""Please use the private_network or the load_balancer attribute""", DeprecationWarning)
            pulumi.log.warn("""endpoint_port is deprecated: Please use the private_network or the load_balancer attribute""")
        if endpoint_port is not None:
            pulumi.set(__self__, "endpoint_port", endpoint_port)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if init_settings is not None:
            pulumi.set(__self__, "init_settings", init_settings)
        if is_ha_cluster is not None:
            pulumi.set(__self__, "is_ha_cluster", is_ha_cluster)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if logs_policy is not None:
            pulumi.set(__self__, "logs_policy", logs_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if read_replicas is not None:
            pulumi.set(__self__, "read_replicas", read_replicas)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if volume_size_in_gb is not None:
            pulumi.set(__self__, "volume_size_in_gb", volume_size_in_gb)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to store logical backups in the same region as the database instance
        """
        return pulumi.get(self, "backup_same_region")

    @backup_same_region.setter
    def backup_same_region(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "backup_same_region", value)

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup schedule frequency in hours
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @backup_schedule_frequency.setter
    def backup_schedule_frequency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_schedule_frequency", value)

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Backup schedule retention in days
        """
        return pulumi.get(self, "backup_schedule_retention")

    @backup_schedule_retention.setter
    def backup_schedule_retention(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "backup_schedule_retention", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Certificate of the Database Instance.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable automated backup for the database instance
        """
        return pulumi.get(self, "disable_backup")

    @disable_backup.setter
    def disable_backup(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_backup", value)

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable encryption at rest for the Database Instance.
        """
        return pulumi.get(self, "encryption_at_rest")

    @encryption_at_rest.setter
    def encryption_at_rest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encryption_at_rest", value)

    @property
    @pulumi.getter(name="endpointIp")
    @_utilities.deprecated("""Please use the private_network or the load_balancer attribute""")
    def endpoint_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Deprecated) The IP of the Database Instance. Please use the private_network or the load_balancer attribute.
        """
        return pulumi.get(self, "endpoint_ip")

    @endpoint_ip.setter
    def endpoint_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_ip", value)

    @property
    @pulumi.getter(name="endpointPort")
    @_utilities.deprecated("""Please use the private_network or the load_balancer attribute""")
    def endpoint_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Deprecated) The port of the Database Instance. Please use the private_network or the load_balancer attribute.
        """
        return pulumi.get(self, "endpoint_port")

    @endpoint_port.setter
    def endpoint_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "endpoint_port", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).

        > **Important** Updates to `engine` will recreate the Database Instance.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="initSettings")
    def init_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of engine settings to be set at database initialisation.
        """
        return pulumi.get(self, "init_settings")

    @init_settings.setter
    def init_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "init_settings", value)

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable high availability for the Database Instance.

        > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @is_ha_cluster.setter
    def is_ha_cluster(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ha_cluster", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]]:
        """
        List of Load Balancer endpoints of the Database Instance.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="logsPolicy")
    def logs_policy(self) -> Optional[pulumi.Input['InstanceLogsPolicyArgs']]:
        """
        Logs policy configuration
        """
        return pulumi.get(self, "logs_policy")

    @logs_policy.setter
    def logs_policy(self, value: Optional[pulumi.Input['InstanceLogsPolicyArgs']]):
        pulumi.set(self, "logs_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Database Instance you want to create (e.g. `db-dev-s`).

        > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
        interruption.

        > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the Database Instance is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for the first user of the Database Instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['InstancePrivateNetworkArgs']]:
        """
        List of Private Networks endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['InstancePrivateNetworkArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the Database
        Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceReadReplicaArgs']]]]:
        """
        List of read replicas of the Database Instance.
        """
        return pulumi.get(self, "read_replicas")

    @read_replicas.setter
    def read_replicas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceReadReplicaArgs']]]]):
        pulumi.set(self, "read_replicas", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region
        in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of engine settings to be set on a running instance.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier for the first user of the Database Instance.

        > **Important** Updates to `user_name` will recreate the Database Instance.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.

        > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @volume_size_in_gb.setter
    def volume_size_in_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_size_in_gb", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("scaleway:databases/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_same_region: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[builtins.int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[builtins.int]] = None,
                 disable_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 init_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_ha_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLoadBalancerArgs', 'InstanceLoadBalancerArgsDict']]]]] = None,
                 logs_policy: Optional[pulumi.Input[Union['InstanceLogsPolicyArgs', 'InstanceLogsPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Database Instances.
        For more information, see refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Example Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            encryption_at_rest=True)
        ```

        ### Example Block Storage Low Latency

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb-sbs",
            node_type="db-play2-pico",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_type="sbs_15k",
            volume_size_in_gb=10)
        ```

        ### Example with Settings

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="db-dev-s",
            disable_backup=True,
            engine="MySQL-8",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            init_settings={
                "lower_case_table_names": "1",
            },
            settings={
                "max_connections": "350",
            })
        ```

        ### Example with backup schedule

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            disable_backup=False,
            backup_schedule_frequency=24,
            backup_schedule_retention=7)
        ```

        ### Examples of endpoint configuration

        Database Instances can have a maximum of 1 public endpoint and 1 private endpoint. They can have both, or none.

        ### 1 static Private Network endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn", ipv4_subnet={
            "subnet": "172.16.20.0/22",
        })
        main = scaleway.databases.Instance("main",
            node_type="db-dev-s",
            engine="PostgreSQL-15",
            private_network={
                "pn_id": pn.id,
                "ip_net": "172.16.20.4/22",
            })
        ```

        ### 1 IPAM Private Network endpoint + 1 public endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        main = scaleway.databases.Instance("main",
            load_balancers=[{}],
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            private_network={
                "pn_id": pn.id,
                "enable_ipam": True,
            })
        ```

        ### Default: 1 public endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            node_type="db-dev-s",
            engine="PostgreSQL-15")
        ```

        > **Note** If nothing is defined, your Database Instance will have a default public load-balancer endpoint.

        ## Limitations

        The Managed Database product is only compliant with the Private Network in the default availability zone (AZ).
        i.e. `fr-par-1`, `nl-ams-1`, `pl-waw-1`. To learn more, read our
        section [How to connect a PostgreSQL and MySQL Database Instance to a Private Network](https://www.scaleway.com/en/docs/managed-databases/postgresql-and-mysql/how-to/connect-database-private-network/)

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/instance:Instance rdb01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] backup_same_region: Boolean to store logical backups in the same region as the database instance
        :param pulumi.Input[builtins.int] backup_schedule_frequency: Backup schedule frequency in hours
        :param pulumi.Input[builtins.int] backup_schedule_retention: Backup schedule retention in days
        :param pulumi.Input[builtins.bool] disable_backup: Disable automated backup for the database instance
        :param pulumi.Input[builtins.bool] encryption_at_rest: Enable or disable encryption at rest for the Database Instance.
        :param pulumi.Input[builtins.str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
               
               > **Important** Updates to `engine` will recreate the Database Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] init_settings: Map of engine settings to be set at database initialisation.
        :param pulumi.Input[builtins.bool] is_ha_cluster: Enable or disable high availability for the Database Instance.
               
               > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLoadBalancerArgs', 'InstanceLoadBalancerArgsDict']]]] load_balancers: List of Load Balancer endpoints of the Database Instance.
        :param pulumi.Input[Union['InstanceLogsPolicyArgs', 'InstanceLogsPolicyArgsDict']] logs_policy: Logs policy configuration
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.str] node_type: The type of Database Instance you want to create (e.g. `db-dev-s`).
               
               > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
               interruption.
               
               > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']] private_network: List of Private Networks endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Database
               Instance is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region
               in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of engine settings to be set on a running instance.
        :param pulumi.Input[builtins.str] snapshot_id: The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Database Instance.
               
               > **Important** Updates to `user_name` will recreate the Database Instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.
               
               > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        :param pulumi.Input[builtins.str] volume_type: Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Database Instances.
        For more information, see refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Example Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            encryption_at_rest=True)
        ```

        ### Example Block Storage Low Latency

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb-sbs",
            node_type="db-play2-pico",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            volume_type="sbs_15k",
            volume_size_in_gb=10)
        ```

        ### Example with Settings

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="db-dev-s",
            disable_backup=True,
            engine="MySQL-8",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            init_settings={
                "lower_case_table_names": "1",
            },
            settings={
                "max_connections": "350",
            })
        ```

        ### Example with backup schedule

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            disable_backup=False,
            backup_schedule_frequency=24,
            backup_schedule_retention=7)
        ```

        ### Examples of endpoint configuration

        Database Instances can have a maximum of 1 public endpoint and 1 private endpoint. They can have both, or none.

        ### 1 static Private Network endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn", ipv4_subnet={
            "subnet": "172.16.20.0/22",
        })
        main = scaleway.databases.Instance("main",
            node_type="db-dev-s",
            engine="PostgreSQL-15",
            private_network={
                "pn_id": pn.id,
                "ip_net": "172.16.20.4/22",
            })
        ```

        ### 1 IPAM Private Network endpoint + 1 public endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        main = scaleway.databases.Instance("main",
            load_balancers=[{}],
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            private_network={
                "pn_id": pn.id,
                "enable_ipam": True,
            })
        ```

        ### Default: 1 public endpoint

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            node_type="db-dev-s",
            engine="PostgreSQL-15")
        ```

        > **Note** If nothing is defined, your Database Instance will have a default public load-balancer endpoint.

        ## Limitations

        The Managed Database product is only compliant with the Private Network in the default availability zone (AZ).
        i.e. `fr-par-1`, `nl-ams-1`, `pl-waw-1`. To learn more, read our
        section [How to connect a PostgreSQL and MySQL Database Instance to a Private Network](https://www.scaleway.com/en/docs/managed-databases/postgresql-and-mysql/how-to/connect-database-private-network/)

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/instance:Instance rdb01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_same_region: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_schedule_frequency: Optional[pulumi.Input[builtins.int]] = None,
                 backup_schedule_retention: Optional[pulumi.Input[builtins.int]] = None,
                 disable_backup: Optional[pulumi.Input[builtins.bool]] = None,
                 encryption_at_rest: Optional[pulumi.Input[builtins.bool]] = None,
                 engine: Optional[pulumi.Input[builtins.str]] = None,
                 init_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_ha_cluster: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLoadBalancerArgs', 'InstanceLoadBalancerArgsDict']]]]] = None,
                 logs_policy: Optional[pulumi.Input[Union['InstanceLogsPolicyArgs', 'InstanceLogsPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
                 private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["backup_same_region"] = backup_same_region
            __props__.__dict__["backup_schedule_frequency"] = backup_schedule_frequency
            __props__.__dict__["backup_schedule_retention"] = backup_schedule_retention
            __props__.__dict__["disable_backup"] = disable_backup
            __props__.__dict__["encryption_at_rest"] = encryption_at_rest
            __props__.__dict__["engine"] = engine
            __props__.__dict__["init_settings"] = init_settings
            __props__.__dict__["is_ha_cluster"] = is_ha_cluster
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["logs_policy"] = logs_policy
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_network"] = private_network
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["settings"] = settings
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["certificate"] = None
            __props__.__dict__["endpoint_ip"] = None
            __props__.__dict__["endpoint_port"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["read_replicas"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/databaseInstance:DatabaseInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'scaleway:databases/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_same_region: Optional[pulumi.Input[builtins.bool]] = None,
            backup_schedule_frequency: Optional[pulumi.Input[builtins.int]] = None,
            backup_schedule_retention: Optional[pulumi.Input[builtins.int]] = None,
            certificate: Optional[pulumi.Input[builtins.str]] = None,
            disable_backup: Optional[pulumi.Input[builtins.bool]] = None,
            encryption_at_rest: Optional[pulumi.Input[builtins.bool]] = None,
            endpoint_ip: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_port: Optional[pulumi.Input[builtins.int]] = None,
            engine: Optional[pulumi.Input[builtins.str]] = None,
            init_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_ha_cluster: Optional[pulumi.Input[builtins.bool]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLoadBalancerArgs', 'InstanceLoadBalancerArgsDict']]]]] = None,
            logs_policy: Optional[pulumi.Input[Union['InstanceLogsPolicyArgs', 'InstanceLogsPolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_type: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]]] = None,
            private_network: Optional[pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            read_replicas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceReadReplicaArgs', 'InstanceReadReplicaArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None,
            volume_size_in_gb: Optional[pulumi.Input[builtins.int]] = None,
            volume_type: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] backup_same_region: Boolean to store logical backups in the same region as the database instance
        :param pulumi.Input[builtins.int] backup_schedule_frequency: Backup schedule frequency in hours
        :param pulumi.Input[builtins.int] backup_schedule_retention: Backup schedule retention in days
        :param pulumi.Input[builtins.str] certificate: Certificate of the Database Instance.
        :param pulumi.Input[builtins.bool] disable_backup: Disable automated backup for the database instance
        :param pulumi.Input[builtins.bool] encryption_at_rest: Enable or disable encryption at rest for the Database Instance.
        :param pulumi.Input[builtins.str] endpoint_ip: (Deprecated) The IP of the Database Instance. Please use the private_network or the load_balancer attribute.
        :param pulumi.Input[builtins.int] endpoint_port: (Deprecated) The port of the Database Instance. Please use the private_network or the load_balancer attribute.
        :param pulumi.Input[builtins.str] engine: Database Instance's engine version (e.g. `PostgreSQL-11`).
               
               > **Important** Updates to `engine` will recreate the Database Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] init_settings: Map of engine settings to be set at database initialisation.
        :param pulumi.Input[builtins.bool] is_ha_cluster: Enable or disable high availability for the Database Instance.
               
               > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLoadBalancerArgs', 'InstanceLoadBalancerArgsDict']]]] load_balancers: List of Load Balancer endpoints of the Database Instance.
        :param pulumi.Input[Union['InstanceLogsPolicyArgs', 'InstanceLogsPolicyArgsDict']] logs_policy: Logs policy configuration
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.str] node_type: The type of Database Instance you want to create (e.g. `db-dev-s`).
               
               > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
               interruption.
               
               > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the Database Instance is associated with.
        :param pulumi.Input[builtins.str] password: Password for the first user of the Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstancePrivateIpArgs', 'InstancePrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the resource.
        :param pulumi.Input[Union['InstancePrivateNetworkArgs', 'InstancePrivateNetworkArgsDict']] private_network: List of Private Networks endpoints of the Database Instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the Database
               Instance is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceReadReplicaArgs', 'InstanceReadReplicaArgsDict']]]] read_replicas: List of read replicas of the Database Instance.
        :param pulumi.Input[builtins.str] region: `region`) The region
               in which the Database Instance should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] settings: Map of engine settings to be set on a running instance.
        :param pulumi.Input[builtins.str] snapshot_id: The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Database Instance.
        :param pulumi.Input[builtins.str] user_name: Identifier for the first user of the Database Instance.
               
               > **Important** Updates to `user_name` will recreate the Database Instance.
        :param pulumi.Input[builtins.int] volume_size_in_gb: Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.
               
               > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        :param pulumi.Input[builtins.str] volume_type: Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["backup_same_region"] = backup_same_region
        __props__.__dict__["backup_schedule_frequency"] = backup_schedule_frequency
        __props__.__dict__["backup_schedule_retention"] = backup_schedule_retention
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["disable_backup"] = disable_backup
        __props__.__dict__["encryption_at_rest"] = encryption_at_rest
        __props__.__dict__["endpoint_ip"] = endpoint_ip
        __props__.__dict__["endpoint_port"] = endpoint_port
        __props__.__dict__["engine"] = engine
        __props__.__dict__["init_settings"] = init_settings
        __props__.__dict__["is_ha_cluster"] = is_ha_cluster
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["logs_policy"] = logs_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_network"] = private_network
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["read_replicas"] = read_replicas
        __props__.__dict__["region"] = region
        __props__.__dict__["settings"] = settings
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["volume_size_in_gb"] = volume_size_in_gb
        __props__.__dict__["volume_type"] = volume_type
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupSameRegion")
    def backup_same_region(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean to store logical backups in the same region as the database instance
        """
        return pulumi.get(self, "backup_same_region")

    @property
    @pulumi.getter(name="backupScheduleFrequency")
    def backup_schedule_frequency(self) -> pulumi.Output[builtins.int]:
        """
        Backup schedule frequency in hours
        """
        return pulumi.get(self, "backup_schedule_frequency")

    @property
    @pulumi.getter(name="backupScheduleRetention")
    def backup_schedule_retention(self) -> pulumi.Output[builtins.int]:
        """
        Backup schedule retention in days
        """
        return pulumi.get(self, "backup_schedule_retention")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[builtins.str]:
        """
        Certificate of the Database Instance.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="disableBackup")
    def disable_backup(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Disable automated backup for the database instance
        """
        return pulumi.get(self, "disable_backup")

    @property
    @pulumi.getter(name="encryptionAtRest")
    def encryption_at_rest(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable encryption at rest for the Database Instance.
        """
        return pulumi.get(self, "encryption_at_rest")

    @property
    @pulumi.getter(name="endpointIp")
    @_utilities.deprecated("""Please use the private_network or the load_balancer attribute""")
    def endpoint_ip(self) -> pulumi.Output[builtins.str]:
        """
        (Deprecated) The IP of the Database Instance. Please use the private_network or the load_balancer attribute.
        """
        return pulumi.get(self, "endpoint_ip")

    @property
    @pulumi.getter(name="endpointPort")
    @_utilities.deprecated("""Please use the private_network or the load_balancer attribute""")
    def endpoint_port(self) -> pulumi.Output[builtins.int]:
        """
        (Deprecated) The port of the Database Instance. Please use the private_network or the load_balancer attribute.
        """
        return pulumi.get(self, "endpoint_port")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[builtins.str]:
        """
        Database Instance's engine version (e.g. `PostgreSQL-11`).

        > **Important** Updates to `engine` will recreate the Database Instance.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="initSettings")
    def init_settings(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of engine settings to be set at database initialisation.
        """
        return pulumi.get(self, "init_settings")

    @property
    @pulumi.getter(name="isHaCluster")
    def is_ha_cluster(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable high availability for the Database Instance.

        > **Important** Updates to `is_ha_cluster` will recreate the Database Instance.
        """
        return pulumi.get(self, "is_ha_cluster")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence['outputs.InstanceLoadBalancer']]:
        """
        List of Load Balancer endpoints of the Database Instance.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="logsPolicy")
    def logs_policy(self) -> pulumi.Output['outputs.InstanceLogsPolicy']:
        """
        Logs policy configuration
        """
        return pulumi.get(self, "logs_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of Database Instance you want to create (e.g. `db-dev-s`).

        > **Important** Updates to `node_type` will upgrade the Database Instance to the desired `node_type` without any
        interruption.

        > **Important** Once your Database Instance reaches `disk_full` status, if you are using `lssd` storage, you should upgrade the `node_type`, and if you are using `bssd` storage, you should increase the volume size before making any other changes to your Database Instance.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the Database Instance is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Password for the first user of the Database Instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.InstancePrivateIp']]:
        """
        The private IPv4 address associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> pulumi.Output[Optional['outputs.InstancePrivateNetwork']]:
        """
        List of Private Networks endpoints of the Database Instance.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the Database
        Instance is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> pulumi.Output[Sequence['outputs.InstanceReadReplica']]:
        """
        List of read replicas of the Database Instance.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region
        in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of engine settings to be set on a running instance.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of an existing snapshot to restore or create the Database Instance from. Conflicts with the `engine` parameter and backup settings.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Database Instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        Identifier for the first user of the Database Instance.

        > **Important** Updates to `user_name` will recreate the Database Instance.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="volumeSizeInGb")
    def volume_size_in_gb(self) -> pulumi.Output[builtins.int]:
        """
        Volume size (in GB). Cannot be used when `volume_type` is set to `lssd`.

        > **Important** Once your Database Instance reaches `disk_full` status, you should increase the volume size before making any other change to your Database Instance.
        """
        return pulumi.get(self, "volume_size_in_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of volume where data are stored (`lssd`, `sbs_5k` or `sbs_15k`).
        """
        return pulumi.get(self, "volume_type")

