# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 is_admin: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database user.
        :param pulumi.Input[builtins.str] password: database user password.
        :param pulumi.Input[builtins.bool] is_admin: Grant admin permissions to the database user.
        :param pulumi.Input[builtins.str] name: database user name.
               
               > **Important:** Updates to `name` will recreate the database user.
        :param pulumi.Input[builtins.str] region: The Scaleway region this resource resides in.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "password", password)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database user.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        database user password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Grant admin permissions to the database user.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        database user name.

        > **Important:** Updates to `name` will recreate the database user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Scaleway region this resource resides in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database user.
        :param pulumi.Input[builtins.bool] is_admin: Grant admin permissions to the database user.
        :param pulumi.Input[builtins.str] name: database user name.
               
               > **Important:** Updates to `name` will recreate the database user.
        :param pulumi.Input[builtins.str] password: database user password.
        :param pulumi.Input[builtins.str] region: The Scaleway region this resource resides in.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database user.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Grant admin permissions to the database user.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        database user name.

        > **Important:** Updates to `name` will recreate the database user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        database user password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Scaleway region this resource resides in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:databases/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages database users.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_random as random
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        db_password = random.RandomPassword("db_password",
            length=16,
            special=True)
        db_admin = scaleway.databases.User("db_admin",
            instance_id=main.id,
            name="devtools",
            password=db_password.result,
            is_admin=True)
        ```

        ## Import

        Database users can be imported using `{region}/{instance_id}/{user_name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/user:User admin fr-par/11111111-1111-1111-1111-111111111111/admin
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database user.
        :param pulumi.Input[builtins.bool] is_admin: Grant admin permissions to the database user.
        :param pulumi.Input[builtins.str] name: database user name.
               
               > **Important:** Updates to `name` will recreate the database user.
        :param pulumi.Input[builtins.str] password: database user password.
        :param pulumi.Input[builtins.str] region: The Scaleway region this resource resides in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages database users.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_random as random
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        db_password = random.RandomPassword("db_password",
            length=16,
            special=True)
        db_admin = scaleway.databases.User("db_admin",
            instance_id=main.id,
            name="devtools",
            password=db_password.result,
            is_admin=True)
        ```

        ## Import

        Database users can be imported using `{region}/{instance_id}/{user_name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/user:User admin fr-par/11111111-1111-1111-1111-111111111111/admin
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_admin"] = is_admin
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/databaseUser:DatabaseUser")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'scaleway:databases/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            is_admin: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database user.
        :param pulumi.Input[builtins.bool] is_admin: Grant admin permissions to the database user.
        :param pulumi.Input[builtins.str] name: database user name.
               
               > **Important:** Updates to `name` will recreate the database user.
        :param pulumi.Input[builtins.str] password: database user password.
        :param pulumi.Input[builtins.str] region: The Scaleway region this resource resides in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_admin"] = is_admin
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database user.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Grant admin permissions to the database user.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        database user name.

        > **Important:** Updates to `name` will recreate the database user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        database user password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The Scaleway region this resource resides in.
        """
        return pulumi.get(self, "region")

