# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeServicesCacheStageArgs', 'EdgeServicesCacheStage']

@pulumi.input_type
class EdgeServicesCacheStageArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[builtins.str],
                 backend_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 purge_requests: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]] = None,
                 refresh_cache: Optional[pulumi.Input[builtins.str]] = None,
                 route_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 waf_stage_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesCacheStage resource.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] backend_stage_id: The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.int] fallback_ttl: The Time To Live (TTL) in seconds. Defines how long content is cached.
        :param pulumi.Input[builtins.bool] include_cookies: Defines whether responses to requests with cookies must be stored in the cache.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cache stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]] purge_requests: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] refresh_cache: Trigger a refresh of the cache by changing this field's value.
        :param pulumi.Input[builtins.str] route_stage_id: The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] waf_stage_id: The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if fallback_ttl is not None:
            pulumi.set(__self__, "fallback_ttl", fallback_ttl)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if purge_requests is not None:
            pulumi.set(__self__, "purge_requests", purge_requests)
        if refresh_cache is not None:
            pulumi.set(__self__, "refresh_cache", refresh_cache)
        if route_stage_id is not None:
            pulumi.set(__self__, "route_stage_id", route_stage_id)
        if waf_stage_id is not None:
            pulumi.set(__self__, "waf_stage_id", waf_stage_id)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @property
    @pulumi.getter(name="fallbackTtl")
    def fallback_ttl(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Time To Live (TTL) in seconds. Defines how long content is cached.
        """
        return pulumi.get(self, "fallback_ttl")

    @fallback_ttl.setter
    def fallback_ttl(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fallback_ttl", value)

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether responses to requests with cookies must be stored in the cache.
        """
        return pulumi.get(self, "include_cookies")

    @include_cookies.setter
    def include_cookies(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_cookies", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the cache stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="purgeRequests")
    def purge_requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "purge_requests")

    @purge_requests.setter
    def purge_requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]]):
        pulumi.set(self, "purge_requests", value)

    @property
    @pulumi.getter(name="refreshCache")
    def refresh_cache(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Trigger a refresh of the cache by changing this field's value.
        """
        return pulumi.get(self, "refresh_cache")

    @refresh_cache.setter
    def refresh_cache(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_cache", value)

    @property
    @pulumi.getter(name="routeStageId")
    def route_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "route_stage_id")

    @route_stage_id.setter
    def route_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_stage_id", value)

    @property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "waf_stage_id")

    @waf_stage_id.setter
    def waf_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_stage_id", value)


@pulumi.input_type
class _EdgeServicesCacheStageState:
    def __init__(__self__, *,
                 backend_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 purge_requests: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]] = None,
                 refresh_cache: Optional[pulumi.Input[builtins.str]] = None,
                 route_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 waf_stage_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesCacheStage resources.
        :param pulumi.Input[builtins.str] backend_stage_id: The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the cache stage.
        :param pulumi.Input[builtins.int] fallback_ttl: The Time To Live (TTL) in seconds. Defines how long content is cached.
        :param pulumi.Input[builtins.bool] include_cookies: Defines whether responses to requests with cookies must be stored in the cache.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cache stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]] purge_requests: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] refresh_cache: Trigger a refresh of the cache by changing this field's value.
        :param pulumi.Input[builtins.str] route_stage_id: The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the cache stage.
        :param pulumi.Input[builtins.str] waf_stage_id: The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if fallback_ttl is not None:
            pulumi.set(__self__, "fallback_ttl", fallback_ttl)
        if include_cookies is not None:
            pulumi.set(__self__, "include_cookies", include_cookies)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if purge_requests is not None:
            pulumi.set(__self__, "purge_requests", purge_requests)
        if refresh_cache is not None:
            pulumi.set(__self__, "refresh_cache", refresh_cache)
        if route_stage_id is not None:
            pulumi.set(__self__, "route_stage_id", route_stage_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if waf_stage_id is not None:
            pulumi.set(__self__, "waf_stage_id", waf_stage_id)

    @property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the cache stage.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="fallbackTtl")
    def fallback_ttl(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Time To Live (TTL) in seconds. Defines how long content is cached.
        """
        return pulumi.get(self, "fallback_ttl")

    @fallback_ttl.setter
    def fallback_ttl(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "fallback_ttl", value)

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether responses to requests with cookies must be stored in the cache.
        """
        return pulumi.get(self, "include_cookies")

    @include_cookies.setter
    def include_cookies(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_cookies", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the cache stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="purgeRequests")
    def purge_requests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "purge_requests")

    @purge_requests.setter
    def purge_requests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesCacheStagePurgeRequestArgs']]]]):
        pulumi.set(self, "purge_requests", value)

    @property
    @pulumi.getter(name="refreshCache")
    def refresh_cache(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Trigger a refresh of the cache by changing this field's value.
        """
        return pulumi.get(self, "refresh_cache")

    @refresh_cache.setter
    def refresh_cache(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "refresh_cache", value)

    @property
    @pulumi.getter(name="routeStageId")
    def route_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "route_stage_id")

    @route_stage_id.setter
    def route_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_stage_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the cache stage.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "waf_stage_id")

    @waf_stage_id.setter
    def waf_stage_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waf_stage_id", value)


@pulumi.type_token("scaleway:index/edgeServicesCacheStage:EdgeServicesCacheStage")
class EdgeServicesCacheStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 purge_requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesCacheStagePurgeRequestArgs', 'EdgeServicesCacheStagePurgeRequestArgsDict']]]]] = None,
                 refresh_cache: Optional[pulumi.Input[builtins.str]] = None,
                 route_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 waf_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services Cache Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesCacheStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            backend_stage_id=main_scaleway_edge_services_backend_stage["id"])
        ```

        ## Import

        Cache stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesCacheStage:EdgeServicesCacheStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend_stage_id: The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.int] fallback_ttl: The Time To Live (TTL) in seconds. Defines how long content is cached.
        :param pulumi.Input[builtins.bool] include_cookies: Defines whether responses to requests with cookies must be stored in the cache.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cache stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesCacheStagePurgeRequestArgs', 'EdgeServicesCacheStagePurgeRequestArgsDict']]]] purge_requests: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] refresh_cache: Trigger a refresh of the cache by changing this field's value.
        :param pulumi.Input[builtins.str] route_stage_id: The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] waf_stage_id: The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesCacheStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services Cache Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesCacheStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            backend_stage_id=main_scaleway_edge_services_backend_stage["id"])
        ```

        ## Import

        Cache stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesCacheStage:EdgeServicesCacheStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesCacheStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesCacheStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 fallback_ttl: Optional[pulumi.Input[builtins.int]] = None,
                 include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 purge_requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesCacheStagePurgeRequestArgs', 'EdgeServicesCacheStagePurgeRequestArgsDict']]]]] = None,
                 refresh_cache: Optional[pulumi.Input[builtins.str]] = None,
                 route_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 waf_stage_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesCacheStageArgs.__new__(EdgeServicesCacheStageArgs)

            __props__.__dict__["backend_stage_id"] = backend_stage_id
            __props__.__dict__["fallback_ttl"] = fallback_ttl
            __props__.__dict__["include_cookies"] = include_cookies
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["purge_requests"] = purge_requests
            __props__.__dict__["refresh_cache"] = refresh_cache
            __props__.__dict__["route_stage_id"] = route_stage_id
            __props__.__dict__["waf_stage_id"] = waf_stage_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesCacheStage, __self__).__init__(
            'scaleway:index/edgeServicesCacheStage:EdgeServicesCacheStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_stage_id: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            fallback_ttl: Optional[pulumi.Input[builtins.int]] = None,
            include_cookies: Optional[pulumi.Input[builtins.bool]] = None,
            pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            purge_requests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesCacheStagePurgeRequestArgs', 'EdgeServicesCacheStagePurgeRequestArgsDict']]]]] = None,
            refresh_cache: Optional[pulumi.Input[builtins.str]] = None,
            route_stage_id: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            waf_stage_id: Optional[pulumi.Input[builtins.str]] = None) -> 'EdgeServicesCacheStage':
        """
        Get an existing EdgeServicesCacheStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] backend_stage_id: The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the cache stage.
        :param pulumi.Input[builtins.int] fallback_ttl: The Time To Live (TTL) in seconds. Defines how long content is cached.
        :param pulumi.Input[builtins.bool] include_cookies: Defines whether responses to requests with cookies must be stored in the cache.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cache stage is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesCacheStagePurgeRequestArgs', 'EdgeServicesCacheStagePurgeRequestArgsDict']]]] purge_requests: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] refresh_cache: Trigger a refresh of the cache by changing this field's value.
        :param pulumi.Input[builtins.str] route_stage_id: The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the cache stage.
        :param pulumi.Input[builtins.str] waf_stage_id: The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesCacheStageState.__new__(_EdgeServicesCacheStageState)

        __props__.__dict__["backend_stage_id"] = backend_stage_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["fallback_ttl"] = fallback_ttl
        __props__.__dict__["include_cookies"] = include_cookies
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["purge_requests"] = purge_requests
        __props__.__dict__["refresh_cache"] = refresh_cache
        __props__.__dict__["route_stage_id"] = route_stage_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["waf_stage_id"] = waf_stage_id
        return EdgeServicesCacheStage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> pulumi.Output[builtins.str]:
        """
        The backend stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the cache stage.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="fallbackTtl")
    def fallback_ttl(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The Time To Live (TTL) in seconds. Defines how long content is cached.
        """
        return pulumi.get(self, "fallback_ttl")

    @property
    @pulumi.getter(name="includeCookies")
    def include_cookies(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether responses to requests with cookies must be stored in the cache.
        """
        return pulumi.get(self, "include_cookies")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the cache stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="purgeRequests")
    def purge_requests(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeServicesCacheStagePurgeRequest']]]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "purge_requests")

    @property
    @pulumi.getter(name="refreshCache")
    def refresh_cache(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Trigger a refresh of the cache by changing this field's value.
        """
        return pulumi.get(self, "refresh_cache")

    @property
    @pulumi.getter(name="routeStageId")
    def route_stage_id(self) -> pulumi.Output[builtins.str]:
        """
        The route stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "route_stage_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the cache stage.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="wafStageId")
    def waf_stage_id(self) -> pulumi.Output[builtins.str]:
        """
        The WAF stage ID the cache stage will be linked to. Only one of `backend_stage_id`, `route_stage_id` and `waf_stage_id` should be specified.
        """
        return pulumi.get(self, "waf_stage_id")

