# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeServicesPipelineArgs', 'EdgeServicesPipeline']

@pulumi.input_type
class EdgeServicesPipelineArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesPipeline resource.
        :param pulumi.Input[builtins.str] description: The description of the pipeline.
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the pipeline is associated with.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the pipeline is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _EdgeServicesPipelineState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesPipeline resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the pipeline.
        :param pulumi.Input[builtins.str] description: The description of the pipeline.
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the pipeline is associated with.
        :param pulumi.Input[builtins.str] status: The status of user pipeline.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the pipeline.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the pipeline.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the pipeline is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of user pipeline.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the pipeline.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:index/edgeServicesPipeline:EdgeServicesPipeline")
class EdgeServicesPipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services Pipelines.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="pipeline-name",
            description="pipeline description")
        ```

        ### Complete pipeline

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="pipeline-name",
            description="pipeline description")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main.id,
            s3_backend_config={
                "bucket_name": "my-bucket-name",
                "bucket_region": "fr-par",
            })
        main_edge_services_waf_stage = scaleway.EdgeServicesWafStage("main",
            pipeline_id=main.id,
            backend_stage_id=main_edge_services_backend_stage.id,
            mode="enable",
            paranoia_level=3)
        main_edge_services_route_stage = scaleway.EdgeServicesRouteStage("main",
            pipeline_id=main.id,
            waf_stage_id=main_edge_services_waf_stage.id,
            rules=[{
                "backend_stage_id": main_edge_services_backend_stage.id,
                "rule_http_match": {
                    "method_filters": [
                        "get",
                        "post",
                    ],
                    "path_filter": {
                        "path_filter_type": "regex",
                        "value": ".*",
                    },
                },
            }])
        main_edge_services_cache_stage = scaleway.EdgeServicesCacheStage("main",
            pipeline_id=main.id,
            route_stage_id=main_edge_services_route_stage.id)
        main_edge_services_tls_stage = scaleway.EdgeServicesTlsStage("main",
            pipeline_id=main.id,
            cache_stage_id=main_edge_services_cache_stage.id,
            managed_certificate=True)
        main_edge_services_dns_stage = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main.id,
            tls_stage_id=main_edge_services_tls_stage.id,
            fqdns=["subdomain.example.com"])
        main_edge_services_head_stage = scaleway.EdgeServicesHeadStage("main",
            pipeline_id=main.id,
            head_stage_id=main_edge_services_dns_stage.id)
        ```

        ## Import

        Pipelines can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesPipeline:EdgeServicesPipeline basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the pipeline.
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the pipeline is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EdgeServicesPipelineArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services Pipelines.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="pipeline-name",
            description="pipeline description")
        ```

        ### Complete pipeline

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesPipeline("main",
            name="pipeline-name",
            description="pipeline description")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main.id,
            s3_backend_config={
                "bucket_name": "my-bucket-name",
                "bucket_region": "fr-par",
            })
        main_edge_services_waf_stage = scaleway.EdgeServicesWafStage("main",
            pipeline_id=main.id,
            backend_stage_id=main_edge_services_backend_stage.id,
            mode="enable",
            paranoia_level=3)
        main_edge_services_route_stage = scaleway.EdgeServicesRouteStage("main",
            pipeline_id=main.id,
            waf_stage_id=main_edge_services_waf_stage.id,
            rules=[{
                "backend_stage_id": main_edge_services_backend_stage.id,
                "rule_http_match": {
                    "method_filters": [
                        "get",
                        "post",
                    ],
                    "path_filter": {
                        "path_filter_type": "regex",
                        "value": ".*",
                    },
                },
            }])
        main_edge_services_cache_stage = scaleway.EdgeServicesCacheStage("main",
            pipeline_id=main.id,
            route_stage_id=main_edge_services_route_stage.id)
        main_edge_services_tls_stage = scaleway.EdgeServicesTlsStage("main",
            pipeline_id=main.id,
            cache_stage_id=main_edge_services_cache_stage.id,
            managed_certificate=True)
        main_edge_services_dns_stage = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main.id,
            tls_stage_id=main_edge_services_tls_stage.id,
            fqdns=["subdomain.example.com"])
        main_edge_services_head_stage = scaleway.EdgeServicesHeadStage("main",
            pipeline_id=main.id,
            head_stage_id=main_edge_services_dns_stage.id)
        ```

        ## Import

        Pipelines can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesPipeline:EdgeServicesPipeline basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesPipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesPipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesPipelineArgs.__new__(EdgeServicesPipelineArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesPipeline, __self__).__init__(
            'scaleway:index/edgeServicesPipeline:EdgeServicesPipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'EdgeServicesPipeline':
        """
        Get an existing EdgeServicesPipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the pipeline.
        :param pulumi.Input[builtins.str] description: The description of the pipeline.
        :param pulumi.Input[builtins.str] name: The name of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the pipeline is associated with.
        :param pulumi.Input[builtins.str] status: The status of user pipeline.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the pipeline.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesPipelineState.__new__(_EdgeServicesPipelineState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return EdgeServicesPipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the pipeline.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the pipeline is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of user pipeline.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the pipeline.
        """
        return pulumi.get(self, "updated_at")

