# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ServerIp',
    'ServerIpv4',
    'ServerIpv6',
    'ServerOption',
    'ServerPrivateIp',
    'ServerPrivateNetwork',
    'GetIpsIpResult',
    'GetIpsIpMacAddressResult',
    'GetOfferCpuResult',
    'GetOfferDiskResult',
    'GetOfferMemoryResult',
    'GetServerIpResult',
    'GetServerIpv4Result',
    'GetServerIpv6Result',
    'GetServerOptionResult',
    'GetServerPrivateIpResult',
    'GetServerPrivateNetworkResult',
]

@pulumi.output_type
class ServerIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 reverse: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the IPv6.
        :param builtins.str id: The ID of the IPv6.
        :param builtins.str reverse: The reverse of the IPv6.
        :param builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> Optional[builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerIpv4(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 reverse: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the IPv6.
        :param builtins.str id: The ID of the IPv6.
        :param builtins.str reverse: The reverse of the IPv6.
        :param builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> Optional[builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerIpv6(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 reverse: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the IPv6.
        :param builtins.str id: The ID of the IPv6.
        :param builtins.str reverse: The reverse of the IPv6.
        :param builtins.str version: The type of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if reverse is not None:
            pulumi.set(__self__, "reverse", reverse)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> Optional[builtins.str]:
        """
        The reverse of the IPv6.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The type of the IPv6.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServerOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 expires_at: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str id: The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        :param builtins.str expires_at: The auto expiration date for compatible options
        :param builtins.str name: The name of the server.
        """
        pulumi.set(__self__, "id", id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the option to enable. Use [this endpoint](https://www.scaleway.com/en/developers/api/elastic-metal/#path-options-list-options) to find the available options IDs.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[builtins.str]:
        """
        The auto expiration date for compatible options
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The address of the IPv6.
        :param builtins.str id: The ID of the IPv6.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The address of the IPv6.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv6.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "mappingId":
            suggest = "mapping_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: builtins.str,
                 created_at: Optional[builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[builtins.str]] = None,
                 mapping_id: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 updated_at: Optional[builtins.str] = None,
                 vlan: Optional[builtins.int] = None):
        """
        :param builtins.str id: The id of the private network to attach.
        :param builtins.str created_at: The date and time of the creation of the private network.
        :param Sequence[builtins.str] ipam_ip_ids: List of IPAM IP IDs to assign to the server in the requested private network.
        :param builtins.str mapping_id: The ID of the Server-to-Private Network mapping.
        :param builtins.str status: The private network status.
        :param builtins.str updated_at: The date and time of the last update of the private network.
        :param builtins.int vlan: The VLAN ID associated to the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if mapping_id is not None:
            pulumi.set(__self__, "mapping_id", mapping_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the private network to attach.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time of the creation of the private network.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of IPAM IP IDs to assign to the server in the requested private network.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> Optional[builtins.str]:
        """
        The ID of the Server-to-Private Network mapping.
        """
        return pulumi.get(self, "mapping_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The private network status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        The date and time of the last update of the private network.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[builtins.int]:
        """
        The VLAN ID associated to the private network.
        """
        return pulumi.get(self, "vlan")


@pulumi.output_type
class GetIpsIpResult(dict):
    def __init__(__self__, *,
                 created_at: builtins.str,
                 description: builtins.str,
                 id: builtins.str,
                 ip_address: builtins.str,
                 mac_addresses: Sequence['outputs.GetIpsIpMacAddressResult'],
                 organization_id: builtins.str,
                 project_id: builtins.str,
                 reverse: builtins.str,
                 status: builtins.str,
                 tags: Sequence[builtins.str],
                 updated_at: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param builtins.str description: The description of the flexible IP.
        :param builtins.str id: The MAC address ID.
        :param Sequence['GetIpsIpMacAddressArgs'] mac_addresses: The MAC address of the Virtual MAC.
        :param builtins.str organization_id: (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        :param builtins.str project_id: (Defaults to provider `project_id`) The ID of the project the IP is in.
        :param builtins.str reverse: The reverse domain associated with this IP.
        :param builtins.str status: The status of virtual MAC.
        :param Sequence[builtins.str] tags: List of tags used as filter. IPs with these exact tags are listed.
        :param builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "mac_addresses", mac_addresses)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the flexible IP.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Sequence['outputs.GetIpsIpMacAddressResult']:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_addresses")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        (Defaults to provider `organization_id`) The ID of the organization the IP is in.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        (Defaults to provider `project_id`) The ID of the project the IP is in.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        List of tags used as filter. IPs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetIpsIpMacAddressResult(dict):
    def __init__(__self__, *,
                 created_at: builtins.str,
                 id: builtins.str,
                 mac_address: builtins.str,
                 mac_type: builtins.str,
                 status: builtins.str,
                 updated_at: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str created_at: The date on which the flexible IP was created (RFC 3339 format).
        :param builtins.str id: The MAC address ID.
        :param builtins.str mac_address: The MAC address of the Virtual MAC.
        :param builtins.str mac_type: The type of virtual MAC.
        :param builtins.str status: The status of virtual MAC.
        :param builtins.str updated_at: The date on which the flexible IP was last updated (RFC 3339 format).
        :param builtins.str zone: `zone`) The zone in which IPs exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mac_type", mac_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the flexible IP was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The MAC address ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> builtins.str:
        """
        The MAC address of the Virtual MAC.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="macType")
    def mac_type(self) -> builtins.str:
        """
        The type of virtual MAC.
        """
        return pulumi.get(self, "mac_type")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of virtual MAC.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date on which the flexible IP was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetOfferCpuResult(dict):
    def __init__(__self__, *,
                 core_count: builtins.int,
                 frequency: builtins.int,
                 name: builtins.str,
                 thread_count: builtins.int):
        """
        :param builtins.int core_count: Number of core on this CPU.
        :param builtins.int frequency: Frequency of the memory in MHz.
        :param builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
        :param builtins.int thread_count: Number of thread on this CPU.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "thread_count", thread_count)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> builtins.int:
        """
        Number of core on this CPU.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def frequency(self) -> builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The offer name. Only one of `name` and `offer_id` should be specified.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="threadCount")
    def thread_count(self) -> builtins.int:
        """
        Number of thread on this CPU.
        """
        return pulumi.get(self, "thread_count")


@pulumi.output_type
class GetOfferDiskResult(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int capacity: Capacity of the memory in GB.
        :param builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOfferMemoryResult(dict):
    def __init__(__self__, *,
                 capacity: builtins.int,
                 frequency: builtins.int,
                 is_ecc: builtins.bool,
                 type: builtins.str):
        """
        :param builtins.int capacity: Capacity of the memory in GB.
        :param builtins.int frequency: Frequency of the memory in MHz.
        :param builtins.bool is_ecc: True if error-correcting code is available on this memory.
        :param builtins.str type: Type of memory.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "is_ecc", is_ecc)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def capacity(self) -> builtins.int:
        """
        Capacity of the memory in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def frequency(self) -> builtins.int:
        """
        Frequency of the memory in MHz.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="isEcc")
    def is_ecc(self) -> builtins.bool:
        """
        True if error-correcting code is available on this memory.
        """
        return pulumi.get(self, "is_ecc")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of memory.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServerIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str,
                 reverse: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str address: The IPv6 address
        :param builtins.str id: The ID of the server.
        :param builtins.str reverse: The Reverse of the IPv6
        :param builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerIpv4Result(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str,
                 reverse: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str address: The IPv6 address
        :param builtins.str id: The ID of the server.
        :param builtins.str reverse: The Reverse of the IPv6
        :param builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerIpv6Result(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str,
                 reverse: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str address: The IPv6 address
        :param builtins.str id: The ID of the server.
        :param builtins.str reverse: The Reverse of the IPv6
        :param builtins.str version: The version of the IPv6
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IPv6 address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The Reverse of the IPv6
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        The version of the IPv6
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServerOptionResult(dict):
    def __init__(__self__, *,
                 expires_at: builtins.str,
                 id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str expires_at: Auto expire the option after this date
        :param builtins.str id: The ID of the server.
        :param builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> builtins.str:
        """
        Auto expire the option after this date
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The server name. Only one of `name` and `server_id` should be specified.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The private IP address
        :param builtins.str id: The ID of the server.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetServerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 created_at: builtins.str,
                 id: builtins.str,
                 ipam_ip_ids: Sequence[builtins.str],
                 mapping_id: builtins.str,
                 status: builtins.str,
                 updated_at: builtins.str,
                 vlan: builtins.int):
        """
        :param builtins.str created_at: The date and time of the creation of the private network
        :param builtins.str id: The ID of the server.
        :param Sequence[builtins.str] ipam_ip_ids: List of IPAM IP IDs to attach to the server
        :param builtins.str mapping_id: The ID of the Server-to-Private Network mapping
        :param builtins.str status: The private network status
        :param builtins.str updated_at: The date and time of the last update of the private network
        :param builtins.int vlan: The VLAN ID associated to the private network
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        pulumi.set(__self__, "mapping_id", mapping_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time of the creation of the private network
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Sequence[builtins.str]:
        """
        List of IPAM IP IDs to attach to the server
        """
        return pulumi.get(self, "ipam_ip_ids")

    @property
    @pulumi.getter(name="mappingId")
    def mapping_id(self) -> builtins.str:
        """
        The ID of the Server-to-Private Network mapping
        """
        return pulumi.get(self, "mapping_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The private network status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the last update of the private network
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def vlan(self) -> builtins.int:
        """
        The VLAN ID associated to the private network
        """
        return pulumi.get(self, "vlan")


