# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetSecretVersionResult',
    'AwaitableGetSecretVersionResult',
    'get_secret_version',
    'get_secret_version_output',
]

warnings.warn("""scaleway.index/getsecretversion.getSecretVersion has been deprecated in favor of scaleway.secrets/getversion.getVersion""", DeprecationWarning)

@pulumi.output_type
class GetSecretVersionResult:
    """
    A collection of values returned by getSecretVersion.
    """
    def __init__(__self__, created_at=None, data=None, description=None, id=None, organization_id=None, project_id=None, region=None, revision=None, secret_id=None, secret_name=None, status=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if revision and not isinstance(revision, str):
            raise TypeError("Expected argument 'revision' to be a str")
        pulumi.set(__self__, "revision", revision)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time of the secret version's creation in RFC 3339 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        The data payload of the secret version. This is a sensitive attribute containing the secret value. Learn more in the [data section](https://www.terraform.io/#data-information).
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        (Optional) The description of the secret version (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def revision(self) -> Optional[builtins.str]:
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the secret version.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the secret version's last update in RFC 3339 format.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetSecretVersionResult(GetSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionResult(
            created_at=self.created_at,
            data=self.data,
            description=self.description,
            id=self.id,
            organization_id=self.organization_id,
            project_id=self.project_id,
            region=self.region,
            revision=self.revision,
            secret_id=self.secret_id,
            secret_name=self.secret_name,
            status=self.status,
            updated_at=self.updated_at)


def get_secret_version(organization_id: Optional[builtins.str] = None,
                       project_id: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       revision: Optional[builtins.str] = None,
                       secret_id: Optional[builtins.str] = None,
                       secret_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionResult:
    """
    The `secrets.Version` data source is used to get information about a specific secret version stored in Scaleway Secret Manager.

    Refer to the Secret Manager [product documentation](https://www.scaleway.com/en/docs/identity-and-access-management/secret-manager/) and [API documentation](https://www.scaleway.com/en/developers/api/secret-manager/) for more information.

    ## Example Usage

    ### Use Secret Manager

    The following commands allow you to:

    - create a secret named `fooii`
    - create a new version of `fooii` containing data (`your_secret`)
    - retrieve the secret version specified by the secret ID and the desired version
    - retrieve the secret version specified by the secret name and the desired version

    The output blocks display the sensitive data contained in your secret version.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Create a secret named fooii
    main = scaleway.secrets.Secret("main",
        name="fooii",
        description="barr")
    # Create a version of fooii containing data
    main_version = scaleway.secrets.Version("main",
        description="your description",
        secret_id=main.id,
        data="your_secret")
    # Retrieve the secret version specified by the secret ID and the desired version
    data_by_secret_id = scaleway.secrets.get_version_output(secret_id=main.id,
        revision="1")
    # Retrieve the secret version specified by the secret name and the desired version
    data_by_secret_name = scaleway.secrets.get_version_output(secret_name=main.name,
        revision="1")
    pulumi.export("scalewaySecretAccessPayload", data_by_secret_name.data)
    pulumi.export("scalewaySecretAccessPayloadById", data_by_secret_id.data)
    ```

    ## Data information

    Note: This data source provides you with access to the secret payload, which is encoded in base64.

    Keep in mind that this is a sensitive attribute. For more information,
    see Sensitive Data in State.

    > **Important:**  This property is sensitive and will not be displayed in the pulumi preview, for security reasons.


    :param builtins.str project_id: The ID of the Scaleway Project associated with the secret version.
    :param builtins.str revision: The revision for this secret version. Refer to alternative values (ex: `latest`) in the [API documentation](https://www.scaleway.com/en/developers/api/secret-manager/#path-secret-versions-access-a-secrets-version-using-the-secrets-id)
    :param builtins.str secret_id: The ID of the secret associated with the secret version. Only one of `secret_id` and `secret_name` should be specified.
    :param builtins.str secret_name: The name of the secret associated with the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    """
    pulumi.log.warn("""get_secret_version is deprecated: scaleway.index/getsecretversion.getSecretVersion has been deprecated in favor of scaleway.secrets/getversion.getVersion""")
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['revision'] = revision
    __args__['secretId'] = secret_id
    __args__['secretName'] = secret_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult).value

    return AwaitableGetSecretVersionResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        data=pulumi.get(__ret__, 'data'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        revision=pulumi.get(__ret__, 'revision'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_secret_version_output(organization_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              revision: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              secret_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              secret_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretVersionResult]:
    """
    The `secrets.Version` data source is used to get information about a specific secret version stored in Scaleway Secret Manager.

    Refer to the Secret Manager [product documentation](https://www.scaleway.com/en/docs/identity-and-access-management/secret-manager/) and [API documentation](https://www.scaleway.com/en/developers/api/secret-manager/) for more information.

    ## Example Usage

    ### Use Secret Manager

    The following commands allow you to:

    - create a secret named `fooii`
    - create a new version of `fooii` containing data (`your_secret`)
    - retrieve the secret version specified by the secret ID and the desired version
    - retrieve the secret version specified by the secret name and the desired version

    The output blocks display the sensitive data contained in your secret version.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    # Create a secret named fooii
    main = scaleway.secrets.Secret("main",
        name="fooii",
        description="barr")
    # Create a version of fooii containing data
    main_version = scaleway.secrets.Version("main",
        description="your description",
        secret_id=main.id,
        data="your_secret")
    # Retrieve the secret version specified by the secret ID and the desired version
    data_by_secret_id = scaleway.secrets.get_version_output(secret_id=main.id,
        revision="1")
    # Retrieve the secret version specified by the secret name and the desired version
    data_by_secret_name = scaleway.secrets.get_version_output(secret_name=main.name,
        revision="1")
    pulumi.export("scalewaySecretAccessPayload", data_by_secret_name.data)
    pulumi.export("scalewaySecretAccessPayloadById", data_by_secret_id.data)
    ```

    ## Data information

    Note: This data source provides you with access to the secret payload, which is encoded in base64.

    Keep in mind that this is a sensitive attribute. For more information,
    see Sensitive Data in State.

    > **Important:**  This property is sensitive and will not be displayed in the pulumi preview, for security reasons.


    :param builtins.str project_id: The ID of the Scaleway Project associated with the secret version.
    :param builtins.str revision: The revision for this secret version. Refer to alternative values (ex: `latest`) in the [API documentation](https://www.scaleway.com/en/developers/api/secret-manager/#path-secret-versions-access-a-secrets-version-using-the-secrets-id)
    :param builtins.str secret_id: The ID of the secret associated with the secret version. Only one of `secret_id` and `secret_name` should be specified.
    :param builtins.str secret_name: The name of the secret associated with the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    """
    pulumi.log.warn("""get_secret_version is deprecated: scaleway.index/getsecretversion.getSecretVersion has been deprecated in favor of scaleway.secrets/getversion.getVersion""")
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['revision'] = revision
    __args__['secretId'] = secret_id
    __args__['secretName'] = secret_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult)
    return __ret__.apply(lambda __response__: GetSecretVersionResult(
        created_at=pulumi.get(__response__, 'created_at'),
        data=pulumi.get(__response__, 'data'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        revision=pulumi.get(__response__, 'revision'),
        secret_id=pulumi.get(__response__, 'secret_id'),
        secret_name=pulumi.get(__response__, 'secret_name'),
        status=pulumi.get(__response__, 'status'),
        updated_at=pulumi.get(__response__, 'updated_at')))
