# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetVpcPublicPatRuleResult',
    'AwaitableGetVpcPublicPatRuleResult',
    'get_vpc_public_pat_rule',
    'get_vpc_public_pat_rule_output',
]

warnings.warn("""scaleway.index/getvpcpublicpatrule.getVpcPublicPatRule has been deprecated in favor of scaleway.network/getpublicgatewaypatrule.getPublicGatewayPatRule""", DeprecationWarning)

@pulumi.output_type
class GetVpcPublicPatRuleResult:
    """
    A collection of values returned by getVpcPublicPatRule.
    """
    def __init__(__self__, created_at=None, gateway_id=None, id=None, organization_id=None, pat_rule_id=None, private_ip=None, private_port=None, protocol=None, public_port=None, updated_at=None, zone=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if pat_rule_id and not isinstance(pat_rule_id, str):
            raise TypeError("Expected argument 'pat_rule_id' to be a str")
        pulumi.set(__self__, "pat_rule_id", pat_rule_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if private_port and not isinstance(private_port, int):
            raise TypeError("Expected argument 'private_port' to be a int")
        pulumi.set(__self__, "private_port", private_port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if public_port and not isinstance(public_port, int):
            raise TypeError("Expected argument 'public_port' to be a int")
        pulumi.set(__self__, "public_port", public_port)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> builtins.str:
        """
        The ID of the Public Gateway.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="patRuleId")
    def pat_rule_id(self) -> builtins.str:
        return pulumi.get(self, "pat_rule_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> builtins.str:
        """
        The private IP address to forward data to.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privatePort")
    def private_port(self) -> builtins.int:
        """
        The private port to translate to.
        """
        return pulumi.get(self, "private_port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol the rule should apply to. Possible values are `both`, `tcp` and `udp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> builtins.int:
        """
        The public port to listen on.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetVpcPublicPatRuleResult(GetVpcPublicPatRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcPublicPatRuleResult(
            created_at=self.created_at,
            gateway_id=self.gateway_id,
            id=self.id,
            organization_id=self.organization_id,
            pat_rule_id=self.pat_rule_id,
            private_ip=self.private_ip,
            private_port=self.private_port,
            protocol=self.protocol,
            public_port=self.public_port,
            updated_at=self.updated_at,
            zone=self.zone)


def get_vpc_public_pat_rule(pat_rule_id: Optional[builtins.str] = None,
                            zone: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcPublicPatRuleResult:
    """
    Gets information about a Public Gateway PAT rule. For further information, please see the
    [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#path-pat-rules-list-pat-rules).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    sg01 = scaleway.instance.SecurityGroup("sg01",
        inbound_default_policy="drop",
        outbound_default_policy="accept",
        inbound_rules=[{
            "action": "accept",
            "port": 22,
            "protocol": "TCP",
        }])
    srv01 = scaleway.instance.Server("srv01",
        name="my-server",
        type="PLAY2-NANO",
        image="ubuntu_jammy",
        security_group_id=sg01.id)
    pn01 = scaleway.network.PrivateNetwork("pn01", name="my-pn")
    pnic01 = scaleway.instance.PrivateNic("pnic01",
        server_id=srv01.id,
        private_network_id=pn01.id)
    dhcp01 = scaleway.network.PublicGatewayDhcp("dhcp01", subnet="192.168.0.0/24")
    ip01 = scaleway.network.PublicGatewayIp("ip01")
    pg01 = scaleway.network.PublicGateway("pg01",
        name="my-pg",
        type="VPC-GW-S",
        ip_id=ip01.id)
    gn01 = scaleway.network.GatewayNetwork("gn01",
        gateway_id=pg01.id,
        private_network_id=pn01.id,
        dhcp_id=dhcp01.id,
        cleanup_dhcp=True,
        enable_masquerade=True)
    rsv01 = scaleway.network.PublicGatewayDhcpReservation("rsv01",
        gateway_network_id=gn01.id,
        mac_address=pnic01.mac_address,
        ip_address="192.168.0.7")
    pat01 = scaleway.network.PublicGatewayPatRule("pat01",
        gateway_id=pg01.id,
        private_ip=rsv01.ip_address,
        private_port=22,
        public_port=2202,
        protocol="tcp")
    main = scaleway.network.get_public_gateway_pat_rule_output(pat_rule_id=pat01.id)
    ```


    :param builtins.str pat_rule_id: The ID of the PAT rule to retrieve
    :param builtins.str zone: `zone`) The zone in which
           the rule exists.
    """
    pulumi.log.warn("""get_vpc_public_pat_rule is deprecated: scaleway.index/getvpcpublicpatrule.getVpcPublicPatRule has been deprecated in favor of scaleway.network/getpublicgatewaypatrule.getPublicGatewayPatRule""")
    __args__ = dict()
    __args__['patRuleId'] = pat_rule_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getVpcPublicPatRule:getVpcPublicPatRule', __args__, opts=opts, typ=GetVpcPublicPatRuleResult).value

    return AwaitableGetVpcPublicPatRuleResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        pat_rule_id=pulumi.get(__ret__, 'pat_rule_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        private_port=pulumi.get(__ret__, 'private_port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        public_port=pulumi.get(__ret__, 'public_port'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        zone=pulumi.get(__ret__, 'zone'))
def get_vpc_public_pat_rule_output(pat_rule_id: Optional[pulumi.Input[builtins.str]] = None,
                                   zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcPublicPatRuleResult]:
    """
    Gets information about a Public Gateway PAT rule. For further information, please see the
    [API documentation](https://www.scaleway.com/en/developers/api/public-gateway/#path-pat-rules-list-pat-rules).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    sg01 = scaleway.instance.SecurityGroup("sg01",
        inbound_default_policy="drop",
        outbound_default_policy="accept",
        inbound_rules=[{
            "action": "accept",
            "port": 22,
            "protocol": "TCP",
        }])
    srv01 = scaleway.instance.Server("srv01",
        name="my-server",
        type="PLAY2-NANO",
        image="ubuntu_jammy",
        security_group_id=sg01.id)
    pn01 = scaleway.network.PrivateNetwork("pn01", name="my-pn")
    pnic01 = scaleway.instance.PrivateNic("pnic01",
        server_id=srv01.id,
        private_network_id=pn01.id)
    dhcp01 = scaleway.network.PublicGatewayDhcp("dhcp01", subnet="192.168.0.0/24")
    ip01 = scaleway.network.PublicGatewayIp("ip01")
    pg01 = scaleway.network.PublicGateway("pg01",
        name="my-pg",
        type="VPC-GW-S",
        ip_id=ip01.id)
    gn01 = scaleway.network.GatewayNetwork("gn01",
        gateway_id=pg01.id,
        private_network_id=pn01.id,
        dhcp_id=dhcp01.id,
        cleanup_dhcp=True,
        enable_masquerade=True)
    rsv01 = scaleway.network.PublicGatewayDhcpReservation("rsv01",
        gateway_network_id=gn01.id,
        mac_address=pnic01.mac_address,
        ip_address="192.168.0.7")
    pat01 = scaleway.network.PublicGatewayPatRule("pat01",
        gateway_id=pg01.id,
        private_ip=rsv01.ip_address,
        private_port=22,
        public_port=2202,
        protocol="tcp")
    main = scaleway.network.get_public_gateway_pat_rule_output(pat_rule_id=pat01.id)
    ```


    :param builtins.str pat_rule_id: The ID of the PAT rule to retrieve
    :param builtins.str zone: `zone`) The zone in which
           the rule exists.
    """
    pulumi.log.warn("""get_vpc_public_pat_rule is deprecated: scaleway.index/getvpcpublicpatrule.getVpcPublicPatRule has been deprecated in favor of scaleway.network/getpublicgatewaypatrule.getPublicGatewayPatRule""")
    __args__ = dict()
    __args__['patRuleId'] = pat_rule_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getVpcPublicPatRule:getVpcPublicPatRule', __args__, opts=opts, typ=GetVpcPublicPatRuleResult)
    return __ret__.apply(lambda __response__: GetVpcPublicPatRuleResult(
        created_at=pulumi.get(__response__, 'created_at'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        id=pulumi.get(__response__, 'id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        pat_rule_id=pulumi.get(__response__, 'pat_rule_id'),
        private_ip=pulumi.get(__response__, 'private_ip'),
        private_port=pulumi.get(__response__, 'private_port'),
        protocol=pulumi.get(__response__, 'protocol'),
        public_port=pulumi.get(__response__, 'public_port'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        zone=pulumi.get(__response__, 'zone')))
