# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    """
    A collection of values returned by getApplication.
    """
    def __init__(__self__, application_id=None, created_at=None, description=None, editable=None, id=None, name=None, organization_id=None, tags=None, updated_at=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def editable(self) -> builtins.bool:
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        return pulumi.get(self, "updated_at")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_id=self.application_id,
            created_at=self.created_at,
            description=self.description,
            editable=self.editable,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            tags=self.tags,
            updated_at=self.updated_at)


def get_application(application_id: Optional[builtins.str] = None,
                    name: Optional[builtins.str] = None,
                    organization_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Gets information about an existing IAM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by name
    find_by_name = scaleway.iam.get_application(name="foobar")
    # Get info by application ID
    find_by_id = scaleway.iam.get_application(application_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str application_id: The ID of the IAM application.
           
           > **Note** You must specify at least one: `name` and/or `application_id`.
    :param builtins.str name: The name of the IAM application.
    :param builtins.str organization_id: `organization_id`) The ID of the
           Organization the application is associated with.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:iam/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        editable=pulumi.get(__ret__, 'editable'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_application_output(application_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           organization_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Gets information about an existing IAM application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by name
    find_by_name = scaleway.iam.get_application(name="foobar")
    # Get info by application ID
    find_by_id = scaleway.iam.get_application(application_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str application_id: The ID of the IAM application.
           
           > **Note** You must specify at least one: `name` and/or `application_id`.
    :param builtins.str name: The name of the IAM application.
    :param builtins.str organization_id: `organization_id`) The ID of the
           Organization the application is associated with.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['name'] = name
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:iam/getApplication:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_id=pulumi.get(__response__, 'application_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        editable=pulumi.get(__response__, 'editable'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
