# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]],
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_principal: Optional[pulumi.Input[builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]] rules: List of rules in the policy.
        :param pulumi.Input[builtins.str] application_id: ID of the application the policy will be linked to
        :param pulumi.Input[builtins.str] description: The description of the IAM policy.
        :param pulumi.Input[builtins.str] group_id: ID of the group the policy will be linked to
        :param pulumi.Input[builtins.str] name: The name of the IAM policy.
        :param pulumi.Input[builtins.bool] no_principal: If the policy doesn't apply to a principal.
               
               > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        :param pulumi.Input[builtins.str] organization_id: `organization_id`) The ID of the organization the policy is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IAM policy.
        :param pulumi.Input[builtins.str] user_id: ID of the user the policy will be linked to
        """
        pulumi.set(__self__, "rules", rules)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_principal is not None:
            pulumi.set(__self__, "no_principal", no_principal)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]:
        """
        List of rules in the policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the application the policy will be linked to
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the IAM policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the group the policy will be linked to
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IAM policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noPrincipal")
    def no_principal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the policy doesn't apply to a principal.

        > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        """
        return pulumi.get(self, "no_principal")

    @no_principal.setter
    def no_principal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_principal", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `organization_id`) The ID of the organization the policy is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the IAM policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the user the policy will be linked to
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 editable: Optional[pulumi.Input[builtins.bool]] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_principal: Optional[pulumi.Input[builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[builtins.str] application_id: ID of the application the policy will be linked to
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the policy.
        :param pulumi.Input[builtins.str] description: The description of the IAM policy.
        :param pulumi.Input[builtins.bool] editable: Whether the policy is editable.
        :param pulumi.Input[builtins.str] group_id: ID of the group the policy will be linked to
        :param pulumi.Input[builtins.str] name: The name of the IAM policy.
        :param pulumi.Input[builtins.bool] no_principal: If the policy doesn't apply to a principal.
               
               > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        :param pulumi.Input[builtins.str] organization_id: `organization_id`) The ID of the organization the policy is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]] rules: List of rules in the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IAM policy.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the policy.
        :param pulumi.Input[builtins.str] user_id: ID of the user the policy will be linked to
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_principal is not None:
            pulumi.set(__self__, "no_principal", no_principal)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the application the policy will be linked to
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the policy.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the IAM policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def editable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the policy is editable.
        """
        return pulumi.get(self, "editable")

    @editable.setter
    def editable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "editable", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the group the policy will be linked to
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IAM policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noPrincipal")
    def no_principal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the policy doesn't apply to a principal.

        > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        """
        return pulumi.get(self, "no_principal")

    @no_principal.setter
    def no_principal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_principal", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `organization_id`) The ID of the organization the policy is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]:
        """
        List of rules in the policy.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the IAM policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the policy.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the user the policy will be linked to
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("scaleway:iam/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_principal: Optional[pulumi.Input[builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway IAM Policies. For more information refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#path-policies-create-a-new-policy).

        > You can find a detailed list of all permission sets available at Scaleway in the permission sets [reference page](https://www.scaleway.com/en/docs/iam/reference-content/permission-sets/).

        ## Example Usage

        ### Create a policy for an organization's project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        default = scaleway.account.get_project(name="default")
        app = scaleway.iam.Application("app", name="my app")
        object_read_only = scaleway.iam.Policy("object_read_only",
            name="my policy",
            description="gives app readonly access to object storage in project",
            application_id=app.id,
            rules=[{
                "project_ids": [default.id],
                "permission_set_names": ["ObjectStorageReadOnly"],
            }])
        ```

        ### Create a policy for all current and future projects in an organization

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        app = scaleway.iam.Application("app", name="my app")
        object_read_only = scaleway.iam.Policy("object_read_only",
            name="my policy",
            description="gives app readonly access to object storage in project",
            application_id=app.id,
            rules=[{
                "organization_id": app.organization_id,
                "permission_set_names": ["ObjectStorageReadOnly"],
            }])
        ```

        ### Create a policy with a particular condition

        IAM policy rule can use a condition to be applied.
        The following variables are available:

        - `request.ip`
        - `request.user_agent`
        - `request.time`

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iam.Policy("main",
            name="tf_tests_policy_condition",
            no_principal=True,
            rules=[{
                "organization_id": "%s",
                "permission_set_names": ["AllProductsFullAccess"],
                "condition": "request.user_agent == 'My User Agent'",
            }])
        ```

        ## Import

        Policies can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/policy:Policy main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: ID of the application the policy will be linked to
        :param pulumi.Input[builtins.str] description: The description of the IAM policy.
        :param pulumi.Input[builtins.str] group_id: ID of the group the policy will be linked to
        :param pulumi.Input[builtins.str] name: The name of the IAM policy.
        :param pulumi.Input[builtins.bool] no_principal: If the policy doesn't apply to a principal.
               
               > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        :param pulumi.Input[builtins.str] organization_id: `organization_id`) The ID of the organization the policy is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]] rules: List of rules in the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IAM policy.
        :param pulumi.Input[builtins.str] user_id: ID of the user the policy will be linked to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway IAM Policies. For more information refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#path-policies-create-a-new-policy).

        > You can find a detailed list of all permission sets available at Scaleway in the permission sets [reference page](https://www.scaleway.com/en/docs/iam/reference-content/permission-sets/).

        ## Example Usage

        ### Create a policy for an organization's project

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        default = scaleway.account.get_project(name="default")
        app = scaleway.iam.Application("app", name="my app")
        object_read_only = scaleway.iam.Policy("object_read_only",
            name="my policy",
            description="gives app readonly access to object storage in project",
            application_id=app.id,
            rules=[{
                "project_ids": [default.id],
                "permission_set_names": ["ObjectStorageReadOnly"],
            }])
        ```

        ### Create a policy for all current and future projects in an organization

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        app = scaleway.iam.Application("app", name="my app")
        object_read_only = scaleway.iam.Policy("object_read_only",
            name="my policy",
            description="gives app readonly access to object storage in project",
            application_id=app.id,
            rules=[{
                "organization_id": app.organization_id,
                "permission_set_names": ["ObjectStorageReadOnly"],
            }])
        ```

        ### Create a policy with a particular condition

        IAM policy rule can use a condition to be applied.
        The following variables are available:

        - `request.ip`
        - `request.user_agent`
        - `request.time`

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iam.Policy("main",
            name="tf_tests_policy_condition",
            no_principal=True,
            rules=[{
                "organization_id": "%s",
                "permission_set_names": ["AllProductsFullAccess"],
                "condition": "request.user_agent == 'My User Agent'",
            }])
        ```

        ## Import

        Policies can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/policy:Policy main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 no_principal: Optional[pulumi.Input[builtins.bool]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["no_principal"] = no_principal
            __props__.__dict__["organization_id"] = organization_id
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["editable"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/iamPolicy:IamPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Policy, __self__).__init__(
            'scaleway:iam/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            editable: Optional[pulumi.Input[builtins.bool]] = None,
            group_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            no_principal: Optional[pulumi.Input[builtins.bool]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            user_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_id: ID of the application the policy will be linked to
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the policy.
        :param pulumi.Input[builtins.str] description: The description of the IAM policy.
        :param pulumi.Input[builtins.bool] editable: Whether the policy is editable.
        :param pulumi.Input[builtins.str] group_id: ID of the group the policy will be linked to
        :param pulumi.Input[builtins.str] name: The name of the IAM policy.
        :param pulumi.Input[builtins.bool] no_principal: If the policy doesn't apply to a principal.
               
               > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        :param pulumi.Input[builtins.str] organization_id: `organization_id`) The ID of the organization the policy is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyRuleArgs', 'PolicyRuleArgsDict']]]] rules: List of rules in the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IAM policy.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the policy.
        :param pulumi.Input[builtins.str] user_id: ID of the user the policy will be linked to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["editable"] = editable
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["no_principal"] = no_principal
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_id"] = user_id
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the application the policy will be linked to
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the policy.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the IAM policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def editable(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the policy is editable.
        """
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the group the policy will be linked to
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IAM policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="noPrincipal")
    def no_principal(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If the policy doesn't apply to a principal.

        > **Important** Only one of `user_id`, `group_id`, `application_id` and `no_principal` may be set.
        """
        return pulumi.get(self, "no_principal")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        `organization_id`) The ID of the organization the policy is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.PolicyRule']]:
        """
        List of rules in the policy.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the IAM policy.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the policy.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the user the policy will be linked to
        """
        return pulumi.get(self, "user_id")

