# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 model_id: pulumi.Input[builtins.str],
                 node_type: pulumi.Input[builtins.str],
                 accept_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input['DeploymentPrivateEndpointArgs']] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_endpoint: Optional[pulumi.Input['DeploymentPublicEndpointArgs']] = None,
                 quantization: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[builtins.str] model_id: The model id used for the deployment.
        :param pulumi.Input[builtins.str] node_type: The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        :param pulumi.Input[builtins.bool] accept_eula: Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        :param pulumi.Input[builtins.int] max_size: The maximum size of the pool.
        :param pulumi.Input[builtins.int] min_size: The minimum size of the pool.
        :param pulumi.Input[builtins.str] name: The deployment name.
        :param pulumi.Input['DeploymentPrivateEndpointArgs'] private_endpoint: Configuration of the deployment's private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]] private_ips: The private IPv4 address associated with the deployment.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input['DeploymentPublicEndpointArgs'] public_endpoint: Configuration of the deployment's public endpoint.
        :param pulumi.Input[builtins.int] quantization: The number of bits each model parameter should be quantized to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the deployment.
        """
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "node_type", node_type)
        if accept_eula is not None:
            pulumi.set(__self__, "accept_eula", accept_eula)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if quantization is not None:
            pulumi.set(__self__, "quantization", quantization)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[builtins.str]:
        """
        The model id used for the deployment.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[builtins.str]:
        """
        The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="acceptEula")
    def accept_eula(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        """
        return pulumi.get(self, "accept_eula")

    @accept_eula.setter
    def accept_eula(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_eula", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of the pool.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum size of the pool.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deployment name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['DeploymentPrivateEndpointArgs']]:
        """
        Configuration of the deployment's private endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['DeploymentPrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the deployment.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input['DeploymentPublicEndpointArgs']]:
        """
        Configuration of the deployment's public endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input['DeploymentPublicEndpointArgs']]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def quantization(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of bits each model parameter should be quantized to
        """
        return pulumi.get(self, "quantization")

    @quantization.setter
    def quantization(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "quantization", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 accept_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 model_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input['DeploymentPrivateEndpointArgs']] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_endpoint: Optional[pulumi.Input['DeploymentPublicEndpointArgs']] = None,
                 quantization: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[builtins.bool] accept_eula: Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the deployment.
        :param pulumi.Input[builtins.int] max_size: The maximum size of the pool.
        :param pulumi.Input[builtins.int] min_size: The minimum size of the pool.
        :param pulumi.Input[builtins.str] model_id: The model id used for the deployment.
        :param pulumi.Input[builtins.str] model_name: The model name used for the deployment. Model names can be found in Console or using Scaleway's CLI (`scw inference model list`)
        :param pulumi.Input[builtins.str] name: The deployment name.
        :param pulumi.Input[builtins.str] node_type: The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        :param pulumi.Input['DeploymentPrivateEndpointArgs'] private_endpoint: Configuration of the deployment's private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]] private_ips: The private IPv4 address associated with the deployment.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input['DeploymentPublicEndpointArgs'] public_endpoint: Configuration of the deployment's public endpoint.
        :param pulumi.Input[builtins.int] quantization: The number of bits each model parameter should be quantized to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.int] size: The size of the pool.
        :param pulumi.Input[builtins.str] status: The status of the deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the deployment.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the deployment.
        """
        if accept_eula is not None:
            pulumi.set(__self__, "accept_eula", accept_eula)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)
        if quantization is not None:
            pulumi.set(__self__, "quantization", quantization)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="acceptEula")
    def accept_eula(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        """
        return pulumi.get(self, "accept_eula")

    @accept_eula.setter
    def accept_eula(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accept_eula", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the deployment.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum size of the pool.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum size of the pool.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The model id used for the deployment.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The model name used for the deployment. Model names can be found in Console or using Scaleway's CLI (`scw inference model list`)
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The deployment name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['DeploymentPrivateEndpointArgs']]:
        """
        Configuration of the deployment's private endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['DeploymentPrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]]:
        """
        The private IPv4 address associated with the deployment.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[pulumi.Input['DeploymentPublicEndpointArgs']]:
        """
        Configuration of the deployment's public endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    @public_endpoint.setter
    def public_endpoint(self, value: Optional[pulumi.Input['DeploymentPublicEndpointArgs']]):
        pulumi.set(self, "public_endpoint", value)

    @property
    @pulumi.getter
    def quantization(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of bits each model parameter should be quantized to
        """
        return pulumi.get(self, "quantization")

    @quantization.setter
    def quantization(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "quantization", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the pool.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the deployment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the deployment.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the deployment.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:inference/deployment:Deployment")
class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input[Union['DeploymentPrivateEndpointArgs', 'DeploymentPrivateEndpointArgsDict']]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPrivateIpArgs', 'DeploymentPrivateIpArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_endpoint: Optional[pulumi.Input[Union['DeploymentPublicEndpointArgs', 'DeploymentPublicEndpointArgsDict']]] = None,
                 quantization: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Managed Inference deployments.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/inference/).

        ## Example Usage

        ## Import

        Functions can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:inference/deployment:Deployment deployment fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_eula: Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        :param pulumi.Input[builtins.int] max_size: The maximum size of the pool.
        :param pulumi.Input[builtins.int] min_size: The minimum size of the pool.
        :param pulumi.Input[builtins.str] model_id: The model id used for the deployment.
        :param pulumi.Input[builtins.str] name: The deployment name.
        :param pulumi.Input[builtins.str] node_type: The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        :param pulumi.Input[Union['DeploymentPrivateEndpointArgs', 'DeploymentPrivateEndpointArgsDict']] private_endpoint: Configuration of the deployment's private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPrivateIpArgs', 'DeploymentPrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the deployment.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[Union['DeploymentPublicEndpointArgs', 'DeploymentPublicEndpointArgsDict']] public_endpoint: Configuration of the deployment's public endpoint.
        :param pulumi.Input[builtins.int] quantization: The number of bits each model parameter should be quantized to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Managed Inference deployments.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/inference/).

        ## Example Usage

        ## Import

        Functions can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:inference/deployment:Deployment deployment fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accept_eula: Optional[pulumi.Input[builtins.bool]] = None,
                 max_size: Optional[pulumi.Input[builtins.int]] = None,
                 min_size: Optional[pulumi.Input[builtins.int]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_type: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input[Union['DeploymentPrivateEndpointArgs', 'DeploymentPrivateEndpointArgsDict']]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPrivateIpArgs', 'DeploymentPrivateIpArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_endpoint: Optional[pulumi.Input[Union['DeploymentPublicEndpointArgs', 'DeploymentPublicEndpointArgsDict']]] = None,
                 quantization: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            __props__.__dict__["accept_eula"] = accept_eula
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["private_endpoint"] = private_endpoint
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_endpoint"] = public_endpoint
            __props__.__dict__["quantization"] = quantization
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["model_name"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/inferenceDeployment:InferenceDeployment")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Deployment, __self__).__init__(
            'scaleway:inference/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accept_eula: Optional[pulumi.Input[builtins.bool]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            max_size: Optional[pulumi.Input[builtins.int]] = None,
            min_size: Optional[pulumi.Input[builtins.int]] = None,
            model_id: Optional[pulumi.Input[builtins.str]] = None,
            model_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_type: Optional[pulumi.Input[builtins.str]] = None,
            private_endpoint: Optional[pulumi.Input[Union['DeploymentPrivateEndpointArgs', 'DeploymentPrivateEndpointArgsDict']]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPrivateIpArgs', 'DeploymentPrivateIpArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            public_endpoint: Optional[pulumi.Input[Union['DeploymentPublicEndpointArgs', 'DeploymentPublicEndpointArgsDict']]] = None,
            quantization: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            size: Optional[pulumi.Input[builtins.int]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accept_eula: Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the deployment.
        :param pulumi.Input[builtins.int] max_size: The maximum size of the pool.
        :param pulumi.Input[builtins.int] min_size: The minimum size of the pool.
        :param pulumi.Input[builtins.str] model_id: The model id used for the deployment.
        :param pulumi.Input[builtins.str] model_name: The model name used for the deployment. Model names can be found in Console or using Scaleway's CLI (`scw inference model list`)
        :param pulumi.Input[builtins.str] name: The deployment name.
        :param pulumi.Input[builtins.str] node_type: The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        :param pulumi.Input[Union['DeploymentPrivateEndpointArgs', 'DeploymentPrivateEndpointArgsDict']] private_endpoint: Configuration of the deployment's private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeploymentPrivateIpArgs', 'DeploymentPrivateIpArgsDict']]]] private_ips: The private IPv4 address associated with the deployment.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the deployment is associated with.
        :param pulumi.Input[Union['DeploymentPublicEndpointArgs', 'DeploymentPublicEndpointArgsDict']] public_endpoint: Configuration of the deployment's public endpoint.
        :param pulumi.Input[builtins.int] quantization: The number of bits each model parameter should be quantized to
        :param pulumi.Input[builtins.str] region: `region`) The region in which the deployment is created.
        :param pulumi.Input[builtins.int] size: The size of the pool.
        :param pulumi.Input[builtins.str] status: The status of the deployment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the deployment.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["accept_eula"] = accept_eula
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["model_name"] = model_name
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["private_endpoint"] = private_endpoint
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_endpoint"] = public_endpoint
        __props__.__dict__["quantization"] = quantization
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptEula")
    def accept_eula(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Some models (e.g Meta Llama) require end-user license agreements. Set `true` to accept.
        """
        return pulumi.get(self, "accept_eula")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the deployment.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum size of the pool.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum size of the pool.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[builtins.str]:
        """
        The model id used for the deployment.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> pulumi.Output[builtins.str]:
        """
        The model name used for the deployment. Model names can be found in Console or using Scaleway's CLI (`scw inference model list`)
        """
        return pulumi.get(self, "model_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The deployment name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[builtins.str]:
        """
        The node type to use for the deployment. Node types can be found using Scaleway's CLI (`scw inference node-type list`)
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> pulumi.Output[Optional['outputs.DeploymentPrivateEndpoint']]:
        """
        Configuration of the deployment's private endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.DeploymentPrivateIp']]:
        """
        The private IPv4 address associated with the deployment.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the deployment is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> pulumi.Output[Optional['outputs.DeploymentPublicEndpoint']]:
        """
        Configuration of the deployment's public endpoint.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter
    def quantization(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of bits each model parameter should be quantized to
        """
        return pulumi.get(self, "quantization")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the deployment is created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[builtins.int]:
        """
        The size of the pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the deployment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the deployment.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the deployment.
        """
        return pulumi.get(self, "updated_at")

