# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceServerArgs', 'InstanceServer']

@pulumi.input_type
class InstanceServerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_password_encryption_ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 boot_type: Optional[pulumi.Input[builtins.str]] = None,
                 bootscript_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_init: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]] = None,
                 replace_on_type_change: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume: Optional[pulumi.Input['InstanceServerRootVolumeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceServer resource.
        :param pulumi.Input[builtins.str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
               Use `replace_on_type_change` to trigger replacement instead of migration.
               
               > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_volume_ids: The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
               attached to the server. Updates to this field will trigger a stop/start of the server.
               
               > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.
               
               > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        :param pulumi.Input[builtins.str] admin_password_encryption_ssh_key_id: The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
               Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
               When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        :param pulumi.Input[builtins.str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[builtins.str] bootscript_id: ID of the target bootscript (set boot_type to bootscript)
        :param pulumi.Input[builtins.str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[builtins.bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[builtins.bool] enable_ipv6: Determines if IPv6 is enabled for the server.
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
               
               You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```
               
               To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        :param pulumi.Input[builtins.str] ip_id: The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.
               
               > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] placement_group_id: The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.
               
               
               > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]] public_ips: The list of public IPs of the server.
        :param pulumi.Input[builtins.bool] replace_on_type_change: If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        :param pulumi.Input['InstanceServerRootVolumeArgs'] root_volume: Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        :param pulumi.Input[builtins.str] security_group_id: The security group the server is attached to
        :param pulumi.Input[builtins.str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_data: The user data associated with the server.
               Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
               You can define values using:
               - string
               - UTF-8 encoded file content using file
               - Binary files using filebase64.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "type", type)
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if admin_password_encryption_ssh_key_id is not None:
            pulumi.set(__self__, "admin_password_encryption_ssh_key_id", admin_password_encryption_ssh_key_id)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if bootscript_id is not None:
            warnings.warn("""bootscript is not supported anymore.""", DeprecationWarning)
            pulumi.log.warn("""bootscript_id is deprecated: bootscript is not supported anymore.""")
        if bootscript_id is not None:
            pulumi.set(__self__, "bootscript_id", bootscript_id)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if enable_dynamic_ip is not None:
            pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        if enable_ipv6 is not None:
            warnings.warn("""Please use a instance.Ip with a `routed_ipv6` type""", DeprecationWarning)
            pulumi.log.warn("""enable_ipv6 is deprecated: Please use a instance.Ip with a `routed_ipv6` type""")
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if replace_on_type_change is not None:
            pulumi.set(__self__, "replace_on_type_change", replace_on_type_change)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
        Use `replace_on_type_change` to trigger replacement instead of migration.

        > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
        attached to the server. Updates to this field will trigger a stop/start of the server.

        > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.

        > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @property
    @pulumi.getter(name="adminPasswordEncryptionSshKeyId")
    def admin_password_encryption_ssh_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
        Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
        When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        """
        return pulumi.get(self, "admin_password_encryption_ssh_key_id")

    @admin_password_encryption_ssh_key_id.setter
    def admin_password_encryption_ssh_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_password_encryption_ssh_key_id", value)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_type", value)

    @property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript is not supported anymore.""")
    def bootscript_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the target bootscript (set boot_type to bootscript)
        """
        return pulumi.get(self, "bootscript_id")

    @bootscript_id.setter
    def bootscript_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bootscript_id", value)

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_init", value)

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @enable_dynamic_ip.setter
    def enable_dynamic_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_dynamic_ip", value)

    @property
    @pulumi.getter(name="enableIpv6")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def enable_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if IPv6 is enabled for the server.
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.

        You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```

        To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.

        > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.


        > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]]:
        """
        The list of public IPs of the server.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter(name="replaceOnTypeChange")
    def replace_on_type_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        """
        return pulumi.get(self, "replace_on_type_change")

    @replace_on_type_change.setter
    def replace_on_type_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_on_type_change", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['InstanceServerRootVolumeArgs']]:
        """
        Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['InstanceServerRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The security group the server is attached to
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The user data associated with the server.
        Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
        You can define values using:
        - string
        - UTF-8 encoded file content using file
        - Binary files using filebase64.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceServerState:
    def __init__(__self__, *,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_password_encryption_ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 boot_type: Optional[pulumi.Input[builtins.str]] = None,
                 bootscript_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_init: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_prefix_length: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group_policy_respected: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 public_ip: Optional[pulumi.Input[builtins.str]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]] = None,
                 replace_on_type_change: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume: Optional[pulumi.Input['InstanceServerRootVolumeArgs']] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceServer resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_volume_ids: The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
               attached to the server. Updates to this field will trigger a stop/start of the server.
               
               > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.
               
               > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        :param pulumi.Input[builtins.str] admin_password_encryption_ssh_key_id: The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
               Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
               When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        :param pulumi.Input[builtins.str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[builtins.str] bootscript_id: ID of the target bootscript (set boot_type to bootscript)
        :param pulumi.Input[builtins.str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[builtins.bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[builtins.bool] enable_ipv6: Determines if IPv6 is enabled for the server.
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
               
               You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```
               
               To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        :param pulumi.Input[builtins.str] ip_id: The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.
               
               > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        :param pulumi.Input[builtins.str] ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.int] ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] placement_group_id: The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.
               
               
               > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        :param pulumi.Input[builtins.bool] placement_group_policy_respected: (Deprecated) Always false, use instance_placement_group ressource to known when the placement group policy is respected.
        :param pulumi.Input[builtins.str] private_ip: The Scaleway internal IP address of the server (Deprecated use ipam_ip datasource instead).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.str] public_ip: The public IP address of the server (Deprecated use `public_ips` instead).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]] public_ips: The list of public IPs of the server.
        :param pulumi.Input[builtins.bool] replace_on_type_change: If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        :param pulumi.Input['InstanceServerRootVolumeArgs'] root_volume: Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        :param pulumi.Input[builtins.str] security_group_id: The security group the server is attached to
        :param pulumi.Input[builtins.str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
               Use `replace_on_type_change` to trigger replacement instead of migration.
               
               > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_data: The user data associated with the server.
               Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
               You can define values using:
               - string
               - UTF-8 encoded file content using file
               - Binary files using filebase64.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        if additional_volume_ids is not None:
            pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if admin_password_encryption_ssh_key_id is not None:
            pulumi.set(__self__, "admin_password_encryption_ssh_key_id", admin_password_encryption_ssh_key_id)
        if boot_type is not None:
            pulumi.set(__self__, "boot_type", boot_type)
        if bootscript_id is not None:
            warnings.warn("""bootscript is not supported anymore.""", DeprecationWarning)
            pulumi.log.warn("""bootscript_id is deprecated: bootscript is not supported anymore.""")
        if bootscript_id is not None:
            pulumi.set(__self__, "bootscript_id", bootscript_id)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if enable_dynamic_ip is not None:
            pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        if enable_ipv6 is not None:
            warnings.warn("""Please use a instance.Ip with a `routed_ipv6` type""", DeprecationWarning)
            pulumi.log.warn("""enable_ipv6 is deprecated: Please use a instance.Ip with a `routed_ipv6` type""")
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if ipv6_address is not None:
            warnings.warn("""Please use a instance.Ip with a `routed_ipv6` type""", DeprecationWarning)
            pulumi.log.warn("""ipv6_address is deprecated: Please use a instance.Ip with a `routed_ipv6` type""")
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_gateway is not None:
            warnings.warn("""Please use a instance.Ip with a `routed_ipv6` type""", DeprecationWarning)
            pulumi.log.warn("""ipv6_gateway is deprecated: Please use a instance.Ip with a `routed_ipv6` type""")
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if ipv6_prefix_length is not None:
            warnings.warn("""Please use a instance.Ip with a `routed_ipv6` type""", DeprecationWarning)
            pulumi.log.warn("""ipv6_prefix_length is deprecated: Please use a instance.Ip with a `routed_ipv6` type""")
        if ipv6_prefix_length is not None:
            pulumi.set(__self__, "ipv6_prefix_length", ipv6_prefix_length)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if placement_group_policy_respected is not None:
            pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        if private_ip is not None:
            warnings.warn("""Use ipam_ip datasource instead to fetch your server's IP in your private network.""", DeprecationWarning)
            pulumi.log.warn("""private_ip is deprecated: Use ipam_ip datasource instead to fetch your server's IP in your private network.""")
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if public_ip is not None:
            warnings.warn("""Use public_ips instead""", DeprecationWarning)
            pulumi.log.warn("""public_ip is deprecated: Use public_ips instead""")
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if replace_on_type_change is not None:
            pulumi.set(__self__, "replace_on_type_change", replace_on_type_change)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
        attached to the server. Updates to this field will trigger a stop/start of the server.

        > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.

        > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        """
        return pulumi.get(self, "additional_volume_ids")

    @additional_volume_ids.setter
    def additional_volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_volume_ids", value)

    @property
    @pulumi.getter(name="adminPasswordEncryptionSshKeyId")
    def admin_password_encryption_ssh_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
        Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
        When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        """
        return pulumi.get(self, "admin_password_encryption_ssh_key_id")

    @admin_password_encryption_ssh_key_id.setter
    def admin_password_encryption_ssh_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "admin_password_encryption_ssh_key_id", value)

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @boot_type.setter
    def boot_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_type", value)

    @property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript is not supported anymore.""")
    def bootscript_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the target bootscript (set boot_type to bootscript)
        """
        return pulumi.get(self, "bootscript_id")

    @bootscript_id.setter
    def bootscript_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bootscript_id", value)

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_init", value)

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @enable_dynamic_ip.setter
    def enable_dynamic_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_dynamic_ip", value)

    @property
    @pulumi.getter(name="enableIpv6")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def enable_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if IPv6 is enabled for the server.
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.

        You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```

        To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.

        > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @property
    @pulumi.getter(name="ipv6Address")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_prefix_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @ipv6_prefix_length.setter
    def ipv6_prefix_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ipv6_prefix_length", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.


        > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Deprecated) Always false, use instance_placement_group ressource to known when the placement group policy is respected.
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @placement_group_policy_respected.setter
    def placement_group_policy_respected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "placement_group_policy_respected", value)

    @property
    @pulumi.getter(name="privateIp")
    @_utilities.deprecated("""Use ipam_ip datasource instead to fetch your server's IP in your private network.""")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Scaleway internal IP address of the server (Deprecated use ipam_ip datasource instead).
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Use public_ips instead""")
    def public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public IP address of the server (Deprecated use `public_ips` instead).
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]]:
        """
        The list of public IPs of the server.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerPublicIpArgs']]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter(name="replaceOnTypeChange")
    def replace_on_type_change(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        """
        return pulumi.get(self, "replace_on_type_change")

    @replace_on_type_change.setter
    def replace_on_type_change(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replace_on_type_change", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['InstanceServerRootVolumeArgs']]:
        """
        Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['InstanceServerRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The security group the server is attached to
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
        Use `replace_on_type_change` to trigger replacement instead of migration.

        > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The user data associated with the server.
        Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
        You can define values using:
        - string
        - UTF-8 encoded file content using file
        - Binary files using filebase64.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/instanceserver.InstanceServer has been deprecated in favor of scaleway.instance/server.Server""", DeprecationWarning)


@pulumi.type_token("scaleway:index/instanceServer:InstanceServer")
class InstanceServer(pulumi.CustomResource):
    warnings.warn("""scaleway.index/instanceserver.InstanceServer has been deprecated in favor of scaleway.instance/server.Server""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_password_encryption_ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 boot_type: Optional[pulumi.Input[builtins.str]] = None,
                 bootscript_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_init: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateIpArgs', 'InstanceServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateNetworkArgs', 'InstanceServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPublicIpArgs', 'InstanceServerPublicIpArgsDict']]]]] = None,
                 replace_on_type_change: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume: Optional[pulumi.Input[Union['InstanceServerRootVolumeArgs', 'InstanceServerRootVolumeArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway compute Instances. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances).

        Please check our [FAQ - Instances](https://www.scaleway.com/en/docs/faq/instances).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        public_ip = scaleway.instance.Ip("public_ip")
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            ip_id=public_ip.id)
        ```

        ### With additional volumes and tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        data = scaleway.block.Volume("data",
            size_in_gb=100,
            iops=5000)
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "hello",
                "public",
            ],
            root_volume={
                "delete_on_termination": False,
            },
            additional_volume_ids=[data.id])
        ```

        ### With a reserved IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ip = scaleway.instance.Ip("ip")
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="f974feac-abae-4365-b988-8ec7d1cec10d",
            tags=[
                "hello",
                "public",
            ],
            ip_id=ip.id)
        ```

        ### With security group

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.instance.SecurityGroup("www",
            inbound_default_policy="drop",
            outbound_default_policy="accept",
            inbound_rules=[
                {
                    "action": "accept",
                    "port": 22,
                    "ip": "212.47.225.64",
                },
                {
                    "action": "accept",
                    "port": 80,
                },
                {
                    "action": "accept",
                    "port": 443,
                },
            ],
            outbound_rules=[{
                "action": "drop",
                "ip_range": "10.20.0.0/24",
            }])
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            security_group_id=www.id)
        ```

        ### With private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01", name="private_network_instance")
        base = scaleway.instance.Server("base",
            image="ubuntu_jammy",
            type="DEV1-S",
            private_networks=[{
                "pn_id": pn01.id,
            }])
        ```

        ### Root volume configuration

        ### Resized block volume with installed image

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        image = scaleway.instance.Server("image",
            type="PRO2-XXS",
            image="ubuntu_jammy",
            root_volume={
                "size_in_gb": 100,
            })
        ```

        ### From snapshot

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        snapshot = scaleway.block.get_snapshot(name="my_snapshot")
        from_snapshot = scaleway.block.Volume("from_snapshot",
            snapshot_id=snapshot.id,
            iops=5000)
        from_snapshot_server = scaleway.instance.Server("from_snapshot",
            type="PRO2-XXS",
            root_volume={
                "volume_id": from_snapshot.id,
                "volume_type": "sbs_volume",
            })
        ```

        ### Using Scaleway Block Storage (SBS) volume

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            type="PLAY2-MICRO",
            image="ubuntu_jammy",
            root_volume={
                "volume_type": "sbs_volume",
                "sbs_iops": 15000,
                "size_in_gb": 50,
            })
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate a new private network interface.

        - `pn_id` - (Required) The private network ID where to connect.
        - `mac_address` The private NIC MAC address.
        - `status` The private NIC state.
        - `zone` - (Defaults to provider `zone`) The zone in which the server must be created.

        > **Important:** You can only attach an instance in the same zone as a private network.
        **Important:** Instance supports a maximum of 8 different private networks.

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/instanceServer:InstanceServer web fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_volume_ids: The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
               attached to the server. Updates to this field will trigger a stop/start of the server.
               
               > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.
               
               > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        :param pulumi.Input[builtins.str] admin_password_encryption_ssh_key_id: The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
               Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
               When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        :param pulumi.Input[builtins.str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[builtins.str] bootscript_id: ID of the target bootscript (set boot_type to bootscript)
        :param pulumi.Input[builtins.str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[builtins.bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[builtins.bool] enable_ipv6: Determines if IPv6 is enabled for the server.
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
               
               You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```
               
               To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        :param pulumi.Input[builtins.str] ip_id: The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.
               
               > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] placement_group_id: The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.
               
               
               > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateIpArgs', 'InstanceServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateNetworkArgs', 'InstanceServerPrivateNetworkArgsDict']]]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPublicIpArgs', 'InstanceServerPublicIpArgsDict']]]] public_ips: The list of public IPs of the server.
        :param pulumi.Input[builtins.bool] replace_on_type_change: If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        :param pulumi.Input[Union['InstanceServerRootVolumeArgs', 'InstanceServerRootVolumeArgsDict']] root_volume: Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        :param pulumi.Input[builtins.str] security_group_id: The security group the server is attached to
        :param pulumi.Input[builtins.str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
               Use `replace_on_type_change` to trigger replacement instead of migration.
               
               > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_data: The user data associated with the server.
               Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
               You can define values using:
               - string
               - UTF-8 encoded file content using file
               - Binary files using filebase64.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway compute Instances. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances).

        Please check our [FAQ - Instances](https://www.scaleway.com/en/docs/faq/instances).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        public_ip = scaleway.instance.Ip("public_ip")
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            ip_id=public_ip.id)
        ```

        ### With additional volumes and tags

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        data = scaleway.block.Volume("data",
            size_in_gb=100,
            iops=5000)
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "hello",
                "public",
            ],
            root_volume={
                "delete_on_termination": False,
            },
            additional_volume_ids=[data.id])
        ```

        ### With a reserved IP

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ip = scaleway.instance.Ip("ip")
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="f974feac-abae-4365-b988-8ec7d1cec10d",
            tags=[
                "hello",
                "public",
            ],
            ip_id=ip.id)
        ```

        ### With security group

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.instance.SecurityGroup("www",
            inbound_default_policy="drop",
            outbound_default_policy="accept",
            inbound_rules=[
                {
                    "action": "accept",
                    "port": 22,
                    "ip": "212.47.225.64",
                },
                {
                    "action": "accept",
                    "port": 80,
                },
                {
                    "action": "accept",
                    "port": 443,
                },
            ],
            outbound_rules=[{
                "action": "drop",
                "ip_range": "10.20.0.0/24",
            }])
        web = scaleway.instance.Server("web",
            type="DEV1-S",
            image="ubuntu_jammy",
            security_group_id=www.id)
        ```

        ### With private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn01 = scaleway.network.PrivateNetwork("pn01", name="private_network_instance")
        base = scaleway.instance.Server("base",
            image="ubuntu_jammy",
            type="DEV1-S",
            private_networks=[{
                "pn_id": pn01.id,
            }])
        ```

        ### Root volume configuration

        ### Resized block volume with installed image

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        image = scaleway.instance.Server("image",
            type="PRO2-XXS",
            image="ubuntu_jammy",
            root_volume={
                "size_in_gb": 100,
            })
        ```

        ### From snapshot

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        snapshot = scaleway.block.get_snapshot(name="my_snapshot")
        from_snapshot = scaleway.block.Volume("from_snapshot",
            snapshot_id=snapshot.id,
            iops=5000)
        from_snapshot_server = scaleway.instance.Server("from_snapshot",
            type="PRO2-XXS",
            root_volume={
                "volume_id": from_snapshot.id,
                "volume_type": "sbs_volume",
            })
        ```

        ### Using Scaleway Block Storage (SBS) volume

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.instance.Server("server",
            type="PLAY2-MICRO",
            image="ubuntu_jammy",
            root_volume={
                "volume_type": "sbs_volume",
                "sbs_iops": 15000,
                "size_in_gb": 50,
            })
        ```

        ## Private Network

        > **Important:** Updates to `private_network` will recreate a new private network interface.

        - `pn_id` - (Required) The private network ID where to connect.
        - `mac_address` The private NIC MAC address.
        - `status` The private NIC state.
        - `zone` - (Defaults to provider `zone`) The zone in which the server must be created.

        > **Important:** You can only attach an instance in the same zone as a private network.
        **Important:** Instance supports a maximum of 8 different private networks.

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/instanceServer:InstanceServer web fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 admin_password_encryption_ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 boot_type: Optional[pulumi.Input[builtins.str]] = None,
                 bootscript_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_init: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dynamic_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateIpArgs', 'InstanceServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateNetworkArgs', 'InstanceServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPublicIpArgs', 'InstanceServerPublicIpArgsDict']]]]] = None,
                 replace_on_type_change: Optional[pulumi.Input[builtins.bool]] = None,
                 root_volume: Optional[pulumi.Input[Union['InstanceServerRootVolumeArgs', 'InstanceServerRootVolumeArgsDict']]] = None,
                 security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""InstanceServer is deprecated: scaleway.index/instanceserver.InstanceServer has been deprecated in favor of scaleway.instance/server.Server""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceServerArgs.__new__(InstanceServerArgs)

            __props__.__dict__["additional_volume_ids"] = additional_volume_ids
            __props__.__dict__["admin_password_encryption_ssh_key_id"] = admin_password_encryption_ssh_key_id
            __props__.__dict__["boot_type"] = boot_type
            __props__.__dict__["bootscript_id"] = bootscript_id
            __props__.__dict__["cloud_init"] = cloud_init
            __props__.__dict__["enable_dynamic_ip"] = enable_dynamic_ip
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["image"] = image
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["ip_ids"] = ip_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protected"] = protected
            __props__.__dict__["public_ips"] = public_ips
            __props__.__dict__["replace_on_type_change"] = replace_on_type_change
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["ipv6_gateway"] = None
            __props__.__dict__["ipv6_prefix_length"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["placement_group_policy_respected"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
        super(InstanceServer, __self__).__init__(
            'scaleway:index/instanceServer:InstanceServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            admin_password_encryption_ssh_key_id: Optional[pulumi.Input[builtins.str]] = None,
            boot_type: Optional[pulumi.Input[builtins.str]] = None,
            bootscript_id: Optional[pulumi.Input[builtins.str]] = None,
            cloud_init: Optional[pulumi.Input[builtins.str]] = None,
            enable_dynamic_ip: Optional[pulumi.Input[builtins.bool]] = None,
            enable_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            image: Optional[pulumi.Input[builtins.str]] = None,
            ip_id: Optional[pulumi.Input[builtins.str]] = None,
            ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_gateway: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_prefix_length: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            placement_group_policy_respected: Optional[pulumi.Input[builtins.bool]] = None,
            private_ip: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateIpArgs', 'InstanceServerPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateNetworkArgs', 'InstanceServerPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            protected: Optional[pulumi.Input[builtins.bool]] = None,
            public_ip: Optional[pulumi.Input[builtins.str]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPublicIpArgs', 'InstanceServerPublicIpArgsDict']]]]] = None,
            replace_on_type_change: Optional[pulumi.Input[builtins.bool]] = None,
            root_volume: Optional[pulumi.Input[Union['InstanceServerRootVolumeArgs', 'InstanceServerRootVolumeArgsDict']]] = None,
            security_group_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            user_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'InstanceServer':
        """
        Get an existing InstanceServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] additional_volume_ids: The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
               attached to the server. Updates to this field will trigger a stop/start of the server.
               
               > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.
               
               > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        :param pulumi.Input[builtins.str] admin_password_encryption_ssh_key_id: The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
               Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
               When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        :param pulumi.Input[builtins.str] boot_type: The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        :param pulumi.Input[builtins.str] bootscript_id: ID of the target bootscript (set boot_type to bootscript)
        :param pulumi.Input[builtins.str] cloud_init: The cloud init script associated with this server
        :param pulumi.Input[builtins.bool] enable_dynamic_ip: If true a dynamic IP will be attached to the server.
        :param pulumi.Input[builtins.bool] enable_ipv6: Determines if IPv6 is enabled for the server.
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] image: The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
               to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.
               
               You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```
               
               To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        :param pulumi.Input[builtins.str] ip_id: The ID of the reserved IP that is attached to the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.
               
               > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        :param pulumi.Input[builtins.str] ipv6_address: The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] ipv6_gateway: The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.int] ipv6_prefix_length: The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
               Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] placement_group_id: The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.
               
               
               > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        :param pulumi.Input[builtins.bool] placement_group_policy_respected: (Deprecated) Always false, use instance_placement_group ressource to known when the placement group policy is respected.
        :param pulumi.Input[builtins.str] private_ip: The Scaleway internal IP address of the server (Deprecated use ipam_ip datasource instead).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateIpArgs', 'InstanceServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPrivateNetworkArgs', 'InstanceServerPrivateNetworkArgsDict']]]] private_networks: The private network associated with the server.
               Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[builtins.bool] protected: Set to true to activate server protection option.
        :param pulumi.Input[builtins.str] public_ip: The public IP address of the server (Deprecated use `public_ips` instead).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerPublicIpArgs', 'InstanceServerPublicIpArgsDict']]]] public_ips: The list of public IPs of the server.
        :param pulumi.Input[builtins.bool] replace_on_type_change: If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        :param pulumi.Input[Union['InstanceServerRootVolumeArgs', 'InstanceServerRootVolumeArgsDict']] root_volume: Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        :param pulumi.Input[builtins.str] security_group_id: The security group the server is attached to
        :param pulumi.Input[builtins.str] state: The state of the server. Possible values are: `started`, `stopped` or `standby`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the server.
        :param pulumi.Input[builtins.str] type: The commercial type of the server.
               You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
               Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
               Use `replace_on_type_change` to trigger replacement instead of migration.
               
               > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_data: The user data associated with the server.
               Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
               You can define values using:
               - string
               - UTF-8 encoded file content using file
               - Binary files using filebase64.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceServerState.__new__(_InstanceServerState)

        __props__.__dict__["additional_volume_ids"] = additional_volume_ids
        __props__.__dict__["admin_password_encryption_ssh_key_id"] = admin_password_encryption_ssh_key_id
        __props__.__dict__["boot_type"] = boot_type
        __props__.__dict__["bootscript_id"] = bootscript_id
        __props__.__dict__["cloud_init"] = cloud_init
        __props__.__dict__["enable_dynamic_ip"] = enable_dynamic_ip
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["image"] = image
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["ip_ids"] = ip_ids
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_gateway"] = ipv6_gateway
        __props__.__dict__["ipv6_prefix_length"] = ipv6_prefix_length
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["placement_group_policy_respected"] = placement_group_policy_respected
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protected"] = protected
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["replace_on_type_change"] = replace_on_type_change
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["zone"] = zone
        return InstanceServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The [additional volumes](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types)
        attached to the server. Updates to this field will trigger a stop/start of the server.

        > **Important:** If this field contains local volumes, the `state` must be set to `stopped`, otherwise it will fail.

        > **Important:** If this field contains local volumes, you have to first detach them, in one apply, and then delete the volume in another apply.
        """
        return pulumi.get(self, "additional_volume_ids")

    @property
    @pulumi.getter(name="adminPasswordEncryptionSshKeyId")
    def admin_password_encryption_ssh_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the SSH RSA key that will be used to encrypt the initial admin password for OS requiring it.
        Mandatory for Windows OS. The public_key value of this key is used to encrypt the admin password.
        When set to an empty string, it resets this value and admin_password_encrypted_value to an empty string so a new password may be generated.
        """
        return pulumi.get(self, "admin_password_encryption_ssh_key_id")

    @property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The boot Type of the server. Possible values are: `local`, `bootscript` or `rescue`.
        """
        return pulumi.get(self, "boot_type")

    @property
    @pulumi.getter(name="bootscriptId")
    @_utilities.deprecated("""bootscript is not supported anymore.""")
    def bootscript_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the target bootscript (set boot_type to bootscript)
        """
        return pulumi.get(self, "bootscript_id")

    @property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> pulumi.Output[builtins.str]:
        """
        The cloud init script associated with this server
        """
        return pulumi.get(self, "cloud_init")

    @property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true a dynamic IP will be attached to the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @property
    @pulumi.getter(name="enableIpv6")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def enable_ipv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if IPv6 is enabled for the server.
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The UUID or the label of the base image used by the server. You can use [this endpoint](https://www.scaleway.com/en/developers/api/marketplace/#path-marketplace-images-list-marketplace-images)
        to find either the right `label` or the right local image `ID` for a given `type`. Optional when creating an instance with an existing root volume.

        You can check the available labels with our [CLI](https://www.scaleway.com/en/docs/compute/instances/api-cli/creating-managing-instances-with-cliv2/). ```scw marketplace image list```

        To retrieve more information by label please use: ```scw marketplace image get label=<LABEL>```
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the reserved IP that is attached to the server.
        """
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of ID of reserved IPs that are attached to the server. Cannot be used with `ip_id`.

        > `ip_id` to `ip_ids` migration: if moving the ip from the old `ip_id` field to the new `ip_ids`, it should not detach the ip.
        """
        return pulumi.get(self, "ip_ids")

    @property
    @pulumi.getter(name="ipv6Address")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_address(self) -> pulumi.Output[builtins.str]:
        """
        The default ipv6 address routed to the server. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6Gateway")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_gateway(self) -> pulumi.Output[builtins.str]:
        """
        The ipv6 gateway address. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6PrefixLength")
    @_utilities.deprecated("""Please use a instance.Ip with a `routed_ipv6` type""")
    def ipv6_prefix_length(self) -> pulumi.Output[builtins.int]:
        """
        The prefix length of the ipv6 subnet routed to the server. ( Only set when enable_ipv6 is set to true )
        Deprecated: Please use a instance.Ip with a `routed_ipv6` type.
        """
        return pulumi.get(self, "ipv6_prefix_length")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [placement group](https://www.scaleway.com/en/developers/api/instance/#path-security-groups-update-a-security-group the server is attached to.


        > **Important:** When updating `placement_group_id` the `state` must be set to `stopped`, otherwise it will fail.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> pulumi.Output[builtins.bool]:
        """
        (Deprecated) Always false, use instance_placement_group ressource to known when the placement group policy is respected.
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @property
    @pulumi.getter(name="privateIp")
    @_utilities.deprecated("""Use ipam_ip datasource instead to fetch your server's IP in your private network.""")
    def private_ip(self) -> pulumi.Output[builtins.str]:
        """
        The Scaleway internal IP address of the server (Deprecated use ipam_ip datasource instead).
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.InstanceServerPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceServerPrivateNetwork']]]:
        """
        The private network associated with the server.
        Use the `pn_id` key to attach a [private_network](https://www.scaleway.com/en/developers/api/instance/#path-private-nics-list-all-private-nics) on your instance.
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def protected(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to true to activate server protection option.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter(name="publicIp")
    @_utilities.deprecated("""Use public_ips instead""")
    def public_ip(self) -> pulumi.Output[builtins.str]:
        """
        The public IP address of the server (Deprecated use `public_ips` instead).
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence['outputs.InstanceServerPublicIp']]:
        """
        The list of public IPs of the server.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter(name="replaceOnTypeChange")
    def replace_on_type_change(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the server will be replaced if `type` is changed. Otherwise, the server will migrate.
        """
        return pulumi.get(self, "replace_on_type_change")

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.InstanceServerRootVolume']:
        """
        Root [volume](https://www.scaleway.com/en/developers/api/instance/#path-volume-types-list-volume-types) attached to the server on creation.
        """
        return pulumi.get(self, "root_volume")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The security group the server is attached to
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        Updates to this field will migrate the server, local storage constraint must be respected. [More info](https://www.scaleway.com/en/docs/compute/instances/api-cli/migrating-instances/).
        Use `replace_on_type_change` to trigger replacement instead of migration.

        > **Important:** If `type` change and migration occurs, the server will be stopped and changed backed to its original state. It will be started again if it was running.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The user data associated with the server.
        Use the `cloud-init` key to use [cloud-init](https://cloudinit.readthedocs.io/en/latest/) on your instance.
        You can define values using:
        - string
        - UTF-8 encoded file content using file
        - Binary files using filebase64.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

