# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DeviceCertificateArgs',
    'DeviceCertificateArgsDict',
    'DeviceMessageFiltersArgs',
    'DeviceMessageFiltersArgsDict',
    'DeviceMessageFiltersPublishArgs',
    'DeviceMessageFiltersPublishArgsDict',
    'DeviceMessageFiltersSubscribeArgs',
    'DeviceMessageFiltersSubscribeArgsDict',
    'RouteDatabaseArgs',
    'RouteDatabaseArgsDict',
    'RouteRestArgs',
    'RouteRestArgsDict',
    'RouteS3Args',
    'RouteS3ArgsDict',
]

MYPY = False

if not MYPY:
    class DeviceCertificateArgsDict(TypedDict):
        crt: NotRequired[pulumi.Input[builtins.str]]
        """
        X509 PEM encoded certificate of the device
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The private key of the device, in case it is generated by Scaleway.
        """
elif False:
    DeviceCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceCertificateArgs:
    def __init__(__self__, *,
                 crt: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] crt: X509 PEM encoded certificate of the device
        :param pulumi.Input[builtins.str] key: The private key of the device, in case it is generated by Scaleway.
        """
        if crt is not None:
            pulumi.set(__self__, "crt", crt)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def crt(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        X509 PEM encoded certificate of the device
        """
        return pulumi.get(self, "crt")

    @crt.setter
    def crt(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crt", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private key of the device, in case it is generated by Scaleway.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class DeviceMessageFiltersArgsDict(TypedDict):
        publish: NotRequired[pulumi.Input['DeviceMessageFiltersPublishArgsDict']]
        """
        Rules used to restrict topics the device can publish to.
        """
        subscribe: NotRequired[pulumi.Input['DeviceMessageFiltersSubscribeArgsDict']]
        """
        Rules used to restrict topics the device can subscribe to.
        """
elif False:
    DeviceMessageFiltersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceMessageFiltersArgs:
    def __init__(__self__, *,
                 publish: Optional[pulumi.Input['DeviceMessageFiltersPublishArgs']] = None,
                 subscribe: Optional[pulumi.Input['DeviceMessageFiltersSubscribeArgs']] = None):
        """
        :param pulumi.Input['DeviceMessageFiltersPublishArgs'] publish: Rules used to restrict topics the device can publish to.
        :param pulumi.Input['DeviceMessageFiltersSubscribeArgs'] subscribe: Rules used to restrict topics the device can subscribe to.
        """
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if subscribe is not None:
            pulumi.set(__self__, "subscribe", subscribe)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input['DeviceMessageFiltersPublishArgs']]:
        """
        Rules used to restrict topics the device can publish to.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input['DeviceMessageFiltersPublishArgs']]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def subscribe(self) -> Optional[pulumi.Input['DeviceMessageFiltersSubscribeArgs']]:
        """
        Rules used to restrict topics the device can subscribe to.
        """
        return pulumi.get(self, "subscribe")

    @subscribe.setter
    def subscribe(self, value: Optional[pulumi.Input['DeviceMessageFiltersSubscribeArgs']]):
        pulumi.set(self, "subscribe", value)


if not MYPY:
    class DeviceMessageFiltersPublishArgsDict(TypedDict):
        policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Filtering policy (eg `accept` or `reject`)
        """
        topics: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of topics to match (eg `foo/bar/+/baz/#`)
        """
elif False:
    DeviceMessageFiltersPublishArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceMessageFiltersPublishArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] policy: Filtering policy (eg `accept` or `reject`)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: List of topics to match (eg `foo/bar/+/baz/#`)
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Filtering policy (eg `accept` or `reject`)
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of topics to match (eg `foo/bar/+/baz/#`)
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)


if not MYPY:
    class DeviceMessageFiltersSubscribeArgsDict(TypedDict):
        policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Same as publish rules.
        """
        topics: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Same as publish rules.

        - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.

        > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
elif False:
    DeviceMessageFiltersSubscribeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeviceMessageFiltersSubscribeArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] policy: Same as publish rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: Same as publish rules.
               
               - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.
               
               > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Same as publish rules.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Same as publish rules.

        - `certificate.crt` - (Optional) The certificate of the device, either generated by Scaleway or provided.

        > **Important:** Updates to `certificate.crt` will disconnect connected devices and the previous certificate will be deleted and won't be recoverable.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)


if not MYPY:
    class RouteDatabaseArgsDict(TypedDict):
        dbname: pulumi.Input[builtins.str]
        """
        The database name (e.g. `measurements`).
        """
        host: pulumi.Input[builtins.str]
        """
        The database hostname. Can be an IP or a FQDN.
        """
        password: pulumi.Input[builtins.str]
        """
        The database password.
        """
        port: pulumi.Input[builtins.int]
        """
        The database port (e.g. `5432`)
        """
        query: pulumi.Input[builtins.str]
        """
        The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        """
        username: pulumi.Input[builtins.str]
        """
        The database username.
        """
elif False:
    RouteDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteDatabaseArgs:
    def __init__(__self__, *,
                 dbname: pulumi.Input[builtins.str],
                 host: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 query: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] dbname: The database name (e.g. `measurements`).
        :param pulumi.Input[builtins.str] host: The database hostname. Can be an IP or a FQDN.
        :param pulumi.Input[builtins.str] password: The database password.
        :param pulumi.Input[builtins.int] port: The database port (e.g. `5432`)
        :param pulumi.Input[builtins.str] query: The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        :param pulumi.Input[builtins.str] username: The database username.
        """
        pulumi.set(__self__, "dbname", dbname)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def dbname(self) -> pulumi.Input[builtins.str]:
        """
        The database name (e.g. `measurements`).
        """
        return pulumi.get(self, "dbname")

    @dbname.setter
    def dbname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dbname", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        The database hostname. Can be an IP or a FQDN.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The database password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        The database port (e.g. `5432`)
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[builtins.str]:
        """
        The SQL query that will be executed when receiving a message ($TOPIC and $PAYLOAD variables are available, see documentation, e.g. `INSERT INTO mytable(date, topic, value) VALUES (NOW(), $TOPIC, $PAYLOAD)`).
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        The database username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class RouteRestArgsDict(TypedDict):
        headers: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]
        """
        a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        """
        uri: pulumi.Input[builtins.str]
        """
        The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        """
        verb: pulumi.Input[builtins.str]
        """
        The HTTP Verb used to call Rest URI (e.g. `post`).
        """
elif False:
    RouteRestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteRestArgs:
    def __init__(__self__, *,
                 headers: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 uri: pulumi.Input[builtins.str],
                 verb: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        :param pulumi.Input[builtins.str] uri: The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        :param pulumi.Input[builtins.str] verb: The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "verb", verb)

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        a map of the extra headers to send with the HTTP call (e.g. `X-Header = Value`).
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the Rest endpoint (e.g. `https://internal.mycompany.com/ingest/mqttdata`).
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def verb(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP Verb used to call Rest URI (e.g. `post`).
        """
        return pulumi.get(self, "verb")

    @verb.setter
    def verb(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "verb", value)


if not MYPY:
    class RouteS3ArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        """
        bucket_region: pulumi.Input[builtins.str]
        """
        The region of the S3 route's destination bucket (e.g. `fr-par`).
        """
        strategy: pulumi.Input[builtins.str]
        """
        How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        """
        object_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The string to prefix object names with (e.g. `mykeyprefix-`).
        """
elif False:
    RouteS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteS3Args:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 bucket_region: pulumi.Input[builtins.str],
                 strategy: pulumi.Input[builtins.str],
                 object_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        :param pulumi.Input[builtins.str] bucket_region: The region of the S3 route's destination bucket (e.g. `fr-par`).
        :param pulumi.Input[builtins.str] strategy: How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        :param pulumi.Input[builtins.str] object_prefix: The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "strategy", strategy)
        if object_prefix is not None:
            pulumi.set(__self__, "object_prefix", object_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 route's destination bucket (e.g. `my-object-storage`).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Input[builtins.str]:
        """
        The region of the S3 route's destination bucket (e.g. `fr-par`).
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[builtins.str]:
        """
        How the S3 route's objects will be created (e.g. `per_topic`). See [documentation](https://www.scaleway.com/en/docs/iot-hub/how-to/create-route/) for behaviour details.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="objectPrefix")
    def object_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The string to prefix object names with (e.g. `mykeyprefix-`).
        """
        return pulumi.get(self, "object_prefix")

    @object_prefix.setter
    def object_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_prefix", value)


