# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NatsCredentialsArgs', 'NatsCredentials']

@pulumi.input_type
class NatsCredentialsArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NatsCredentials resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the NATS account the credentials are generated from
        :param pulumi.Input[builtins.str] name: The unique name of the NATS credentials.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which the account exists.
        """
        pulumi.set(__self__, "account_id", account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the NATS account the credentials are generated from
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the NATS credentials.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which the account exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NatsCredentialsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NatsCredentials resources.
        :param pulumi.Input[builtins.str] account_id: The ID of the NATS account the credentials are generated from
        :param pulumi.Input[builtins.str] file: The content of the credentials file.
        :param pulumi.Input[builtins.str] name: The unique name of the NATS credentials.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which the account exists.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the NATS account the credentials are generated from
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content of the credentials file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the NATS credentials.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region
        in which the account exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:mnq/natsCredentials:NatsCredentials")
class NatsCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Messaging and Queuing NATS credentials.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/nats-overview/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.NatsAccount("main", name="nats-account")
        main_nats_credentials = scaleway.mnq.NatsCredentials("main", account_id=main.id)
        ```

        ## Import

        Namespaces can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/natsCredentials:NatsCredentials main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the NATS account the credentials are generated from
        :param pulumi.Input[builtins.str] name: The unique name of the NATS credentials.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which the account exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatsCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Messaging and Queuing NATS credentials.
        For further information, see
        our [main documentation](https://www.scaleway.com/en/docs/messaging/reference-content/nats-overview/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.mnq.NatsAccount("main", name="nats-account")
        main_nats_credentials = scaleway.mnq.NatsCredentials("main", account_id=main.id)
        ```

        ## Import

        Namespaces can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:mnq/natsCredentials:NatsCredentials main fr-par/11111111111111111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param NatsCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatsCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatsCredentialsArgs.__new__(NatsCredentialsArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["file"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/mnqNatsCredentials:MnqNatsCredentials")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["file"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NatsCredentials, __self__).__init__(
            'scaleway:mnq/natsCredentials:NatsCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            file: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'NatsCredentials':
        """
        Get an existing NatsCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the NATS account the credentials are generated from
        :param pulumi.Input[builtins.str] file: The content of the credentials file.
        :param pulumi.Input[builtins.str] name: The unique name of the NATS credentials.
        :param pulumi.Input[builtins.str] region: `region`). The region
               in which the account exists.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatsCredentialsState.__new__(_NatsCredentialsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["file"] = file
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return NatsCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the NATS account the credentials are generated from
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def file(self) -> pulumi.Output[builtins.str]:
        """
        The content of the credentials file.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the NATS credentials.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`). The region
        in which the account exists.
        """
        return pulumi.get(self, "region")

