# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketAclArgs', 'BucketAcl']

@pulumi.input_type
class BucketAclArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 access_control_policy: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a BucketAcl resource.
        :param pulumi.Input[builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input['BucketAclAccessControlPolicyArgs'] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[builtins.str] acl: The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        :param pulumi.Input[builtins.str] expected_bucket_owner: The project ID of the expected bucket owner.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BucketAclState:
    def __init__(__self__, *,
                 access_control_policy: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketAcl resources.
        :param pulumi.Input['BucketAclAccessControlPolicyArgs'] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[builtins.str] acl: The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        :param pulumi.Input[builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[builtins.str] expected_bucket_owner: The project ID of the expected bucket owner.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        if access_control_policy is not None:
            pulumi.set(__self__, "access_control_policy", access_control_policy)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @access_control_policy.setter
    def access_control_policy(self, value: Optional[pulumi.Input['BucketAclAccessControlPolicyArgs']]):
        pulumi.set(self, "access_control_policy", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:object/bucketAcl:BucketAcl")
class BucketAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket", name="unique-name")
        main = scaleway.object.BucketAcl("main",
            bucket=main_scaleway_object_bucket["id"],
            acl="private")
        ```

        For more information, refer to the [PutBucketAcl API call documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/bucket-operations/#putbucketacl).

        ### With Grants

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main", name="your-bucket")
        main_bucket_acl = scaleway.object.BucketAcl("main",
            bucket=main.id,
            access_control_policy={
                "grants": [
                    {
                        "grantee": {
                            "id": "<project-id>:<project-id>",
                            "type": "CanonicalUser",
                        },
                        "permission": "FULL_CONTROL",
                    },
                    {
                        "grantee": {
                            "id": "<project-id>",
                            "type": "CanonicalUser",
                        },
                        "permission": "WRITE",
                    },
                ],
                "owner": {
                    "id": "<project-id>",
                },
            })
        ```

        ## The ACL

        Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.

        ## The access control policy

        The `access_control_policy` configuration block supports the following arguments:

        * `grant` - (Required) Set of grant configuration blocks documented below.
        * `owner` - (Required) Configuration block of the bucket owner's display name and ID documented below.

        ## The grant

        The `grant` configuration block supports the following arguments:

        * `grantee` - (Required) Configuration block for the project being granted permissions documented below.
        * `permission` - (Required) Logging permissions assigned to the grantee for the bucket.

        ## The permission

        The following list shows each access policy permissions supported.

        `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`

        For more information about ACL permissions in the S3 bucket, see [ACL permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html).

        ## The owner

        The `owner` configuration block supports the following arguments:

        * `id` - (Required) The ID of the project owner.
        * `display_name` - (Optional) The display name of the owner.

        ## the grantee

        The `grantee` configuration block supports the following arguments:

        * `id` - (Optional) The canonical user ID of the grantee.
        * `type` - (Required) Type of grantee. Valid values: CanonicalUser, Group.
        * `uri` - (Optional) The uri of the grantee if type is Group.

        ## Import

        Bucket ACLs can be imported using the `{region}/{bucketName}/{acl}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:object/bucketAcl:BucketAcl some_bucket fr-par/some-bucket/private
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:object/bucketAcl:BucketAcl some_bucket fr-par/some-bucket/private@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[builtins.str] acl: The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        :param pulumi.Input[builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[builtins.str] expected_bucket_owner: The project ID of the expected bucket owner.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        some_bucket = scaleway.object.Bucket("some_bucket", name="unique-name")
        main = scaleway.object.BucketAcl("main",
            bucket=main_scaleway_object_bucket["id"],
            acl="private")
        ```

        For more information, refer to the [PutBucketAcl API call documentation](https://www.scaleway.com/en/docs/object-storage/api-cli/bucket-operations/#putbucketacl).

        ### With Grants

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main", name="your-bucket")
        main_bucket_acl = scaleway.object.BucketAcl("main",
            bucket=main.id,
            access_control_policy={
                "grants": [
                    {
                        "grantee": {
                            "id": "<project-id>:<project-id>",
                            "type": "CanonicalUser",
                        },
                        "permission": "FULL_CONTROL",
                    },
                    {
                        "grantee": {
                            "id": "<project-id>",
                            "type": "CanonicalUser",
                        },
                        "permission": "WRITE",
                    },
                ],
                "owner": {
                    "id": "<project-id>",
                },
            })
        ```

        ## The ACL

        Refer to the [official canned ACL documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) for more information on the different roles.

        ## The access control policy

        The `access_control_policy` configuration block supports the following arguments:

        * `grant` - (Required) Set of grant configuration blocks documented below.
        * `owner` - (Required) Configuration block of the bucket owner's display name and ID documented below.

        ## The grant

        The `grant` configuration block supports the following arguments:

        * `grantee` - (Required) Configuration block for the project being granted permissions documented below.
        * `permission` - (Required) Logging permissions assigned to the grantee for the bucket.

        ## The permission

        The following list shows each access policy permissions supported.

        `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`

        For more information about ACL permissions in the S3 bucket, see [ACL permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html).

        ## The owner

        The `owner` configuration block supports the following arguments:

        * `id` - (Required) The ID of the project owner.
        * `display_name` - (Optional) The display name of the owner.

        ## the grantee

        The `grantee` configuration block supports the following arguments:

        * `id` - (Optional) The canonical user ID of the grantee.
        * `type` - (Required) Type of grantee. Valid values: CanonicalUser, Group.
        * `uri` - (Optional) The uri of the grantee if type is Group.

        ## Import

        Bucket ACLs can be imported using the `{region}/{bucketName}/{acl}` identifier, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:object/bucketAcl:BucketAcl some_bucket fr-par/some-bucket/private
        ```

        ~> **Important:** The `project_id` attribute has a particular behavior with s3 products because the s3 API is scoped by project.

        If you are using a project different from the default one, you have to specify the project ID at the end of the import command.

        bash

        ```sh
        $ pulumi import scaleway:object/bucketAcl:BucketAcl some_bucket fr-par/some-bucket/private@xxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param BucketAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
                 acl: Optional[pulumi.Input[builtins.str]] = None,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketAclArgs.__new__(BucketAclArgs)

            __props__.__dict__["access_control_policy"] = access_control_policy
            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/objectBucketAcl:ObjectBucketAcl")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketAcl, __self__).__init__(
            'scaleway:object/bucketAcl:BucketAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_policy: Optional[pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']]] = None,
            acl: Optional[pulumi.Input[builtins.str]] = None,
            bucket: Optional[pulumi.Input[builtins.str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'BucketAcl':
        """
        Get an existing BucketAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAclAccessControlPolicyArgs', 'BucketAclAccessControlPolicyArgsDict']] access_control_policy: A configuration block that sets the ACL permissions for an object per grantee documented below.
        :param pulumi.Input[builtins.str] acl: The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        :param pulumi.Input[builtins.str] bucket: The bucket's name or regional ID.
        :param pulumi.Input[builtins.str] expected_bucket_owner: The project ID of the expected bucket owner.
        :param pulumi.Input[builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[builtins.str] region: The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketAclState.__new__(_BucketAclState)

        __props__.__dict__["access_control_policy"] = access_control_policy
        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return BucketAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessControlPolicy")
    def access_control_policy(self) -> pulumi.Output['outputs.BucketAclAccessControlPolicy']:
        """
        A configuration block that sets the ACL permissions for an object per grantee documented below.
        """
        return pulumi.get(self, "access_control_policy")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The canned ACL you want to apply to the bucket. Refer to the [AWS Canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl_overview.html#canned-acl) documentation page to find a list of all the supported canned ACLs.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[builtins.str]:
        """
        The bucket's name or regional ID.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The project ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The [region](https://www.scaleway.com/en/developers/api/#regions-and-zones) in which the bucket should be created.
        """
        return pulumi.get(self, "region")

