# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CockpitArgs', 'Cockpit']

@pulumi.input_type
class CockpitArgs:
    def __init__(__self__, *,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cockpit resource.
        :param pulumi.Input[builtins.str] plan: Name of the plan to use. Available plans are: free, premium, and custom.
               > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        """
        if plan is not None:
            warnings.warn("""The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""", DeprecationWarning)
            pulumi.log.warn("""plan is deprecated: The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""")
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""")
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the plan to use. Available plans are: free, premium, and custom.
        > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _CockpitState:
    def __init__(__self__, *,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['CockpitEndpointArgs']]]] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 push_urls: Optional[pulumi.Input[Sequence[pulumi.Input['CockpitPushUrlArgs']]]] = None):
        """
        Input properties used for looking up and filtering Cockpit resources.
        :param pulumi.Input[Sequence[pulumi.Input['CockpitEndpointArgs']]] endpoints: (Deprecated) A list of [endpoints](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#endpoints) related to Cockpit, each with specific URLs:
        :param pulumi.Input[builtins.str] plan: Name of the plan to use. Available plans are: free, premium, and custom.
               > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        :param pulumi.Input[builtins.str] plan_id: (Deprecated) The ID of the current pricing plan.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['CockpitPushUrlArgs']]] push_urls: [DEPRECATED] Push_url
        """
        if endpoints is not None:
            warnings.warn("""Use 'scaleway_cockpit_source' instead of 'endpoints'. This field will be removed in future releases.""", DeprecationWarning)
            pulumi.log.warn("""endpoints is deprecated: Use 'scaleway_cockpit_source' instead of 'endpoints'. This field will be removed in future releases.""")
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if plan is not None:
            warnings.warn("""The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""", DeprecationWarning)
            pulumi.log.warn("""plan is deprecated: The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""")
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if plan_id is not None:
            warnings.warn("""The 'plan_id' attribute is deprecated and will be removed in a future release.""", DeprecationWarning)
            pulumi.log.warn("""plan_id is deprecated: The 'plan_id' attribute is deprecated and will be removed in a future release.""")
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if push_urls is not None:
            warnings.warn("""Please use `observability.Source` instead""", DeprecationWarning)
            pulumi.log.warn("""push_urls is deprecated: Please use `observability.Source` instead""")
        if push_urls is not None:
            pulumi.set(__self__, "push_urls", push_urls)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use 'scaleway_cockpit_source' instead of 'endpoints'. This field will be removed in future releases.""")
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CockpitEndpointArgs']]]]:
        """
        (Deprecated) A list of [endpoints](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#endpoints) related to Cockpit, each with specific URLs:
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CockpitEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""")
    def plan(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the plan to use. Available plans are: free, premium, and custom.
        > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="planId")
    @_utilities.deprecated("""The 'plan_id' attribute is deprecated and will be removed in a future release.""")
    def plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Deprecated) The ID of the current pricing plan.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="pushUrls")
    @_utilities.deprecated("""Please use `observability.Source` instead""")
    def push_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CockpitPushUrlArgs']]]]:
        """
        [DEPRECATED] Push_url
        """
        return pulumi.get(self, "push_urls")

    @push_urls.setter
    def push_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CockpitPushUrlArgs']]]]):
        pulumi.set(self, "push_urls", value)


@pulumi.type_token("scaleway:observability/cockpit:Cockpit")
class Cockpit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This section explains how to import a Cockpit using its `{project_id}`.

        bash

        ```sh
        $ pulumi import scaleway:observability/cockpit:Cockpit main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] plan: Name of the plan to use. Available plans are: free, premium, and custom.
               > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CockpitArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This section explains how to import a Cockpit using its `{project_id}`.

        bash

        ```sh
        $ pulumi import scaleway:observability/cockpit:Cockpit main 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param CockpitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CockpitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 plan: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CockpitArgs.__new__(CockpitArgs)

            __props__.__dict__["plan"] = plan
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["plan_id"] = None
            __props__.__dict__["push_urls"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/cockpit:Cockpit")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Cockpit, __self__).__init__(
            'scaleway:observability/cockpit:Cockpit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CockpitEndpointArgs', 'CockpitEndpointArgsDict']]]]] = None,
            plan: Optional[pulumi.Input[builtins.str]] = None,
            plan_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            push_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CockpitPushUrlArgs', 'CockpitPushUrlArgsDict']]]]] = None) -> 'Cockpit':
        """
        Get an existing Cockpit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CockpitEndpointArgs', 'CockpitEndpointArgsDict']]]] endpoints: (Deprecated) A list of [endpoints](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#endpoints) related to Cockpit, each with specific URLs:
        :param pulumi.Input[builtins.str] plan: Name of the plan to use. Available plans are: free, premium, and custom.
               > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        :param pulumi.Input[builtins.str] plan_id: (Deprecated) The ID of the current pricing plan.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CockpitPushUrlArgs', 'CockpitPushUrlArgsDict']]]] push_urls: [DEPRECATED] Push_url
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CockpitState.__new__(_CockpitState)

        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["plan"] = plan
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["push_urls"] = push_urls
        return Cockpit(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Use 'scaleway_cockpit_source' instead of 'endpoints'. This field will be removed in future releases.""")
    def endpoints(self) -> pulumi.Output[Sequence['outputs.CockpitEndpoint']]:
        """
        (Deprecated) A list of [endpoints](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#endpoints) related to Cockpit, each with specific URLs:
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'plan' attribute is deprecated and no longer has any effect. Future updates will remove this attribute entirely.""")
    def plan(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the plan to use. Available plans are: free, premium, and custom.
        > **Important:** The plan field is deprecated. Any modification or selection will have no effect.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="planId")
    @_utilities.deprecated("""The 'plan_id' attribute is deprecated and will be removed in a future release.""")
    def plan_id(self) -> pulumi.Output[builtins.str]:
        """
        (Deprecated) The ID of the current pricing plan.
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pushUrls")
    @_utilities.deprecated("""Please use `observability.Source` instead""")
    def push_urls(self) -> pulumi.Output[Sequence['outputs.CockpitPushUrl']]:
        """
        [DEPRECATED] Push_url
        """
        return pulumi.get(self, "push_urls")

