# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GrafanaUserArgs', 'GrafanaUser']

@pulumi.input_type
class GrafanaUserArgs:
    def __init__(__self__, *,
                 login: pulumi.Input[builtins.str],
                 role: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GrafanaUser resource.
        :param pulumi.Input[builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        """
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "role", role)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def login(self) -> pulumi.Input[builtins.str]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[builtins.str]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _GrafanaUserState:
    def __init__(__self__, *,
                 grafana_url: Optional[pulumi.Input[builtins.str]] = None,
                 login: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GrafanaUser resources.
        :param pulumi.Input[builtins.str] grafana_url: URL for Grafana.
        :param pulumi.Input[builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[builtins.str] password: The password of the Grafana user.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @grafana_url.setter
    def grafana_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grafana_url", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the Grafana user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("scaleway:observability/grafanaUser:GrafanaUser")
class GrafanaUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `observability.GrafanaUser` resource allows you to create and manage [Grafana users](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#grafana-users) in Scaleway Cockpit.

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Create a Grafana user

        The following command allows you to create a Grafana user within a specific Scaleway Project.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="test project grafana user")
        main = scaleway.observability.GrafanaUser("main",
            project_id=project.id,
            login="my-awesome-user",
            role="editor")
        ```

        ## Import

        This section explains how to import Grafana users using the ID of the Project associated with Cockpit, and the Grafana user ID in the `{project_id}/{grafana_user_id}` format.

        bash

        ```sh
        $ pulumi import scaleway:observability/grafanaUser:GrafanaUser main 11111111-1111-1111-1111-111111111111/2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrafanaUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `observability.GrafanaUser` resource allows you to create and manage [Grafana users](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#grafana-users) in Scaleway Cockpit.

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Create a Grafana user

        The following command allows you to create a Grafana user within a specific Scaleway Project.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="test project grafana user")
        main = scaleway.observability.GrafanaUser("main",
            project_id=project.id,
            login="my-awesome-user",
            role="editor")
        ```

        ## Import

        This section explains how to import Grafana users using the ID of the Project associated with Cockpit, and the Grafana user ID in the `{project_id}/{grafana_user_id}` format.

        bash

        ```sh
        $ pulumi import scaleway:observability/grafanaUser:GrafanaUser main 11111111-1111-1111-1111-111111111111/2
        ```

        :param str resource_name: The name of the resource.
        :param GrafanaUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrafanaUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrafanaUserArgs.__new__(GrafanaUserArgs)

            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            __props__.__dict__["project_id"] = project_id
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["grafana_url"] = None
            __props__.__dict__["password"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/cockpitGrafanaUser:CockpitGrafanaUser")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GrafanaUser, __self__).__init__(
            'scaleway:observability/grafanaUser:GrafanaUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grafana_url: Optional[pulumi.Input[builtins.str]] = None,
            login: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None) -> 'GrafanaUser':
        """
        Get an existing GrafanaUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] grafana_url: URL for Grafana.
        :param pulumi.Input[builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[builtins.str] password: The password of the Grafana user.
        :param pulumi.Input[builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrafanaUserState.__new__(_GrafanaUserState)

        __props__.__dict__["grafana_url"] = grafana_url
        __props__.__dict__["login"] = login
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role"] = role
        return GrafanaUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> pulumi.Output[builtins.str]:
        """
        URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[builtins.str]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password of the Grafana user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[builtins.str]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

