# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetImageTagResult',
    'AwaitableGetImageTagResult',
    'get_image_tag',
    'get_image_tag_output',
]

@pulumi.output_type
class GetImageTagResult:
    """
    A collection of values returned by getImageTag.
    """
    def __init__(__self__, created_at=None, digest=None, id=None, image_id=None, name=None, organization_id=None, project_id=None, region=None, status=None, tag_id=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if digest and not isinstance(digest, str):
            raise TypeError("Expected argument 'digest' to be a str")
        pulumi.set(__self__, "digest", digest)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag_id and not isinstance(tag_id, str):
            raise TypeError("Expected argument 'tag_id' to be a str")
        pulumi.set(__self__, "tag_id", tag_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time when the registry image tag was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        Hash of the tag content. Several tags of the same image may have the same digest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        The organization ID the image tag is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the registry image tag.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagId")
    def tag_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tag_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time of the last update to the registry image tag.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetImageTagResult(GetImageTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageTagResult(
            created_at=self.created_at,
            digest=self.digest,
            id=self.id,
            image_id=self.image_id,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            region=self.region,
            status=self.status,
            tag_id=self.tag_id,
            updated_at=self.updated_at)


def get_image_tag(image_id: Optional[builtins.str] = None,
                  name: Optional[builtins.str] = None,
                  project_id: Optional[builtins.str] = None,
                  region: Optional[builtins.str] = None,
                  tag_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageTagResult:
    """
    Gets information about a specific tag of a Container Registry image.


    :param builtins.str image_id: The ID of the registry image.
    :param builtins.str name: The name of the registry image tag.
    :param builtins.str project_id: The ID of the project the image tag is associated with.
    :param builtins.str region: The region in which the registry image tag exists.
    :param builtins.str tag_id: The ID of the registry image tag.
    """
    __args__ = dict()
    __args__['imageId'] = image_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['tagId'] = tag_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:registry/getImageTag:getImageTag', __args__, opts=opts, typ=GetImageTagResult).value

    return AwaitableGetImageTagResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        digest=pulumi.get(__ret__, 'digest'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tag_id=pulumi.get(__ret__, 'tag_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_image_tag_output(image_id: Optional[pulumi.Input[builtins.str]] = None,
                         name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         tag_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageTagResult]:
    """
    Gets information about a specific tag of a Container Registry image.


    :param builtins.str image_id: The ID of the registry image.
    :param builtins.str name: The name of the registry image tag.
    :param builtins.str project_id: The ID of the project the image tag is associated with.
    :param builtins.str region: The region in which the registry image tag exists.
    :param builtins.str tag_id: The ID of the registry image tag.
    """
    __args__ = dict()
    __args__['imageId'] = image_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['tagId'] = tag_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:registry/getImageTag:getImageTag', __args__, opts=opts, typ=GetImageTagResult)
    return __ret__.apply(lambda __response__: GetImageTagResult(
        created_at=pulumi.get(__response__, 'created_at'),
        digest=pulumi.get(__response__, 'digest'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tag_id=pulumi.get(__response__, 'tag_id'),
        updated_at=pulumi.get(__response__, 'updated_at')))
