# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOfferSubscriptionResult',
    'AwaitableGetOfferSubscriptionResult',
    'get_offer_subscription',
    'get_offer_subscription_output',
]

@pulumi.output_type
class GetOfferSubscriptionResult:
    """
    A collection of values returned by getOfferSubscription.
    """
    def __init__(__self__, cancellation_available_at=None, id=None, included_monthly_emails=None, max_custom_blocklists_per_domain=None, max_dedicated_ips=None, max_domains=None, max_webhooks_per_domain=None, offer_name=None, project_id=None, region=None, sla=None, subscribed_at=None):
        if cancellation_available_at and not isinstance(cancellation_available_at, str):
            raise TypeError("Expected argument 'cancellation_available_at' to be a str")
        pulumi.set(__self__, "cancellation_available_at", cancellation_available_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if included_monthly_emails and not isinstance(included_monthly_emails, int):
            raise TypeError("Expected argument 'included_monthly_emails' to be a int")
        pulumi.set(__self__, "included_monthly_emails", included_monthly_emails)
        if max_custom_blocklists_per_domain and not isinstance(max_custom_blocklists_per_domain, int):
            raise TypeError("Expected argument 'max_custom_blocklists_per_domain' to be a int")
        pulumi.set(__self__, "max_custom_blocklists_per_domain", max_custom_blocklists_per_domain)
        if max_dedicated_ips and not isinstance(max_dedicated_ips, int):
            raise TypeError("Expected argument 'max_dedicated_ips' to be a int")
        pulumi.set(__self__, "max_dedicated_ips", max_dedicated_ips)
        if max_domains and not isinstance(max_domains, int):
            raise TypeError("Expected argument 'max_domains' to be a int")
        pulumi.set(__self__, "max_domains", max_domains)
        if max_webhooks_per_domain and not isinstance(max_webhooks_per_domain, int):
            raise TypeError("Expected argument 'max_webhooks_per_domain' to be a int")
        pulumi.set(__self__, "max_webhooks_per_domain", max_webhooks_per_domain)
        if offer_name and not isinstance(offer_name, str):
            raise TypeError("Expected argument 'offer_name' to be a str")
        pulumi.set(__self__, "offer_name", offer_name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sla and not isinstance(sla, float):
            raise TypeError("Expected argument 'sla' to be a float")
        pulumi.set(__self__, "sla", sla)
        if subscribed_at and not isinstance(subscribed_at, str):
            raise TypeError("Expected argument 'subscribed_at' to be a str")
        pulumi.set(__self__, "subscribed_at", subscribed_at)

    @property
    @pulumi.getter(name="cancellationAvailableAt")
    def cancellation_available_at(self) -> builtins.str:
        """
        The date and time when cancellation becomes available for the subscription.
        """
        return pulumi.get(self, "cancellation_available_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includedMonthlyEmails")
    def included_monthly_emails(self) -> builtins.int:
        """
        The number of emails included in the offer subscription per month.
        """
        return pulumi.get(self, "included_monthly_emails")

    @property
    @pulumi.getter(name="maxCustomBlocklistsPerDomain")
    def max_custom_blocklists_per_domain(self) -> builtins.int:
        """
        The maximum number of custom blocklists that can be associated with the offer subscription per domain.
        """
        return pulumi.get(self, "max_custom_blocklists_per_domain")

    @property
    @pulumi.getter(name="maxDedicatedIps")
    def max_dedicated_ips(self) -> builtins.int:
        """
        The maximum number of dedicated IPs that can be associated with the offer subscription.
        """
        return pulumi.get(self, "max_dedicated_ips")

    @property
    @pulumi.getter(name="maxDomains")
    def max_domains(self) -> builtins.int:
        """
        The maximum number of domains that can be associated with the offer subscription.
        """
        return pulumi.get(self, "max_domains")

    @property
    @pulumi.getter(name="maxWebhooksPerDomain")
    def max_webhooks_per_domain(self) -> builtins.int:
        """
        The maximum number of webhooks that can be associated with the offer subscription per domain.
        """
        return pulumi.get(self, "max_webhooks_per_domain")

    @property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> builtins.str:
        """
        The name of the offer associated with the subscription (e.g., `scale`).
        """
        return pulumi.get(self, "offer_name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def sla(self) -> builtins.float:
        """
        The Service Level Agreement (SLA) percentage of the offer subscription.
        """
        return pulumi.get(self, "sla")

    @property
    @pulumi.getter(name="subscribedAt")
    def subscribed_at(self) -> builtins.str:
        """
        The date and time of the subscription.
        """
        return pulumi.get(self, "subscribed_at")


class AwaitableGetOfferSubscriptionResult(GetOfferSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOfferSubscriptionResult(
            cancellation_available_at=self.cancellation_available_at,
            id=self.id,
            included_monthly_emails=self.included_monthly_emails,
            max_custom_blocklists_per_domain=self.max_custom_blocklists_per_domain,
            max_dedicated_ips=self.max_dedicated_ips,
            max_domains=self.max_domains,
            max_webhooks_per_domain=self.max_webhooks_per_domain,
            offer_name=self.offer_name,
            project_id=self.project_id,
            region=self.region,
            sla=self.sla,
            subscribed_at=self.subscribed_at)


def get_offer_subscription(project_id: Optional[builtins.str] = None,
                           region: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOfferSubscriptionResult:
    """
    Gets information about a transactional email offer subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Retrieve offer subscription information
    test = scaleway.tem.get_offer_subscription()
    ```


    :param builtins.str project_id: `project_id`) The ID of the project the offer subscription is associated with.
    :param builtins.str region: `region`) The region where the offer subscription exists.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:tem/getOfferSubscription:getOfferSubscription', __args__, opts=opts, typ=GetOfferSubscriptionResult).value

    return AwaitableGetOfferSubscriptionResult(
        cancellation_available_at=pulumi.get(__ret__, 'cancellation_available_at'),
        id=pulumi.get(__ret__, 'id'),
        included_monthly_emails=pulumi.get(__ret__, 'included_monthly_emails'),
        max_custom_blocklists_per_domain=pulumi.get(__ret__, 'max_custom_blocklists_per_domain'),
        max_dedicated_ips=pulumi.get(__ret__, 'max_dedicated_ips'),
        max_domains=pulumi.get(__ret__, 'max_domains'),
        max_webhooks_per_domain=pulumi.get(__ret__, 'max_webhooks_per_domain'),
        offer_name=pulumi.get(__ret__, 'offer_name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        sla=pulumi.get(__ret__, 'sla'),
        subscribed_at=pulumi.get(__ret__, 'subscribed_at'))
def get_offer_subscription_output(project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOfferSubscriptionResult]:
    """
    Gets information about a transactional email offer subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Retrieve offer subscription information
    test = scaleway.tem.get_offer_subscription()
    ```


    :param builtins.str project_id: `project_id`) The ID of the project the offer subscription is associated with.
    :param builtins.str region: `region`) The region where the offer subscription exists.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:tem/getOfferSubscription:getOfferSubscription', __args__, opts=opts, typ=GetOfferSubscriptionResult)
    return __ret__.apply(lambda __response__: GetOfferSubscriptionResult(
        cancellation_available_at=pulumi.get(__response__, 'cancellation_available_at'),
        id=pulumi.get(__response__, 'id'),
        included_monthly_emails=pulumi.get(__response__, 'included_monthly_emails'),
        max_custom_blocklists_per_domain=pulumi.get(__response__, 'max_custom_blocklists_per_domain'),
        max_dedicated_ips=pulumi.get(__response__, 'max_dedicated_ips'),
        max_domains=pulumi.get(__response__, 'max_domains'),
        max_webhooks_per_domain=pulumi.get(__response__, 'max_webhooks_per_domain'),
        offer_name=pulumi.get(__response__, 'offer_name'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        sla=pulumi.get(__response__, 'sla'),
        subscribed_at=pulumi.get(__response__, 'subscribed_at')))
