# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WebhookArgs', 'Webhook']

@pulumi.input_type
class WebhookArgs:
    def __init__(__self__, *,
                 domain_id: pulumi.Input[builtins.str],
                 event_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 sns_arn: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Webhook resource.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain the webhook is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: A list of event types that trigger the webhook.
        :param pulumi.Input[builtins.str] sns_arn: The Amazon Resource Name (ARN) of the SNS topic.
        :param pulumi.Input[builtins.str] name: The name of the webhook. Defaults to an autogenerated name if not provided.
        :param pulumi.Input[builtins.str] project_id: The ID of the project the webhook is associated with.
        :param pulumi.Input[builtins.str] region: . The region in which the webhook should be created.
        """
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "event_types", event_types)
        pulumi.set(__self__, "sns_arn", sns_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the domain the webhook is associated with.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of event types that trigger the webhook.
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "event_types", value)

    @property
    @pulumi.getter(name="snsArn")
    def sns_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SNS topic.
        """
        return pulumi.get(self, "sns_arn")

    @sns_arn.setter
    def sns_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sns_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the webhook. Defaults to an autogenerated name if not provided.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project the webhook is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        . The region in which the webhook should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _WebhookState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_arn: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Webhook resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the webhook's creation (RFC 3339 format).
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain the webhook is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: A list of event types that trigger the webhook.
        :param pulumi.Input[builtins.str] name: The name of the webhook. Defaults to an autogenerated name if not provided.
        :param pulumi.Input[builtins.str] organization_id: The ID of the organization the webhook belongs to.
        :param pulumi.Input[builtins.str] project_id: The ID of the project the webhook is associated with.
        :param pulumi.Input[builtins.str] region: . The region in which the webhook should be created.
        :param pulumi.Input[builtins.str] sns_arn: The Amazon Resource Name (ARN) of the SNS topic.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the webhook's last update (RFC 3339 format).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sns_arn is not None:
            pulumi.set(__self__, "sns_arn", sns_arn)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the webhook's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the domain the webhook is associated with.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of event types that trigger the webhook.
        """
        return pulumi.get(self, "event_types")

    @event_types.setter
    def event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "event_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the webhook. Defaults to an autogenerated name if not provided.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the organization the webhook belongs to.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project the webhook is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        . The region in which the webhook should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="snsArn")
    def sns_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the SNS topic.
        """
        return pulumi.get(self, "sns_arn")

    @sns_arn.setter
    def sns_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sns_arn", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the webhook's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:tem/webhook:Webhook")
class Webhook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Transactional Email Webhooks.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/transactional-email).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.tem.Webhook("main",
            domain_id="your-domain-id",
            event_types=[
                "email_delivered",
                "email_bounced",
            ],
            sns_arn="arn:scw:sns:fr-par:project-xxxx:your-sns-topic",
            name="example-webhook")
        ```

        ### Complete Example with Dependencies

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        domain_name = config.require("domainName")
        sns = scaleway.mnq.Sns("sns")
        sns_credentials = scaleway.mnq.SnsCredentials("sns_credentials", permissions={
            "can_manage": True,
        })
        sns_topic = scaleway.mnq.SnsTopic("sns_topic",
            name="test-mnq-sns-topic-basic",
            access_key=sns_credentials.access_key,
            secret_key=sns_credentials.secret_key)
        cr01 = scaleway.tem.Domain("cr01",
            name=domain_name,
            accept_tos=True)
        spf = scaleway.domain.Record("spf",
            dns_zone=domain_name,
            type="TXT",
            data=cr01.spf_config.apply(lambda spf_config: f"v=spf1 {spf_config} -all"))
        dkim = scaleway.domain.Record("dkim",
            dns_zone=domain_name,
            name=cr01.project_id.apply(lambda project_id: f"{project_id}._domainkey"),
            type="TXT",
            data=cr01.dkim_config)
        mx = scaleway.domain.Record("mx",
            dns_zone=domain_name,
            type="MX",
            data=".")
        dmarc = scaleway.domain.Record("dmarc",
            dns_zone=domain_name,
            name=cr01.dmarc_name,
            type="TXT",
            data=cr01.dmarc_config)
        valid = scaleway.tem.DomainValidation("valid",
            domain_id=cr01.id,
            region=cr01.region,
            timeout=3600)
        webhook = scaleway.tem.Webhook("webhook",
            name="example-webhook",
            domain_id=cr01.id,
            event_types=[
                "email_delivered",
                "email_bounced",
            ],
            sns_arn=sns_topic.arn,
            opts = pulumi.ResourceOptions(depends_on=[
                    valid,
                    sns_topic,
                ]))
        ```

        ## Import

        Webhooks can be imported using the {region}/{id}, e.g.

        bash

        ```sh
        $ pulumi import scaleway:tem/webhook:Webhook main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain the webhook is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: A list of event types that trigger the webhook.
        :param pulumi.Input[builtins.str] name: The name of the webhook. Defaults to an autogenerated name if not provided.
        :param pulumi.Input[builtins.str] project_id: The ID of the project the webhook is associated with.
        :param pulumi.Input[builtins.str] region: . The region in which the webhook should be created.
        :param pulumi.Input[builtins.str] sns_arn: The Amazon Resource Name (ARN) of the SNS topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Transactional Email Webhooks.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/transactional-email).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.tem.Webhook("main",
            domain_id="your-domain-id",
            event_types=[
                "email_delivered",
                "email_bounced",
            ],
            sns_arn="arn:scw:sns:fr-par:project-xxxx:your-sns-topic",
            name="example-webhook")
        ```

        ### Complete Example with Dependencies

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        domain_name = config.require("domainName")
        sns = scaleway.mnq.Sns("sns")
        sns_credentials = scaleway.mnq.SnsCredentials("sns_credentials", permissions={
            "can_manage": True,
        })
        sns_topic = scaleway.mnq.SnsTopic("sns_topic",
            name="test-mnq-sns-topic-basic",
            access_key=sns_credentials.access_key,
            secret_key=sns_credentials.secret_key)
        cr01 = scaleway.tem.Domain("cr01",
            name=domain_name,
            accept_tos=True)
        spf = scaleway.domain.Record("spf",
            dns_zone=domain_name,
            type="TXT",
            data=cr01.spf_config.apply(lambda spf_config: f"v=spf1 {spf_config} -all"))
        dkim = scaleway.domain.Record("dkim",
            dns_zone=domain_name,
            name=cr01.project_id.apply(lambda project_id: f"{project_id}._domainkey"),
            type="TXT",
            data=cr01.dkim_config)
        mx = scaleway.domain.Record("mx",
            dns_zone=domain_name,
            type="MX",
            data=".")
        dmarc = scaleway.domain.Record("dmarc",
            dns_zone=domain_name,
            name=cr01.dmarc_name,
            type="TXT",
            data=cr01.dmarc_config)
        valid = scaleway.tem.DomainValidation("valid",
            domain_id=cr01.id,
            region=cr01.region,
            timeout=3600)
        webhook = scaleway.tem.Webhook("webhook",
            name="example-webhook",
            domain_id=cr01.id,
            event_types=[
                "email_delivered",
                "email_bounced",
            ],
            sns_arn=sns_topic.arn,
            opts = pulumi.ResourceOptions(depends_on=[
                    valid,
                    sns_topic,
                ]))
        ```

        ## Import

        Webhooks can be imported using the {region}/{id}, e.g.

        bash

        ```sh
        $ pulumi import scaleway:tem/webhook:Webhook main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param WebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sns_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebhookArgs.__new__(WebhookArgs)

            if domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'domain_id'")
            __props__.__dict__["domain_id"] = domain_id
            if event_types is None and not opts.urn:
                raise TypeError("Missing required property 'event_types'")
            __props__.__dict__["event_types"] = event_types
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if sns_arn is None and not opts.urn:
                raise TypeError("Missing required property 'sns_arn'")
            __props__.__dict__["sns_arn"] = sns_arn
            __props__.__dict__["created_at"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/temWebhook:TemWebhook")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Webhook, __self__).__init__(
            'scaleway:tem/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            event_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            sns_arn: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the webhook's creation (RFC 3339 format).
        :param pulumi.Input[builtins.str] domain_id: The ID of the domain the webhook is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] event_types: A list of event types that trigger the webhook.
        :param pulumi.Input[builtins.str] name: The name of the webhook. Defaults to an autogenerated name if not provided.
        :param pulumi.Input[builtins.str] organization_id: The ID of the organization the webhook belongs to.
        :param pulumi.Input[builtins.str] project_id: The ID of the project the webhook is associated with.
        :param pulumi.Input[builtins.str] region: . The region in which the webhook should be created.
        :param pulumi.Input[builtins.str] sns_arn: The Amazon Resource Name (ARN) of the SNS topic.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the webhook's last update (RFC 3339 format).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebhookState.__new__(_WebhookState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["event_types"] = event_types
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["sns_arn"] = sns_arn
        __props__.__dict__["updated_at"] = updated_at
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the webhook's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the domain the webhook is associated with.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of event types that trigger the webhook.
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the webhook. Defaults to an autogenerated name if not provided.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the organization the webhook belongs to.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project the webhook is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        . The region in which the webhook should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="snsArn")
    def sns_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the SNS topic.
        """
        return pulumi.get(self, "sns_arn")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the webhook's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

