"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Persona = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class Persona extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.activities.length === 0) {
            throw TypeError('The array activities must be of type Activity[] with at least one element.');
        }
        this.activities = props.activities;
        const activityNames = this.activities.map((activity) => { return activity.activityName; });
        if (activityNames.length !== new Set(activityNames).size) {
            throw TypeError('The array activities must be of type Activity[] and must not contain duplicate activities.');
        }
        this.customizeVPC(props.subnets, props.securityGroups);
        this.customizeKMS(props.dataKeys, props.volumeKeys);
    }
    /**
       * Creates role with permissions of persona
       * @param scope the Construct scope.
       * @param id the resource id.
       * @param roleNameSuffix the name suffix of the role that will be created, if empty the role will have the name of the activity.
       * @param roleDescription the description of the role that will be created.
       * @returns - The role that is created with the permissions of the persona
       */
    createRole(scope, id, roleNameSuffix, roleDescription = '') {
        if (!roleNameSuffix || !roleNameSuffix.length) {
            throw TypeError('The role name should be a non empty string');
        }
        const policies = [];
        for (const activity of this.activities) {
            policies.push(activity.createPolicy(scope));
        }
        const role = new iam.Role(scope, id, {
            roleName: `SageMaker-${roleNameSuffix}`,
            description: roleDescription,
            assumedBy: this.activities[0].createPrincipal(),
        });
        for (const policy of policies) {
            role.attachInlinePolicy(policy);
        }
        return role;
    }
    customizeVPC(subnets, securityGroups) {
        if (!subnets && !securityGroups) {
            return;
        }
        if (!subnets || !subnets.length) {
            throw TypeError('The array subnets must be of type ec2.ISubnet[] with at least one element.');
        }
        if (!securityGroups || !securityGroups.length) {
            throw TypeError('The array securityGroups must be of type ec2.ISecurityGroup[] with at least one element.');
        }
        for (const activity of this.activities) {
            activity.customizeVPC(subnets, securityGroups);
        }
    }
    customizeKMS(dataKeys, volumeKeys) {
        if (!dataKeys && !volumeKeys) {
            return;
        }
        if (!dataKeys || !dataKeys.length) {
            throw TypeError('The array dataKeys must be of type kms.IKey[] with at least one element.');
        }
        if (!volumeKeys || !volumeKeys.length) {
            throw TypeError('The array volumeKeys must be of type kms.IKey[] with at least one element.');
        }
        for (const activity of this.activities) {
            activity.customizeKMS(dataKeys, volumeKeys);
        }
    }
    /**
       * Grant permissions of activity to identity
       * @param identity identity to be granted permissions
       * @returns - The grant with the permissions granted to the identity
       */
    grantPermissionsTo(identity) {
        let grant = this.activities[0].grantPermissionsTo(identity);
        for (let i = 1; i < this.activities.length; i++) {
            grant = grant.combine(this.activities[i].grantPermissionsTo(identity));
        }
        return grant;
    }
}
exports.Persona = Persona;
_a = JSII_RTTI_SYMBOL_1;
Persona[_a] = { fqn: "@cdklabs/cdk-aws-sagemaker-role-manager.Persona", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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